/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SupportingDocumentTypeList
 *
 * @param version - Version of the resource
 */
declare function SupportingDocumentTypeList(version: V1): SupportingDocumentTypeListInstance;

interface SupportingDocumentTypeListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SupportingDocumentTypeContext;
  /**
   * Streams SupportingDocumentTypeInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SupportingDocumentTypeInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SupportingDocumentTypeInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SupportingDocumentTypeListInstanceEachOptions, callback?: (item: SupportingDocumentTypeInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a supporting_document_type
   *
   * @param sid - The unique string that identifies the Supporting Document Type resource
   */
  get(sid: string): SupportingDocumentTypeContext;
  /**
   * Retrieve a single target page of SupportingDocumentTypeInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SupportingDocumentTypePage) => any): Promise<SupportingDocumentTypePage>;
  /**
   * Retrieve a single target page of SupportingDocumentTypeInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SupportingDocumentTypePage) => any): Promise<SupportingDocumentTypePage>;
  /**
   * Lists SupportingDocumentTypeInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SupportingDocumentTypeInstance[]) => any): Promise<SupportingDocumentTypeInstance[]>;
  /**
   * Lists SupportingDocumentTypeInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SupportingDocumentTypeListInstanceOptions, callback?: (error: Error | null, items: SupportingDocumentTypeInstance[]) => any): Promise<SupportingDocumentTypeInstance[]>;
  /**
   * Retrieve a single page of SupportingDocumentTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SupportingDocumentTypePage) => any): Promise<SupportingDocumentTypePage>;
  /**
   * Retrieve a single page of SupportingDocumentTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SupportingDocumentTypeListInstancePageOptions, callback?: (error: Error | null, items: SupportingDocumentTypePage) => any): Promise<SupportingDocumentTypePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface SupportingDocumentTypeListInstanceEachOptions {
  callback?: (item: SupportingDocumentTypeInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface SupportingDocumentTypeListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface SupportingDocumentTypeListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface SupportingDocumentTypePayload extends SupportingDocumentTypeResource, Page.TwilioResponsePayload {
}

interface SupportingDocumentTypeResource {
  fields: object[];
  friendly_name: string;
  machine_name: string;
  sid: string;
  url: string;
}

interface SupportingDocumentTypeSolution {
}


declare class SupportingDocumentTypeContext {
  /**
   * Initialize the SupportingDocumentTypeContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the Supporting Document Type resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a SupportingDocumentTypeInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SupportingDocumentTypeInstance) => any): Promise<SupportingDocumentTypeInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SupportingDocumentTypeInstance extends SerializableClass {
  /**
   * Initialize the SupportingDocumentTypeContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the Supporting Document Type resource
   */
  constructor(version: V1, payload: SupportingDocumentTypePayload, sid: string);

  private _proxy: SupportingDocumentTypeContext;
  /**
   * fetch a SupportingDocumentTypeInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SupportingDocumentTypeInstance) => any): Promise<SupportingDocumentTypeInstance>;
  fields: object[];
  friendlyName: string;
  machineName: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class SupportingDocumentTypePage extends Page<V1, SupportingDocumentTypePayload, SupportingDocumentTypeResource, SupportingDocumentTypeInstance> {
  /**
   * Initialize the SupportingDocumentTypePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SupportingDocumentTypeSolution);

  /**
   * Build an instance of SupportingDocumentTypeInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SupportingDocumentTypePayload): SupportingDocumentTypeInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SupportingDocumentTypeContext, SupportingDocumentTypeInstance, SupportingDocumentTypeList, SupportingDocumentTypeListInstance, SupportingDocumentTypeListInstanceEachOptions, SupportingDocumentTypeListInstanceOptions, SupportingDocumentTypeListInstancePageOptions, SupportingDocumentTypePage, SupportingDocumentTypePayload, SupportingDocumentTypeResource, SupportingDocumentTypeSolution }
