/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

type InteractionChannelInviteAction = 'accept'|'decline';

type InteractionChannelInviteType = 'taskrouter';

/**
 * Initialize the InteractionChannelInviteList
 *
 * @param version - Version of the resource
 * @param interactionSid - The interaction_sid
 * @param channelSid - The channel_sid
 */
declare function InteractionChannelInviteList(version: V1, interactionSid: string, channelSid: string): InteractionChannelInviteListInstance;

interface InteractionChannelInviteListInstance {
  /**
   * create a InteractionChannelInviteInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: InteractionChannelInviteListInstanceCreateOptions, callback?: (error: Error | null, item: InteractionChannelInviteInstance) => any): Promise<InteractionChannelInviteInstance>;
  /**
   * Streams InteractionChannelInviteInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: InteractionChannelInviteInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams InteractionChannelInviteInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: InteractionChannelInviteListInstanceEachOptions, callback?: (item: InteractionChannelInviteInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of InteractionChannelInviteInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: InteractionChannelInvitePage) => any): Promise<InteractionChannelInvitePage>;
  /**
   * Retrieve a single target page of InteractionChannelInviteInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: InteractionChannelInvitePage) => any): Promise<InteractionChannelInvitePage>;
  /**
   * Lists InteractionChannelInviteInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: InteractionChannelInviteInstance[]) => any): Promise<InteractionChannelInviteInstance[]>;
  /**
   * Lists InteractionChannelInviteInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: InteractionChannelInviteListInstanceOptions, callback?: (error: Error | null, items: InteractionChannelInviteInstance[]) => any): Promise<InteractionChannelInviteInstance[]>;
  /**
   * Retrieve a single page of InteractionChannelInviteInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: InteractionChannelInvitePage) => any): Promise<InteractionChannelInvitePage>;
  /**
   * Retrieve a single page of InteractionChannelInviteInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: InteractionChannelInviteListInstancePageOptions, callback?: (error: Error | null, items: InteractionChannelInvitePage) => any): Promise<InteractionChannelInvitePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property routing - The routing
 */
interface InteractionChannelInviteListInstanceCreateOptions {
  routing: object;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface InteractionChannelInviteListInstanceEachOptions {
  callback?: (item: InteractionChannelInviteInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface InteractionChannelInviteListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface InteractionChannelInviteListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface InteractionChannelInvitePayload extends InteractionChannelInviteResource, Page.TwilioResponsePayload {
}

interface InteractionChannelInviteResource {
  channel_sid: string;
  interaction_sid: string;
  routing: object;
  sid: string;
  url: string;
}

interface InteractionChannelInviteSolution {
  channelSid?: string;
  interactionSid?: string;
}


declare class InteractionChannelInviteInstance extends SerializableClass {
  /**
   * Initialize the InteractionChannelInviteContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param interactionSid - The interaction_sid
   * @param channelSid - The channel_sid
   */
  constructor(version: V1, payload: InteractionChannelInvitePayload, interactionSid: string, channelSid: string);

  channelSid: string;
  interactionSid: string;
  routing: any;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class InteractionChannelInvitePage extends Page<V1, InteractionChannelInvitePayload, InteractionChannelInviteResource, InteractionChannelInviteInstance> {
  /**
   * Initialize the InteractionChannelInvitePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: InteractionChannelInviteSolution);

  /**
   * Build an instance of InteractionChannelInviteInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: InteractionChannelInvitePayload): InteractionChannelInviteInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { InteractionChannelInviteAction, InteractionChannelInviteInstance, InteractionChannelInviteList, InteractionChannelInviteListInstance, InteractionChannelInviteListInstanceCreateOptions, InteractionChannelInviteListInstanceEachOptions, InteractionChannelInviteListInstanceOptions, InteractionChannelInviteListInstancePageOptions, InteractionChannelInvitePage, InteractionChannelInvitePayload, InteractionChannelInviteResource, InteractionChannelInviteSolution, InteractionChannelInviteType }
