'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var WebChannelList;
var WebChannelPage;
var WebChannelInstance;
var WebChannelContext;

/* jshint ignore:start */
/**
 * Initialize the WebChannelList
 *
 * @constructor Twilio.FlexApi.V1.WebChannelList
 *
 * @param {Twilio.FlexApi.V1} version - Version of the resource
 */
/* jshint ignore:end */
WebChannelList = function WebChannelList(version) {
  /* jshint ignore:start */
  /**
   * @function webChannel
   * @memberof Twilio.FlexApi.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.FlexApi.V1.WebChannelContext}
   */
  /* jshint ignore:end */
  function WebChannelListInstance(sid) {
    return WebChannelListInstance.get(sid);
  }

  WebChannelListInstance._version = version;
  // Path Solution
  WebChannelListInstance._solution = {};
  WebChannelListInstance._uri = `/WebChannels`;
  /* jshint ignore:start */
  /**
   * Streams WebChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  WebChannelListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists WebChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebChannelListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebChannelListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebChannelPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WebChannelListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebChannelPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a WebChannelInstance
   *
   * @function create
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.flexFlowSid - The SID of the Flex Flow
   * @param {string} opts.identity - The chat identity
   * @param {string} opts.customerFriendlyName - The chat participant's friendly name
   * @param {string} opts.chatFriendlyName - The chat channel's friendly name
   * @param {string} [opts.chatUniqueName] - The chat channel's unique name
   * @param {string} [opts.preEngagementData] - The pre-engagement data
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed WebChannelInstance
   */
  /* jshint ignore:end */
  WebChannelListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['flexFlowSid'])) {
      throw new Error('Required parameter "opts[\'flexFlowSid\']" missing.');
    }
    if (_.isUndefined(opts['identity'])) {
      throw new Error('Required parameter "opts[\'identity\']" missing.');
    }
    if (_.isUndefined(opts['customerFriendlyName'])) {
      throw new Error('Required parameter "opts[\'customerFriendlyName\']" missing.');
    }
    if (_.isUndefined(opts['chatFriendlyName'])) {
      throw new Error('Required parameter "opts[\'chatFriendlyName\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FlexFlowSid': _.get(opts, 'flexFlowSid'),
      'Identity': _.get(opts, 'identity'),
      'CustomerFriendlyName': _.get(opts, 'customerFriendlyName'),
      'ChatFriendlyName': _.get(opts, 'chatFriendlyName'),
      'ChatUniqueName': _.get(opts, 'chatUniqueName'),
      'PreEngagementData': _.get(opts, 'preEngagementData')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WebChannelInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a web_channel
   *
   * @function get
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @param {string} sid - The SID of the WebChannel resource to fetch
   *
   * @returns {Twilio.FlexApi.V1.WebChannelContext}
   */
  /* jshint ignore:end */
  WebChannelListInstance.get = function get(sid) {
    return new WebChannelContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.FlexApi.V1.WebChannelList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WebChannelListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WebChannelListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return WebChannelListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WebChannelPage
 *
 * @constructor Twilio.FlexApi.V1.WebChannelPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WebChannelSolution} solution - Path solution
 *
 * @returns WebChannelPage
 */
/* jshint ignore:end */
WebChannelPage = function WebChannelPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WebChannelPage.prototype, Page.prototype);
WebChannelPage.prototype.constructor = WebChannelPage;

/* jshint ignore:start */
/**
 * Build an instance of WebChannelInstance
 *
 * @function getInstance
 * @memberof Twilio.FlexApi.V1.WebChannelPage#
 *
 * @param {WebChannelPayload} payload - Payload response from the API
 *
 * @returns WebChannelInstance
 */
/* jshint ignore:end */
WebChannelPage.prototype.getInstance = function getInstance(payload) {
  return new WebChannelInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.WebChannelPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebChannelPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WebChannelPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WebChannelContext
 *
 * @constructor Twilio.FlexApi.V1.WebChannelInstance
 *
 * @property {string} accountSid -
 *          The SID of the Account that created the resource and owns this Workflow
 * @property {string} flexFlowSid - The SID of the Flex Flow
 * @property {string} sid -
 *          The unique string that identifies the WebChannel resource
 * @property {string} url - The absolute URL of the WebChannel resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 *
 * @param {V1} version - Version of the resource
 * @param {WebChannelPayload} payload - The instance payload
 * @param {sid} sid - The SID of the WebChannel resource to fetch
 */
/* jshint ignore:end */
WebChannelInstance = function WebChannelInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.flexFlowSid = payload.flex_flow_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(WebChannelInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WebChannelContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WebChannelInstance
 *
 * @function fetch
 * @memberof Twilio.FlexApi.V1.WebChannelInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a WebChannelInstance
 *
 * @function update
 * @memberof Twilio.FlexApi.V1.WebChannelInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {web_channel.chat_status} [opts.chatStatus] - The chat status
 * @param {string} [opts.postEngagementData] - The post-engagement data
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a WebChannelInstance
 *
 * @function remove
 * @memberof Twilio.FlexApi.V1.WebChannelInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.WebChannelInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebChannelInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WebChannelInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WebChannelContext
 *
 * @constructor Twilio.FlexApi.V1.WebChannelContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID of the WebChannel resource to fetch
 */
/* jshint ignore:end */
WebChannelContext = function WebChannelContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/WebChannels/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a WebChannelInstance
 *
 * @function fetch
 * @memberof Twilio.FlexApi.V1.WebChannelContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new WebChannelInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a WebChannelInstance
 *
 * @function update
 * @memberof Twilio.FlexApi.V1.WebChannelContext#
 *
 * @param {object} [opts] - Options for request
 * @param {web_channel.chat_status} [opts.chatStatus] - The chat status
 * @param {string} [opts.postEngagementData] - The post-engagement data
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'ChatStatus': _.get(opts, 'chatStatus'),
    'PostEngagementData': _.get(opts, 'postEngagementData')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WebChannelInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a WebChannelInstance
 *
 * @function remove
 * @memberof Twilio.FlexApi.V1.WebChannelContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WebChannelInstance
 */
/* jshint ignore:end */
WebChannelContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.FlexApi.V1.WebChannelContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WebChannelContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WebChannelContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WebChannelList: WebChannelList,
  WebChannelPage: WebChannelPage,
  WebChannelInstance: WebChannelInstance,
  WebChannelContext: WebChannelContext
};
