'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var NetworkAccessProfileNetworkList;
var NetworkAccessProfileNetworkPage;
var NetworkAccessProfileNetworkInstance;
var NetworkAccessProfileNetworkContext;

/* jshint ignore:start */
/**
 * Initialize the NetworkAccessProfileNetworkList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList
 *
 * @param {Twilio.Supersim.V1} version - Version of the resource
 * @param {string} networkAccessProfileSid -
 *          The unique string that identifies the Network Access Profile resource
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkList = function
    NetworkAccessProfileNetworkList(version, networkAccessProfileSid) {
  /* jshint ignore:start */
  /**
   * @function networks
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext}
   */
  /* jshint ignore:end */
  function NetworkAccessProfileNetworkListInstance(sid) {
    return NetworkAccessProfileNetworkListInstance.get(sid);
  }

  NetworkAccessProfileNetworkListInstance._version = version;
  // Path Solution
  NetworkAccessProfileNetworkListInstance._solution = {
    networkAccessProfileSid: networkAccessProfileSid
  };
  NetworkAccessProfileNetworkListInstance._uri = `/NetworkAccessProfiles/${networkAccessProfileSid}/Networks`;
  /* jshint ignore:start */
  /**
   * Streams NetworkAccessProfileNetworkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists NetworkAccessProfileNetworkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of NetworkAccessProfileNetworkInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new NetworkAccessProfileNetworkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of NetworkAccessProfileNetworkInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new NetworkAccessProfileNetworkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a NetworkAccessProfileNetworkInstance
   *
   * @function create
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.network - The SID that identifies the Network resource
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed NetworkAccessProfileNetworkInstance
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.create = function create(opts, callback)
      {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['network'])) {
      throw new Error('Required parameter "opts[\'network\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({'Network': _.get(opts, 'network')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new NetworkAccessProfileNetworkInstance(
        this._version,
        payload,
        this._solution.networkAccessProfileSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a network_access_profile_network
   *
   * @function get
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @param {string} sid - The SID of the resource to fetch
   *
   * @returns {Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext}
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.get = function get(sid) {
    return new NetworkAccessProfileNetworkContext(
      this._version,
      this._solution.networkAccessProfileSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  NetworkAccessProfileNetworkListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  NetworkAccessProfileNetworkListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return NetworkAccessProfileNetworkListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the NetworkAccessProfileNetworkPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {NetworkAccessProfileNetworkSolution} solution - Path solution
 *
 * @returns NetworkAccessProfileNetworkPage
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkPage = function
    NetworkAccessProfileNetworkPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(NetworkAccessProfileNetworkPage.prototype, Page.prototype);
NetworkAccessProfileNetworkPage.prototype.constructor = NetworkAccessProfileNetworkPage;

/* jshint ignore:start */
/**
 * Build an instance of NetworkAccessProfileNetworkInstance
 *
 * @function getInstance
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkPage#
 *
 * @param {NetworkAccessProfileNetworkPayload} payload -
 *          Payload response from the API
 *
 * @returns NetworkAccessProfileNetworkInstance
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkPage.prototype.getInstance = function
    getInstance(payload) {
  return new NetworkAccessProfileNetworkInstance(
    this._version,
    payload,
    this._solution.networkAccessProfileSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NetworkAccessProfileNetworkPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NetworkAccessProfileNetworkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} networkAccessProfileSid -
 *          The unique string that identifies the Network Access Profile resource
 * @property {string} friendlyName - A human readable identifier of this resource
 * @property {string} isoCountry - The ISO country code of the Network resource
 * @property {object} identifiers - The MCC/MNCs included in the resource
 * @property {string} url - The absolute URL of the resource
 *
 * @param {V1} version - Version of the resource
 * @param {NetworkAccessProfileNetworkPayload} payload - The instance payload
 * @param {sid} networkAccessProfileSid -
 *          The unique string that identifies the Network Access Profile resource
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkInstance = function
    NetworkAccessProfileNetworkInstance(version, payload,
    networkAccessProfileSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.networkAccessProfileSid = payload.network_access_profile_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.isoCountry = payload.iso_country; // jshint ignore:line
  this.identifiers = payload.identifiers; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {networkAccessProfileSid: networkAccessProfileSid, sid: sid || this.sid, };
};

Object.defineProperty(NetworkAccessProfileNetworkInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new NetworkAccessProfileNetworkContext(
          this._version,
          this._solution.networkAccessProfileSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * remove a NetworkAccessProfileNetworkInstance
 *
 * @function remove
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkAccessProfileNetworkInstance
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkInstance.prototype.remove = function remove(callback)
    {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a NetworkAccessProfileNetworkInstance
 *
 * @function fetch
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkAccessProfileNetworkInstance
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NetworkAccessProfileNetworkInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NetworkAccessProfileNetworkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} networkAccessProfileSid -
 *          The unique string that identifies the Network Access Profile resource
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkContext = function
    NetworkAccessProfileNetworkContext(version, networkAccessProfileSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {networkAccessProfileSid: networkAccessProfileSid, sid: sid, };
  this._uri = `/NetworkAccessProfiles/${networkAccessProfileSid}/Networks/${sid}`;
};

/* jshint ignore:start */
/**
 * remove a NetworkAccessProfileNetworkInstance
 *
 * @function remove
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkAccessProfileNetworkInstance
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkContext.prototype.remove = function remove(callback)
    {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a NetworkAccessProfileNetworkInstance
 *
 * @function fetch
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkAccessProfileNetworkInstance
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new NetworkAccessProfileNetworkInstance(
      this._version,
      payload,
      this._solution.networkAccessProfileSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkAccessProfileContext.NetworkAccessProfileNetworkContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkAccessProfileNetworkContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

NetworkAccessProfileNetworkContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  NetworkAccessProfileNetworkList: NetworkAccessProfileNetworkList,
  NetworkAccessProfileNetworkPage: NetworkAccessProfileNetworkPage,
  NetworkAccessProfileNetworkInstance: NetworkAccessProfileNetworkInstance,
  NetworkAccessProfileNetworkContext: NetworkAccessProfileNetworkContext
};
