/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Domain = require('../base/Domain');
import Twilio = require('./Twilio');
import V1 = require('./conversations/V1');
import { AddressConfigurationListInstance } from './conversations/v1/addressConfiguration';
import { ConfigurationListInstance } from './conversations/v1/configuration';
import { ConversationListInstance } from './conversations/v1/conversation';
import { CredentialListInstance } from './conversations/v1/credential';
import { ParticipantConversationListInstance } from './conversations/v1/participantConversation';
import { RoleListInstance } from './conversations/v1/role';
import { ServiceListInstance } from './conversations/v1/service';
import { UserListInstance } from './conversations/v1/user';


declare class Conversations extends Domain {
  /**
   * Initialize conversations domain
   *
   * @param twilio - The twilio client
   */
  constructor(twilio: Twilio);

  readonly addressConfigurations: AddressConfigurationListInstance;
  readonly configuration: ConfigurationListInstance;
  readonly conversations: ConversationListInstance;
  readonly credentials: CredentialListInstance;
  readonly participantConversations: ParticipantConversationListInstance;
  readonly roles: RoleListInstance;
  readonly services: ServiceListInstance;
  readonly users: UserListInstance;
  readonly v1: V1;
}

export = Conversations;
