'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var UserConversationList;
var UserConversationPage;
var UserConversationInstance;
var UserConversationContext;

/* jshint ignore:start */
/**
 * Initialize the UserConversationList
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList
 *
 * @param {Twilio.Conversations.V1} version - Version of the resource
 * @param {string} chatServiceSid -
 *          The unique ID of the Conversation Service this conversation belongs to.
 * @param {string} userSid - The unique ID for the User.
 */
/* jshint ignore:end */
UserConversationList = function UserConversationList(version, chatServiceSid,
                                                      userSid) {
  /* jshint ignore:start */
  /**
   * @function userConversations
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext}
   */
  /* jshint ignore:end */
  function UserConversationListInstance(sid) {
    return UserConversationListInstance.get(sid);
  }

  UserConversationListInstance._version = version;
  // Path Solution
  UserConversationListInstance._solution = {chatServiceSid: chatServiceSid, userSid: userSid};
  UserConversationListInstance._uri = `/Services/${chatServiceSid}/Users/${userSid}/Conversations`;
  /* jshint ignore:start */
  /**
   * Streams UserConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  UserConversationListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists UserConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserConversationListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserConversationListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new UserConversationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UserConversationListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new UserConversationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a user_conversation
   *
   * @function get
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @param {string} conversationSid - The unique SID identifier of the Conversation.
   *
   * @returns {Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext}
   */
  /* jshint ignore:end */
  UserConversationListInstance.get = function get(conversationSid) {
    return new UserConversationContext(
      this._version,
      this._solution.chatServiceSid,
      this._solution.userSid,
      conversationSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UserConversationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UserConversationListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return UserConversationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UserConversationPage
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UserConversationSolution} solution - Path solution
 *
 * @returns UserConversationPage
 */
/* jshint ignore:end */
UserConversationPage = function UserConversationPage(version, response,
                                                      solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UserConversationPage.prototype, Page.prototype);
UserConversationPage.prototype.constructor = UserConversationPage;

/* jshint ignore:start */
/**
 * Build an instance of UserConversationInstance
 *
 * @function getInstance
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationPage#
 *
 * @param {UserConversationPayload} payload - Payload response from the API
 *
 * @returns UserConversationInstance
 */
/* jshint ignore:end */
UserConversationPage.prototype.getInstance = function getInstance(payload) {
  return new UserConversationInstance(
    this._version,
    payload,
    this._solution.chatServiceSid,
    this._solution.userSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserConversationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserConversationPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserConversationContext
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationInstance
 *
 * @property {string} accountSid -
 *          The unique ID of the Account responsible for this conversation.
 * @property {string} chatServiceSid -
 *          The unique ID of the Conversation Service this conversation belongs to.
 * @property {string} conversationSid -
 *          The unique ID of the Conversation for this User Conversation.
 * @property {number} unreadMessagesCount -
 *          The number of unread Messages in the Conversation.
 * @property {number} lastReadMessageIndex - The index of the last read Message .
 * @property {string} participantSid - Participant Sid.
 * @property {string} userSid - The unique ID for the User.
 * @property {string} friendlyName - The human-readable name of this conversation.
 * @property {user_conversation.state} conversationState -
 *          The current state of this User Conversation
 * @property {object} timers - Timer date values for this conversation.
 * @property {string} attributes -
 *          An optional string metadata field you can use to store any data you wish.
 * @property {Date} dateCreated - The date that this conversation was created.
 * @property {Date} dateUpdated - The date that this conversation was last updated.
 * @property {string} createdBy - Creator of this conversation.
 * @property {user_conversation.notification_level} notificationLevel -
 *          The Notification Level of this User Conversation.
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the Conversation resource.
 * @property {string} url - The url
 * @property {string} links -
 *          Absolute URLs to access the participant and conversation of this user conversation.
 *
 * @param {V1} version - Version of the resource
 * @param {UserConversationPayload} payload - The instance payload
 * @param {sid} chatServiceSid -
 *          The unique ID of the Conversation Service this conversation belongs to.
 * @param {sid} userSid - The unique ID for the User.
 * @param {sid_like} conversationSid -
 *          The unique SID identifier of the Conversation.
 */
/* jshint ignore:end */
UserConversationInstance = function UserConversationInstance(version, payload,
    chatServiceSid, userSid, conversationSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.chatServiceSid = payload.chat_service_sid; // jshint ignore:line
  this.conversationSid = payload.conversation_sid; // jshint ignore:line
  this.unreadMessagesCount = deserialize.integer(payload.unread_messages_count); // jshint ignore:line
  this.lastReadMessageIndex = deserialize.integer(payload.last_read_message_index); // jshint ignore:line
  this.participantSid = payload.participant_sid; // jshint ignore:line
  this.userSid = payload.user_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.conversationState = payload.conversation_state; // jshint ignore:line
  this.timers = payload.timers; // jshint ignore:line
  this.attributes = payload.attributes; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.createdBy = payload.created_by; // jshint ignore:line
  this.notificationLevel = payload.notification_level; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {
    chatServiceSid: chatServiceSid,
    userSid: userSid,
    conversationSid: conversationSid || this.conversationSid,
  };
};

Object.defineProperty(UserConversationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new UserConversationContext(
          this._version,
          this._solution.chatServiceSid,
          this._solution.userSid,
          this._solution.conversationSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a UserConversationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {user_conversation.notification_level} [opts.notificationLevel] -
 *          The Notification Level of this User Conversation.
 * @param {Date} [opts.lastReadTimestamp] -
 *          The date of the last message read in conversation by the user.
 * @param {number} [opts.lastReadMessageIndex] -
 *          The index of the last read Message.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a UserConversationInstance
 *
 * @function remove
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a UserConversationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserConversationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UserConversationInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UserConversationContext
 *
 * @constructor Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} chatServiceSid -
 *          The SID of the Conversation Service that the resource is associated with.
 * @param {sid_like} userSid - The unique SID identifier of the User.
 * @param {sid_like} conversationSid -
 *          The unique SID identifier of the Conversation.
 */
/* jshint ignore:end */
UserConversationContext = function UserConversationContext(version,
                                                            chatServiceSid,
                                                            userSid,
                                                            conversationSid) {
  this._version = version;

  // Path Solution
  this._solution = {
    chatServiceSid: chatServiceSid,
    userSid: userSid,
    conversationSid: conversationSid,
  };
  this._uri = `/Services/${chatServiceSid}/Users/${userSid}/Conversations/${conversationSid}`;
};

/* jshint ignore:start */
/**
 * update a UserConversationInstance
 *
 * @function update
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext#
 *
 * @param {object} [opts] - Options for request
 * @param {user_conversation.notification_level} [opts.notificationLevel] -
 *          The Notification Level of this User Conversation.
 * @param {Date} [opts.lastReadTimestamp] -
 *          The date of the last message read in conversation by the user.
 * @param {number} [opts.lastReadMessageIndex] -
 *          The index of the last read Message.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'NotificationLevel': _.get(opts, 'notificationLevel'),
    'LastReadTimestamp': serialize.iso8601DateTime(_.get(opts, 'lastReadTimestamp')),
    'LastReadMessageIndex': _.get(opts, 'lastReadMessageIndex')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new UserConversationInstance(
      this._version,
      payload,
      this._solution.chatServiceSid,
      this._solution.userSid,
      this._solution.conversationSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a UserConversationInstance
 *
 * @function remove
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a UserConversationInstance
 *
 * @function fetch
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UserConversationInstance
 */
/* jshint ignore:end */
UserConversationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new UserConversationInstance(
      this._version,
      payload,
      this._solution.chatServiceSid,
      this._solution.userSid,
      this._solution.conversationSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ServiceContext.UserContext.UserConversationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
UserConversationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

UserConversationContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UserConversationList: UserConversationList,
  UserConversationPage: UserConversationPage,
  UserConversationInstance: UserConversationInstance,
  UserConversationContext: UserConversationContext
};
