'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var ActivityList = require('./workspace/activity').ActivityList;
var EventList = require('./workspace/event').EventList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var TaskChannelList = require('./workspace/taskChannel').TaskChannelList;
var TaskList = require('./workspace/task').TaskList;
var TaskQueueList = require('./workspace/taskQueue').TaskQueueList;
var WorkerList = require('./workspace/worker').WorkerList;
var WorkflowList = require('./workspace/workflow').WorkflowList;
var WorkspaceCumulativeStatisticsList = require(
    './workspace/workspaceCumulativeStatistics').WorkspaceCumulativeStatisticsList;
var WorkspaceRealTimeStatisticsList = require(
    './workspace/workspaceRealTimeStatistics').WorkspaceRealTimeStatisticsList;
var WorkspaceStatisticsList = require(
    './workspace/workspaceStatistics').WorkspaceStatisticsList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var WorkspaceList;
var WorkspacePage;
var WorkspaceInstance;
var WorkspaceContext;

/* jshint ignore:start */
/**
 * Initialize the WorkspaceList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 */
/* jshint ignore:end */
WorkspaceList = function WorkspaceList(version) {
  /* jshint ignore:start */
  /**
   * @function workspaces
   * @memberof Twilio.Taskrouter.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext}
   */
  /* jshint ignore:end */
  function WorkspaceListInstance(sid) {
    return WorkspaceListInstance.get(sid);
  }

  WorkspaceListInstance._version = version;
  // Path Solution
  WorkspaceListInstance._solution = {};
  WorkspaceListInstance._uri = `/Workspaces`;
  /* jshint ignore:start */
  /**
   * Streams WorkspaceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The friendly_name of the Workspace resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  WorkspaceListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists WorkspaceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The friendly_name of the Workspace resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WorkspaceListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of WorkspaceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The friendly_name of the Workspace resources to read
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WorkspaceListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WorkspacePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of WorkspaceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  WorkspaceListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new WorkspacePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a WorkspaceInstance
   *
   * @function create
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName - A string to describe the Workspace resource
   * @param {string} [opts.eventCallbackUrl] -
   *          The URL we should call when an event occurs
   * @param {string} [opts.eventsFilter] -
   *          The list of Workspace events for which to call event_callback_url
   * @param {boolean} [opts.multiTaskEnabled] - Whether multi-tasking is enabled
   * @param {string} [opts.template] - An available template name
   * @param {workspace.queue_order} [opts.prioritizeQueueOrder] -
   *          The type of TaskQueue to prioritize when Workers are receiving Tasks from both types of TaskQueues
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed WorkspaceInstance
   */
  /* jshint ignore:end */
  WorkspaceListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['friendlyName'])) {
      throw new Error('Required parameter "opts[\'friendlyName\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'EventCallbackUrl': _.get(opts, 'eventCallbackUrl'),
      'EventsFilter': _.get(opts, 'eventsFilter'),
      'MultiTaskEnabled': serialize.bool(_.get(opts, 'multiTaskEnabled')),
      'Template': _.get(opts, 'template'),
      'PrioritizeQueueOrder': _.get(opts, 'prioritizeQueueOrder')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new WorkspaceInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a workspace
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @param {string} sid - The SID of the resource to fetch
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext}
   */
  /* jshint ignore:end */
  WorkspaceListInstance.get = function get(sid) {
    return new WorkspaceContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WorkspaceListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WorkspaceListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return WorkspaceListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WorkspacePage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspacePage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WorkspaceSolution} solution - Path solution
 *
 * @returns WorkspacePage
 */
/* jshint ignore:end */
WorkspacePage = function WorkspacePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WorkspacePage.prototype, Page.prototype);
WorkspacePage.prototype.constructor = WorkspacePage;

/* jshint ignore:start */
/**
 * Build an instance of WorkspaceInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspacePage#
 *
 * @param {WorkspacePayload} payload - Payload response from the API
 *
 * @returns WorkspaceInstance
 */
/* jshint ignore:end */
WorkspacePage.prototype.getInstance = function getInstance(payload) {
  return new WorkspaceInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspacePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspacePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkspacePage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkspaceContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} defaultActivityName - The name of the default activity
 * @property {string} defaultActivitySid -
 *          The SID of the Activity that will be used when new Workers are created in the Workspace
 * @property {string} eventCallbackUrl - The URL we call when an event occurs
 * @property {string} eventsFilter -
 *          The list of Workspace events for which to call event_callback_url
 * @property {string} friendlyName -
 *          The string that you assigned to describe the Workspace resource
 * @property {boolean} multiTaskEnabled - Whether multi-tasking is enabled
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} timeoutActivityName - The name of the timeout activity
 * @property {string} timeoutActivitySid -
 *          The SID of the Activity that will be assigned to a Worker when a Task reservation times out without a response
 * @property {workspace.queue_order} prioritizeQueueOrder -
 *          The type of TaskQueue to prioritize when Workers are receiving Tasks from both types of TaskQueues
 * @property {string} url - The absolute URL of the Workspace resource
 * @property {string} links - The URLs of related resources
 *
 * @param {V1} version - Version of the resource
 * @param {WorkspacePayload} payload - The instance payload
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
WorkspaceInstance = function WorkspaceInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.defaultActivityName = payload.default_activity_name; // jshint ignore:line
  this.defaultActivitySid = payload.default_activity_sid; // jshint ignore:line
  this.eventCallbackUrl = payload.event_callback_url; // jshint ignore:line
  this.eventsFilter = payload.events_filter; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.multiTaskEnabled = payload.multi_task_enabled; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.timeoutActivityName = payload.timeout_activity_name; // jshint ignore:line
  this.timeoutActivitySid = payload.timeout_activity_sid; // jshint ignore:line
  this.prioritizeQueueOrder = payload.prioritize_queue_order; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(WorkspaceInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WorkspaceContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WorkspaceInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a WorkspaceInstance
 *
 * @function update
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.defaultActivitySid] -
 *          The SID of the Activity that will be used when new Workers are created in the Workspace
 * @param {string} [opts.eventCallbackUrl] -
 *          The URL we should call when an event occurs
 * @param {string} [opts.eventsFilter] -
 *          The list of Workspace events for which to call event_callback_url
 * @param {string} [opts.friendlyName] -
 *          A string to describe the Workspace resource
 * @param {boolean} [opts.multiTaskEnabled] - Whether multi-tasking is enabled
 * @param {string} [opts.timeoutActivitySid] -
 *          The SID of the Activity that will be assigned to a Worker when a Task reservation times out without a response
 * @param {workspace.queue_order} [opts.prioritizeQueueOrder] -
 *          The type of TaskQueue to prioritize when Workers are receiving Tasks from both types of TaskQueues
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a WorkspaceInstance
 *
 * @function remove
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the activities
 *
 * @function activities
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.ActivityList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.activities = function activities() {
  return this._proxy.activities;
};

/* jshint ignore:start */
/**
 * Access the events
 *
 * @function events
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.EventList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.events = function events() {
  return this._proxy.events;
};

/* jshint ignore:start */
/**
 * Access the tasks
 *
 * @function tasks
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.tasks = function tasks() {
  return this._proxy.tasks;
};

/* jshint ignore:start */
/**
 * Access the taskQueues
 *
 * @function taskQueues
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.taskQueues = function taskQueues() {
  return this._proxy.taskQueues;
};

/* jshint ignore:start */
/**
 * Access the workers
 *
 * @function workers
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkerList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.workers = function workers() {
  return this._proxy.workers;
};

/* jshint ignore:start */
/**
 * Access the workflows
 *
 * @function workflows
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.workflows = function workflows() {
  return this._proxy.workflows;
};

/* jshint ignore:start */
/**
 * Access the statistics
 *
 * @function statistics
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.statistics = function statistics() {
  return this._proxy.statistics;
};

/* jshint ignore:start */
/**
 * Access the realTimeStatistics
 *
 * @function realTimeStatistics
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceRealTimeStatisticsList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.realTimeStatistics = function realTimeStatistics() {
  return this._proxy.realTimeStatistics;
};

/* jshint ignore:start */
/**
 * Access the cumulativeStatistics
 *
 * @function cumulativeStatistics
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceCumulativeStatisticsList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.cumulativeStatistics = function
    cumulativeStatistics() {
  return this._proxy.cumulativeStatistics;
};

/* jshint ignore:start */
/**
 * Access the taskChannels
 *
 * @function taskChannels
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskChannelList}
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.taskChannels = function taskChannels() {
  return this._proxy.taskChannels;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspaceInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkspaceInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkspaceContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext
 *
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.ActivityList} activities -
 *          activities resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.EventList} events -
 *          events resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.TaskList} tasks -
 *          tasks resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueList} taskQueues -
 *          taskQueues resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.WorkerList} workers -
 *          workers resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowList} workflows -
 *          workflows resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsList} statistics -
 *          statistics resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceRealTimeStatisticsList} realTimeStatistics -
 *          realTimeStatistics resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceCumulativeStatisticsList} cumulativeStatistics -
 *          cumulativeStatistics resource
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.TaskChannelList} taskChannels -
 *          taskChannels resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
WorkspaceContext = function WorkspaceContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Workspaces/${sid}`;

  // Dependents
  this._activities = undefined;
  this._events = undefined;
  this._tasks = undefined;
  this._taskQueues = undefined;
  this._workers = undefined;
  this._workflows = undefined;
  this._statistics = undefined;
  this._realTimeStatistics = undefined;
  this._cumulativeStatistics = undefined;
  this._taskChannels = undefined;
};

/* jshint ignore:start */
/**
 * fetch a WorkspaceInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkspaceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a WorkspaceInstance
 *
 * @function update
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.defaultActivitySid] -
 *          The SID of the Activity that will be used when new Workers are created in the Workspace
 * @param {string} [opts.eventCallbackUrl] -
 *          The URL we should call when an event occurs
 * @param {string} [opts.eventsFilter] -
 *          The list of Workspace events for which to call event_callback_url
 * @param {string} [opts.friendlyName] -
 *          A string to describe the Workspace resource
 * @param {boolean} [opts.multiTaskEnabled] - Whether multi-tasking is enabled
 * @param {string} [opts.timeoutActivitySid] -
 *          The SID of the Activity that will be assigned to a Worker when a Task reservation times out without a response
 * @param {workspace.queue_order} [opts.prioritizeQueueOrder] -
 *          The type of TaskQueue to prioritize when Workers are receiving Tasks from both types of TaskQueues
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'DefaultActivitySid': _.get(opts, 'defaultActivitySid'),
    'EventCallbackUrl': _.get(opts, 'eventCallbackUrl'),
    'EventsFilter': _.get(opts, 'eventsFilter'),
    'FriendlyName': _.get(opts, 'friendlyName'),
    'MultiTaskEnabled': serialize.bool(_.get(opts, 'multiTaskEnabled')),
    'TimeoutActivitySid': _.get(opts, 'timeoutActivitySid'),
    'PrioritizeQueueOrder': _.get(opts, 'prioritizeQueueOrder')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkspaceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a WorkspaceInstance
 *
 * @function remove
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceInstance
 */
/* jshint ignore:end */
WorkspaceContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(WorkspaceContext.prototype,
  'activities', {
    get: function() {
      if (!this._activities) {
        this._activities = new ActivityList(this._version, this._solution.sid);
      }
      return this._activities;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'events', {
    get: function() {
      if (!this._events) {
        this._events = new EventList(this._version, this._solution.sid);
      }
      return this._events;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'tasks', {
    get: function() {
      if (!this._tasks) {
        this._tasks = new TaskList(this._version, this._solution.sid);
      }
      return this._tasks;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'taskQueues', {
    get: function() {
      if (!this._taskQueues) {
        this._taskQueues = new TaskQueueList(this._version, this._solution.sid);
      }
      return this._taskQueues;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'workers', {
    get: function() {
      if (!this._workers) {
        this._workers = new WorkerList(this._version, this._solution.sid);
      }
      return this._workers;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'workflows', {
    get: function() {
      if (!this._workflows) {
        this._workflows = new WorkflowList(this._version, this._solution.sid);
      }
      return this._workflows;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'statistics', {
    get: function() {
      if (!this._statistics) {
        this._statistics = new WorkspaceStatisticsList(this._version, this._solution.sid);
      }
      return this._statistics;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'realTimeStatistics', {
    get: function() {
      if (!this._realTimeStatistics) {
        this._realTimeStatistics = new WorkspaceRealTimeStatisticsList(this._version, this._solution.sid);
      }
      return this._realTimeStatistics;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'cumulativeStatistics', {
    get: function() {
      if (!this._cumulativeStatistics) {
        this._cumulativeStatistics = new WorkspaceCumulativeStatisticsList(
          this._version,
          this._solution.sid
        );
      }
      return this._cumulativeStatistics;
    }
});

Object.defineProperty(WorkspaceContext.prototype,
  'taskChannels', {
    get: function() {
      if (!this._taskChannels) {
        this._taskChannels = new TaskChannelList(this._version, this._solution.sid);
      }
      return this._taskChannels;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspaceContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WorkspaceContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WorkspaceList: WorkspaceList,
  WorkspacePage: WorkspacePage,
  WorkspaceInstance: WorkspaceInstance,
  WorkspaceContext: WorkspaceContext
};
