/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type ParticipantWebhookEnabledType = 'true'|'false';

/**
 * Initialize the ParticipantList
 *
 * @param version - Version of the resource
 * @param conversationSid - The unique ID of the Conversation for this participant.
 */
declare function ParticipantList(version: V1, conversationSid: string): ParticipantListInstance;

/**
 * Options to pass to remove
 *
 * @property xTwilioWebhookEnabled - The X-Twilio-Webhook-Enabled HTTP request header
 */
interface ParticipantInstanceRemoveOptions {
  xTwilioWebhookEnabled?: ParticipantWebhookEnabledType;
}

/**
 * Options to pass to update
 *
 * @property attributes - An optional string metadata field you can use to store any data you wish.
 * @property dateCreated - The date that this resource was created.
 * @property dateUpdated - The date that this resource was last updated.
 * @property identity - A unique string identifier for the conversation participant as Conversation User.
 * @property lastReadMessageIndex - Index of last “read” message in the Conversation for the Participant.
 * @property lastReadTimestamp - Timestamp of last “read” message in the Conversation for the Participant.
 * @property messagingBinding.projectedAddress - The address of the Twilio phone number that is used in Group MMS.
 * @property messagingBinding.proxyAddress - The address of the Twilio phone number that the participant is in contact with.
 * @property roleSid - The SID of a conversation-level Role to assign to the participant
 * @property xTwilioWebhookEnabled - The X-Twilio-Webhook-Enabled HTTP request header
 */
interface ParticipantInstanceUpdateOptions {
  attributes?: string;
  dateCreated?: Date;
  dateUpdated?: Date;
  identity?: string;
  lastReadMessageIndex?: number;
  lastReadTimestamp?: string;
  messagingBinding?: {
    proxyAddress?: string;
    projectedAddress?: string;
  };
  roleSid?: string;
  xTwilioWebhookEnabled?: ParticipantWebhookEnabledType;
}

interface ParticipantListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ParticipantContext;
  /**
   * create a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * create a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ParticipantListInstanceCreateOptions, callback?: (error: Error | null, item: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * Streams ParticipantInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ParticipantInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ParticipantListInstanceEachOptions, callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a participant
   *
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  get(sid: string): ParticipantContext;
  /**
   * Retrieve a single target page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Retrieve a single target page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Lists ParticipantInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ParticipantInstance[]) => any): Promise<ParticipantInstance[]>;
  /**
   * Lists ParticipantInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ParticipantListInstanceOptions, callback?: (error: Error | null, items: ParticipantInstance[]) => any): Promise<ParticipantInstance[]>;
  /**
   * Retrieve a single page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Retrieve a single page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ParticipantListInstancePageOptions, callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property attributes - An optional string metadata field you can use to store any data you wish.
 * @property dateCreated - The date that this resource was created.
 * @property dateUpdated - The date that this resource was last updated.
 * @property identity - A unique string identifier for the conversation participant as Conversation User.
 * @property messagingBinding.address - The address of the participant's device.
 * @property messagingBinding.projectedAddress - The address of the Twilio phone number that is used in Group MMS.
 * @property messagingBinding.proxyAddress - The address of the Twilio phone number that the participant is in contact with.
 * @property roleSid - The SID of a conversation-level Role to assign to the participant
 * @property xTwilioWebhookEnabled - The X-Twilio-Webhook-Enabled HTTP request header
 */
interface ParticipantListInstanceCreateOptions {
  attributes?: string;
  dateCreated?: Date;
  dateUpdated?: Date;
  identity?: string;
  messagingBinding?: {
    address?: string;
    proxyAddress?: string;
    projectedAddress?: string;
  };
  roleSid?: string;
  xTwilioWebhookEnabled?: ParticipantWebhookEnabledType;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ParticipantListInstanceEachOptions {
  callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ParticipantListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ParticipantListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ParticipantPayload extends ParticipantResource, Page.TwilioResponsePayload {
}

interface ParticipantResource {
  account_sid: string;
  attributes: string;
  conversation_sid: string;
  date_created: Date;
  date_updated: Date;
  identity: string;
  last_read_message_index: number;
  last_read_timestamp: string;
  messaging_binding: object;
  role_sid: string;
  sid: string;
  url: string;
}

interface ParticipantSolution {
  conversationSid?: string;
}


declare class ParticipantContext {
  /**
   * Initialize the ParticipantContext
   *
   * @param version - Version of the resource
   * @param conversationSid - The unique ID of the Conversation for this participant.
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  constructor(version: V1, conversationSid: string, sid: string);

  /**
   * fetch a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * remove a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<boolean>;
  /**
   * remove a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  remove(opts?: ParticipantInstanceRemoveOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * update a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ParticipantInstanceUpdateOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
}


declare class ParticipantInstance extends SerializableClass {
  /**
   * Initialize the ParticipantContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param conversationSid - The unique ID of the Conversation for this participant.
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  constructor(version: V1, payload: ParticipantPayload, conversationSid: string, sid: string);

  private _proxy: ParticipantContext;
  accountSid: string;
  attributes: string;
  conversationSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  identity: string;
  lastReadMessageIndex: number;
  lastReadTimestamp: string;
  messagingBinding: any;
  /**
   * remove a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<boolean>;
  /**
   * remove a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  remove(opts?: ParticipantInstanceRemoveOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<boolean>;
  roleSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * update a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ParticipantInstanceUpdateOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  url: string;
}


declare class ParticipantPage extends Page<V1, ParticipantPayload, ParticipantResource, ParticipantInstance> {
  /**
   * Initialize the ParticipantPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ParticipantSolution);

  /**
   * Build an instance of ParticipantInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ParticipantPayload): ParticipantInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ParticipantContext, ParticipantInstance, ParticipantInstanceRemoveOptions, ParticipantInstanceUpdateOptions, ParticipantList, ParticipantListInstance, ParticipantListInstanceCreateOptions, ParticipantListInstanceEachOptions, ParticipantListInstanceOptions, ParticipantListInstancePageOptions, ParticipantPage, ParticipantPayload, ParticipantResource, ParticipantSolution, ParticipantWebhookEnabledType }
