'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var VerificationAttemptsSummaryList;
var VerificationAttemptsSummaryPage;
var VerificationAttemptsSummaryInstance;
var VerificationAttemptsSummaryContext;

/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptsSummaryList
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptsSummaryList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 */
/* jshint ignore:end */
VerificationAttemptsSummaryList = function
    VerificationAttemptsSummaryList(version) {
  /* jshint ignore:start */
  /**
   * @function verificationAttemptsSummary
   * @memberof Twilio.Verify.V2#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.VerificationAttemptsSummaryContext}
   */
  /* jshint ignore:end */
  function VerificationAttemptsSummaryListInstance(sid) {
    return VerificationAttemptsSummaryListInstance.get(sid);
  }

  VerificationAttemptsSummaryListInstance._version = version;
  // Path Solution
  VerificationAttemptsSummaryListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a verification_attempts_summary
   *
   * @function get
   * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryList#
   *
   * @returns {Twilio.Verify.V2.VerificationAttemptsSummaryContext}
   */
  /* jshint ignore:end */
  VerificationAttemptsSummaryListInstance.get = function get() {
    return new VerificationAttemptsSummaryContext(this._version);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  VerificationAttemptsSummaryListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  VerificationAttemptsSummaryListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return VerificationAttemptsSummaryListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptsSummaryPage
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptsSummaryPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {VerificationAttemptsSummarySolution} solution - Path solution
 *
 * @returns VerificationAttemptsSummaryPage
 */
/* jshint ignore:end */
VerificationAttemptsSummaryPage = function
    VerificationAttemptsSummaryPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(VerificationAttemptsSummaryPage.prototype, Page.prototype);
VerificationAttemptsSummaryPage.prototype.constructor = VerificationAttemptsSummaryPage;

/* jshint ignore:start */
/**
 * Build an instance of VerificationAttemptsSummaryInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryPage#
 *
 * @param {VerificationAttemptsSummaryPayload} payload -
 *          Payload response from the API
 *
 * @returns VerificationAttemptsSummaryInstance
 */
/* jshint ignore:end */
VerificationAttemptsSummaryPage.prototype.getInstance = function
    getInstance(payload) {
  return new VerificationAttemptsSummaryInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptsSummaryPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationAttemptsSummaryPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptsSummaryContext
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptsSummaryInstance
 *
 * @property {number} totalAttempts - Total of attempts made.
 * @property {number} totalConverted - Total of attempts confirmed by the end user.
 * @property {number} totalUnconverted -
 *          Total of attempts made that were not confirmed by the end user.
 * @property {number} conversionRatePercentage -
 *          Percentage of the confirmed messages over the total.
 * @property {string} url - The url
 *
 * @param {V2} version - Version of the resource
 * @param {VerificationAttemptsSummaryPayload} payload - The instance payload
 */
/* jshint ignore:end */
VerificationAttemptsSummaryInstance = function
    VerificationAttemptsSummaryInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.totalAttempts = deserialize.integer(payload.total_attempts); // jshint ignore:line
  this.totalConverted = deserialize.integer(payload.total_converted); // jshint ignore:line
  this.totalUnconverted = deserialize.integer(payload.total_unconverted); // jshint ignore:line
  this.conversionRatePercentage = deserialize.decimal(payload.conversion_rate_percentage); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

Object.defineProperty(VerificationAttemptsSummaryInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new VerificationAttemptsSummaryContext(this._version);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a VerificationAttemptsSummaryInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.verifyServiceSid] -
 *          Filter the verification attempts considered on the summary by verify service.
 * @param {Date} [opts.dateCreatedAfter] -
 *          Consider verification attempts create after this date on the summary.
 * @param {Date} [opts.dateCreatedBefore] -
 *          Consider verification attempts created before this date on the summary.
 * @param {string} [opts.country] -
 *          Filter verification attempts considered on the summary by destination country.
 * @param {verification_attempts_summary.channels} [opts.channel] -
 *          Filter verification attempts considered on the summary by communication channel.
 * @param {string} [opts.destinationPrefix] -
 *          Filters the attempts considered on the summary by destination prefix.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationAttemptsSummaryInstance
 */
/* jshint ignore:end */
VerificationAttemptsSummaryInstance.prototype.fetch = function fetch(opts,
    callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptsSummaryInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationAttemptsSummaryInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptsSummaryContext
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptsSummaryContext
 *
 * @param {V2} version - Version of the resource
 */
/* jshint ignore:end */
VerificationAttemptsSummaryContext = function
    VerificationAttemptsSummaryContext(version) {
  this._version = version;

  // Path Solution
  this._solution = {};
  this._uri = `/Attempts/Summary`;
};

/* jshint ignore:start */
/**
 * fetch a VerificationAttemptsSummaryInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.verifyServiceSid] -
 *          Filter the verification attempts considered on the summary by verify service.
 * @param {Date} [opts.dateCreatedAfter] -
 *          Consider verification attempts create after this date on the summary.
 * @param {Date} [opts.dateCreatedBefore] -
 *          Consider verification attempts created before this date on the summary.
 * @param {string} [opts.country] -
 *          Filter verification attempts considered on the summary by destination country.
 * @param {verification_attempts_summary.channels} [opts.channel] -
 *          Filter verification attempts considered on the summary by communication channel.
 * @param {string} [opts.destinationPrefix] -
 *          Filters the attempts considered on the summary by destination prefix.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationAttemptsSummaryInstance
 */
/* jshint ignore:end */
VerificationAttemptsSummaryContext.prototype.fetch = function fetch(opts,
    callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'VerifyServiceSid': _.get(opts, 'verifyServiceSid'),
    'DateCreatedAfter': serialize.iso8601DateTime(_.get(opts, 'dateCreatedAfter')),
    'DateCreatedBefore': serialize.iso8601DateTime(_.get(opts, 'dateCreatedBefore')),
    'Country': _.get(opts, 'country'),
    'Channel': _.get(opts, 'channel'),
    'DestinationPrefix': _.get(opts, 'destinationPrefix')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new VerificationAttemptsSummaryInstance(this._version, payload));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptsSummaryContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptsSummaryContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

VerificationAttemptsSummaryContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  VerificationAttemptsSummaryList: VerificationAttemptsSummaryList,
  VerificationAttemptsSummaryPage: VerificationAttemptsSummaryPage,
  VerificationAttemptsSummaryInstance: VerificationAttemptsSummaryInstance,
  VerificationAttemptsSummaryContext: VerificationAttemptsSummaryContext
};
