'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var ParticipantConversationList;
var ParticipantConversationPage;
var ParticipantConversationInstance;

/* jshint ignore:start */
/**
 * Initialize the ParticipantConversationList
 *
 * @constructor Twilio.Conversations.V1.ParticipantConversationList
 *
 * @param {Twilio.Conversations.V1} version - Version of the resource
 */
/* jshint ignore:end */
ParticipantConversationList = function ParticipantConversationList(version) {
  /* jshint ignore:start */
  /**
   * @function participantConversations
   * @memberof Twilio.Conversations.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Conversations.V1.ParticipantConversationContext}
   */
  /* jshint ignore:end */
  function ParticipantConversationListInstance(sid) {
    return ParticipantConversationListInstance.get(sid);
  }

  ParticipantConversationListInstance._version = version;
  // Path Solution
  ParticipantConversationListInstance._solution = {};
  ParticipantConversationListInstance._uri = `/ParticipantConversations`;
  /* jshint ignore:start */
  /**
   * Streams ParticipantConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Conversations.V1.ParticipantConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.identity] -
   *          A unique string identifier for the conversation participant as Conversation User.
   * @param {string} [opts.address] -
   *          A unique string identifier for the conversation participant who's not a Conversation User.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  ParticipantConversationListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists ParticipantConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Conversations.V1.ParticipantConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.identity] -
   *          A unique string identifier for the conversation participant as Conversation User.
   * @param {string} [opts.address] -
   *          A unique string identifier for the conversation participant who's not a Conversation User.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ParticipantConversationListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of ParticipantConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Conversations.V1.ParticipantConversationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.identity] -
   *          A unique string identifier for the conversation participant as Conversation User.
   * @param {string} [opts.address] -
   *          A unique string identifier for the conversation participant who's not a Conversation User.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ParticipantConversationListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Identity': _.get(opts, 'identity'),
      'Address': _.get(opts, 'address'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ParticipantConversationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of ParticipantConversationInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Conversations.V1.ParticipantConversationList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ParticipantConversationListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new ParticipantConversationPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Conversations.V1.ParticipantConversationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  ParticipantConversationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  ParticipantConversationListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return ParticipantConversationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the ParticipantConversationPage
 *
 * @constructor Twilio.Conversations.V1.ParticipantConversationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {ParticipantConversationSolution} solution - Path solution
 *
 * @returns ParticipantConversationPage
 */
/* jshint ignore:end */
ParticipantConversationPage = function ParticipantConversationPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(ParticipantConversationPage.prototype, Page.prototype);
ParticipantConversationPage.prototype.constructor = ParticipantConversationPage;

/* jshint ignore:start */
/**
 * Build an instance of ParticipantConversationInstance
 *
 * @function getInstance
 * @memberof Twilio.Conversations.V1.ParticipantConversationPage#
 *
 * @param {ParticipantConversationPayload} payload - Payload response from the API
 *
 * @returns ParticipantConversationInstance
 */
/* jshint ignore:end */
ParticipantConversationPage.prototype.getInstance = function
    getInstance(payload) {
  return new ParticipantConversationInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ParticipantConversationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
ParticipantConversationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ParticipantConversationPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ParticipantConversationContext
 *
 * @constructor Twilio.Conversations.V1.ParticipantConversationInstance
 *
 * @property {string} accountSid -
 *          The unique ID of the Account responsible for this conversation.
 * @property {string} chatServiceSid -
 *          The unique ID of the Conversation Service this conversation belongs to.
 * @property {string} participantSid - The unique ID of the Participant.
 * @property {string} participantUserSid -
 *          The unique ID for the conversation participant as Conversation User.
 * @property {string} participantIdentity -
 *          A unique string identifier for the conversation participant as Conversation User.
 * @property {object} participantMessagingBinding -
 *          Information about how this participant exchanges messages with the conversation.
 * @property {string} conversationSid -
 *          The unique ID of the Conversation this Participant belongs to.
 * @property {string} conversationUniqueName -
 *          An application-defined string that uniquely identifies the Conversation resource
 * @property {string} conversationFriendlyName -
 *          The human-readable name of this conversation.
 * @property {string} conversationAttributes -
 *          An optional string metadata field you can use to store any data you wish.
 * @property {Date} conversationDateCreated -
 *          The date that this conversation was created.
 * @property {Date} conversationDateUpdated -
 *          The date that this conversation was last updated.
 * @property {string} conversationCreatedBy - Creator of this conversation.
 * @property {participant_conversation.state} conversationState -
 *          The current state of this User Conversation
 * @property {object} conversationTimers - Timer date values for this conversation.
 * @property {string} links -
 *          Absolute URLs to access the participant and conversation of this Participant Conversation.
 *
 * @param {V1} version - Version of the resource
 * @param {ParticipantConversationPayload} payload - The instance payload
 */
/* jshint ignore:end */
ParticipantConversationInstance = function
    ParticipantConversationInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.chatServiceSid = payload.chat_service_sid; // jshint ignore:line
  this.participantSid = payload.participant_sid; // jshint ignore:line
  this.participantUserSid = payload.participant_user_sid; // jshint ignore:line
  this.participantIdentity = payload.participant_identity; // jshint ignore:line
  this.participantMessagingBinding = payload.participant_messaging_binding; // jshint ignore:line
  this.conversationSid = payload.conversation_sid; // jshint ignore:line
  this.conversationUniqueName = payload.conversation_unique_name; // jshint ignore:line
  this.conversationFriendlyName = payload.conversation_friendly_name; // jshint ignore:line
  this.conversationAttributes = payload.conversation_attributes; // jshint ignore:line
  this.conversationDateCreated = deserialize.iso8601DateTime(payload.conversation_date_created); // jshint ignore:line
  this.conversationDateUpdated = deserialize.iso8601DateTime(payload.conversation_date_updated); // jshint ignore:line
  this.conversationCreatedBy = payload.conversation_created_by; // jshint ignore:line
  this.conversationState = payload.conversation_state; // jshint ignore:line
  this.conversationTimers = payload.conversation_timers; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Conversations.V1.ParticipantConversationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
ParticipantConversationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ParticipantConversationInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  ParticipantConversationList: ParticipantConversationList,
  ParticipantConversationPage: ParticipantConversationPage,
  ParticipantConversationInstance: ParticipantConversationInstance
};
