'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var InstalledAddOnExtensionList;
var InstalledAddOnExtensionPage;
var InstalledAddOnExtensionInstance;
var InstalledAddOnExtensionContext;

/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnExtensionList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList
 *
 * @param {Twilio.Preview.Marketplace} version - Version of the resource
 * @param {string} installedAddOnSid -
 *          The SID of the InstalledAddOn resource to which this extension applies
 */
/* jshint ignore:end */
InstalledAddOnExtensionList = function InstalledAddOnExtensionList(version,
    installedAddOnSid) {
  /* jshint ignore:start */
  /**
   * @function extensions
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext}
   */
  /* jshint ignore:end */
  function InstalledAddOnExtensionListInstance(sid) {
    return InstalledAddOnExtensionListInstance.get(sid);
  }

  InstalledAddOnExtensionListInstance._version = version;
  // Path Solution
  InstalledAddOnExtensionListInstance._solution = {installedAddOnSid: installedAddOnSid};
  InstalledAddOnExtensionListInstance._uri = `/InstalledAddOns/${installedAddOnSid}/Extensions`;
  /* jshint ignore:start */
  /**
   * Streams InstalledAddOnExtensionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists InstalledAddOnExtensionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of InstalledAddOnExtensionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new InstalledAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of InstalledAddOnExtensionInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new InstalledAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a installed_add_on_extension
   *
   * @function get
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @param {string} sid - The SID of the InstalledAddOn Extension resource to fetch
   *
   * @returns {Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext}
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.get = function get(sid) {
    return new InstalledAddOnExtensionContext(this._version, this._solution.installedAddOnSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  InstalledAddOnExtensionListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  InstalledAddOnExtensionListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return InstalledAddOnExtensionListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnExtensionPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionPage
 *
 * @param {Marketplace} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {InstalledAddOnExtensionSolution} solution - Path solution
 *
 * @returns InstalledAddOnExtensionPage
 */
/* jshint ignore:end */
InstalledAddOnExtensionPage = function InstalledAddOnExtensionPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(InstalledAddOnExtensionPage.prototype, Page.prototype);
InstalledAddOnExtensionPage.prototype.constructor = InstalledAddOnExtensionPage;

/* jshint ignore:start */
/**
 * Build an instance of InstalledAddOnExtensionInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionPage#
 *
 * @param {InstalledAddOnExtensionPayload} payload - Payload response from the API
 *
 * @returns InstalledAddOnExtensionInstance
 */
/* jshint ignore:end */
InstalledAddOnExtensionPage.prototype.getInstance = function
    getInstance(payload) {
  return new InstalledAddOnExtensionInstance(
    this._version,
    payload,
    this._solution.installedAddOnSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnExtensionPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

InstalledAddOnExtensionPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} installedAddOnSid -
 *          The SID of the InstalledAddOn resource to which this extension applies
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} productName - The name of the Extension's Product
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the resource
 * @property {boolean} enabled - Whether the Extension will be invoked
 * @property {string} url - The absolute URL of the resource
 *
 * @param {Marketplace} version - Version of the resource
 * @param {InstalledAddOnExtensionPayload} payload - The instance payload
 * @param {sid} installedAddOnSid -
 *          The SID of the InstalledAddOn resource to which this extension applies
 * @param {sid} sid - The SID of the InstalledAddOn Extension resource to fetch
 */
/* jshint ignore:end */
InstalledAddOnExtensionInstance = function
    InstalledAddOnExtensionInstance(version, payload, installedAddOnSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.installedAddOnSid = payload.installed_add_on_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.productName = payload.product_name; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.enabled = payload.enabled; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {installedAddOnSid: installedAddOnSid, sid: sid || this.sid, };
};

Object.defineProperty(InstalledAddOnExtensionInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new InstalledAddOnExtensionContext(
          this._version,
          this._solution.installedAddOnSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a InstalledAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnExtensionInstance
 */
/* jshint ignore:end */
InstalledAddOnExtensionInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a InstalledAddOnExtensionInstance
 *
 * @function update
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionInstance#
 *
 * @param {object} opts - Options for request
 * @param {boolean} opts.enabled - Whether the Extension should be invoked
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnExtensionInstance
 */
/* jshint ignore:end */
InstalledAddOnExtensionInstance.prototype.update = function update(opts,
    callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnExtensionInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

InstalledAddOnExtensionInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the InstalledAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext
 *
 * @param {Marketplace} version - Version of the resource
 * @param {sid} installedAddOnSid -
 *          The SID of the InstalledAddOn resource with the extension to fetch
 * @param {sid} sid - The SID of the InstalledAddOn Extension resource to fetch
 */
/* jshint ignore:end */
InstalledAddOnExtensionContext = function
    InstalledAddOnExtensionContext(version, installedAddOnSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {installedAddOnSid: installedAddOnSid, sid: sid, };
  this._uri = `/InstalledAddOns/${installedAddOnSid}/Extensions/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a InstalledAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnExtensionInstance
 */
/* jshint ignore:end */
InstalledAddOnExtensionContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new InstalledAddOnExtensionInstance(
      this._version,
      payload,
      this._solution.installedAddOnSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a InstalledAddOnExtensionInstance
 *
 * @function update
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext#
 *
 * @param {object} opts - Options for request
 * @param {boolean} opts.enabled - Whether the Extension should be invoked
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed InstalledAddOnExtensionInstance
 */
/* jshint ignore:end */
InstalledAddOnExtensionContext.prototype.update = function update(opts,
    callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts['enabled'])) {
    throw new Error('Required parameter "opts[\'enabled\']" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'Enabled': serialize.bool(_.get(opts, 'enabled'))});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new InstalledAddOnExtensionInstance(
      this._version,
      payload,
      this._solution.installedAddOnSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.InstalledAddOnContext.InstalledAddOnExtensionContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
InstalledAddOnExtensionContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

InstalledAddOnExtensionContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  InstalledAddOnExtensionList: InstalledAddOnExtensionList,
  InstalledAddOnExtensionPage: InstalledAddOnExtensionPage,
  InstalledAddOnExtensionInstance: InstalledAddOnExtensionInstance,
  InstalledAddOnExtensionContext: InstalledAddOnExtensionContext
};
