/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2010 = require('../../../V2010');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the UserDefinedMessageSubscriptionList
 *
 * @param version - Version of the resource
 * @param accountSid - Account SID.
 * @param callSid - Call SID.
 */
declare function UserDefinedMessageSubscriptionList(version: V2010, accountSid: string, callSid: string): UserDefinedMessageSubscriptionListInstance;

interface UserDefinedMessageSubscriptionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): UserDefinedMessageSubscriptionContext;
  /**
   * create a UserDefinedMessageSubscriptionInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: UserDefinedMessageSubscriptionListInstanceCreateOptions, callback?: (error: Error | null, item: UserDefinedMessageSubscriptionInstance) => any): Promise<UserDefinedMessageSubscriptionInstance>;
  /**
   * Constructs a user_defined_message_subscription
   *
   * @param sid - User Defined Message Subscription SID.
   */
  get(sid: string): UserDefinedMessageSubscriptionContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property callback - The URL we should call to send user defined messages.
 * @property idempotencyKey - A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.
 * @property method - HTTP method used with the callback.
 */
interface UserDefinedMessageSubscriptionListInstanceCreateOptions {
  callback: string;
  idempotencyKey?: string;
  method?: string;
}

interface UserDefinedMessageSubscriptionPayload extends UserDefinedMessageSubscriptionResource, Page.TwilioResponsePayload {
}

interface UserDefinedMessageSubscriptionResource {
  account_sid: string;
  call_sid: string;
  date_created: Date;
  sid: string;
  uri: string;
}

interface UserDefinedMessageSubscriptionSolution {
  accountSid?: string;
  callSid?: string;
}


declare class UserDefinedMessageSubscriptionContext {
  /**
   * Initialize the UserDefinedMessageSubscriptionContext
   *
   * @param version - Version of the resource
   * @param accountSid - Account SID.
   * @param callSid - Call SID.
   * @param sid - User Defined Message Subscription SID.
   */
  constructor(version: V2010, accountSid: string, callSid: string, sid: string);

  /**
   * remove a UserDefinedMessageSubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: UserDefinedMessageSubscriptionInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class UserDefinedMessageSubscriptionInstance extends SerializableClass {
  /**
   * Initialize the UserDefinedMessageSubscriptionContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - Account SID.
   * @param callSid - Call SID.
   * @param sid - User Defined Message Subscription SID.
   */
  constructor(version: V2010, payload: UserDefinedMessageSubscriptionPayload, accountSid: string, callSid: string, sid: string);

  private _proxy: UserDefinedMessageSubscriptionContext;
  accountSid: string;
  callSid: string;
  dateCreated: Date;
  /**
   * remove a UserDefinedMessageSubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: UserDefinedMessageSubscriptionInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uri: string;
}


declare class UserDefinedMessageSubscriptionPage extends Page<V2010, UserDefinedMessageSubscriptionPayload, UserDefinedMessageSubscriptionResource, UserDefinedMessageSubscriptionInstance> {
  /**
   * Initialize the UserDefinedMessageSubscriptionPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: UserDefinedMessageSubscriptionSolution);

  /**
   * Build an instance of UserDefinedMessageSubscriptionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UserDefinedMessageSubscriptionPayload): UserDefinedMessageSubscriptionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UserDefinedMessageSubscriptionContext, UserDefinedMessageSubscriptionInstance, UserDefinedMessageSubscriptionList, UserDefinedMessageSubscriptionListInstance, UserDefinedMessageSubscriptionListInstanceCreateOptions, UserDefinedMessageSubscriptionPage, UserDefinedMessageSubscriptionPayload, UserDefinedMessageSubscriptionResource, UserDefinedMessageSubscriptionSolution }
