/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ApprovalFetchList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param sid - The unique string that identifies the Content resource
 */
declare function ApprovalFetchList(version: V1, sid: string): ApprovalFetchListInstance;

interface ApprovalFetchListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ApprovalFetchContext;
  /**
   * Constructs a approval_fetch
   */
  get(): ApprovalFetchContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ApprovalFetchPayload extends ApprovalFetchResource, Page.TwilioResponsePayload {
}

interface ApprovalFetchResource {
  account_sid: string;
  sid: string;
  url: string;
  whatsapp: object;
}

interface ApprovalFetchSolution {
  sid?: string;
}


declare class ApprovalFetchContext {
  /**
   * Initialize the ApprovalFetchContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the Content resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a ApprovalFetchInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ApprovalFetchInstance) => any): Promise<ApprovalFetchInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ApprovalFetchInstance extends SerializableClass {
  /**
   * Initialize the ApprovalFetchContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the Content resource
   */
  constructor(version: V1, payload: ApprovalFetchPayload, sid: string);

  private _proxy: ApprovalFetchContext;
  accountSid: string;
  /**
   * fetch a ApprovalFetchInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ApprovalFetchInstance) => any): Promise<ApprovalFetchInstance>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  whatsapp: any;
}


declare class ApprovalFetchPage extends Page<V1, ApprovalFetchPayload, ApprovalFetchResource, ApprovalFetchInstance> {
  /**
   * Initialize the ApprovalFetchPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ApprovalFetchSolution);

  /**
   * Build an instance of ApprovalFetchInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ApprovalFetchPayload): ApprovalFetchInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ApprovalFetchContext, ApprovalFetchInstance, ApprovalFetchList, ApprovalFetchListInstance, ApprovalFetchPage, ApprovalFetchPayload, ApprovalFetchResource, ApprovalFetchSolution }
