'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var SchemaVersionList = require('./schema/version').SchemaVersionList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var SchemaList;
var SchemaPage;
var SchemaInstance;
var SchemaContext;

/* jshint ignore:start */
/**
 * Initialize the SchemaList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SchemaList
 *
 * @param {Twilio.Events.V1} version - Version of the resource
 */
/* jshint ignore:end */
SchemaList = function SchemaList(version) {
  /* jshint ignore:start */
  /**
   * @function schemas
   * @memberof Twilio.Events.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Events.V1.SchemaContext}
   */
  /* jshint ignore:end */
  function SchemaListInstance(sid) {
    return SchemaListInstance.get(sid);
  }

  SchemaListInstance._version = version;
  // Path Solution
  SchemaListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a schema
   *
   * @function get
   * @memberof Twilio.Events.V1.SchemaList#
   *
   * @param {string} id - The unique identifier of the schema.
   *
   * @returns {Twilio.Events.V1.SchemaContext}
   */
  /* jshint ignore:end */
  SchemaListInstance.get = function get(id) {
    return new SchemaContext(this._version, id);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Events.V1.SchemaList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SchemaListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SchemaListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return SchemaListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SchemaPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SchemaPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SchemaSolution} solution - Path solution
 *
 * @returns SchemaPage
 */
/* jshint ignore:end */
SchemaPage = function SchemaPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SchemaPage.prototype, Page.prototype);
SchemaPage.prototype.constructor = SchemaPage;

/* jshint ignore:start */
/**
 * Build an instance of SchemaInstance
 *
 * @function getInstance
 * @memberof Twilio.Events.V1.SchemaPage#
 *
 * @param {SchemaPayload} payload - Payload response from the API
 *
 * @returns SchemaInstance
 */
/* jshint ignore:end */
SchemaPage.prototype.getInstance = function getInstance(payload) {
  return new SchemaInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SchemaPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SchemaPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SchemaPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SchemaContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SchemaInstance
 *
 * @property {string} id - Schema Identifier.
 * @property {string} url - The URL of this resource.
 * @property {string} links - Nested resource URLs.
 * @property {Date} latestVersionDateCreated -
 *          The date that the latest schema version was created.
 * @property {number} latestVersion - Latest schema version.
 *
 * @param {V1} version - Version of the resource
 * @param {SchemaPayload} payload - The instance payload
 * @param {string} id - The unique identifier of the schema.
 */
/* jshint ignore:end */
SchemaInstance = function SchemaInstance(version, payload, id) {
  this._version = version;

  // Marshaled Properties
  this.id = payload.id; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.latestVersionDateCreated = deserialize.iso8601DateTime(payload.latest_version_date_created); // jshint ignore:line
  this.latestVersion = deserialize.integer(payload.latest_version); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {id: id || this.id, };
};

Object.defineProperty(SchemaInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SchemaContext(this._version, this._solution.id);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SchemaInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SchemaInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SchemaInstance
 */
/* jshint ignore:end */
SchemaInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Access the versions
 *
 * @function versions
 * @memberof Twilio.Events.V1.SchemaInstance#
 *
 * @returns {Twilio.Events.V1.SchemaContext.SchemaVersionList}
 */
/* jshint ignore:end */
SchemaInstance.prototype.versions = function versions() {
  return this._proxy.versions;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SchemaInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SchemaInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SchemaInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SchemaContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SchemaContext
 *
 * @property {Twilio.Events.V1.SchemaContext.SchemaVersionList} versions -
 *          versions resource
 *
 * @param {V1} version - Version of the resource
 * @param {string} id - The unique identifier of the schema.
 */
/* jshint ignore:end */
SchemaContext = function SchemaContext(version, id) {
  this._version = version;

  // Path Solution
  this._solution = {id: id, };
  this._uri = `/Schemas/${id}`;

  // Dependents
  this._versions = undefined;
};

/* jshint ignore:start */
/**
 * fetch a SchemaInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SchemaContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SchemaInstance
 */
/* jshint ignore:end */
SchemaContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SchemaInstance(this._version, payload, this._solution.id));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(SchemaContext.prototype,
  'versions', {
    get: function() {
      if (!this._versions) {
        this._versions = new SchemaVersionList(this._version, this._solution.id);
      }
      return this._versions;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SchemaContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SchemaContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SchemaContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SchemaList: SchemaList,
  SchemaPage: SchemaPage,
  SchemaInstance: SchemaInstance,
  SchemaContext: SchemaContext
};
