/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the AssessmentsList
 *
 * @param version - Version of the resource
 */
declare function AssessmentsList(version: V1): AssessmentsListInstance;

interface AssessmentsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AssessmentsContext;
  /**
   * Constructs a assessments
   */
  get(): AssessmentsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AssessmentsPayload extends AssessmentsResource, Page.TwilioResponsePayload {
}

interface AssessmentsResource {
  url: string;
}

interface AssessmentsSolution {
}


declare class AssessmentsContext {
  /**
   * Initialize the AssessmentsContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * create a AssessmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: AssessmentsInstance) => any): Promise<AssessmentsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AssessmentsInstance extends SerializableClass {
  /**
   * Initialize the AssessmentsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: AssessmentsPayload);

  private _proxy: AssessmentsContext;
  /**
   * create a AssessmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, items: AssessmentsInstance) => any): Promise<AssessmentsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class AssessmentsPage extends Page<V1, AssessmentsPayload, AssessmentsResource, AssessmentsInstance> {
  /**
   * Initialize the AssessmentsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AssessmentsSolution);

  /**
   * Build an instance of AssessmentsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AssessmentsPayload): AssessmentsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AssessmentsContext, AssessmentsInstance, AssessmentsList, AssessmentsListInstance, AssessmentsPage, AssessmentsPayload, AssessmentsResource, AssessmentsSolution }
