/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { AnnotationList } from './call/annotation';
import { AnnotationListInstance } from './call/annotation';
import { CallSummaryList } from './call/summary';
import { CallSummaryListInstance } from './call/summary';
import { EventList } from './call/event';
import { EventListInstance } from './call/event';
import { MetricList } from './call/metric';
import { MetricListInstance } from './call/metric';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the CallList
 *
 * @param version - Version of the resource
 */
declare function CallList(version: V1): CallListInstance;

interface CallListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CallContext;
  /**
   * Constructs a call
   *
   * @param sid - The sid
   */
  get(sid: string): CallContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface CallPayload extends CallResource, Page.TwilioResponsePayload {
}

interface CallResource {
  links: string;
  sid: string;
  url: string;
}

interface CallSolution {
}


declare class CallContext {
  /**
   * Initialize the CallContext
   *
   * @param version - Version of the resource
   * @param sid - The sid
   */
  constructor(version: V1, sid: string);

  annotation: AnnotationListInstance;
  events: EventListInstance;
  /**
   * fetch a CallInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CallInstance) => any): Promise<CallInstance>;
  metrics: MetricListInstance;
  summary: CallSummaryListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CallInstance extends SerializableClass {
  /**
   * Initialize the CallContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The sid
   */
  constructor(version: V1, payload: CallPayload, sid: string);

  private _proxy: CallContext;
  /**
   * Access the annotation
   */
  annotation(): AnnotationListInstance;
  /**
   * Access the events
   */
  events(): EventListInstance;
  /**
   * fetch a CallInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CallInstance) => any): Promise<CallInstance>;
  links: string;
  /**
   * Access the metrics
   */
  metrics(): MetricListInstance;
  sid: string;
  /**
   * Access the summary
   */
  summary(): CallSummaryListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class CallPage extends Page<V1, CallPayload, CallResource, CallInstance> {
  /**
   * Initialize the CallPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CallSolution);

  /**
   * Build an instance of CallInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CallPayload): CallInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CallContext, CallInstance, CallList, CallListInstance, CallPage, CallPayload, CallResource, CallSolution }
