/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type AnnotationAnsweredBy = 'unknown_answered_by'|'human'|'machine';

type AnnotationConnectivityIssue = 'unknown_connectivity_issue'|'no_connectivity_issue'|'invalid_number'|'caller_id'|'dropped_call'|'number_reachability';

type AnnotationQualityIssues = 'unknown_quality_issue'|'no_quality_issue'|'low_volume'|'choppy_robotic'|'echo'|'dtmf'|'latency'|'owa'|'static_noise';

/**
 * Initialize the AnnotationList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param callSid - Call SID.
 */
declare function AnnotationList(version: V1, callSid: string): AnnotationListInstance;

/**
 * Options to pass to update
 *
 * @property answeredBy - Indicates the answering entity as determined by Answering Machine Detection.
 * @property callScore - Call Score
 * @property comment - User comments
 * @property connectivityIssue - Indicates if the call had any connectivity issue
 * @property incident - Call tag for incidents or support ticket
 * @property qualityIssues - Indicates if the call had audio quality issues.
 * @property spam - Call spam indicator
 */
interface AnnotationInstanceUpdateOptions {
  answeredBy?: AnnotationAnsweredBy;
  callScore?: number;
  comment?: string;
  connectivityIssue?: AnnotationConnectivityIssue;
  incident?: string;
  qualityIssues?: string;
  spam?: boolean;
}

interface AnnotationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AnnotationContext;
  /**
   * Constructs a annotation
   */
  get(): AnnotationContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AnnotationPayload extends AnnotationResource, Page.TwilioResponsePayload {
}

interface AnnotationResource {
  account_sid: string;
  answered_by: AnnotationAnsweredBy;
  call_score: number;
  call_sid: string;
  comment: string;
  connectivity_issue: AnnotationConnectivityIssue;
  incident: string;
  quality_issues: string[];
  spam: boolean;
  url: string;
}

interface AnnotationSolution {
  callSid?: string;
}


declare class AnnotationContext {
  /**
   * Initialize the AnnotationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param callSid - Call SID.
   */
  constructor(version: V1, callSid: string);

  /**
   * fetch a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * update a AnnotationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AnnotationInstanceUpdateOptions, callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
}


declare class AnnotationInstance extends SerializableClass {
  /**
   * Initialize the AnnotationContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param callSid - Call SID.
   */
  constructor(version: V1, payload: AnnotationPayload, callSid: string);

  private _proxy: AnnotationContext;
  accountSid: string;
  answeredBy: AnnotationAnsweredBy;
  callScore: number;
  callSid: string;
  comment: string;
  connectivityIssue: AnnotationConnectivityIssue;
  /**
   * fetch a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  incident: string;
  qualityIssues: string[];
  spam: boolean;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * update a AnnotationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AnnotationInstanceUpdateOptions, callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  url: string;
}


declare class AnnotationPage extends Page<V1, AnnotationPayload, AnnotationResource, AnnotationInstance> {
  /**
   * Initialize the AnnotationPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AnnotationSolution);

  /**
   * Build an instance of AnnotationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AnnotationPayload): AnnotationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AnnotationAnsweredBy, AnnotationConnectivityIssue, AnnotationContext, AnnotationInstance, AnnotationInstanceUpdateOptions, AnnotationList, AnnotationListInstance, AnnotationPage, AnnotationPayload, AnnotationQualityIssues, AnnotationResource, AnnotationSolution }
