'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var TokenList;
var TokenPage;
var TokenInstance;

/* jshint ignore:start */
/**
 * Initialize the TokenList
 *
 * @constructor Twilio.Oauth.V1.TokenList
 *
 * @param {Twilio.Oauth.V1} version - Version of the resource
 */
/* jshint ignore:end */
TokenList = function TokenList(version) {
  /* jshint ignore:start */
  /**
   * @function token
   * @memberof Twilio.Oauth.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Oauth.V1.TokenContext}
   */
  /* jshint ignore:end */
  function TokenListInstance(sid) {
    return TokenListInstance.get(sid);
  }

  TokenListInstance._version = version;
  // Path Solution
  TokenListInstance._solution = {};
  TokenListInstance._uri = `/token`;
  /* jshint ignore:start */
  /**
   * create a TokenInstance
   *
   * @function create
   * @memberof Twilio.Oauth.V1.TokenList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.grantType -
   *          A way of representing resource owner's to obtain access token
   * @param {string} opts.clientSid -
   *          A string that uniquely identifies this oauth app
   * @param {string} [opts.clientSecret] - The credential for confidential OAuth App
   * @param {string} [opts.code] - Jwt token
   * @param {string} [opts.codeVerifier] - The cryptographically generated code
   * @param {string} [opts.deviceCode] - Jwt token
   * @param {string} [opts.refreshToken] - Jwt token
   * @param {string} [opts.deviceId] - An Id of device
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed TokenInstance
   */
  /* jshint ignore:end */
  TokenListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['grantType'])) {
      throw new Error('Required parameter "opts[\'grantType\']" missing.');
    }
    if (_.isUndefined(opts['clientSid'])) {
      throw new Error('Required parameter "opts[\'clientSid\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'GrantType': _.get(opts, 'grantType'),
      'ClientSid': _.get(opts, 'clientSid'),
      'ClientSecret': _.get(opts, 'clientSecret'),
      'Code': _.get(opts, 'code'),
      'CodeVerifier': _.get(opts, 'codeVerifier'),
      'DeviceCode': _.get(opts, 'deviceCode'),
      'RefreshToken': _.get(opts, 'refreshToken'),
      'DeviceId': _.get(opts, 'deviceId')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TokenInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Oauth.V1.TokenList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TokenListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TokenListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return TokenListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TokenPage
 *
 * @constructor Twilio.Oauth.V1.TokenPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TokenSolution} solution - Path solution
 *
 * @returns TokenPage
 */
/* jshint ignore:end */
TokenPage = function TokenPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TokenPage.prototype, Page.prototype);
TokenPage.prototype.constructor = TokenPage;

/* jshint ignore:start */
/**
 * Build an instance of TokenInstance
 *
 * @function getInstance
 * @memberof Twilio.Oauth.V1.TokenPage#
 *
 * @param {TokenPayload} payload - Payload response from the API
 *
 * @returns TokenInstance
 */
/* jshint ignore:end */
TokenPage.prototype.getInstance = function getInstance(payload) {
  return new TokenInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Oauth.V1.TokenPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TokenPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TokenPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TokenContext
 *
 * @constructor Twilio.Oauth.V1.TokenInstance
 *
 * @property {string} accessToken -
 *          Token which carries the necessary information to access a Twilio resource directly
 * @property {string} refreshToken -
 *          Token which carries the information necessary to get a new access token
 * @property {string} idToken - The id_token
 * @property {Date} refreshTokenExpiresAt -
 *          The RFC 2822 date and time in GMT when the refresh token expires
 * @property {Date} accessTokenExpiresAt -
 *          The RFC 2822 date and time in GMT when the access token expires
 *
 * @param {V1} version - Version of the resource
 * @param {TokenPayload} payload - The instance payload
 */
/* jshint ignore:end */
TokenInstance = function TokenInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.accessToken = payload.access_token; // jshint ignore:line
  this.refreshToken = payload.refresh_token; // jshint ignore:line
  this.idToken = payload.id_token; // jshint ignore:line
  this.refreshTokenExpiresAt = deserialize.iso8601DateTime(payload.refresh_token_expires_at); // jshint ignore:line
  this.accessTokenExpiresAt = deserialize.iso8601DateTime(payload.access_token_expires_at); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Oauth.V1.TokenInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TokenInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TokenInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TokenList: TokenList,
  TokenPage: TokenPage,
  TokenInstance: TokenInstance
};
