/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { ChallengeList } from './entity/challenge';
import { ChallengeListInstance } from './entity/challenge';
import { FactorList } from './entity/factor';
import { FactorListInstance } from './entity/factor';
import { NewFactorList } from './entity/newFactor';
import { NewFactorListInstance } from './entity/newFactor';
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the EntityList
 *
 * @param version - Version of the resource
 * @param serviceSid - Service Sid.
 */
declare function EntityList(version: V2, serviceSid: string): EntityListInstance;

interface EntityListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): EntityContext;
  /**
   * create a EntityInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: EntityListInstanceCreateOptions, callback?: (error: Error | null, item: EntityInstance) => any): Promise<EntityInstance>;
  /**
   * Streams EntityInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: EntityInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams EntityInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: EntityListInstanceEachOptions, callback?: (item: EntityInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a entity
   *
   * @param identity - Unique external identifier of the Entity
   */
  get(identity: string): EntityContext;
  /**
   * Retrieve a single target page of EntityInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: EntityPage) => any): Promise<EntityPage>;
  /**
   * Retrieve a single target page of EntityInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: EntityPage) => any): Promise<EntityPage>;
  /**
   * Lists EntityInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: EntityInstance[]) => any): Promise<EntityInstance[]>;
  /**
   * Lists EntityInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: EntityListInstanceOptions, callback?: (error: Error | null, items: EntityInstance[]) => any): Promise<EntityInstance[]>;
  /**
   * Retrieve a single page of EntityInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: EntityPage) => any): Promise<EntityPage>;
  /**
   * Retrieve a single page of EntityInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: EntityListInstancePageOptions, callback?: (error: Error | null, items: EntityPage) => any): Promise<EntityPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property identity - Unique external identifier of the Entity
 */
interface EntityListInstanceCreateOptions {
  identity: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface EntityListInstanceEachOptions {
  callback?: (item: EntityInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface EntityListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface EntityListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface EntityPayload extends EntityResource, Page.TwilioResponsePayload {
}

interface EntityResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  identity: string;
  links: string;
  service_sid: string;
  sid: string;
  url: string;
}

interface EntitySolution {
  serviceSid?: string;
}


declare class EntityContext {
  /**
   * Initialize the EntityContext
   *
   * @param version - Version of the resource
   * @param serviceSid - Service Sid.
   * @param identity - Unique external identifier of the Entity
   */
  constructor(version: V2, serviceSid: string, identity: string);

  challenges: ChallengeListInstance;
  factors: FactorListInstance;
  /**
   * fetch a EntityInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EntityInstance) => any): Promise<EntityInstance>;
  newFactors: NewFactorListInstance;
  /**
   * remove a EntityInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: EntityInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class EntityInstance extends SerializableClass {
  /**
   * Initialize the EntityContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - Service Sid.
   * @param identity - Unique external identifier of the Entity
   */
  constructor(version: V2, payload: EntityPayload, serviceSid: string, identity: string);

  private _proxy: EntityContext;
  accountSid: string;
  /**
   * Access the challenges
   */
  challenges(): ChallengeListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * Access the factors
   */
  factors(): FactorListInstance;
  /**
   * fetch a EntityInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EntityInstance) => any): Promise<EntityInstance>;
  identity: string;
  links: string;
  /**
   * Access the newFactors
   */
  newFactors(): NewFactorListInstance;
  /**
   * remove a EntityInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: EntityInstance) => any): Promise<boolean>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class EntityPage extends Page<V2, EntityPayload, EntityResource, EntityInstance> {
  /**
   * Initialize the EntityPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: EntitySolution);

  /**
   * Build an instance of EntityInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: EntityPayload): EntityInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { EntityContext, EntityInstance, EntityList, EntityListInstance, EntityListInstanceCreateOptions, EntityListInstanceEachOptions, EntityListInstanceOptions, EntityListInstancePageOptions, EntityPage, EntityPayload, EntityResource, EntitySolution }
