/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the TemplateList
 *
 * @param version - Version of the resource
 */
declare function TemplateList(version: V2): TemplateListInstance;

interface TemplateListInstance {
  /**
   * Streams TemplateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TemplateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TemplateInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TemplateListInstanceEachOptions, callback?: (item: TemplateInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of TemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TemplatePage) => any): Promise<TemplatePage>;
  /**
   * Retrieve a single target page of TemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TemplatePage) => any): Promise<TemplatePage>;
  /**
   * Lists TemplateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TemplateInstance[]) => any): Promise<TemplateInstance[]>;
  /**
   * Lists TemplateInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TemplateListInstanceOptions, callback?: (error: Error | null, items: TemplateInstance[]) => any): Promise<TemplateInstance[]>;
  /**
   * Retrieve a single page of TemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TemplatePage) => any): Promise<TemplatePage>;
  /**
   * Retrieve a single page of TemplateInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TemplateListInstancePageOptions, callback?: (error: Error | null, items: TemplatePage) => any): Promise<TemplatePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - Filter templates using friendly name
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TemplateListInstanceEachOptions {
  callback?: (item: TemplateInstance, done: (err?: Error) => void) => void;
  done?: Function;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property friendlyName - Filter templates using friendly name
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TemplateListInstanceOptions {
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property friendlyName - Filter templates using friendly name
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TemplateListInstancePageOptions {
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TemplatePayload extends TemplateResource, Page.TwilioResponsePayload {
}

interface TemplateResource {
  account_sid: string;
  channels: string[];
  friendly_name: string;
  sid: string;
  translations: object;
}

interface TemplateSolution {
}


declare class TemplateInstance extends SerializableClass {
  /**
   * Initialize the TemplateContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: TemplatePayload);

  accountSid: string;
  channels: string[];
  friendlyName: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  translations: any;
}


declare class TemplatePage extends Page<V2, TemplatePayload, TemplateResource, TemplateInstance> {
  /**
   * Initialize the TemplatePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: TemplateSolution);

  /**
   * Build an instance of TemplateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TemplatePayload): TemplateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TemplateInstance, TemplateList, TemplateListInstance, TemplateListInstanceEachOptions, TemplateListInstanceOptions, TemplateListInstancePageOptions, TemplatePage, TemplatePayload, TemplateResource, TemplateSolution }
