/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ArchivedCallList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function ArchivedCallList(version: V1): ArchivedCallListInstance;

interface ArchivedCallListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ArchivedCallContext;
  /**
   * Constructs a archived_call
   *
   * @param date - The date of the Call in UTC.
   * @param sid - The unique string that identifies this resource
   */
  get(date: string, sid: string): ArchivedCallContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ArchivedCallPayload extends ArchivedCallResource, Page.TwilioResponsePayload {
}

interface ArchivedCallResource {
  date: Date;
  sid: string;
  url: string;
}

interface ArchivedCallSolution {
}


declare class ArchivedCallContext {
  /**
   * Initialize the ArchivedCallContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param date - The date of the Call in UTC.
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V1, date: Date, sid: string);

  /**
   * remove a ArchivedCallInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ArchivedCallInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ArchivedCallInstance extends SerializableClass {
  /**
   * Initialize the ArchivedCallContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param date - The date of the Call in UTC.
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V1, payload: ArchivedCallPayload, date: Date, sid: string);

  private _proxy: ArchivedCallContext;
  date: Date;
  /**
   * remove a ArchivedCallInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ArchivedCallInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class ArchivedCallPage extends Page<V1, ArchivedCallPayload, ArchivedCallResource, ArchivedCallInstance> {
  /**
   * Initialize the ArchivedCallPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ArchivedCallSolution);

  /**
   * Build an instance of ArchivedCallInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ArchivedCallPayload): ArchivedCallInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ArchivedCallContext, ArchivedCallInstance, ArchivedCallList, ArchivedCallListInstance, ArchivedCallPage, ArchivedCallPayload, ArchivedCallResource, ArchivedCallSolution }
