"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Oauth
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserInfoListInstance = exports.UserInfoInstance = exports.UserInfoContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
class UserInfoContextImpl {
    constructor(_version) {
        this._version = _version;
        this._solution = {};
        this._uri = `/userinfo`;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new UserInfoInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.UserInfoContextImpl = UserInfoContextImpl;
class UserInfoInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.userSid = payload.user_sid;
        this.firstName = payload.first_name;
        this.lastName = payload.last_name;
        this.friendlyName = payload.friendly_name;
        this.email = payload.email;
        this.url = payload.url;
        this._solution = {};
    }
    get _proxy() {
        this._context = this._context || new UserInfoContextImpl(this._version);
        return this._context;
    }
    /**
     * Fetch a UserInfoInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed UserInfoInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            userSid: this.userSid,
            firstName: this.firstName,
            lastName: this.lastName,
            friendlyName: this.friendlyName,
            email: this.email,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.UserInfoInstance = UserInfoInstance;
function UserInfoListInstance(version) {
    const instance = (() => instance.get());
    instance.get = function get() {
        return new UserInfoContextImpl(version);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.UserInfoListInstance = UserInfoListInstance;
