/* valasymbolresolver.c generated by valac, the Vala compiler
 * generated from valasymbolresolver.vala, do not modify */

/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSymbolResolverPrivate {
	ValaSymbol* root_symbol;
	ValaScope* current_scope;
};

static gint ValaSymbolResolver_private_offset;
static gpointer vala_symbol_resolver_parent_class = NULL;

static void vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base,
                                                ValaNamespace* ns);
static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base,
                                            ValaClass* cl);
static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base,
                                             ValaStruct* st);
static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base,
                                                ValaInterface* iface);
static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base,
                                           ValaEnum* en);
static void vala_symbol_resolver_real_visit_error_domain (ValaCodeVisitor* base,
                                                   ValaErrorDomain* ed);
static void vala_symbol_resolver_real_visit_delegate (ValaCodeVisitor* base,
                                               ValaDelegate* cb);
static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base,
                                               ValaConstant* c);
static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base,
                                            ValaField* f);
static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base,
                                             ValaMethod* m);
static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base,
                                                      ValaCreationMethod* m);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base,
                                                       ValaParameter* p);
static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base,
                                               ValaProperty* prop);
static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base,
                                                        ValaPropertyAccessor* acc);
static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base,
                                             ValaSignal* sig);
static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base,
                                                  ValaConstructor* c);
static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base,
                                                 ValaDestructor* d);
static void vala_symbol_resolver_real_visit_block (ValaCodeVisitor* base,
                                            ValaBlock* b);
static void vala_symbol_resolver_real_visit_using_directive (ValaCodeVisitor* base,
                                                      ValaUsingDirective* ns);
static ValaSymbol* vala_symbol_resolver_resolve_symbol (ValaSymbolResolver* self,
                                                 ValaUnresolvedSymbol* unresolved_symbol);
static gboolean vala_symbol_resolver_has_base_struct_cycle (ValaSymbolResolver* self,
                                                     ValaStruct* st,
                                                     ValaStruct* loop_st);
static ValaDataType* vala_symbol_resolver_get_type_for_struct (ValaSymbolResolver* self,
                                                        ValaStruct* st,
                                                        ValaStruct* base_struct);
static ValaDataType* vala_symbol_resolver_resolve_type (ValaSymbolResolver* self,
                                                 ValaUnresolvedType* unresolved_type);
static void vala_symbol_resolver_real_visit_data_type (ValaCodeVisitor* base,
                                                ValaDataType* data_type);
static void vala_symbol_resolver_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                            ValaDeclarationStatement* stmt);
static void vala_symbol_resolver_real_visit_local_variable (ValaCodeVisitor* base,
                                                     ValaLocalVariable* local);
static void vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base,
                                                       ValaInitializerList* list);
static void vala_symbol_resolver_real_visit_with_statement (ValaCodeVisitor* base,
                                                     ValaWithStatement* stmt);
static void vala_symbol_resolver_real_visit_expression_statement (ValaCodeVisitor* base,
                                                           ValaExpressionStatement* stmt);
static void vala_symbol_resolver_real_visit_if_statement (ValaCodeVisitor* base,
                                                   ValaIfStatement* stmt);
static void vala_symbol_resolver_real_visit_switch_statement (ValaCodeVisitor* base,
                                                       ValaSwitchStatement* stmt);
static void vala_symbol_resolver_real_visit_switch_section (ValaCodeVisitor* base,
                                                     ValaSwitchSection* section);
static void vala_symbol_resolver_real_visit_switch_label (ValaCodeVisitor* base,
                                                   ValaSwitchLabel* label);
static void vala_symbol_resolver_real_visit_loop_statement (ValaCodeVisitor* base,
                                                     ValaLoopStatement* stmt);
static void vala_symbol_resolver_real_visit_while_statement (ValaCodeVisitor* base,
                                                      ValaWhileStatement* stmt);
static void vala_symbol_resolver_real_visit_do_statement (ValaCodeVisitor* base,
                                                   ValaDoStatement* stmt);
static void vala_symbol_resolver_real_visit_for_statement (ValaCodeVisitor* base,
                                                    ValaForStatement* stmt);
static void vala_symbol_resolver_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                        ValaForeachStatement* stmt);
static void vala_symbol_resolver_real_visit_return_statement (ValaCodeVisitor* base,
                                                       ValaReturnStatement* stmt);
static void vala_symbol_resolver_real_visit_yield_statement (ValaCodeVisitor* base,
                                                      ValaYieldStatement* stmt);
static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base,
                                                      ValaThrowStatement* stmt);
static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base,
                                                    ValaTryStatement* stmt);
static void vala_symbol_resolver_real_visit_delete_statement (ValaCodeVisitor* base,
                                                       ValaDeleteStatement* stmt);
static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base,
                                                   ValaCatchClause* clause);
static void vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                                ValaArrayCreationExpression* e);
static void vala_symbol_resolver_real_visit_template (ValaCodeVisitor* base,
                                               ValaTemplate* tmpl);
static void vala_symbol_resolver_real_visit_tuple (ValaCodeVisitor* base,
                                            ValaTuple* tuple);
static void vala_symbol_resolver_real_visit_member_access (ValaCodeVisitor* base,
                                                    ValaMemberAccess* expr);
static void vala_symbol_resolver_real_visit_method_call (ValaCodeVisitor* base,
                                                  ValaMethodCall* expr);
static void vala_symbol_resolver_real_visit_element_access (ValaCodeVisitor* base,
                                                     ValaElementAccess* expr);
static void vala_symbol_resolver_real_visit_slice_expression (ValaCodeVisitor* base,
                                                       ValaSliceExpression* expr);
static void vala_symbol_resolver_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                         ValaPostfixExpression* expr);
static void vala_symbol_resolver_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                                 ValaObjectCreationExpression* expr);
static void vala_symbol_resolver_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                                        ValaSizeofExpression* expr);
static void vala_symbol_resolver_real_visit_typeof_expression (ValaCodeVisitor* base,
                                                        ValaTypeofExpression* expr);
static void vala_symbol_resolver_real_visit_unary_expression (ValaCodeVisitor* base,
                                                       ValaUnaryExpression* expr);
static void vala_symbol_resolver_real_visit_cast_expression (ValaCodeVisitor* base,
                                                      ValaCastExpression* expr);
static void vala_symbol_resolver_real_visit_named_argument (ValaCodeVisitor* base,
                                                     ValaNamedArgument* expr);
static void vala_symbol_resolver_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                          ValaPointerIndirection* expr);
static void vala_symbol_resolver_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                           ValaAddressofExpression* expr);
static void vala_symbol_resolver_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                                    ValaReferenceTransferExpression* expr);
static void vala_symbol_resolver_real_visit_binary_expression (ValaCodeVisitor* base,
                                                        ValaBinaryExpression* expr);
static void vala_symbol_resolver_real_visit_type_check (ValaCodeVisitor* base,
                                                 ValaTypeCheck* expr);
static void vala_symbol_resolver_real_visit_conditional_expression (ValaCodeVisitor* base,
                                                             ValaConditionalExpression* expr);
static void vala_symbol_resolver_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                        ValaLambdaExpression* l);
static void vala_symbol_resolver_real_visit_assignment (ValaCodeVisitor* base,
                                                 ValaAssignment* a);
static void vala_symbol_resolver_finalize (ValaCodeVisitor * obj);
static GType vala_symbol_resolver_get_type_once (void);

static inline gpointer
vala_symbol_resolver_get_instance_private (ValaSymbolResolver* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSymbolResolver_private_offset);
}

/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_symbol_resolver_resolve (ValaSymbolResolver* self,
                              ValaCodeContext* context)
{
	ValaNamespace* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = vala_code_context_get_root (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp1_);
	_vala_code_node_unref0 (self->priv->root_symbol);
	self->priv->root_symbol = _tmp2_;
	_tmp3_ = vala_code_context_get_root (context);
	_tmp4_ = _tmp3_;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
	_vala_code_node_unref0 (self->priv->root_symbol);
	self->priv->root_symbol = NULL;
}

static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}

static void
vala_symbol_resolver_real_visit_namespace (ValaCodeVisitor* base,
                                           ValaNamespace* ns)
{
	ValaSymbolResolver * self;
	ValaScope* old_scope = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->current_scope;
	_tmp1_ = _vala_scope_ref0 (_tmp0_);
	old_scope = _tmp1_;
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) ns);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
	_tmp5_ = _vala_scope_ref0 (old_scope);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp5_;
	_vala_scope_unref0 (old_scope);
}

static void
vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base,
                                       ValaClass* cl)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
	vala_class_set_base_class (cl, NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp5_ = vala_class_get_base_types (cl);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_type_index = _type_index + 1;
			_tmp9_ = _type_index;
			_tmp10_ = _type_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_index);
			type = (ValaDataType*) _tmp12_;
			_tmp13_ = type;
			_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
			_tmp15_ = _tmp14_;
			if (VALA_IS_CLASS (_tmp15_)) {
				ValaClass* _tmp16_;
				ValaClass* _tmp17_;
				ValaDataType* _tmp32_;
				ValaTypeSymbol* _tmp33_;
				ValaTypeSymbol* _tmp34_;
				ValaClass* _tmp35_;
				ValaClass* _tmp36_;
				_tmp16_ = vala_class_get_base_class (cl);
				_tmp17_ = _tmp16_;
				if (_tmp17_ != NULL) {
					ValaDataType* _tmp18_;
					ValaSourceReference* _tmp19_;
					ValaSourceReference* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					ValaClass* _tmp23_;
					ValaClass* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					ValaDataType* _tmp27_;
					ValaTypeSymbol* _tmp28_;
					ValaTypeSymbol* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
					_tmp18_ = type;
					_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) cl);
					_tmp22_ = _tmp21_;
					_tmp23_ = vala_class_get_base_class (cl);
					_tmp24_ = _tmp23_;
					_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = type;
					_tmp28_ = vala_data_type_get_type_symbol (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp29_);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp20_, "%s: Classes cannot have multiple base classes (`%s' and `%s')", _tmp22_, _tmp26_, _tmp31_);
					_g_free0 (_tmp31_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp22_);
					_vala_code_node_unref0 (type);
					return;
				}
				_tmp32_ = type;
				_tmp33_ = vala_data_type_get_type_symbol (_tmp32_);
				_tmp34_ = _tmp33_;
				vala_class_set_base_class (cl, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_CLASS, ValaClass));
				_tmp35_ = vala_class_get_base_class (cl);
				_tmp36_ = _tmp35_;
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp36_, (ValaTypeSymbol*) cl)) {
					ValaDataType* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaSourceReference* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					ValaClass* _tmp42_;
					ValaClass* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
					_tmp37_ = type;
					_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) cl);
					_tmp41_ = _tmp40_;
					_tmp42_ = vala_class_get_base_class (cl);
					_tmp43_ = _tmp42_;
					_tmp44_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp43_);
					_tmp45_ = _tmp44_;
					vala_report_error (_tmp39_, "Base class cycle (`%s' and `%s')", _tmp41_, _tmp45_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp41_);
					_vala_code_node_unref0 (type);
					return;
				}
			}
			_vala_code_node_unref0 (type);
		}
	}
	_tmp46_ = self->priv->current_scope;
	_tmp47_ = vala_scope_get_parent_scope (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = _vala_scope_ref0 (_tmp48_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp49_;
}

static void
vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base,
                                        ValaStruct* st)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) st);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	_tmp5_ = vala_struct_get_base_type (st);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaStruct* base_type = NULL;
		ValaStruct* _tmp7_;
		ValaStruct* _tmp8_;
		ValaStruct* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp7_ = vala_struct_get_base_struct (st);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (_tmp8_);
		base_type = _tmp9_;
		_tmp10_ = base_type;
		if (_tmp10_ != NULL) {
			ValaStruct* _tmp11_;
			_tmp11_ = base_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp11_, (ValaTypeSymbol*) st)) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaStruct* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				vala_code_node_set_error ((ValaCodeNode*) st, TRUE);
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) st);
				_tmp15_ = _tmp14_;
				_tmp16_ = base_type;
				_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				vala_report_error (_tmp13_, "Base struct cycle (`%s' and `%s')", _tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				_vala_code_node_unref0 (base_type);
				return;
			}
		}
		_vala_code_node_unref0 (base_type);
	}
	_tmp19_ = self->priv->current_scope;
	_tmp20_ = vala_scope_get_parent_scope (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_scope_ref0 (_tmp21_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp22_;
}

static void
vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base,
                                           ValaInterface* iface)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp30_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaScope* _tmp33_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) iface);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp5_ = vala_interface_get_prerequisites (iface);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValaDataType* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_type_index = _type_index + 1;
			_tmp9_ = _type_index;
			_tmp10_ = _type_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_index);
			type = (ValaDataType*) _tmp12_;
			_tmp14_ = type;
			_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ != NULL) {
				ValaDataType* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				_tmp17_ = type;
				_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp13_ = vala_typesymbol_is_subtype_of (_tmp19_, (ValaTypeSymbol*) iface);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				ValaDataType* _tmp20_;
				ValaSourceReference* _tmp21_;
				ValaSourceReference* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				ValaDataType* _tmp25_;
				ValaTypeSymbol* _tmp26_;
				ValaTypeSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) iface, TRUE);
				_tmp20_ = type;
				_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_symbol_get_full_name ((ValaSymbol*) iface);
				_tmp24_ = _tmp23_;
				_tmp25_ = type;
				_tmp26_ = vala_data_type_get_type_symbol (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp27_);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp22_, "Prerequisite cycle (`%s' and `%s')", _tmp24_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp24_);
				_vala_code_node_unref0 (type);
				return;
			}
			_vala_code_node_unref0 (type);
		}
	}
	_tmp30_ = self->priv->current_scope;
	_tmp31_ = vala_scope_get_parent_scope (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _vala_scope_ref0 (_tmp32_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp33_;
}

static void
vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base,
                                      ValaEnum* en)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) en);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}

static void
vala_symbol_resolver_real_visit_error_domain (ValaCodeVisitor* base,
                                              ValaErrorDomain* ed)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) ed);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) ed);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}

static void
vala_symbol_resolver_real_visit_delegate (ValaCodeVisitor* base,
                                          ValaDelegate* cb)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) cb);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) cb);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) cb, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}

static void
vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base,
                                          ValaConstant* c)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* old_scope = NULL;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_scope;
	_tmp3_ = _vala_scope_ref0 (_tmp2_);
	old_scope = _tmp3_;
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp5_ = _tmp4_;
	if (!VALA_IS_BLOCK (_tmp5_)) {
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp7_ = _tmp6_;
		_tmp8_ = _vala_scope_ref0 (_tmp7_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp8_;
	}
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) self);
	_tmp9_ = old_scope;
	_tmp10_ = _vala_scope_ref0 (_tmp9_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp10_;
	_vala_scope_unref0 (old_scope);
}

static void
vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* f)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) f);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) f, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}

static void
vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* m)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_scope_ref0 (_tmp3_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp4_;
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp5_ = self->priv->current_scope;
	_tmp6_ = vala_scope_get_parent_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_scope_ref0 (_tmp7_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp8_;
}

static void
vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base,
                                                 ValaCreationMethod* m)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base,
                                                  ValaParameter* p)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (p != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) p);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* prop)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base,
                                                   ValaPropertyAccessor* acc)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) acc);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) acc, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base,
                                        ValaSignal* sig)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base,
                                             ValaConstructor* c)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base,
                                            ValaDestructor* d)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) d);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_block (ValaCodeVisitor* base,
                                       ValaBlock* b)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) b);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_using_directive (ValaCodeVisitor* base,
                                                 ValaUsingDirective* ns)
{
	ValaSymbolResolver * self;
	ValaUnresolvedSymbol* unresolved_symbol = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaUnresolvedSymbol* _tmp2_;
	ValaUnresolvedSymbol* _tmp3_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_using_directive_get_namespace_symbol (ns);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_UNRESOLVED_SYMBOL (_tmp1_) ? ((ValaUnresolvedSymbol*) _tmp1_) : NULL);
	unresolved_symbol = _tmp2_;
	_tmp3_ = unresolved_symbol;
	if (_tmp3_ != NULL) {
		ValaUnresolvedSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp4_ = unresolved_symbol;
		_tmp5_ = vala_symbol_resolver_resolve_symbol (self, _tmp4_);
		_tmp6_ = _tmp5_;
		vala_using_directive_set_namespace_symbol (ns, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = vala_using_directive_get_namespace_symbol (ns);
		_tmp8_ = _tmp7_;
		if (!VALA_IS_NAMESPACE (_tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaUnresolvedSymbol* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) ns, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp10_ = _tmp9_;
			_tmp11_ = unresolved_symbol;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp10_, "The namespace name `%s' could not be found", _tmp13_);
			_g_free0 (_tmp13_);
			_vala_code_node_unref0 (unresolved_symbol);
			return;
		}
	}
	_vala_code_node_unref0 (unresolved_symbol);
}

static ValaSymbol*
vala_symbol_resolver_resolve_symbol (ValaSymbolResolver* self,
                                     ValaUnresolvedSymbol* unresolved_symbol)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (unresolved_symbol != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_qualified (unresolved_symbol);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaSymbol* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp2_ = self->priv->root_symbol;
		_tmp3_ = vala_symbol_get_scope (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_scope_lookup (_tmp4_, _tmp6_);
		result = _tmp7_;
		return result;
	} else {
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp8_ = vala_unresolved_symbol_get_inner (unresolved_symbol);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == NULL) {
			ValaSymbol* sym = NULL;
			ValaScope* scope = NULL;
			ValaScope* _tmp10_;
			ValaScope* _tmp11_;
			ValaObjectTypeSymbol* current_symbol = NULL;
			ValaSymbol* _tmp28_;
			ValaObjectTypeSymbol* _tmp43_;
			gboolean _tmp91_ = FALSE;
			ValaSymbol* _tmp92_;
			sym = NULL;
			_tmp10_ = self->priv->current_scope;
			_tmp11_ = _vala_scope_ref0 (_tmp10_);
			scope = _tmp11_;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				ValaSymbol* _tmp13_;
				ValaScope* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				ValaSymbol* _tmp18_;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				ValaSymbol* _tmp21_;
				ValaScope* _tmp24_;
				ValaScope* _tmp25_;
				ValaScope* _tmp26_;
				ValaScope* _tmp27_;
				_tmp13_ = sym;
				if (_tmp13_ == NULL) {
					ValaScope* _tmp14_;
					_tmp14_ = scope;
					_tmp12_ = _tmp14_ != NULL;
				} else {
					_tmp12_ = FALSE;
				}
				if (!_tmp12_) {
					break;
				}
				_tmp15_ = scope;
				_tmp16_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_scope_lookup (_tmp15_, _tmp17_);
				_vala_code_node_unref0 (sym);
				sym = _tmp18_;
				_tmp21_ = sym;
				if (VALA_IS_NAMESPACE (_tmp21_)) {
					_tmp20_ = TRUE;
				} else {
					ValaSymbol* _tmp22_;
					_tmp22_ = sym;
					_tmp20_ = VALA_IS_TYPESYMBOL (_tmp22_);
				}
				if (_tmp20_) {
					_tmp19_ = TRUE;
				} else {
					ValaSymbol* _tmp23_;
					_tmp23_ = sym;
					_tmp19_ = VALA_IS_TYPEPARAMETER (_tmp23_);
				}
				if (!_tmp19_) {
					_vala_code_node_unref0 (sym);
					sym = NULL;
				}
				_tmp24_ = scope;
				_tmp25_ = vala_scope_get_parent_scope (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = _vala_scope_ref0 (_tmp26_);
				_vala_scope_unref0 (scope);
				scope = _tmp27_;
			}
			current_symbol = NULL;
			_tmp28_ = sym;
			if (_tmp28_ == NULL) {
				ValaScope* _tmp29_;
				ValaScope* _tmp30_;
				_tmp29_ = self->priv->current_scope;
				_tmp30_ = _vala_scope_ref0 (_tmp29_);
				_vala_scope_unref0 (scope);
				scope = _tmp30_;
				while (TRUE) {
					ValaScope* _tmp31_;
					ValaScope* _tmp32_;
					ValaSymbol* _tmp33_;
					ValaSymbol* _tmp34_;
					ValaScope* _tmp39_;
					ValaScope* _tmp40_;
					ValaScope* _tmp41_;
					ValaScope* _tmp42_;
					_tmp31_ = scope;
					if (!(_tmp31_ != NULL)) {
						break;
					}
					_tmp32_ = scope;
					_tmp33_ = vala_scope_get_owner (_tmp32_);
					_tmp34_ = _tmp33_;
					if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp34_)) {
						ValaScope* _tmp35_;
						ValaSymbol* _tmp36_;
						ValaSymbol* _tmp37_;
						ValaObjectTypeSymbol* _tmp38_;
						_tmp35_ = scope;
						_tmp36_ = vala_scope_get_owner (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
						_vala_code_node_unref0 (current_symbol);
						current_symbol = _tmp38_;
						break;
					}
					_tmp39_ = scope;
					_tmp40_ = vala_scope_get_parent_scope (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = _vala_scope_ref0 (_tmp41_);
					_vala_scope_unref0 (scope);
					scope = _tmp42_;
				}
			}
			_tmp43_ = current_symbol;
			if (_tmp43_ != NULL) {
				ValaList* types = NULL;
				ValaObjectTypeSymbol* _tmp44_;
				_tmp44_ = current_symbol;
				if (VALA_IS_CLASS (_tmp44_)) {
					ValaObjectTypeSymbol* _tmp45_;
					ValaList* _tmp46_;
					_tmp45_ = current_symbol;
					_tmp46_ = vala_class_get_base_types (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CLASS, ValaClass));
					types = _tmp46_;
				} else {
					ValaObjectTypeSymbol* _tmp47_;
					_tmp47_ = current_symbol;
					if (VALA_IS_INTERFACE (_tmp47_)) {
						ValaObjectTypeSymbol* _tmp48_;
						ValaList* _tmp49_;
						_tmp48_ = current_symbol;
						_tmp49_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_INTERFACE, ValaInterface));
						types = _tmp49_;
					} else {
						g_assert_not_reached ();
					}
				}
				{
					ValaList* _type_list = NULL;
					ValaList* _tmp50_;
					gint _type_size = 0;
					ValaList* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					gint _type_index = 0;
					_tmp50_ = types;
					_type_list = _tmp50_;
					_tmp51_ = _type_list;
					_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
					_tmp53_ = _tmp52_;
					_type_size = _tmp53_;
					_type_index = -1;
					while (TRUE) {
						gint _tmp54_;
						gint _tmp55_;
						ValaDataType* type = NULL;
						ValaList* _tmp56_;
						gpointer _tmp57_;
						ValaDataType* _tmp58_;
						ValaTypeSymbol* _tmp59_;
						ValaTypeSymbol* _tmp60_;
						ValaSymbol* local_sym = NULL;
						ValaDataType* _tmp61_;
						ValaTypeSymbol* _tmp62_;
						ValaTypeSymbol* _tmp63_;
						const gchar* _tmp64_;
						const gchar* _tmp65_;
						ValaSymbol* _tmp66_;
						gboolean _tmp67_ = FALSE;
						ValaSymbol* _tmp68_;
						gboolean _tmp70_ = FALSE;
						ValaSymbol* _tmp71_;
						_type_index = _type_index + 1;
						_tmp54_ = _type_index;
						_tmp55_ = _type_size;
						if (!(_tmp54_ < _tmp55_)) {
							break;
						}
						_tmp56_ = _type_list;
						_tmp57_ = vala_list_get (_tmp56_, _type_index);
						type = (ValaDataType*) _tmp57_;
						_tmp58_ = type;
						_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
						_tmp60_ = _tmp59_;
						if (_tmp60_ == NULL) {
							_vala_code_node_unref0 (type);
							continue;
						}
						_tmp61_ = type;
						_tmp62_ = vala_data_type_get_type_symbol (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
						_tmp65_ = _tmp64_;
						_tmp66_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp63_, _tmp65_);
						local_sym = _tmp66_;
						_tmp68_ = local_sym;
						if (VALA_IS_NAMESPACE (_tmp68_)) {
							_tmp67_ = TRUE;
						} else {
							ValaSymbol* _tmp69_;
							_tmp69_ = local_sym;
							_tmp67_ = VALA_IS_TYPESYMBOL (_tmp69_);
						}
						if (!_tmp67_) {
							_vala_code_node_unref0 (local_sym);
							local_sym = NULL;
						}
						_tmp71_ = local_sym;
						if (_tmp71_ != NULL) {
							ValaSymbol* _tmp72_;
							ValaSymbolAccessibility _tmp73_;
							ValaSymbolAccessibility _tmp74_;
							_tmp72_ = local_sym;
							_tmp73_ = vala_symbol_get_access (_tmp72_);
							_tmp74_ = _tmp73_;
							_tmp70_ = _tmp74_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
						} else {
							_tmp70_ = FALSE;
						}
						if (_tmp70_) {
							gboolean _tmp75_ = FALSE;
							ValaSymbol* _tmp76_;
							ValaSymbol* _tmp89_;
							ValaSymbol* _tmp90_;
							_tmp76_ = sym;
							if (_tmp76_ != NULL) {
								ValaSymbol* _tmp77_;
								ValaSymbol* _tmp78_;
								_tmp77_ = sym;
								_tmp78_ = local_sym;
								_tmp75_ = _tmp77_ != _tmp78_;
							} else {
								_tmp75_ = FALSE;
							}
							if (_tmp75_) {
								ValaSourceReference* _tmp79_;
								ValaSourceReference* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								ValaSymbol* _tmp83_;
								gchar* _tmp84_;
								gchar* _tmp85_;
								ValaSymbol* _tmp86_;
								gchar* _tmp87_;
								gchar* _tmp88_;
								vala_code_node_set_error ((ValaCodeNode*) unresolved_symbol, TRUE);
								_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_symbol);
								_tmp80_ = _tmp79_;
								_tmp81_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
								_tmp82_ = _tmp81_;
								_tmp83_ = sym;
								_tmp84_ = vala_symbol_get_full_name (_tmp83_);
								_tmp85_ = _tmp84_;
								_tmp86_ = local_sym;
								_tmp87_ = vala_symbol_get_full_name (_tmp86_);
								_tmp88_ = _tmp87_;
								vala_report_error (_tmp80_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp82_, _tmp85_, _tmp88_);
								_g_free0 (_tmp88_);
								_g_free0 (_tmp85_);
								result = NULL;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (type);
								_vala_code_node_unref0 (current_symbol);
								_vala_scope_unref0 (scope);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_tmp89_ = local_sym;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (sym);
							sym = _tmp90_;
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (type);
					}
				}
			}
			_tmp92_ = sym;
			if (_tmp92_ == NULL) {
				ValaSourceReference* _tmp93_;
				ValaSourceReference* _tmp94_;
				_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_symbol);
				_tmp94_ = _tmp93_;
				_tmp91_ = _tmp94_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp95_;
					ValaSourceReference* _tmp96_;
					ValaList* _tmp97_;
					ValaList* _tmp98_;
					gint _ns_size = 0;
					ValaList* _tmp99_;
					gint _tmp100_;
					gint _tmp101_;
					gint _ns_index = 0;
					_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_symbol);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_source_reference_get_using_directives (_tmp96_);
					_tmp98_ = _tmp97_;
					_ns_list = _tmp98_;
					_tmp99_ = _ns_list;
					_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
					_tmp101_ = _tmp100_;
					_ns_size = _tmp101_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp102_;
						gint _tmp103_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp104_;
						gpointer _tmp105_;
						gboolean _tmp106_ = FALSE;
						ValaUsingDirective* _tmp107_;
						gboolean _tmp108_;
						gboolean _tmp109_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp113_;
						ValaSymbol* _tmp114_;
						ValaSymbol* _tmp115_;
						ValaScope* _tmp116_;
						ValaScope* _tmp117_;
						const gchar* _tmp118_;
						const gchar* _tmp119_;
						ValaSymbol* _tmp120_;
						gboolean _tmp121_ = FALSE;
						gboolean _tmp122_ = FALSE;
						ValaSymbol* _tmp123_;
						ValaSymbol* _tmp126_;
						_ns_index = _ns_index + 1;
						_tmp102_ = _ns_index;
						_tmp103_ = _ns_size;
						if (!(_tmp102_ < _tmp103_)) {
							break;
						}
						_tmp104_ = _ns_list;
						_tmp105_ = vala_list_get (_tmp104_, _ns_index);
						ns = (ValaUsingDirective*) _tmp105_;
						_tmp107_ = ns;
						_tmp108_ = vala_code_node_get_error ((ValaCodeNode*) _tmp107_);
						_tmp109_ = _tmp108_;
						if (_tmp109_) {
							_tmp106_ = TRUE;
						} else {
							ValaUsingDirective* _tmp110_;
							ValaSymbol* _tmp111_;
							ValaSymbol* _tmp112_;
							_tmp110_ = ns;
							_tmp111_ = vala_using_directive_get_namespace_symbol (_tmp110_);
							_tmp112_ = _tmp111_;
							_tmp106_ = VALA_IS_UNRESOLVED_SYMBOL (_tmp112_);
						}
						if (_tmp106_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp113_ = ns;
						_tmp114_ = vala_using_directive_get_namespace_symbol (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_symbol_get_scope (_tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_scope_lookup (_tmp117_, _tmp119_);
						local_sym = _tmp120_;
						_tmp123_ = local_sym;
						if (VALA_IS_NAMESPACE (_tmp123_)) {
							_tmp122_ = TRUE;
						} else {
							ValaSymbol* _tmp124_;
							_tmp124_ = local_sym;
							_tmp122_ = VALA_IS_TYPESYMBOL (_tmp124_);
						}
						if (_tmp122_) {
							_tmp121_ = TRUE;
						} else {
							ValaSymbol* _tmp125_;
							_tmp125_ = sym;
							_tmp121_ = VALA_IS_TYPEPARAMETER (_tmp125_);
						}
						if (!_tmp121_) {
							_vala_code_node_unref0 (local_sym);
							local_sym = NULL;
						}
						_tmp126_ = local_sym;
						if (_tmp126_ != NULL) {
							gboolean _tmp127_ = FALSE;
							ValaSymbol* _tmp128_;
							ValaSymbol* _tmp141_;
							ValaSymbol* _tmp142_;
							_tmp128_ = sym;
							if (_tmp128_ != NULL) {
								ValaSymbol* _tmp129_;
								ValaSymbol* _tmp130_;
								_tmp129_ = sym;
								_tmp130_ = local_sym;
								_tmp127_ = _tmp129_ != _tmp130_;
							} else {
								_tmp127_ = FALSE;
							}
							if (_tmp127_) {
								ValaSourceReference* _tmp131_;
								ValaSourceReference* _tmp132_;
								const gchar* _tmp133_;
								const gchar* _tmp134_;
								ValaSymbol* _tmp135_;
								gchar* _tmp136_;
								gchar* _tmp137_;
								ValaSymbol* _tmp138_;
								gchar* _tmp139_;
								gchar* _tmp140_;
								vala_code_node_set_error ((ValaCodeNode*) unresolved_symbol, TRUE);
								_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_symbol);
								_tmp132_ = _tmp131_;
								_tmp133_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
								_tmp134_ = _tmp133_;
								_tmp135_ = sym;
								_tmp136_ = vala_symbol_get_full_name (_tmp135_);
								_tmp137_ = _tmp136_;
								_tmp138_ = local_sym;
								_tmp139_ = vala_symbol_get_full_name (_tmp138_);
								_tmp140_ = _tmp139_;
								vala_report_error (_tmp132_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp134_, _tmp137_, _tmp140_);
								_g_free0 (_tmp140_);
								_g_free0 (_tmp137_);
								result = NULL;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_code_node_unref0 (current_symbol);
								_vala_scope_unref0 (scope);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_tmp141_ = local_sym;
							_tmp142_ = _vala_code_node_ref0 (_tmp141_);
							_vala_code_node_unref0 (sym);
							sym = _tmp142_;
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
			result = sym;
			_vala_code_node_unref0 (current_symbol);
			_vala_scope_unref0 (scope);
			return result;
		} else {
			ValaSymbol* parent_symbol = NULL;
			ValaUnresolvedSymbol* _tmp143_;
			ValaUnresolvedSymbol* _tmp144_;
			ValaSymbol* _tmp145_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp155_;
			ValaSymbol* _tmp156_;
			ValaScope* _tmp157_;
			ValaScope* _tmp158_;
			const gchar* _tmp159_;
			const gchar* _tmp160_;
			ValaSymbol* _tmp161_;
			_tmp143_ = vala_unresolved_symbol_get_inner (unresolved_symbol);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_symbol_resolver_resolve_symbol (self, _tmp144_);
			parent_symbol = _tmp145_;
			_tmp146_ = parent_symbol;
			if (_tmp146_ == NULL) {
				ValaUnresolvedSymbol* _tmp147_;
				ValaUnresolvedSymbol* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaUnresolvedSymbol* _tmp151_;
				ValaUnresolvedSymbol* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				vala_code_node_set_error ((ValaCodeNode*) unresolved_symbol, TRUE);
				_tmp147_ = vala_unresolved_symbol_get_inner (unresolved_symbol);
				_tmp148_ = _tmp147_;
				_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = vala_unresolved_symbol_get_inner (unresolved_symbol);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
				_tmp154_ = _tmp153_;
				vala_report_error (_tmp150_, "The symbol `%s' could not be found", _tmp154_);
				result = NULL;
				_vala_code_node_unref0 (parent_symbol);
				return result;
			}
			_tmp155_ = parent_symbol;
			vala_symbol_set_used (_tmp155_, TRUE);
			_tmp156_ = parent_symbol;
			_tmp157_ = vala_symbol_get_scope (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_symbol_get_name ((ValaSymbol*) unresolved_symbol);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_scope_lookup (_tmp158_, _tmp160_);
			result = _tmp161_;
			_vala_code_node_unref0 (parent_symbol);
			return result;
		}
	}
}

static gboolean
vala_symbol_resolver_has_base_struct_cycle (ValaSymbolResolver* self,
                                            ValaStruct* st,
                                            ValaStruct* loop_st)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaUnresolvedSymbol* _tmp4_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaStruct* base_struct = NULL;
	ValaSymbol* _tmp7_;
	ValaStruct* _tmp8_;
	ValaStruct* _tmp9_;
	ValaStruct* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (st != NULL, FALSE);
	g_return_val_if_fail (loop_st != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_type (st);
	_tmp1_ = _tmp0_;
	if (!VALA_IS_UNRESOLVED_TYPE (_tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_struct_get_base_type (st);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_resolver_resolve_symbol (self, _tmp5_);
	sym = _tmp6_;
	_tmp7_ = sym;
	base_struct = VALA_IS_STRUCT (_tmp7_) ? ((ValaStruct*) _tmp7_) : NULL;
	_tmp8_ = base_struct;
	if (_tmp8_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (sym);
		return result;
	}
	_tmp9_ = base_struct;
	if (_tmp9_ == loop_st) {
		result = TRUE;
		_vala_code_node_unref0 (sym);
		return result;
	}
	_tmp10_ = base_struct;
	result = vala_symbol_resolver_has_base_struct_cycle (self, _tmp10_, loop_st);
	_vala_code_node_unref0 (sym);
	return result;
}

static ValaDataType*
vala_symbol_resolver_get_type_for_struct (ValaSymbolResolver* self,
                                          ValaStruct* st,
                                          ValaStruct* base_struct)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaStruct* _tmp16_;
	ValaStruct* _tmp17_;
	ValaAttribute* _tmp21_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (base_struct != NULL, NULL);
	_tmp0_ = vala_struct_get_base_type (st);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		ValaScope* old_scope = NULL;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		if (vala_symbol_resolver_has_base_struct_cycle (self, st, st)) {
			ValaStructValueType* _tmp2_;
			_tmp2_ = vala_struct_value_type_new (st);
			result = (ValaDataType*) _tmp2_;
			return result;
		}
		_tmp3_ = self->priv->current_scope;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) st);
		_tmp5_ = _tmp4_;
		if (_tmp3_ == _tmp5_) {
			ValaStructValueType* _tmp6_;
			_tmp6_ = vala_struct_value_type_new (st);
			result = (ValaDataType*) _tmp6_;
			return result;
		}
		_tmp7_ = self->priv->current_scope;
		_tmp8_ = _vala_scope_ref0 (_tmp7_);
		old_scope = _tmp8_;
		_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) st);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_scope_ref0 (_tmp10_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp11_;
		_tmp12_ = vala_struct_get_base_type (st);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, (ValaCodeVisitor*) self);
		_tmp14_ = old_scope;
		_tmp15_ = _vala_scope_ref0 (_tmp14_);
		_vala_scope_unref0 (self->priv->current_scope);
		self->priv->current_scope = _tmp15_;
		_vala_scope_unref0 (old_scope);
	}
	_tmp16_ = vala_struct_get_base_struct (base_struct);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaStruct* _tmp18_;
		ValaStruct* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = vala_struct_get_base_struct (base_struct);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_resolver_get_type_for_struct (self, st, _tmp19_);
		result = _tmp20_;
		return result;
	}
	_tmp21_ = vala_code_node_get_attribute ((ValaCodeNode*) base_struct, "BooleanType");
	if (_tmp21_ != NULL) {
		ValaBooleanType* _tmp22_;
		_tmp22_ = vala_boolean_type_new (st);
		result = (ValaDataType*) _tmp22_;
		return result;
	} else {
		ValaAttribute* _tmp23_;
		_tmp23_ = vala_code_node_get_attribute ((ValaCodeNode*) base_struct, "IntegerType");
		if (_tmp23_ != NULL) {
			ValaIntegerType* _tmp24_;
			_tmp24_ = vala_integer_type_new (st, NULL, NULL);
			result = (ValaDataType*) _tmp24_;
			return result;
		} else {
			ValaAttribute* _tmp25_;
			_tmp25_ = vala_code_node_get_attribute ((ValaCodeNode*) base_struct, "FloatingType");
			if (_tmp25_ != NULL) {
				ValaFloatingType* _tmp26_;
				_tmp26_ = vala_floating_type_new (st);
				result = (ValaDataType*) _tmp26_;
				return result;
			} else {
				ValaStructValueType* _tmp27_;
				_tmp27_ = vala_struct_value_type_new (st);
				result = (ValaDataType*) _tmp27_;
				return result;
			}
		}
	}
}

static ValaDataType*
vala_symbol_resolver_resolve_type (ValaSymbolResolver* self,
                                   ValaUnresolvedType* unresolved_type)
{
	ValaDataType* type = NULL;
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* sym = NULL;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp20_;
	ValaDataType* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaDataType* _tmp75_;
	gboolean _tmp76_;
	gboolean _tmp77_;
	ValaSymbol* _tmp78_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (unresolved_type != NULL, NULL);
	type = NULL;
	_tmp0_ = vala_unresolved_type_get_unresolved_symbol (unresolved_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "void") == 0) {
		ValaVoidType* _tmp4_;
		_tmp4_ = vala_void_type_new (NULL);
		result = (ValaDataType*) _tmp4_;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp5_ = vala_unresolved_type_get_unresolved_symbol (unresolved_type);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_resolver_resolve_symbol (self, _tmp6_);
	sym = _tmp7_;
	_tmp8_ = sym;
	if (_tmp8_ == NULL) {
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		ValaInvalidType* _tmp19_;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (unresolved_type);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (!_tmp12_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaUnresolvedSymbol* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_unresolved_type_get_unresolved_symbol (unresolved_type);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_code_node_to_string ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			vala_report_error (_tmp14_, "The type name `%s' could not be found", _tmp18_);
			_g_free0 (_tmp18_);
		}
		_tmp19_ = vala_invalid_type_new ();
		result = (ValaDataType*) _tmp19_;
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp20_ = sym;
	if (VALA_IS_TYPEPARAMETER (_tmp20_)) {
		ValaSymbol* _tmp21_;
		ValaGenericType* _tmp22_;
		_tmp21_ = sym;
		_tmp22_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp22_;
	} else {
		ValaSymbol* _tmp23_;
		_tmp23_ = sym;
		if (VALA_IS_TYPESYMBOL (_tmp23_)) {
			ValaSymbol* _tmp24_;
			_tmp24_ = sym;
			if (VALA_IS_DELEGATE (_tmp24_)) {
				ValaSymbol* _tmp25_;
				ValaDelegateType* _tmp26_;
				_tmp25_ = sym;
				_tmp26_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_DELEGATE, ValaDelegate));
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp26_;
			} else {
				ValaSymbol* _tmp27_;
				_tmp27_ = sym;
				if (VALA_IS_CLASS (_tmp27_)) {
					ValaClass* cl = NULL;
					ValaSymbol* _tmp28_;
					ValaClass* _tmp29_;
					gboolean _tmp30_;
					gboolean _tmp31_;
					_tmp28_ = sym;
					cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass);
					_tmp29_ = cl;
					_tmp30_ = vala_class_get_is_error_base (_tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp31_) {
						ValaSourceReference* _tmp32_;
						ValaSourceReference* _tmp33_;
						ValaErrorType* _tmp34_;
						_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_error_type_new (NULL, NULL, _tmp33_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp34_;
					} else {
						ValaClass* _tmp35_;
						ValaObjectType* _tmp36_;
						_tmp35_ = cl;
						_tmp36_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp35_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp36_;
					}
				} else {
					ValaSymbol* _tmp37_;
					_tmp37_ = sym;
					if (VALA_IS_INTERFACE (_tmp37_)) {
						ValaSymbol* _tmp38_;
						ValaObjectType* _tmp39_;
						_tmp38_ = sym;
						_tmp39_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_INTERFACE, ValaInterface));
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp39_;
					} else {
						ValaSymbol* _tmp40_;
						_tmp40_ = sym;
						if (VALA_IS_STRUCT (_tmp40_)) {
							ValaSymbol* _tmp41_;
							ValaSymbol* _tmp42_;
							ValaDataType* _tmp43_;
							_tmp41_ = sym;
							_tmp42_ = sym;
							_tmp43_ = vala_symbol_resolver_get_type_for_struct (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_STRUCT, ValaStruct), G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, VALA_TYPE_STRUCT, ValaStruct));
							_vala_code_node_unref0 (type);
							type = _tmp43_;
						} else {
							ValaSymbol* _tmp44_;
							_tmp44_ = sym;
							if (VALA_IS_ENUM (_tmp44_)) {
								ValaSymbol* _tmp45_;
								ValaEnumValueType* _tmp46_;
								_tmp45_ = sym;
								_tmp46_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_ENUM, ValaEnum));
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp46_;
							} else {
								ValaSymbol* _tmp47_;
								_tmp47_ = sym;
								if (VALA_IS_ERROR_DOMAIN (_tmp47_)) {
									ValaSymbol* _tmp48_;
									ValaSourceReference* _tmp49_;
									ValaSourceReference* _tmp50_;
									ValaErrorType* _tmp51_;
									_tmp48_ = sym;
									_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
									_tmp50_ = _tmp49_;
									_tmp51_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), NULL, _tmp50_);
									_vala_code_node_unref0 (type);
									type = (ValaDataType*) _tmp51_;
								} else {
									ValaSymbol* _tmp52_;
									_tmp52_ = sym;
									if (VALA_IS_ERROR_CODE (_tmp52_)) {
										ValaSymbol* _tmp53_;
										ValaSymbol* _tmp54_;
										ValaSymbol* _tmp55_;
										ValaSymbol* _tmp56_;
										ValaSourceReference* _tmp57_;
										ValaSourceReference* _tmp58_;
										ValaErrorType* _tmp59_;
										_tmp53_ = sym;
										_tmp54_ = vala_symbol_get_parent_symbol (_tmp53_);
										_tmp55_ = _tmp54_;
										_tmp56_ = sym;
										_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
										_tmp58_ = _tmp57_;
										_tmp59_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp58_);
										_vala_code_node_unref0 (type);
										type = (ValaDataType*) _tmp59_;
									} else {
										ValaSourceReference* _tmp60_;
										ValaSourceReference* _tmp61_;
										ValaSymbol* _tmp62_;
										gchar* _tmp63_;
										gchar* _tmp64_;
										ValaInvalidType* _tmp65_;
										_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
										_tmp61_ = _tmp60_;
										_tmp62_ = sym;
										_tmp63_ = vala_symbol_get_full_name (_tmp62_);
										_tmp64_ = _tmp63_;
										vala_report_error (_tmp61_, "internal error: `%s' is not a supported type", _tmp64_);
										_g_free0 (_tmp64_);
										_tmp65_ = vala_invalid_type_new ();
										result = (ValaDataType*) _tmp65_;
										_vala_code_node_unref0 (sym);
										_vala_code_node_unref0 (type);
										return result;
									}
								}
							}
						}
					}
				}
			}
		} else {
			ValaSourceReference* _tmp66_;
			ValaSourceReference* _tmp67_;
			ValaSymbol* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			ValaInvalidType* _tmp71_;
			_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
			_tmp67_ = _tmp66_;
			_tmp68_ = sym;
			_tmp69_ = vala_symbol_get_full_name (_tmp68_);
			_tmp70_ = _tmp69_;
			vala_report_error (_tmp67_, "`%s' is not a type", _tmp70_);
			_g_free0 (_tmp70_);
			_tmp71_ = vala_invalid_type_new ();
			result = (ValaDataType*) _tmp71_;
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp72_ = type;
	_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_type);
	_tmp74_ = _tmp73_;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp74_);
	_tmp75_ = type;
	_tmp76_ = vala_data_type_get_value_owned ((ValaDataType*) unresolved_type);
	_tmp77_ = _tmp76_;
	vala_data_type_set_value_owned (_tmp75_, _tmp77_);
	_tmp78_ = sym;
	vala_symbol_set_used (_tmp78_, TRUE);
	_tmp79_ = type;
	if (VALA_IS_GENERIC_TYPE (_tmp79_)) {
		ValaDataType* _tmp80_;
		_tmp80_ = type;
		vala_data_type_set_nullable (_tmp80_, TRUE);
	} else {
		ValaDataType* _tmp81_;
		gboolean _tmp82_;
		gboolean _tmp83_;
		_tmp81_ = type;
		_tmp82_ = vala_data_type_get_nullable ((ValaDataType*) unresolved_type);
		_tmp83_ = _tmp82_;
		vala_data_type_set_nullable (_tmp81_, _tmp83_);
	}
	_tmp84_ = type;
	_tmp85_ = vala_data_type_get_is_dynamic ((ValaDataType*) unresolved_type);
	_tmp86_ = _tmp85_;
	vala_data_type_set_is_dynamic (_tmp84_, _tmp86_);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp87_;
		gint _type_arg_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _type_arg_index = 0;
		_tmp87_ = vala_data_type_get_type_arguments ((ValaDataType*) unresolved_type);
		_type_arg_list = _tmp87_;
		_tmp88_ = _type_arg_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_type_arg_size = _tmp90_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp93_;
			gpointer _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			_type_arg_index = _type_arg_index + 1;
			_tmp91_ = _type_arg_index;
			_tmp92_ = _type_arg_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_list_get (_tmp93_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp94_;
			_tmp95_ = type;
			_tmp96_ = type_arg;
			vala_data_type_add_type_argument (_tmp95_, _tmp96_);
			_vala_code_node_unref0 (type_arg);
		}
	}
	result = type;
	_vala_code_node_unref0 (sym);
	return result;
}

static void
vala_symbol_resolver_real_visit_data_type (ValaCodeVisitor* base,
                                           ValaDataType* data_type)
{
	ValaSymbolResolver * self;
	ValaUnresolvedType* unresolved_type = NULL;
	ValaUnresolvedType* _tmp0_;
	ValaUnresolvedType* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaUnresolvedType* _tmp4_;
	ValaUnresolvedType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (data_type != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) data_type, (ValaCodeVisitor*) self);
	if (!VALA_IS_UNRESOLVED_TYPE (data_type)) {
		return;
	}
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (data_type, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
	unresolved_type = _tmp0_;
	_tmp1_ = unresolved_type;
	_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = unresolved_type;
	_tmp5_ = unresolved_type;
	_tmp6_ = vala_symbol_resolver_resolve_type (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_code_node_replace_type (_tmp3_, (ValaDataType*) _tmp4_, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (unresolved_type);
}

static void
vala_symbol_resolver_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                       ValaDeclarationStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_local_variable (ValaCodeVisitor* base,
                                                ValaLocalVariable* local)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) local, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base,
                                                  ValaInitializerList* list)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) list);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) list, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_with_statement (ValaCodeVisitor* base,
                                                ValaWithStatement* stmt)
{
	ValaSymbolResolver * self;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_expression_statement (ValaCodeVisitor* base,
                                                      ValaExpressionStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_if_statement (ValaCodeVisitor* base,
                                              ValaIfStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_switch_statement (ValaCodeVisitor* base,
                                                  ValaSwitchStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_switch_section (ValaCodeVisitor* base,
                                                ValaSwitchSection* section)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (section != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) section);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) section, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_switch_label (ValaCodeVisitor* base,
                                              ValaSwitchLabel* label)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (label != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) label);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) label, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_loop_statement (ValaCodeVisitor* base,
                                                ValaLoopStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_while_statement (ValaCodeVisitor* base,
                                                 ValaWhileStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_do_statement (ValaCodeVisitor* base,
                                              ValaDoStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_for_statement (ValaCodeVisitor* base,
                                               ValaForStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                   ValaForeachStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_return_statement (ValaCodeVisitor* base,
                                                  ValaReturnStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_yield_statement (ValaCodeVisitor* base,
                                                 ValaYieldStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base,
                                                 ValaThrowStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base,
                                               ValaTryStatement* stmt)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_delete_statement (ValaCodeVisitor* base,
                                                  ValaDeleteStatement* stmt)
{
	ValaSymbolResolver * self;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base,
                                              ValaCatchClause* clause)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (clause != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) clause);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) clause, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                           ValaArrayCreationExpression* e)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (e != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) e);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) e, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_template (ValaCodeVisitor* base,
                                          ValaTemplate* tmpl)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (tmpl != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) tmpl);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) tmpl, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_tuple (ValaCodeVisitor* base,
                                       ValaTuple* tuple)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (tuple != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) tuple);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) tuple, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_member_access (ValaCodeVisitor* base,
                                               ValaMemberAccess* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_method_call (ValaCodeVisitor* base,
                                             ValaMethodCall* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_element_access (ValaCodeVisitor* base,
                                                ValaElementAccess* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_slice_expression (ValaCodeVisitor* base,
                                                  ValaSliceExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                    ValaPostfixExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                            ValaObjectCreationExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                                   ValaSizeofExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_typeof_expression (ValaCodeVisitor* base,
                                                   ValaTypeofExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_unary_expression (ValaCodeVisitor* base,
                                                  ValaUnaryExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_cast_expression (ValaCodeVisitor* base,
                                                 ValaCastExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_named_argument (ValaCodeVisitor* base,
                                                ValaNamedArgument* expr)
{
	ValaSymbolResolver * self;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                     ValaPointerIndirection* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                      ValaAddressofExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                               ValaReferenceTransferExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_binary_expression (ValaCodeVisitor* base,
                                                   ValaBinaryExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_type_check (ValaCodeVisitor* base,
                                            ValaTypeCheck* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_conditional_expression (ValaCodeVisitor* base,
                                                        ValaConditionalExpression* expr)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                   ValaLambdaExpression* l)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (l != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) l);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) l, (ValaCodeVisitor*) self);
}

static void
vala_symbol_resolver_real_visit_assignment (ValaCodeVisitor* base,
                                            ValaAssignment* a)
{
	ValaSymbolResolver * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaSymbolResolver*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) a);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) a, (ValaCodeVisitor*) self);
}

ValaSymbolResolver*
vala_symbol_resolver_construct (GType object_type)
{
	ValaSymbolResolver* self = NULL;
	self = (ValaSymbolResolver*) vala_code_visitor_construct (object_type);
	return self;
}

ValaSymbolResolver*
vala_symbol_resolver_new (void)
{
	return vala_symbol_resolver_construct (VALA_TYPE_SYMBOL_RESOLVER);
}

static void
vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass,
                                 gpointer klass_data)
{
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_symbol_resolver_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSymbolResolver_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_symbol_resolver_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_symbol_resolver_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_symbol_resolver_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_symbol_resolver_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_symbol_resolver_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_symbol_resolver_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_symbol_resolver_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) vala_symbol_resolver_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_symbol_resolver_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_symbol_resolver_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_symbol_resolver_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_formal_parameter = (void (*) (ValaCodeVisitor*, ValaParameter*)) vala_symbol_resolver_real_visit_formal_parameter;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_symbol_resolver_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor*, ValaPropertyAccessor*)) vala_symbol_resolver_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_symbol_resolver_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_symbol_resolver_real_visit_constructor;
	((ValaCodeVisitorClass *) klass)->visit_destructor = (void (*) (ValaCodeVisitor*, ValaDestructor*)) vala_symbol_resolver_real_visit_destructor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor*, ValaBlock*)) vala_symbol_resolver_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_using_directive = (void (*) (ValaCodeVisitor*, ValaUsingDirective*)) vala_symbol_resolver_real_visit_using_directive;
	((ValaCodeVisitorClass *) klass)->visit_data_type = (void (*) (ValaCodeVisitor*, ValaDataType*)) vala_symbol_resolver_real_visit_data_type;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor*, ValaDeclarationStatement*)) vala_symbol_resolver_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor*, ValaLocalVariable*)) vala_symbol_resolver_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_initializer_list = (void (*) (ValaCodeVisitor*, ValaInitializerList*)) vala_symbol_resolver_real_visit_initializer_list;
	((ValaCodeVisitorClass *) klass)->visit_with_statement = (void (*) (ValaCodeVisitor*, ValaWithStatement*)) vala_symbol_resolver_real_visit_with_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor*, ValaExpressionStatement*)) vala_symbol_resolver_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor*, ValaIfStatement*)) vala_symbol_resolver_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor*, ValaSwitchStatement*)) vala_symbol_resolver_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_section = (void (*) (ValaCodeVisitor*, ValaSwitchSection*)) vala_symbol_resolver_real_visit_switch_section;
	((ValaCodeVisitorClass *) klass)->visit_switch_label = (void (*) (ValaCodeVisitor*, ValaSwitchLabel*)) vala_symbol_resolver_real_visit_switch_label;
	((ValaCodeVisitorClass *) klass)->visit_loop_statement = (void (*) (ValaCodeVisitor*, ValaLoopStatement*)) vala_symbol_resolver_real_visit_loop_statement;
	((ValaCodeVisitorClass *) klass)->visit_while_statement = (void (*) (ValaCodeVisitor*, ValaWhileStatement*)) vala_symbol_resolver_real_visit_while_statement;
	((ValaCodeVisitorClass *) klass)->visit_do_statement = (void (*) (ValaCodeVisitor*, ValaDoStatement*)) vala_symbol_resolver_real_visit_do_statement;
	((ValaCodeVisitorClass *) klass)->visit_for_statement = (void (*) (ValaCodeVisitor*, ValaForStatement*)) vala_symbol_resolver_real_visit_for_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor*, ValaForeachStatement*)) vala_symbol_resolver_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor*, ValaReturnStatement*)) vala_symbol_resolver_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor*, ValaYieldStatement*)) vala_symbol_resolver_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_symbol_resolver_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_symbol_resolver_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_delete_statement = (void (*) (ValaCodeVisitor*, ValaDeleteStatement*)) vala_symbol_resolver_real_visit_delete_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_symbol_resolver_real_visit_catch_clause;
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor*, ValaArrayCreationExpression*)) vala_symbol_resolver_real_visit_array_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_template = (void (*) (ValaCodeVisitor*, ValaTemplate*)) vala_symbol_resolver_real_visit_template;
	((ValaCodeVisitorClass *) klass)->visit_tuple = (void (*) (ValaCodeVisitor*, ValaTuple*)) vala_symbol_resolver_real_visit_tuple;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_symbol_resolver_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_symbol_resolver_real_visit_method_call;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_symbol_resolver_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor*, ValaSliceExpression*)) vala_symbol_resolver_real_visit_slice_expression;
	((ValaCodeVisitorClass *) klass)->visit_postfix_expression = (void (*) (ValaCodeVisitor*, ValaPostfixExpression*)) vala_symbol_resolver_real_visit_postfix_expression;
	((ValaCodeVisitorClass *) klass)->visit_object_creation_expression = (void (*) (ValaCodeVisitor*, ValaObjectCreationExpression*)) vala_symbol_resolver_real_visit_object_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_sizeof_expression = (void (*) (ValaCodeVisitor*, ValaSizeofExpression*)) vala_symbol_resolver_real_visit_sizeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_typeof_expression = (void (*) (ValaCodeVisitor*, ValaTypeofExpression*)) vala_symbol_resolver_real_visit_typeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_unary_expression = (void (*) (ValaCodeVisitor*, ValaUnaryExpression*)) vala_symbol_resolver_real_visit_unary_expression;
	((ValaCodeVisitorClass *) klass)->visit_cast_expression = (void (*) (ValaCodeVisitor*, ValaCastExpression*)) vala_symbol_resolver_real_visit_cast_expression;
	((ValaCodeVisitorClass *) klass)->visit_named_argument = (void (*) (ValaCodeVisitor*, ValaNamedArgument*)) vala_symbol_resolver_real_visit_named_argument;
	((ValaCodeVisitorClass *) klass)->visit_pointer_indirection = (void (*) (ValaCodeVisitor*, ValaPointerIndirection*)) vala_symbol_resolver_real_visit_pointer_indirection;
	((ValaCodeVisitorClass *) klass)->visit_addressof_expression = (void (*) (ValaCodeVisitor*, ValaAddressofExpression*)) vala_symbol_resolver_real_visit_addressof_expression;
	((ValaCodeVisitorClass *) klass)->visit_reference_transfer_expression = (void (*) (ValaCodeVisitor*, ValaReferenceTransferExpression*)) vala_symbol_resolver_real_visit_reference_transfer_expression;
	((ValaCodeVisitorClass *) klass)->visit_binary_expression = (void (*) (ValaCodeVisitor*, ValaBinaryExpression*)) vala_symbol_resolver_real_visit_binary_expression;
	((ValaCodeVisitorClass *) klass)->visit_type_check = (void (*) (ValaCodeVisitor*, ValaTypeCheck*)) vala_symbol_resolver_real_visit_type_check;
	((ValaCodeVisitorClass *) klass)->visit_conditional_expression = (void (*) (ValaCodeVisitor*, ValaConditionalExpression*)) vala_symbol_resolver_real_visit_conditional_expression;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) vala_symbol_resolver_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor*, ValaAssignment*)) vala_symbol_resolver_real_visit_assignment;
}

static void
vala_symbol_resolver_instance_init (ValaSymbolResolver * self,
                                    gpointer klass)
{
	self->priv = vala_symbol_resolver_get_instance_private (self);
}

static void
vala_symbol_resolver_finalize (ValaCodeVisitor * obj)
{
	ValaSymbolResolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolver);
	_vala_code_node_unref0 (self->priv->root_symbol);
	_vala_scope_unref0 (self->priv->current_scope);
	VALA_CODE_VISITOR_CLASS (vala_symbol_resolver_parent_class)->finalize (obj);
}

/**
 * Code visitor resolving symbol names.
 */
static GType
vala_symbol_resolver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_instance_init, NULL };
	GType vala_symbol_resolver_type_id;
	vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
	ValaSymbolResolver_private_offset = g_type_add_instance_private (vala_symbol_resolver_type_id, sizeof (ValaSymbolResolverPrivate));
	return vala_symbol_resolver_type_id;
}

GType
vala_symbol_resolver_get_type (void)
{
	static volatile gsize vala_symbol_resolver_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_resolver_type_id__volatile)) {
		GType vala_symbol_resolver_type_id;
		vala_symbol_resolver_type_id = vala_symbol_resolver_get_type_once ();
		g_once_init_leave (&vala_symbol_resolver_type_id__volatile, vala_symbol_resolver_type_id);
	}
	return vala_symbol_resolver_type_id__volatile;
}

