/* valadoc.c generated by valac, the Vala compiler
 * generated from valadoc.vala, do not modify */

/* valadoc.vala
 *
 * Copyright (C) 2008-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>
#include <stdio.h>
#include <valadoc.h>
#include <glib/gstdio.h>
#include <valacodegen.h>
#include <locale.h>

#define TYPE_VALA_DOC (vala_doc_get_type ())
#define VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DOC, ValaDoc))
#define VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DOC, ValaDocClass))
#define IS_VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DOC))
#define IS_VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DOC))
#define VALA_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DOC, ValaDocClass))

typedef struct _ValaDoc ValaDoc;
typedef struct _ValaDocClass ValaDocClass;
typedef struct _ValaDocPrivate ValaDocPrivate;
enum  {
	VALA_DOC_0_PROPERTY,
	VALA_DOC_NUM_PROPERTIES
};
static GParamSpec* vala_doc_properties[VALA_DOC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALADOC_TYPE_TREE_BUILDER (valadoc_tree_builder_get_type ())
#define VALADOC_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilder))
#define VALADOC_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))
#define VALADOC_IS_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_IS_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_TREE_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))

typedef struct _ValadocTreeBuilder ValadocTreeBuilder;
typedef struct _ValadocTreeBuilderClass ValadocTreeBuilderClass;
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALADOC_TYPE_SYMBOL_RESOLVER (valadoc_symbol_resolver_get_type ())
#define VALADOC_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolver))
#define VALADOC_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolverClass))
#define VALADOC_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_SYMBOL_RESOLVER))
#define VALADOC_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_SYMBOL_RESOLVER))
#define VALADOC_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_SYMBOL_RESOLVER, ValadocSymbolResolverClass))

typedef struct _ValadocSymbolResolver ValadocSymbolResolver;
typedef struct _ValadocSymbolResolverClass ValadocSymbolResolverClass;

#define VALADOC_TYPE_GIR_WRITER (valadoc_gir_writer_get_type ())
#define VALADOC_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_GIR_WRITER, ValadocGirWriter))
#define VALADOC_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_GIR_WRITER, ValadocGirWriterClass))
#define VALADOC_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_GIR_WRITER))
#define VALADOC_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_GIR_WRITER))
#define VALADOC_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_GIR_WRITER, ValadocGirWriterClass))

typedef struct _ValadocGirWriter ValadocGirWriter;
typedef struct _ValadocGirWriterClass ValadocGirWriterClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaDoc {
	GObject parent_instance;
	ValaDocPrivate * priv;
};

struct _ValaDocClass {
	GObjectClass parent_class;
};

static gpointer vala_doc_parent_class = NULL;
static gchar* vala_doc_directory;
static gchar* vala_doc_basedir;
static gchar** vala_doc_defines;
static gboolean vala_doc_experimental;
static gboolean vala_doc_experimental_non_null;
static gchar** vala_doc_metadata_directories;
static gchar** vala_doc_gir_directories;
static gchar** vala_doc_vapi_directories;
static gchar** vala_doc_packages;
static gchar** vala_doc_import_directories;
static gchar** vala_doc_import_packages;
static gchar** vala_doc_alternative_resource_dirs;
static gchar* vala_doc_wikidirectory;
static gboolean vala_doc_with_deps;
static gchar* vala_doc_docletpath;
static gchar** vala_doc_pluginargs;
static gboolean vala_doc__protected;
static gboolean vala_doc__internal;
static gboolean vala_doc__private;
static gboolean vala_doc_use_svg_images;
static gchar* vala_doc_pkg_name;
static gchar* vala_doc_pkg_version;
static gchar* vala_doc_gir_name;
static gboolean vala_doc_version;
static gboolean vala_doc_force;
static gboolean vala_doc_fatal_warnings;
static gboolean vala_doc_verbose;
static gboolean vala_doc_disable_diagnostic_colors;
static gchar* vala_doc_target_glib;
static gchar** vala_doc_tsources;
static gchar* vala_doc_wikidirectory = NULL;
static gchar* vala_doc_pkg_version = NULL;
static gchar* vala_doc_docletpath = NULL;
static gchar** vala_doc_pluginargs = NULL;
static gchar* vala_doc_directory = NULL;
static gchar* vala_doc_pkg_name = NULL;
static gchar* vala_doc_gir_name = NULL;
static gchar* vala_doc_gir_namespace;
static gchar* vala_doc_gir_namespace = NULL;
static gchar* vala_doc_gir_version;
static gchar* vala_doc_gir_version = NULL;
static gboolean vala_doc_add_inherited;
static gboolean vala_doc_add_inherited = FALSE;
static gboolean vala_doc__protected = TRUE;
static gboolean vala_doc__internal = FALSE;
static gboolean vala_doc_with_deps = FALSE;
static gboolean vala_doc__private = FALSE;
static gboolean vala_doc_version = FALSE;
static gboolean vala_doc_use_svg_images = FALSE;
static gboolean vala_doc_disable_diagnostic_colors = FALSE;
static gboolean vala_doc_verbose = FALSE;
static gboolean vala_doc_force = FALSE;
static gboolean vala_doc_fatal_warnings = FALSE;
static gchar* vala_doc_basedir = NULL;
static gchar** vala_doc_defines = NULL;
static gboolean vala_doc_experimental = FALSE;
static gboolean vala_doc_experimental_non_null = FALSE;
static ValaProfile vala_doc_profile;
static ValaProfile vala_doc_profile = 0;
static gchar** vala_doc_import_packages = NULL;
static gchar** vala_doc_import_directories = NULL;
static gchar** vala_doc_vapi_directories = NULL;
static gchar** vala_doc_metadata_directories = NULL;
static gchar** vala_doc_gir_directories = NULL;
static gchar** vala_doc_tsources = NULL;
static gchar** vala_doc_packages = NULL;
static gchar** vala_doc_alternative_resource_dirs = NULL;
static gchar* vala_doc_target_glib = NULL;

GType vala_doc_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaDoc, g_object_unref)
#define VALA_DOC_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_doc_option_parse_profile (const gchar* option_name,
                                        const gchar* val,
                                        void* data,
                                        GError** error);
static gboolean vala_doc_option_deprecated (const gchar* option_name,
                                     const gchar* val,
                                     void* data,
                                     GError** error);
static gint vala_doc_quit (ValadocErrorReporter* reporter);
static gboolean vala_doc_check_pkg_name (void);
static gchar* vala_doc_get_pkg_name (ValaDoc* self);
static ValadocModuleLoader* vala_doc_create_module_loader (ValaDoc* self,
                                                    ValadocErrorReporter* reporter,
                                                    ValadocDoclet* * doclet);
static gint vala_doc_run (ValaDoc* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gint length);
static gchar** _vala_array_dup2 (gchar** self,
                          gint length);
static gchar** _vala_array_dup3 (gchar** self,
                          gint length);
static gchar** _vala_array_dup4 (gchar** self,
                          gint length);
static gchar** _vala_array_dup5 (gchar** self,
                          gint length);
static gchar** _vala_array_dup6 (gchar** self,
                          gint length);
static gchar** _vala_array_dup7 (gchar** self,
                          gint length);
static gchar** _vala_array_dup8 (gchar** self,
                          gint length);
GType valadoc_tree_builder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocTreeBuilder, vala_code_visitor_unref)
ValadocTreeBuilder* valadoc_tree_builder_new (void);
ValadocTreeBuilder* valadoc_tree_builder_construct (GType object_type);
ValadocApiTree* valadoc_tree_builder_build (ValadocTreeBuilder* self,
                                            ValadocSettings* settings,
                                            ValadocErrorReporter* reporter);
GType valadoc_symbol_resolver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocSymbolResolver, g_object_unref)
ValadocSymbolResolver* valadoc_symbol_resolver_new (ValadocTreeBuilder* builder);
ValadocSymbolResolver* valadoc_symbol_resolver_construct (GType object_type,
                                                          ValadocTreeBuilder* builder);
GType valadoc_gir_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocGirWriter, vala_code_visitor_unref)
ValadocGirWriter* valadoc_gir_writer_new (ValadocSymbolResolver* resolver);
ValadocGirWriter* valadoc_gir_writer_construct (GType object_type,
                                                ValadocSymbolResolver* resolver);
static gint vala_doc_main (gchar** args,
                    gint args_length1);
ValaDoc* vala_doc_new (void);
ValaDoc* vala_doc_construct (GType object_type);
static void vala_doc_finalize (GObject * obj);
static GType vala_doc_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_DOC_options[33] = {{"directory", 'o', (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_directory, "Output directory", "DIRECTORY"}, {"basedir", 'b', (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_basedir, "Base source directory", "DIRECTORY"}, {"define", 'D', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_defines, "Define SYMBOL", "SYMBOL..."}, {"profile", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_doc_option_parse_profile, "Use the given profile instead of the default, options are 'gobject' or" \
" 'posix'", "PROFILE"}, {"enable-experimental", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_experimental, "Enable experimental features", NULL}, {"enable-experimental-non-null", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"metadatadir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"driver", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_doc_option_deprecated, "Name of an driver or path to a custom driver (DEPRECATED AND IGNORED)", NULL}, {"importdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_import_directories, "Look for external documentation in DIRECTORY", "DIRECTORY..."}, {"import", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_import_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"alternative-resource-dir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_alternative_resource_dirs, "Alternative resource directories", "DIRECTORY..."}, {"wiki", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_doc_wikidirectory, "Wiki directory", "DIRECTORY"}, {"deps", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_with_deps, "Adds packages to the documentation", NULL}, {"doclet", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_docletpath, "Name of an included doclet or path to custom doclet", "PLUGIN"}, {"doclet-arg", 'X', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_pluginargs, "Pass arguments to the doclet", "ARG"}, {"no-protected", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &vala_doc__protected, "Removes protected elements from documentation", NULL}, {"internal", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc__internal, "Adds internal elements to documentation", NULL}, {"private", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc__private, "Adds private elements to documentation", NULL}, {"use-svg-images", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_use_svg_images, "Generate SVG image charts instead of PNG", NULL}, {"package-name", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_pkg_name, "package name", "NAME"}, {"package-version", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_pkg_version, "package version", "VERSION"}, {"gir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_gir_name, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_version, "Display version number", NULL}, {"force", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_force, "force", NULL}, {"fatal-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_fatal_warnings, "Treat warnings as fatal", NULL}, {"verbose", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_verbose, "Show all warnings", NULL}, {"no-color", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_doc_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_doc_target_glib, "Target version of glib for code generation", "'MAJOR.MINOR', or 'auto'"}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_tsources, NULL, "FILE..."}, {NULL}};

static gboolean
vala_doc_option_parse_profile (const gchar* option_name,
                               const gchar* val,
                               void* data,
                               GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("gobject-2.0"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("gobject"))))) {
		switch (0) {
			default:
			{
				vala_doc_profile = VALA_PROFILE_GOBJECT;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("posix")))) {
		switch (0) {
			default:
			{
				vala_doc_profile = VALA_PROFILE_POSIX;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --profile argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_doc_option_deprecated (const gchar* option_name,
                            const gchar* val,
                            void* data,
                            GError** error)
{
	FILE* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_doc_quit (ValadocErrorReporter* reporter)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint result = 0;
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp1_ = valadoc_error_reporter_get_errors (reporter);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gboolean _tmp3_ = FALSE;
		if (!vala_doc_fatal_warnings) {
			_tmp3_ = TRUE;
		} else {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = valadoc_error_reporter_get_warnings (reporter);
			_tmp5_ = _tmp4_;
			_tmp3_ = _tmp5_ == 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FILE* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = stdout;
		_tmp7_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp8_ = _tmp7_;
		fprintf (_tmp6_, "Succeeded - %d warning(s)\n", _tmp8_);
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		FILE* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = stdout;
		_tmp10_ = valadoc_error_reporter_get_errors (reporter);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp13_ = _tmp12_;
		fprintf (_tmp9_, "Failed: %d error(s), %d warning(s)\n", _tmp11_, _tmp13_);
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static gboolean
vala_doc_check_pkg_name (void)
{
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean result = FALSE;
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = vala_doc_pkg_name;
	if (g_strcmp0 (_tmp2_, "glib-2.0") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = vala_doc_pkg_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "gobject-2.0") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vala_doc_tsources;
	_tmp4__length1 = _vala_array_length (vala_doc_tsources);
	{
		gchar** package_collection = NULL;
		gint package_collection_length1 = 0;
		gint _package_collection_size_ = 0;
		gint package_it = 0;
		package_collection = _tmp4_;
		package_collection_length1 = _tmp4__length1;
		for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
			gchar* _tmp5_;
			gchar* package = NULL;
			_tmp5_ = g_strdup (package_collection[package_it]);
			package = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = vala_doc_pkg_name;
				_tmp7_ = package;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = FALSE;
					_g_free0 (package);
					return result;
				}
				_g_free0 (package);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
vala_doc_get_pkg_name (ValaDoc* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = vala_doc_directory;
		if (g_str_has_suffix (_tmp1_, "/")) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = vala_doc_directory;
			_tmp3_ = g_path_get_dirname (_tmp2_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp3_;
		} else {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = vala_doc_directory;
			_tmp5_ = g_path_get_basename (_tmp4_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp5_;
		}
	}
	_tmp6_ = vala_doc_pkg_name;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}

static ValadocModuleLoader*
vala_doc_create_module_loader (ValaDoc* self,
                               ValadocErrorReporter* reporter,
                               ValadocDoclet* * doclet)
{
	ValadocDoclet* _vala_doclet = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocModuleLoader* _tmp0_;
	gchar* pluginpath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocModuleLoader* _tmp4_;
	const gchar* _tmp5_;
	ValadocDoclet* _tmp6_;
	ValadocDoclet* _tmp7_;
	ValadocModuleLoader* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = valadoc_module_loader_get_instance ();
	modules = _tmp0_;
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = NULL;
	_tmp1_ = vala_doc_docletpath;
	_tmp2_ = valadoc_module_loader_get_doclet_path (_tmp1_, reporter);
	pluginpath = _tmp2_;
	_tmp3_ = pluginpath;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		return result;
	}
	_tmp4_ = modules;
	_tmp5_ = pluginpath;
	_tmp6_ = valadoc_module_loader_create_doclet (_tmp4_, _tmp5_);
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = _tmp6_;
	_tmp7_ = _vala_doclet;
	if (_tmp7_ == NULL) {
		valadoc_error_reporter_simple_error (reporter, NULL, "failed to load doclet");
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		return result;
	}
	result = modules;
	_g_free0 (pluginpath);
	if (doclet) {
		*doclet = _vala_doclet;
	} else {
		_g_object_unref0 (_vala_doclet);
	}
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
vala_doc_run (ValaDoc* self)
{
	ValaCodeContext* context = NULL;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValadocErrorReporter* reporter = NULL;
	ValadocErrorReporter* _tmp2_;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	const gchar* _tmp19_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValadocErrorReporter* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	const gchar* _tmp34_;
	ValadocSettings* settings = NULL;
	ValadocSettings* _tmp66_;
	ValadocErrorReporter* _tmp67_;
	ValadocSettings* _tmp68_;
	ValadocSettings* _tmp69_;
	gchar* _tmp70_;
	ValadocSettings* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	ValadocSettings* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
	ValadocSettings* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	ValadocSettings* _tmp92_;
	ValadocSettings* _tmp93_;
	ValadocSettings* _tmp94_;
	ValadocSettings* _tmp95_;
	ValadocSettings* _tmp96_;
	ValadocSettings* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	ValadocSettings* _tmp100_;
	ValadocSettings* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	ValadocSettings* _tmp104_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	gchar** _tmp106_;
	gint _tmp106__length1;
	ValadocSettings* _tmp107_;
	ValadocSettings* _tmp108_;
	ValadocSettings* _tmp109_;
	const gchar* _tmp110_;
	gchar* _tmp111_;
	ValadocSettings* _tmp112_;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	ValadocSettings* _tmp115_;
	gchar** _tmp116_;
	gint _tmp116__length1;
	gchar** _tmp117_;
	gint _tmp117__length1;
	ValadocSettings* _tmp118_;
	gchar** _tmp119_;
	gint _tmp119__length1;
	gchar** _tmp120_;
	gint _tmp120__length1;
	ValadocSettings* _tmp121_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	gchar** _tmp123_;
	gint _tmp123__length1;
	ValadocSettings* _tmp124_;
	const gchar* _tmp125_;
	gchar* _tmp126_;
	ValadocSettings* _tmp127_;
	ValadocSettings* _tmp128_;
	gchar** _tmp129_;
	gint _tmp129__length1;
	gchar** _tmp130_;
	gint _tmp130__length1;
	ValadocSettings* _tmp131_;
	gchar** _tmp132_;
	gint _tmp132__length1;
	gchar** _tmp133_;
	gint _tmp133__length1;
	ValadocSettings* _tmp134_;
	ValaProfile _tmp135_;
	ValadocSettings* _tmp136_;
	gchar** _tmp137_;
	gint _tmp137__length1;
	gchar** _tmp138_;
	gint _tmp138__length1;
	ValadocSettings* _tmp139_;
	gchar** _tmp140_;
	gint _tmp140__length1;
	gchar** _tmp141_;
	gint _tmp141__length1;
	ValadocDoclet* doclet = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocErrorReporter* _tmp142_;
	ValadocDoclet* _tmp143_ = NULL;
	ValadocModuleLoader* _tmp144_;
	gboolean _tmp145_ = FALSE;
	ValadocErrorReporter* _tmp146_;
	gint _tmp147_;
	gint _tmp148_;
	ValadocTreeBuilder* builder = NULL;
	ValadocTreeBuilder* _tmp151_;
	ValadocApiTree* doctree = NULL;
	ValadocTreeBuilder* _tmp152_;
	ValadocSettings* _tmp153_;
	ValadocErrorReporter* _tmp154_;
	ValadocApiTree* _tmp155_;
	ValadocErrorReporter* _tmp156_;
	gint _tmp157_;
	gint _tmp158_;
	ValadocSymbolResolver* resolver = NULL;
	ValadocTreeBuilder* _tmp160_;
	ValadocSymbolResolver* _tmp161_;
	ValadocApiTree* _tmp162_;
	ValadocSymbolResolver* _tmp163_;
	ValadocApiChildSymbolRegistrar* registrar = NULL;
	ValadocApiChildSymbolRegistrar* _tmp164_;
	ValadocApiTree* _tmp165_;
	ValadocApiChildSymbolRegistrar* _tmp166_;
	ValadocDocumentationParser* docparser = NULL;
	ValadocSettings* _tmp167_;
	ValadocErrorReporter* _tmp168_;
	ValadocApiTree* _tmp169_;
	ValadocModuleLoader* _tmp170_;
	ValadocDocumentationParser* _tmp171_;
	ValadocApiTree* _tmp172_;
	ValadocImporterDocumentationImporter** importers = NULL;
	ValadocApiTree* _tmp174_;
	ValadocDocumentationParser* _tmp175_;
	ValadocModuleLoader* _tmp176_;
	ValadocSettings* _tmp177_;
	ValadocErrorReporter* _tmp178_;
	ValadocImporterValadocDocumentationImporter* _tmp179_;
	ValadocApiTree* _tmp180_;
	ValadocDocumentationParser* _tmp181_;
	ValadocModuleLoader* _tmp182_;
	ValadocSettings* _tmp183_;
	ValadocErrorReporter* _tmp184_;
	ValadocImporterGirDocumentationImporter* _tmp185_;
	ValadocImporterDocumentationImporter** _tmp186_;
	gint importers_length1;
	gint _importers_size_;
	ValadocApiTree* _tmp187_;
	ValadocDocumentationParser* _tmp188_;
	ValadocErrorReporter* _tmp189_;
	gint _tmp190_;
	gint _tmp191_;
	ValadocApiTree* _tmp193_;
	ValadocImporterDocumentationImporter** _tmp194_;
	gint _tmp194__length1;
	gchar** _tmp195_;
	gint _tmp195__length1;
	gchar** _tmp196_;
	gint _tmp196__length1;
	ValadocErrorReporter* _tmp197_;
	gint _tmp198_;
	gint _tmp199_;
	ValadocApiTree* _tmp201_;
	ValadocDocumentationParser* _tmp202_;
	ValadocErrorReporter* _tmp203_;
	gint _tmp204_;
	gint _tmp205_;
	const gchar* _tmp207_;
	ValadocDoclet* _tmp232_;
	ValadocSettings* _tmp233_;
	ValadocApiTree* _tmp234_;
	ValadocErrorReporter* _tmp235_;
	ValadocErrorReporter* _tmp236_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	context = _tmp0_;
	_tmp1_ = context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = valadoc_error_reporter_new (NULL);
	reporter = _tmp2_;
	if (vala_doc_disable_diagnostic_colors == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValadocErrorReporter* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = reporter;
			_tmp6_ = env_colors;
			valadoc_error_reporter_set_colors (_tmp5_, _tmp6_);
		} else {
			ValadocErrorReporter* _tmp7_;
			_tmp7_ = reporter;
			valadoc_error_reporter_set_colors (_tmp7_, VALA_DOC_DEFAULT_COLORS);
		}
	}
	_tmp8_ = vala_doc_directory;
	if (_tmp8_ == NULL) {
		ValadocErrorReporter* _tmp9_;
		ValadocErrorReporter* _tmp10_;
		_tmp9_ = reporter;
		valadoc_error_reporter_simple_error (_tmp9_, NULL, "No output directory specified.");
		_tmp10_ = reporter;
		result = vala_doc_quit (_tmp10_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	if (!vala_doc_check_pkg_name ()) {
		ValadocErrorReporter* _tmp11_;
		ValadocErrorReporter* _tmp12_;
		_tmp11_ = reporter;
		valadoc_error_reporter_simple_error (_tmp11_, NULL, "File already exists");
		_tmp12_ = reporter;
		result = vala_doc_quit (_tmp12_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp13_ = vala_doc_directory;
	if (g_file_test (_tmp13_, G_FILE_TEST_EXISTS)) {
		if (vala_doc_force == TRUE) {
			gboolean tmp = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = vala_doc_directory;
			tmp = valadoc_remove_directory (_tmp14_);
			if (tmp == FALSE) {
				ValadocErrorReporter* _tmp15_;
				ValadocErrorReporter* _tmp16_;
				_tmp15_ = reporter;
				valadoc_error_reporter_simple_error (_tmp15_, NULL, "Can't remove directory.");
				_tmp16_ = reporter;
				result = vala_doc_quit (_tmp16_);
				_g_object_unref0 (reporter);
				_vala_code_context_unref0 (context);
				return result;
			}
		} else {
			ValadocErrorReporter* _tmp17_;
			ValadocErrorReporter* _tmp18_;
			_tmp17_ = reporter;
			valadoc_error_reporter_simple_error (_tmp17_, NULL, "File already exists");
			_tmp18_ = reporter;
			result = vala_doc_quit (_tmp18_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	_tmp19_ = vala_doc_wikidirectory;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		_tmp20_ = vala_doc_wikidirectory;
		if (!g_file_test (_tmp20_, G_FILE_TEST_IS_DIR)) {
			ValadocErrorReporter* _tmp21_;
			ValadocErrorReporter* _tmp22_;
			_tmp21_ = reporter;
			valadoc_error_reporter_simple_error (_tmp21_, NULL, "Wiki-directory does not exist.");
			_tmp22_ = reporter;
			result = vala_doc_quit (_tmp22_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	_tmp23_ = vala_doc_alternative_resource_dirs;
	_tmp23__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp23_;
		dir_collection_length1 = _tmp23__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp24_;
				_tmp24_ = dir;
				if (!g_file_test (_tmp24_, G_FILE_TEST_IS_DIR)) {
					ValadocErrorReporter* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					ValadocErrorReporter* _tmp29_;
					_tmp25_ = reporter;
					_tmp26_ = dir;
					_tmp27_ = g_strdup_printf ("alternative resource directory '%s' does not exist.", _tmp26_);
					_tmp28_ = _tmp27_;
					valadoc_error_reporter_simple_error (_tmp25_, NULL, "%s", _tmp28_);
					_g_free0 (_tmp28_);
					_tmp29_ = reporter;
					result = vala_doc_quit (_tmp29_);
					_g_object_unref0 (reporter);
					_vala_code_context_unref0 (context);
					return result;
				}
			}
		}
	}
	_tmp30_ = reporter;
	_tmp31_ = valadoc_error_reporter_get_errors (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 0) {
		ValadocErrorReporter* _tmp33_;
		_tmp33_ = reporter;
		result = vala_doc_quit (_tmp33_);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp34_ = vala_doc_gir_name;
	if (_tmp34_ != NULL) {
		glong gir_len = 0L;
		const gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint last_hyphen = 0;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp51_ = FALSE;
		const gchar* _tmp52_;
		gboolean report_warning = FALSE;
		gchar** _tmp59_;
		gint _tmp59__length1;
		_tmp35_ = vala_doc_gir_name;
		_tmp36_ = strlen (_tmp35_);
		_tmp37_ = _tmp36_;
		gir_len = (glong) _tmp37_;
		_tmp38_ = vala_doc_gir_name;
		last_hyphen = string_last_index_of_char (_tmp38_, (gunichar) '-', 0);
		if (last_hyphen == -1) {
			_tmp39_ = TRUE;
		} else {
			const gchar* _tmp40_;
			_tmp40_ = vala_doc_gir_name;
			_tmp39_ = !g_str_has_suffix (_tmp40_, ".gir");
		}
		if (_tmp39_) {
			ValadocErrorReporter* _tmp41_;
			const gchar* _tmp42_;
			ValadocErrorReporter* _tmp43_;
			_tmp41_ = reporter;
			_tmp42_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp41_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp42_);
			_tmp43_ = reporter;
			result = vala_doc_quit (_tmp43_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		_tmp44_ = vala_doc_gir_name;
		_tmp45_ = string_substring (_tmp44_, (glong) 0, (glong) last_hyphen);
		_g_free0 (vala_doc_gir_namespace);
		vala_doc_gir_namespace = _tmp45_;
		_tmp46_ = vala_doc_gir_name;
		_tmp47_ = string_substring (_tmp46_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
		_g_free0 (vala_doc_gir_version);
		vala_doc_gir_version = _tmp47_;
		_tmp48_ = vala_doc_gir_version;
		g_strcanon (_tmp48_, "0123456789.", '?');
		_tmp52_ = vala_doc_gir_namespace;
		if (g_strcmp0 (_tmp52_, "") == 0) {
			_tmp51_ = TRUE;
		} else {
			const gchar* _tmp53_;
			_tmp53_ = vala_doc_gir_version;
			_tmp51_ = g_strcmp0 (_tmp53_, "") == 0;
		}
		if (_tmp51_) {
			_tmp50_ = TRUE;
		} else {
			const gchar* _tmp54_;
			_tmp54_ = vala_doc_gir_version;
			_tmp50_ = !g_ascii_isdigit (string_get (_tmp54_, (glong) 0));
		}
		if (_tmp50_) {
			_tmp49_ = TRUE;
		} else {
			const gchar* _tmp55_;
			_tmp55_ = vala_doc_gir_version;
			_tmp49_ = string_contains (_tmp55_, "?");
		}
		if (_tmp49_) {
			ValadocErrorReporter* _tmp56_;
			const gchar* _tmp57_;
			ValadocErrorReporter* _tmp58_;
			_tmp56_ = reporter;
			_tmp57_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp56_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp57_);
			_tmp58_ = reporter;
			result = vala_doc_quit (_tmp58_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		report_warning = TRUE;
		_tmp59_ = vala_doc_tsources;
		_tmp59__length1 = _vala_array_length (vala_doc_tsources);
		{
			gchar** source_collection = NULL;
			gint source_collection_length1 = 0;
			gint _source_collection_size_ = 0;
			gint source_it = 0;
			source_collection = _tmp59_;
			source_collection_length1 = _tmp59__length1;
			for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
				gchar* _tmp60_;
				gchar* source = NULL;
				_tmp60_ = g_strdup (source_collection[source_it]);
				source = _tmp60_;
				{
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_;
					_tmp62_ = source;
					if (g_str_has_suffix (_tmp62_, ".vala")) {
						_tmp61_ = TRUE;
					} else {
						const gchar* _tmp63_;
						_tmp63_ = source;
						_tmp61_ = g_str_has_suffix (_tmp63_, ".gs");
					}
					if (_tmp61_) {
						report_warning = FALSE;
						_g_free0 (source);
						break;
					}
					_g_free0 (source);
				}
			}
		}
		if (report_warning == TRUE) {
			ValadocErrorReporter* _tmp64_;
			ValadocErrorReporter* _tmp65_;
			_tmp64_ = reporter;
			valadoc_error_reporter_simple_error (_tmp64_, NULL, "No source file specified to be compiled to gir.");
			_tmp65_ = reporter;
			result = vala_doc_quit (_tmp65_);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	_tmp66_ = valadoc_settings_new ();
	settings = _tmp66_;
	_tmp67_ = reporter;
	_tmp68_ = settings;
	valadoc_error_reporter_set_settings (_tmp67_, _tmp68_);
	_tmp69_ = settings;
	_tmp70_ = vala_doc_get_pkg_name (self);
	_g_free0 (_tmp69_->pkg_name);
	_tmp69_->pkg_name = _tmp70_;
	_tmp71_ = settings;
	_tmp72_ = vala_doc_gir_namespace;
	_tmp73_ = g_strdup (_tmp72_);
	_g_free0 (_tmp71_->gir_namespace);
	_tmp71_->gir_namespace = _tmp73_;
	_tmp74_ = settings;
	_tmp75_ = vala_doc_gir_version;
	_tmp76_ = g_strdup (_tmp75_);
	_g_free0 (_tmp74_->gir_version);
	_tmp74_->gir_version = _tmp76_;
	_tmp77_ = vala_doc_gir_name;
	if (_tmp77_ != NULL) {
		ValadocSettings* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		ValadocSettings* _tmp81_;
		const gchar* _tmp82_;
		gchar* _tmp83_;
		ValadocSettings* _tmp84_;
		const gchar* _tmp85_;
		_tmp78_ = settings;
		_tmp79_ = vala_doc_gir_name;
		_tmp80_ = g_path_get_basename (_tmp79_);
		_g_free0 (_tmp78_->gir_name);
		_tmp78_->gir_name = _tmp80_;
		_tmp81_ = settings;
		_tmp82_ = vala_doc_gir_name;
		_tmp83_ = g_path_get_dirname (_tmp82_);
		_g_free0 (_tmp81_->gir_directory);
		_tmp81_->gir_directory = _tmp83_;
		_tmp84_ = settings;
		_tmp85_ = _tmp84_->gir_directory;
		if (g_strcmp0 (_tmp85_, "") == 0) {
			ValadocSettings* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp86_ = settings;
			_tmp87_ = vala_doc_directory;
			_tmp88_ = g_path_get_dirname (_tmp87_);
			_g_free0 (_tmp86_->gir_directory);
			_tmp86_->gir_directory = _tmp88_;
		}
	}
	_tmp89_ = settings;
	_tmp90_ = vala_doc_pkg_version;
	_tmp91_ = g_strdup (_tmp90_);
	_g_free0 (_tmp89_->pkg_version);
	_tmp89_->pkg_version = _tmp91_;
	_tmp92_ = settings;
	_tmp92_->add_inherited = vala_doc_add_inherited;
	_tmp93_ = settings;
	_tmp93_->_protected = vala_doc__protected;
	_tmp94_ = settings;
	_tmp94_->_internal = vala_doc__internal;
	_tmp95_ = settings;
	_tmp95_->with_deps = vala_doc_with_deps;
	_tmp96_ = settings;
	_tmp96_->_private = vala_doc__private;
	_tmp97_ = settings;
	_tmp98_ = vala_doc_directory;
	_tmp99_ = vala_code_context_realpath (_tmp98_);
	_g_free0 (_tmp97_->path);
	_tmp97_->path = _tmp99_;
	_tmp100_ = settings;
	_tmp100_->verbose = vala_doc_verbose;
	_tmp101_ = settings;
	_tmp102_ = vala_doc_wikidirectory;
	_tmp103_ = g_strdup (_tmp102_);
	_g_free0 (_tmp101_->wiki_directory);
	_tmp101_->wiki_directory = _tmp103_;
	_tmp104_ = settings;
	_tmp105_ = vala_doc_pluginargs;
	_tmp105__length1 = _vala_array_length (vala_doc_pluginargs);
	_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup1 (_tmp105_, _tmp105__length1) : _tmp105_;
	_tmp106__length1 = _tmp105__length1;
	_tmp104_->pluginargs = (_vala_array_free (_tmp104_->pluginargs, _tmp104_->pluginargs_length1, (GDestroyNotify) g_free), NULL);
	_tmp104_->pluginargs = _tmp106_;
	_tmp104_->pluginargs_length1 = _tmp106__length1;
	_tmp107_ = settings;
	_tmp107_->experimental = vala_doc_experimental;
	_tmp108_ = settings;
	_tmp108_->experimental_non_null = vala_doc_experimental_non_null;
	_tmp109_ = settings;
	_tmp110_ = vala_doc_basedir;
	_tmp111_ = g_strdup (_tmp110_);
	_g_free0 (_tmp109_->basedir);
	_tmp109_->basedir = _tmp111_;
	_tmp112_ = settings;
	_tmp113_ = vala_doc_directory;
	_tmp114_ = g_strdup (_tmp113_);
	_g_free0 (_tmp112_->directory);
	_tmp112_->directory = _tmp114_;
	_tmp115_ = settings;
	_tmp116_ = vala_doc_vapi_directories;
	_tmp116__length1 = _vala_array_length (vala_doc_vapi_directories);
	_tmp117_ = (_tmp116_ != NULL) ? _vala_array_dup2 (_tmp116_, _tmp116__length1) : _tmp116_;
	_tmp117__length1 = _tmp116__length1;
	_tmp115_->vapi_directories = (_vala_array_free (_tmp115_->vapi_directories, _tmp115_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp115_->vapi_directories = _tmp117_;
	_tmp115_->vapi_directories_length1 = _tmp117__length1;
	_tmp118_ = settings;
	_tmp119_ = vala_doc_metadata_directories;
	_tmp119__length1 = _vala_array_length (vala_doc_metadata_directories);
	_tmp120_ = (_tmp119_ != NULL) ? _vala_array_dup3 (_tmp119_, _tmp119__length1) : _tmp119_;
	_tmp120__length1 = _tmp119__length1;
	_tmp118_->metadata_directories = (_vala_array_free (_tmp118_->metadata_directories, _tmp118_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp118_->metadata_directories = _tmp120_;
	_tmp118_->metadata_directories_length1 = _tmp120__length1;
	_tmp121_ = settings;
	_tmp122_ = vala_doc_gir_directories;
	_tmp122__length1 = _vala_array_length (vala_doc_gir_directories);
	_tmp123_ = (_tmp122_ != NULL) ? _vala_array_dup4 (_tmp122_, _tmp122__length1) : _tmp122_;
	_tmp123__length1 = _tmp122__length1;
	_tmp121_->gir_directories = (_vala_array_free (_tmp121_->gir_directories, _tmp121_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp121_->gir_directories = _tmp123_;
	_tmp121_->gir_directories_length1 = _tmp123__length1;
	_tmp124_ = settings;
	_tmp125_ = vala_doc_target_glib;
	_tmp126_ = g_strdup (_tmp125_);
	_g_free0 (_tmp124_->target_glib);
	_tmp124_->target_glib = _tmp126_;
	_tmp127_ = settings;
	_tmp127_->use_svg_images = vala_doc_use_svg_images;
	_tmp128_ = settings;
	_tmp129_ = vala_doc_tsources;
	_tmp129__length1 = _vala_array_length (vala_doc_tsources);
	_tmp130_ = (_tmp129_ != NULL) ? _vala_array_dup5 (_tmp129_, _tmp129__length1) : _tmp129_;
	_tmp130__length1 = _tmp129__length1;
	_tmp128_->source_files = (_vala_array_free (_tmp128_->source_files, _tmp128_->source_files_length1, (GDestroyNotify) g_free), NULL);
	_tmp128_->source_files = _tmp130_;
	_tmp128_->source_files_length1 = _tmp130__length1;
	_tmp131_ = settings;
	_tmp132_ = vala_doc_packages;
	_tmp132__length1 = _vala_array_length (vala_doc_packages);
	_tmp133_ = (_tmp132_ != NULL) ? _vala_array_dup6 (_tmp132_, _tmp132__length1) : _tmp132_;
	_tmp133__length1 = _tmp132__length1;
	_tmp131_->packages = (_vala_array_free (_tmp131_->packages, _tmp131_->packages_length1, (GDestroyNotify) g_free), NULL);
	_tmp131_->packages = _tmp133_;
	_tmp131_->packages_length1 = _tmp133__length1;
	_tmp134_ = settings;
	_tmp135_ = vala_doc_profile;
	_tmp134_->profile = _tmp135_;
	_tmp136_ = settings;
	_tmp137_ = vala_doc_defines;
	_tmp137__length1 = _vala_array_length (vala_doc_defines);
	_tmp138_ = (_tmp137_ != NULL) ? _vala_array_dup7 (_tmp137_, _tmp137__length1) : _tmp137_;
	_tmp138__length1 = _tmp137__length1;
	_tmp136_->defines = (_vala_array_free (_tmp136_->defines, _tmp136_->defines_length1, (GDestroyNotify) g_free), NULL);
	_tmp136_->defines = _tmp138_;
	_tmp136_->defines_length1 = _tmp138__length1;
	_tmp139_ = settings;
	_tmp140_ = vala_doc_alternative_resource_dirs;
	_tmp140__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	_tmp141_ = (_tmp140_ != NULL) ? _vala_array_dup8 (_tmp140_, _tmp140__length1) : _tmp140_;
	_tmp141__length1 = _tmp140__length1;
	_tmp139_->alternative_resource_dirs = (_vala_array_free (_tmp139_->alternative_resource_dirs, _tmp139_->alternative_resource_dirs_length1, (GDestroyNotify) g_free), NULL);
	_tmp139_->alternative_resource_dirs = _tmp141_;
	_tmp139_->alternative_resource_dirs_length1 = _tmp141__length1;
	doclet = NULL;
	_tmp142_ = reporter;
	_tmp144_ = vala_doc_create_module_loader (self, _tmp142_, &_tmp143_);
	_g_object_unref0 (doclet);
	doclet = _tmp143_;
	modules = _tmp144_;
	_tmp146_ = reporter;
	_tmp147_ = valadoc_error_reporter_get_errors (_tmp146_);
	_tmp148_ = _tmp147_;
	if (_tmp148_ > 0) {
		_tmp145_ = TRUE;
	} else {
		ValadocModuleLoader* _tmp149_;
		_tmp149_ = modules;
		_tmp145_ = _tmp149_ == NULL;
	}
	if (_tmp145_) {
		ValadocErrorReporter* _tmp150_;
		_tmp150_ = reporter;
		result = vala_doc_quit (_tmp150_);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp151_ = valadoc_tree_builder_new ();
	builder = _tmp151_;
	_tmp152_ = builder;
	_tmp153_ = settings;
	_tmp154_ = reporter;
	_tmp155_ = valadoc_tree_builder_build (_tmp152_, _tmp153_, _tmp154_);
	doctree = _tmp155_;
	_tmp156_ = reporter;
	_tmp157_ = valadoc_error_reporter_get_errors (_tmp156_);
	_tmp158_ = _tmp157_;
	if (_tmp158_ > 0) {
		ValadocErrorReporter* _tmp159_;
		_g_object_unref0 (doclet);
		doclet = NULL;
		_tmp159_ = reporter;
		result = vala_doc_quit (_tmp159_);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp160_ = builder;
	_tmp161_ = valadoc_symbol_resolver_new (_tmp160_);
	resolver = _tmp161_;
	_tmp162_ = doctree;
	_tmp163_ = resolver;
	valadoc_api_tree_accept (_tmp162_, (ValadocApiVisitor*) _tmp163_);
	_tmp164_ = valadoc_api_child_symbol_registrar_new ();
	registrar = _tmp164_;
	_tmp165_ = doctree;
	_tmp166_ = registrar;
	valadoc_api_tree_accept (_tmp165_, (ValadocApiVisitor*) _tmp166_);
	_tmp167_ = settings;
	_tmp168_ = reporter;
	_tmp169_ = doctree;
	_tmp170_ = modules;
	_tmp171_ = valadoc_documentation_parser_new (_tmp167_, _tmp168_, _tmp169_, _tmp170_);
	docparser = _tmp171_;
	_tmp172_ = doctree;
	if (!valadoc_api_tree_create_tree (_tmp172_)) {
		ValadocErrorReporter* _tmp173_;
		_tmp173_ = reporter;
		result = vala_doc_quit (_tmp173_);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp174_ = doctree;
	_tmp175_ = docparser;
	_tmp176_ = modules;
	_tmp177_ = settings;
	_tmp178_ = reporter;
	_tmp179_ = valadoc_importer_valadoc_documentation_importer_new (_tmp174_, _tmp175_, _tmp176_, _tmp177_, _tmp178_);
	_tmp180_ = doctree;
	_tmp181_ = docparser;
	_tmp182_ = modules;
	_tmp183_ = settings;
	_tmp184_ = reporter;
	_tmp185_ = valadoc_importer_gir_documentation_importer_new (_tmp180_, _tmp181_, _tmp182_, _tmp183_, _tmp184_);
	_tmp186_ = g_new0 (ValadocImporterDocumentationImporter*, 2 + 1);
	_tmp186_[0] = (ValadocImporterDocumentationImporter*) _tmp179_;
	_tmp186_[1] = (ValadocImporterDocumentationImporter*) _tmp185_;
	importers = _tmp186_;
	importers_length1 = 2;
	_importers_size_ = importers_length1;
	_tmp187_ = doctree;
	_tmp188_ = docparser;
	valadoc_api_tree_parse_comments (_tmp187_, _tmp188_);
	_tmp189_ = reporter;
	_tmp190_ = valadoc_error_reporter_get_errors (_tmp189_);
	_tmp191_ = _tmp190_;
	if (_tmp191_ > 0) {
		ValadocErrorReporter* _tmp192_;
		_tmp192_ = reporter;
		result = vala_doc_quit (_tmp192_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp193_ = doctree;
	_tmp194_ = importers;
	_tmp194__length1 = importers_length1;
	_tmp195_ = vala_doc_import_packages;
	_tmp195__length1 = _vala_array_length (vala_doc_import_packages);
	_tmp196_ = vala_doc_import_directories;
	_tmp196__length1 = _vala_array_length (vala_doc_import_directories);
	valadoc_api_tree_import_comments (_tmp193_, _tmp194_, (gint) _tmp194__length1, _tmp195_, (gint) _tmp195__length1, _tmp196_, (gint) _tmp196__length1);
	_tmp197_ = reporter;
	_tmp198_ = valadoc_error_reporter_get_errors (_tmp197_);
	_tmp199_ = _tmp198_;
	if (_tmp199_ > 0) {
		ValadocErrorReporter* _tmp200_;
		_tmp200_ = reporter;
		result = vala_doc_quit (_tmp200_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp201_ = doctree;
	_tmp202_ = docparser;
	valadoc_api_tree_check_comments (_tmp201_, _tmp202_);
	_tmp203_ = reporter;
	_tmp204_ = valadoc_error_reporter_get_errors (_tmp203_);
	_tmp205_ = _tmp204_;
	if (_tmp205_ > 0) {
		ValadocErrorReporter* _tmp206_;
		_tmp206_ = reporter;
		result = vala_doc_quit (_tmp206_);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_g_object_unref0 (resolver);
		_valadoc_api_tree_unref0 (doctree);
		_vala_code_visitor_unref0 (builder);
		_g_object_unref0 (modules);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		_g_object_unref0 (reporter);
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp207_ = vala_doc_gir_name;
	if (_tmp207_ != NULL) {
		ValadocGirWriter* gir_writer = NULL;
		ValadocSymbolResolver* _tmp208_;
		ValadocGirWriter* _tmp209_;
		ValadocGirWriter* _tmp210_;
		ValadocApiTree* _tmp211_;
		ValaCodeContext* _tmp212_;
		ValaCodeContext* _tmp213_;
		ValadocSettings* _tmp214_;
		const gchar* _tmp215_;
		ValadocSettings* _tmp216_;
		const gchar* _tmp217_;
		ValadocSettings* _tmp218_;
		const gchar* _tmp219_;
		gchar* _tmp220_;
		gchar* _tmp221_;
		ValadocSettings* _tmp222_;
		const gchar* _tmp223_;
		ValadocSettings* _tmp224_;
		const gchar* _tmp225_;
		ValadocSettings* _tmp226_;
		const gchar* _tmp227_;
		ValadocErrorReporter* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		_tmp208_ = resolver;
		_tmp209_ = valadoc_gir_writer_new (_tmp208_);
		gir_writer = _tmp209_;
		_tmp210_ = gir_writer;
		_tmp211_ = doctree;
		_tmp212_ = valadoc_api_tree_get_context (_tmp211_);
		_tmp213_ = _tmp212_;
		_tmp214_ = settings;
		_tmp215_ = _tmp214_->gir_directory;
		_tmp216_ = settings;
		_tmp217_ = _tmp216_->gir_namespace;
		_tmp218_ = settings;
		_tmp219_ = _tmp218_->gir_version;
		_tmp220_ = g_strdup_printf ("%s-%s.gir", _tmp217_, _tmp219_);
		_tmp221_ = _tmp220_;
		_tmp222_ = settings;
		_tmp223_ = _tmp222_->gir_namespace;
		_tmp224_ = settings;
		_tmp225_ = _tmp224_->gir_version;
		_tmp226_ = settings;
		_tmp227_ = _tmp226_->pkg_name;
		vala_gir_writer_write_file ((ValaGIRWriter*) _tmp210_, _tmp213_, _tmp215_, _tmp221_, _tmp223_, _tmp225_, _tmp227_, NULL);
		_g_free0 (_tmp221_);
		_tmp228_ = reporter;
		_tmp229_ = valadoc_error_reporter_get_errors (_tmp228_);
		_tmp230_ = _tmp229_;
		if (_tmp230_ > 0) {
			ValadocErrorReporter* _tmp231_;
			_tmp231_ = reporter;
			result = vala_doc_quit (_tmp231_);
			_vala_code_visitor_unref0 (gir_writer);
			importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (docparser);
			_g_object_unref0 (registrar);
			_g_object_unref0 (resolver);
			_valadoc_api_tree_unref0 (doctree);
			_vala_code_visitor_unref0 (builder);
			_g_object_unref0 (modules);
			_g_object_unref0 (doclet);
			_g_object_unref0 (settings);
			_g_object_unref0 (reporter);
			_vala_code_context_unref0 (context);
			return result;
		}
		_vala_code_visitor_unref0 (gir_writer);
	}
	_tmp232_ = doclet;
	_tmp233_ = settings;
	_tmp234_ = doctree;
	_tmp235_ = reporter;
	valadoc_doclet_process (_tmp232_, _tmp233_, _tmp234_, _tmp235_);
	_tmp236_ = reporter;
	result = vala_doc_quit (_tmp236_);
	importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (docparser);
	_g_object_unref0 (registrar);
	_g_object_unref0 (resolver);
	_valadoc_api_tree_unref0 (doctree);
	_vala_code_visitor_unref0 (builder);
	_g_object_unref0 (modules);
	_g_object_unref0 (doclet);
	_g_object_unref0 (settings);
	_g_object_unref0 (reporter);
	_vala_code_context_unref0 (context);
	return result;
}

static gint
vala_doc_main (gchar** args,
               gint args_length1)
{
	const gchar* _tmp0_;
	ValaDoc* valadoc = NULL;
	ValaDoc* _tmp15_;
	ValaDoc* _tmp16_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	setlocale (LC_ALL, "");
	_tmp0_ = vala_get_build_version ();
	if (g_strcmp0 (_tmp0_, VALA_BUILD_VERSION) != 0) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stderr;
		_tmp2_ = vala_get_build_version ();
		fprintf (_tmp1_, "Integrity check failed (libvala %s doesn't match valadoc %s)\n", _tmp2_, VALA_BUILD_VERSION);
		result = 1;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp3_;
		GOptionContext* _tmp4_;
		GOptionContext* _tmp5_;
		GOptionContext* _tmp6_;
		_tmp3_ = g_option_context_new ("- Vala Documentation Tool");
		opt_context = _tmp3_;
		_tmp4_ = opt_context;
		g_option_context_set_help_enabled (_tmp4_, TRUE);
		_tmp5_ = opt_context;
		g_option_context_add_main_entries (_tmp5_, VALA_DOC_options, NULL);
		_tmp6_ = opt_context;
		g_option_context_parse (_tmp6_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp7_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		FILE* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "%s\n", _tmp10_);
		_tmp11_ = stdout;
		_tmp12_ = args[0];
		fprintf (_tmp11_, "Run '%s --help' to see a full list of available command line options.\n", _tmp12_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp13_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	if (vala_doc_version) {
		FILE* _tmp14_;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "Valadoc %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp15_ = vala_doc_new ();
	valadoc = _tmp15_;
	_tmp16_ = valadoc;
	result = vala_doc_run (_tmp16_);
	_g_object_unref0 (valadoc);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_doc_main (argv, argc);
}

ValaDoc*
vala_doc_construct (GType object_type)
{
	ValaDoc * self = NULL;
	self = (ValaDoc*) g_object_new (object_type, NULL);
	return self;
}

ValaDoc*
vala_doc_new (void)
{
	return vala_doc_construct (TYPE_VALA_DOC);
}

static void
vala_doc_class_init (ValaDocClass * klass,
                     gpointer klass_data)
{
	vala_doc_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vala_doc_finalize;
}

static void
vala_doc_instance_init (ValaDoc * self,
                        gpointer klass)
{
}

static void
vala_doc_finalize (GObject * obj)
{
	ValaDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_DOC, ValaDoc);
	G_OBJECT_CLASS (vala_doc_parent_class)->finalize (obj);
}

static GType
vala_doc_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoc), 0, (GInstanceInitFunc) vala_doc_instance_init, NULL };
	GType vala_doc_type_id;
	vala_doc_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDoc", &g_define_type_info, 0);
	return vala_doc_type_id;
}

GType
vala_doc_get_type (void)
{
	static volatile gsize vala_doc_type_id__volatile = 0;
	if (g_once_init_enter (&vala_doc_type_id__volatile)) {
		GType vala_doc_type_id;
		vala_doc_type_id = vala_doc_get_type_once ();
		g_once_init_leave (&vala_doc_type_id__volatile, vala_doc_type_id);
	}
	return vala_doc_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

