#ifndef CONFIG
#define CONFIG "config.h"
#endif // CONFIG
#include CONFIG

#ifndef NO_INTERNAL_DATA

#include "kmsdata.h"

#if defined(FULL_INTERNAL_DATA)

uint8_t DefaultKmsData[] =
{
	/* 0000 */ 0x4B, 0x4D, 0x44, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,   // KMD.............
	/* 0010 */ 0x1D, 0x00, 0x00, 0x00, 0xCA, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...............
	/* 0020 */ 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........h.......
	/* 0030 */ 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........H.......
	/* 0040 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ................
	/* 0050 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0xC0, 0x97, 0xD7, 0x20,   // .[........ 
	/* 0060 */ 0xBF, 0xC4, 0x08, 0x22, 0x00, 0x00, 0x00, 0x00, 0x56, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ."....V.......
	/* 0070 */ 0x80, 0x4F, 0x3E, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0xDC, 0x0B,   // .O>L....`.....
	/* 0080 */ 0x7F, 0x6A, 0xFE, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .j.............
	/* 0090 */ 0x00, 0x11, 0x07, 0x51, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x8E, 0xF2, 0x0D,   // ...Q..........
	/* 00A0 */ 0xFF, 0x3F, 0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ?B............
	/* 00B0 */ 0x00, 0x9A, 0x00, 0x56, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x40, 0x17, 0x0C, 0x1A,   // ...V.......@...
	/* 00C0 */ 0xBF, 0xC8, 0x5B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x31, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // [.....1 ......
	/* 00D0 */ 0x80, 0x33, 0xE4, 0x58, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x00, 0x00, 0xC0, 0xE1, 0xE4, 0x00,   // .3X.........
	/* 00E0 */ 0xFF, 0xC9, 0x9A, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x8B, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;..... ......
	/* 00F0 */ 0x00, 0x29, 0xA8, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x5A, 0xB2, 0x27,   // .)[........Z'
	/* 0100 */ 0x7F, 0x87, 0xE3, 0x28, 0x00, 0x00, 0x00, 0x00, 0x34, 0x27, 0xC9, 0x55, 0x82, 0xD6, 0x71, 0x4D,   // ..(....4'U.qM
	/* 0110 */ 0x98, 0x3E, 0xD6, 0xEC, 0x3F, 0x16, 0x05, 0x9F, 0x84, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .>?....!......
	/* 0120 */ 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x81, 0x28, 0xA5, 0x59, 0x89, 0xA9, 0x9D, 0x47,   // ...2.....(Y..G
	/* 0130 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x8C, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.c.!......
	/* 0140 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x01, 0x00, 0x15, 0xCE, 0xF1, 0x0F, 0x89, 0xA9, 0x9D, 0x47,   // ............G
	/* 0150 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x97, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.c.!......
	/* 0160 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x05, 0x00, 0xFB, 0xB1, 0x49, 0x84, 0xEA, 0xF0, 0x7A, 0x49,   // ........I.zI
	/* 0170 */ 0x99, 0xAB, 0x66, 0xCA, 0x96, 0xE9, 0xA0, 0xF5, 0xA3, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .f..!......
	/* 0180 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x59, 0x56, 0xB1, 0x11, 0x03, 0xE6, 0xF1, 0x4C,   // ........YV..L
	/* 0190 */ 0x9C, 0x1F, 0xF0, 0xEC, 0x01, 0xB8, 0x18, 0x88, 0xB7, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .....!......
	/* 01A0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x36, 0xD6, 0x7C, 0xD2, 0x62, 0x19, 0xE9, 0x44,   // ........6|b.D
	/* 01B0 */ 0x8B, 0x4F, 0x27, 0xB6, 0xC2, 0x3E, 0xFB, 0x85, 0xD0, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .O'>.!......
	/* 01C0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x23, 0xBF, 0xA0, 0x7B, 0xF5, 0xD0, 0x72, 0x40,   // ........#.{r@
	/* 01D0 */ 0x91, 0xD9, 0xD5, 0x5A, 0xF5, 0xA4, 0x81, 0xB6, 0xEC, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z.!......
	/* 01E0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00, 0xC0, 0xE3, 0x9F, 0x96, 0xEC, 0xA3, 0x1A, 0x49,   // ...........I
	/* 01F0 */ 0x9F, 0x25, 0x42, 0x36, 0x05, 0xDE, 0xB3, 0x65, 0x08, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .%B6.޳e."......
	/* 0200 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x58, 0x13, 0xC5, 0xE1, 0x3E, 0xFE, 0x03, 0x42,   // ........X.>.B
	/* 0210 */ 0xA4, 0xA2, 0x3B, 0x6B, 0x20, 0xC9, 0x73, 0x4E, 0x21, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ;k sN!"......
	/* 0220 */ 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x4F, 0x13, 0xE2, 0x58, 0x11, 0x8E, 0x17, 0x4D,   // ........O.X...M
	/* 0230 */ 0x9C, 0xB2, 0x91, 0x06, 0x9C, 0x15, 0x11, 0x48, 0x35, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ......H5"......
	/* 0240 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x19, 0x52, 0xDE, 0x7F, 0xFA, 0xFB, 0x4A, 0x48,   // .........R.JH
	/* 0250 */ 0x82, 0xC9, 0x34, 0xD1, 0xAD, 0x53, 0xE8, 0x56, 0x4E, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .4ѭSVN"......
	/* 0260 */ 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x7B, 0xB9, 0xBB, 0xA4, 0x8C, 0x28, 0x4A,   // ........;{.(J
	/* 0270 */ 0x97, 0x17, 0x89, 0xFA, 0xBD, 0x42, 0xC4, 0xAC, 0x58, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...BĬX"......
	/* 0280 */ 0x00, 0x00, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0x58, 0xB3, 0x40, 0x3C, 0x48, 0x59, 0xAF, 0x45,   // ........X@<HYE
	/* 0290 */ 0x92, 0x3B, 0x53, 0xD2, 0x1F, 0xCC, 0x7E, 0x79, 0x6B, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;S.~yk"......
	/* 02A0 */ 0x00, 0x00, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x90, 0x68, 0x64, 0x6D, 0x06, 0x36, 0x1A, 0x46,   // .........hdm.6.F
	/* 02B0 */ 0x86, 0xAB, 0x59, 0x8B, 0xB8, 0x4A, 0xCE, 0x82, 0x7E, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Y.J.~"......
	/* 02C0 */ 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x80, 0xC7, 0x8F, 0xCB, 0x05, 0x2C, 0x5A, 0x49,   // ...........,ZI
	/* 02D0 */ 0x97, 0x10, 0x85, 0xAF, 0xFF, 0xC9, 0x04, 0xD7, 0x93, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....."......
	/* 02E0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xBB, 0xA0, 0x94, 0x5F, 0xA0, 0xD5, 0x81, 0x40,   // .........._..@
	/* 02F0 */ 0xA6, 0x85, 0x58, 0x19, 0x41, 0x8B, 0x2F, 0xE0, 0xA8, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .X.A./"......
	/* 0300 */ 0x00, 0x00, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0xE4, 0x56, 0xE1, 0x33, 0x6F, 0xB7, 0x52, 0x4A,   // ........V3oRJ
	/* 0310 */ 0x9F, 0x91, 0xF6, 0x41, 0xDD, 0x95, 0xAC, 0x48, 0xB8, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..A.H"......
	/* 0320 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x87, 0x33, 0xE5, 0x8F, 0x87, 0x30, 0x47, 0x44,   // .........3..0GD
	/* 0330 */ 0x89, 0x85, 0xF7, 0x51, 0x32, 0x21, 0x5A, 0xC9, 0xDC, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Q2!Z"......
	/* 0340 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xF3, 0xFD, 0x21, 0x8A, 0xC5, 0xCB, 0xEB, 0x44,   // ........!.D
	/* 0350 */ 0x83, 0xF3, 0xFE, 0x28, 0x4E, 0x66, 0x80, 0xA7, 0x0C, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .(Nf..#......
	/* 0360 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xCC, 0xC6, 0x0F, 0x0E, 0xFF, 0xAE, 0x4F,   // ..........O
	/* 0370 */ 0x9D, 0x08, 0x43, 0x70, 0x78, 0x5B, 0xF7, 0xED, 0x2F, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Cpx[/#......
	/* 0380 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xB6, 0xF5, 0x87, 0xCA, 0x46, 0xCD, 0xC0, 0x40,   // .........F@
	/* 0390 */ 0xB0, 0x6D, 0x8E, 0xCD, 0x57, 0xA4, 0x37, 0x3F, 0x56, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // m.W7?V#......
	/* 03A0 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x89, 0x26, 0xCA, 0xB2, 0xA8, 0xA9, 0xD7, 0x42,   // .........&ʲB
	/* 03B0 */ 0x93, 0x8D, 0xCF, 0x8E, 0x9F, 0x20, 0x19, 0x58, 0x89, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .... .X.#......
	/* 03C0 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x71, 0xCB, 0x65, 0x86, 0x8C, 0x46, 0xA3, 0x4A,   // ........qe..FJ
	/* 03D0 */ 0xA3, 0x37, 0xCB, 0x9B, 0xC9, 0xD5, 0xEA, 0xAC, 0xAF, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 7.꬯#......
	/* 03E0 */ 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0xD3, 0xEF, 0x56, 0x84, 0x04, 0x0C, 0x89, 0x40,   // ........V....@
	/* 03F0 */ 0x87, 0x40, 0x5B, 0x72, 0x38, 0x53, 0x5A, 0x65, 0xC3, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .@[r8SZe#......
	/* 0400 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x69, 0xC0, 0x9F, 0x6E, 0x7D, 0x25, 0xC4, 0x4B,   // ........i.n}%K
	/* 0410 */ 0xB4, 0xA7, 0x75, 0x05, 0x14, 0xD3, 0x27, 0x43, 0xDA, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // u..'C#......
	/* 0420 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x70, 0x52, 0x5F, 0x6D, 0xAC, 0x31, 0x3E, 0x43,   // ........pR_m1>C
	/* 0430 */ 0xB9, 0x0A, 0x39, 0x89, 0x29, 0x23, 0xC6, 0x57, 0xEE, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .9.)#W#......
	/* 0440 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x01, 0x00, 0x00, 0xDC, 0x64, 0x2A, 0x21, 0xB1, 0x43, 0x3D, 0x4D,   // ........d*!C=M
	/* 0450 */ 0xA3, 0x0C, 0x2F, 0xC6, 0x9D, 0x20, 0x95, 0xC6, 0x05, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ./. ..$......
	/* 0460 */ 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x46, 0xF9, 0x5A, 0xE8, 0x25, 0x2E, 0xB7, 0x47,   // ........FZ%.G
	/* 0470 */ 0x83, 0xE1, 0xBE, 0xBC, 0xEB, 0xEA, 0xC6, 0x11, 0x13, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ᾼ..$......
	/* 0480 */ 0x01, 0x00, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xBF, 0xF1, 0xA6, 0xE6, 0x40, 0x9D, 0xC3, 0x40,   // ........@.@
	/* 0490 */ 0xAA, 0x9F, 0xC7, 0x7B, 0xA2, 0x15, 0x78, 0xC0, 0x1F, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .{.x.$......
	/* 04A0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x68, 0x79, 0x4C, 0xAA, 0xDA, 0xB9, 0x80, 0x46,   // ........hyLڹ.F
	/* 04B0 */ 0x92, 0xB6, 0xAC, 0xB2, 0x5E, 0x2F, 0x86, 0x6C, 0x2B, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .^/.l+$......
	/* 04C0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x1B, 0xF6, 0xB5, 0x85, 0x0B, 0x32, 0xE3, 0x4B,   // ...........2K
	/* 04D0 */ 0x81, 0x4A, 0xB7, 0x6B, 0x2B, 0xFA, 0xFC, 0x82, 0x45, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Jk+.E$......
	/* 04E0 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xB1, 0x9E, 0x7D, 0x61, 0x36, 0xEF, 0x82, 0x4F,   // .........}a6.O
	/* 04F0 */ 0x86, 0xE0, 0xA6, 0x5A, 0xE0, 0x7B, 0x96, 0xC6, 0x51, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z{.Q$......
	/* 0500 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x62, 0xEB, 0xE8, 0x8D, 0xE0, 0xBB, 0xAC, 0x40,   // ........b.໬@
	/* 0510 */ 0xAC, 0x17, 0xF7, 0x55, 0x95, 0x07, 0x1E, 0xA3, 0x5D, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .U...]$......
	/* 0520 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xC1, 0x9C, 0xA9, 0x19, 0x77, 0x06, 0x43,   // ..........w.C
	/* 0530 */ 0x96, 0x45, 0x29, 0x41, 0x02, 0xFB, 0xFF, 0x95, 0x77, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .E)A..w$......
	/* 0540 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x55, 0xAE, 0xE1, 0x34, 0xF8, 0x27, 0x50, 0x49,   // ........U4'PI
	/* 0550 */ 0x88, 0x77, 0x7A, 0x03, 0xBE, 0x5F, 0xB1, 0x81, 0x96, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .wz._..$......
	/* 0560 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xBB, 0x3C, 0x4D, 0x03, 0x4B, 0x5D, 0x45, 0x42,   // ........<M.K]EB
	/* 0570 */ 0xB3, 0xF8, 0xF8, 0x45, 0x71, 0x31, 0x40, 0x78, 0xB5, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Eq1@x$......
	/* 0580 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xEA, 0x32, 0xDE, 0xEE, 0xAA, 0x62, 0x46,   // ........2bF
	/* 0590 */ 0x94, 0x44, 0xC1, 0xBE, 0xFB, 0x41, 0xBD, 0xE2, 0xD4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .DA$......
	/* 05A0 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xE5, 0x62, 0xC3, 0x90, 0xA1, 0x0D, 0xFD, 0x4B,   // ........b..K
	/* 05B0 */ 0xB5, 0x3B, 0xB8, 0x7D, 0x30, 0x9A, 0xDE, 0x43, 0xF1, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ;}0.C$......
	/* 05C0 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x95, 0xE3, 0x73, 0x0C, 0xFC, 0x0D, 0x40,   // ........|.s..@
	/* 05D0 */ 0x91, 0x84, 0x5F, 0x7B, 0x6F, 0x2E, 0xB4, 0x09, 0x26, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .._{o..&%......
	/* 05E0 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xB3, 0xFA, 0xD2, 0x32, 0xA8, 0xE4, 0xC2, 0x42,   // ........2B
	/* 05F0 */ 0x92, 0x3B, 0x4B, 0xF4, 0xFD, 0x13, 0xE6, 0xEE, 0x59, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;K.Y%......
	/* 0600 */ 0x00, 0x01, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x33, 0xA3, 0x03, 0x71, 0xC8, 0xB8, 0xCC, 0x49,   // ........3.qȸI
	/* 0610 */ 0x93, 0xCE, 0xD3, 0x7C, 0x09, 0x68, 0x7F, 0x92, 0x79, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .|.h..y%......
	/* 0620 */ 0x00, 0x01, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x83, 0xD3, 0xB2, 0xE0, 0x12, 0xD1, 0x3F, 0x41,   // .........Ӳ.?A
	/* 0630 */ 0x8A, 0x80, 0x97, 0xF3, 0x73, 0xA5, 0x82, 0x0C, 0x9B, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...s...%......
	/* 0640 */ 0x00, 0x03, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00, 0xFB, 0x54, 0x84, 0xE3, 0xA4, 0x41, 0x59, 0x4F,   // ........T.AYO
	/* 0650 */ 0xA5, 0xDC, 0x25, 0x08, 0x0E, 0x35, 0x47, 0x30, 0xB3, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // %..5G0%......
	/* 0660 */ 0x00, 0x03, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00, 0x60, 0x5A, 0x5A, 0x2D, 0x40, 0x30, 0xBF, 0x48,   // ........`ZZ-@0H
	/* 0670 */ 0xBE, 0xB0, 0xFC, 0xD7, 0x70, 0xC2, 0x0C, 0xE0, 0xCC, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // p.%......
	/* 0680 */ 0x00, 0x04, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x83, 0x6D, 0x77, 0x9F, 0x56, 0x71, 0xB2, 0x45,   // .........mw.VqE
	/* 0690 */ 0x8A, 0x5C, 0x35, 0x9B, 0x9C, 0x9F, 0x22, 0xA3, 0xEC, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .\5..."%......
	/* 06A0 */ 0x00, 0x04, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x99, 0x7C, 0xE9, 0x58, 0x77, 0xF3, 0xF1, 0x4E,   // .........|XwN
	/* 06B0 */ 0x81, 0xD5, 0x4A, 0xD5, 0x52, 0x2B, 0x5F, 0xD8, 0x0E, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .JR+_.&......
	/* 06C0 */ 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x44, 0x75, 0x10, 0xA9, 0xA0, 0xF4, 0x53, 0x40,   // ........Du..S@
	/* 06D0 */ 0xA9, 0x6A, 0x14, 0x79, 0xAB, 0xDE, 0xF9, 0x12, 0x1E, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // j.y..&......
	/* 06E0 */ 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x51, 0x17, 0x9E, 0x7B, 0xDA, 0xA8, 0x75, 0x4F,   // ........Q..{ڨuO
	/* 06F0 */ 0x95, 0x60, 0x5F, 0xAD, 0xFE, 0x3D, 0x8E, 0x38, 0x3F, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .`_=.8?&......
	/* 0700 */ 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x57, 0x8A, 0x91, 0xCD, 0x1B, 0xA4, 0x82, 0x4C,   // ........W....L
	/* 0710 */ 0x8D, 0xCE, 0x1A, 0x53, 0x8E, 0x22, 0x1A, 0x83, 0x51, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..S."..Q&......
	/* 0720 */ 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x88, 0x22, 0xC4, 0xE0, 0x0C, 0x98, 0x88, 0x47,   // ........."...G
	/* 0730 */ 0xA0, 0x14, 0xC0, 0x80, 0xD2, 0xE1, 0x92, 0x6E, 0x71, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....nq&......
	/* 0740 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x55, 0x23, 0x10, 0x3C, 0x27, 0xD0, 0xC6, 0x42,   // ........U#.<'B
	/* 0750 */ 0xAD, 0x23, 0x2E, 0x7E, 0xF8, 0xA0, 0x25, 0x85, 0x86, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // #.~.%..&......
	/* 0760 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x21, 0x11, 0x11, 0x73, 0x38, 0x56, 0xF6, 0x40,   // ........!..s8V@
	/* 0770 */ 0xBC, 0x11, 0xF1, 0xD7, 0xB0, 0xD6, 0x43, 0x00, 0x9D, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .װC..&......
	/* 0780 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xA4, 0x51, 0x7B, 0x04, 0x0C, 0x8F, 0x4E,   // ........lQ{...N
	/* 0790 */ 0x9A, 0xF4, 0x84, 0x96, 0xCC, 0xA9, 0x0D, 0x5E, 0xB3, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...̩.^&......
	/* 07A0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xB7, 0x38, 0xB8, 0x87, 0xB6, 0x41, 0x90, 0x45,   // ........8.A.E
	/* 07B0 */ 0x83, 0x18, 0x57, 0x97, 0x95, 0x1D, 0x85, 0x29, 0xD3, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..W....)&......
	/* 07C0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xE2, 0xE3, 0x72, 0xE2, 0x2F, 0x73, 0x65, 0x4C,   // ........r/seL
	/* 07D0 */ 0xA8, 0xF0, 0x48, 0x47, 0x47, 0xD0, 0xD9, 0x47, 0xF5, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // HGGG&......
	/* 07E0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x92, 0xC0, 0xBB, 0x82, 0x50, 0xBC, 0x16, 0x4E,   // ..........P.N
	/* 07F0 */ 0x8E, 0x18, 0xB7, 0x4F, 0xC4, 0x86, 0xAE, 0xC3, 0x0D, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..O..'......
	/* 0800 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xD3, 0x71, 0x15, 0x4B, 0xFB, 0xBA, 0x40, 0x4B,   // ........q.K@K
	/* 0810 */ 0x80, 0x87, 0xA9, 0x61, 0xBE, 0x2C, 0xAF, 0x65, 0x31, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..a,e1'......
	/* 0820 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x92, 0x73, 0xE6, 0x2D, 0xA7, 0xB7, 0x2A, 0x46,   // .........s-*F
	/* 0830 */ 0xB1, 0xCA, 0x10, 0x8D, 0xD1, 0x89, 0xF5, 0x88, 0x57, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....W'......
	/* 0840 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x82, 0xFC, 0x1A, 0x3F, 0xAC, 0xF8, 0x6C, 0x4F,   // ..........?lO
	/* 0850 */ 0x80, 0x05, 0x1D, 0x23, 0x3E, 0x60, 0x6E, 0xEE, 0x6F, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...#>`no'......
	/* 0860 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x8C, 0xB1, 0x00, 0x53, 0x33, 0x2E, 0xC2, 0x4D,   // ..........S3.M
	/* 0870 */ 0x82, 0x91, 0x47, 0xFF, 0xCE, 0xC7, 0x46, 0xDD, 0x91, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..GF.'......
	/* 0880 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x5A, 0x0B, 0xA8, 0xAD, 0x76, 0x8B, 0x42,   // ........Z.v.B
	/* 0890 */ 0xB0, 0x5D, 0xA4, 0x7D, 0x2D, 0xFF, 0xEE, 0xBF, 0xB5, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ]}-'......
	/* 08A0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x01, 0x82, 0x80, 0xFF, 0xC6, 0xFE, 0xD4, 0x4F,   // ...........O
	/* 08B0 */ 0xAE, 0x16, 0xAB, 0xBD, 0xDA, 0xDE, 0x57, 0x06, 0xCF, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .W.'......
	/* 08C0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x05, 0xAB, 0xF2, 0x43, 0x87, 0x7C, 0x56, 0x4D,   // .........C.|VM
	/* 08D0 */ 0xB2, 0x7C, 0x44, 0xD0, 0xF9, 0xA3, 0xDA, 0xBD, 0xEF, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // |Dڽ'......
	/* 08E0 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x65, 0x8E, 0x86, 0xEC, 0xDF, 0xFA, 0x59, 0x47,   // ........e..YG
	/* 08F0 */ 0xB2, 0x3E, 0x93, 0xFE, 0x37, 0xF2, 0xCC, 0x29, 0x0D, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // >.7).(......
	/* 0900 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xEA, 0x50, 0xDB, 0xE4, 0xA1, 0xBD, 0x66, 0x45,   // ........P䡽fE
	/* 0910 */ 0xB0, 0x47, 0x0C, 0xA5, 0x0A, 0xBC, 0x6F, 0x07, 0x38, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // G..o.8(......
	/* 0920 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x14, 0xF8, 0xF4, 0x0D, 0x57, 0x3F, 0x8B, 0x4B,   // ..........W?.K
	/* 0930 */ 0x9A, 0x9D, 0xFD, 0xDA, 0xDC, 0xD6, 0x9F, 0xAC, 0x51, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...Q(......
	/* 0940 */ 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x09, 0xE5, 0x2E, 0xAE, 0x34, 0x1B, 0xC0, 0x41,   // ..........4.A
	/* 0950 */ 0xAC, 0xB7, 0x6D, 0x46, 0x50, 0x16, 0x89, 0x15, 0x65, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // mFP...e(......
	/* 0960 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x08, 0xED, 0xBB, 0x46, 0x7B, 0x9C, 0xFC, 0x48,   // .........F{.H
	/* 0970 */ 0xA6, 0x14, 0x95, 0x25, 0x05, 0x73, 0xF4, 0xEA, 0x7A, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..%.sz(......
	/* 0980 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x05, 0xD6, 0xB6, 0x1C, 0xB3, 0x11, 0x14, 0x4E,   // .........ֶ...N
	/* 0990 */ 0xBB, 0x30, 0xDA, 0x91, 0xC8, 0xE3, 0x98, 0x3A, 0x91, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 0..:.(......
	/* 09A0 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x80, 0x99, 0x2E, 0xB9, 0xD5, 0xB9, 0x21, 0x48,   // ...........չ!H
	/* 09B0 */ 0x9C, 0x94, 0x14, 0x0F, 0x63, 0x2F, 0x63, 0x12, 0xA8, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....c/c.(......
	/* 09C0 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x29, 0x15, 0x04, 0x5A, 0xF8, 0xFE, 0x07, 0x4D,   // ........)..Z.M
	/* 09D0 */ 0xB0, 0x6F, 0xB5, 0x9B, 0x57, 0x3B, 0x32, 0xD2, 0xBF, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // o.W;2ҿ(......
	/* 09E0 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x9A, 0xA0, 0x54, 0x7B, 0xD5, 0x10, 0x4C,   // ...........T{.L
	/* 09F0 */ 0x8B, 0x69, 0xA8, 0x42, 0xD6, 0x59, 0x0A, 0xD5, 0xD8, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .iBY.(......
	/* 0A00 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x96, 0x78, 0x53, 0xDB, 0x6F, 0x37, 0xAE, 0x48,   // .........xSo7H
	/* 0A10 */ 0xA4, 0x92, 0x53, 0xD0, 0x54, 0x77, 0x73, 0xD0, 0xF1, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .STws(......
	/* 0A20 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x6A, 0x29, 0xA8, 0xE1, 0x37, 0xDB, 0xD1, 0x44,   // ........j)7D
	/* 0A30 */ 0x8C, 0xCE, 0x7B, 0xC9, 0x61, 0xD5, 0x9C, 0x54, 0x0D, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .{a.T.)......
	/* 0A40 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xD3, 0x6D, 0xAA, 0xB4, 0xC2, 0xE2, 0x40,   // ........m@
	/* 0A50 */ 0xA5, 0x44, 0xA6, 0xBB, 0xB3, 0xF5, 0xC3, 0x95, 0x29, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // D.))......
	/* 0A60 */ 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xD6, 0x4E, 0xC0, 0xC8, 0x55, 0x47, 0x4B,   // ........NUGK
	/* 0A70 */ 0x9F, 0x8E, 0x5A, 0x1F, 0x31, 0xCE, 0xEE, 0x60, 0x3A, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Z.1`:)......
	/* 0A80 */ 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0xA2, 0x84, 0x55, 0x9D, 0x85, 0x2D, 0x9A, 0x41,   // .........U..-.A
	/* 0A90 */ 0x98, 0x2C, 0xA0, 0x08, 0x88, 0xBB, 0x9D, 0xDF, 0x49, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .,....I)......
	/* 0AA0 */ 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0xA0, 0x90, 0x73, 0x19, 0xF6, 0x65, 0x95, 0x4A,   // ..........s.e.J
	/* 0AB0 */ 0xBD, 0xC4, 0x55, 0xD5, 0x8A, 0x3B, 0x02, 0x53, 0x69, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // U.;.Si)......
	/* 0AC0 */ 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0xD4, 0xFC, 0x60, 0x88, 0x7B, 0xA7, 0x20, 0x4A,   // ........`.{ J
	/* 0AD0 */ 0x90, 0x45, 0xA1, 0x50, 0xFF, 0x11, 0xD6, 0x09, 0x7A, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .EP..z)......
	/* 0AE0 */ 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0xA3, 0x18, 0x00, 0xA0, 0x0F, 0xF2, 0x32, 0x46,   // ............2F
	/* 0AF0 */ 0xBF, 0x7C, 0x8D, 0xAA, 0x53, 0x51, 0xC9, 0x14, 0x99, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // |.SQ..)......
	/* 0B00 */ 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0xAF, 0x8B, 0x01, 0x10, 0x21, 0xCE, 0x60, 0x40,   // ...........!`@
	/* 0B10 */ 0x80, 0xBD, 0x47, 0xFE, 0x74, 0xED, 0x4D, 0xAB, 0xB4, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .GtM)......
	/* 0B20 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x48, 0x18, 0xDB, 0x18, 0xE0, 0x12, 0x67, 0x41,   // ........H...gA
	/* 0B30 */ 0xB9, 0xD7, 0xDA, 0x7F, 0xCD, 0xA5, 0x07, 0xDB, 0xDD, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ͥ.)......
	/* 0B40 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x1B, 0x8E, 0x45, 0x7A, 0x83, 0xF6, 0x45,   // ..........Ez.E
	/* 0B50 */ 0xB9, 0xD5, 0x92, 0x5E, 0xD5, 0xD2, 0x99, 0xDE, 0x04, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .^..*......
	/* 0B60 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0xE7, 0x97, 0x49, 0xE1, 0x0A, 0x80, 0xF7, 0x4C,   // .........I..L
	/* 0B70 */ 0xAD, 0x10, 0xDE, 0x4B, 0x45, 0xB5, 0x78, 0xDB, 0x19, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .KEx.*......
	/* 0B80 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x6D, 0xCD, 0x8B, 0xA9, 0x43, 0x53, 0x03, 0x46,   // ........m.CS.F
	/* 0B90 */ 0x8A, 0xFE, 0x59, 0x08, 0xE4, 0x61, 0x11, 0x12, 0x30, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Y.a..0*......
	/* 0BA0 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0xC1, 0x45, 0xF2, 0xEB, 0xA8, 0x29, 0xAF, 0x4D,   // ........E)M
	/* 0BB0 */ 0x9C, 0xB1, 0x38, 0xDF, 0xC6, 0x08, 0xA8, 0xC8, 0x47, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .8.G*......
	/* 0BC0 */ 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x38, 0x32, 0x1C, 0xFE, 0x2A, 0x43, 0xA1, 0x43,   // ........82.*CC
	/* 0BD0 */ 0x8E, 0x25, 0x97, 0xE7, 0xD1, 0xEF, 0x10, 0xF3, 0x60, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .%..`*......
	/* 0BE0 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x6A, 0x45, 0xEE, 0xFF, 0x87, 0xCD, 0x90, 0x43,   // ........jE..C
	/* 0BF0 */ 0x8E, 0x07, 0x16, 0x14, 0x6C, 0x67, 0x2F, 0xD0, 0x71, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....lg/q*......
	/* 0C00 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x4F, 0xB7, 0x78, 0xDB, 0x1C, 0xEF, 0x92, 0x48,   // ........Ox..H
	/* 0C10 */ 0xAB, 0xFE, 0x1E, 0x66, 0xB8, 0x23, 0x1D, 0xF6, 0x86, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .f#..*......
	/* 0C20 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x64, 0x8A, 0x55, 0x78, 0x19, 0xDC, 0xFE, 0x43,   // ........d.Ux.C
	/* 0C30 */ 0xA0, 0xD0, 0x80, 0x75, 0xB2, 0xA3, 0x70, 0xA3, 0xA8, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..up*......
	/* 0C40 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x1D, 0x6A, 0x2C, 0xC7, 0x52, 0xF2, 0x7E, 0x4E,   // .........j,R~N
	/* 0C50 */ 0xBD, 0xD1, 0x3F, 0xCA, 0x34, 0x2A, 0xCB, 0x35, 0xBB, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ?4*5*......
	/* 0C60 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0xB5, 0x87, 0x8D, 0xE5, 0x26, 0x81, 0x80, 0x45,   // ..........&..E
	/* 0C70 */ 0x80, 0xFB, 0x86, 0x1B, 0x22, 0xF7, 0x92, 0x96, 0xDC, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..."..*......
	/* 0C80 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0xC7, 0x91, 0xB4, 0xCA, 0x18, 0xA9, 0x60, 0x4F,   // ..........`O
	/* 0C90 */ 0xB5, 0x02, 0xDA, 0xB7, 0x5E, 0x33, 0x4F, 0x40, 0xFD, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ڷ^3O@*......
	/* 0CA0 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x3D, 0xE6, 0x6C, 0x09, 0xAC, 0x4F, 0xA9, 0x48,   // ........=l.OH
	/* 0CB0 */ 0x82, 0xA9, 0x61, 0xAE, 0x9E, 0x80, 0x0E, 0x5F, 0x20, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .a..._ +......
	/* 0CC0 */ 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x32, 0x2B, 0x94, 0xE9, 0x55, 0x2E, 0x97, 0x41,   // ........2+.U..A
	/* 0CD0 */ 0xB0, 0xBD, 0x5F, 0xF5, 0x8C, 0xBA, 0x88, 0x60, 0x3D, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // _..`=+......
	/* 0CE0 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x12, 0x82, 0x99, 0xBA, 0x0A, 0x46, 0xDB, 0x44,   // ............FD
	/* 0CF0 */ 0xBF, 0xB5, 0x71, 0xBF, 0x09, 0xD1, 0xC6, 0x8B, 0x58, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // q..X+......
	/* 0D00 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xD6, 0xEC, 0xDD, 0xC6, 0x54, 0x23, 0x19, 0x4C,   // ........T#.L
	/* 0D10 */ 0x90, 0x9B, 0x30, 0x6A, 0x30, 0x58, 0x48, 0x4E, 0x84, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..0j0XHN.+......
	/* 0D20 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xA3, 0xE3, 0xF5, 0xB8, 0x33, 0xED, 0x08, 0x46,   // ........3.F
	/* 0D30 */ 0x81, 0xE1, 0x37, 0xD6, 0xC9, 0xDC, 0xFD, 0x9C, 0xA1, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .7.+......
	/* 0D40 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x1A, 0x67, 0x81, 0xD1, 0x79, 0xB1, 0x4E,   // .........g.yN
	/* 0D50 */ 0xB0, 0x04, 0x8C, 0xBB, 0xE1, 0x73, 0xAF, 0xEA, 0xCC, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..s+......
	/* 0D60 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x70, 0x3E, 0x11, 0x49, 0xFA, 0xA4, 0x48,   // ........\p>.IH
	/* 0D70 */ 0xBE, 0xEA, 0x7D, 0xD8, 0x79, 0xB4, 0x6B, 0x14, 0xE3, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // }yk.+......
	/* 0D80 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x81, 0x69, 0x6B, 0xC0, 0xFD, 0xD7, 0x35, 0x4A,   // .........ik5J
	/* 0D90 */ 0xB7, 0xB4, 0x05, 0x47, 0x42, 0xB7, 0xAF, 0x67, 0xFC, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .GBg+......
	/* 0DA0 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xD7, 0x76, 0x74, 0x48, 0x8E, 0xB4, 0x49,   // .........vtH.I
	/* 0DB0 */ 0xAB, 0x63, 0x4D, 0x0B, 0x81, 0x3A, 0x16, 0xE4, 0x15, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // cM..:..,......
	/* 0DC0 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x54, 0x2D, 0xB8, 0x0A, 0xF4, 0x47, 0xCB, 0x4A,   // ........T-.GJ
	/* 0DD0 */ 0x81, 0x8C, 0xCC, 0x5B, 0xF0, 0xEC, 0xB6, 0x49, 0x30, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..[I0,......
	/* 0DE0 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x90, 0x85, 0xE8, 0xF7, 0xC7, 0xDF, 0x78, 0x4C,   // ..........xL
	/* 0DF0 */ 0xBC, 0xCB, 0x6F, 0x38, 0x65, 0xB9, 0x9D, 0x1A, 0x5B, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // o8e..[,......
	/* 0E00 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x2D, 0x4E, 0xCD, 0x59, 0x50, 0x50, 0x4A,   // .........-NYPPJ
	/* 0E10 */ 0xA9, 0x2D, 0x05, 0xD5, 0xBB, 0x12, 0x67, 0xC7, 0x84, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // -.ջ.g.,......
	/* 0E20 */ 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x52, 0xE9, 0xCD, 0x96, 0x2F, 0x9D, 0x4D,   // ........R./.M
	/* 0E30 */ 0x8F, 0x2B, 0x2D, 0x34, 0x9F, 0x64, 0xFC, 0x51, 0xAD, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .+-4.dQ,......
	/* 0E40 */ 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0x6B, 0x3E, 0x38, 0xA4, 0xDA, 0xDA, 0x3D, 0x42,   // ........k>8=B
	/* 0E50 */ 0xA4, 0x3D, 0xF2, 0x56, 0x78, 0x42, 0x96, 0x76, 0xCB, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // =VxB.v,......
	/* 0E60 */ 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0x7B, 0xA0, 0x59, 0xCF, 0x2A, 0x1A, 0xE0, 0x4B,   // ........{.Y*.K
	/* 0E70 */ 0xBF, 0xE0, 0x42, 0x3B, 0x58, 0x23, 0xE6, 0x63, 0xEB, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // B;X#c,......
	/* 0E80 */ 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0x7F, 0x33, 0x9C, 0x2B, 0x1D, 0x7A, 0x71, 0x42,   // .........3.+.zqB
	/* 0E90 */ 0x90, 0xA3, 0xC6, 0x85, 0x5A, 0x2B, 0x8A, 0x1C, 0x0F, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Z+...-......
	/* 0EA0 */ 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0x72, 0xAD, 0x1E, 0x63, 0xAB, 0xA8, 0xF8, 0x4D,   // ........r.cM
	/* 0EB0 */ 0xBB, 0xDF, 0x37, 0x20, 0x29, 0x98, 0x9B, 0xDD, 0x23, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 7 )..#-......
	/* 0EC0 */ 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0x7C, 0x9F, 0xFA, 0xDD, 0x9E, 0xF0, 0xB9, 0x40,   // ........|..@
	/* 0ED0 */ 0x8C, 0x1A, 0xBE, 0x87, 0x7A, 0x9A, 0x7F, 0x4B, 0x3B, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...z..K;-......
	/* 0EE0 */ 0x00, 0x0D, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x56, 0x11, 0xFB, 0x7A, 0x1D, 0x2C, 0xFC, 0x40,   // ........V.z.,@
	/* 0EF0 */ 0xB2, 0x60, 0xAA, 0xB7, 0x44, 0x2B, 0x62, 0xFE, 0x53, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // `D+bS-......
	/* 0F00 */ 0x00, 0x0D, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xD4, 0x42, 0x25, 0xAD, 0x54, 0x91, 0x6D, 0x4C,   // ........B%T.mL
	/* 0F10 */ 0x8A, 0x44, 0x30, 0xF1, 0x1E, 0xE9, 0x69, 0x89, 0x77, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .D0.i.w-......
	/* 0F20 */ 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xD0, 0xE3, 0x01, 0x24, 0x0A, 0xC5, 0x58, 0x4B,   // .........$.XK
	/* 0F30 */ 0x87, 0xB2, 0x7E, 0x79, 0x4B, 0x7D, 0x26, 0x07, 0x94, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .~yK}&..-......
	/* 0F40 */ 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x90, 0x4D, 0xAF, 0xC1, 0xBC, 0xD1, 0xCA, 0x44,   // .........MD
	/* 0F50 */ 0x85, 0xD4, 0x00, 0x3B, 0xA3, 0x3D, 0xB3, 0xB9, 0xC1, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..;=-......
	/* 0F60 */ 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x49, 0x98, 0x81, 0xD0, 0xAD, 0xB2, 0x47,   // .........I..ЭG
	/* 0F70 */ 0xB3, 0xBA, 0x31, 0x6B, 0x12, 0xD6, 0x47, 0xB4, 0xE0, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 1k.G-......
	/* 0F80 */ 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x20, 0xE2, 0xB6, 0x68, 0x09, 0xCF, 0x6B, 0x46,   // ........ h.kF
	/* 0F90 */ 0x92, 0xD3, 0x45, 0xCD, 0x96, 0x4B, 0x95, 0x09, 0x0F, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .E.K..........
	/* 0FA0 */ 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x77, 0xEF, 0x09, 0xFD, 0x47, 0x56, 0xFF, 0x4E,   // ........w.GVN
	/* 0FB0 */ 0x80, 0x9C, 0xAF, 0x2B, 0x64, 0x65, 0x9A, 0x45, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..+de.E........
	/* 0FC0 */ 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x17, 0xEF, 0x01, 0x0D, 0x3E, 0x2A, 0x42,   // ........k...>*B
	/* 0FD0 */ 0xB4, 0xF8, 0x4E, 0xA8, 0x80, 0x03, 0x5E, 0x8F, 0x5D, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // N..^.].......
	/* 0FE0 */ 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x51, 0x72, 0xF7, 0x87, 0x0E, 0xD5, 0x48,   // ........\Qr..H
	/* 0FF0 */ 0xA6, 0x76, 0xE6, 0x96, 0x2C, 0x3E, 0x11, 0x95, 0x7D, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // v.,>..}.......
	/* 1000 */ 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xD9, 0x8B, 0x8B, 0xA7, 0x17, 0x80, 0xF5, 0x4D,   // ............M
	/* 1010 */ 0xB8, 0x6A, 0x09, 0xF7, 0x56, 0xAF, 0xFA, 0x7C, 0x9C, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // j.V|........
	/* 1020 */ 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xF3, 0x8C, 0xA1, 0xCD, 0x96, 0xC1, 0xAD, 0x46,   // ..........F
	/* 1030 */ 0xB2, 0x89, 0x60, 0xC0, 0x72, 0x86, 0x99, 0x94, 0xB7, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .`r..........
	/* 1040 */ 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xB9, 0x1F, 0x53, 0x68, 0x11, 0x55, 0x89, 0x49,   // .........Sh.U.I
	/* 1050 */ 0x97, 0xBE, 0xD1, 0x1A, 0x0F, 0x55, 0x63, 0x3F, 0xDA, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...Uc?.......
	/* 1060 */ 0x00, 0x11, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x2B, 0x0E, 0x62, 0xE7, 0x09, 0xFD, 0x42,   // ........=+.b.B
	/* 1070 */ 0x80, 0x2A, 0x17, 0xA1, 0x36, 0x52, 0xFE, 0x7A, 0xFA, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .*.6Rz.......
	/* 1080 */ 0x00, 0x11, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xE6, 0x82, 0x74, 0x89, 0xC5, 0x7F, 0x4B,   // ..........t..K
	/* 1090 */ 0x8E, 0xCC, 0x46, 0xD4, 0x55, 0xAC, 0x3B, 0x87, 0x1C, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .FU;../......
	/* 10A0 */ 0x00, 0x12, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x85, 0x26, 0x8A, 0x7E, 0x1C, 0xD3, 0x48,   // ..........&.~.H
	/* 10B0 */ 0xA6, 0x87, 0xFB, 0xCA, 0x9B, 0x9A, 0xC1, 0x6B, 0x3E, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...k>/......
	/* 10C0 */ 0x00, 0x12, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x60, 0x3D, 0x64, 0xD3, 0x42, 0x0C, 0x2D, 0x41,   // ........`=dB.-A
	/* 10D0 */ 0xA7, 0xD6, 0x52, 0xE6, 0x63, 0x53, 0x27, 0xF6, 0x6C, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // RcS'l/......
	/* 10E0 */ 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x83, 0x1C, 0xFD, 0x95, 0xF5, 0x7D, 0x4A, 0x49,   // ...........}JI
	/* 10F0 */ 0xBE, 0x8B, 0x13, 0x00, 0xE1, 0xC9, 0xD1, 0xCD, 0x8B, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..../......
	/* 1100 */ 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x86, 0x54, 0x7D, 0x20, 0xE1, 0x71, 0x47,   // .........T} qG
	/* 1110 */ 0xB7, 0xF1, 0x7B, 0x56, 0xC6, 0xD3, 0x17, 0x0C, 0xB2, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // {V../......
	/* 1120 */ 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x41, 0xEC, 0xF5, 0xF0, 0x55, 0x0D, 0x32, 0x47,   // ........AU.2G
	/* 1130 */ 0xAF, 0x02, 0x44, 0x0A, 0x44, 0xA3, 0xCF, 0x0F, 0xDA, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .D.D./......
	/* 1140 */ 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0xBE, 0xA2, 0x43, 0xB7, 0xD4, 0x68, 0xD3, 0x4D,   // ........ChM
	/* 1150 */ 0xAF, 0x32, 0x92, 0x42, 0x5B, 0x7B, 0xB6, 0x23, 0xF7, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 2.B[{#/......
	/* 1160 */ 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x44, 0x13, 0x09, 0x00, 0xA4, 0x1E, 0x37, 0x4F,   // ........D....7O
	/* 1170 */ 0xB7, 0x89, 0x01, 0x75, 0x0B, 0xA6, 0x98, 0x8C, 0x1C, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..u....0......
	/* 1180 */ 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xA4, 0x6B, 0xDB, 0x21, 0x7B, 0x9A, 0x14, 0x4A,   // ........k!{..J
	/* 1190 */ 0x9E, 0x29, 0x64, 0xA6, 0x0C, 0x59, 0x30, 0x1D, 0x3E, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .)d.Y0.>0......
	/* 11A0 */ 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x04, 0xCA, 0xB3, 0x58, 0xA3, 0x68, 0x4D,   // ........N.ʳXhM
	/* 11B0 */ 0x98, 0x83, 0xAA, 0xA2, 0x94, 0x1A, 0xCA, 0x99, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .....`0......
	/* 11C0 */ 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x34, 0xBF, 0x3D, 0x6C, 0x5F, 0xA7, 0x4F,   // .........4=l_O
	/* 11D0 */ 0xB9, 0x36, 0x69, 0x9D, 0xCE, 0x9E, 0x26, 0x3F, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 6i..&?.0......
	/* 11E0 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xF4, 0x33, 0x44, 0x7B, 0xE7, 0xB1, 0x88, 0x47,   // ........3D{.G
	/* 11F0 */ 0x89, 0x5A, 0xC4, 0x53, 0x78, 0xD3, 0x82, 0x53, 0x9F, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ZSx.S.0......
	/* 1200 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x79, 0x67, 0xC5, 0x21, 0x49, 0xB4, 0x20, 0x4D,   // ........yg!I M
	/* 1210 */ 0xAD, 0xFC, 0xEE, 0xCE, 0x0E, 0x1A, 0xD7, 0x4B, 0xC1, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..K0......
	/* 1220 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x1B, 0x5A, 0x2B, 0xAB, 0xA5, 0x54, 0x4C,   // ..........Z+TL
	/* 1230 */ 0xAC, 0x2F, 0xA6, 0xD9, 0x48, 0x24, 0xA2, 0x83, 0xE0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // /H$.0......
	/* 1240 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x10, 0x54, 0x1C, 0x8C, 0x39, 0x9F, 0x05, 0x48,   // .........T..9..H
	/* 1250 */ 0x8C, 0x9D, 0x63, 0xA0, 0x77, 0x06, 0x35, 0x8F, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..c.w.5.0......
	/* 1260 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x6E, 0xAF, 0xD9, 0x43, 0x86, 0x5E, 0xE8, 0x4B,   // ........nC.^K
	/* 1270 */ 0xA7, 0x97, 0xD0, 0x72, 0xA0, 0x46, 0x89, 0x6C, 0x1C, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .r.F.l.1......
	/* 1280 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0xE7, 0x08, 0x9C, 0xE4, 0x82, 0xDA, 0xF8, 0x42,   // ...........B
	/* 1290 */ 0xBD, 0xE2, 0xB5, 0x70, 0xFB, 0xCA, 0xE7, 0x6C, 0x36, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // pl61......
	/* 12A0 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x22, 0xEF, 0xC5, 0x61, 0x4F, 0xF1, 0x53, 0x45,   // ........"aOSE
	/* 12B0 */ 0xA8, 0x24, 0xC4, 0xB3, 0x1E, 0x84, 0xB1, 0x00, 0x6B, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // $ĳ...k1......
	/* 12C0 */ 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x44, 0x7C, 0x94, 0xBA, 0x9D, 0xD1, 0x86, 0x47,   // ........D|...G
	/* 12D0 */ 0xB6, 0xAE, 0x22, 0x77, 0x0B, 0xC9, 0x4C, 0x54, 0x9E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // "w.LT.1......
	/* 12E0 */ 0x00, 0x16, 0x06, 0x05, 0x00, 0x01, 0x00, 0x00, 0x06, 0x16, 0x3D, 0x4F, 0xEA, 0x3F, 0x01, 0x4C,   // ..........=O?.L
	/* 12F0 */ 0xBE, 0x3C, 0x8D, 0x67, 0x1C, 0x40, 0x1E, 0x3B, 0xC5, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // <.g.@.;1......
	/* 1300 */ 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0xC2, 0x2D, 0x68, 0x2C, 0x68, 0x8B, 0x63, 0x4F,   // ........-h,h.cO
	/* 1310 */ 0xA1, 0x65, 0xAE, 0x29, 0x1D, 0x4C, 0xF1, 0x38, 0xDC, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // e).L81......
	/* 1320 */ 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xD8, 0xCF, 0xD7, 0xC0, 0x2B, 0x45,   // .........+E
	/* 1330 */ 0x9F, 0x60, 0xEF, 0x5C, 0x70, 0xC3, 0x20, 0x94, 0xF5, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .`\p .1......
	/* 1340 */ 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x50, 0x49, 0xF5, 0xD4, 0xF2, 0x26, 0xB4, 0x4F,   // ........PI&O
	/* 1350 */ 0xBA, 0x21, 0xFF, 0xAB, 0x16, 0xAF, 0xCA, 0xDE, 0x0E, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // !..2......
	/* 1360 */ 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x72, 0xE8, 0xE7, 0x8C, 0x8C, 0x18, 0x98, 0x4B,   // ........r....K
	/* 1370 */ 0x9D, 0x90, 0xF8, 0xF9, 0x0B, 0x7A, 0xAD, 0x02, 0x29, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...z.)2......
	/* 1380 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x70, 0xD4, 0xE5, 0xCE, 0x3B, 0x6E, 0xCC, 0x4F,   // ........p;nO
	/* 1390 */ 0x8C, 0x2B, 0xD1, 0x74, 0x28, 0x56, 0x8A, 0x9F, 0x3C, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .+t(V..<2......
	/* 13A0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xB8, 0xD0, 0x47, 0x89, 0x3B, 0xC3, 0xE1, 0x43,   // ........G.;C
	/* 13B0 */ 0x8C, 0x56, 0x9B, 0x67, 0x4C, 0x05, 0x28, 0x32, 0x4E, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .V.gL.(2N2......
	/* 13C0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x39, 0x66, 0x6B, 0xCA, 0xD6, 0x4A, 0xAE, 0x40,   // ........9fkJ@
	/* 13D0 */ 0xA5, 0x75, 0x14, 0xDE, 0xE0, 0x7F, 0x64, 0x30, 0x61, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // u..d0a2......
	/* 13E0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x40, 0x96, 0xED, 0x09, 0x20, 0xF0, 0x0A, 0x40,   // ........@.. .@
	/* 13F0 */ 0xAC, 0xD8, 0xD7, 0xD8, 0x67, 0xDF, 0xD9, 0xC2, 0x76, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // gv2......
	/* 1400 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x49, 0x4E, 0x3D, 0xEF, 0x3D, 0xA5, 0x81, 0x4D,   // ........IN==.M
	/* 1410 */ 0xA2, 0xB1, 0x2C, 0xA6, 0xC2, 0x55, 0x6B, 0x2C, 0x8A, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ,Uk,.2......
	/* 1420 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x5C, 0x6F, 0x58, 0xAB, 0x56, 0x52, 0x32, 0x46,   // ........\oXVR2F
	/* 1430 */ 0x96, 0x2F, 0xFE, 0xFD, 0x8B, 0x49, 0xE6, 0xF4, 0x9E, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ./.I.2......
	/* 1440 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x92, 0xC1, 0xB7, 0xEC, 0xAB, 0x73, 0xED, 0x4D,   // .........sM
	/* 1450 */ 0xAC, 0xF4, 0x23, 0x99, 0xB0, 0x95, 0xD0, 0xCC, 0xB2, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // #..̲2......
	/* 1460 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x1D, 0x3B, 0x59, 0x45, 0xB1, 0xDF, 0x91, 0x4E,   // .........;YE.N
	/* 1470 */ 0xBB, 0xFB, 0x2D, 0x5D, 0x0C, 0xE2, 0x22, 0x7A, 0xC6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // -]."z2......
	/* 1480 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x60, 0x77, 0x32, 0x6F, 0x5C, 0x8C, 0x7C, 0x41,   // ........`w2o\.|A
	/* 1490 */ 0x9B, 0x61, 0x83, 0x6A, 0x98, 0x28, 0x7E, 0x0C, 0xDD, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .a.j.(~.2......
	/* 14A0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xF7, 0x3F, 0x13, 0xDF, 0x14, 0xBF, 0x95, 0x4F,   // ........?...O
	/* 14B0 */ 0xAF, 0xE3, 0x7B, 0x48, 0xE7, 0xE3, 0x31, 0xEF, 0xFB, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // {H12......
	/* 14C0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x61, 0xBF, 0xC7, 0x5D, 0xC9, 0x5E, 0x96, 0x49,   // ........a]^.I
	/* 14D0 */ 0x9C, 0xCB, 0xDF, 0x80, 0x6A, 0x2D, 0x0E, 0xFE, 0x13, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..j-..3......
	/* 14E0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x75, 0x4F, 0x0C, 0xB5, 0x9B, 0x59, 0xE8, 0x43,   // ........uO..YC
	/* 14F0 */ 0x8D, 0xCD, 0x10, 0x81, 0xA7, 0x96, 0x72, 0x41, 0x30, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....rA03......
	/* 1500 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x87, 0x9E, 0x50, 0xEA, 0xA1, 0x07, 0x45, 0x4A,   // ..........P.EJ
	/* 1510 */ 0x9E, 0xDC, 0xEB, 0xA5, 0xA3, 0x9F, 0x36, 0xAF, 0x46, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .륣.6F3......
	/* 1520 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x78, 0xA6, 0xA2, 0x9D, 0x6B, 0xFB, 0x67, 0x4E,   // ........x.kgN
	/* 1530 */ 0xAB, 0x84, 0x60, 0xDD, 0x6A, 0x9C, 0x81, 0x9A, 0x68, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .`j...h3......
	/* 1540 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x05, 0x61, 0x23, 0x92, 0x67, 0xBB, 0x4F, 0x49,   // .........a#.gOI
	/* 1550 */ 0x94, 0xC7, 0x7F, 0x7A, 0x60, 0x79, 0x29, 0xBD, 0x7D, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..z`y)}3......
	/* 1560 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x9C, 0x38, 0x58, 0xE5, 0xC3, 0x83, 0x29, 0x4B,   // .........8X.)K
	/* 1570 */ 0xAD, 0xFE, 0x5E, 0x4D, 0x7F, 0x46, 0xC3, 0x58, 0x97, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ^M.FX.3......
	/* 1580 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xFF, 0x33, 0xD8, 0x9E, 0x92, 0x4F, 0x36, 0x4F,   // ........3..O6O
	/* 1590 */ 0xB3, 0x70, 0x86, 0x83, 0xA4, 0xF1, 0x32, 0x75, 0xAD, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // p..2u3......
	/* 15A0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xE7, 0x82, 0x08, 0x2D, 0xE7, 0xA4, 0x3B, 0x42,   // ..........-;B
	/* 15B0 */ 0x8C, 0xCC, 0x70, 0xD9, 0x1E, 0x01, 0x58, 0xB1, 0xC8, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .p..X3......
	/* 15C0 */ 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0x2C, 0x62, 0xE7, 0x6E, 0xD8, 0x18, 0x05, 0x40,   // ........,bn..@
	/* 15D0 */ 0x9F, 0xB7, 0x92, 0xDB, 0x64, 0x4A, 0x27, 0x9B, 0xD9, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..dJ'.3......
	/* 15E0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x52, 0x1D, 0x46, 0xF7, 0x2B, 0x7C, 0xB2, 0x43,   // ........R.F+|C
	/* 15F0 */ 0x87, 0x44, 0xEA, 0x95, 0x8E, 0x0B, 0xD0, 0x9A, 0xEC, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .D....3......
	/* 1600 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x40, 0x80, 0x0B, 0xA3, 0x8A, 0xD6, 0x3F, 0x42,   // ........@...?B
	/* 1610 */ 0xB0, 0xB5, 0x9C, 0xE2, 0x92, 0xEA, 0x5A, 0x8F, 0xFE, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Z.3......
	/* 1620 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xE3, 0x11, 0x9F, 0x1B, 0x5C, 0xC8, 0x1B, 0x4E,   // ...........\.N
	/* 1630 */ 0xBB, 0x29, 0x87, 0x9A, 0xD2, 0xC9, 0x09, 0xE3, 0x13, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // )....4......
	/* 1640 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x6B, 0x1C, 0x98, 0xDC, 0x8E, 0xFC, 0x0F, 0x42,   // ........k....B
	/* 1650 */ 0xAA, 0x43, 0xF8, 0xF3, 0x3E, 0x5C, 0x09, 0x23, 0x24, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // C>\.#$4......
	/* 1660 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xE6, 0xF3, 0xE1, 0xEF, 0xA2, 0xAE, 0x44, 0x41,   // ........DA
	/* 1670 */ 0xA2, 0x08, 0x32, 0xAA, 0x87, 0x2B, 0x65, 0x45, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .2.+eE64......
	/* 1680 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xFA, 0x3A, 0x1C, 0x77, 0xC5, 0x50, 0x3F, 0x44,   // ........:.wP?D
	/* 1690 */ 0xB1, 0x51, 0xFF, 0x25, 0x46, 0xD8, 0x63, 0xA0, 0x4A, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Q%Fc.J4......
	/* 16A0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x49, 0x26, 0x76, 0x8C, 0xD1, 0x97, 0x53, 0x49,   // ........I&v..SI
	/* 16B0 */ 0xAD, 0x27, 0xB7, 0xE2, 0xC2, 0x5B, 0x97, 0x2E, 0x5E, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // '[..^4......
	/* 16C0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x9C, 0xDA, 0x22, 0xB3, 0xE2, 0xA2, 0x58, 0x40,   // ........."X@
	/* 16D0 */ 0x9E, 0x4E, 0xF5, 0x9A, 0x69, 0x70, 0xBD, 0x69, 0x75, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .N.ipiu4......
	/* 16E0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x4A, 0x12, 0x5D, 0x4A, 0x20, 0xE6, 0xBA, 0x44,   // ........J.]J D
	/* 16F0 */ 0xB6, 0xFF, 0x65, 0x89, 0x61, 0xB3, 0x3B, 0x9A, 0x93, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // e.a;..4......
	/* 1700 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xD1, 0x28, 0x7A, 0x42, 0x7C, 0xD1, 0xBF, 0x4A,   // ........(zB|ѿJ
	/* 1710 */ 0xB7, 0x17, 0x32, 0xC7, 0x80, 0xBA, 0x6F, 0x07, 0xAB, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .2.o.4......
	/* 1720 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xF1, 0x9F, 0xC7, 0x00, 0x50, 0x68, 0x3D, 0x44,   // ..........Ph=D
	/* 1730 */ 0xBF, 0x61, 0x71, 0xCD, 0xE0, 0xDE, 0x30, 0x5F, 0xC8, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // aq0_4......
	/* 1740 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x38, 0xFB, 0x3A, 0xB1, 0x79, 0xCD, 0xE5, 0x4A,   // ........8:yJ
	/* 1750 */ 0x9F, 0x7F, 0xEE, 0xD0, 0x58, 0xD7, 0x50, 0xCA, 0xDE, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..XP4......
	/* 1760 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x0E, 0xC1, 0x3A, 0xE1, 0xD0, 0x75, 0xFF, 0x4A,   // .........:uJ
	/* 1770 */ 0xA0, 0xCD, 0x76, 0x49, 0x82, 0xCF, 0x54, 0x1C, 0xF3, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .vI.T.4......
	/* 1780 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xF0, 0xFA, 0x4E, 0xAC, 0x1F, 0xF8, 0x61, 0x4F,   // ........N.aO
	/* 1790 */ 0xBD, 0xF7, 0xEA, 0x32, 0xB0, 0x2A, 0xB1, 0x17, 0x09, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 2*..5......
	/* 17A0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xC6, 0xB1, 0xF5, 0xD9, 0x86, 0x53, 0x5A, 0x49,   // ........Ʊ.SZI
	/* 17B0 */ 0x88, 0xF9, 0x9A, 0xD6, 0xB4, 0x1A, 0xC9, 0xB3, 0x24, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..ִ.ɳ$5......
	/* 17C0 */ 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0xE2, 0x38, 0xB5, 0x44, 0x34, 0xFB, 0x32, 0x47,   // ........8D42G
	/* 17D0 */ 0x81, 0xE4, 0x64, 0x4C, 0x17, 0xD2, 0xE7, 0x46, 0x35, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .dL.F55......
	/* 17E0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0xA0, 0xBF, 0x73, 0x93, 0xB3, 0x97, 0x87, 0x45,   // .........s...E
	/* 17F0 */ 0xAB, 0x73, 0x30, 0x93, 0x44, 0x61, 0xD5, 0x5C, 0x56, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // s0.Da\V5......
	/* 1800 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0xB4, 0x6E, 0x28, 0xAA, 0x6F, 0x55, 0xEB, 0x4E,   // ........n(oUN
	/* 1810 */ 0x96, 0x7C, 0xC1, 0xB7, 0x71, 0xB7, 0x67, 0x3E, 0x76, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .|qg>v5......
	/* 1820 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x56, 0x82, 0xCC, 0x7C, 0xAA, 0xFB, 0xC6, 0x49,   // ........V.|I
	/* 1830 */ 0xB2, 0xA9, 0xF5, 0xAF, 0xB4, 0x25, 0x7C, 0xD2, 0x97, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // %|.5......
	/* 1840 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x17, 0xFE, 0x3D, 0xC5, 0x00, 0xCC, 0x67, 0x49,   // .........=.gI
	/* 1850 */ 0xB1, 0x88, 0xA0, 0x88, 0xA9, 0x65, 0x49, 0x4D, 0xBA, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...eIM5......
	/* 1860 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x7D, 0xA8, 0x16, 0x28, 0xED, 0xE1, 0x97, 0x40,   // ........}.(.@
	/* 1870 */ 0xB3, 0x11, 0xE2, 0x34, 0x1C, 0x57, 0xB1, 0x79, 0xD9, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .4.Wy5......
	/* 1880 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x08, 0xF9, 0xC0, 0x67, 0x4F, 0x18, 0x64, 0x4F,   // .........gO.dO
	/* 1890 */ 0x82, 0x50, 0x12, 0xDB, 0x79, 0x7A, 0xB3, 0xC3, 0xF9, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .P.yz5......
	/* 18A0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x7A, 0x4E, 0xCE, 0x7B, 0x80, 0xDD, 0x82, 0x46,   // ........zN{..F
	/* 18B0 */ 0x98, 0xFA, 0xF9, 0x93, 0x72, 0x58, 0x03, 0xD2, 0x1B, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..rX..6......
	/* 18C0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x0A, 0x0C, 0xC1, 0x1E, 0xF6, 0x54, 0x3E, 0x45,   // ...........T>E
	/* 18D0 */ 0xB8, 0x5A, 0x6F, 0xA1, 0xBB, 0xFE, 0xA9, 0xB7, 0x3D, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Zo=6......
	/* 18E0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0xBF, 0xB5, 0xD2, 0x87, 0x7B, 0xD4, 0xFB, 0x41,   // .........{A
	/* 18F0 */ 0xAF, 0x62, 0x71, 0xC3, 0x82, 0xF5, 0xCC, 0x85, 0x62, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // bq..b6......
	/* 1900 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0xA9, 0x50, 0xFE, 0x3C, 0x03, 0x0E, 0x29, 0x4B,   // ........P<..)K
	/* 1910 */ 0x97, 0x54, 0x9F, 0x19, 0x3F, 0x07, 0xB7, 0x1F, 0x8E, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .T..?...6......
	/* 1920 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x57, 0x9E, 0xE4, 0x39, 0x68, 0xAE, 0xE3, 0x4E,   // ........W.9hN
	/* 1930 */ 0xB0, 0x98, 0x26, 0x48, 0x0D, 0xF3, 0xDA, 0x96, 0xB4, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .&H..6......
	/* 1940 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x17, 0x21, 0xAA, 0x15, 0x79, 0x8F, 0xA8, 0x49,   // .........!.y.I
	/* 1950 */ 0x83, 0x17, 0x75, 0x30, 0x26, 0xD6, 0xA0, 0x54, 0xDF, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..u0&.T6......
	/* 1960 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x0E, 0xD6, 0xBF, 0xCF, 0x5F, 0x0B, 0x7D, 0x42,   // .........ֿ_.}B
	/* 1970 */ 0x91, 0x7C, 0xA4, 0xDF, 0x42, 0xA8, 0x0E, 0x44, 0x03, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .|B.D.7......
	/* 1980 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x81, 0xCC, 0x12, 0x70, 0x87, 0x88, 0xE9, 0x42,   // ..........p..B
	/* 1990 */ 0xB1, 0x7D, 0x4E, 0x5E, 0x42, 0x76, 0x0F, 0x0D, 0x27, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // }N^Bv..'7......
	/* 19A0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0xB6, 0x7E, 0x9C, 0xDE, 0x85, 0x5A, 0x0D, 0x42,   // ........~..Z.B
	/* 19B0 */ 0x97, 0x03, 0xFF, 0xF1, 0x1B, 0xDD, 0x4D, 0x43, 0x50, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...MCP7......
	/* 19C0 */ 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x0C, 0xFC, 0xC0, 0x67, 0xBA, 0xDE, 0x1B, 0x40,   // .........g.@
	/* 19D0 */ 0xBF, 0x8B, 0x9C, 0x8A, 0xD8, 0x39, 0x58, 0x04, 0x6F, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...9X.o7......
	/* 19E0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x36, 0x5D, 0xE6, 0xC3, 0x1F, 0x14, 0x2F, 0x4D,   // ........6]../M
	/* 19F0 */ 0xA3, 0x03, 0xA8, 0x42, 0xEE, 0x75, 0x6A, 0x29, 0x82, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Buj).7......
	/* 1A00 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xCB, 0xBC, 0xAA, 0x9C, 0xB1, 0x61, 0x4B, 0x4B,   // ........˼.aKK
	/* 1A10 */ 0x8B, 0xEC, 0xD1, 0x0A, 0x3C, 0x3A, 0xC2, 0xCE, 0x94, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..<:.7......
	/* 1A20 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x6E, 0xEA, 0x14, 0xE9, 0xFA, 0xA5, 0x39, 0x44,   // ........n.9D
	/* 1A30 */ 0xA3, 0x94, 0xA9, 0xBB, 0x32, 0x93, 0xCA, 0x09, 0xA6, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .2..7......
	/* 1A40 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x59, 0xCE, 0xCA, 0xD8, 0xD2, 0x33, 0xC7, 0x4A,   // ........Y3J
	/* 1A50 */ 0x9B, 0x1B, 0x9B, 0x72, 0x33, 0x9C, 0x51, 0xC8, 0xBA, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...r3.QȺ7......
	/* 1A60 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x65, 0x92, 0x9D, 0xEC, 0x1E, 0x9D, 0xD0, 0x4E,   // ........e....N
	/* 1A70 */ 0x83, 0x8A, 0xCD, 0xC2, 0x0F, 0x25, 0x51, 0xA1, 0xCE, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...%Q7......
	/* 1A80 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xBA, 0x1B, 0x0B, 0xD7, 0x93, 0xB8, 0x44, 0x45,   // ...........DE
	/* 1A90 */ 0x96, 0xE2, 0xB7, 0xA3, 0x18, 0x09, 0x1C, 0x33, 0xE2, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ⷣ...37......
	/* 1AA0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x6F, 0x59, 0x50, 0xD4, 0x4D, 0x89, 0xE0, 0x49,   // ........oYPM.I
	/* 1AB0 */ 0x96, 0x6A, 0xFD, 0x39, 0xED, 0x4C, 0x4C, 0x64, 0xF9, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .j9LLd7......
	/* 1AC0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x97, 0x41, 0x41, 0x4F, 0xC2, 0x0F, 0x01, 0x4C,   // .........AAO..L
	/* 1AD0 */ 0xB6, 0x8A, 0x86, 0xCB, 0xB9, 0xAC, 0x25, 0x4C, 0x17, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..˹%L.8......
	/* 1AE0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x10, 0x81, 0x9B, 0x82, 0x6F, 0x0E, 0x49, 0x43,   // ............o.IC
	/* 1AF0 */ 0xBC, 0xA4, 0x42, 0x80, 0x35, 0x77, 0x78, 0x8D, 0x2F, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // B.5wx./8......
	/* 1B00 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xBC, 0xDA, 0x7D, 0xDA, 0xBE, 0x3F, 0x47, 0x44,   // ........}ھ?GD
	/* 1B10 */ 0x9E, 0x01, 0x6A, 0xB7, 0x44, 0x0B, 0x4C, 0xD4, 0x4B, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..jD.LK8......
	/* 1B20 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x45, 0xCA, 0xBA, 0xCB, 0x6A, 0x55, 0x16, 0x44,   // ........EʺjU.D
	/* 1B30 */ 0xAD, 0x03, 0xBD, 0xA5, 0x98, 0xEA, 0xA7, 0xC8, 0x68, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..h8......
	/* 1B40 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xCB, 0x06, 0x1A, 0x04, 0xB8, 0xC5, 0x72, 0x47,   // ...........rG
	/* 1B50 */ 0x80, 0x9F, 0x41, 0x6D, 0x03, 0xD1, 0x66, 0x54, 0x89, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Am.fT.8......
	/* 1B60 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xE1, 0x4E, 0xE0, 0x83, 0x8D, 0xFA, 0x6D, 0x43,   // ........N..mC
	/* 1B70 */ 0x89, 0x94, 0xD3, 0x1A, 0x86, 0x2C, 0xAB, 0x77, 0x9F, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....,w.8......
	/* 1B80 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x3D, 0xA2, 0xDF, 0xDE, 0xD1, 0x6E, 0xA6, 0x45,   // ........=nE
	/* 1B90 */ 0x85, 0xDC, 0x63, 0xCA, 0xE0, 0x54, 0x6D, 0xE6, 0xBE, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .cTm8......
	/* 1BA0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xC1, 0x01, 0xF3, 0x6B, 0x4A, 0xB9, 0xE9, 0x43,   // .........kJC
	/* 1BB0 */ 0xBA, 0x31, 0xD4, 0x94, 0x59, 0x8C, 0x47, 0xFB, 0xD3, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 1.Y.G8......
	/* 1BC0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xE3, 0xAB, 0x34, 0xB2, 0x57, 0x08, 0x9C, 0x4F,   // ........4W..O
	/* 1BD0 */ 0xB0, 0x5A, 0x4D, 0xC3, 0x14, 0xF8, 0x55, 0x57, 0xE9, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ZM.UW8......
	/* 1BE0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x21, 0x78, 0x2A, 0xAA, 0x27, 0x18, 0x2C, 0x4C,   // ........!x*'.,L
	/* 1BF0 */ 0x8F, 0x1D, 0x45, 0x13, 0xA3, 0x4D, 0xDA, 0x97, 0x03, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..E.M..9......
	/* 1C00 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x20, 0xE6, 0x1F, 0x36, 0xF4, 0x64, 0xB5, 0x41,   // ........ .6dA
	/* 1C10 */ 0xBA, 0x77, 0x84, 0xF8, 0xE0, 0x79, 0xB1, 0xF7, 0x1E, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // w.y.9......
	/* 1C20 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xDF, 0xBA, 0x11, 0xBB, 0xAA, 0xD8, 0x0E, 0x47,   // ........ߺ..G
	/* 1C30 */ 0x93, 0x11, 0x20, 0xEA, 0xF8, 0x0F, 0xE5, 0xCC, 0x3D, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .. .=9......
	/* 1C40 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x85, 0x88, 0xC8, 0x0B, 0x8C, 0x71, 0x1D, 0x49,   // ............q.I
	/* 1C50 */ 0x92, 0x1F, 0x6F, 0x21, 0x43, 0x49, 0xE7, 0x9C, 0x4E, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..o!CI.N9......
	/* 1C60 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x0C, 0x4D, 0x7C, 0xFC, 0x85, 0x2E, 0xB9, 0x4B,   // .........M|..K
	/* 1C70 */ 0xAF, 0xD4, 0x01, 0xED, 0x14, 0x76, 0xB5, 0xE9, 0x78, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..vx9......
	/* 1C80 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0x19, 0x66, 0x0F, 0x50, 0x93, 0xEF, 0x75, 0x4B,   // .........f.P.uK
	/* 1C90 */ 0xBC, 0xB4, 0x82, 0x81, 0x99, 0x98, 0xA3, 0xCA, 0x9C, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .....9......
	/* 1CA0 */ 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xEB, 0xCE, 0x9B, 0x9E, 0x36, 0xE7, 0x26, 0x4F,   // ..........6&O
	/* 1CB0 */ 0x88, 0xDE, 0x76, 0x3F, 0x87, 0xDC, 0xC4, 0x85, 0xBE, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .v?..9......
	/* 1CC0 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xE9, 0x54, 0x78, 0x23, 0xFC, 0x79, 0x97, 0x44,   // ........Tx#y.D
	/* 1CD0 */ 0xA0, 0xC1, 0xA7, 0x09, 0x69, 0x69, 0x1C, 0x6B, 0xD1, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..ii.k9......
	/* 1CE0 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x01, 0xA3, 0xF8, 0xC8, 0xF5, 0x19, 0x32, 0x41,   // ..........2A
	/* 1CF0 */ 0x96, 0xCE, 0x2D, 0xE9, 0xD4, 0xAD, 0xBD, 0x33, 0xE3, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .-ԭ39......
	/* 1D00 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x61, 0xFD, 0x31, 0x31, 0x4F, 0x5E, 0x08, 0x43,   // ........a11O^.C
	/* 1D10 */ 0x8D, 0x6D, 0x62, 0xBE, 0x19, 0x87, 0xC9, 0x2C, 0xF7, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .mb..,9......
	/* 1D20 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x5F, 0x8B, 0xDD, 0x85, 0xA4, 0xEA, 0xF3, 0x4A,   // ........_..J
	/* 1D30 */ 0xA6, 0x28, 0xCC, 0xE9, 0xE7, 0x7C, 0x9A, 0x03, 0x0E, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // (|...:......
	/* 1D40 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x3F, 0xBF, 0xA2, 0x2C, 0x9E, 0x94, 0x6A, 0x44,   // ........?,..jD
	/* 1D50 */ 0x82, 0xC7, 0xE2, 0x5A, 0x15, 0xEC, 0x78, 0xC4, 0x2C, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z.x,:......
	/* 1D60 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xE3, 0xF0, 0x77, 0x17, 0x92, 0x73, 0x98, 0x41,   // ........w..s.A
	/* 1D70 */ 0x97, 0xEA, 0x8A, 0xE4, 0xDE, 0x6F, 0x63, 0x81, 0x44, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..oc.D:......
	/* 1D80 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xCA, 0x4C, 0x3E, 0x9D, 0x72, 0xE1, 0xF1, 0x46,   // ........L>.rF
	/* 1D90 */ 0xA2, 0xF4, 0x1D, 0x21, 0x07, 0x05, 0x14, 0x44, 0x61, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .!...Da:......
	/* 1DA0 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x6E, 0x6C, 0x4C, 0x73, 0xBA, 0xB0, 0x98, 0x42,   // ........nlLs.B
	/* 1DB0 */ 0xA8, 0x91, 0x67, 0x17, 0x72, 0xB2, 0xBD, 0x1B, 0x77, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .g.r.w:......
	/* 1DC0 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x4B, 0xA7, 0x12, 0x69, 0xFB, 0xA5, 0x1A, 0x40,   // ........K.i.@
	/* 1DD0 */ 0xBF, 0xDB, 0x2E, 0x3A, 0xB4, 0x6F, 0x4B, 0x02, 0x96, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .:oK..:......
	/* 1DE0 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x8F, 0xF0, 0x5C, 0x5B, 0x1A, 0xB8, 0x1D, 0x43,   // .........\[..C
	/* 1DF0 */ 0xB0, 0x80, 0x34, 0x50, 0xD8, 0x62, 0x05, 0x65, 0xAB, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .4Pb.e:......
	/* 1E00 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xF3, 0x7D, 0x6D, 0xE0, 0xD0, 0xAA, 0x9D, 0x41,   // ........}mЪ.A
	/* 1E10 */ 0x8D, 0xFB, 0x0A, 0xC3, 0x7E, 0x2B, 0xDF, 0x39, 0xC1, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..~+9:......
	/* 1E20 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xFE, 0x34, 0x98, 0x05, 0xEA, 0xA8, 0xFF, 0x4B,   // ........4..K
	/* 1E30 */ 0xB6, 0x7B, 0x4D, 0x00, 0x6B, 0x54, 0x47, 0xD3, 0xDC, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // {M.kTG:......
	/* 1E40 */ 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0xD4, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........ ......
	/* 1E50 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x63, 0x45, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // .[....cE......
	/* 1E60 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........ ......
	/* 1E70 */ 0x80, 0xE2, 0x9F, 0x57, 0x00, 0x00, 0x00, 0x00, 0x39, 0x38, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // ..W....98......
	/* 1E80 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .........!......
	/* 1E90 */ 0x00, 0x7A, 0x60, 0x52, 0x00, 0x00, 0x00, 0x00, 0x80, 0x25, 0x00, 0x00, 0x01, 0x19, 0x00, 0x00,   // .z`R.....%......
	/* 1EA0 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........-!......
	/* 1EB0 */ 0x80, 0xD2, 0x89, 0x50, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x23, 0x00, 0x00, 0x32, 0x15, 0x00, 0x00,   // ..P....#..2...
	/* 1EC0 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........E!......
	/* 1ED0 */ 0x80, 0xFC, 0x62, 0x4D, 0x00, 0x00, 0x00, 0x00, 0xB1, 0x1D, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .bM..........
	/* 1EE0 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........d!......
	/* 1EF0 */ 0x00, 0x31, 0x1B, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x72, 0x17, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .1.J....r......
	/* 1F00 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30,   // ........03612-00
	/* 1F10 */ 0x32, 0x30, 0x36, 0x2D, 0x35, 0x35, 0x36, 0x2D, 0x31, 0x32, 0x33, 0x37, 0x32, 0x37, 0x2D, 0x30,   // 206-556-123727-0
	/* 1F20 */ 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30,   // 3-1033-17763.000
	/* 1F30 */ 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // 0-2972018.Window
	/* 1F40 */ 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // s.Windows Server
	/* 1F50 */ 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x30, 0x39,   //  2019.03612-0009
	/* 1F60 */ 0x36, 0x2D, 0x31, 0x39, 0x39, 0x2D, 0x37, 0x39, 0x39, 0x31, 0x38, 0x38, 0x2D, 0x30, 0x33, 0x2D,   // 6-199-799188-03-
	/* 1F70 */ 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D,   // 1033-17763.0000-
	/* 1F80 */ 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30,   // 2972018.Office20
	/* 1F90 */ 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x30,   // 10.Office 2010.0
	/* 1FA0 */ 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x32, 0x34, 0x30, 0x2D, 0x37,   // 3612-00206-240-7
	/* 1FB0 */ 0x31, 0x39, 0x36, 0x33, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37,   // 19639-03-1033-17
	/* 1FC0 */ 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38,   // 763.0000-2972018
	/* 1FD0 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69,   // .Office2013.Offi
	/* 1FE0 */ 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30,   // ce 2013.03612-00
	/* 1FF0 */ 0x32, 0x30, 0x36, 0x2D, 0x34, 0x33, 0x38, 0x2D, 0x30, 0x30, 0x34, 0x35, 0x33, 0x32, 0x2D, 0x30,   // 206-438-004532-0
	/* 2000 */ 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30,   // 3-1033-17763.000
	/* 2010 */ 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // 0-2972018.Office
	/* 2020 */ 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36,   // 2016.Office 2016
	/* 2030 */ 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x33, 0x38, 0x35, 0x38, 0x2D, 0x30, 0x35, 0x33,   // .03612-03858-053
	/* 2040 */ 0x2D, 0x30, 0x38, 0x39, 0x35, 0x31, 0x36, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D,   // -089516-03-1033-
	/* 2050 */ 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30,   // 17763.0000-29720
	/* 2060 */ 0x31, 0x38, 0x00, 0x57, 0x69, 0x6E, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x47, 0x6F, 0x76, 0x00, 0x57,   // 18.WinChinaGov.W
	/* 2070 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x20,   // indows 10 China 
	/* 2080 */ 0x47, 0x6F, 0x76, 0x65, 0x72, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32,   // Government.03612
	/* 2090 */ 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x36, 0x38, 0x34, 0x2D, 0x31, 0x33, 0x37, 0x36, 0x36,   // -00206-684-13766
	/* 20A0 */ 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E,   // 9-03-1033-17763.
	/* 20B0 */ 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66,   // 0000-2972018.Off
	/* 20C0 */ 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32,   // ice2019.Office 2
	/* 20D0 */ 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x31,   // 019.Windows 10 1
	/* 20E0 */ 0x38, 0x30, 0x39, 0x20, 0x2F, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // 809 / Server 201
	/* 20F0 */ 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x31, 0x36, 0x30,   // 9.Windows 10 160
	/* 2100 */ 0x37, 0x20, 0x2F, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00,   // 7 / Server 2016.
	/* 2110 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x2F, 0x20, 0x53, 0x65,   // Windows 8.1 / Se
	/* 2120 */ 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x00, 0x57, 0x69, 0x6E,   // rver 2012 R2.Win
	/* 2130 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x2F, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,   // dows 8 / Server 
	/* 2140 */ 0x32, 0x30, 0x31, 0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x2F,   // 2012.Windows 7 /
	/* 2150 */ 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20,   //  Server 2008 R2 
	/* 2160 */ 0x53, 0x50, 0x31, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74,   // SP1.Windows Vist
	/* 2170 */ 0x61, 0x20, 0x2F, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // a / Server 2008 
	/* 2180 */ 0x53, 0x50, 0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x00, 0x4F, 0x66, 0x66, 0x69,   // SP2.Windows.Offi
	/* 2190 */ 0x63, 0x65, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31,   // ce2010.Office201
	/* 21A0 */ 0x33, 0x2B, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // 3+.Windows Serve
	/* 21B0 */ 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // r 2019.Windows 1
	/* 21C0 */ 0x30, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00,   // 0 2019 (Volume).
	/* 21D0 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x55, 0x6E, 0x6B, 0x6E, 0x6F,   // Windows 10 Unkno
	/* 21E0 */ 0x77, 0x6E, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64,   // wn (Volume).Wind
	/* 21F0 */ 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x20, 0x47, 0x6F, 0x76,   // ows 10 China Gov
	/* 2200 */ 0x65, 0x72, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // ernment.Windows 
	/* 2210 */ 0x31, 0x30, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29,   // 10 2016 (Volume)
	/* 2220 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x28, 0x52, 0x65, 0x74,   // .Windows 10 (Ret
	/* 2230 */ 0x61, 0x69, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // ail).Windows 10 
	/* 2240 */ 0x32, 0x30, 0x31, 0x35, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69,   // 2015 (Volume).Wi
	/* 2250 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // ndows 7.Windows 
	/* 2260 */ 0x38, 0x20, 0x28, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // 8 (Retail).Windo
	/* 2270 */ 0x77, 0x73, 0x20, 0x38, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69,   // ws 8 (Volume).Wi
	/* 2280 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x28, 0x52, 0x65, 0x74, 0x61, 0x69,   // ndows 8.1 (Retai
	/* 2290 */ 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x28,   // l).Windows 8.1 (
	/* 22A0 */ 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // Volume).Windows 
	/* 22B0 */ 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // Preview.Windows 
	/* 22C0 */ 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x41, 0x20, 0x28, 0x57,   // Server 2008 A (W
	/* 22D0 */ 0x65, 0x62, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x48, 0x50, 0x43, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64,   // eb and HPC).Wind
	/* 22E0 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // ows Server 2008 
	/* 22F0 */ 0x42, 0x20, 0x28, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x61, 0x6E, 0x64, 0x20,   // B (Standard and 
	/* 2300 */ 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64,   // Enterprise).Wind
	/* 2310 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // ows Server 2008 
	/* 2320 */ 0x43, 0x20, 0x28, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x29, 0x00, 0x57,   // C (Datacenter).W
	/* 2330 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	/* 2340 */ 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x41, 0x20, 0x28, 0x57, 0x65, 0x62, 0x20, 0x61, 0x6E, 0x64,   // 08 R2 A (Web and
	/* 2350 */ 0x20, 0x48, 0x50, 0x43, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   //  HPC).Windows Se
	/* 2360 */ 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x42, 0x20, 0x28,   // rver 2008 R2 B (
	/* 2370 */ 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x45, 0x6E, 0x74,   // Standard and Ent
	/* 2380 */ 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // erprise).Windows
	/* 2390 */ 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20,   //  Server 2008 R2 
	/* 23A0 */ 0x43, 0x20, 0x28, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x29, 0x00, 0x57,   // C (Datacenter).W
	/* 23B0 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	/* 23C0 */ 0x31, 0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // 12.Windows Serve
	/* 23D0 */ 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // r 2012 R2.Window
	/* 23E0 */ 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x57, 0x69,   // s Server 2016.Wi
	/* 23F0 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x50, 0x72, 0x65,   // ndows Server Pre
	/* 2400 */ 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73,   // view.Windows Vis
	/* 2410 */ 0x74, 0x61, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F,   // ta.Office 2010.O
	/* 2420 */ 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // ffice 2013.Offic
	/* 2430 */ 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65,   // e 2013 (Pre-Rele
	/* 2440 */ 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36,   // ase).Office 2016
	/* 2450 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E,   // .Office 2019.Win
	/* 2460 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39,   // dows Server 2019
	/* 2470 */ 0x20, 0x41, 0x52, 0x4D, 0x36, 0x34, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   //  ARM64.Windows S
	/* 2480 */ 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x41, 0x7A, 0x75, 0x72, 0x65,   // erver 2019 Azure
	/* 2490 */ 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   //  Core.Windows Se
	/* 24A0 */ 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65,   // rver 2019 Datace
	/* 24B0 */ 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72,   // nter.Windows Ser
	/* 24C0 */ 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x45, 0x73, 0x73, 0x65, 0x6E, 0x74, 0x69,   // ver 2019 Essenti
	/* 24D0 */ 0x61, 0x6C, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // als.Windows Serv
	/* 24E0 */ 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64,   // er 2019 Standard
	/* 24F0 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,   // .Windows Server 
	/* 2500 */ 0x32, 0x30, 0x31, 0x39, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20,   // 2019 Datacenter 
	/* 2510 */ 0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61,   // (Semi-Annual Cha
	/* 2520 */ 0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // nnel).Windows Se
	/* 2530 */ 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61,   // rver 2019 Standa
	/* 2540 */ 0x72, 0x64, 0x20, 0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61, 0x6C, 0x20,   // rd (Semi-Annual 
	/* 2550 */ 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Channel).Windows
	/* 2560 */ 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4C,   //  10 Enterprise L
	/* 2570 */ 0x54, 0x53, 0x43, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // TSC 2019.Windows
	/* 2580 */ 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4C,   //  10 Enterprise L
	/* 2590 */ 0x54, 0x53, 0x43, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // TSC 2019 N.Windo
	/* 25A0 */ 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,   // ws 10 Enterprise
	/* 25B0 */ 0x20, 0x47, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E,   //  G.Windows 10 En
	/* 25C0 */ 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x47, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64,   // terprise GN.Wind
	/* 25D0 */ 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,   // ows 10 Enterpris
	/* 25E0 */ 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x4C, 0x54, 0x53, 0x42, 0x00, 0x57, 0x69, 0x6E, 0x64,   // e 2016 LTSB.Wind
	/* 25F0 */ 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,   // ows 10 Enterpris
	/* 2600 */ 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x4C, 0x54, 0x53, 0x42, 0x20, 0x4E, 0x00, 0x57, 0x69,   // e 2016 LTSB N.Wi
	/* 2610 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65, 0x00, 0x57, 0x69,   // ndows 10 Home.Wi
	/* 2620 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65, 0x20, 0x43, 0x6F,   // ndows 10 Home Co
	/* 2630 */ 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00, 0x57,   // untry Specific.W
	/* 2640 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65, 0x20, 0x4E,   // indows 10 Home N
	/* 2650 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65,   // .Windows 10 Home
	/* 2660 */ 0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65,   //  Single Language
	/* 2670 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x64, 0x75, 0x63,   // .Windows 10 Educ
	/* 2680 */ 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30,   // ation.Windows 10
	/* 2690 */ 0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E,   //  Education N.Win
	/* 26A0 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // dows 10 Enterpri
	/* 26B0 */ 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E,   // se.Windows 10 En
	/* 26C0 */ 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x32, 0x30, 0x31, 0x35, 0x20, 0x4C, 0x54,   // terprise 2015 LT
	/* 26D0 */ 0x53, 0x42, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E,   // SB.Windows 10 En
	/* 26E0 */ 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x32, 0x30, 0x31, 0x35, 0x20, 0x4C, 0x54,   // terprise 2015 LT
	/* 26F0 */ 0x53, 0x42, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // SB N.Windows 10 
	/* 2700 */ 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E,   // Enterprise N.Win
	/* 2710 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // dows 10 Professi
	/* 2720 */ 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x6F, 0x72, 0x6B, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E,   // onal Workstation
	/* 2730 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66,   // .Windows 10 Prof
	/* 2740 */ 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x6F, 0x72, 0x6B, 0x73, 0x74, 0x61,   // essional Worksta
	/* 2750 */ 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // tion N.Windows 1
	/* 2760 */ 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57,   // 0 Professional.W
	/* 2770 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // indows 10 Profes
	/* 2780 */ 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E,   // sional Education
	/* 2790 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66,   // .Windows 10 Prof
	/* 27A0 */ 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69,   // essional Educati
	/* 27B0 */ 0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // on N.Windows 10 
	/* 27C0 */ 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00, 0x57,   // Professional N.W
	/* 27D0 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // indows 10 Profes
	/* 27E0 */ 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57,   // sional Preview.W
	/* 27F0 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70,   // indows 10 Enterp
	/* 2800 */ 0x72, 0x69, 0x73, 0x65, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E,   // rise Preview.Win
	/* 2810 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // dows 10 Enterpri
	/* 2820 */ 0x73, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6C, 0x20, 0x44,   // se for Virtual D
	/* 2830 */ 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // esktops.Windows 
	/* 2840 */ 0x31, 0x30, 0x20, 0x52, 0x65, 0x6D, 0x6F, 0x74, 0x65, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // 10 Remote Server
	/* 2850 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x53, 0x20, 0x28, 0x4C,   // .Windows 10 S (L
	/* 2860 */ 0x65, 0x61, 0x6E, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45,   // ean).Windows 7 E
	/* 2870 */ 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // nterprise.Window
	/* 2880 */ 0x73, 0x20, 0x37, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x45,   // s 7 Enterprise E
	/* 2890 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72,   // .Windows 7 Enter
	/* 28A0 */ 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // prise N.Windows 
	/* 28B0 */ 0x37, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57,   // 7 Professional.W
	/* 28C0 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73,   // indows 7 Profess
	/* 28D0 */ 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x45, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // ional E.Windows 
	/* 28E0 */ 0x37, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E,   // 7 Professional N
	/* 28F0 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64,   // .Windows 7 Embed
	/* 2900 */ 0x64, 0x65, 0x64, 0x20, 0x50, 0x4F, 0x53, 0x52, 0x65, 0x61, 0x64, 0x79, 0x00, 0x57, 0x69, 0x6E,   // ded POSReady.Win
	/* 2910 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20,   // dows 7 Embedded 
	/* 2920 */ 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Standard.Windows
	/* 2930 */ 0x20, 0x37, 0x20, 0x54, 0x68, 0x69, 0x6E, 0x50, 0x43, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   //  7 ThinPC.Window
	/* 2940 */ 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // s 8 Core.Windows
	/* 2950 */ 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20,   //  8 Core Country 
	/* 2960 */ 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Specific.Windows
	/* 2970 */ 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   //  8 Core N.Window
	/* 2980 */ 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20,   // s 8 Core Single 
	/* 2990 */ 0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Language.Windows
	/* 29A0 */ 0x20, 0x38, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20,   //  8 Professional 
	/* 29B0 */ 0x57, 0x4D, 0x43, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6D,   // WMC.Windows 8 Em
	/* 29C0 */ 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20,   // bedded Industry 
	/* 29D0 */ 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E,   // Professional.Win
	/* 29E0 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20,   // dows 8 Embedded 
	/* 29F0 */ 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72,   // Industry Enterpr
	/* 2A00 */ 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6E,   // ise.Windows 8 En
	/* 2A10 */ 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // terprise.Windows
	/* 2A20 */ 0x20, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00,   //  8 Enterprise N.
	/* 2A30 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // Windows 8 Profes
	/* 2A40 */ 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38,   // sional.Windows 8
	/* 2A50 */ 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00,   //  Professional N.
	/* 2A60 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65,   // Windows 8.1 Core
	/* 2A70 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72,   // .Windows 8.1 Cor
	/* 2A80 */ 0x65, 0x20, 0x41, 0x52, 0x4D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E,   // e ARM.Windows 8.
	/* 2A90 */ 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53,   // 1 Core Country S
	/* 2AA0 */ 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // pecific.Windows 
	/* 2AB0 */ 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // 8.1 Core N.Windo
	/* 2AC0 */ 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x53, 0x69, 0x6E, 0x67,   // ws 8.1 Core Sing
	/* 2AD0 */ 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   // le Language.Wind
	/* 2AE0 */ 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // ows 8.1 Professi
	/* 2AF0 */ 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x53, 0x74, 0x75, 0x64, 0x65, 0x6E, 0x74, 0x00, 0x57, 0x69, 0x6E,   // onal Student.Win
	/* 2B00 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73,   // dows 8.1 Profess
	/* 2B10 */ 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x53, 0x74, 0x75, 0x64, 0x65, 0x6E, 0x74, 0x20, 0x4E, 0x00,   // ional Student N.
	/* 2B20 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66,   // Windows 8.1 Prof
	/* 2B30 */ 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x4D, 0x43, 0x00, 0x57, 0x69, 0x6E,   // essional WMC.Win
	/* 2B40 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F,   // dows 8.1 Core Co
	/* 2B50 */ 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // nnected.Windows 
	/* 2B60 */ 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74,   // 8.1 Core Connect
	/* 2B70 */ 0x65, 0x64, 0x20, 0x43, 0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69,   // ed Country Speci
	/* 2B80 */ 0x66, 0x69, 0x63, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20,   // fic.Windows 8.1 
	/* 2B90 */ 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x4E,   // Core Connected N
	/* 2BA0 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72,   // .Windows 8.1 Cor
	/* 2BB0 */ 0x65, 0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x53, 0x69, 0x6E, 0x67,   // e Connected Sing
	/* 2BC0 */ 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   // le Language.Wind
	/* 2BD0 */ 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // ows 8.1 Enterpri
	/* 2BE0 */ 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45,   // se.Windows 8.1 E
	/* 2BF0 */ 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64,   // nterprise N.Wind
	/* 2C00 */ 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // ows 8.1 Professi
	/* 2C10 */ 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31,   // onal.Windows 8.1
	/* 2C20 */ 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00,   //  Professional N.
	/* 2C30 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45, 0x6D, 0x62, 0x65,   // Windows 8.1 Embe
	/* 2C40 */ 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x50, 0x72,   // dded Industry Pr
	/* 2C50 */ 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // ofessional.Windo
	/* 2C60 */ 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20,   // ws 8.1 Embedded 
	/* 2C70 */ 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x41, 0x75, 0x74, 0x6F, 0x6D, 0x6F, 0x74,   // Industry Automot
	/* 2C80 */ 0x69, 0x76, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20,   // ive.Windows 8.1 
	/* 2C90 */ 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72,   // Embedded Industr
	/* 2CA0 */ 0x79, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E,   // y Enterprise.Win
	/* 2CB0 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // dows 10 Enterpri
	/* 2CC0 */ 0x73, 0x65, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // se Preview.Windo
	/* 2CD0 */ 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E,   // ws 10 Profession
	/* 2CE0 */ 0x61, 0x6C, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // al Preview.Windo
	/* 2CF0 */ 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E,   // ws 10 Profession
	/* 2D00 */ 0x61, 0x6C, 0x20, 0x57, 0x4D, 0x43, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57,   // al WMC Preview.W
	/* 2D10 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x78, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69,   // indows 8.x Previ
	/* 2D20 */ 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x78, 0x20, 0x50,   // ew.Windows 8.x P
	/* 2D30 */ 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x20, 0x41, 0x52, 0x4D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // review ARM.Windo
	/* 2D40 */ 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x57,   // ws Server 2008 W
	/* 2D50 */ 0x65, 0x62, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // eb.Windows Serve
	/* 2D60 */ 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x43, 0x6F, 0x6D, 0x70, 0x75, 0x74, 0x65, 0x20, 0x43,   // r 2008 Compute C
	/* 2D70 */ 0x6C, 0x75, 0x73, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // luster.Windows S
	/* 2D80 */ 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64,   // erver 2008 Stand
	/* 2D90 */ 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // ard.Windows Serv
	/* 2DA0 */ 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64,   // er 2008 Standard
	/* 2DB0 */ 0x20, 0x77, 0x69, 0x74, 0x68, 0x6F, 0x75, 0x74, 0x20, 0x48, 0x79, 0x70, 0x65, 0x72, 0x2D, 0x56,   //  without Hyper-V
	/* 2DC0 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,   // .Windows Server 
	/* 2DD0 */ 0x32, 0x30, 0x30, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00,   // 2008 Enterprise.
	/* 2DE0 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // Windows Server 2
	/* 2DF0 */ 0x30, 0x30, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x77,   // 008 Enterprise w
	/* 2E00 */ 0x69, 0x74, 0x68, 0x6F, 0x75, 0x74, 0x20, 0x48, 0x79, 0x70, 0x65, 0x72, 0x2D, 0x56, 0x00, 0x57,   // ithout Hyper-V.W
	/* 2E10 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	/* 2E20 */ 0x30, 0x38, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69,   // 08 Datacenter.Wi
	/* 2E30 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30,   // ndows Server 200
	/* 2E40 */ 0x38, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x77, 0x69, 0x74,   // 8 Datacenter wit
	/* 2E50 */ 0x68, 0x6F, 0x75, 0x74, 0x20, 0x48, 0x79, 0x70, 0x65, 0x72, 0x2D, 0x56, 0x00, 0x57, 0x69, 0x6E,   // hout Hyper-V.Win
	/* 2E60 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38,   // dows Server 2008
	/* 2E70 */ 0x20, 0x66, 0x6F, 0x72, 0x20, 0x49, 0x74, 0x61, 0x6E, 0x69, 0x75, 0x6D, 0x00, 0x57, 0x69, 0x6E,   //  for Itanium.Win
	/* 2E80 */ 0x64, 0x6F, 0x77, 0x73, 0x20, 0x4D, 0x75, 0x6C, 0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20,   // dows MultiPoint 
	/* 2E90 */ 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x57, 0x69, 0x6E, 0x64,   // Server 2010.Wind
	/* 2EA0 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // ows Server 2008 
	/* 2EB0 */ 0x52, 0x32, 0x20, 0x57, 0x65, 0x62, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // R2 Web.Windows S
	/* 2EC0 */ 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x48, 0x50,   // erver 2008 R2 HP
	/* 2ED0 */ 0x43, 0x20, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // C Edition.Window
	/* 2EE0 */ 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32,   // s Server 2008 R2
	/* 2EF0 */ 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   //  Standard.Window
	/* 2F00 */ 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32,   // s Server 2008 R2
	/* 2F10 */ 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   //  Enterprise.Wind
	/* 2F20 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // ows Server 2008 
	/* 2F30 */ 0x52, 0x32, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69,   // R2 Datacenter.Wi
	/* 2F40 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30,   // ndows Server 200
	/* 2F50 */ 0x38, 0x20, 0x52, 0x32, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x49, 0x74, 0x61, 0x6E, 0x69, 0x75, 0x6D,   // 8 R2 for Itanium
	/* 2F60 */ 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   //  Enterprise.Wind
	/* 2F70 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20,   // ows Server 2012 
	/* 2F80 */ 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // Datacenter.Windo
	/* 2F90 */ 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x4D,   // ws Server 2012 M
	/* 2FA0 */ 0x75, 0x6C, 0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x50, 0x72, 0x65, 0x6D, 0x69, 0x75,   // ultiPoint Premiu
	/* 2FB0 */ 0x6D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // m.Windows Server
	/* 2FC0 */ 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x4D, 0x75, 0x6C, 0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E, 0x74,   //  2012 MultiPoint
	/* 2FD0 */ 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   //  Standard.Window
	/* 2FE0 */ 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x53, 0x74,   // s Server 2012 St
	/* 2FF0 */ 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // andard.Windows S
	/* 3000 */ 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x43, 0x6C,   // erver 2012 R2 Cl
	/* 3010 */ 0x6F, 0x75, 0x64, 0x20, 0x53, 0x74, 0x6F, 0x72, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   // oud Storage.Wind
	/* 3020 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20,   // ows Server 2012 
	/* 3030 */ 0x52, 0x32, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69,   // R2 Datacenter.Wi
	/* 3040 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // ndows Server 201
	/* 3050 */ 0x32, 0x20, 0x52, 0x32, 0x20, 0x45, 0x73, 0x73, 0x65, 0x6E, 0x74, 0x69, 0x61, 0x6C, 0x73, 0x00,   // 2 R2 Essentials.
	/* 3060 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // Windows Server 2
	/* 3070 */ 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00,   // 012 R2 Standard.
	/* 3080 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // Windows Server 2
	/* 3090 */ 0x30, 0x31, 0x36, 0x20, 0x41, 0x7A, 0x75, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57,   // 016 Azure Core.W
	/* 30A0 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	/* 30B0 */ 0x31, 0x36, 0x20, 0x43, 0x6C, 0x6F, 0x75, 0x64, 0x20, 0x53, 0x74, 0x6F, 0x72, 0x61, 0x67, 0x65,   // 16 Cloud Storage
	/* 30C0 */ 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,   // .Windows Server 
	/* 30D0 */ 0x32, 0x30, 0x31, 0x36, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00,   // 2016 Datacenter.
	/* 30E0 */ 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // Windows Server 2
	/* 30F0 */ 0x30, 0x31, 0x36, 0x20, 0x45, 0x73, 0x73, 0x65, 0x6E, 0x74, 0x69, 0x61, 0x6C, 0x73, 0x00, 0x57,   // 016 Essentials.W
	/* 3100 */ 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	/* 3110 */ 0x31, 0x36, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64,   // 16 Standard.Wind
	/* 3120 */ 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20,   // ows Server 2016 
	/* 3130 */ 0x41, 0x52, 0x4D, 0x36, 0x34, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // ARM64.Windows Se
	/* 3140 */ 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65,   // rver 2016 Datace
	/* 3150 */ 0x6E, 0x74, 0x65, 0x72, 0x20, 0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61,   // nter (Semi-Annua
	/* 3160 */ 0x6C, 0x20, 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // l Channel).Windo
	/* 3170 */ 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x53,   // ws Server 2016 S
	/* 3180 */ 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E,   // tandard (Semi-An
	/* 3190 */ 0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69,   // nual Channel).Wi
	/* 31A0 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // ndows Server 201
	/* 31B0 */ 0x36, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x50, 0x72, 0x65,   // 6 Datacenter Pre
	/* 31C0 */ 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73,   // view.Windows Vis
	/* 31D0 */ 0x74, 0x61, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64,   // ta Business.Wind
	/* 31E0 */ 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74, 0x61, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65,   // ows Vista Busine
	/* 31F0 */ 0x73, 0x73, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73,   // ss N.Windows Vis
	/* 3200 */ 0x74, 0x61, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69,   // ta Enterprise.Wi
	/* 3210 */ 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74, 0x61, 0x20, 0x45, 0x6E, 0x74, 0x65,   // ndows Vista Ente
	/* 3220 */ 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // rprise N.Office 
	/* 3230 */ 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69,   // Access 2010.Offi
	/* 3240 */ 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66,   // ce Excel 2010.Of
	/* 3250 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x47, 0x72, 0x6F, 0x6F, 0x76, 0x65, 0x20, 0x32, 0x30, 0x31, 0x30,   // fice Groove 2010
	/* 3260 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x49, 0x6E, 0x66, 0x6F, 0x50, 0x61, 0x74, 0x68,   // .Office InfoPath
	/* 3270 */ 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E,   //  2010.Office Mon
	/* 3280 */ 0x64, 0x6F, 0x20, 0x31, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // do 1 2010.Office
	/* 3290 */ 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66,   //  Mondo 2 2010.Of
	/* 32A0 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31,   // fice OneNote 201
	/* 32B0 */ 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74, 0x4C, 0x6F, 0x6F, 0x6B,   // 0.Office OutLook
	/* 32C0 */ 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77,   //  2010.Office Pow
	/* 32D0 */ 0x65, 0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66,   // erPoint 2010.Off
	/* 32E0 */ 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C,   // ice Professional
	/* 32F0 */ 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   //  Plus 2010.Offic
	/* 3300 */ 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30,   // e Project Pro 20
	/* 3310 */ 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63,   // 10.Office Projec
	/* 3320 */ 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00,   // t Standard 2010.
	/* 3330 */ 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72,   // Office Publisher
	/* 3340 */ 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6D, 0x61,   //  2010.Office Sma
	/* 3350 */ 0x6C, 0x6C, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73, 0x20, 0x42, 0x61, 0x73, 0x69,   // ll Business Basi
	/* 3360 */ 0x63, 0x73, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53,   // cs 2010.Office S
	/* 3370 */ 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66,   // tandard 2010.Off
	/* 3380 */ 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x65, 0x6D, 0x69, 0x75,   // ice Visio Premiu
	/* 3390 */ 0x6D, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69,   // m 2010.Office Vi
	/* 33A0 */ 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66,   // sio Pro 2010.Off
	/* 33B0 */ 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61,   // ice Visio Standa
	/* 33C0 */ 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57,   // rd 2010.Office W
	/* 33D0 */ 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // ord 2010.Office 
	/* 33E0 */ 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69,   // Access 2013.Offi
	/* 33F0 */ 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66,   // ce Excel 2013.Of
	/* 3400 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x49, 0x6E, 0x66, 0x6F, 0x50, 0x61, 0x74, 0x68, 0x20, 0x32, 0x30,   // fice InfoPath 20
	/* 3410 */ 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4C, 0x79, 0x6E, 0x63, 0x20, 0x32,   // 13.Office Lync 2
	/* 3420 */ 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F,   // 013.Office Mondo
	/* 3430 */ 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65,   //  2013.Office One
	/* 3440 */ 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // Note 2013.Office
	/* 3450 */ 0x20, 0x4F, 0x75, 0x74, 0x4C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66,   //  OutLook 2013.Of
	/* 3460 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20,   // fice PowerPoint 
	/* 3470 */ 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66,   // 2013.Office Prof
	/* 3480 */ 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30,   // essional Plus 20
	/* 3490 */ 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63,   // 13.Office Projec
	/* 34A0 */ 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // t Pro 2013.Offic
	/* 34B0 */ 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61,   // e Project Standa
	/* 34C0 */ 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50,   // rd 2013.Office P
	/* 34D0 */ 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66,   // ublisher 2013.Of
	/* 34E0 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30,   // fice Standard 20
	/* 34F0 */ 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20,   // 13.Office Visio 
	/* 3500 */ 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // Pro 2013.Office 
	/* 3510 */ 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32,   // Visio Standard 2
	/* 3520 */ 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20,   // 013.Office Word 
	/* 3530 */ 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65,   // 2013.Office Acce
	/* 3540 */ 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C,   // ss 2013 (Pre-Rel
	/* 3550 */ 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63,   // ease).Office Exc
	/* 3560 */ 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C,   // el 2013 (Pre-Rel
	/* 3570 */ 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x47, 0x72, 0x6F,   // ease).Office Gro
	/* 3580 */ 0x6F, 0x76, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65,   // ove 2013 (Pre-Re
	/* 3590 */ 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x49, 0x6E,   // lease).Office In
	/* 35A0 */ 0x66, 0x6F, 0x50, 0x61, 0x74, 0x68, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65,   // foPath 2013 (Pre
	/* 35B0 */ 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // -Release).Office
	/* 35C0 */ 0x20, 0x4C, 0x79, 0x6E, 0x63, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D,   //  Lync 2013 (Pre-
	/* 35D0 */ 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // Release).Office 
	/* 35E0 */ 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D,   // Mondo 2013 (Pre-
	/* 35F0 */ 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // Release).Office 
	/* 3600 */ 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72,   // OneNote 2013 (Pr
	/* 3610 */ 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // e-Release).Offic
	/* 3620 */ 0x65, 0x20, 0x4F, 0x75, 0x74, 0x6C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28,   // e Outlook 2013 (
	/* 3630 */ 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66,   // Pre-Release).Off
	/* 3640 */ 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32,   // ice PowerPoint 2
	/* 3650 */ 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65,   // 013 (Pre-Release
	/* 3660 */ 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73,   // ).Office Profess
	/* 3670 */ 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20,   // ional Plus 2013 
	/* 3680 */ 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66,   // (Pre-Release).Of
	/* 3690 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F,   // fice Project Pro
	/* 36A0 */ 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61,   //  2013 (Pre-Relea
	/* 36B0 */ 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65,   // se).Office Proje
	/* 36C0 */ 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33,   // ct Standard 2013
	/* 36D0 */ 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F,   //  (Pre-Release).O
	/* 36E0 */ 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20,   // ffice Publisher 
	/* 36F0 */ 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73,   // 2013 (Pre-Releas
	/* 3700 */ 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20,   // e).Office Visio 
	/* 3710 */ 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65,   // Pro 2013 (Pre-Re
	/* 3720 */ 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69,   // lease).Office Vi
	/* 3730 */ 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31,   // sio Standard 201
	/* 3740 */ 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00,   // 3 (Pre-Release).
	/* 3750 */ 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33,   // Office Word 2013
	/* 3760 */ 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F,   //  (Pre-Release).O
	/* 3770 */ 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31,   // ffice Access 201
	/* 3780 */ 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32,   // 6.Office Excel 2
	/* 3790 */ 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F,   // 016.Office Mondo
	/* 37A0 */ 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E,   //  2016.Office Mon
	/* 37B0 */ 0x64, 0x6F, 0x20, 0x52, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // do R 2016.Office
	/* 37C0 */ 0x20, 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66,   //  OneNote 2016.Of
	/* 37D0 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74, 0x6C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31,   // fice Outlook 201
	/* 37E0 */ 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x70, 0x6F,   // 6.Office Powerpo
	/* 37F0 */ 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // int 2016.Office 
	/* 3800 */ 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75,   // Professional Plu
	/* 3810 */ 0x73, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72,   // s 2016.Office Pr
	/* 3820 */ 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F,   // oject Pro 2016.O
	/* 3830 */ 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72,   // ffice Project Pr
	/* 3840 */ 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // o 2016 C2R.Offic
	/* 3850 */ 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61,   // e Project Standa
	/* 3860 */ 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50,   // rd 2016.Office P
	/* 3870 */ 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20,   // roject Standard 
	/* 3880 */ 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // 2016 C2R.Office 
	/* 3890 */ 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F,   // Publisher 2016.O
	/* 38A0 */ 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6B, 0x79, 0x70, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20,   // ffice Skype for 
	/* 38B0 */ 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66,   // Business 2016.Of
	/* 38C0 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30,   // fice Standard 20
	/* 38D0 */ 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20,   // 16.Office Visio 
	/* 38E0 */ 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // Pro 2016.Office 
	/* 38F0 */ 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43,   // Visio Pro 2016 C
	/* 3900 */ 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20,   // 2R.Office Visio 
	/* 3910 */ 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66,   // Standard 2016.Of
	/* 3920 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64,   // fice Visio Stand
	/* 3930 */ 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66,   // ard 2016 C2R.Off
	/* 3940 */ 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66,   // ice Word 2016.Of
	/* 3950 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61,   // fice Professiona
	/* 3960 */ 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x43, 0x32, 0x52, 0x20,   // l Plus 2019 C2R 
	/* 3970 */ 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50,   // Preview.Office P
	/* 3980 */ 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20,   // roject Pro 2019 
	/* 3990 */ 0x43, 0x32, 0x52, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x4F, 0x66, 0x66, 0x69,   // C2R Preview.Offi
	/* 39A0 */ 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31,   // ce Visio Pro 201
	/* 39B0 */ 0x39, 0x20, 0x43, 0x32, 0x52, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x4F, 0x66,   // 9 C2R Preview.Of
	/* 39C0 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x39,   // fice Access 2019
	/* 39D0 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30,   // .Office Excel 20
	/* 39E0 */ 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74, 0x6C, 0x6F, 0x6F,   // 19.Office Outloo
	/* 39F0 */ 0x6B, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F,   // k 2019.Office Po
	/* 3A00 */ 0x77, 0x65, 0x72, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66,   // werpoint 2019.Of
	/* 3A10 */ 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61,   // fice Professiona
	/* 3A20 */ 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69,   // l Plus 2019.Offi
	/* 3A30 */ 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32,   // ce Project Pro 2
	/* 3A40 */ 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65,   // 019.Office Proje
	/* 3A50 */ 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x39,   // ct Standard 2019
	/* 3A60 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65,   // .Office Publishe
	/* 3A70 */ 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6B,   // r 2019.Office Sk
	/* 3A80 */ 0x79, 0x70, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73,   // ype for Business
	/* 3A90 */ 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61,   //  2019.Office Sta
	/* 3AA0 */ 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // ndard 2019.Offic
	/* 3AB0 */ 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39,   // e Visio Pro 2019
	/* 3AC0 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74,   // .Office Visio St
	/* 3AD0 */ 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69,   // andard 2019.Offi
	/* 3AE0 */ 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00,                     // ce Word 2019.
};

#elif defined(NO_STRICT_MODES)

uint8_t DefaultKmsData[] =
{
	/* 0000 */ 0x4B, 0x4D, 0x44, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,   // KMD.............
	/* 0010 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ................
	/* 0020 */ 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........h.......
	/* 0030 */ 0x28, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // (.......(.......
	/* 0040 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...............
	/* 0050 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0xC0, 0x97, 0xD7, 0x20,   // .[........ 
	/* 0060 */ 0xBF, 0xC4, 0x08, 0x22, 0x00, 0x00, 0x00, 0x00, 0x23, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ."....#.......
	/* 0070 */ 0x80, 0x4F, 0x3E, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0xDC, 0x0B,   // .O>L....`.....
	/* 0080 */ 0x7F, 0x6A, 0xFE, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x61, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .j.....a.......
	/* 0090 */ 0x00, 0x11, 0x07, 0x51, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x8E, 0xF2, 0x0D,   // ...Q..........
	/* 00A0 */ 0xFF, 0x3F, 0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ?B.............
	/* 00B0 */ 0x00, 0x9A, 0x00, 0x56, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x40, 0x17, 0x0C, 0x1A,   // ...V.......@...
	/* 00C0 */ 0xBF, 0xC8, 0x5B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0xDD, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // [............
	/* 00D0 */ 0x80, 0x33, 0xE4, 0x58, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x00, 0x00, 0xC0, 0xE1, 0xE4, 0x00,   // .3X.........
	/* 00E0 */ 0xFF, 0xC9, 0x9A, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;............
	/* 00F0 */ 0x00, 0x29, 0xA8, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x5A, 0xB2, 0x27,   // .)[........Z'
	/* 0100 */ 0x7F, 0x87, 0xE3, 0x28, 0x00, 0x00, 0x00, 0x00, 0x34, 0x27, 0xC9, 0x55, 0x82, 0xD6, 0x71, 0x4D,   // ..(....4'U.qM
	/* 0110 */ 0x98, 0x3E, 0xD6, 0xEC, 0x3F, 0x16, 0x05, 0x9F, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .>?...Z.......
	/* 0120 */ 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x81, 0x28, 0xA5, 0x59, 0x89, 0xA9, 0x9D, 0x47,   // ...2.....(Y..G
	/* 0130 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.cZ.......
	/* 0140 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x01, 0x00, 0x15, 0xCE, 0xF1, 0x0F, 0x89, 0xA9, 0x9D, 0x47,   // ............G
	/* 0150 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.cZ.......
	/* 0160 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x05, 0x00, 0x23, 0xBF, 0xA0, 0x7B, 0xF5, 0xD0, 0x72, 0x40,   // ........#.{r@
	/* 0170 */ 0x91, 0xD9, 0xD5, 0x5A, 0xF5, 0xA4, 0x81, 0xB6, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z.Z.......
	/* 0180 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00, 0x46, 0xF9, 0x5A, 0xE8, 0x25, 0x2E, 0xB7, 0x47,   // ........FZ%.G
	/* 0190 */ 0x83, 0xE1, 0xBE, 0xBC, 0xEB, 0xEA, 0xC6, 0x11, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ᾼ.Z.......
	/* 01A0 */ 0x01, 0x00, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xBF, 0xF1, 0xA6, 0xE6, 0x40, 0x9D, 0xC3, 0x40,   // ........@.@
	/* 01B0 */ 0xAA, 0x9F, 0xC7, 0x7B, 0xA2, 0x15, 0x78, 0xC0, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .{.xZ.......
	/* 01C0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x68, 0x79, 0x4C, 0xAA, 0xDA, 0xB9, 0x80, 0x46,   // ........hyLڹ.F
	/* 01D0 */ 0x92, 0xB6, 0xAC, 0xB2, 0x5E, 0x2F, 0x86, 0x6C, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .^/.lZ.......
	/* 01E0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x1B, 0xF6, 0xB5, 0x85, 0x0B, 0x32, 0xE3, 0x4B,   // ...........2K
	/* 01F0 */ 0x81, 0x4A, 0xB7, 0x6B, 0x2B, 0xFA, 0xFC, 0x82, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Jk+.Z.......
	/* 0200 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xB1, 0x9E, 0x7D, 0x61, 0x36, 0xEF, 0x82, 0x4F,   // .........}a6.O
	/* 0210 */ 0x86, 0xE0, 0xA6, 0x5A, 0xE0, 0x7B, 0x96, 0xC6, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z{.Z.......
	/* 0220 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 0230 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x63, 0x45, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // .[....cE......
	/* 0240 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 0250 */ 0x80, 0xE2, 0x9F, 0x57, 0x00, 0x00, 0x00, 0x00, 0x39, 0x38, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // ..W....98......
	/* 0260 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 0270 */ 0x00, 0x7A, 0x60, 0x52, 0x00, 0x00, 0x00, 0x00, 0x80, 0x25, 0x00, 0x00, 0x01, 0x19, 0x00, 0x00,   // .z`R.....%......
	/* 0280 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 0290 */ 0x80, 0xD2, 0x89, 0x50, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x23, 0x00, 0x00, 0x32, 0x15, 0x00, 0x00,   // ..P....#..2...
	/* 02A0 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 02B0 */ 0x80, 0xFC, 0x62, 0x4D, 0x00, 0x00, 0x00, 0x00, 0xB1, 0x1D, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .bM..........
	/* 02C0 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........Z.......
	/* 02D0 */ 0x00, 0x31, 0x1B, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x72, 0x17, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .1.J....r......
	/* 02E0 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30,   // ........03612-00
	/* 02F0 */ 0x32, 0x30, 0x36, 0x2D, 0x35, 0x35, 0x36, 0x2D, 0x31, 0x32, 0x33, 0x37, 0x32, 0x37, 0x2D, 0x30,   // 206-556-123727-0
	/* 0300 */ 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30,   // 3-1033-17763.000
	/* 0310 */ 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // 0-2972018.Window
	/* 0320 */ 0x73, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x30, 0x39, 0x36, 0x2D, 0x31,   // s..03612-00096-1
	/* 0330 */ 0x39, 0x39, 0x2D, 0x37, 0x39, 0x39, 0x31, 0x38, 0x38, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33,   // 99-799188-03-103
	/* 0340 */ 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37,   // 3-17763.0000-297
	/* 0350 */ 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x30, 0x00,   // 2018.Office2010.
	/* 0360 */ 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x32, 0x34, 0x30,   // .03612-00206-240
	/* 0370 */ 0x2D, 0x37, 0x31, 0x39, 0x36, 0x33, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D,   // -719639-03-1033-
	/* 0380 */ 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30,   // 17763.0000-29720
	/* 0390 */ 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x33, 0x00, 0x00, 0x30,   // 18.Office2013..0
	/* 03A0 */ 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x34, 0x33, 0x38, 0x2D, 0x30,   // 3612-00206-438-0
	/* 03B0 */ 0x30, 0x34, 0x35, 0x33, 0x32, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37,   // 04532-03-1033-17
	/* 03C0 */ 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38,   // 763.0000-2972018
	/* 03D0 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x36, 0x00, 0x00, 0x30, 0x33, 0x36,   // .Office2016..036
	/* 03E0 */ 0x31, 0x32, 0x2D, 0x30, 0x33, 0x38, 0x35, 0x38, 0x2D, 0x30, 0x35, 0x33, 0x2D, 0x30, 0x38, 0x39,   // 12-03858-053-089
	/* 03F0 */ 0x35, 0x31, 0x36, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36,   // 516-03-1033-1776
	/* 0400 */ 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x57,   // 3.0000-2972018.W
	/* 0410 */ 0x69, 0x6E, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x47, 0x6F, 0x76, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31,   // inChinaGov..0361
	/* 0420 */ 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x36, 0x38, 0x34, 0x2D, 0x31, 0x33, 0x37, 0x36,   // 2-00206-684-1376
	/* 0430 */ 0x36, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33,   // 69-03-1033-17763
	/* 0440 */ 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66,   // .0000-2972018.Of
	/* 0450 */ 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x39, 0x00, 0x00, 0x55, 0x6E, 0x6B, 0x6E, 0x6F, 0x77,   // fice2019..Unknow
	/* 0460 */ 0x6E, 0x00,                                                                                       // n.
};

#else // !defined(NO_STRICT_MODES)

uint8_t DefaultKmsData[] =
{
	/* 0000 */ 0x4B, 0x4D, 0x44, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,   // KMD.............
	/* 0010 */ 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ................
	/* 0020 */ 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........h.......
	/* 0030 */ 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ................
	/* 0040 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...............
	/* 0050 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0xC0, 0x97, 0xD7, 0x20,   // .[........ 
	/* 0060 */ 0xBF, 0xC4, 0x08, 0x22, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ."............
	/* 0070 */ 0x80, 0x4F, 0x3E, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0xDC, 0x0B,   // .O>L....`.....
	/* 0080 */ 0x7F, 0x6A, 0xFE, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x41, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .j.....A.......
	/* 0090 */ 0x00, 0x11, 0x07, 0x51, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x8E, 0xF2, 0x0D,   // ...Q..........
	/* 00A0 */ 0xFF, 0x3F, 0x42, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ?B.............
	/* 00B0 */ 0x00, 0x9A, 0x00, 0x56, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x40, 0x17, 0x0C, 0x1A,   // ...V.......@...
	/* 00C0 */ 0xBF, 0xC8, 0x5B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0xBD, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // [............
	/* 00D0 */ 0x80, 0x33, 0xE4, 0x58, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x00, 0x00, 0xC0, 0xE1, 0xE4, 0x00,   // .3X.........
	/* 00E0 */ 0xFF, 0xC9, 0x9A, 0x3B, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;...........
	/* 00F0 */ 0x00, 0x29, 0xA8, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x5A, 0xB2, 0x27,   // .)[........Z'
	/* 0100 */ 0x7F, 0x87, 0xE3, 0x28, 0x00, 0x00, 0x00, 0x00, 0x34, 0x27, 0xC9, 0x55, 0x82, 0xD6, 0x71, 0x4D,   // ..(....4'U.qM
	/* 0110 */ 0x98, 0x3E, 0xD6, 0xEC, 0x3F, 0x16, 0x05, 0x9F, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .>?...:.......
	/* 0120 */ 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x81, 0x28, 0xA5, 0x59, 0x89, 0xA9, 0x9D, 0x47,   // ...2.....(Y..G
	/* 0130 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.c:.......
	/* 0140 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x01, 0x00, 0x15, 0xCE, 0xF1, 0x0F, 0x89, 0xA9, 0x9D, 0x47,   // ............G
	/* 0150 */ 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // Fu7.c:.......
	/* 0160 */ 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x05, 0x00, 0xFB, 0xB1, 0x49, 0x84, 0xEA, 0xF0, 0x7A, 0x49,   // ........I.zI
	/* 0170 */ 0x99, 0xAB, 0x66, 0xCA, 0x96, 0xE9, 0xA0, 0xF5, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .f..:.......
	/* 0180 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x59, 0x56, 0xB1, 0x11, 0x03, 0xE6, 0xF1, 0x4C,   // ........YV..L
	/* 0190 */ 0x9C, 0x1F, 0xF0, 0xEC, 0x01, 0xB8, 0x18, 0x88, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .....:.......
	/* 01A0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x36, 0xD6, 0x7C, 0xD2, 0x62, 0x19, 0xE9, 0x44,   // ........6|b.D
	/* 01B0 */ 0x8B, 0x4F, 0x27, 0xB6, 0xC2, 0x3E, 0xFB, 0x85, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .O'>.:.......
	/* 01C0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x23, 0xBF, 0xA0, 0x7B, 0xF5, 0xD0, 0x72, 0x40,   // ........#.{r@
	/* 01D0 */ 0x91, 0xD9, 0xD5, 0x5A, 0xF5, 0xA4, 0x81, 0xB6, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z.:.......
	/* 01E0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00, 0xC0, 0xE3, 0x9F, 0x96, 0xEC, 0xA3, 0x1A, 0x49,   // ...........I
	/* 01F0 */ 0x9F, 0x25, 0x42, 0x36, 0x05, 0xDE, 0xB3, 0x65, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .%B6.޳e:.......
	/* 0200 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x58, 0x13, 0xC5, 0xE1, 0x3E, 0xFE, 0x03, 0x42,   // ........X.>.B
	/* 0210 */ 0xA4, 0xA2, 0x3B, 0x6B, 0x20, 0xC9, 0x73, 0x4E, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ;k sN:.......
	/* 0220 */ 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x4F, 0x13, 0xE2, 0x58, 0x11, 0x8E, 0x17, 0x4D,   // ........O.X...M
	/* 0230 */ 0x9C, 0xB2, 0x91, 0x06, 0x9C, 0x15, 0x11, 0x48, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ......H:.......
	/* 0240 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0x19, 0x52, 0xDE, 0x7F, 0xFA, 0xFB, 0x4A, 0x48,   // .........R.JH
	/* 0250 */ 0x82, 0xC9, 0x34, 0xD1, 0xAD, 0x53, 0xE8, 0x56, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .4ѭSV:.......
	/* 0260 */ 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x3B, 0x7B, 0xB9, 0xBB, 0xA4, 0x8C, 0x28, 0x4A,   // ........;{.(J
	/* 0270 */ 0x97, 0x17, 0x89, 0xFA, 0xBD, 0x42, 0xC4, 0xAC, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ...BĬ:.......
	/* 0280 */ 0x00, 0x00, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00, 0x58, 0xB3, 0x40, 0x3C, 0x48, 0x59, 0xAF, 0x45,   // ........X@<HYE
	/* 0290 */ 0x92, 0x3B, 0x53, 0xD2, 0x1F, 0xCC, 0x7E, 0x79, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;S.~y:.......
	/* 02A0 */ 0x00, 0x00, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x90, 0x68, 0x64, 0x6D, 0x06, 0x36, 0x1A, 0x46,   // .........hdm.6.F
	/* 02B0 */ 0x86, 0xAB, 0x59, 0x8B, 0xB8, 0x4A, 0xCE, 0x82, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Y.J.:.......
	/* 02C0 */ 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00, 0x80, 0xC7, 0x8F, 0xCB, 0x05, 0x2C, 0x5A, 0x49,   // ...........,ZI
	/* 02D0 */ 0x97, 0x10, 0x85, 0xAF, 0xFF, 0xC9, 0x04, 0xD7, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ....:.......
	/* 02E0 */ 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00, 0xBB, 0xA0, 0x94, 0x5F, 0xA0, 0xD5, 0x81, 0x40,   // .........._..@
	/* 02F0 */ 0xA6, 0x85, 0x58, 0x19, 0x41, 0x8B, 0x2F, 0xE0, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .X.A./:.......
	/* 0300 */ 0x00, 0x00, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00, 0xE4, 0x56, 0xE1, 0x33, 0x6F, 0xB7, 0x52, 0x4A,   // ........V3oRJ
	/* 0310 */ 0x9F, 0x91, 0xF6, 0x41, 0xDD, 0x95, 0xAC, 0x48, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..A.H:.......
	/* 0320 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x87, 0x33, 0xE5, 0x8F, 0x87, 0x30, 0x47, 0x44,   // .........3..0GD
	/* 0330 */ 0x89, 0x85, 0xF7, 0x51, 0x32, 0x21, 0x5A, 0xC9, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Q2!Z:.......
	/* 0340 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xF3, 0xFD, 0x21, 0x8A, 0xC5, 0xCB, 0xEB, 0x44,   // ........!.D
	/* 0350 */ 0x83, 0xF3, 0xFE, 0x28, 0x4E, 0x66, 0x80, 0xA7, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .(Nf.:.......
	/* 0360 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xCC, 0xC6, 0x0F, 0x0E, 0xFF, 0xAE, 0x4F,   // ..........O
	/* 0370 */ 0x9D, 0x08, 0x43, 0x70, 0x78, 0x5B, 0xF7, 0xED, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..Cpx[:.......
	/* 0380 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0xB6, 0xF5, 0x87, 0xCA, 0x46, 0xCD, 0xC0, 0x40,   // .........F@
	/* 0390 */ 0xB0, 0x6D, 0x8E, 0xCD, 0x57, 0xA4, 0x37, 0x3F, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // m.W7?:.......
	/* 03A0 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x89, 0x26, 0xCA, 0xB2, 0xA8, 0xA9, 0xD7, 0x42,   // .........&ʲB
	/* 03B0 */ 0x93, 0x8D, 0xCF, 0x8E, 0x9F, 0x20, 0x19, 0x58, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .... .X:.......
	/* 03C0 */ 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00, 0x71, 0xCB, 0x65, 0x86, 0x8C, 0x46, 0xA3, 0x4A,   // ........qe..FJ
	/* 03D0 */ 0xA3, 0x37, 0xCB, 0x9B, 0xC9, 0xD5, 0xEA, 0xAC, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 7.:.......
	/* 03E0 */ 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0xD3, 0xEF, 0x56, 0x84, 0x04, 0x0C, 0x89, 0x40,   // ........V....@
	/* 03F0 */ 0x87, 0x40, 0x5B, 0x72, 0x38, 0x53, 0x5A, 0x65, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .@[r8SZe:.......
	/* 0400 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x69, 0xC0, 0x9F, 0x6E, 0x7D, 0x25, 0xC4, 0x4B,   // ........i.n}%K
	/* 0410 */ 0xB4, 0xA7, 0x75, 0x05, 0x14, 0xD3, 0x27, 0x43, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // u..'C:.......
	/* 0420 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x70, 0x52, 0x5F, 0x6D, 0xAC, 0x31, 0x3E, 0x43,   // ........pR_m1>C
	/* 0430 */ 0xB9, 0x0A, 0x39, 0x89, 0x29, 0x23, 0xC6, 0x57, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .9.)#W:.......
	/* 0440 */ 0x00, 0x00, 0x06, 0x05, 0x00, 0x01, 0x00, 0x00, 0xDC, 0x64, 0x2A, 0x21, 0xB1, 0x43, 0x3D, 0x4D,   // ........d*!C=M
	/* 0450 */ 0xA3, 0x0C, 0x2F, 0xC6, 0x9D, 0x20, 0x95, 0xC6, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ./. .:.......
	/* 0460 */ 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00, 0x46, 0xF9, 0x5A, 0xE8, 0x25, 0x2E, 0xB7, 0x47,   // ........FZ%.G
	/* 0470 */ 0x83, 0xE1, 0xBE, 0xBC, 0xEB, 0xEA, 0xC6, 0x11, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .ᾼ.:.......
	/* 0480 */ 0x01, 0x00, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00, 0xBF, 0xF1, 0xA6, 0xE6, 0x40, 0x9D, 0xC3, 0x40,   // ........@.@
	/* 0490 */ 0xAA, 0x9F, 0xC7, 0x7B, 0xA2, 0x15, 0x78, 0xC0, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .{.x:.......
	/* 04A0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00, 0x68, 0x79, 0x4C, 0xAA, 0xDA, 0xB9, 0x80, 0x46,   // ........hyLڹ.F
	/* 04B0 */ 0x92, 0xB6, 0xAC, 0xB2, 0x5E, 0x2F, 0x86, 0x6C, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .^/.l:.......
	/* 04C0 */ 0x02, 0x00, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00, 0x1B, 0xF6, 0xB5, 0x85, 0x0B, 0x32, 0xE3, 0x4B,   // ...........2K
	/* 04D0 */ 0x81, 0x4A, 0xB7, 0x6B, 0x2B, 0xFA, 0xFC, 0x82, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Jk+.:.......
	/* 04E0 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00, 0xB1, 0x9E, 0x7D, 0x61, 0x36, 0xEF, 0x82, 0x4F,   // .........}a6.O
	/* 04F0 */ 0x86, 0xE0, 0xA6, 0x5A, 0xE0, 0x7B, 0x96, 0xC6, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .Z{.:.......
	/* 0500 */ 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 0510 */ 0x00, 0xB5, 0xB2, 0x5B, 0x00, 0x00, 0x00, 0x00, 0x63, 0x45, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // .[....cE......
	/* 0520 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 0530 */ 0x80, 0xE2, 0x9F, 0x57, 0x00, 0x00, 0x00, 0x00, 0x39, 0x38, 0x00, 0x00, 0x1C, 0x0E, 0x00, 0x00,   // ..W....98......
	/* 0540 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 0550 */ 0x00, 0x7A, 0x60, 0x52, 0x00, 0x00, 0x00, 0x00, 0x80, 0x25, 0x00, 0x00, 0x01, 0x19, 0x00, 0x00,   // .z`R.....%......
	/* 0560 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 0570 */ 0x80, 0xD2, 0x89, 0x50, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x23, 0x00, 0x00, 0x32, 0x15, 0x00, 0x00,   // ..P....#..2...
	/* 0580 */ 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 0590 */ 0x80, 0xFC, 0x62, 0x4D, 0x00, 0x00, 0x00, 0x00, 0xB1, 0x1D, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .bM..........
	/* 05A0 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ........:.......
	/* 05B0 */ 0x00, 0x31, 0x1B, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x72, 0x17, 0x00, 0x00, 0x01, 0xD7, 0x00, 0x00,   // .1.J....r......
	/* 05C0 */ 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30,   // ........03612-00
	/* 05D0 */ 0x32, 0x30, 0x36, 0x2D, 0x35, 0x35, 0x36, 0x2D, 0x31, 0x32, 0x33, 0x37, 0x32, 0x37, 0x2D, 0x30,   // 206-556-123727-0
	/* 05E0 */ 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30,   // 3-1033-17763.000
	/* 05F0 */ 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // 0-2972018.Window
	/* 0600 */ 0x73, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x30, 0x39, 0x36, 0x2D, 0x31,   // s..03612-00096-1
	/* 0610 */ 0x39, 0x39, 0x2D, 0x37, 0x39, 0x39, 0x31, 0x38, 0x38, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33,   // 99-799188-03-103
	/* 0620 */ 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37,   // 3-17763.0000-297
	/* 0630 */ 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x30, 0x00,   // 2018.Office2010.
	/* 0640 */ 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x32, 0x34, 0x30,   // .03612-00206-240
	/* 0650 */ 0x2D, 0x37, 0x31, 0x39, 0x36, 0x33, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D,   // -719639-03-1033-
	/* 0660 */ 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30,   // 17763.0000-29720
	/* 0670 */ 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x33, 0x00, 0x00, 0x30,   // 18.Office2013..0
	/* 0680 */ 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x34, 0x33, 0x38, 0x2D, 0x30,   // 3612-00206-438-0
	/* 0690 */ 0x30, 0x34, 0x35, 0x33, 0x32, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37,   // 04532-03-1033-17
	/* 06A0 */ 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38,   // 763.0000-2972018
	/* 06B0 */ 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x36, 0x00, 0x00, 0x30, 0x33, 0x36,   // .Office2016..036
	/* 06C0 */ 0x31, 0x32, 0x2D, 0x30, 0x33, 0x38, 0x35, 0x38, 0x2D, 0x30, 0x35, 0x33, 0x2D, 0x30, 0x38, 0x39,   // 12-03858-053-089
	/* 06D0 */ 0x35, 0x31, 0x36, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36,   // 516-03-1033-1776
	/* 06E0 */ 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x57,   // 3.0000-2972018.W
	/* 06F0 */ 0x69, 0x6E, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x47, 0x6F, 0x76, 0x00, 0x00, 0x30, 0x33, 0x36, 0x31,   // inChinaGov..0361
	/* 0700 */ 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x36, 0x38, 0x34, 0x2D, 0x31, 0x33, 0x37, 0x36,   // 2-00206-684-1376
	/* 0710 */ 0x36, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33,   // 69-03-1033-17763
	/* 0720 */ 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x39, 0x37, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66,   // .0000-2972018.Of
	/* 0730 */ 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x39, 0x00, 0x00, 0x55, 0x6E, 0x6B, 0x6E, 0x6F, 0x77,   // fice2019..Unknow
	/* 0740 */ 0x6E, 0x00,                                                                                       // n.
};

#endif // // !defined(NO_STRICT_MODES)

__pure size_t getDefaultKmsDataSize()
{
	return sizeof(DefaultKmsData);
}

#endif // NO_INTERNAL_DATA

