export declare const endpointNames: string[];
export declare function capitalize(s: string): string;
export declare function getZigbee2MQTTVersion(): Promise<{
    commitHash: string;
    version: string;
}>;
export declare function getDependencyVersion(depend: string): Promise<{
    version: string;
}>;
export declare function formatDate(time: number, type: 'ISO_8601' | 'ISO_8601_local' | 'epoch' | 'relative'): string | number;
export declare function objectHasProperties(object: {
    [s: string]: unknown;
}, properties: string[]): boolean;
export declare function equalsPartial(object: {
    [s: string]: unknown;
}, expected: {
    [s: string]: unknown;
}): boolean;
export declare function getObjectProperty(object: {
    [s: string]: unknown;
}, key: string, defaultValue: unknown): unknown;
export declare function getResponse(request: {
    transaction: string;
}, data: unknown, error: string): {
    data: unknown;
    status: string;
    error?: string;
    transaction?: string;
};
export declare function parseJSON(value: string, failedReturnValue: unknown): unknown;
export declare function loadModuleFromText(moduleCode: string): unknown;
export declare function loadModuleFromFile(modulePath: string): unknown;
export declare function getExternalConvertersDefinitions(settings: any): any;
export declare function removeNullPropertiesFromObject(obj: KeyValue): void;
export declare function getKey(object: KeyValue, value: unknown, fallback: unknown, convertTo: (v: unknown) => unknown): unknown;
export declare function toNetworkAddressHex(value: number): string;
export declare function toSnakeCase(value: string | KeyValue): any;
export declare function validateFriendlyName(name: string, throwFirstError?: boolean): string[];
export declare function sleep(seconds: number): Promise<void>;
export declare function sanitizeImageParameter(parameter: string): string;
export declare function isAvailabilityEnabledForDevice(rd: ResolvedDevice, settings: Settings): boolean;
export declare function isXiaomiDevice(device: Device): boolean;
export declare function isIkeaTradfriDevice(device: Device): boolean;
export declare const hours: (hours: number) => number;
export declare const minutes: (minutes: number) => number;
export declare const seconds: (seconds: number) => number;
//# sourceMappingURL=utils.d.ts.map