import * as ZHEvents from 'zigbee-herdsman/dist/controller/events';
import ExtensionTS from './extension/extensionts';
declare global {
    interface EventDeviceRenamed {
        device: Device;
        homeAssisantRename: boolean;
        from: string;
        to: string;
    }
    interface EventDeviceRemoved {
        resolvedEntity: ResolvedEntity;
    }
    type EventMQTTMessage = {
        topic: string;
        message: string;
    };
    type EventMQTTMessagePublished = {
        topic: string;
        payload: string;
        options: {
            retain: boolean;
            qos: number;
        };
    };
    type EventPermitJoinChanged = ZHEvents.PermitJoinChangedPayload;
    type EventLastSeenChanged = {
        device: Device;
    };
    type EventDeviceNetworkAddressChanged = {
        device: Device;
    };
    type EventDeviceAnnounce = {
        device: Device;
    };
    type EventDeviceInterview = {
        device: Device;
        status: 'started' | 'successful' | 'failed';
    };
    type EventDeviceJoined = {
        device: Device;
    };
    type EventReportingDisabled = {
        device: ZHDevice;
    };
    type EventDeviceLeave = {
        ieeeAddr: string;
    };
    type EventGroupMembersChanged = {
        group: ResolvedEntity;
    };
    type EventPublishEntityState = {
        messagePayload: KeyValue;
        entity: ResolvedEntity;
        stateChangeReason: 'publishDebounce';
        payload: KeyValue;
        ieeeAddr: string;
    };
    type EventDeviceMessage = {
        type: ZHEvents.MessagePayloadType;
        device: Device;
        endpoint: ZHEndpoint;
        linkquality: number;
        groupID: number;
        cluster: string | number;
        data: KeyValue | Array<string | number>;
        meta: {
            zclTransactionSequenceNumber?: number;
        };
    };
}
declare type ListenerKey = string | ExtensionTS;
export default class EventBus {
    private callbacksByExtension;
    private emitter;
    emitAdapterDisconnected(): void;
    onAdapterDisconnected(key: ListenerKey, callback: () => void): void;
    emitPermitJoinChanged(data: EventPermitJoinChanged): void;
    onPermitJoinChanged(key: ListenerKey, callback: (data: EventPermitJoinChanged) => void): void;
    onDeviceRenamed(key: ListenerKey, callback: (data: EventDeviceRenamed) => void): void;
    onDeviceRemoved(key: ListenerKey, callback: (data: EventDeviceRemoved) => void): void;
    emitLastSeenChanged(data: EventLastSeenChanged): void;
    onLastSeenChanged(key: ListenerKey, callback: (data: EventLastSeenChanged) => void): void;
    emitDeviceNetworkAddressChanged(data: EventDeviceNetworkAddressChanged): void;
    onDeviceNetworkAddressChanged(key: ListenerKey, callback: (data: EventDeviceNetworkAddressChanged) => void): void;
    emitDeviceAnnounce(data: EventDeviceAnnounce): void;
    onDeviceAnnounce(key: ListenerKey, callback: (data: EventDeviceAnnounce) => void): void;
    emitDeviceInterview(data: EventDeviceInterview): void;
    onDeviceInterview(key: ListenerKey, callback: (data: EventDeviceInterview) => void): void;
    emitDeviceJoined(data: EventDeviceJoined): void;
    onDeviceJoined(key: ListenerKey, callback: (data: EventDeviceJoined) => void): void;
    emitDeviceLeave(data: EventDeviceLeave): void;
    onDeviceLeave(key: ListenerKey, callback: (data: EventDeviceLeave) => void): void;
    emitDeviceMessage(data: EventDeviceMessage): void;
    onDeviceMessage(key: ListenerKey, callback: (data: EventDeviceMessage) => void): void;
    emitMQTTMessage(data: EventMQTTMessage): void;
    onMQTTMessage(key: ListenerKey, callback: (data: EventMQTTMessage) => void): void;
    emitMQTTMessagePublished(data: EventMQTTMessagePublished): void;
    onMQTTMessagePublished(key: ListenerKey, callback: (data: EventMQTTMessagePublished) => void): void;
    onPublishEntityState(key: ListenerKey, callback: (data: EventPublishEntityState) => void): void;
    onGroupMembersChanged(key: ListenerKey, callback: (data: EventGroupMembersChanged) => void): void;
    emitDevicesChanged(): void;
    onDevicesChanged(key: ListenerKey, callback: () => void): void;
    onReportingDisabled(key: ListenerKey, callback: (data: EventReportingDisabled) => void): void;
    private on;
    emit(event: string, ...args: any[]): void;
    removeListeners(key: ListenerKey): void;
}
export {};
//# sourceMappingURL=eventBus.d.ts.map