"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable brace-style */
const events_1 = __importDefault(require("events"));
class EventBus {
    constructor() {
        /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
        this.callbacksByExtension = {};
        this.emitter = new events_1.default.EventEmitter();
    }
    emitAdapterDisconnected() { this.emitter.emit('adapterDisconnected'); }
    onAdapterDisconnected(key, callback) {
        this.on('adapterDisconnected', callback, key);
    }
    emitPermitJoinChanged(data) { this.emitter.emit('permitJoinChanged', data); }
    onPermitJoinChanged(key, callback) {
        this.on('permitJoinChanged', callback, key);
    }
    // public emitDeviceRenamed(data: EventDeviceRenamed): void {this.emitter.emit('deviceRenamed', data);}
    onDeviceRenamed(key, callback) {
        this.on('deviceRenamed', callback, key);
    }
    // public emitDeviceRemoved(data: EventDeviceRemoved): void {this.emitter.emit('deviceRemoved', data);}
    onDeviceRemoved(key, callback) {
        this.on('deviceRemoved', callback, key);
    }
    emitLastSeenChanged(data) { this.emitter.emit('lastSeenChanged', data); }
    onLastSeenChanged(key, callback) {
        this.on('lastSeenChanged', callback, key);
    }
    emitDeviceNetworkAddressChanged(data) {
        this.emitter.emit('deviceNetworkAddressChanged', data);
    }
    onDeviceNetworkAddressChanged(key, callback) {
        this.on('deviceNetworkAddressChanged', callback, key);
    }
    emitDeviceAnnounce(data) { this.emitter.emit('deviceAnnounce', data); }
    onDeviceAnnounce(key, callback) {
        this.on('deviceAnnounce', callback, key);
    }
    emitDeviceInterview(data) { this.emitter.emit('deviceInterview', data); }
    onDeviceInterview(key, callback) {
        this.on('deviceInterview', callback, key);
    }
    emitDeviceJoined(data) { this.emitter.emit('deviceJoined', data); }
    onDeviceJoined(key, callback) {
        this.on('deviceJoined', callback, key);
    }
    emitDeviceLeave(data) { this.emitter.emit('deviceLeave', data); }
    onDeviceLeave(key, callback) {
        this.on('deviceLeave', callback, key);
    }
    emitDeviceMessage(data) { this.emitter.emit('deviceMessage', data); }
    onDeviceMessage(key, callback) {
        this.on('deviceMessage', callback, key);
    }
    emitMQTTMessage(data) { this.emitter.emit('mqttMessage', data); }
    onMQTTMessage(key, callback) {
        this.on('mqttMessage', callback, key);
    }
    emitMQTTMessagePublished(data) {
        this.emitter.emit('mqttMessagePublished', data);
    }
    onMQTTMessagePublished(key, callback) {
        this.on('mqttMessagePublished', callback, key);
    }
    // public emitPublishEntityState(data: EventPublishEntityState): void {
    //     this.emitter.emit('publishEntityState', data);}
    onPublishEntityState(key, callback) {
        this.on('publishEntityState', callback, key);
    }
    // public emitGroupMembersChanged(data: EventGroupMembersChanged): void {
    //     this.emitter.emit('groupMembersChanged', data);}
    onGroupMembersChanged(key, callback) {
        this.on('groupMembersChanged', callback, key);
    }
    emitDevicesChanged() { this.emitter.emit('devicesChanged'); }
    onDevicesChanged(key, callback) { this.on('devicesChanged', callback, key); }
    // public emitReportingDisabled(data: EventReportingDisabled): void {
    //     this.emitter.emit('reportingDisabled', data);}
    onReportingDisabled(key, callback) {
        this.on('reportingDisabled', callback, key);
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
    on(event, callback, key) {
        key = typeof key === 'string' ? key : key.constructor.name;
        if (!this.callbacksByExtension[key])
            this.callbacksByExtension[key] = [];
        this.callbacksByExtension[key].push({ event, callback });
        this.emitter.on(event, callback);
    }
    // TODO: remove
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
    emit(event, ...args) {
        this.emitter.emit(event, ...args);
    }
    removeListeners(key) {
        var _a;
        key = typeof key === 'string' ? key : key.constructor.name;
        (_a = this.callbacksByExtension[key]) === null || _a === void 0 ? void 0 : _a.forEach((e) => this.emitter.removeListener(e.event, e.callback));
    }
}
exports.default = EventBus;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRCdXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9saWIvZXZlbnRCdXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxnQ0FBZ0M7QUFDaEMsb0RBQTRCO0FBeUM1QixNQUFxQixRQUFRO0lBQTdCO1FBQ0ksaUVBQWlFO1FBQ3pELHlCQUFvQixHQUE2RSxFQUFFLENBQUM7UUFDcEcsWUFBTyxHQUFHLElBQUksZ0JBQU0sQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQTZGaEQsQ0FBQztJQTNGVSx1QkFBdUIsS0FBVSxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUEsQ0FBQztJQUMzRSxxQkFBcUIsQ0FBQyxHQUFnQixFQUFFLFFBQW9CO1FBQy9ELElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUU1QyxxQkFBcUIsQ0FBQyxJQUE0QixJQUFTLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxDQUFDLENBQUEsQ0FBQztJQUN6RyxtQkFBbUIsQ0FBQyxHQUFnQixFQUFFLFFBQWdEO1FBQ3pGLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUVqRCx1R0FBdUc7SUFDaEcsZUFBZSxDQUFDLEdBQWdCLEVBQUUsUUFBNEM7UUFDakYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUU3Qyx1R0FBdUc7SUFDaEcsZUFBZSxDQUFDLEdBQWdCLEVBQUUsUUFBNEM7UUFDakYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUV0QyxtQkFBbUIsQ0FBQyxJQUEwQixJQUFTLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxDQUFDLENBQUEsQ0FBQztJQUNuRyxpQkFBaUIsQ0FBQyxHQUFnQixFQUFFLFFBQThDO1FBQ3JGLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUV4QywrQkFBK0IsQ0FBQyxJQUFzQztRQUN6RSxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyw2QkFBNkIsRUFBRSxJQUFJLENBQUMsQ0FBQztJQUFBLENBQUM7SUFDckQsNkJBQTZCLENBQ2hDLEdBQWdCLEVBQUUsUUFBMEQ7UUFDNUUsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQSxDQUFDO0lBRXBELGtCQUFrQixDQUFDLElBQXlCLElBQVMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQSxDQUFDO0lBQ2hHLGdCQUFnQixDQUFDLEdBQWdCLEVBQUUsUUFBNkM7UUFDbkYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQSxDQUFDO0lBRXZDLG1CQUFtQixDQUFDLElBQTBCLElBQVMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQSxDQUFDO0lBQ25HLGlCQUFpQixDQUFDLEdBQWdCLEVBQUUsUUFBOEM7UUFDckYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQSxDQUFDO0lBRXhDLGdCQUFnQixDQUFDLElBQXVCLElBQVMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUEsQ0FBQztJQUMxRixjQUFjLENBQUMsR0FBZ0IsRUFBRSxRQUEyQztRQUMvRSxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQSxDQUFDO0lBRXJDLGVBQWUsQ0FBQyxJQUFzQixJQUFTLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFBLENBQUM7SUFDdkYsYUFBYSxDQUFDLEdBQWdCLEVBQUUsUUFBMEM7UUFDN0UsSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUVwQyxpQkFBaUIsQ0FBQyxJQUF3QixJQUFTLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFBLENBQUM7SUFDN0YsZUFBZSxDQUFDLEdBQWdCLEVBQUUsUUFBNEM7UUFDakYsSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUV0QyxlQUFlLENBQUMsSUFBc0IsSUFBUyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQSxDQUFDO0lBQ3ZGLGFBQWEsQ0FBQyxHQUFnQixFQUFFLFFBQTBDO1FBQzdFLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUFBLENBQUM7SUFFcEMsd0JBQXdCLENBQUMsSUFBK0I7UUFDM0QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFBQSxDQUFDO0lBQzlDLHNCQUFzQixDQUFDLEdBQWdCLEVBQUUsUUFBbUQ7UUFDL0YsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQSxDQUFDO0lBRXBELHVFQUF1RTtJQUN2RSxzREFBc0Q7SUFDL0Msb0JBQW9CLENBQUMsR0FBZ0IsRUFBRSxRQUFpRDtRQUMzRixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixFQUFFLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUFBLENBQUM7SUFFbEQseUVBQXlFO0lBQ3pFLHVEQUF1RDtJQUNoRCxxQkFBcUIsQ0FBQyxHQUFnQixFQUFFLFFBQWtEO1FBQzdGLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQUEsQ0FBQztJQUU1QyxrQkFBa0IsS0FBVSxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUEsQ0FBQztJQUNqRSxnQkFBZ0IsQ0FBQyxHQUFnQixFQUFFLFFBQW9CLElBQVMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsRUFBRSxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQSxDQUFDO0lBRWpILHFFQUFxRTtJQUNyRSxxREFBcUQ7SUFDOUMsbUJBQW1CLENBQUMsR0FBZ0IsRUFBRSxRQUFnRDtRQUN6RixJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixFQUFFLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUFBLENBQUM7SUFFakQsaUVBQWlFO0lBQ3pELEVBQUUsQ0FBQyxLQUFhLEVBQUUsUUFBa0MsRUFBRSxHQUFnQjtRQUMxRSxHQUFHLEdBQUcsT0FBTyxHQUFHLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDO1FBQzNELElBQUksQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsR0FBRyxDQUFDO1lBQUUsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUN6RSxJQUFJLENBQUMsb0JBQW9CLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUMsS0FBSyxFQUFFLFFBQVEsRUFBQyxDQUFDLENBQUM7UUFDdkQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRCxlQUFlO0lBQ2YsaUVBQWlFO0lBQ2pFLElBQUksQ0FBQyxLQUFhLEVBQUUsR0FBRyxJQUFXO1FBQzlCLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFTSxlQUFlLENBQUMsR0FBZ0I7O1FBQ25DLEdBQUcsR0FBRyxPQUFPLEdBQUcsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUM7UUFDM0QsTUFBQSxJQUFJLENBQUMsb0JBQW9CLENBQUMsR0FBRyxDQUFDLDBDQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUNyRyxDQUFDO0NBQ0o7QUFoR0QsMkJBZ0dDIn0=