/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;


/**
 * Provides APIs to load {@link android.content.pm.SharedLibraryInfo#TYPE_SDK_PACKAGE SDKs}
 * into sdk sandbox process, and then interact with them.
 *
 * <p>NOTE: currently {@link android.app.sdksandbox.SdkSandboxManager SdkSandboxManager} is
 * {@link android.app.sdksandbox.SdkSandboxManager#SDK_SANDBOX_STATE_DISABLED disabled}. Eventually, this functionality
 * will be enabled via a
 * <a href="https://source.android.com/devices/architecture/modular-system">Mainline update</a>.
 *
 * <p>{@code SdkSandbox} is a java process running in a separate uid range. Each app has its own
 * sdk sandbox process.
 *
 * <p>First app needs to declare {@code SDKs} it depends on in it's {@code AndroidManifest.xml}
 * using {@code <uses-sdk-library>} tag. App can only load {@code SDKs} it depends on into the
 * {@code SdkSandbox}.
 *
 * @see android.content.pm.SharedLibraryInfo#TYPE_SDK_PACKAGE
 * @see
 * <a href="https://developer.android.com/design-for-safety/ads/sdk-runtime">SDK runtime design proposal</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SdkSandboxManager {

SdkSandboxManager() { throw new RuntimeException("Stub!"); }

/**
 * Returns current state of the {@code SdkSandbox}.

 * @return Value is {@link android.app.sdksandbox.SdkSandboxManager#SDK_SANDBOX_STATE_DISABLED}, or {@link android.app.sdksandbox.SdkSandboxManager#SDK_SANDBOX_STATE_ENABLED_PROCESS_ISOLATION}
 */

public static int getSdkSandboxState() { throw new RuntimeException("Stub!"); }

/**
 * Sdk Sandbox is disabled.
 *
 * <p>{@link android.app.sdksandbox.SdkSandboxManager SdkSandboxManager} APIs are hidden. Attempts at calling them will result in
 * {@link java.lang.UnsupportedOperationException UnsupportedOperationException}.
 */

public static final int SDK_SANDBOX_STATE_DISABLED = 0; // 0x0

/**
 * Sdk Sandbox is enabled.
 *
 * <p>App can use {@link android.app.sdksandbox.SdkSandboxManager SdkSandboxManager} APIs to load {@code SDKs} it depends on into the
 * corresponding {@code SdkSandbox} process.
 */

public static final int SDK_SANDBOX_STATE_ENABLED_PROCESS_ISOLATION = 2; // 0x2
}

