/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.database;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Cursor extends java.io.Closeable {

public int getCount();

public int getPosition();

public boolean move(int offset);

public boolean moveToPosition(int position);

public boolean moveToFirst();

public boolean moveToLast();

public boolean moveToNext();

public boolean moveToPrevious();

public boolean isFirst();

public boolean isLast();

public boolean isBeforeFirst();

public boolean isAfterLast();

public int getColumnIndex(java.lang.String columnName);

public int getColumnIndexOrThrow(java.lang.String columnName) throws java.lang.IllegalArgumentException;

public java.lang.String getColumnName(int columnIndex);

public java.lang.String[] getColumnNames();

public int getColumnCount();

public byte[] getBlob(int columnIndex);

public java.lang.String getString(int columnIndex);

public void copyStringToBuffer(int columnIndex, android.database.CharArrayBuffer buffer);

public short getShort(int columnIndex);

public int getInt(int columnIndex);

public long getLong(int columnIndex);

public float getFloat(int columnIndex);

public double getDouble(int columnIndex);

public int getType(int columnIndex);

public boolean isNull(int columnIndex);

@Deprecated
public void deactivate();

@Deprecated
public boolean requery();

public void close();

public boolean isClosed();

public void registerContentObserver(android.database.ContentObserver observer);

public void unregisterContentObserver(android.database.ContentObserver observer);

public void registerDataSetObserver(android.database.DataSetObserver observer);

public void unregisterDataSetObserver(android.database.DataSetObserver observer);

public void setNotificationUri(android.content.ContentResolver cr, android.net.Uri uri);

public default void setNotificationUris(@android.annotation.NonNull android.content.ContentResolver cr, @android.annotation.NonNull java.util.List<android.net.Uri> uris) { throw new RuntimeException("Stub!"); }

public android.net.Uri getNotificationUri();

@android.annotation.Nullable
public default java.util.List<android.net.Uri> getNotificationUris() { throw new RuntimeException("Stub!"); }

public boolean getWantsAllOnMoveCalls();

public void setExtras(android.os.Bundle extras);

public android.os.Bundle getExtras();

public android.os.Bundle respond(android.os.Bundle extras);

public static final int FIELD_TYPE_BLOB = 4; // 0x4

public static final int FIELD_TYPE_FLOAT = 2; // 0x2

public static final int FIELD_TYPE_INTEGER = 1; // 0x1

public static final int FIELD_TYPE_NULL = 0; // 0x0

public static final int FIELD_TYPE_STRING = 3; // 0x3
}

