/* GENERATED SOURCE. DO NOT MODIFY. */
// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/*
 *******************************************************************************
 * Copyright (C) 2012-2016, Google, International Business Machines Corporation and
 * others. All Rights Reserved.
 *******************************************************************************
 */

package android.icu.text;

import java.text.Format;

/**
 * Immutable class for formatting a list, using data from CLDR (or supplied
 * separately). The class is not subclassable.
 *
 * @author Mark Davis
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ListFormatter {

ListFormatter() { throw new RuntimeException("Stub!"); }

/**
 * Create a list formatter that is appropriate for a locale.
 *
 * @param locale
 *            the locale in question.
 * @return ListFormatter
 */

public static android.icu.text.ListFormatter getInstance(android.icu.util.ULocale locale, android.icu.text.ListFormatter.Type type, android.icu.text.ListFormatter.Width width) { throw new RuntimeException("Stub!"); }

/**
 * Create a list formatter that is appropriate for a locale.
 *
 * @param locale
 *            the locale in question.
 * @return ListFormatter
 */

public static android.icu.text.ListFormatter getInstance(java.util.Locale locale, android.icu.text.ListFormatter.Type type, android.icu.text.ListFormatter.Width width) { throw new RuntimeException("Stub!"); }

/**
 * Create a list formatter that is appropriate for a locale.
 *
 * @param locale
 *            the locale in question.
 * @return ListFormatter
 */

public static android.icu.text.ListFormatter getInstance(android.icu.util.ULocale locale) { throw new RuntimeException("Stub!"); }

/**
 * Create a list formatter that is appropriate for a locale.
 *
 * @param locale
 *            the locale in question.
 * @return ListFormatter
 */

public static android.icu.text.ListFormatter getInstance(java.util.Locale locale) { throw new RuntimeException("Stub!"); }

/**
 * Create a list formatter that is appropriate for the default FORMAT locale.
 *
 * @return ListFormatter
 */

public static android.icu.text.ListFormatter getInstance() { throw new RuntimeException("Stub!"); }

/**
 * Format a list of objects.
 *
 * @param items
 *            items to format. The toString() method is called on each.
 * @return items formatted into a string
 */

public java.lang.String format(java.lang.Object... items) { throw new RuntimeException("Stub!"); }

/**
 * Format a collection of objects. The toString() method is called on each.
 *
 * @param items
 *            items to format. The toString() method is called on each.
 * @return items formatted into a string
 */

public java.lang.String format(java.util.Collection<?> items) { throw new RuntimeException("Stub!"); }

/**
 * Format a list of objects to a FormattedList. You can access the offsets
 * of each element from the FormattedList.
 *
 * @param items
 *            items to format. The toString() method is called on each.
 * @return items formatted into a FormattedList
 */

public android.icu.text.ListFormatter.FormattedList formatToValue(java.lang.Object... items) { throw new RuntimeException("Stub!"); }

/**
 * Format a collection of objects to a FormattedList. You can access the offsets
 * of each element from the FormattedList.
 *
 * @param items
 *            items to format. The toString() method is called on each.
 * @return items formatted into a FormattedList
 */

public android.icu.text.ListFormatter.FormattedList formatToValue(java.util.Collection<?> items) { throw new RuntimeException("Stub!"); }

/**
 * Returns the pattern to use for a particular item count.
 * @param count the item count.
 * @return the pattern with {0}, {1}, {2}, etc. For English,
 * getPatternForNumItems(3) == "{0}, {1}, and {2}"
 * @throws java.lang.IllegalArgumentException when count is 0 or negative.
 */

public java.lang.String getPatternForNumItems(int count) { throw new RuntimeException("Stub!"); }
/**
 * An immutable class containing the result of a list formatting operation.
 *
 * Instances of this class are immutable and thread-safe.
 *
 * Not intended for public subclassing.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class FormattedList implements android.icu.text.FormattedValue {

FormattedList() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public int length() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public char charAt(int index) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public java.lang.CharSequence subSequence(int start, int end) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public <A extends java.lang.Appendable> A appendTo(A appendable) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public boolean nextPosition(android.icu.text.ConstrainedFieldPosition cfpos) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 */

public java.text.AttributedCharacterIterator toCharacterIterator() { throw new RuntimeException("Stub!"); }
}

/**
 * Type of meaning expressed by the list.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Type {
/**
 * Conjunction formatting, e.g. "Alice, Bob, Charlie, and Delta".
 */

AND,
/**
 * Disjunction (or alternative, or simply one of) formatting, e.g.
 * "Alice, Bob, Charlie, or Delta".
 */

OR,
/**
 * Formatting of a list of values with units, e.g. "5 pounds, 12 ounces".
 */

UNITS;
}

/**
 * Verbosity level of the list patterns.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Width {
/**
 * Use list formatting with full words (no abbreviations) when possible.
 */

WIDE,
/**
 * Use list formatting of typical length.
 */

SHORT,
/**
 * Use list formatting of the shortest possible length.
 */

NARROW;
}

}

