/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.session;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaController {

public MediaController(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.media.session.MediaSession.Token token) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.session.MediaController.TransportControls getTransportControls() { throw new RuntimeException("Stub!"); }

public boolean dispatchMediaButtonEvent(@android.annotation.NonNull android.view.KeyEvent keyEvent) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.session.PlaybackState getPlaybackState() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaMetadata getMetadata() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.media.session.MediaSession.QueueItem> getQueue() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getQueueTitle() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public int getRatingType() { throw new RuntimeException("Stub!"); }

public long getFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.session.MediaController.PlaybackInfo getPlaybackInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.PendingIntent getSessionActivity() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.session.MediaSession.Token getSessionToken() { throw new RuntimeException("Stub!"); }

public void setVolumeTo(int value, int flags) { throw new RuntimeException("Stub!"); }

public void adjustVolume(int direction, int flags) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull android.media.session.MediaController.Callback callback) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull android.media.session.MediaController.Callback callback, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.media.session.MediaController.Callback callback) { throw new RuntimeException("Stub!"); }

public void sendCommand(@android.annotation.NonNull java.lang.String command, @android.annotation.Nullable android.os.Bundle args, @android.annotation.Nullable android.os.ResultReceiver cb) { throw new RuntimeException("Stub!"); }

public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getSessionInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getTag() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Callback {

public Callback() { throw new RuntimeException("Stub!"); }

public void onSessionDestroyed() { throw new RuntimeException("Stub!"); }

public void onSessionEvent(@android.annotation.NonNull java.lang.String event, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onPlaybackStateChanged(@android.annotation.Nullable android.media.session.PlaybackState state) { throw new RuntimeException("Stub!"); }

public void onMetadataChanged(@android.annotation.Nullable android.media.MediaMetadata metadata) { throw new RuntimeException("Stub!"); }

public void onQueueChanged(@android.annotation.Nullable java.util.List<android.media.session.MediaSession.QueueItem> queue) { throw new RuntimeException("Stub!"); }

public void onQueueTitleChanged(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

public void onExtrasChanged(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void onAudioInfoChanged(android.media.session.MediaController.PlaybackInfo info) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PlaybackInfo implements android.os.Parcelable {

PlaybackInfo() { throw new RuntimeException("Stub!"); }

public int getPlaybackType() { throw new RuntimeException("Stub!"); }

public int getVolumeControl() { throw new RuntimeException("Stub!"); }

public int getMaxVolume() { throw new RuntimeException("Stub!"); }

public int getCurrentVolume() { throw new RuntimeException("Stub!"); }

public android.media.AudioAttributes getAudioAttributes() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getVolumeControlId() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.session.MediaController.PlaybackInfo> CREATOR;
static { CREATOR = null; }

public static final int PLAYBACK_TYPE_LOCAL = 1; // 0x1

public static final int PLAYBACK_TYPE_REMOTE = 2; // 0x2
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TransportControls {

private TransportControls() { throw new RuntimeException("Stub!"); }

public void prepare() { throw new RuntimeException("Stub!"); }

public void prepareFromMediaId(java.lang.String mediaId, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void prepareFromSearch(java.lang.String query, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void prepareFromUri(android.net.Uri uri, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void play() { throw new RuntimeException("Stub!"); }

public void playFromMediaId(java.lang.String mediaId, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void playFromSearch(java.lang.String query, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void playFromUri(android.net.Uri uri, android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void skipToQueueItem(long id) { throw new RuntimeException("Stub!"); }

public void pause() { throw new RuntimeException("Stub!"); }

public void stop() { throw new RuntimeException("Stub!"); }

public void seekTo(long pos) { throw new RuntimeException("Stub!"); }

public void fastForward() { throw new RuntimeException("Stub!"); }

public void skipToNext() { throw new RuntimeException("Stub!"); }

public void rewind() { throw new RuntimeException("Stub!"); }

public void skipToPrevious() { throw new RuntimeException("Stub!"); }

public void setRating(android.media.Rating rating) { throw new RuntimeException("Stub!"); }

public void setPlaybackSpeed(float speed) { throw new RuntimeException("Stub!"); }

public void sendCustomAction(@android.annotation.NonNull android.media.session.PlaybackState.CustomAction customAction, @android.annotation.Nullable android.os.Bundle args) { throw new RuntimeException("Stub!"); }

public void sendCustomAction(@android.annotation.NonNull java.lang.String action, @android.annotation.Nullable android.os.Bundle args) { throw new RuntimeException("Stub!"); }
}

}

