/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.eap;


/**
 * EapInfo represents data provided by the server during EAP authentication
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class EapInfo {

EapInfo() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves EAP method type
 *
 * @return EAP method type

 * Value is {@link android.net.eap.EapSessionConfig.EapMethodConfig#EAP_TYPE_SIM}, {@link android.net.eap.EapSessionConfig.EapMethodConfig#EAP_TYPE_TTLS}, {@link android.net.eap.EapSessionConfig.EapMethodConfig#EAP_TYPE_AKA}, {@link android.net.eap.EapSessionConfig.EapMethodConfig#EAP_TYPE_MSCHAP_V2}, or {@link android.net.eap.EapSessionConfig.EapMethodConfig#EAP_TYPE_AKA_PRIME}
 */

public final int getEapMethodType() { throw new RuntimeException("Stub!"); }
}

