/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

import java.util.List;
import android.os.Parcelable;

/**
 * Describes information about a detected access point. In addition
 * to the attributes described here, the supplicant keeps track of
 * {@code quality}, {@code noise}, and {@code maxbitrate} attributes,
 * but does not currently report them to external clients.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScanResult implements android.os.Parcelable {

/**
 * copy constructor
 * @param source This value cannot be {@code null}.
 */

public ScanResult(@android.annotation.NonNull android.net.wifi.ScanResult source) { throw new RuntimeException("Stub!"); }

/** Construct an empty scan result. */

public ScanResult() { throw new RuntimeException("Stub!"); }

/**
 * The SSID of the access point.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.wifi.WifiSsid getWifiSsid() { throw new RuntimeException("Stub!"); }

/**
 * Return the access point Multi-Link Device (MLD) MAC Address for Wi-Fi 7 access points.
 * i.e. {@link #getWifiStandard()} returns {@link #WIFI_STANDARD_11BE}.
 *
 * @return MLD MAC Address for access point if exists (Wi-Fi 7 access points), null otherwise.
 */

@android.annotation.Nullable
public android.net.MacAddress getApMldMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Return the access point Multi-Link Operation (MLO) link-id for Wi-Fi 7 access points.
 * i.e. when {@link #getWifiStandard()} returns {@link #WIFI_STANDARD_11BE}, otherwise return
 * {@link android.net.wifi.MloLink#INVALID_MLO_LINK_ID MloLink#INVALID_MLO_LINK_ID}.
 *
 * Valid values are 0-15 as described in IEEE 802.11be Specification, section 9.4.2.295b.2.
 *
 * @return {@link android.net.wifi.MloLink#INVALID_MLO_LINK_ID MloLink#INVALID_MLO_LINK_ID} or a valid value (0-15).

 * Value is between MloLink.INVALID_MLO_LINK_ID and MloLink.MAX_MLO_LINK_ID inclusive
 */

public int getApMloLinkId() { throw new RuntimeException("Stub!"); }

/**
 * Return the Multi-Link Operation (MLO) affiliated Links for Wi-Fi 7 access points.
 * i.e. when {@link #getWifiStandard()} returns {@link #WIFI_STANDARD_11BE}.
 *
 * @return List of affiliated MLO links, or an empty list if access point is not Wi-Fi 7

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.wifi.MloLink> getAffiliatedMloLinks() { throw new RuntimeException("Stub!"); }

/**
 * return the AP wifi standard.

 * @return Value is {@link android.net.wifi.ScanResult#WIFI_STANDARD_UNKNOWN}, {@link android.net.wifi.ScanResult#WIFI_STANDARD_LEGACY}, {@link android.net.wifi.ScanResult#WIFI_STANDARD_11N}, {@link android.net.wifi.ScanResult#WIFI_STANDARD_11AC}, {@link android.net.wifi.ScanResult#WIFI_STANDARD_11AX}, {@link android.net.wifi.ScanResult#WIFI_STANDARD_11AD}, or {@link android.net.wifi.ScanResult#WIFI_STANDARD_11BE}
 */

public int getWifiStandard() { throw new RuntimeException("Stub!"); }

public boolean is80211mcResponder() { throw new RuntimeException("Stub!"); }

public boolean isPasspointNetwork() { throw new RuntimeException("Stub!"); }

/**
 * Utility function to convert Wi-Fi channel number to frequency in MHz.
 *
 * Reference the Wi-Fi channel numbering and the channelization in IEEE 802.11-2016
 * specifications, section 17.3.8.4.2, 17.3.8.4.3 and Table 15-6.
 *
 * See also {@link #convertFrequencyMhzToChannelIfSupported(int)}.
 *
 * @param channel number to convert.
 * @param band of channel to convert. One of the following bands:
 *        {@link #WIFI_BAND_24_GHZ},  {@link #WIFI_BAND_5_GHZ},
 *        {@link #WIFI_BAND_6_GHZ},  {@link #WIFI_BAND_60_GHZ}.
 * Value is {@link android.net.wifi.ScanResult#UNSPECIFIED}, {@link android.net.wifi.ScanResult#WIFI_BAND_24_GHZ}, {@link android.net.wifi.ScanResult#WIFI_BAND_5_GHZ}, {@link android.net.wifi.ScanResult#WIFI_BAND_6_GHZ}, or {@link android.net.wifi.ScanResult#WIFI_BAND_60_GHZ}
 * @return center frequency in Mhz of the channel, {@link #UNSPECIFIED} if no match
 */

public static int convertChannelToFrequencyMhzIfSupported(int channel, int band) { throw new RuntimeException("Stub!"); }

/**
 * Utility function to convert frequency in MHz to channel number.
 *
 * See also {@link #convertChannelToFrequencyMhzIfSupported(int,int)}.
 *
 * @param freqMhz frequency in MHz
 * @return channel number associated with given frequency, {@link #UNSPECIFIED} if no match
 */

public static int convertFrequencyMhzToChannelIfSupported(int freqMhz) { throw new RuntimeException("Stub!"); }

/**
 * Get all information elements found in the beacon.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.wifi.ScanResult.InformationElement> getInformationElements() { throw new RuntimeException("Stub!"); }

/**
 * Get all the security types supported by this ScanResult.
 * @return array of {@code WifiInfo#SECURITY_TYPE_*}.
 
 * This value cannot be {@code null}.

 * Value is {@link android.net.wifi.WifiInfo#SECURITY_TYPE_UNKNOWN}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_OPEN}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_WEP}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_PSK}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_EAP}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_SAE}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_OWE}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_WAPI_PSK}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_WAPI_CERT}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_EAP_WPA3_ENTERPRISE}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_EAP_WPA3_ENTERPRISE_192_BIT}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_PASSPOINT_R1_R2}, {@link android.net.wifi.WifiInfo#SECURITY_TYPE_PASSPOINT_R3}, or {@link android.net.wifi.WifiInfo#SECURITY_TYPE_DPP}
 */

@android.annotation.NonNull
public int[] getSecurityTypes() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * The address of the access point.
 */

public java.lang.String BSSID;

/**
 * AP Channel bandwidth is 160 MHZ
 */

public static final int CHANNEL_WIDTH_160MHZ = 3; // 0x3

/**
 * AP Channel bandwidth is 20 MHZ
 */

public static final int CHANNEL_WIDTH_20MHZ = 0; // 0x0

/**
 * AP Channel bandwidth is 320 MHZ
 */

public static final int CHANNEL_WIDTH_320MHZ = 5; // 0x5

/**
 * AP Channel bandwidth is 40 MHZ
 */

public static final int CHANNEL_WIDTH_40MHZ = 1; // 0x1

/**
 * AP Channel bandwidth is 80 MHZ
 */

public static final int CHANNEL_WIDTH_80MHZ = 2; // 0x2

/**
 * AP Channel bandwidth is 160 MHZ, but 80MHZ + 80MHZ
 */

public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4; // 0x4

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.ScanResult> CREATOR;
static { CREATOR = null; }

/**
 * Preamble type: EHT.
 */

public static final int PREAMBLE_EHT = 4; // 0x4

/**
 * Preamble type: HE.
 */

public static final int PREAMBLE_HE = 3; // 0x3

/**
 * Preamble type: HT.
 */

public static final int PREAMBLE_HT = 1; // 0x1

/**
 * Preamble type: Legacy.
 */

public static final int PREAMBLE_LEGACY = 0; // 0x0

/**
 * Preamble type: VHT.
 */

public static final int PREAMBLE_VHT = 2; // 0x2

/**
 * The network name.
 *
 * @deprecated Use {@link #getWifiSsid()} instead.
 */

@Deprecated public java.lang.String SSID;

/**
 * The unspecified value.
 */

public static final int UNSPECIFIED = -1; // 0xffffffff

/**
 * Wi-Fi 2.4 GHz band.
 */

public static final int WIFI_BAND_24_GHZ = 1; // 0x1

/**
 * Wi-Fi 5 GHz band.
 */

public static final int WIFI_BAND_5_GHZ = 2; // 0x2

/**
 * Wi-Fi 60 GHz band.
 */

public static final int WIFI_BAND_60_GHZ = 16; // 0x10

/**
 * Wi-Fi 6 GHz band.
 */

public static final int WIFI_BAND_6_GHZ = 8; // 0x8

/**
 * Wi-Fi 802.11ac
 */

public static final int WIFI_STANDARD_11AC = 5; // 0x5

/**
 * Wi-Fi 802.11ad
 */

public static final int WIFI_STANDARD_11AD = 7; // 0x7

/**
 * Wi-Fi 802.11ax
 */

public static final int WIFI_STANDARD_11AX = 6; // 0x6

/**
 * Wi-Fi 802.11be
 */

public static final int WIFI_STANDARD_11BE = 8; // 0x8

/**
 * Wi-Fi 802.11n
 */

public static final int WIFI_STANDARD_11N = 4; // 0x4

/**
 * Wi-Fi 802.11a/b/g
 */

public static final int WIFI_STANDARD_LEGACY = 1; // 0x1

/**
 * Wi-Fi unknown standard
 */

public static final int WIFI_STANDARD_UNKNOWN = 0; // 0x0

/**
 * Describes the authentication, key management, and encryption schemes
 * supported by the access point.
 */

public java.lang.String capabilities;

/**
 * Not used if the AP bandwidth is 20 MHz
 * If the AP use 40, 80, 160 or 320MHz, this is the center frequency (in MHz)
 * if the AP use 80 + 80 MHz, this is the center frequency of the first segment (in MHz)
 */

public int centerFreq0;

/**
 * Only used if the AP bandwidth is 80 + 80 MHz
 * if the AP use 80 + 80 MHz, this is the center frequency of the second segment (in MHz)
 */

public int centerFreq1;

/**
 * AP Channel bandwidth; one of {@link #CHANNEL_WIDTH_20MHZ}, {@link #CHANNEL_WIDTH_40MHZ},
 * {@link #CHANNEL_WIDTH_80MHZ}, {@link #CHANNEL_WIDTH_160MHZ}, {@link #CHANNEL_WIDTH_320MHZ},
 * or {@link #CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link #CHANNEL_WIDTH_320MHZ}

 * <br>
 * Value is {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ}
 */

public int channelWidth;

/**
 * The center frequency of the primary 20 MHz frequency (in MHz) of the channel over which the
 * client is communicating with the access point.
 */

public int frequency;

/**
 * The detected signal level in dBm, also known as the RSSI.
 *
 * <p>Use {@link android.net.wifi.WifiManager#calculateSignalLevel} to convert this number into
 * an absolute signal level which can be displayed to a user.
 */

public int level;

/**
 * Indicates Passpoint operator name published by access point.
 * @deprecated - Use {@link android.net.wifi.WifiInfo#getPasspointProviderFriendlyName() WifiInfo#getPasspointProviderFriendlyName()}
 */

@Deprecated public java.lang.CharSequence operatorFriendlyName;

/**
 * timestamp in microseconds (since boot) when
 * this result was last seen.
 */

public long timestamp;

/**
 * Indicates venue name (such as 'San Francisco Airport') published by access point; only
 * available on Passpoint network and if published by access point.
 * @deprecated - This information is not provided
 */

@Deprecated public java.lang.CharSequence venueName;
/**
 * information elements from beacon.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InformationElement implements android.os.Parcelable {

/**
 * Constructs InformationElements from beacon.
 *
 * @param id element id
 * @param idExt element id extension
 * @param bytes the body of the information element, may contain multiple elements

 * This value cannot be {@code null}.
 */

public InformationElement(int id, int idExt, @android.annotation.NonNull byte[] bytes) { throw new RuntimeException("Stub!"); }

/**
 * @param rhs This value cannot be {@code null}.
 */

public InformationElement(@android.annotation.NonNull android.net.wifi.ScanResult.InformationElement rhs) { throw new RuntimeException("Stub!"); }

/**
 * The element ID of the information element. Defined in the IEEE 802.11-2016 spec
 * Table 9-77.
 */

public int getId() { throw new RuntimeException("Stub!"); }

/**
 * The element ID Extension of the information element. Defined in the IEEE 802.11-2016 spec
 * Table 9-77.
 */

public int getIdExt() { throw new RuntimeException("Stub!"); }

/**
 * Get the specific content of the information element.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.nio.ByteBuffer getBytes() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface {@hide} */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object that) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.ScanResult.InformationElement> CREATOR;
static { CREATOR = null; }
}

}

