/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os.health;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UidHealthStats {

private UidHealthStats() { throw new RuntimeException("Stub!"); }

public static final int MEASUREMENT_BLUETOOTH_IDLE_MS = 10020; // 0x2724

public static final int MEASUREMENT_BLUETOOTH_POWER_MAMS = 10023; // 0x2727

public static final int MEASUREMENT_BLUETOOTH_RX_BYTES = 10052; // 0x2744

public static final int MEASUREMENT_BLUETOOTH_RX_MS = 10021; // 0x2725

public static final int MEASUREMENT_BLUETOOTH_RX_PACKETS = 10058; // 0x274a

public static final int MEASUREMENT_BLUETOOTH_TX_BYTES = 10053; // 0x2745

public static final int MEASUREMENT_BLUETOOTH_TX_MS = 10022; // 0x2726

public static final int MEASUREMENT_BLUETOOTH_TX_PACKETS = 10059; // 0x274b

public static final int MEASUREMENT_BUTTON_USER_ACTIVITY_COUNT = 10046; // 0x273e

@Deprecated public static final int MEASUREMENT_CPU_POWER_MAMS = 10064; // 0x2750

public static final int MEASUREMENT_MOBILE_IDLE_MS = 10024; // 0x2728

public static final int MEASUREMENT_MOBILE_POWER_MAMS = 10027; // 0x272b

public static final int MEASUREMENT_MOBILE_RX_BYTES = 10048; // 0x2740

public static final int MEASUREMENT_MOBILE_RX_MS = 10025; // 0x2729

public static final int MEASUREMENT_MOBILE_RX_PACKETS = 10054; // 0x2746

public static final int MEASUREMENT_MOBILE_TX_BYTES = 10049; // 0x2741

public static final int MEASUREMENT_MOBILE_TX_MS = 10026; // 0x272a

public static final int MEASUREMENT_MOBILE_TX_PACKETS = 10055; // 0x2747

public static final int MEASUREMENT_OTHER_USER_ACTIVITY_COUNT = 10045; // 0x273d

public static final int MEASUREMENT_REALTIME_BATTERY_MS = 10001; // 0x2711

public static final int MEASUREMENT_REALTIME_SCREEN_OFF_BATTERY_MS = 10003; // 0x2713

public static final int MEASUREMENT_SYSTEM_CPU_TIME_MS = 10063; // 0x274f

public static final int MEASUREMENT_TOUCH_USER_ACTIVITY_COUNT = 10047; // 0x273f

public static final int MEASUREMENT_UPTIME_BATTERY_MS = 10002; // 0x2712

public static final int MEASUREMENT_UPTIME_SCREEN_OFF_BATTERY_MS = 10004; // 0x2714

public static final int MEASUREMENT_USER_CPU_TIME_MS = 10062; // 0x274e

public static final int MEASUREMENT_WIFI_FULL_LOCK_MS = 10029; // 0x272d

public static final int MEASUREMENT_WIFI_IDLE_MS = 10016; // 0x2720

public static final int MEASUREMENT_WIFI_MULTICAST_MS = 10031; // 0x272f

public static final int MEASUREMENT_WIFI_POWER_MAMS = 10019; // 0x2723

public static final int MEASUREMENT_WIFI_RUNNING_MS = 10028; // 0x272c

public static final int MEASUREMENT_WIFI_RX_BYTES = 10050; // 0x2742

public static final int MEASUREMENT_WIFI_RX_MS = 10017; // 0x2721

public static final int MEASUREMENT_WIFI_RX_PACKETS = 10056; // 0x2748

public static final int MEASUREMENT_WIFI_TX_BYTES = 10051; // 0x2743

public static final int MEASUREMENT_WIFI_TX_MS = 10018; // 0x2722

public static final int MEASUREMENT_WIFI_TX_PACKETS = 10057; // 0x2749

public static final int STATS_PACKAGES = 10015; // 0x271f

public static final int STATS_PIDS = 10013; // 0x271d

public static final int STATS_PROCESSES = 10014; // 0x271e

public static final int TIMERS_JOBS = 10010; // 0x271a

public static final int TIMERS_SENSORS = 10012; // 0x271c

public static final int TIMERS_SYNCS = 10009; // 0x2719

public static final int TIMERS_WAKELOCKS_DRAW = 10008; // 0x2718

public static final int TIMERS_WAKELOCKS_FULL = 10005; // 0x2715

public static final int TIMERS_WAKELOCKS_PARTIAL = 10006; // 0x2716

public static final int TIMERS_WAKELOCKS_WINDOW = 10007; // 0x2717

public static final int TIMER_AUDIO = 10032; // 0x2730

public static final int TIMER_BLUETOOTH_SCAN = 10037; // 0x2735

public static final int TIMER_CAMERA = 10035; // 0x2733

public static final int TIMER_FLASHLIGHT = 10034; // 0x2732

public static final int TIMER_FOREGROUND_ACTIVITY = 10036; // 0x2734

public static final int TIMER_GPS_SENSOR = 10011; // 0x271b

public static final int TIMER_MOBILE_RADIO_ACTIVE = 10061; // 0x274d

public static final int TIMER_PROCESS_STATE_BACKGROUND_MS = 10042; // 0x273a

public static final int TIMER_PROCESS_STATE_CACHED_MS = 10043; // 0x273b

public static final int TIMER_PROCESS_STATE_FOREGROUND_MS = 10041; // 0x2739

public static final int TIMER_PROCESS_STATE_FOREGROUND_SERVICE_MS = 10039; // 0x2737

public static final int TIMER_PROCESS_STATE_TOP_MS = 10038; // 0x2736

public static final int TIMER_PROCESS_STATE_TOP_SLEEPING_MS = 10040; // 0x2738

public static final int TIMER_VIBRATOR = 10044; // 0x273c

public static final int TIMER_VIDEO = 10033; // 0x2731

public static final int TIMER_WIFI_SCAN = 10030; // 0x272e
}

