/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Doug Lea with assistance from members of JCP JSR-166
 * Expert Group and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 */


package java.util.concurrent;

import java.util.NavigableMap;
import java.util.NavigableSet;

/**
 * A {@link java.util.concurrent.ConcurrentMap ConcurrentMap} supporting {@link java.util.NavigableMap NavigableMap} operations,
 * and recursively so for its navigable sub-maps.
 *
 * <p>This interface is a member of the
 * <a href="{@docRoot}/java.base/java/util/package-summary.html#CollectionsFramework">
 * Java Collections Framework</a>.
 *
 * @author Doug Lea
 * @param <K> the type of keys maintained by this map
 * @param <V> the type of mapped values
 * @since 1.6
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ConcurrentNavigableMap<K, V> extends java.util.concurrent.ConcurrentMap<K,V>,  java.util.NavigableMap<K,V> {

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive);

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> headMap(K toKey, boolean inclusive);

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> tailMap(K fromKey, boolean inclusive);

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> subMap(K fromKey, K toKey);

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> headMap(K toKey);

/**
 * @throws java.lang.ClassCastException       {@inheritDoc}
 * @throws java.lang.NullPointerException     {@inheritDoc}
 * @throws java.lang.IllegalArgumentException {@inheritDoc}
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> tailMap(K fromKey);

/**
 * Returns a reverse order view of the mappings contained in this map.
 * The descending map is backed by this map, so changes to the map are
 * reflected in the descending map, and vice-versa.
 *
 * <p>The returned map has an ordering equivalent to
 * {@link java.util.Collections#reverseOrder(Comparator) Collections.reverseOrder}{@code (comparator())}.
 * The expression {@code m.descendingMap().descendingMap()} returns a
 * view of {@code m} essentially equivalent to {@code m}.
 *
 * @return a reverse order view of this map
 */

public java.util.concurrent.ConcurrentNavigableMap<K,V> descendingMap();

/**
 * Returns a {@link java.util.NavigableSet NavigableSet} view of the keys contained in this map.
 * The set's iterator returns the keys in ascending order.
 * The set is backed by the map, so changes to the map are
 * reflected in the set, and vice-versa.  The set supports element
 * removal, which removes the corresponding mapping from the map,
 * via the {@code Iterator.remove}, {@code Set.remove},
 * {@code removeAll}, {@code retainAll}, and {@code clear}
 * operations.  It does not support the {@code add} or {@code addAll}
 * operations.
 *
 * <p>The view's iterators and spliterators are
 * <a href="package-summary.html#Weakly"><i>weakly consistent</i></a>.
 *
 * @return a navigable set view of the keys in this map
 */

public java.util.NavigableSet<K> navigableKeySet();

/**
 * Returns a {@link java.util.NavigableSet NavigableSet} view of the keys contained in this map.
 * The set's iterator returns the keys in ascending order.
 * The set is backed by the map, so changes to the map are
 * reflected in the set, and vice-versa.  The set supports element
 * removal, which removes the corresponding mapping from the map,
 * via the {@code Iterator.remove}, {@code Set.remove},
 * {@code removeAll}, {@code retainAll}, and {@code clear}
 * operations.  It does not support the {@code add} or {@code addAll}
 * operations.
 *
 * <p>The view's iterators and spliterators are
 * <a href="package-summary.html#Weakly"><i>weakly consistent</i></a>.
 *
 * <p>This method is equivalent to method {@code navigableKeySet}.
 *
 * @return a navigable set view of the keys in this map
 */

public java.util.NavigableSet<K> keySet();

/**
 * Returns a reverse order {@link java.util.NavigableSet NavigableSet} view of the keys contained in this map.
 * The set's iterator returns the keys in descending order.
 * The set is backed by the map, so changes to the map are
 * reflected in the set, and vice-versa.  The set supports element
 * removal, which removes the corresponding mapping from the map,
 * via the {@code Iterator.remove}, {@code Set.remove},
 * {@code removeAll}, {@code retainAll}, and {@code clear}
 * operations.  It does not support the {@code add} or {@code addAll}
 * operations.
 *
 * <p>The view's iterators and spliterators are
 * <a href="package-summary.html#Weakly"><i>weakly consistent</i></a>.
 *
 * @return a reverse order navigable set view of the keys in this map
 */

public java.util.NavigableSet<K> descendingKeySet();
}

