(()=>{var __webpack_modules__=[,module=>{"use strict";module.exports=require("electron")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getChannelFilename=getChannelFilename;exports.newBaseUrl=newBaseUrl;exports.newUrlFromBase=newUrlFromBase;Object.defineProperty(exports,"AppUpdater",{enumerable:true,get:function(){return _AppUpdater().AppUpdater}});Object.defineProperty(exports,"NoOpLogger",{enumerable:true,get:function(){return _AppUpdater().NoOpLogger}});Object.defineProperty(exports,"CancellationToken",{enumerable:true,get:function(){return _builderUtilRuntime().CancellationToken}});Object.defineProperty(exports,"Provider",{enumerable:true,get:function(){return _Provider().Provider}});Object.defineProperty(exports,"AppImageUpdater",{enumerable:true,get:function(){return _AppImageUpdater().AppImageUpdater}});Object.defineProperty(exports,"MacUpdater",{enumerable:true,get:function(){return _MacUpdater().MacUpdater}});Object.defineProperty(exports,"NsisUpdater",{enumerable:true,get:function(){return _NsisUpdater().NsisUpdater}});exports.UpdaterSignal=exports.UPDATE_DOWNLOADED=exports.DOWNLOAD_PROGRESS=void 0;function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _AppUpdater(){const data=__webpack_require__(4);_AppUpdater=function(){return data};return data}function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}function _AppImageUpdater(){const data=__webpack_require__(157);_AppImageUpdater=function(){return data};return data}function _MacUpdater(){const data=__webpack_require__(166);_MacUpdater=function(){return data};return data}function _NsisUpdater(){const data=__webpack_require__(168);_NsisUpdater=function(){return data};return data}let _autoUpdater;function doLoadAutoUpdater(){if(process.platform==="win32"){_autoUpdater=new(__webpack_require__(168).NsisUpdater)}else if(process.platform==="darwin"){_autoUpdater=new(__webpack_require__(166).MacUpdater)}else{_autoUpdater=new(__webpack_require__(157).AppImageUpdater)}return _autoUpdater}Object.defineProperty(exports,"autoUpdater",{enumerable:true,get:()=>_autoUpdater||doLoadAutoUpdater()});function getChannelFilename(channel){return`${channel}.yml`}const DOWNLOAD_PROGRESS="download-progress";exports.DOWNLOAD_PROGRESS=DOWNLOAD_PROGRESS;const UPDATE_DOWNLOADED="update-downloaded";exports.UPDATE_DOWNLOADED=UPDATE_DOWNLOADED;class UpdaterSignal{constructor(emitter){this.emitter=emitter}login(handler){addHandler(this.emitter,"login",handler)}progress(handler){addHandler(this.emitter,DOWNLOAD_PROGRESS,handler)}updateDownloaded(handler){addHandler(this.emitter,UPDATE_DOWNLOADED,handler)}updateCancelled(handler){addHandler(this.emitter,"update-cancelled",handler)}}exports.UpdaterSignal=UpdaterSignal;const isLogEvent=false;function addHandler(emitter,event,handler){if(isLogEvent){emitter.on(event,((...args)=>{console.log("%s %s",event,args);handler(...args)}))}else{emitter.on(event,handler)}}function newBaseUrl(url){const result=new(_url().URL)(url);if(!result.pathname.endsWith("/")){result.pathname+="/"}return result}function newUrlFromBase(pathname,baseUrl,addRandomQueryToAvoidCaching=false){const result=new(_url().URL)(pathname,baseUrl);const search=baseUrl.search;if(search!=null&&search.length!==0){result.search=search}else if(addRandomQueryToAvoidCaching){result.search=`noCache=${Date.now().toString(32)}`}return result}},module=>{"use strict";module.exports=require("url")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NoOpLogger=exports.AppUpdater=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _crypto(){const data=__webpack_require__(9);_crypto=function(){return data};return data}function _electron(){const data=__webpack_require__(1);_electron=function(){return data};return data}function _events(){const data=__webpack_require__(7);_events=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}function _jsYaml(){const data=__webpack_require__(69);_jsYaml=function(){return data};return data}function _lazyVal(){const data=__webpack_require__(101);_lazyVal=function(){return data};return data}var path=_interopRequireWildcard(__webpack_require__(40));function _semver(){const data=__webpack_require__(102);_semver=function(){return data};return data}function _DownloadedUpdateHelper(){const data=__webpack_require__(145);_DownloadedUpdateHelper=function(){return data};return data}function _ElectronAppAdapter(){const data=__webpack_require__(147);_ElectronAppAdapter=function(){return data};return data}function _electronHttpExecutor(){const data=__webpack_require__(149);_electronHttpExecutor=function(){return data};return data}function _GenericProvider(){const data=__webpack_require__(150);_GenericProvider=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _providerFactory(){const data=__webpack_require__(152);_providerFactory=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class AppUpdater extends _events().EventEmitter{constructor(options,app){super();this.autoDownload=true;this.autoInstallOnAppQuit=true;this.allowPrerelease=false;this.fullChangelog=false;this.allowDowngrade=false;this._channel=null;this.downloadedUpdateHelper=null;this.requestHeaders=null;this._logger=console;this.signals=new(_main().UpdaterSignal)(this);this._appUpdateConfigPath=null;this.clientPromise=null;this.stagingUserIdPromise=new(_lazyVal().Lazy)((()=>this.getOrCreateStagingUserId()));this.configOnDisk=new(_lazyVal().Lazy)((()=>this.loadUpdateConfig()));this.checkForUpdatesPromise=null;this.updateInfoAndProvider=null;this._testOnlyOptions=null;this.on("error",(error=>{this._logger.error(`Error: ${error.stack||error.message}`)}));if(app==null){this.app=new(_ElectronAppAdapter().ElectronAppAdapter);this.httpExecutor=new(_electronHttpExecutor().ElectronHttpExecutor)(((authInfo,callback)=>this.emit("login",authInfo,callback)))}else{this.app=app;this.httpExecutor=null}const currentVersionString=this.app.version;const currentVersion=(0,_semver().parse)(currentVersionString);if(currentVersion==null){throw(0,_builderUtilRuntime().newError)(`App version is not a valid semver version: "${currentVersionString}"`,"ERR_UPDATER_INVALID_VERSION")}this.currentVersion=currentVersion;this.allowPrerelease=hasPrereleaseComponents(currentVersion);if(options!=null){this.setFeedURL(options);if(typeof options!=="string"&&options.requestHeaders){this.requestHeaders=options.requestHeaders}}}get channel(){return this._channel}set channel(value){if(this._channel!=null){if(typeof value!=="string"){throw(0,_builderUtilRuntime().newError)(`Channel must be a string, but got: ${value}`,"ERR_UPDATER_INVALID_CHANNEL")}else if(value.length===0){throw(0,_builderUtilRuntime().newError)(`Channel must be not an empty string`,"ERR_UPDATER_INVALID_CHANNEL")}}this._channel=value;this.allowDowngrade=true}get netSession(){return(0,_electronHttpExecutor().getNetSession)()}get logger(){return this._logger}set logger(value){this._logger=value==null?new NoOpLogger:value}set updateConfigPath(value){this.clientPromise=null;this._appUpdateConfigPath=value;this.configOnDisk=new(_lazyVal().Lazy)((()=>this.loadUpdateConfig()))}getFeedURL(){return"Deprecated. Do not use it."}setFeedURL(options){const runtimeOptions=this.createProviderRuntimeOptions();let provider;if(typeof options==="string"){provider=new(_GenericProvider().GenericProvider)({provider:"generic",url:options},this,{...runtimeOptions,isUseMultipleRangeRequest:(0,_providerFactory().isUrlProbablySupportMultiRangeRequests)(options)})}else{provider=(0,_providerFactory().createClient)(options,this,runtimeOptions)}this.clientPromise=Promise.resolve(provider)}checkForUpdates(){let checkForUpdatesPromise=this.checkForUpdatesPromise;if(checkForUpdatesPromise!=null){this._logger.info("Checking for update (already in progress)");return checkForUpdatesPromise}const nullizePromise=()=>this.checkForUpdatesPromise=null;this._logger.info("Checking for update");checkForUpdatesPromise=this.doCheckForUpdates().then((it=>{nullizePromise();return it})).catch((e=>{nullizePromise();this.emit("error",e,`Cannot check for updates: ${(e.stack||e).toString()}`);throw e}));this.checkForUpdatesPromise=checkForUpdatesPromise;return checkForUpdatesPromise}isUpdaterActive(){if(!this.app.isPackaged){this._logger.info("Skip checkForUpdatesAndNotify because application is not packed");return false}return true}checkForUpdatesAndNotify(downloadNotification){if(!this.isUpdaterActive()){return Promise.resolve(null)}return this.checkForUpdates().then((it=>{const downloadPromise=it.downloadPromise;if(downloadPromise==null){const debug=this._logger.debug;if(debug!=null){debug("checkForUpdatesAndNotify called, downloadPromise is null")}return it}downloadPromise.then((()=>{const notificationContent=this.formatDownloadNotification(it.updateInfo.version,this.app.name,downloadNotification);new(_electron().Notification)(notificationContent).show()}));return it}))}formatDownloadNotification(version,appName,downloadNotification){if(downloadNotification==null){downloadNotification={title:"A new update is ready to install",body:`{appName} version {version} has been downloaded and will be automatically installed on exit`}}downloadNotification={title:downloadNotification.title.replace("{appName}",appName).replace("{version}",version),body:downloadNotification.body.replace("{appName}",appName).replace("{version}",version)};return downloadNotification}async isStagingMatch(updateInfo){const rawStagingPercentage=updateInfo.stagingPercentage;let stagingPercentage=rawStagingPercentage;if(stagingPercentage==null){return true}stagingPercentage=parseInt(stagingPercentage,10);if(isNaN(stagingPercentage)){this._logger.warn(`Staging percentage is NaN: ${rawStagingPercentage}`);return true}stagingPercentage=stagingPercentage/100;const stagingUserId=await this.stagingUserIdPromise.value;const val=_builderUtilRuntime().UUID.parse(stagingUserId).readUInt32BE(12);const percentage=val/4294967295;this._logger.info(`Staging percentage: ${stagingPercentage}, percentage: ${percentage}, user id: ${stagingUserId}`);return percentage<stagingPercentage}computeFinalHeaders(headers){if(this.requestHeaders!=null){Object.assign(headers,this.requestHeaders)}return headers}async isUpdateAvailable(updateInfo){const latestVersion=(0,_semver().parse)(updateInfo.version);if(latestVersion==null){throw(0,_builderUtilRuntime().newError)(`This file could not be downloaded, or the latest version (from update server) does not have a valid semver version: "${updateInfo.version}"`,"ERR_UPDATER_INVALID_VERSION")}const currentVersion=this.currentVersion;if((0,_semver().eq)(latestVersion,currentVersion)){return false}const isStagingMatch=await this.isStagingMatch(updateInfo);if(!isStagingMatch){return false}const isLatestVersionNewer=(0,_semver().gt)(latestVersion,currentVersion);const isLatestVersionOlder=(0,_semver().lt)(latestVersion,currentVersion);if(isLatestVersionNewer){return true}return this.allowDowngrade&&isLatestVersionOlder}async getUpdateInfoAndProvider(){await this.app.whenReady();if(this.clientPromise==null){this.clientPromise=this.configOnDisk.value.then((it=>(0,_providerFactory().createClient)(it,this,this.createProviderRuntimeOptions())))}const client=await this.clientPromise;const stagingUserId=await this.stagingUserIdPromise.value;client.setRequestHeaders(this.computeFinalHeaders({"x-user-staging-id":stagingUserId}));return{info:await client.getLatestVersion(),provider:client}}createProviderRuntimeOptions(){return{isUseMultipleRangeRequest:true,platform:this._testOnlyOptions==null?process.platform:this._testOnlyOptions.platform,executor:this.httpExecutor}}async doCheckForUpdates(){this.emit("checking-for-update");const result=await this.getUpdateInfoAndProvider();const updateInfo=result.info;if(!await this.isUpdateAvailable(updateInfo)){this._logger.info(`Update for version ${this.currentVersion} is not available (latest version: ${updateInfo.version}, downgrade is ${this.allowDowngrade?"allowed":"disallowed"}).`);this.emit("update-not-available",updateInfo);return{versionInfo:updateInfo,updateInfo}}this.updateInfoAndProvider=result;this.onUpdateAvailable(updateInfo);const cancellationToken=new(_builderUtilRuntime().CancellationToken);return{versionInfo:updateInfo,updateInfo,cancellationToken,downloadPromise:this.autoDownload?this.downloadUpdate(cancellationToken):null}}onUpdateAvailable(updateInfo){this._logger.info(`Found version ${updateInfo.version} (url: ${(0,_builderUtilRuntime().asArray)(updateInfo.files).map((it=>it.url)).join(", ")})`);this.emit("update-available",updateInfo)}downloadUpdate(cancellationToken=new(_builderUtilRuntime().CancellationToken)){const updateInfoAndProvider=this.updateInfoAndProvider;if(updateInfoAndProvider==null){const error=new Error("Please check update first");this.dispatchError(error);return Promise.reject(error)}this._logger.info(`Downloading update from ${(0,_builderUtilRuntime().asArray)(updateInfoAndProvider.info.files).map((it=>it.url)).join(", ")}`);const errorHandler=e=>{if(!(e instanceof _builderUtilRuntime().CancellationError)){try{this.dispatchError(e)}catch(nestedError){this._logger.warn(`Cannot dispatch error event: ${nestedError.stack||nestedError}`)}}return e};try{return this.doDownloadUpdate({updateInfoAndProvider,requestHeaders:this.computeRequestHeaders(updateInfoAndProvider.provider),cancellationToken}).catch((e=>{throw errorHandler(e)}))}catch(e){return Promise.reject(errorHandler(e))}}dispatchError(e){this.emit("error",e,(e.stack||e).toString())}dispatchUpdateDownloaded(event){this.emit(_main().UPDATE_DOWNLOADED,event)}async loadUpdateConfig(){if(this._appUpdateConfigPath==null){this._appUpdateConfigPath=this.app.appUpdateConfigPath}return(0,_jsYaml().safeLoad)(await(0,_fsExtra().readFile)(this._appUpdateConfigPath,"utf-8"))}computeRequestHeaders(provider){const fileExtraDownloadHeaders=provider.fileExtraDownloadHeaders;if(fileExtraDownloadHeaders!=null){const requestHeaders=this.requestHeaders;return requestHeaders==null?fileExtraDownloadHeaders:{...fileExtraDownloadHeaders,...requestHeaders}}return this.computeFinalHeaders({accept:"*/*"})}async getOrCreateStagingUserId(){const file=path.join(this.app.userDataPath,".updaterId");try{const id=await(0,_fsExtra().readFile)(file,"utf-8");if(_builderUtilRuntime().UUID.check(id)){return id}else{this._logger.warn(`Staging user id file exists, but content was invalid: ${id}`)}}catch(e){if(e.code!=="ENOENT"){this._logger.warn(`Couldn't read staging user ID, creating a blank one: ${e}`)}}const id=_builderUtilRuntime().UUID.v5((0,_crypto().randomBytes)(4096),_builderUtilRuntime().UUID.OID);this._logger.info(`Generated new staging user ID: ${id}`);try{await(0,_fsExtra().outputFile)(file,id)}catch(e){this._logger.warn(`Couldn't write out staging user ID: ${e}`)}return id}get isAddNoCacheQuery(){const headers=this.requestHeaders;if(headers==null){return true}for(const headerName of Object.keys(headers)){const s=headerName.toLowerCase();if(s==="authorization"||s==="private-token"){return false}}return true}async getOrCreateDownloadHelper(){let result=this.downloadedUpdateHelper;if(result==null){const dirName=(await this.configOnDisk.value).updaterCacheDirName;const logger=this._logger;if(dirName==null){logger.error("updaterCacheDirName is not specified in app-update.yml Was app build using at least electron-builder 20.34.0?")}const cacheDir=path.join(this.app.baseCachePath,dirName||this.app.name);if(logger.debug!=null){logger.debug(`updater cache dir: ${cacheDir}`)}result=new(_DownloadedUpdateHelper().DownloadedUpdateHelper)(cacheDir);this.downloadedUpdateHelper=result}return result}async executeDownload(taskOptions){const fileInfo=taskOptions.fileInfo;const downloadOptions={headers:taskOptions.downloadUpdateOptions.requestHeaders,cancellationToken:taskOptions.downloadUpdateOptions.cancellationToken,sha2:fileInfo.info.sha2,sha512:fileInfo.info.sha512};if(this.listenerCount(_main().DOWNLOAD_PROGRESS)>0){downloadOptions.onProgress=it=>this.emit(_main().DOWNLOAD_PROGRESS,it)}const updateInfo=taskOptions.downloadUpdateOptions.updateInfoAndProvider.info;const version=updateInfo.version;const packageInfo=fileInfo.packageInfo;function getCacheUpdateFileName(){const urlPath=decodeURIComponent(taskOptions.fileInfo.url.pathname);if(urlPath.endsWith(`.${taskOptions.fileExtension}`)){return path.posix.basename(urlPath)}else{return`update.${taskOptions.fileExtension}`}}const downloadedUpdateHelper=await this.getOrCreateDownloadHelper();const cacheDir=downloadedUpdateHelper.cacheDirForPendingUpdate;await(0,_fsExtra().ensureDir)(cacheDir);const updateFileName=getCacheUpdateFileName();let updateFile=path.join(cacheDir,updateFileName);const packageFile=packageInfo==null?null:path.join(cacheDir,`package-${version}${path.extname(packageInfo.path)||".7z"}`);const done=async isSaveCache=>{await downloadedUpdateHelper.setDownloadedFile(updateFile,packageFile,updateInfo,fileInfo,updateFileName,isSaveCache);await taskOptions.done({...updateInfo,downloadedFile:updateFile});return packageFile==null?[updateFile]:[updateFile,packageFile]};const log=this._logger;const cachedUpdateFile=await downloadedUpdateHelper.validateDownloadedPath(updateFile,updateInfo,fileInfo,log);if(cachedUpdateFile!=null){updateFile=cachedUpdateFile;return await done(false)}const removeFileIfAny=async()=>{await downloadedUpdateHelper.clear().catch((()=>{}));return await(0,_fsExtra().unlink)(updateFile).catch((()=>{}))};const tempUpdateFile=await(0,_DownloadedUpdateHelper().createTempUpdateFile)(`temp-${updateFileName}`,cacheDir,log);try{await taskOptions.task(tempUpdateFile,downloadOptions,packageFile,removeFileIfAny);await(0,_fsExtra().rename)(tempUpdateFile,updateFile)}catch(e){await removeFileIfAny();if(e instanceof _builderUtilRuntime().CancellationError){log.info("cancelled");this.emit("update-cancelled",updateInfo)}throw e}log.info(`New version ${version} has been downloaded to ${updateFile}`);return await done(true)}}exports.AppUpdater=AppUpdater;function hasPrereleaseComponents(version){const versionPrereleaseComponent=(0,_semver().prerelease)(version);return versionPrereleaseComponent!=null&&versionPrereleaseComponent.length>0}class NoOpLogger{info(message){}warn(message){}error(message){}}exports.NoOpLogger=NoOpLogger},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.asArray=asArray;exports.newError=newError;Object.defineProperty(exports,"CancellationToken",{enumerable:true,get:function(){return _CancellationToken().CancellationToken}});Object.defineProperty(exports,"CancellationError",{enumerable:true,get:function(){return _CancellationToken().CancellationError}});Object.defineProperty(exports,"HttpError",{enumerable:true,get:function(){return _httpExecutor().HttpError}});Object.defineProperty(exports,"createHttpError",{enumerable:true,get:function(){return _httpExecutor().createHttpError}});Object.defineProperty(exports,"HttpExecutor",{enumerable:true,get:function(){return _httpExecutor().HttpExecutor}});Object.defineProperty(exports,"DigestTransform",{enumerable:true,get:function(){return _httpExecutor().DigestTransform}});Object.defineProperty(exports,"safeGetHeader",{enumerable:true,get:function(){return _httpExecutor().safeGetHeader}});Object.defineProperty(exports,"configureRequestOptions",{enumerable:true,get:function(){return _httpExecutor().configureRequestOptions}});Object.defineProperty(exports,"configureRequestOptionsFromUrl",{enumerable:true,get:function(){return _httpExecutor().configureRequestOptionsFromUrl}});Object.defineProperty(exports,"safeStringifyJson",{enumerable:true,get:function(){return _httpExecutor().safeStringifyJson}});Object.defineProperty(exports,"parseJson",{enumerable:true,get:function(){return _httpExecutor().parseJson}});Object.defineProperty(exports,"configureRequestUrl",{enumerable:true,get:function(){return _httpExecutor().configureRequestUrl}});Object.defineProperty(exports,"getS3LikeProviderBaseUrl",{enumerable:true,get:function(){return _publishOptions().getS3LikeProviderBaseUrl}});Object.defineProperty(exports,"githubUrl",{enumerable:true,get:function(){return _publishOptions().githubUrl}});Object.defineProperty(exports,"parseDn",{enumerable:true,get:function(){return _rfc2253Parser().parseDn}});Object.defineProperty(exports,"UUID",{enumerable:true,get:function(){return _uuid().UUID}});Object.defineProperty(exports,"ProgressCallbackTransform",{enumerable:true,get:function(){return _ProgressCallbackTransform().ProgressCallbackTransform}});Object.defineProperty(exports,"parseXml",{enumerable:true,get:function(){return _xml().parseXml}});Object.defineProperty(exports,"XElement",{enumerable:true,get:function(){return _xml().XElement}});exports.CURRENT_APP_PACKAGE_FILE_NAME=exports.CURRENT_APP_INSTALLER_FILE_NAME=void 0;function _CancellationToken(){const data=__webpack_require__(6);_CancellationToken=function(){return data};return data}function _httpExecutor(){const data=__webpack_require__(8);_httpExecutor=function(){return data};return data}function _publishOptions(){const data=__webpack_require__(23);_publishOptions=function(){return data};return data}function _rfc2253Parser(){const data=__webpack_require__(24);_rfc2253Parser=function(){return data};return data}function _uuid(){const data=__webpack_require__(25);_uuid=function(){return data};return data}function _ProgressCallbackTransform(){const data=__webpack_require__(22);_ProgressCallbackTransform=function(){return data};return data}function _xml(){const data=__webpack_require__(26);_xml=function(){return data};return data}const CURRENT_APP_INSTALLER_FILE_NAME="installer.exe";exports.CURRENT_APP_INSTALLER_FILE_NAME=CURRENT_APP_INSTALLER_FILE_NAME;const CURRENT_APP_PACKAGE_FILE_NAME="package.7z";exports.CURRENT_APP_PACKAGE_FILE_NAME=CURRENT_APP_PACKAGE_FILE_NAME;function asArray(v){if(v==null){return[]}else if(Array.isArray(v)){return v}else{return[v]}}function newError(message,code){const error=new Error(message);error.code=code;return error}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.CancellationError=exports.CancellationToken=void 0;function _events(){const data=__webpack_require__(7);_events=function(){return data};return data}class CancellationToken extends _events().EventEmitter{constructor(parent){super();this.parentCancelHandler=null;this._parent=null;this._cancelled=false;if(parent!=null){this.parent=parent}}get cancelled(){return this._cancelled||this._parent!=null&&this._parent.cancelled}set parent(value){this.removeParentCancelHandler();this._parent=value;this.parentCancelHandler=()=>this.cancel();this._parent.onCancel(this.parentCancelHandler)}cancel(){this._cancelled=true;this.emit("cancel")}onCancel(handler){if(this.cancelled){handler()}else{this.once("cancel",handler)}}createPromise(callback){if(this.cancelled){return Promise.reject(new CancellationError)}const finallyHandler=()=>{if(cancelHandler!=null){try{this.removeListener("cancel",cancelHandler);cancelHandler=null}catch(ignore){}}};let cancelHandler=null;return new Promise(((resolve,reject)=>{let addedCancelHandler=null;cancelHandler=()=>{try{if(addedCancelHandler!=null){addedCancelHandler();addedCancelHandler=null}}finally{reject(new CancellationError)}};if(this.cancelled){cancelHandler();return}this.onCancel(cancelHandler);callback(resolve,reject,(callback=>{addedCancelHandler=callback}))})).then((it=>{finallyHandler();return it})).catch((e=>{finallyHandler();throw e}))}removeParentCancelHandler(){const parent=this._parent;if(parent!=null&&this.parentCancelHandler!=null){parent.removeListener("cancel",this.parentCancelHandler);this.parentCancelHandler=null}}dispose(){try{this.removeParentCancelHandler()}finally{this.removeAllListeners();this._parent=null}}}exports.CancellationToken=CancellationToken;class CancellationError extends Error{constructor(){super("cancelled")}}exports.CancellationError=CancellationError},module=>{"use strict";module.exports=require("events")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.createHttpError=createHttpError;exports.parseJson=parseJson;exports.configureRequestOptionsFromUrl=configureRequestOptionsFromUrl;exports.configureRequestUrl=configureRequestUrl;exports.safeGetHeader=safeGetHeader;exports.configureRequestOptions=configureRequestOptions;exports.safeStringifyJson=safeStringifyJson;exports.DigestTransform=exports.HttpExecutor=exports.HttpError=void 0;function _crypto(){const data=__webpack_require__(9);_crypto=function(){return data};return data}var _debug2=_interopRequireDefault(__webpack_require__(10));var _fs=__webpack_require__(20);function _stream(){const data=__webpack_require__(21);_stream=function(){return data};return data}function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _CancellationToken(){const data=__webpack_require__(6);_CancellationToken=function(){return data};return data}function _index(){const data=__webpack_require__(5);_index=function(){return data};return data}function _ProgressCallbackTransform(){const data=__webpack_require__(22);_ProgressCallbackTransform=function(){return data};return data}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}const debug=(0,_debug2.default)("electron-builder");function createHttpError(response,description=null){return new HttpError(response.statusCode||-1,`${response.statusCode} ${response.statusMessage}`+(description==null?"":"\n"+JSON.stringify(description,null,"  "))+"\nHeaders: "+safeStringifyJson(response.headers),description)}const HTTP_STATUS_CODES=new Map([[429,"Too many requests"],[400,"Bad request"],[403,"Forbidden"],[404,"Not found"],[405,"Method not allowed"],[406,"Not acceptable"],[408,"Request timeout"],[413,"Request entity too large"],[500,"Internal server error"],[502,"Bad gateway"],[503,"Service unavailable"],[504,"Gateway timeout"],[505,"HTTP version not supported"]]);class HttpError extends Error{constructor(statusCode,message=`HTTP error: ${HTTP_STATUS_CODES.get(statusCode)||statusCode}`,description=null){super(message);this.statusCode=statusCode;this.description=description;this.name="HttpError";this.code=`HTTP_ERROR_${statusCode}`}}exports.HttpError=HttpError;function parseJson(result){return result.then((it=>it==null||it.length===0?null:JSON.parse(it)))}class HttpExecutor{constructor(){this.maxRedirects=10}request(options,cancellationToken=new(_CancellationToken().CancellationToken),data){configureRequestOptions(options);const encodedData=data==null?undefined:Buffer.from(JSON.stringify(data));if(encodedData!=null){options.method="post";options.headers["Content-Type"]="application/json";options.headers["Content-Length"]=encodedData.length}return this.doApiRequest(options,cancellationToken,(it=>{it.end(encodedData)}))}doApiRequest(options,cancellationToken,requestProcessor,redirectCount=0){if(debug.enabled){debug(`Request: ${safeStringifyJson(options)}`)}return cancellationToken.createPromise(((resolve,reject,onCancel)=>{const request=this.createRequest(options,(response=>{try{this.handleResponse(response,options,cancellationToken,resolve,reject,redirectCount,requestProcessor)}catch(e){reject(e)}}));this.addErrorAndTimeoutHandlers(request,reject);this.addRedirectHandlers(request,options,reject,redirectCount,(options=>{this.doApiRequest(options,cancellationToken,requestProcessor,redirectCount).then(resolve).catch(reject)}));requestProcessor(request,reject);onCancel((()=>request.abort()))}))}addRedirectHandlers(request,options,reject,redirectCount,handler){}addErrorAndTimeoutHandlers(request,reject){this.addTimeOutHandler(request,reject);request.on("error",reject);request.on("aborted",(()=>{reject(new Error("Request has been aborted by the server"))}))}handleResponse(response,options,cancellationToken,resolve,reject,redirectCount,requestProcessor){if(debug.enabled){debug(`Response: ${response.statusCode} ${response.statusMessage}, request options: ${safeStringifyJson(options)}`)}if(response.statusCode===404){reject(createHttpError(response,`method: ${options.method||"GET"} url: ${options.protocol||"https:"}//${options.hostname}${options.port?`:${options.port}`:""}${options.path}\n\nPlease double check that your authentication token is correct. Due to security reasons actual status maybe not reported, but 404.\n`));return}else if(response.statusCode===204){resolve();return}const redirectUrl=safeGetHeader(response,"location");if(redirectUrl!=null){if(redirectCount>this.maxRedirects){reject(this.createMaxRedirectError());return}this.doApiRequest(HttpExecutor.prepareRedirectUrlOptions(redirectUrl,options),cancellationToken,requestProcessor,redirectCount).then(resolve).catch(reject);return}response.setEncoding("utf8");let data="";response.on("error",reject);response.on("data",(chunk=>data+=chunk));response.on("end",(()=>{try{if(response.statusCode!=null&&response.statusCode>=400){const contentType=safeGetHeader(response,"content-type");const isJson=contentType!=null&&(Array.isArray(contentType)?contentType.find((it=>it.includes("json")))!=null:contentType.includes("json"));reject(createHttpError(response,isJson?JSON.parse(data):data))}else{resolve(data.length===0?null:data)}}catch(e){reject(e)}}))}async downloadToBuffer(url,options){return await options.cancellationToken.createPromise(((resolve,reject,onCancel)=>{let result=null;const requestOptions={headers:options.headers||undefined,redirect:"manual"};configureRequestUrl(url,requestOptions);configureRequestOptions(requestOptions);this.doDownload(requestOptions,{destination:null,options,onCancel,callback:error=>{if(error==null){resolve(result)}else{reject(error)}},responseHandler:(response,callback)=>{const contentLength=safeGetHeader(response,"content-length");let position=-1;if(contentLength!=null){const size=parseInt(contentLength,10);if(size>0){if(size>52428800){callback(new Error("Maximum allowed size is 50 MB"));return}result=Buffer.alloc(size);position=0}}response.on("data",(chunk=>{if(position!==-1){chunk.copy(result,position);position+=chunk.length}else if(result==null){result=chunk}else{if(result.length>52428800){callback(new Error("Maximum allowed size is 50 MB"));return}result=Buffer.concat([result,chunk])}}));response.on("end",(()=>{if(result!=null&&position!==-1&&position!==result.length){callback(new Error(`Received data length ${position} is not equal to expected ${result.length}`))}else{callback(null)}}))}},0)}))}doDownload(requestOptions,options,redirectCount){const request=this.createRequest(requestOptions,(response=>{if(response.statusCode>=400){options.callback(new Error(`Cannot download "${requestOptions.protocol||"https:"}//${requestOptions.hostname}${requestOptions.path}", status ${response.statusCode}: ${response.statusMessage}`));return}response.on("error",options.callback);const redirectUrl=safeGetHeader(response,"location");if(redirectUrl!=null){if(redirectCount<this.maxRedirects){this.doDownload(HttpExecutor.prepareRedirectUrlOptions(redirectUrl,requestOptions),options,redirectCount++)}else{options.callback(this.createMaxRedirectError())}return}if(options.responseHandler==null){configurePipes(options,response)}else{options.responseHandler(response,options.callback)}}));this.addErrorAndTimeoutHandlers(request,options.callback);this.addRedirectHandlers(request,requestOptions,options.callback,redirectCount,(requestOptions=>{this.doDownload(requestOptions,options,redirectCount++)}));request.end()}createMaxRedirectError(){return new Error(`Too many redirects (> ${this.maxRedirects})`)}addTimeOutHandler(request,callback){request.on("socket",(socket=>{socket.setTimeout(60*1e3,(()=>{request.abort();callback(new Error("Request timed out"))}))}))}static prepareRedirectUrlOptions(redirectUrl,options){const newOptions=configureRequestOptionsFromUrl(redirectUrl,{...options});const headers=newOptions.headers;if(headers!=null&&headers.authorization!=null&&headers.authorization.startsWith("token")){const parsedNewUrl=new(_url().URL)(redirectUrl);if(parsedNewUrl.hostname.endsWith(".amazonaws.com")){delete headers.authorization}}return newOptions}}exports.HttpExecutor=HttpExecutor;function configureRequestOptionsFromUrl(url,options){const result=configureRequestOptions(options);configureRequestUrl(new(_url().URL)(url),result);return result}function configureRequestUrl(url,options){options.protocol=url.protocol;options.hostname=url.hostname;if(url.port){options.port=url.port}else if(options.port){delete options.port}options.path=url.pathname+url.search}class DigestTransform extends _stream().Transform{constructor(expected,algorithm="sha512",encoding="base64"){super();this.expected=expected;this.algorithm=algorithm;this.encoding=encoding;this._actual=null;this.isValidateOnEnd=true;this.digester=(0,_crypto().createHash)(algorithm)}get actual(){return this._actual}_transform(chunk,encoding,callback){this.digester.update(chunk);callback(null,chunk)}_flush(callback){this._actual=this.digester.digest(this.encoding);if(this.isValidateOnEnd){try{this.validate()}catch(e){callback(e);return}}callback(null)}validate(){if(this._actual==null){throw(0,_index().newError)("Not finished yet","ERR_STREAM_NOT_FINISHED")}if(this._actual!==this.expected){throw(0,_index().newError)(`${this.algorithm} checksum mismatch, expected ${this.expected}, got ${this._actual}`,"ERR_CHECKSUM_MISMATCH")}return null}}exports.DigestTransform=DigestTransform;function checkSha2(sha2Header,sha2,callback){if(sha2Header!=null&&sha2!=null&&sha2Header!==sha2){callback(new Error(`checksum mismatch: expected ${sha2} but got ${sha2Header} (X-Checksum-Sha2 header)`));return false}return true}function safeGetHeader(response,headerKey){const value=response.headers[headerKey];if(value==null){return null}else if(Array.isArray(value)){return value.length===0?null:value[value.length-1]}else{return value}}function configurePipes(options,response){if(!checkSha2(safeGetHeader(response,"X-Checksum-Sha2"),options.options.sha2,options.callback)){return}const streams=[];if(options.options.onProgress!=null){const contentLength=safeGetHeader(response,"content-length");if(contentLength!=null){streams.push(new(_ProgressCallbackTransform().ProgressCallbackTransform)(parseInt(contentLength,10),options.options.cancellationToken,options.options.onProgress))}}const sha512=options.options.sha512;if(sha512!=null){streams.push(new DigestTransform(sha512,"sha512",sha512.length===128&&!sha512.includes("+")&&!sha512.includes("Z")&&!sha512.includes("=")?"hex":"base64"))}else if(options.options.sha2!=null){streams.push(new DigestTransform(options.options.sha2,"sha256","hex"))}const fileOut=(0,_fs.createWriteStream)(options.destination);streams.push(fileOut);let lastStream=response;for(const stream of streams){stream.on("error",(error=>{if(!options.options.cancellationToken.cancelled){options.callback(error)}}));lastStream=lastStream.pipe(stream)}fileOut.on("finish",(()=>{fileOut.close(options.callback)}))}function configureRequestOptions(options,token,method){if(method!=null){options.method=method}options.headers={...options.headers};const headers=options.headers;if(token!=null){headers.authorization=token.startsWith("Basic")?token:`token ${token}`}if(headers["User-Agent"]==null){headers["User-Agent"]="electron-builder"}if(method==null||method==="GET"||headers["Cache-Control"]==null){headers["Cache-Control"]="no-cache"}if(options.protocol==null&&process.versions.electron!=null){options.protocol="https:"}return options}function safeStringifyJson(data,skippedNames){return JSON.stringify(data,((name,value)=>{if(name.endsWith("authorization")||name.endsWith("Password")||name.endsWith("PASSWORD")||name.endsWith("Token")||name.includes("password")||name.includes("token")||skippedNames!=null&&skippedNames.has(name)){return"<stripped sensitive data>"}return value}),2)}},module=>{"use strict";module.exports=require("crypto")},(module,__unused_webpack_exports,__webpack_require__)=>{if(typeof process==="undefined"||process.type==="renderer"||process.browser===true||process.__nwjs){module.exports=__webpack_require__(11)}else{module.exports=__webpack_require__(14)}},(module,exports,__webpack_require__)=>{exports.formatArgs=formatArgs;exports.save=save;exports.load=load;exports.useColors=useColors;exports.storage=localstorage();exports.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function useColors(){if(typeof window!=="undefined"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)){return true}if(typeof navigator!=="undefined"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)){return false}return typeof document!=="undefined"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window!=="undefined"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator!=="undefined"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator!=="undefined"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}function formatArgs(args){args[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+args[0]+(this.useColors?"%c ":" ")+"+"+module.exports.humanize(this.diff);if(!this.useColors){return}const c="color: "+this.color;args.splice(1,0,c,"color: inherit");let index=0;let lastC=0;args[0].replace(/%[a-zA-Z%]/g,(match=>{if(match==="%%"){return}index++;if(match==="%c"){lastC=index}}));args.splice(lastC,0,c)}exports.log=console.debug||console.log||(()=>{});function save(namespaces){try{if(namespaces){exports.storage.setItem("debug",namespaces)}else{exports.storage.removeItem("debug")}}catch(error){}}function load(){let r;try{r=exports.storage.getItem("debug")}catch(error){}if(!r&&typeof process!=="undefined"&&"env"in process){r=process.env.DEBUG}return r}function localstorage(){try{return localStorage}catch(error){}}module.exports=__webpack_require__(12)(exports);const{formatters}=module.exports;formatters.j=function(v){try{return JSON.stringify(v)}catch(error){return"[UnexpectedJSONParseError]: "+error.message}}},(module,__unused_webpack_exports,__webpack_require__)=>{function setup(env){createDebug.debug=createDebug;createDebug.default=createDebug;createDebug.coerce=coerce;createDebug.disable=disable;createDebug.enable=enable;createDebug.enabled=enabled;createDebug.humanize=__webpack_require__(13);Object.keys(env).forEach((key=>{createDebug[key]=env[key]}));createDebug.instances=[];createDebug.names=[];createDebug.skips=[];createDebug.formatters={};function selectColor(namespace){let hash=0;for(let i=0;i<namespace.length;i++){hash=(hash<<5)-hash+namespace.charCodeAt(i);hash|=0}return createDebug.colors[Math.abs(hash)%createDebug.colors.length]}createDebug.selectColor=selectColor;function createDebug(namespace){let prevTime;function debug(...args){if(!debug.enabled){return}const self=debug;const curr=Number(new Date);const ms=curr-(prevTime||curr);self.diff=ms;self.prev=prevTime;self.curr=curr;prevTime=curr;args[0]=createDebug.coerce(args[0]);if(typeof args[0]!=="string"){args.unshift("%O")}let index=0;args[0]=args[0].replace(/%([a-zA-Z%])/g,((match,format)=>{if(match==="%%"){return match}index++;const formatter=createDebug.formatters[format];if(typeof formatter==="function"){const val=args[index];match=formatter.call(self,val);args.splice(index,1);index--}return match}));createDebug.formatArgs.call(self,args);const logFn=self.log||createDebug.log;logFn.apply(self,args)}debug.namespace=namespace;debug.enabled=createDebug.enabled(namespace);debug.useColors=createDebug.useColors();debug.color=createDebug.selectColor(namespace);debug.destroy=destroy;debug.extend=extend;if(typeof createDebug.init==="function"){createDebug.init(debug)}createDebug.instances.push(debug);return debug}function destroy(){const index=createDebug.instances.indexOf(this);if(index!==-1){createDebug.instances.splice(index,1);return true}return false}function extend(namespace,delimiter){const newDebug=createDebug(this.namespace+(typeof delimiter==="undefined"?":":delimiter)+namespace);newDebug.log=this.log;return newDebug}function enable(namespaces){createDebug.save(namespaces);createDebug.names=[];createDebug.skips=[];let i;const split=(typeof namespaces==="string"?namespaces:"").split(/[\s,]+/);const len=split.length;for(i=0;i<len;i++){if(!split[i]){continue}namespaces=split[i].replace(/\*/g,".*?");if(namespaces[0]==="-"){createDebug.skips.push(new RegExp("^"+namespaces.substr(1)+"$"))}else{createDebug.names.push(new RegExp("^"+namespaces+"$"))}}for(i=0;i<createDebug.instances.length;i++){const instance=createDebug.instances[i];instance.enabled=createDebug.enabled(instance.namespace)}}function disable(){const namespaces=[...createDebug.names.map(toNamespace),...createDebug.skips.map(toNamespace).map((namespace=>"-"+namespace))].join(",");createDebug.enable("");return namespaces}function enabled(name){if(name[name.length-1]==="*"){return true}let i;let len;for(i=0,len=createDebug.skips.length;i<len;i++){if(createDebug.skips[i].test(name)){return false}}for(i=0,len=createDebug.names.length;i<len;i++){if(createDebug.names[i].test(name)){return true}}return false}function toNamespace(regexp){return regexp.toString().substring(2,regexp.toString().length-2).replace(/\.\*\?$/,"*")}function coerce(val){if(val instanceof Error){return val.stack||val.message}return val}createDebug.enable(createDebug.load());return createDebug}module.exports=setup},module=>{var s=1e3;var m=s*60;var h=m*60;var d=h*24;var w=d*7;var y=d*365.25;module.exports=function(val,options){options=options||{};var type=typeof val;if(type==="string"&&val.length>0){return parse(val)}else if(type==="number"&&isFinite(val)){return options.long?fmtLong(val):fmtShort(val)}throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(val))};function parse(str){str=String(str);if(str.length>100){return}var match=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(str);if(!match){return}var n=parseFloat(match[1]);var type=(match[2]||"ms").toLowerCase();switch(type){case"years":case"year":case"yrs":case"yr":case"y":return n*y;case"weeks":case"week":case"w":return n*w;case"days":case"day":case"d":return n*d;case"hours":case"hour":case"hrs":case"hr":case"h":return n*h;case"minutes":case"minute":case"mins":case"min":case"m":return n*m;case"seconds":case"second":case"secs":case"sec":case"s":return n*s;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:return undefined}}function fmtShort(ms){var msAbs=Math.abs(ms);if(msAbs>=d){return Math.round(ms/d)+"d"}if(msAbs>=h){return Math.round(ms/h)+"h"}if(msAbs>=m){return Math.round(ms/m)+"m"}if(msAbs>=s){return Math.round(ms/s)+"s"}return ms+"ms"}function fmtLong(ms){var msAbs=Math.abs(ms);if(msAbs>=d){return plural(ms,msAbs,d,"day")}if(msAbs>=h){return plural(ms,msAbs,h,"hour")}if(msAbs>=m){return plural(ms,msAbs,m,"minute")}if(msAbs>=s){return plural(ms,msAbs,s,"second")}return ms+" ms"}function plural(ms,msAbs,n,name){var isPlural=msAbs>=n*1.5;return Math.round(ms/n)+" "+name+(isPlural?"s":"")}},(module,exports,__webpack_require__)=>{const tty=__webpack_require__(15);const util=__webpack_require__(16);exports.init=init;exports.log=log;exports.formatArgs=formatArgs;exports.save=save;exports.load=load;exports.useColors=useColors;exports.colors=[6,2,3,4,5,1];try{const supportsColor=__webpack_require__(17);if(supportsColor&&(supportsColor.stderr||supportsColor).level>=2){exports.colors=[20,21,26,27,32,33,38,39,40,41,42,43,44,45,56,57,62,63,68,69,74,75,76,77,78,79,80,81,92,93,98,99,112,113,128,129,134,135,148,149,160,161,162,163,164,165,166,167,168,169,170,171,172,173,178,179,184,185,196,197,198,199,200,201,202,203,204,205,206,207,208,209,214,215,220,221]}}catch(error){}exports.inspectOpts=Object.keys(process.env).filter((key=>/^debug_/i.test(key))).reduce(((obj,key)=>{const prop=key.substring(6).toLowerCase().replace(/_([a-z])/g,((_,k)=>k.toUpperCase()));let val=process.env[key];if(/^(yes|on|true|enabled)$/i.test(val)){val=true}else if(/^(no|off|false|disabled)$/i.test(val)){val=false}else if(val==="null"){val=null}else{val=Number(val)}obj[prop]=val;return obj}),{});function useColors(){return"colors"in exports.inspectOpts?Boolean(exports.inspectOpts.colors):tty.isatty(process.stderr.fd)}function formatArgs(args){const{namespace:name,useColors}=this;if(useColors){const c=this.color;const colorCode="[3"+(c<8?c:"8;5;"+c);const prefix=`  ${colorCode};1m${name} [0m`;args[0]=prefix+args[0].split("\n").join("\n"+prefix);args.push(colorCode+"m+"+module.exports.humanize(this.diff)+"[0m")}else{args[0]=getDate()+name+" "+args[0]}}function getDate(){if(exports.inspectOpts.hideDate){return""}return(new Date).toISOString()+" "}function log(...args){return process.stderr.write(util.format(...args)+"\n")}function save(namespaces){if(namespaces){process.env.DEBUG=namespaces}else{delete process.env.DEBUG}}function load(){return process.env.DEBUG}function init(debug){debug.inspectOpts={};const keys=Object.keys(exports.inspectOpts);for(let i=0;i<keys.length;i++){debug.inspectOpts[keys[i]]=exports.inspectOpts[keys[i]]}}module.exports=__webpack_require__(12)(exports);const{formatters}=module.exports;formatters.o=function(v){this.inspectOpts.colors=this.useColors;return util.inspect(v,this.inspectOpts).replace(/\s*\n\s*/g," ")};formatters.O=function(v){this.inspectOpts.colors=this.useColors;return util.inspect(v,this.inspectOpts)}},module=>{"use strict";module.exports=require("tty")},module=>{"use strict";module.exports=require("util")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const os=__webpack_require__(18);const hasFlag=__webpack_require__(19);const env=process.env;let forceColor;if(hasFlag("no-color")||hasFlag("no-colors")||hasFlag("color=false")){forceColor=false}else if(hasFlag("color")||hasFlag("colors")||hasFlag("color=true")||hasFlag("color=always")){forceColor=true}if("FORCE_COLOR"in env){forceColor=env.FORCE_COLOR.length===0||parseInt(env.FORCE_COLOR,10)!==0}function translateLevel(level){if(level===0){return false}return{level,hasBasic:true,has256:level>=2,has16m:level>=3}}function supportsColor(stream){if(forceColor===false){return 0}if(hasFlag("color=16m")||hasFlag("color=full")||hasFlag("color=truecolor")){return 3}if(hasFlag("color=256")){return 2}if(stream&&!stream.isTTY&&forceColor!==true){return 0}const min=forceColor?1:0;if(process.platform==="win32"){const osRelease=os.release().split(".");if(Number(process.versions.node.split(".")[0])>=8&&Number(osRelease[0])>=10&&Number(osRelease[2])>=10586){return Number(osRelease[2])>=14931?3:2}return 1}if("CI"in env){if(["TRAVIS","CIRCLECI","APPVEYOR","GITLAB_CI"].some((sign=>sign in env))||env.CI_NAME==="codeship"){return 1}return min}if("TEAMCITY_VERSION"in env){return/^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION)?1:0}if(env.COLORTERM==="truecolor"){return 3}if("TERM_PROGRAM"in env){const version=parseInt((env.TERM_PROGRAM_VERSION||"").split(".")[0],10);switch(env.TERM_PROGRAM){case"iTerm.app":return version>=3?3:2;case"Apple_Terminal":return 2}}if(/-256(color)?$/i.test(env.TERM)){return 2}if(/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)){return 1}if("COLORTERM"in env){return 1}if(env.TERM==="dumb"){return min}return min}function getSupportLevel(stream){const level=supportsColor(stream);return translateLevel(level)}module.exports={supportsColor:getSupportLevel,stdout:getSupportLevel(process.stdout),stderr:getSupportLevel(process.stderr)}},module=>{"use strict";module.exports=require("os")},module=>{"use strict";module.exports=(flag,argv)=>{argv=argv||process.argv;const prefix=flag.startsWith("-")?"":flag.length===1?"-":"--";const pos=argv.indexOf(prefix+flag);const terminatorPos=argv.indexOf("--");return pos!==-1&&(terminatorPos===-1?true:pos<terminatorPos)}},module=>{"use strict";module.exports=require("fs")},module=>{"use strict";module.exports=require("stream")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ProgressCallbackTransform=void 0;function _stream(){const data=__webpack_require__(21);_stream=function(){return data};return data}class ProgressCallbackTransform extends _stream().Transform{constructor(total,cancellationToken,onProgress){super();this.total=total;this.cancellationToken=cancellationToken;this.onProgress=onProgress;this.start=Date.now();this.transferred=0;this.delta=0;this.nextUpdate=this.start+1e3}_transform(chunk,encoding,callback){if(this.cancellationToken.cancelled){callback(new Error("cancelled"),null);return}this.transferred+=chunk.length;this.delta+=chunk.length;const now=Date.now();if(now>=this.nextUpdate&&this.transferred!==this.total){this.nextUpdate=now+1e3;this.onProgress({total:this.total,delta:this.delta,transferred:this.transferred,percent:this.transferred/this.total*100,bytesPerSecond:Math.round(this.transferred/((now-this.start)/1e3))});this.delta=0}callback(null,chunk)}_flush(callback){if(this.cancellationToken.cancelled){callback(new Error("cancelled"));return}this.onProgress({total:this.total,delta:this.delta,transferred:this.total,percent:100,bytesPerSecond:Math.round(this.transferred/((Date.now()-this.start)/1e3))});this.delta=0;callback(null)}}exports.ProgressCallbackTransform=ProgressCallbackTransform},(__unused_webpack_module,exports)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.githubUrl=githubUrl;exports.getS3LikeProviderBaseUrl=getS3LikeProviderBaseUrl;function githubUrl(options,defaultHost="github.com"){return`${options.protocol||"https"}://${options.host||defaultHost}`}function getS3LikeProviderBaseUrl(configuration){const provider=configuration.provider;if(provider==="s3"){return s3Url(configuration)}if(provider==="spaces"){return spacesUrl(configuration)}throw new Error(`Not supported provider: ${provider}`)}function s3Url(options){let url;if(options.endpoint!=null){url=`${options.endpoint}/${options.bucket}`}else if(options.bucket.includes(".")){if(options.region==null){throw new Error(`Bucket name "${options.bucket}" includes a dot, but S3 region is missing`)}if(options.region==="us-east-1"){url=`https://s3.amazonaws.com/${options.bucket}`}else{url=`https://s3-${options.region}.amazonaws.com/${options.bucket}`}}else if(options.region==="cn-north-1"){url=`https://${options.bucket}.s3.${options.region}.amazonaws.com.cn`}else{url=`https://${options.bucket}.s3.amazonaws.com`}return appendPath(url,options.path)}function appendPath(url,p){if(p!=null&&p.length>0){if(!p.startsWith("/")){url+="/"}url+=p}return url}function spacesUrl(options){if(options.name==null){throw new Error(`name is missing`)}if(options.region==null){throw new Error(`region is missing`)}return appendPath(`https://${options.name}.${options.region}.digitaloceanspaces.com`,options.path)}},(__unused_webpack_module,exports)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.parseDn=parseDn;function parseDn(seq){let quoted=false;let key=null;let token="";let nextNonSpace=0;seq=seq.trim();const result=new Map;for(let i=0;i<=seq.length;i++){if(i===seq.length){if(key!==null){result.set(key,token)}break}const ch=seq[i];if(quoted){if(ch==='"'){quoted=false;continue}}else{if(ch==='"'){quoted=true;continue}if(ch==="\\"){i++;const ord=parseInt(seq.slice(i,i+2),16);if(Number.isNaN(ord)){token+=seq[i]}else{i++;token+=String.fromCharCode(ord)}continue}if(key===null&&ch==="="){key=token;token="";continue}if(ch===","||ch===";"||ch==="+"){if(key!==null){result.set(key,token)}key=null;token="";continue}}if(ch===" "&&!quoted){if(token.length===0){continue}if(i>nextNonSpace){let j=i;while(seq[j]===" "){j++}nextNonSpace=j}if(nextNonSpace>=seq.length||seq[nextNonSpace]===","||seq[nextNonSpace]===";"||key===null&&seq[nextNonSpace]==="="||key!==null&&seq[nextNonSpace]==="+"){i=nextNonSpace-1;continue}}token+=ch}return result}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.nil=exports.UUID=void 0;function _crypto(){const data=__webpack_require__(9);_crypto=function(){return data};return data}function _index(){const data=__webpack_require__(5);_index=function(){return data};return data}const invalidName="options.name must be either a string or a Buffer";const randomHost=(0,_crypto().randomBytes)(16);randomHost[0]=randomHost[0]|1;const hex2byte={};const byte2hex=[];for(let i=0;i<256;i++){const hex=(i+256).toString(16).substr(1);hex2byte[hex]=i;byte2hex[i]=hex}class UUID{constructor(uuid){this.ascii=null;this.binary=null;const check=UUID.check(uuid);if(!check){throw new Error("not a UUID")}this.version=check.version;if(check.format==="ascii"){this.ascii=uuid}else{this.binary=uuid}}static v5(name,namespace){return uuidNamed(name,"sha1",80,namespace)}toString(){if(this.ascii==null){this.ascii=stringify(this.binary)}return this.ascii}inspect(){return`UUID v${this.version} ${this.toString()}`}static check(uuid,offset=0){if(typeof uuid==="string"){uuid=uuid.toLowerCase();if(!/^[a-f0-9]{8}(-[a-f0-9]{4}){3}-([a-f0-9]{12})$/.test(uuid)){return false}if(uuid==="00000000-0000-0000-0000-000000000000"){return{version:undefined,variant:"nil",format:"ascii"}}return{version:(hex2byte[uuid[14]+uuid[15]]&240)>>4,variant:getVariant((hex2byte[uuid[19]+uuid[20]]&224)>>5),format:"ascii"}}if(Buffer.isBuffer(uuid)){if(uuid.length<offset+16){return false}let i=0;for(;i<16;i++){if(uuid[offset+i]!==0){break}}if(i===16){return{version:undefined,variant:"nil",format:"binary"}}return{version:(uuid[offset+6]&240)>>4,variant:getVariant((uuid[offset+8]&224)>>5),format:"binary"}}throw(0,_index().newError)("Unknown type of uuid","ERR_UNKNOWN_UUID_TYPE")}static parse(input){const buffer=Buffer.allocUnsafe(16);let j=0;for(let i=0;i<16;i++){buffer[i]=hex2byte[input[j++]+input[j++]];if(i===3||i===5||i===7||i===9){j+=1}}return buffer}}exports.UUID=UUID;UUID.OID=UUID.parse("6ba7b812-9dad-11d1-80b4-00c04fd430c8");function getVariant(bits){switch(bits){case 0:case 1:case 3:return"ncs";case 4:case 5:return"rfc4122";case 6:return"microsoft";default:return"future"}}var UuidEncoding;(function(UuidEncoding){UuidEncoding[UuidEncoding["ASCII"]=0]="ASCII";UuidEncoding[UuidEncoding["BINARY"]=1]="BINARY";UuidEncoding[UuidEncoding["OBJECT"]=2]="OBJECT"})(UuidEncoding||(UuidEncoding={}));function uuidNamed(name,hashMethod,version,namespace,encoding=UuidEncoding.ASCII){const hash=(0,_crypto().createHash)(hashMethod);const nameIsNotAString=typeof name!=="string";if(nameIsNotAString&&!Buffer.isBuffer(name)){throw(0,_index().newError)(invalidName,"ERR_INVALID_UUID_NAME")}hash.update(namespace);hash.update(name);const buffer=hash.digest();let result;switch(encoding){case UuidEncoding.BINARY:buffer[6]=buffer[6]&15|version;buffer[8]=buffer[8]&63|128;result=buffer;break;case UuidEncoding.OBJECT:buffer[6]=buffer[6]&15|version;buffer[8]=buffer[8]&63|128;result=new UUID(buffer);break;default:result=byte2hex[buffer[0]]+byte2hex[buffer[1]]+byte2hex[buffer[2]]+byte2hex[buffer[3]]+"-"+byte2hex[buffer[4]]+byte2hex[buffer[5]]+"-"+byte2hex[buffer[6]&15|version]+byte2hex[buffer[7]]+"-"+byte2hex[buffer[8]&63|128]+byte2hex[buffer[9]]+"-"+byte2hex[buffer[10]]+byte2hex[buffer[11]]+byte2hex[buffer[12]]+byte2hex[buffer[13]]+byte2hex[buffer[14]]+byte2hex[buffer[15]];break}return result}function stringify(buffer){return byte2hex[buffer[0]]+byte2hex[buffer[1]]+byte2hex[buffer[2]]+byte2hex[buffer[3]]+"-"+byte2hex[buffer[4]]+byte2hex[buffer[5]]+"-"+byte2hex[buffer[6]]+byte2hex[buffer[7]]+"-"+byte2hex[buffer[8]]+byte2hex[buffer[9]]+"-"+byte2hex[buffer[10]]+byte2hex[buffer[11]]+byte2hex[buffer[12]]+byte2hex[buffer[13]]+byte2hex[buffer[14]]+byte2hex[buffer[15]]}const nil=new UUID("00000000-0000-0000-0000-000000000000");exports.nil=nil},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.parseXml=parseXml;exports.XElement=void 0;function sax(){const data=_interopRequireWildcard(__webpack_require__(27));sax=function(){return data};return data}function _index(){const data=__webpack_require__(5);_index=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class XElement{constructor(name){this.name=name;this.value="";this.attributes=null;this.isCData=false;this.elements=null;if(!name){throw(0,_index().newError)("Element name cannot be empty","ERR_XML_ELEMENT_NAME_EMPTY")}if(!isValidName(name)){throw(0,_index().newError)(`Invalid element name: ${name}`,"ERR_XML_ELEMENT_INVALID_NAME")}}attribute(name){const result=this.attributes===null?null:this.attributes[name];if(result==null){throw(0,_index().newError)(`No attribute "${name}"`,"ERR_XML_MISSED_ATTRIBUTE")}return result}removeAttribute(name){if(this.attributes!==null){delete this.attributes[name]}}element(name,ignoreCase=false,errorIfMissed=null){const result=this.elementOrNull(name,ignoreCase);if(result===null){throw(0,_index().newError)(errorIfMissed||`No element "${name}"`,"ERR_XML_MISSED_ELEMENT")}return result}elementOrNull(name,ignoreCase=false){if(this.elements===null){return null}for(const element of this.elements){if(isNameEquals(element,name,ignoreCase)){return element}}return null}getElements(name,ignoreCase=false){if(this.elements===null){return[]}return this.elements.filter((it=>isNameEquals(it,name,ignoreCase)))}elementValueOrEmpty(name,ignoreCase=false){const element=this.elementOrNull(name,ignoreCase);return element===null?"":element.value}}exports.XElement=XElement;const NAME_REG_EXP=new RegExp(/^[A-Za-z_][:A-Za-z0-9_-]*$/i);function isValidName(name){return NAME_REG_EXP.test(name)}function isNameEquals(element,name,ignoreCase){const elementName=element.name;return elementName===name||ignoreCase===true&&elementName.length===name.length&&elementName.toLowerCase()===name.toLowerCase()}function parseXml(data){let rootElement=null;const parser=sax().parser(true,{});const elements=[];parser.onopentag=saxElement=>{const element=new XElement(saxElement.name);element.attributes=saxElement.attributes;if(rootElement===null){rootElement=element}else{const parent=elements[elements.length-1];if(parent.elements==null){parent.elements=[]}parent.elements.push(element)}elements.push(element)};parser.onclosetag=()=>{elements.pop()};parser.ontext=text=>{if(elements.length>0){elements[elements.length-1].value=text}};parser.oncdata=cdata=>{const element=elements[elements.length-1];element.value=cdata;element.isCData=true};parser.onerror=err=>{throw err};parser.write(data);return rootElement}},(__unused_webpack_module,exports,__webpack_require__)=>{(function(sax){sax.parser=function(strict,opt){return new SAXParser(strict,opt)};sax.SAXParser=SAXParser;sax.SAXStream=SAXStream;sax.createStream=createStream;sax.MAX_BUFFER_LENGTH=64*1024;var buffers=["comment","sgmlDecl","textNode","tagName","doctype","procInstName","procInstBody","entity","attribName","attribValue","cdata","script"];sax.EVENTS=["text","processinginstruction","sgmldeclaration","doctype","comment","opentagstart","attribute","opentag","closetag","opencdata","cdata","closecdata","error","end","ready","script","opennamespace","closenamespace"];function SAXParser(strict,opt){if(!(this instanceof SAXParser)){return new SAXParser(strict,opt)}var parser=this;clearBuffers(parser);parser.q=parser.c="";parser.bufferCheckPosition=sax.MAX_BUFFER_LENGTH;parser.opt=opt||{};parser.opt.lowercase=parser.opt.lowercase||parser.opt.lowercasetags;parser.looseCase=parser.opt.lowercase?"toLowerCase":"toUpperCase";parser.tags=[];parser.closed=parser.closedRoot=parser.sawRoot=false;parser.tag=parser.error=null;parser.strict=!!strict;parser.noscript=!!(strict||parser.opt.noscript);parser.state=S.BEGIN;parser.strictEntities=parser.opt.strictEntities;parser.ENTITIES=parser.strictEntities?Object.create(sax.XML_ENTITIES):Object.create(sax.ENTITIES);parser.attribList=[];if(parser.opt.xmlns){parser.ns=Object.create(rootNS)}parser.trackPosition=parser.opt.position!==false;if(parser.trackPosition){parser.position=parser.line=parser.column=0}emit(parser,"onready")}if(!Object.create){Object.create=function(o){function F(){}F.prototype=o;var newf=new F;return newf}}if(!Object.keys){Object.keys=function(o){var a=[];for(var i in o)if(o.hasOwnProperty(i))a.push(i);return a}}function checkBufferLength(parser){var maxAllowed=Math.max(sax.MAX_BUFFER_LENGTH,10);var maxActual=0;for(var i=0,l=buffers.length;i<l;i++){var len=parser[buffers[i]].length;if(len>maxAllowed){switch(buffers[i]){case"textNode":closeText(parser);break;case"cdata":emitNode(parser,"oncdata",parser.cdata);parser.cdata="";break;case"script":emitNode(parser,"onscript",parser.script);parser.script="";break;default:error(parser,"Max buffer length exceeded: "+buffers[i])}}maxActual=Math.max(maxActual,len)}var m=sax.MAX_BUFFER_LENGTH-maxActual;parser.bufferCheckPosition=m+parser.position}function clearBuffers(parser){for(var i=0,l=buffers.length;i<l;i++){parser[buffers[i]]=""}}function flushBuffers(parser){closeText(parser);if(parser.cdata!==""){emitNode(parser,"oncdata",parser.cdata);parser.cdata=""}if(parser.script!==""){emitNode(parser,"onscript",parser.script);parser.script=""}}SAXParser.prototype={end:function(){end(this)},write,resume:function(){this.error=null;return this},close:function(){return this.write(null)},flush:function(){flushBuffers(this)}};var Stream;try{Stream=__webpack_require__(21).Stream}catch(ex){Stream=function(){}}var streamWraps=sax.EVENTS.filter((function(ev){return ev!=="error"&&ev!=="end"}));function createStream(strict,opt){return new SAXStream(strict,opt)}function SAXStream(strict,opt){if(!(this instanceof SAXStream)){return new SAXStream(strict,opt)}Stream.apply(this);this._parser=new SAXParser(strict,opt);this.writable=true;this.readable=true;var me=this;this._parser.onend=function(){me.emit("end")};this._parser.onerror=function(er){me.emit("error",er);me._parser.error=null};this._decoder=null;streamWraps.forEach((function(ev){Object.defineProperty(me,"on"+ev,{get:function(){return me._parser["on"+ev]},set:function(h){if(!h){me.removeAllListeners(ev);me._parser["on"+ev]=h;return h}me.on(ev,h)},enumerable:true,configurable:false})}))}SAXStream.prototype=Object.create(Stream.prototype,{constructor:{value:SAXStream}});SAXStream.prototype.write=function(data){if(typeof Buffer==="function"&&typeof Buffer.isBuffer==="function"&&Buffer.isBuffer(data)){if(!this._decoder){var SD=__webpack_require__(28).StringDecoder;this._decoder=new SD("utf8")}data=this._decoder.write(data)}this._parser.write(data.toString());this.emit("data",data);return true};SAXStream.prototype.end=function(chunk){if(chunk&&chunk.length){this.write(chunk)}this._parser.end();return true};SAXStream.prototype.on=function(ev,handler){var me=this;if(!me._parser["on"+ev]&&streamWraps.indexOf(ev)!==-1){me._parser["on"+ev]=function(){var args=arguments.length===1?[arguments[0]]:Array.apply(null,arguments);args.splice(0,0,ev);me.emit.apply(me,args)}}return Stream.prototype.on.call(me,ev,handler)};var CDATA="[CDATA[";var DOCTYPE="DOCTYPE";var XML_NAMESPACE="http://www.w3.org/XML/1998/namespace";var XMLNS_NAMESPACE="http://www.w3.org/2000/xmlns/";var rootNS={xml:XML_NAMESPACE,xmlns:XMLNS_NAMESPACE};var nameStart=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;var nameBody=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;var entityStart=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;var entityBody=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;function isWhitespace(c){return c===" "||c==="\n"||c==="\r"||c==="\t"}function isQuote(c){return c==='"'||c==="'"}function isAttribEnd(c){return c===">"||isWhitespace(c)}function isMatch(regex,c){return regex.test(c)}function notMatch(regex,c){return!isMatch(regex,c)}var S=0;sax.STATE={BEGIN:S++,BEGIN_WHITESPACE:S++,TEXT:S++,TEXT_ENTITY:S++,OPEN_WAKA:S++,SGML_DECL:S++,SGML_DECL_QUOTED:S++,DOCTYPE:S++,DOCTYPE_QUOTED:S++,DOCTYPE_DTD:S++,DOCTYPE_DTD_QUOTED:S++,COMMENT_STARTING:S++,COMMENT:S++,COMMENT_ENDING:S++,COMMENT_ENDED:S++,CDATA:S++,CDATA_ENDING:S++,CDATA_ENDING_2:S++,PROC_INST:S++,PROC_INST_BODY:S++,PROC_INST_ENDING:S++,OPEN_TAG:S++,OPEN_TAG_SLASH:S++,ATTRIB:S++,ATTRIB_NAME:S++,ATTRIB_NAME_SAW_WHITE:S++,ATTRIB_VALUE:S++,ATTRIB_VALUE_QUOTED:S++,ATTRIB_VALUE_CLOSED:S++,ATTRIB_VALUE_UNQUOTED:S++,ATTRIB_VALUE_ENTITY_Q:S++,ATTRIB_VALUE_ENTITY_U:S++,CLOSE_TAG:S++,CLOSE_TAG_SAW_WHITE:S++,SCRIPT:S++,SCRIPT_ENDING:S++};sax.XML_ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'"};sax.ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'",AElig:198,Aacute:193,Acirc:194,Agrave:192,Aring:197,Atilde:195,Auml:196,Ccedil:199,ETH:208,Eacute:201,Ecirc:202,Egrave:200,Euml:203,Iacute:205,Icirc:206,Igrave:204,Iuml:207,Ntilde:209,Oacute:211,Ocirc:212,Ograve:210,Oslash:216,Otilde:213,Ouml:214,THORN:222,Uacute:218,Ucirc:219,Ugrave:217,Uuml:220,Yacute:221,aacute:225,acirc:226,aelig:230,agrave:224,aring:229,atilde:227,auml:228,ccedil:231,eacute:233,ecirc:234,egrave:232,eth:240,euml:235,iacute:237,icirc:238,igrave:236,iuml:239,ntilde:241,oacute:243,ocirc:244,ograve:242,oslash:248,otilde:245,ouml:246,szlig:223,thorn:254,uacute:250,ucirc:251,ugrave:249,uuml:252,yacute:253,yuml:255,copy:169,reg:174,nbsp:160,iexcl:161,cent:162,pound:163,curren:164,yen:165,brvbar:166,sect:167,uml:168,ordf:170,laquo:171,not:172,shy:173,macr:175,deg:176,plusmn:177,sup1:185,sup2:178,sup3:179,acute:180,micro:181,para:182,middot:183,cedil:184,ordm:186,raquo:187,frac14:188,frac12:189,frac34:190,iquest:191,times:215,divide:247,OElig:338,oelig:339,Scaron:352,scaron:353,Yuml:376,fnof:402,circ:710,tilde:732,Alpha:913,Beta:914,Gamma:915,Delta:916,Epsilon:917,Zeta:918,Eta:919,Theta:920,Iota:921,Kappa:922,Lambda:923,Mu:924,Nu:925,Xi:926,Omicron:927,Pi:928,Rho:929,Sigma:931,Tau:932,Upsilon:933,Phi:934,Chi:935,Psi:936,Omega:937,alpha:945,beta:946,gamma:947,delta:948,epsilon:949,zeta:950,eta:951,theta:952,iota:953,kappa:954,lambda:955,mu:956,nu:957,xi:958,omicron:959,pi:960,rho:961,sigmaf:962,sigma:963,tau:964,upsilon:965,phi:966,chi:967,psi:968,omega:969,thetasym:977,upsih:978,piv:982,ensp:8194,emsp:8195,thinsp:8201,zwnj:8204,zwj:8205,lrm:8206,rlm:8207,ndash:8211,mdash:8212,lsquo:8216,rsquo:8217,sbquo:8218,ldquo:8220,rdquo:8221,bdquo:8222,dagger:8224,Dagger:8225,bull:8226,hellip:8230,permil:8240,prime:8242,Prime:8243,lsaquo:8249,rsaquo:8250,oline:8254,frasl:8260,euro:8364,image:8465,weierp:8472,real:8476,trade:8482,alefsym:8501,larr:8592,uarr:8593,rarr:8594,darr:8595,harr:8596,crarr:8629,lArr:8656,uArr:8657,rArr:8658,dArr:8659,hArr:8660,forall:8704,part:8706,exist:8707,empty:8709,nabla:8711,isin:8712,notin:8713,ni:8715,prod:8719,sum:8721,minus:8722,lowast:8727,radic:8730,prop:8733,infin:8734,ang:8736,and:8743,or:8744,cap:8745,cup:8746,int:8747,there4:8756,sim:8764,cong:8773,asymp:8776,ne:8800,equiv:8801,le:8804,ge:8805,sub:8834,sup:8835,nsub:8836,sube:8838,supe:8839,oplus:8853,otimes:8855,perp:8869,sdot:8901,lceil:8968,rceil:8969,lfloor:8970,rfloor:8971,lang:9001,rang:9002,loz:9674,spades:9824,clubs:9827,hearts:9829,diams:9830};Object.keys(sax.ENTITIES).forEach((function(key){var e=sax.ENTITIES[key];var s=typeof e==="number"?String.fromCharCode(e):e;sax.ENTITIES[key]=s}));for(var s in sax.STATE){sax.STATE[sax.STATE[s]]=s}S=sax.STATE;function emit(parser,event,data){parser[event]&&parser[event](data)}function emitNode(parser,nodeType,data){if(parser.textNode)closeText(parser);emit(parser,nodeType,data)}function closeText(parser){parser.textNode=textopts(parser.opt,parser.textNode);if(parser.textNode)emit(parser,"ontext",parser.textNode);parser.textNode=""}function textopts(opt,text){if(opt.trim)text=text.trim();if(opt.normalize)text=text.replace(/\s+/g," ");return text}function error(parser,er){closeText(parser);if(parser.trackPosition){er+="\nLine: "+parser.line+"\nColumn: "+parser.column+"\nChar: "+parser.c}er=new Error(er);parser.error=er;emit(parser,"onerror",er);return parser}function end(parser){if(parser.sawRoot&&!parser.closedRoot)strictFail(parser,"Unclosed root tag");if(parser.state!==S.BEGIN&&parser.state!==S.BEGIN_WHITESPACE&&parser.state!==S.TEXT){error(parser,"Unexpected end")}closeText(parser);parser.c="";parser.closed=true;emit(parser,"onend");SAXParser.call(parser,parser.strict,parser.opt);return parser}function strictFail(parser,message){if(typeof parser!=="object"||!(parser instanceof SAXParser)){throw new Error("bad call to strictFail")}if(parser.strict){error(parser,message)}}function newTag(parser){if(!parser.strict)parser.tagName=parser.tagName[parser.looseCase]();var parent=parser.tags[parser.tags.length-1]||parser;var tag=parser.tag={name:parser.tagName,attributes:{}};if(parser.opt.xmlns){tag.ns=parent.ns}parser.attribList.length=0;emitNode(parser,"onopentagstart",tag)}function qname(name,attribute){var i=name.indexOf(":");var qualName=i<0?["",name]:name.split(":");var prefix=qualName[0];var local=qualName[1];if(attribute&&name==="xmlns"){prefix="xmlns";local=""}return{prefix,local}}function attrib(parser){if(!parser.strict){parser.attribName=parser.attribName[parser.looseCase]()}if(parser.attribList.indexOf(parser.attribName)!==-1||parser.tag.attributes.hasOwnProperty(parser.attribName)){parser.attribName=parser.attribValue="";return}if(parser.opt.xmlns){var qn=qname(parser.attribName,true);var prefix=qn.prefix;var local=qn.local;if(prefix==="xmlns"){if(local==="xml"&&parser.attribValue!==XML_NAMESPACE){strictFail(parser,"xml: prefix must be bound to "+XML_NAMESPACE+"\n"+"Actual: "+parser.attribValue)}else if(local==="xmlns"&&parser.attribValue!==XMLNS_NAMESPACE){strictFail(parser,"xmlns: prefix must be bound to "+XMLNS_NAMESPACE+"\n"+"Actual: "+parser.attribValue)}else{var tag=parser.tag;var parent=parser.tags[parser.tags.length-1]||parser;if(tag.ns===parent.ns){tag.ns=Object.create(parent.ns)}tag.ns[local]=parser.attribValue}}parser.attribList.push([parser.attribName,parser.attribValue])}else{parser.tag.attributes[parser.attribName]=parser.attribValue;emitNode(parser,"onattribute",{name:parser.attribName,value:parser.attribValue})}parser.attribName=parser.attribValue=""}function openTag(parser,selfClosing){if(parser.opt.xmlns){var tag=parser.tag;var qn=qname(parser.tagName);tag.prefix=qn.prefix;tag.local=qn.local;tag.uri=tag.ns[qn.prefix]||"";if(tag.prefix&&!tag.uri){strictFail(parser,"Unbound namespace prefix: "+JSON.stringify(parser.tagName));tag.uri=qn.prefix}var parent=parser.tags[parser.tags.length-1]||parser;if(tag.ns&&parent.ns!==tag.ns){Object.keys(tag.ns).forEach((function(p){emitNode(parser,"onopennamespace",{prefix:p,uri:tag.ns[p]})}))}for(var i=0,l=parser.attribList.length;i<l;i++){var nv=parser.attribList[i];var name=nv[0];var value=nv[1];var qualName=qname(name,true);var prefix=qualName.prefix;var local=qualName.local;var uri=prefix===""?"":tag.ns[prefix]||"";var a={name,value,prefix,local,uri};if(prefix&&prefix!=="xmlns"&&!uri){strictFail(parser,"Unbound namespace prefix: "+JSON.stringify(prefix));a.uri=prefix}parser.tag.attributes[name]=a;emitNode(parser,"onattribute",a)}parser.attribList.length=0}parser.tag.isSelfClosing=!!selfClosing;parser.sawRoot=true;parser.tags.push(parser.tag);emitNode(parser,"onopentag",parser.tag);if(!selfClosing){if(!parser.noscript&&parser.tagName.toLowerCase()==="script"){parser.state=S.SCRIPT}else{parser.state=S.TEXT}parser.tag=null;parser.tagName=""}parser.attribName=parser.attribValue="";parser.attribList.length=0}function closeTag(parser){if(!parser.tagName){strictFail(parser,"Weird empty close tag.");parser.textNode+="</>";parser.state=S.TEXT;return}if(parser.script){if(parser.tagName!=="script"){parser.script+="</"+parser.tagName+">";parser.tagName="";parser.state=S.SCRIPT;return}emitNode(parser,"onscript",parser.script);parser.script=""}var t=parser.tags.length;var tagName=parser.tagName;if(!parser.strict){tagName=tagName[parser.looseCase]()}var closeTo=tagName;while(t--){var close=parser.tags[t];if(close.name!==closeTo){strictFail(parser,"Unexpected close tag")}else{break}}if(t<0){strictFail(parser,"Unmatched closing tag: "+parser.tagName);parser.textNode+="</"+parser.tagName+">";parser.state=S.TEXT;return}parser.tagName=tagName;var s=parser.tags.length;while(s-- >t){var tag=parser.tag=parser.tags.pop();parser.tagName=parser.tag.name;emitNode(parser,"onclosetag",parser.tagName);var x={};for(var i in tag.ns){x[i]=tag.ns[i]}var parent=parser.tags[parser.tags.length-1]||parser;if(parser.opt.xmlns&&tag.ns!==parent.ns){Object.keys(tag.ns).forEach((function(p){var n=tag.ns[p];emitNode(parser,"onclosenamespace",{prefix:p,uri:n})}))}}if(t===0)parser.closedRoot=true;parser.tagName=parser.attribValue=parser.attribName="";parser.attribList.length=0;parser.state=S.TEXT}function parseEntity(parser){var entity=parser.entity;var entityLC=entity.toLowerCase();var num;var numStr="";if(parser.ENTITIES[entity]){return parser.ENTITIES[entity]}if(parser.ENTITIES[entityLC]){return parser.ENTITIES[entityLC]}entity=entityLC;if(entity.charAt(0)==="#"){if(entity.charAt(1)==="x"){entity=entity.slice(2);num=parseInt(entity,16);numStr=num.toString(16)}else{entity=entity.slice(1);num=parseInt(entity,10);numStr=num.toString(10)}}entity=entity.replace(/^0+/,"");if(isNaN(num)||numStr.toLowerCase()!==entity){strictFail(parser,"Invalid character entity");return"&"+parser.entity+";"}return String.fromCodePoint(num)}function beginWhiteSpace(parser,c){if(c==="<"){parser.state=S.OPEN_WAKA;parser.startTagPosition=parser.position}else if(!isWhitespace(c)){strictFail(parser,"Non-whitespace before first tag.");parser.textNode=c;parser.state=S.TEXT}}function charAt(chunk,i){var result="";if(i<chunk.length){result=chunk.charAt(i)}return result}function write(chunk){var parser=this;if(this.error){throw this.error}if(parser.closed){return error(parser,"Cannot write after close. Assign an onready handler.")}if(chunk===null){return end(parser)}if(typeof chunk==="object"){chunk=chunk.toString()}var i=0;var c="";while(true){c=charAt(chunk,i++);parser.c=c;if(!c){break}if(parser.trackPosition){parser.position++;if(c==="\n"){parser.line++;parser.column=0}else{parser.column++}}switch(parser.state){case S.BEGIN:parser.state=S.BEGIN_WHITESPACE;if(c==="\ufeff"){continue}beginWhiteSpace(parser,c);continue;case S.BEGIN_WHITESPACE:beginWhiteSpace(parser,c);continue;case S.TEXT:if(parser.sawRoot&&!parser.closedRoot){var starti=i-1;while(c&&c!=="<"&&c!=="&"){c=charAt(chunk,i++);if(c&&parser.trackPosition){parser.position++;if(c==="\n"){parser.line++;parser.column=0}else{parser.column++}}}parser.textNode+=chunk.substring(starti,i-1)}if(c==="<"&&!(parser.sawRoot&&parser.closedRoot&&!parser.strict)){parser.state=S.OPEN_WAKA;parser.startTagPosition=parser.position}else{if(!isWhitespace(c)&&(!parser.sawRoot||parser.closedRoot)){strictFail(parser,"Text data outside of root node.")}if(c==="&"){parser.state=S.TEXT_ENTITY}else{parser.textNode+=c}}continue;case S.SCRIPT:if(c==="<"){parser.state=S.SCRIPT_ENDING}else{parser.script+=c}continue;case S.SCRIPT_ENDING:if(c==="/"){parser.state=S.CLOSE_TAG}else{parser.script+="<"+c;parser.state=S.SCRIPT}continue;case S.OPEN_WAKA:if(c==="!"){parser.state=S.SGML_DECL;parser.sgmlDecl=""}else if(isWhitespace(c)){}else if(isMatch(nameStart,c)){parser.state=S.OPEN_TAG;parser.tagName=c}else if(c==="/"){parser.state=S.CLOSE_TAG;parser.tagName=""}else if(c==="?"){parser.state=S.PROC_INST;parser.procInstName=parser.procInstBody=""}else{strictFail(parser,"Unencoded <");if(parser.startTagPosition+1<parser.position){var pad=parser.position-parser.startTagPosition;c=new Array(pad).join(" ")+c}parser.textNode+="<"+c;parser.state=S.TEXT}continue;case S.SGML_DECL:if((parser.sgmlDecl+c).toUpperCase()===CDATA){emitNode(parser,"onopencdata");parser.state=S.CDATA;parser.sgmlDecl="";parser.cdata=""}else if(parser.sgmlDecl+c==="--"){parser.state=S.COMMENT;parser.comment="";parser.sgmlDecl=""}else if((parser.sgmlDecl+c).toUpperCase()===DOCTYPE){parser.state=S.DOCTYPE;if(parser.doctype||parser.sawRoot){strictFail(parser,"Inappropriately located doctype declaration")}parser.doctype="";parser.sgmlDecl=""}else if(c===">"){emitNode(parser,"onsgmldeclaration",parser.sgmlDecl);parser.sgmlDecl="";parser.state=S.TEXT}else if(isQuote(c)){parser.state=S.SGML_DECL_QUOTED;parser.sgmlDecl+=c}else{parser.sgmlDecl+=c}continue;case S.SGML_DECL_QUOTED:if(c===parser.q){parser.state=S.SGML_DECL;parser.q=""}parser.sgmlDecl+=c;continue;case S.DOCTYPE:if(c===">"){parser.state=S.TEXT;emitNode(parser,"ondoctype",parser.doctype);parser.doctype=true}else{parser.doctype+=c;if(c==="["){parser.state=S.DOCTYPE_DTD}else if(isQuote(c)){parser.state=S.DOCTYPE_QUOTED;parser.q=c}}continue;case S.DOCTYPE_QUOTED:parser.doctype+=c;if(c===parser.q){parser.q="";parser.state=S.DOCTYPE}continue;case S.DOCTYPE_DTD:parser.doctype+=c;if(c==="]"){parser.state=S.DOCTYPE}else if(isQuote(c)){parser.state=S.DOCTYPE_DTD_QUOTED;parser.q=c}continue;case S.DOCTYPE_DTD_QUOTED:parser.doctype+=c;if(c===parser.q){parser.state=S.DOCTYPE_DTD;parser.q=""}continue;case S.COMMENT:if(c==="-"){parser.state=S.COMMENT_ENDING}else{parser.comment+=c}continue;case S.COMMENT_ENDING:if(c==="-"){parser.state=S.COMMENT_ENDED;parser.comment=textopts(parser.opt,parser.comment);if(parser.comment){emitNode(parser,"oncomment",parser.comment)}parser.comment=""}else{parser.comment+="-"+c;parser.state=S.COMMENT}continue;case S.COMMENT_ENDED:if(c!==">"){strictFail(parser,"Malformed comment");parser.comment+="--"+c;parser.state=S.COMMENT}else{parser.state=S.TEXT}continue;case S.CDATA:if(c==="]"){parser.state=S.CDATA_ENDING}else{parser.cdata+=c}continue;case S.CDATA_ENDING:if(c==="]"){parser.state=S.CDATA_ENDING_2}else{parser.cdata+="]"+c;parser.state=S.CDATA}continue;case S.CDATA_ENDING_2:if(c===">"){if(parser.cdata){emitNode(parser,"oncdata",parser.cdata)}emitNode(parser,"onclosecdata");parser.cdata="";parser.state=S.TEXT}else if(c==="]"){parser.cdata+="]"}else{parser.cdata+="]]"+c;parser.state=S.CDATA}continue;case S.PROC_INST:if(c==="?"){parser.state=S.PROC_INST_ENDING}else if(isWhitespace(c)){parser.state=S.PROC_INST_BODY}else{parser.procInstName+=c}continue;case S.PROC_INST_BODY:if(!parser.procInstBody&&isWhitespace(c)){continue}else if(c==="?"){parser.state=S.PROC_INST_ENDING}else{parser.procInstBody+=c}continue;case S.PROC_INST_ENDING:if(c===">"){emitNode(parser,"onprocessinginstruction",{name:parser.procInstName,body:parser.procInstBody});parser.procInstName=parser.procInstBody="";parser.state=S.TEXT}else{parser.procInstBody+="?"+c;parser.state=S.PROC_INST_BODY}continue;case S.OPEN_TAG:if(isMatch(nameBody,c)){parser.tagName+=c}else{newTag(parser);if(c===">"){openTag(parser)}else if(c==="/"){parser.state=S.OPEN_TAG_SLASH}else{if(!isWhitespace(c)){strictFail(parser,"Invalid character in tag name")}parser.state=S.ATTRIB}}continue;case S.OPEN_TAG_SLASH:if(c===">"){openTag(parser,true);closeTag(parser)}else{strictFail(parser,"Forward-slash in opening tag not followed by >");parser.state=S.ATTRIB}continue;case S.ATTRIB:if(isWhitespace(c)){continue}else if(c===">"){openTag(parser)}else if(c==="/"){parser.state=S.OPEN_TAG_SLASH}else if(isMatch(nameStart,c)){parser.attribName=c;parser.attribValue="";parser.state=S.ATTRIB_NAME}else{strictFail(parser,"Invalid attribute name")}continue;case S.ATTRIB_NAME:if(c==="="){parser.state=S.ATTRIB_VALUE}else if(c===">"){strictFail(parser,"Attribute without value");parser.attribValue=parser.attribName;attrib(parser);openTag(parser)}else if(isWhitespace(c)){parser.state=S.ATTRIB_NAME_SAW_WHITE}else if(isMatch(nameBody,c)){parser.attribName+=c}else{strictFail(parser,"Invalid attribute name")}continue;case S.ATTRIB_NAME_SAW_WHITE:if(c==="="){parser.state=S.ATTRIB_VALUE}else if(isWhitespace(c)){continue}else{strictFail(parser,"Attribute without value");parser.tag.attributes[parser.attribName]="";parser.attribValue="";emitNode(parser,"onattribute",{name:parser.attribName,value:""});parser.attribName="";if(c===">"){openTag(parser)}else if(isMatch(nameStart,c)){parser.attribName=c;parser.state=S.ATTRIB_NAME}else{strictFail(parser,"Invalid attribute name");parser.state=S.ATTRIB}}continue;case S.ATTRIB_VALUE:if(isWhitespace(c)){continue}else if(isQuote(c)){parser.q=c;parser.state=S.ATTRIB_VALUE_QUOTED}else{strictFail(parser,"Unquoted attribute value");parser.state=S.ATTRIB_VALUE_UNQUOTED;parser.attribValue=c}continue;case S.ATTRIB_VALUE_QUOTED:if(c!==parser.q){if(c==="&"){parser.state=S.ATTRIB_VALUE_ENTITY_Q}else{parser.attribValue+=c}continue}attrib(parser);parser.q="";parser.state=S.ATTRIB_VALUE_CLOSED;continue;case S.ATTRIB_VALUE_CLOSED:if(isWhitespace(c)){parser.state=S.ATTRIB}else if(c===">"){openTag(parser)}else if(c==="/"){parser.state=S.OPEN_TAG_SLASH}else if(isMatch(nameStart,c)){strictFail(parser,"No whitespace between attributes");parser.attribName=c;parser.attribValue="";parser.state=S.ATTRIB_NAME}else{strictFail(parser,"Invalid attribute name")}continue;case S.ATTRIB_VALUE_UNQUOTED:if(!isAttribEnd(c)){if(c==="&"){parser.state=S.ATTRIB_VALUE_ENTITY_U}else{parser.attribValue+=c}continue}attrib(parser);if(c===">"){openTag(parser)}else{parser.state=S.ATTRIB}continue;case S.CLOSE_TAG:if(!parser.tagName){if(isWhitespace(c)){continue}else if(notMatch(nameStart,c)){if(parser.script){parser.script+="</"+c;parser.state=S.SCRIPT}else{strictFail(parser,"Invalid tagname in closing tag.")}}else{parser.tagName=c}}else if(c===">"){closeTag(parser)}else if(isMatch(nameBody,c)){parser.tagName+=c}else if(parser.script){parser.script+="</"+parser.tagName;parser.tagName="";parser.state=S.SCRIPT}else{if(!isWhitespace(c)){strictFail(parser,"Invalid tagname in closing tag")}parser.state=S.CLOSE_TAG_SAW_WHITE}continue;case S.CLOSE_TAG_SAW_WHITE:if(isWhitespace(c)){continue}if(c===">"){closeTag(parser)}else{strictFail(parser,"Invalid characters in closing tag")}continue;case S.TEXT_ENTITY:case S.ATTRIB_VALUE_ENTITY_Q:case S.ATTRIB_VALUE_ENTITY_U:var returnState;var buffer;switch(parser.state){case S.TEXT_ENTITY:returnState=S.TEXT;buffer="textNode";break;case S.ATTRIB_VALUE_ENTITY_Q:returnState=S.ATTRIB_VALUE_QUOTED;buffer="attribValue";break;case S.ATTRIB_VALUE_ENTITY_U:returnState=S.ATTRIB_VALUE_UNQUOTED;buffer="attribValue";break}if(c===";"){parser[buffer]+=parseEntity(parser);parser.entity="";parser.state=returnState}else if(isMatch(parser.entity.length?entityBody:entityStart,c)){parser.entity+=c}else{strictFail(parser,"Invalid character in entity name");parser[buffer]+="&"+parser.entity+c;parser.entity="";parser.state=returnState}continue;default:throw new Error(parser,"Unknown state: "+parser.state)}}if(parser.position>=parser.bufferCheckPosition){checkBufferLength(parser)}return parser}if(!String.fromCodePoint){(function(){var stringFromCharCode=String.fromCharCode;var floor=Math.floor;var fromCodePoint=function(){var MAX_SIZE=16384;var codeUnits=[];var highSurrogate;var lowSurrogate;var index=-1;var length=arguments.length;if(!length){return""}var result="";while(++index<length){var codePoint=Number(arguments[index]);if(!isFinite(codePoint)||codePoint<0||codePoint>1114111||floor(codePoint)!==codePoint){throw RangeError("Invalid code point: "+codePoint)}if(codePoint<=65535){codeUnits.push(codePoint)}else{codePoint-=65536;highSurrogate=(codePoint>>10)+55296;lowSurrogate=codePoint%1024+56320;codeUnits.push(highSurrogate,lowSurrogate)}if(index+1===length||codeUnits.length>MAX_SIZE){result+=stringFromCharCode.apply(null,codeUnits);codeUnits.length=0}}return result};if(Object.defineProperty){Object.defineProperty(String,"fromCodePoint",{value:fromCodePoint,configurable:true,writable:true})}else{String.fromCodePoint=fromCodePoint}})()}})(false?0:exports)},module=>{"use strict";module.exports=require("string_decoder")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";module.exports={...__webpack_require__(30),...__webpack_require__(38),...__webpack_require__(46),...__webpack_require__(49),...__webpack_require__(52),...__webpack_require__(58),...__webpack_require__(41),...__webpack_require__(65),...__webpack_require__(67),...__webpack_require__(63),...__webpack_require__(48),...__webpack_require__(50)};const fs=__webpack_require__(20);if(Object.getOwnPropertyDescriptor(fs,"promises")){Object.defineProperty(module.exports,"promises",{get(){return fs.promises}})}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const fs=__webpack_require__(32);const api=["access","appendFile","chmod","chown","close","copyFile","fchmod","fchown","fdatasync","fstat","fsync","ftruncate","futimes","lchmod","lchown","link","lstat","mkdir","mkdtemp","open","opendir","readdir","readFile","readlink","realpath","rename","rm","rmdir","stat","symlink","truncate","unlink","utimes","writeFile"].filter((key=>typeof fs[key]==="function"));Object.keys(fs).forEach((key=>{if(key==="promises"){return}exports[key]=fs[key]}));api.forEach((method=>{exports[method]=u(fs[method])}));exports.exists=function(filename,callback){if(typeof callback==="function"){return fs.exists(filename,callback)}return new Promise((resolve=>fs.exists(filename,resolve)))};exports.read=function(fd,buffer,offset,length,position,callback){if(typeof callback==="function"){return fs.read(fd,buffer,offset,length,position,callback)}return new Promise(((resolve,reject)=>{fs.read(fd,buffer,offset,length,position,((err,bytesRead,buffer)=>{if(err)return reject(err);resolve({bytesRead,buffer})}))}))};exports.write=function(fd,buffer,...args){if(typeof args[args.length-1]==="function"){return fs.write(fd,buffer,...args)}return new Promise(((resolve,reject)=>{fs.write(fd,buffer,...args,((err,bytesWritten,buffer)=>{if(err)return reject(err);resolve({bytesWritten,buffer})}))}))};if(typeof fs.writev==="function"){exports.writev=function(fd,buffers,...args){if(typeof args[args.length-1]==="function"){return fs.writev(fd,buffers,...args)}return new Promise(((resolve,reject)=>{fs.writev(fd,buffers,...args,((err,bytesWritten,buffers)=>{if(err)return reject(err);resolve({bytesWritten,buffers})}))}))}}if(typeof fs.realpath.native==="function"){exports.realpath.native=u(fs.realpath.native)}},(__unused_webpack_module,exports)=>{"use strict";exports.fromCallback=function(fn){return Object.defineProperty((function(...args){if(typeof args[args.length-1]==="function")fn.apply(this,args);else{return new Promise(((resolve,reject)=>{fn.call(this,...args,((err,res)=>err!=null?reject(err):resolve(res)))}))}}),"name",{value:fn.name})};exports.fromPromise=function(fn){return Object.defineProperty((function(...args){const cb=args[args.length-1];if(typeof cb!=="function")return fn.apply(this,args);else fn.apply(this,args.slice(0,-1)).then((r=>cb(null,r)),cb)}),"name",{value:fn.name})}},(module,__unused_webpack_exports,__webpack_require__)=>{var fs=__webpack_require__(20);var polyfills=__webpack_require__(33);var legacy=__webpack_require__(35);var clone=__webpack_require__(36);var util=__webpack_require__(16);var gracefulQueue;var previousSymbol;if(typeof Symbol==="function"&&typeof Symbol.for==="function"){gracefulQueue=Symbol.for("graceful-fs.queue");previousSymbol=Symbol.for("graceful-fs.previous")}else{gracefulQueue="___graceful-fs.queue";previousSymbol="___graceful-fs.previous"}function noop(){}function publishQueue(context,queue){Object.defineProperty(context,gracefulQueue,{get:function(){return queue}})}var debug=noop;if(util.debuglog)debug=util.debuglog("gfs4");else if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||""))debug=function(){var m=util.format.apply(util,arguments);m="GFS4: "+m.split(/\n/).join("\nGFS4: ");console.error(m)};if(!fs[gracefulQueue]){var queue=global[gracefulQueue]||[];publishQueue(fs,queue);fs.close=function(fs$close){function close(fd,cb){return fs$close.call(fs,fd,(function(err){if(!err){resetQueue()}if(typeof cb==="function")cb.apply(this,arguments)}))}Object.defineProperty(close,previousSymbol,{value:fs$close});return close}(fs.close);fs.closeSync=function(fs$closeSync){function closeSync(fd){fs$closeSync.apply(fs,arguments);resetQueue()}Object.defineProperty(closeSync,previousSymbol,{value:fs$closeSync});return closeSync}(fs.closeSync);if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||"")){process.on("exit",(function(){debug(fs[gracefulQueue]);__webpack_require__(37).equal(fs[gracefulQueue].length,0)}))}}if(!global[gracefulQueue]){publishQueue(global,fs[gracefulQueue])}module.exports=patch(clone(fs));if(process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH&&!fs.__patched){module.exports=patch(fs);fs.__patched=true}function patch(fs){polyfills(fs);fs.gracefulify=patch;fs.createReadStream=createReadStream;fs.createWriteStream=createWriteStream;var fs$readFile=fs.readFile;fs.readFile=readFile;function readFile(path,options,cb){if(typeof options==="function")cb=options,options=null;return go$readFile(path,options,cb);function go$readFile(path,options,cb,startTime){return fs$readFile(path,options,(function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readFile,[path,options,cb],err,startTime||Date.now(),Date.now()]);else{if(typeof cb==="function")cb.apply(this,arguments)}}))}}var fs$writeFile=fs.writeFile;fs.writeFile=writeFile;function writeFile(path,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$writeFile(path,data,options,cb);function go$writeFile(path,data,options,cb,startTime){return fs$writeFile(path,data,options,(function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$writeFile,[path,data,options,cb],err,startTime||Date.now(),Date.now()]);else{if(typeof cb==="function")cb.apply(this,arguments)}}))}}var fs$appendFile=fs.appendFile;if(fs$appendFile)fs.appendFile=appendFile;function appendFile(path,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$appendFile(path,data,options,cb);function go$appendFile(path,data,options,cb,startTime){return fs$appendFile(path,data,options,(function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$appendFile,[path,data,options,cb],err,startTime||Date.now(),Date.now()]);else{if(typeof cb==="function")cb.apply(this,arguments)}}))}}var fs$copyFile=fs.copyFile;if(fs$copyFile)fs.copyFile=copyFile;function copyFile(src,dest,flags,cb){if(typeof flags==="function"){cb=flags;flags=0}return go$copyFile(src,dest,flags,cb);function go$copyFile(src,dest,flags,cb,startTime){return fs$copyFile(src,dest,flags,(function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$copyFile,[src,dest,flags,cb],err,startTime||Date.now(),Date.now()]);else{if(typeof cb==="function")cb.apply(this,arguments)}}))}}var fs$readdir=fs.readdir;fs.readdir=readdir;function readdir(path,options,cb){if(typeof options==="function")cb=options,options=null;return go$readdir(path,options,cb);function go$readdir(path,options,cb,startTime){return fs$readdir(path,options,(function(err,files){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readdir,[path,options,cb],err,startTime||Date.now(),Date.now()]);else{if(files&&files.sort)files.sort();if(typeof cb==="function")cb.call(this,err,files)}}))}}if(process.version.substr(0,4)==="v0.8"){var legStreams=legacy(fs);ReadStream=legStreams.ReadStream;WriteStream=legStreams.WriteStream}var fs$ReadStream=fs.ReadStream;if(fs$ReadStream){ReadStream.prototype=Object.create(fs$ReadStream.prototype);ReadStream.prototype.open=ReadStream$open}var fs$WriteStream=fs.WriteStream;if(fs$WriteStream){WriteStream.prototype=Object.create(fs$WriteStream.prototype);WriteStream.prototype.open=WriteStream$open}Object.defineProperty(fs,"ReadStream",{get:function(){return ReadStream},set:function(val){ReadStream=val},enumerable:true,configurable:true});Object.defineProperty(fs,"WriteStream",{get:function(){return WriteStream},set:function(val){WriteStream=val},enumerable:true,configurable:true});var FileReadStream=ReadStream;Object.defineProperty(fs,"FileReadStream",{get:function(){return FileReadStream},set:function(val){FileReadStream=val},enumerable:true,configurable:true});var FileWriteStream=WriteStream;Object.defineProperty(fs,"FileWriteStream",{get:function(){return FileWriteStream},set:function(val){FileWriteStream=val},enumerable:true,configurable:true});function ReadStream(path,options){if(this instanceof ReadStream)return fs$ReadStream.apply(this,arguments),this;else return ReadStream.apply(Object.create(ReadStream.prototype),arguments)}function ReadStream$open(){var that=this;open(that.path,that.flags,that.mode,(function(err,fd){if(err){if(that.autoClose)that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd);that.read()}}))}function WriteStream(path,options){if(this instanceof WriteStream)return fs$WriteStream.apply(this,arguments),this;else return WriteStream.apply(Object.create(WriteStream.prototype),arguments)}function WriteStream$open(){var that=this;open(that.path,that.flags,that.mode,(function(err,fd){if(err){that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd)}}))}function createReadStream(path,options){return new fs.ReadStream(path,options)}function createWriteStream(path,options){return new fs.WriteStream(path,options)}var fs$open=fs.open;fs.open=open;function open(path,flags,mode,cb){if(typeof mode==="function")cb=mode,mode=null;return go$open(path,flags,mode,cb);function go$open(path,flags,mode,cb,startTime){return fs$open(path,flags,mode,(function(err,fd){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$open,[path,flags,mode,cb],err,startTime||Date.now(),Date.now()]);else{if(typeof cb==="function")cb.apply(this,arguments)}}))}}return fs}function enqueue(elem){debug("ENQUEUE",elem[0].name,elem[1]);fs[gracefulQueue].push(elem);retry()}var retryTimer;function resetQueue(){var now=Date.now();for(var i=0;i<fs[gracefulQueue].length;++i){if(fs[gracefulQueue][i].length>2){fs[gracefulQueue][i][3]=now;fs[gracefulQueue][i][4]=now}}retry()}function retry(){clearTimeout(retryTimer);retryTimer=undefined;if(fs[gracefulQueue].length===0)return;var elem=fs[gracefulQueue].shift();var fn=elem[0];var args=elem[1];var err=elem[2];var startTime=elem[3];var lastTime=elem[4];if(startTime===undefined){debug("RETRY",fn.name,args);fn.apply(null,args)}else if(Date.now()-startTime>=6e4){debug("TIMEOUT",fn.name,args);var cb=args.pop();if(typeof cb==="function")cb.call(null,err)}else{var sinceAttempt=Date.now()-lastTime;var sinceStart=Math.max(lastTime-startTime,1);var desiredDelay=Math.min(sinceStart*1.2,100);if(sinceAttempt>=desiredDelay){debug("RETRY",fn.name,args);fn.apply(null,args.concat([startTime]))}else{fs[gracefulQueue].push(elem)}}if(retryTimer===undefined){retryTimer=setTimeout(retry,0)}}},(module,__unused_webpack_exports,__webpack_require__)=>{var constants=__webpack_require__(34);var origCwd=process.cwd;var cwd=null;var platform=process.env.GRACEFUL_FS_PLATFORM||process.platform;process.cwd=function(){if(!cwd)cwd=origCwd.call(process);return cwd};try{process.cwd()}catch(er){}if(typeof process.chdir==="function"){var chdir=process.chdir;process.chdir=function(d){cwd=null;chdir.call(process,d)};if(Object.setPrototypeOf)Object.setPrototypeOf(process.chdir,chdir)}module.exports=patch;function patch(fs){if(constants.hasOwnProperty("O_SYMLINK")&&process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)){patchLchmod(fs)}if(!fs.lutimes){patchLutimes(fs)}fs.chown=chownFix(fs.chown);fs.fchown=chownFix(fs.fchown);fs.lchown=chownFix(fs.lchown);fs.chmod=chmodFix(fs.chmod);fs.fchmod=chmodFix(fs.fchmod);fs.lchmod=chmodFix(fs.lchmod);fs.chownSync=chownFixSync(fs.chownSync);fs.fchownSync=chownFixSync(fs.fchownSync);fs.lchownSync=chownFixSync(fs.lchownSync);fs.chmodSync=chmodFixSync(fs.chmodSync);fs.fchmodSync=chmodFixSync(fs.fchmodSync);fs.lchmodSync=chmodFixSync(fs.lchmodSync);fs.stat=statFix(fs.stat);fs.fstat=statFix(fs.fstat);fs.lstat=statFix(fs.lstat);fs.statSync=statFixSync(fs.statSync);fs.fstatSync=statFixSync(fs.fstatSync);fs.lstatSync=statFixSync(fs.lstatSync);if(!fs.lchmod){fs.lchmod=function(path,mode,cb){if(cb)process.nextTick(cb)};fs.lchmodSync=function(){}}if(!fs.lchown){fs.lchown=function(path,uid,gid,cb){if(cb)process.nextTick(cb)};fs.lchownSync=function(){}}if(platform==="win32"){fs.rename=function(fs$rename){return function(from,to,cb){var start=Date.now();var backoff=0;fs$rename(from,to,(function CB(er){if(er&&(er.code==="EACCES"||er.code==="EPERM")&&Date.now()-start<6e4){setTimeout((function(){fs.stat(to,(function(stater,st){if(stater&&stater.code==="ENOENT")fs$rename(from,to,CB);else cb(er)}))}),backoff);if(backoff<100)backoff+=10;return}if(cb)cb(er)}))}}(fs.rename)}fs.read=function(fs$read){function read(fd,buffer,offset,length,position,callback_){var callback;if(callback_&&typeof callback_==="function"){var eagCounter=0;callback=function(er,_,__){if(er&&er.code==="EAGAIN"&&eagCounter<10){eagCounter++;return fs$read.call(fs,fd,buffer,offset,length,position,callback)}callback_.apply(this,arguments)}}return fs$read.call(fs,fd,buffer,offset,length,position,callback)}if(Object.setPrototypeOf)Object.setPrototypeOf(read,fs$read);return read}(fs.read);fs.readSync=function(fs$readSync){return function(fd,buffer,offset,length,position){var eagCounter=0;while(true){try{return fs$readSync.call(fs,fd,buffer,offset,length,position)}catch(er){if(er.code==="EAGAIN"&&eagCounter<10){eagCounter++;continue}throw er}}}}(fs.readSync);function patchLchmod(fs){fs.lchmod=function(path,mode,callback){fs.open(path,constants.O_WRONLY|constants.O_SYMLINK,mode,(function(err,fd){if(err){if(callback)callback(err);return}fs.fchmod(fd,mode,(function(err){fs.close(fd,(function(err2){if(callback)callback(err||err2)}))}))}))};fs.lchmodSync=function(path,mode){var fd=fs.openSync(path,constants.O_WRONLY|constants.O_SYMLINK,mode);var threw=true;var ret;try{ret=fs.fchmodSync(fd,mode);threw=false}finally{if(threw){try{fs.closeSync(fd)}catch(er){}}else{fs.closeSync(fd)}}return ret}}function patchLutimes(fs){if(constants.hasOwnProperty("O_SYMLINK")){fs.lutimes=function(path,at,mt,cb){fs.open(path,constants.O_SYMLINK,(function(er,fd){if(er){if(cb)cb(er);return}fs.futimes(fd,at,mt,(function(er){fs.close(fd,(function(er2){if(cb)cb(er||er2)}))}))}))};fs.lutimesSync=function(path,at,mt){var fd=fs.openSync(path,constants.O_SYMLINK);var ret;var threw=true;try{ret=fs.futimesSync(fd,at,mt);threw=false}finally{if(threw){try{fs.closeSync(fd)}catch(er){}}else{fs.closeSync(fd)}}return ret}}else{fs.lutimes=function(_a,_b,_c,cb){if(cb)process.nextTick(cb)};fs.lutimesSync=function(){}}}function chmodFix(orig){if(!orig)return orig;return function(target,mode,cb){return orig.call(fs,target,mode,(function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)}))}}function chmodFixSync(orig){if(!orig)return orig;return function(target,mode){try{return orig.call(fs,target,mode)}catch(er){if(!chownErOk(er))throw er}}}function chownFix(orig){if(!orig)return orig;return function(target,uid,gid,cb){return orig.call(fs,target,uid,gid,(function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)}))}}function chownFixSync(orig){if(!orig)return orig;return function(target,uid,gid){try{return orig.call(fs,target,uid,gid)}catch(er){if(!chownErOk(er))throw er}}}function statFix(orig){if(!orig)return orig;return function(target,options,cb){if(typeof options==="function"){cb=options;options=null}function callback(er,stats){if(stats){if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296}if(cb)cb.apply(this,arguments)}return options?orig.call(fs,target,options,callback):orig.call(fs,target,callback)}}function statFixSync(orig){if(!orig)return orig;return function(target,options){var stats=options?orig.call(fs,target,options):orig.call(fs,target);if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296;return stats}}function chownErOk(er){if(!er)return true;if(er.code==="ENOSYS")return true;var nonroot=!process.getuid||process.getuid()!==0;if(nonroot){if(er.code==="EINVAL"||er.code==="EPERM")return true}return false}}},module=>{"use strict";module.exports=require("constants")},(module,__unused_webpack_exports,__webpack_require__)=>{var Stream=__webpack_require__(21).Stream;module.exports=legacy;function legacy(fs){return{ReadStream,WriteStream};function ReadStream(path,options){if(!(this instanceof ReadStream))return new ReadStream(path,options);Stream.call(this);var self=this;this.path=path;this.fd=null;this.readable=true;this.paused=false;this.flags="r";this.mode=438;this.bufferSize=64*1024;options=options||{};var keys=Object.keys(options);for(var index=0,length=keys.length;index<length;index++){var key=keys[index];this[key]=options[key]}if(this.encoding)this.setEncoding(this.encoding);if(this.start!==undefined){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.end===undefined){this.end=Infinity}else if("number"!==typeof this.end){throw TypeError("end must be a Number")}if(this.start>this.end){throw new Error("start must be <= end")}this.pos=this.start}if(this.fd!==null){process.nextTick((function(){self._read()}));return}fs.open(this.path,this.flags,this.mode,(function(err,fd){if(err){self.emit("error",err);self.readable=false;return}self.fd=fd;self.emit("open",fd);self._read()}))}function WriteStream(path,options){if(!(this instanceof WriteStream))return new WriteStream(path,options);Stream.call(this);this.path=path;this.fd=null;this.writable=true;this.flags="w";this.encoding="binary";this.mode=438;this.bytesWritten=0;options=options||{};var keys=Object.keys(options);for(var index=0,length=keys.length;index<length;index++){var key=keys[index];this[key]=options[key]}if(this.start!==undefined){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.start<0){throw new Error("start must be >= zero")}this.pos=this.start}this.busy=false;this._queue=[];if(this.fd===null){this._open=fs.open;this._queue.push([this._open,this.path,this.flags,this.mode,undefined]);this.flush()}}}},module=>{"use strict";module.exports=clone;var getPrototypeOf=Object.getPrototypeOf||function(obj){return obj.__proto__};function clone(obj){if(obj===null||typeof obj!=="object")return obj;if(obj instanceof Object)var copy={__proto__:getPrototypeOf(obj)};else var copy=Object.create(null);Object.getOwnPropertyNames(obj).forEach((function(key){Object.defineProperty(copy,key,Object.getOwnPropertyDescriptor(obj,key))}));return copy}},module=>{"use strict";module.exports=require("assert")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";module.exports={copySync:__webpack_require__(39)}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);const path=__webpack_require__(40);const mkdirsSync=__webpack_require__(41).mkdirsSync;const utimesMillisSync=__webpack_require__(44).utimesMillisSync;const stat=__webpack_require__(45);function copySync(src,dest,opts){if(typeof opts==="function"){opts={filter:opts}}opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;\n\n    see https://github.com/jprichardson/node-fs-extra/issues/269`)}const{srcStat,destStat}=stat.checkPathsSync(src,dest,"copy");stat.checkParentPathsSync(src,srcStat,dest,"copy");return handleFilterAndCopy(destStat,src,dest,opts)}function handleFilterAndCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;const destParent=path.dirname(dest);if(!fs.existsSync(destParent))mkdirsSync(destParent);return startCopy(destStat,src,dest,opts)}function startCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;return getStats(destStat,src,dest,opts)}function getStats(destStat,src,dest,opts){const statSync=opts.dereference?fs.statSync:fs.lstatSync;const srcStat=statSync(src);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts)}function onFile(srcStat,destStat,src,dest,opts){if(!destStat)return copyFile(srcStat,src,dest,opts);return mayCopyFile(srcStat,src,dest,opts)}function mayCopyFile(srcStat,src,dest,opts){if(opts.overwrite){fs.unlinkSync(dest);return copyFile(srcStat,src,dest,opts)}else if(opts.errorOnExist){throw new Error(`'${dest}' already exists`)}}function copyFile(srcStat,src,dest,opts){fs.copyFileSync(src,dest);if(opts.preserveTimestamps)handleTimestamps(srcStat.mode,src,dest);return setDestMode(dest,srcStat.mode)}function handleTimestamps(srcMode,src,dest){if(fileIsNotWritable(srcMode))makeFileWritable(dest,srcMode);return setDestTimestamps(src,dest)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode){return setDestMode(dest,srcMode|128)}function setDestMode(dest,srcMode){return fs.chmodSync(dest,srcMode)}function setDestTimestamps(src,dest){const updatedSrcStat=fs.statSync(src);return utimesMillisSync(dest,updatedSrcStat.atime,updatedSrcStat.mtime)}function onDir(srcStat,destStat,src,dest,opts){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts);if(destStat&&!destStat.isDirectory()){throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`)}return copyDir(src,dest,opts)}function mkDirAndCopy(srcMode,src,dest,opts){fs.mkdirSync(dest);copyDir(src,dest,opts);return setDestMode(dest,srcMode)}function copyDir(src,dest,opts){fs.readdirSync(src).forEach((item=>copyDirItem(item,src,dest,opts)))}function copyDirItem(item,src,dest,opts){const srcItem=path.join(src,item);const destItem=path.join(dest,item);const{destStat}=stat.checkPathsSync(srcItem,destItem,"copy");return startCopy(destStat,srcItem,destItem,opts)}function onLink(destStat,src,dest,opts){let resolvedSrc=fs.readlinkSync(src);if(opts.dereference){resolvedSrc=path.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs.symlinkSync(resolvedSrc,dest)}else{let resolvedDest;try{resolvedDest=fs.readlinkSync(dest)}catch(err){if(err.code==="EINVAL"||err.code==="UNKNOWN")return fs.symlinkSync(resolvedSrc,dest);throw err}if(opts.dereference){resolvedDest=path.resolve(process.cwd(),resolvedDest)}if(stat.isSrcSubdir(resolvedSrc,resolvedDest)){throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`)}if(fs.statSync(dest).isDirectory()&&stat.isSrcSubdir(resolvedDest,resolvedSrc)){throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`)}return copyLink(resolvedSrc,dest)}}function copyLink(resolvedSrc,dest){fs.unlinkSync(dest);return fs.symlinkSync(resolvedSrc,dest)}module.exports=copySync},module=>{"use strict";module.exports=require("path")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromPromise;const{makeDir:_makeDir,makeDirSync}=__webpack_require__(42);const makeDir=u(_makeDir);module.exports={mkdirs:makeDir,mkdirsSync:makeDirSync,mkdirp:makeDir,mkdirpSync:makeDirSync,ensureDir:makeDir,ensureDirSync:makeDirSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(30);const path=__webpack_require__(40);const atLeastNode=__webpack_require__(43);const useNativeRecursiveOption=atLeastNode("10.12.0");const checkPath=pth=>{if(process.platform==="win32"){const pathHasInvalidWinCharacters=/[<>:"|?*]/.test(pth.replace(path.parse(pth).root,""));if(pathHasInvalidWinCharacters){const error=new Error(`Path contains invalid characters: ${pth}`);error.code="EINVAL";throw error}}};const processOptions=options=>{const defaults={mode:511};if(typeof options==="number")options={mode:options};return{...defaults,...options}};const permissionError=pth=>{const error=new Error(`operation not permitted, mkdir '${pth}'`);error.code="EPERM";error.errno=-4048;error.path=pth;error.syscall="mkdir";return error};module.exports.makeDir=async(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path.resolve(input);return fs.mkdir(pth,{mode:options.mode,recursive:true})}const make=async pth=>{try{await fs.mkdir(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}await make(path.dirname(pth));return make(pth)}try{const stats=await fs.stat(pth);if(!stats.isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path.resolve(input))};module.exports.makeDirSync=(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path.resolve(input);return fs.mkdirSync(pth,{mode:options.mode,recursive:true})}const make=pth=>{try{fs.mkdirSync(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}make(path.dirname(pth));return make(pth)}try{if(!fs.statSync(pth).isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path.resolve(input))}},module=>{module.exports=r=>{const n=process.versions.node.split(".").map((x=>parseInt(x,10)));r=r.split(".").map((x=>parseInt(x,10)));return n[0]>r[0]||n[0]===r[0]&&(n[1]>r[1]||n[1]===r[1]&&n[2]>=r[2])}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);function utimesMillis(path,atime,mtime,callback){fs.open(path,"r+",((err,fd)=>{if(err)return callback(err);fs.futimes(fd,atime,mtime,(futimesErr=>{fs.close(fd,(closeErr=>{if(callback)callback(futimesErr||closeErr)}))}))}))}function utimesMillisSync(path,atime,mtime){const fd=fs.openSync(path,"r+");fs.futimesSync(fd,atime,mtime);return fs.closeSync(fd)}module.exports={utimesMillis,utimesMillisSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(30);const path=__webpack_require__(40);const util=__webpack_require__(16);const atLeastNode=__webpack_require__(43);const nodeSupportsBigInt=atLeastNode("10.5.0");const stat=file=>nodeSupportsBigInt?fs.stat(file,{bigint:true}):fs.stat(file);const statSync=file=>nodeSupportsBigInt?fs.statSync(file,{bigint:true}):fs.statSync(file);function getStats(src,dest){return Promise.all([stat(src),stat(dest).catch((err=>{if(err.code==="ENOENT")return null;throw err}))]).then((([srcStat,destStat])=>({srcStat,destStat})))}function getStatsSync(src,dest){let destStat;const srcStat=statSync(src);try{destStat=statSync(dest)}catch(err){if(err.code==="ENOENT")return{srcStat,destStat:null};throw err}return{srcStat,destStat}}function checkPaths(src,dest,funcName,cb){util.callbackify(getStats)(src,dest,((err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;if(destStat&&areIdentical(srcStat,destStat)){return cb(new Error("Source and destination must not be the same."))}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){return cb(new Error(errMsg(src,dest,funcName)))}return cb(null,{srcStat,destStat})}))}function checkPathsSync(src,dest,funcName){const{srcStat,destStat}=getStatsSync(src,dest);if(destStat&&areIdentical(srcStat,destStat)){throw new Error("Source and destination must not be the same.")}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){throw new Error(errMsg(src,dest,funcName))}return{srcStat,destStat}}function checkParentPaths(src,srcStat,dest,funcName,cb){const srcParent=path.resolve(path.dirname(src));const destParent=path.resolve(path.dirname(dest));if(destParent===srcParent||destParent===path.parse(destParent).root)return cb();const callback=(err,destStat)=>{if(err){if(err.code==="ENOENT")return cb();return cb(err)}if(areIdentical(srcStat,destStat)){return cb(new Error(errMsg(src,dest,funcName)))}return checkParentPaths(src,srcStat,destParent,funcName,cb)};if(nodeSupportsBigInt)fs.stat(destParent,{bigint:true},callback);else fs.stat(destParent,callback)}function checkParentPathsSync(src,srcStat,dest,funcName){const srcParent=path.resolve(path.dirname(src));const destParent=path.resolve(path.dirname(dest));if(destParent===srcParent||destParent===path.parse(destParent).root)return;let destStat;try{destStat=statSync(destParent)}catch(err){if(err.code==="ENOENT")return;throw err}if(areIdentical(srcStat,destStat)){throw new Error(errMsg(src,dest,funcName))}return checkParentPathsSync(src,srcStat,destParent,funcName)}function areIdentical(srcStat,destStat){if(destStat.ino&&destStat.dev&&destStat.ino===srcStat.ino&&destStat.dev===srcStat.dev){if(nodeSupportsBigInt||destStat.ino<Number.MAX_SAFE_INTEGER){return true}if(destStat.size===srcStat.size&&destStat.mode===srcStat.mode&&destStat.nlink===srcStat.nlink&&destStat.atimeMs===srcStat.atimeMs&&destStat.mtimeMs===srcStat.mtimeMs&&destStat.ctimeMs===srcStat.ctimeMs&&destStat.birthtimeMs===srcStat.birthtimeMs){return true}}return false}function isSrcSubdir(src,dest){const srcArr=path.resolve(src).split(path.sep).filter((i=>i));const destArr=path.resolve(dest).split(path.sep).filter((i=>i));return srcArr.reduce(((acc,cur,i)=>acc&&destArr[i]===cur),true)}function errMsg(src,dest,funcName){return`Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`}module.exports={checkPaths,checkPathsSync,checkParentPaths,checkParentPathsSync,isSrcSubdir}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;module.exports={copy:u(__webpack_require__(47))}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);const path=__webpack_require__(40);const mkdirs=__webpack_require__(41).mkdirs;const pathExists=__webpack_require__(48).pathExists;const utimesMillis=__webpack_require__(44).utimesMillis;const stat=__webpack_require__(45);function copy(src,dest,opts,cb){if(typeof opts==="function"&&!cb){cb=opts;opts={}}else if(typeof opts==="function"){opts={filter:opts}}cb=cb||function(){};opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;\n\n    see https://github.com/jprichardson/node-fs-extra/issues/269`)}stat.checkPaths(src,dest,"copy",((err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;stat.checkParentPaths(src,srcStat,dest,"copy",(err=>{if(err)return cb(err);if(opts.filter)return handleFilter(checkParentDir,destStat,src,dest,opts,cb);return checkParentDir(destStat,src,dest,opts,cb)}))}))}function checkParentDir(destStat,src,dest,opts,cb){const destParent=path.dirname(dest);pathExists(destParent,((err,dirExists)=>{if(err)return cb(err);if(dirExists)return startCopy(destStat,src,dest,opts,cb);mkdirs(destParent,(err=>{if(err)return cb(err);return startCopy(destStat,src,dest,opts,cb)}))}))}function handleFilter(onInclude,destStat,src,dest,opts,cb){Promise.resolve(opts.filter(src,dest)).then((include=>{if(include)return onInclude(destStat,src,dest,opts,cb);return cb()}),(error=>cb(error)))}function startCopy(destStat,src,dest,opts,cb){if(opts.filter)return handleFilter(getStats,destStat,src,dest,opts,cb);return getStats(destStat,src,dest,opts,cb)}function getStats(destStat,src,dest,opts,cb){const stat=opts.dereference?fs.stat:fs.lstat;stat(src,((err,srcStat)=>{if(err)return cb(err);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts,cb)}))}function onFile(srcStat,destStat,src,dest,opts,cb){if(!destStat)return copyFile(srcStat,src,dest,opts,cb);return mayCopyFile(srcStat,src,dest,opts,cb)}function mayCopyFile(srcStat,src,dest,opts,cb){if(opts.overwrite){fs.unlink(dest,(err=>{if(err)return cb(err);return copyFile(srcStat,src,dest,opts,cb)}))}else if(opts.errorOnExist){return cb(new Error(`'${dest}' already exists`))}else return cb()}function copyFile(srcStat,src,dest,opts,cb){fs.copyFile(src,dest,(err=>{if(err)return cb(err);if(opts.preserveTimestamps)return handleTimestampsAndMode(srcStat.mode,src,dest,cb);return setDestMode(dest,srcStat.mode,cb)}))}function handleTimestampsAndMode(srcMode,src,dest,cb){if(fileIsNotWritable(srcMode)){return makeFileWritable(dest,srcMode,(err=>{if(err)return cb(err);return setDestTimestampsAndMode(srcMode,src,dest,cb)}))}return setDestTimestampsAndMode(srcMode,src,dest,cb)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode,cb){return setDestMode(dest,srcMode|128,cb)}function setDestTimestampsAndMode(srcMode,src,dest,cb){setDestTimestamps(src,dest,(err=>{if(err)return cb(err);return setDestMode(dest,srcMode,cb)}))}function setDestMode(dest,srcMode,cb){return fs.chmod(dest,srcMode,cb)}function setDestTimestamps(src,dest,cb){fs.stat(src,((err,updatedSrcStat)=>{if(err)return cb(err);return utimesMillis(dest,updatedSrcStat.atime,updatedSrcStat.mtime,cb)}))}function onDir(srcStat,destStat,src,dest,opts,cb){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts,cb);if(destStat&&!destStat.isDirectory()){return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`))}return copyDir(src,dest,opts,cb)}function mkDirAndCopy(srcMode,src,dest,opts,cb){fs.mkdir(dest,(err=>{if(err)return cb(err);copyDir(src,dest,opts,(err=>{if(err)return cb(err);return setDestMode(dest,srcMode,cb)}))}))}function copyDir(src,dest,opts,cb){fs.readdir(src,((err,items)=>{if(err)return cb(err);return copyDirItems(items,src,dest,opts,cb)}))}function copyDirItems(items,src,dest,opts,cb){const item=items.pop();if(!item)return cb();return copyDirItem(items,item,src,dest,opts,cb)}function copyDirItem(items,item,src,dest,opts,cb){const srcItem=path.join(src,item);const destItem=path.join(dest,item);stat.checkPaths(srcItem,destItem,"copy",((err,stats)=>{if(err)return cb(err);const{destStat}=stats;startCopy(destStat,srcItem,destItem,opts,(err=>{if(err)return cb(err);return copyDirItems(items,src,dest,opts,cb)}))}))}function onLink(destStat,src,dest,opts,cb){fs.readlink(src,((err,resolvedSrc)=>{if(err)return cb(err);if(opts.dereference){resolvedSrc=path.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs.symlink(resolvedSrc,dest,cb)}else{fs.readlink(dest,((err,resolvedDest)=>{if(err){if(err.code==="EINVAL"||err.code==="UNKNOWN")return fs.symlink(resolvedSrc,dest,cb);return cb(err)}if(opts.dereference){resolvedDest=path.resolve(process.cwd(),resolvedDest)}if(stat.isSrcSubdir(resolvedSrc,resolvedDest)){return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`))}if(destStat.isDirectory()&&stat.isSrcSubdir(resolvedDest,resolvedSrc)){return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`))}return copyLink(resolvedSrc,dest,cb)}))}}))}function copyLink(resolvedSrc,dest,cb){fs.unlink(dest,(err=>{if(err)return cb(err);return fs.symlink(resolvedSrc,dest,cb)}))}module.exports=copy},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromPromise;const fs=__webpack_require__(30);function pathExists(path){return fs.access(path).then((()=>true)).catch((()=>false))}module.exports={pathExists:u(pathExists),pathExistsSync:fs.existsSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const fs=__webpack_require__(32);const path=__webpack_require__(40);const mkdir=__webpack_require__(41);const remove=__webpack_require__(50);const emptyDir=u((function emptyDir(dir,callback){callback=callback||function(){};fs.readdir(dir,((err,items)=>{if(err)return mkdir.mkdirs(dir,callback);items=items.map((item=>path.join(dir,item)));deleteItem();function deleteItem(){const item=items.pop();if(!item)return callback();remove.remove(item,(err=>{if(err)return callback(err);deleteItem()}))}}))}));function emptyDirSync(dir){let items;try{items=fs.readdirSync(dir)}catch{return mkdir.mkdirsSync(dir)}items.forEach((item=>{item=path.join(dir,item);remove.removeSync(item)}))}module.exports={emptyDirSync,emptydirSync:emptyDirSync,emptyDir,emptydir:emptyDir}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const rimraf=__webpack_require__(51);module.exports={remove:u(rimraf),removeSync:rimraf.sync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);const path=__webpack_require__(40);const assert=__webpack_require__(37);const isWindows=process.platform==="win32";function defaults(options){const methods=["unlink","chmod","stat","lstat","rmdir","readdir"];methods.forEach((m=>{options[m]=options[m]||fs[m];m=m+"Sync";options[m]=options[m]||fs[m]}));options.maxBusyTries=options.maxBusyTries||3}function rimraf(p,options,cb){let busyTries=0;if(typeof options==="function"){cb=options;options={}}assert(p,"rimraf: missing path");assert.strictEqual(typeof p,"string","rimraf: path should be a string");assert.strictEqual(typeof cb,"function","rimraf: callback function required");assert(options,"rimraf: invalid options argument provided");assert.strictEqual(typeof options,"object","rimraf: options should be object");defaults(options);rimraf_(p,options,(function CB(er){if(er){if((er.code==="EBUSY"||er.code==="ENOTEMPTY"||er.code==="EPERM")&&busyTries<options.maxBusyTries){busyTries++;const time=busyTries*100;return setTimeout((()=>rimraf_(p,options,CB)),time)}if(er.code==="ENOENT")er=null}cb(er)}))}function rimraf_(p,options,cb){assert(p);assert(options);assert(typeof cb==="function");options.lstat(p,((er,st)=>{if(er&&er.code==="ENOENT"){return cb(null)}if(er&&er.code==="EPERM"&&isWindows){return fixWinEPERM(p,options,er,cb)}if(st&&st.isDirectory()){return rmdir(p,options,er,cb)}options.unlink(p,(er=>{if(er){if(er.code==="ENOENT"){return cb(null)}if(er.code==="EPERM"){return isWindows?fixWinEPERM(p,options,er,cb):rmdir(p,options,er,cb)}if(er.code==="EISDIR"){return rmdir(p,options,er,cb)}}return cb(er)}))}))}function fixWinEPERM(p,options,er,cb){assert(p);assert(options);assert(typeof cb==="function");options.chmod(p,438,(er2=>{if(er2){cb(er2.code==="ENOENT"?null:er)}else{options.stat(p,((er3,stats)=>{if(er3){cb(er3.code==="ENOENT"?null:er)}else if(stats.isDirectory()){rmdir(p,options,er,cb)}else{options.unlink(p,cb)}}))}}))}function fixWinEPERMSync(p,options,er){let stats;assert(p);assert(options);try{options.chmodSync(p,438)}catch(er2){if(er2.code==="ENOENT"){return}else{throw er}}try{stats=options.statSync(p)}catch(er3){if(er3.code==="ENOENT"){return}else{throw er}}if(stats.isDirectory()){rmdirSync(p,options,er)}else{options.unlinkSync(p)}}function rmdir(p,options,originalEr,cb){assert(p);assert(options);assert(typeof cb==="function");options.rmdir(p,(er=>{if(er&&(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM")){rmkids(p,options,cb)}else if(er&&er.code==="ENOTDIR"){cb(originalEr)}else{cb(er)}}))}function rmkids(p,options,cb){assert(p);assert(options);assert(typeof cb==="function");options.readdir(p,((er,files)=>{if(er)return cb(er);let n=files.length;let errState;if(n===0)return options.rmdir(p,cb);files.forEach((f=>{rimraf(path.join(p,f),options,(er=>{if(errState){return}if(er)return cb(errState=er);if(--n===0){options.rmdir(p,cb)}}))}))}))}function rimrafSync(p,options){let st;options=options||{};defaults(options);assert(p,"rimraf: missing path");assert.strictEqual(typeof p,"string","rimraf: path should be a string");assert(options,"rimraf: missing options");assert.strictEqual(typeof options,"object","rimraf: options should be object");try{st=options.lstatSync(p)}catch(er){if(er.code==="ENOENT"){return}if(er.code==="EPERM"&&isWindows){fixWinEPERMSync(p,options,er)}}try{if(st&&st.isDirectory()){rmdirSync(p,options,null)}else{options.unlinkSync(p)}}catch(er){if(er.code==="ENOENT"){return}else if(er.code==="EPERM"){return isWindows?fixWinEPERMSync(p,options,er):rmdirSync(p,options,er)}else if(er.code!=="EISDIR"){throw er}rmdirSync(p,options,er)}}function rmdirSync(p,options,originalEr){assert(p);assert(options);try{options.rmdirSync(p)}catch(er){if(er.code==="ENOTDIR"){throw originalEr}else if(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM"){rmkidsSync(p,options)}else if(er.code!=="ENOENT"){throw er}}}function rmkidsSync(p,options){assert(p);assert(options);options.readdirSync(p).forEach((f=>rimrafSync(path.join(p,f),options)));if(isWindows){const startTime=Date.now();do{try{const ret=options.rmdirSync(p,options);return ret}catch{}}while(Date.now()-startTime<500)}else{const ret=options.rmdirSync(p,options);return ret}}module.exports=rimraf;rimraf.sync=rimrafSync},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const file=__webpack_require__(53);const link=__webpack_require__(54);const symlink=__webpack_require__(55);module.exports={createFile:file.createFile,createFileSync:file.createFileSync,ensureFile:file.createFile,ensureFileSync:file.createFileSync,createLink:link.createLink,createLinkSync:link.createLinkSync,ensureLink:link.createLink,ensureLinkSync:link.createLinkSync,createSymlink:symlink.createSymlink,createSymlinkSync:symlink.createSymlinkSync,ensureSymlink:symlink.createSymlink,ensureSymlinkSync:symlink.createSymlinkSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const path=__webpack_require__(40);const fs=__webpack_require__(32);const mkdir=__webpack_require__(41);function createFile(file,callback){function makeFile(){fs.writeFile(file,"",(err=>{if(err)return callback(err);callback()}))}fs.stat(file,((err,stats)=>{if(!err&&stats.isFile())return callback();const dir=path.dirname(file);fs.stat(dir,((err,stats)=>{if(err){if(err.code==="ENOENT"){return mkdir.mkdirs(dir,(err=>{if(err)return callback(err);makeFile()}))}return callback(err)}if(stats.isDirectory())makeFile();else{fs.readdir(dir,(err=>{if(err)return callback(err)}))}}))}))}function createFileSync(file){let stats;try{stats=fs.statSync(file)}catch{}if(stats&&stats.isFile())return;const dir=path.dirname(file);try{if(!fs.statSync(dir).isDirectory()){fs.readdirSync(dir)}}catch(err){if(err&&err.code==="ENOENT")mkdir.mkdirsSync(dir);else throw err}fs.writeFileSync(file,"")}module.exports={createFile:u(createFile),createFileSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const path=__webpack_require__(40);const fs=__webpack_require__(32);const mkdir=__webpack_require__(41);const pathExists=__webpack_require__(48).pathExists;function createLink(srcpath,dstpath,callback){function makeLink(srcpath,dstpath){fs.link(srcpath,dstpath,(err=>{if(err)return callback(err);callback(null)}))}pathExists(dstpath,((err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);fs.lstat(srcpath,(err=>{if(err){err.message=err.message.replace("lstat","ensureLink");return callback(err)}const dir=path.dirname(dstpath);pathExists(dir,((err,dirExists)=>{if(err)return callback(err);if(dirExists)return makeLink(srcpath,dstpath);mkdir.mkdirs(dir,(err=>{if(err)return callback(err);makeLink(srcpath,dstpath)}))}))}))}))}function createLinkSync(srcpath,dstpath){const destinationExists=fs.existsSync(dstpath);if(destinationExists)return undefined;try{fs.lstatSync(srcpath)}catch(err){err.message=err.message.replace("lstat","ensureLink");throw err}const dir=path.dirname(dstpath);const dirExists=fs.existsSync(dir);if(dirExists)return fs.linkSync(srcpath,dstpath);mkdir.mkdirsSync(dir);return fs.linkSync(srcpath,dstpath)}module.exports={createLink:u(createLink),createLinkSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const path=__webpack_require__(40);const fs=__webpack_require__(32);const _mkdirs=__webpack_require__(41);const mkdirs=_mkdirs.mkdirs;const mkdirsSync=_mkdirs.mkdirsSync;const _symlinkPaths=__webpack_require__(56);const symlinkPaths=_symlinkPaths.symlinkPaths;const symlinkPathsSync=_symlinkPaths.symlinkPathsSync;const _symlinkType=__webpack_require__(57);const symlinkType=_symlinkType.symlinkType;const symlinkTypeSync=_symlinkType.symlinkTypeSync;const pathExists=__webpack_require__(48).pathExists;function createSymlink(srcpath,dstpath,type,callback){callback=typeof type==="function"?type:callback;type=typeof type==="function"?false:type;pathExists(dstpath,((err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);symlinkPaths(srcpath,dstpath,((err,relative)=>{if(err)return callback(err);srcpath=relative.toDst;symlinkType(relative.toCwd,type,((err,type)=>{if(err)return callback(err);const dir=path.dirname(dstpath);pathExists(dir,((err,dirExists)=>{if(err)return callback(err);if(dirExists)return fs.symlink(srcpath,dstpath,type,callback);mkdirs(dir,(err=>{if(err)return callback(err);fs.symlink(srcpath,dstpath,type,callback)}))}))}))}))}))}function createSymlinkSync(srcpath,dstpath,type){const destinationExists=fs.existsSync(dstpath);if(destinationExists)return undefined;const relative=symlinkPathsSync(srcpath,dstpath);srcpath=relative.toDst;type=symlinkTypeSync(relative.toCwd,type);const dir=path.dirname(dstpath);const exists=fs.existsSync(dir);if(exists)return fs.symlinkSync(srcpath,dstpath,type);mkdirsSync(dir);return fs.symlinkSync(srcpath,dstpath,type)}module.exports={createSymlink:u(createSymlink),createSymlinkSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const path=__webpack_require__(40);const fs=__webpack_require__(32);const pathExists=__webpack_require__(48).pathExists;function symlinkPaths(srcpath,dstpath,callback){if(path.isAbsolute(srcpath)){return fs.lstat(srcpath,(err=>{if(err){err.message=err.message.replace("lstat","ensureSymlink");return callback(err)}return callback(null,{toCwd:srcpath,toDst:srcpath})}))}else{const dstdir=path.dirname(dstpath);const relativeToDst=path.join(dstdir,srcpath);return pathExists(relativeToDst,((err,exists)=>{if(err)return callback(err);if(exists){return callback(null,{toCwd:relativeToDst,toDst:srcpath})}else{return fs.lstat(srcpath,(err=>{if(err){err.message=err.message.replace("lstat","ensureSymlink");return callback(err)}return callback(null,{toCwd:srcpath,toDst:path.relative(dstdir,srcpath)})}))}}))}}function symlinkPathsSync(srcpath,dstpath){let exists;if(path.isAbsolute(srcpath)){exists=fs.existsSync(srcpath);if(!exists)throw new Error("absolute srcpath does not exist");return{toCwd:srcpath,toDst:srcpath}}else{const dstdir=path.dirname(dstpath);const relativeToDst=path.join(dstdir,srcpath);exists=fs.existsSync(relativeToDst);if(exists){return{toCwd:relativeToDst,toDst:srcpath}}else{exists=fs.existsSync(srcpath);if(!exists)throw new Error("relative srcpath does not exist");return{toCwd:srcpath,toDst:path.relative(dstdir,srcpath)}}}}module.exports={symlinkPaths,symlinkPathsSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);function symlinkType(srcpath,type,callback){callback=typeof type==="function"?type:callback;type=typeof type==="function"?false:type;if(type)return callback(null,type);fs.lstat(srcpath,((err,stats)=>{if(err)return callback(null,"file");type=stats&&stats.isDirectory()?"dir":"file";callback(null,type)}))}function symlinkTypeSync(srcpath,type){let stats;if(type)return type;try{stats=fs.lstatSync(srcpath)}catch{return"file"}return stats&&stats.isDirectory()?"dir":"file"}module.exports={symlinkType,symlinkTypeSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromPromise;const jsonFile=__webpack_require__(59);jsonFile.outputJson=u(__webpack_require__(62));jsonFile.outputJsonSync=__webpack_require__(64);jsonFile.outputJSON=jsonFile.outputJson;jsonFile.outputJSONSync=jsonFile.outputJsonSync;jsonFile.writeJSON=jsonFile.writeJson;jsonFile.writeJSONSync=jsonFile.writeJsonSync;jsonFile.readJSON=jsonFile.readJson;jsonFile.readJSONSync=jsonFile.readJsonSync;module.exports=jsonFile},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const jsonFile=__webpack_require__(60);module.exports={readJson:jsonFile.readFile,readJsonSync:jsonFile.readFileSync,writeJson:jsonFile.writeFile,writeJsonSync:jsonFile.writeFileSync}},(module,__unused_webpack_exports,__webpack_require__)=>{let _fs;try{_fs=__webpack_require__(32)}catch(_){_fs=__webpack_require__(20)}const universalify=__webpack_require__(31);const{stringify,stripBom}=__webpack_require__(61);async function _readFile(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;let data=await universalify.fromCallback(fs.readFile)(file,options);data=stripBom(data);let obj;try{obj=JSON.parse(data,options?options.reviver:null)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}return obj}const readFile=universalify.fromPromise(_readFile);function readFileSync(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;try{let content=fs.readFileSync(file,options);content=stripBom(content);return JSON.parse(content,options.reviver)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}}async function _writeFile(file,obj,options={}){const fs=options.fs||_fs;const str=stringify(obj,options);await universalify.fromCallback(fs.writeFile)(file,str,options)}const writeFile=universalify.fromPromise(_writeFile);function writeFileSync(file,obj,options={}){const fs=options.fs||_fs;const str=stringify(obj,options);return fs.writeFileSync(file,str,options)}const jsonfile={readFile,readFileSync,writeFile,writeFileSync};module.exports=jsonfile},module=>{function stringify(obj,{EOL="\n",finalEOL=true,replacer=null,spaces}={}){const EOF=finalEOL?EOL:"";const str=JSON.stringify(obj,replacer,spaces);return str.replace(/\n/g,EOL)+EOF}function stripBom(content){if(Buffer.isBuffer(content))content=content.toString("utf8");return content.replace(/^\uFEFF/,"")}module.exports={stringify,stripBom}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const{stringify}=__webpack_require__(61);const{outputFile}=__webpack_require__(63);async function outputJson(file,data,options={}){const str=stringify(data,options);await outputFile(file,str,options)}module.exports=outputJson},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;const fs=__webpack_require__(32);const path=__webpack_require__(40);const mkdir=__webpack_require__(41);const pathExists=__webpack_require__(48).pathExists;function outputFile(file,data,encoding,callback){if(typeof encoding==="function"){callback=encoding;encoding="utf8"}const dir=path.dirname(file);pathExists(dir,((err,itDoes)=>{if(err)return callback(err);if(itDoes)return fs.writeFile(file,data,encoding,callback);mkdir.mkdirs(dir,(err=>{if(err)return callback(err);fs.writeFile(file,data,encoding,callback)}))}))}function outputFileSync(file,...args){const dir=path.dirname(file);if(fs.existsSync(dir)){return fs.writeFileSync(file,...args)}mkdir.mkdirsSync(dir);fs.writeFileSync(file,...args)}module.exports={outputFile:u(outputFile),outputFileSync}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const{stringify}=__webpack_require__(61);const{outputFileSync}=__webpack_require__(63);function outputJsonSync(file,data,options){const str=stringify(data,options);outputFileSync(file,str,options)}module.exports=outputJsonSync},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";module.exports={moveSync:__webpack_require__(66)}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);const path=__webpack_require__(40);const copySync=__webpack_require__(38).copySync;const removeSync=__webpack_require__(50).removeSync;const mkdirpSync=__webpack_require__(41).mkdirpSync;const stat=__webpack_require__(45);function moveSync(src,dest,opts){opts=opts||{};const overwrite=opts.overwrite||opts.clobber||false;const{srcStat}=stat.checkPathsSync(src,dest,"move");stat.checkParentPathsSync(src,srcStat,dest,"move");mkdirpSync(path.dirname(dest));return doRename(src,dest,overwrite)}function doRename(src,dest,overwrite){if(overwrite){removeSync(dest);return rename(src,dest,overwrite)}if(fs.existsSync(dest))throw new Error("dest already exists.");return rename(src,dest,overwrite)}function rename(src,dest,overwrite){try{fs.renameSync(src,dest)}catch(err){if(err.code!=="EXDEV")throw err;return moveAcrossDevice(src,dest,overwrite)}}function moveAcrossDevice(src,dest,overwrite){const opts={overwrite,errorOnExist:true};copySync(src,dest,opts);return removeSync(src)}module.exports=moveSync},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const u=__webpack_require__(31).fromCallback;module.exports={move:u(__webpack_require__(68))}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const fs=__webpack_require__(32);const path=__webpack_require__(40);const copy=__webpack_require__(46).copy;const remove=__webpack_require__(50).remove;const mkdirp=__webpack_require__(41).mkdirp;const pathExists=__webpack_require__(48).pathExists;const stat=__webpack_require__(45);function move(src,dest,opts,cb){if(typeof opts==="function"){cb=opts;opts={}}const overwrite=opts.overwrite||opts.clobber||false;stat.checkPaths(src,dest,"move",((err,stats)=>{if(err)return cb(err);const{srcStat}=stats;stat.checkParentPaths(src,srcStat,dest,"move",(err=>{if(err)return cb(err);mkdirp(path.dirname(dest),(err=>{if(err)return cb(err);return doRename(src,dest,overwrite,cb)}))}))}))}function doRename(src,dest,overwrite,cb){if(overwrite){return remove(dest,(err=>{if(err)return cb(err);return rename(src,dest,overwrite,cb)}))}pathExists(dest,((err,destExists)=>{if(err)return cb(err);if(destExists)return cb(new Error("dest already exists."));return rename(src,dest,overwrite,cb)}))}function rename(src,dest,overwrite,cb){fs.rename(src,dest,(err=>{if(!err)return cb();if(err.code!=="EXDEV")return cb(err);return moveAcrossDevice(src,dest,overwrite,cb)}))}function moveAcrossDevice(src,dest,overwrite,cb){const opts={overwrite,errorOnExist:true};copy(src,dest,opts,(err=>{if(err)return cb(err);return remove(src,cb)}))}module.exports=move},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var yaml=__webpack_require__(70);module.exports=yaml},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var loader=__webpack_require__(71);var dumper=__webpack_require__(100);function deprecated(name){return function(){throw new Error("Function "+name+" is deprecated and cannot be used.")}}module.exports.Type=__webpack_require__(77);module.exports.Schema=__webpack_require__(76);module.exports.FAILSAFE_SCHEMA=__webpack_require__(80);module.exports.JSON_SCHEMA=__webpack_require__(79);module.exports.CORE_SCHEMA=__webpack_require__(78);module.exports.DEFAULT_SAFE_SCHEMA=__webpack_require__(75);module.exports.DEFAULT_FULL_SCHEMA=__webpack_require__(95);module.exports.load=loader.load;module.exports.loadAll=loader.loadAll;module.exports.safeLoad=loader.safeLoad;module.exports.safeLoadAll=loader.safeLoadAll;module.exports.dump=dumper.dump;module.exports.safeDump=dumper.safeDump;module.exports.YAMLException=__webpack_require__(73);module.exports.MINIMAL_SCHEMA=__webpack_require__(80);module.exports.SAFE_SCHEMA=__webpack_require__(75);module.exports.DEFAULT_SCHEMA=__webpack_require__(95);module.exports.scan=deprecated("scan");module.exports.parse=deprecated("parse");module.exports.compose=deprecated("compose");module.exports.addConstructor=deprecated("addConstructor")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);var YAMLException=__webpack_require__(73);var Mark=__webpack_require__(74);var DEFAULT_SAFE_SCHEMA=__webpack_require__(75);var DEFAULT_FULL_SCHEMA=__webpack_require__(95);var _hasOwnProperty=Object.prototype.hasOwnProperty;var CONTEXT_FLOW_IN=1;var CONTEXT_FLOW_OUT=2;var CONTEXT_BLOCK_IN=3;var CONTEXT_BLOCK_OUT=4;var CHOMPING_CLIP=1;var CHOMPING_STRIP=2;var CHOMPING_KEEP=3;var PATTERN_NON_PRINTABLE=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;var PATTERN_NON_ASCII_LINE_BREAKS=/[\x85\u2028\u2029]/;var PATTERN_FLOW_INDICATORS=/[,\[\]\{\}]/;var PATTERN_TAG_HANDLE=/^(?:!|!!|![a-z\-]+!)$/i;var PATTERN_TAG_URI=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function _class(obj){return Object.prototype.toString.call(obj)}function is_EOL(c){return c===10||c===13}function is_WHITE_SPACE(c){return c===9||c===32}function is_WS_OR_EOL(c){return c===9||c===32||c===10||c===13}function is_FLOW_INDICATOR(c){return c===44||c===91||c===93||c===123||c===125}function fromHexCode(c){var lc;if(48<=c&&c<=57){return c-48}lc=c|32;if(97<=lc&&lc<=102){return lc-97+10}return-1}function escapedHexLen(c){if(c===120){return 2}if(c===117){return 4}if(c===85){return 8}return 0}function fromDecimalCode(c){if(48<=c&&c<=57){return c-48}return-1}function simpleEscapeSequence(c){return c===48?"\0":c===97?"":c===98?"\b":c===116?"\t":c===9?"\t":c===110?"\n":c===118?"\v":c===102?"\f":c===114?"\r":c===101?"":c===32?" ":c===34?'"':c===47?"/":c===92?"\\":c===78?"":c===95?" ":c===76?"\u2028":c===80?"\u2029":""}function charFromCodepoint(c){if(c<=65535){return String.fromCharCode(c)}return String.fromCharCode((c-65536>>10)+55296,(c-65536&1023)+56320)}var simpleEscapeCheck=new Array(256);var simpleEscapeMap=new Array(256);for(var i=0;i<256;i++){simpleEscapeCheck[i]=simpleEscapeSequence(i)?1:0;simpleEscapeMap[i]=simpleEscapeSequence(i)}function State(input,options){this.input=input;this.filename=options["filename"]||null;this.schema=options["schema"]||DEFAULT_FULL_SCHEMA;this.onWarning=options["onWarning"]||null;this.legacy=options["legacy"]||false;this.json=options["json"]||false;this.listener=options["listener"]||null;this.implicitTypes=this.schema.compiledImplicit;this.typeMap=this.schema.compiledTypeMap;this.length=input.length;this.position=0;this.line=0;this.lineStart=0;this.lineIndent=0;this.documents=[]}function generateError(state,message){return new YAMLException(message,new Mark(state.filename,state.input,state.position,state.line,state.position-state.lineStart))}function throwError(state,message){throw generateError(state,message)}function throwWarning(state,message){if(state.onWarning){state.onWarning.call(null,generateError(state,message))}}var directiveHandlers={YAML:function handleYamlDirective(state,name,args){var match,major,minor;if(state.version!==null){throwError(state,"duplication of %YAML directive")}if(args.length!==1){throwError(state,"YAML directive accepts exactly one argument")}match=/^([0-9]+)\.([0-9]+)$/.exec(args[0]);if(match===null){throwError(state,"ill-formed argument of the YAML directive")}major=parseInt(match[1],10);minor=parseInt(match[2],10);if(major!==1){throwError(state,"unacceptable YAML version of the document")}state.version=args[0];state.checkLineBreaks=minor<2;if(minor!==1&&minor!==2){throwWarning(state,"unsupported YAML version of the document")}},TAG:function handleTagDirective(state,name,args){var handle,prefix;if(args.length!==2){throwError(state,"TAG directive accepts exactly two arguments")}handle=args[0];prefix=args[1];if(!PATTERN_TAG_HANDLE.test(handle)){throwError(state,"ill-formed tag handle (first argument) of the TAG directive")}if(_hasOwnProperty.call(state.tagMap,handle)){throwError(state,'there is a previously declared suffix for "'+handle+'" tag handle')}if(!PATTERN_TAG_URI.test(prefix)){throwError(state,"ill-formed tag prefix (second argument) of the TAG directive")}state.tagMap[handle]=prefix}};function captureSegment(state,start,end,checkJson){var _position,_length,_character,_result;if(start<end){_result=state.input.slice(start,end);if(checkJson){for(_position=0,_length=_result.length;_position<_length;_position+=1){_character=_result.charCodeAt(_position);if(!(_character===9||32<=_character&&_character<=1114111)){throwError(state,"expected valid JSON character")}}}else if(PATTERN_NON_PRINTABLE.test(_result)){throwError(state,"the stream contains non-printable characters")}state.result+=_result}}function mergeMappings(state,destination,source,overridableKeys){var sourceKeys,key,index,quantity;if(!common.isObject(source)){throwError(state,"cannot merge mappings; the provided source object is unacceptable")}sourceKeys=Object.keys(source);for(index=0,quantity=sourceKeys.length;index<quantity;index+=1){key=sourceKeys[index];if(!_hasOwnProperty.call(destination,key)){destination[key]=source[key];overridableKeys[key]=true}}}function storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode,startLine,startPos){var index,quantity;if(Array.isArray(keyNode)){keyNode=Array.prototype.slice.call(keyNode);for(index=0,quantity=keyNode.length;index<quantity;index+=1){if(Array.isArray(keyNode[index])){throwError(state,"nested arrays are not supported inside keys")}if(typeof keyNode==="object"&&_class(keyNode[index])==="[object Object]"){keyNode[index]="[object Object]"}}}if(typeof keyNode==="object"&&_class(keyNode)==="[object Object]"){keyNode="[object Object]"}keyNode=String(keyNode);if(_result===null){_result={}}if(keyTag==="tag:yaml.org,2002:merge"){if(Array.isArray(valueNode)){for(index=0,quantity=valueNode.length;index<quantity;index+=1){mergeMappings(state,_result,valueNode[index],overridableKeys)}}else{mergeMappings(state,_result,valueNode,overridableKeys)}}else{if(!state.json&&!_hasOwnProperty.call(overridableKeys,keyNode)&&_hasOwnProperty.call(_result,keyNode)){state.line=startLine||state.line;state.position=startPos||state.position;throwError(state,"duplicated mapping key")}_result[keyNode]=valueNode;delete overridableKeys[keyNode]}return _result}function readLineBreak(state){var ch;ch=state.input.charCodeAt(state.position);if(ch===10){state.position++}else if(ch===13){state.position++;if(state.input.charCodeAt(state.position)===10){state.position++}}else{throwError(state,"a line break is expected")}state.line+=1;state.lineStart=state.position}function skipSeparationSpace(state,allowComments,checkIndent){var lineBreaks=0,ch=state.input.charCodeAt(state.position);while(ch!==0){while(is_WHITE_SPACE(ch)){ch=state.input.charCodeAt(++state.position)}if(allowComments&&ch===35){do{ch=state.input.charCodeAt(++state.position)}while(ch!==10&&ch!==13&&ch!==0)}if(is_EOL(ch)){readLineBreak(state);ch=state.input.charCodeAt(state.position);lineBreaks++;state.lineIndent=0;while(ch===32){state.lineIndent++;ch=state.input.charCodeAt(++state.position)}}else{break}}if(checkIndent!==-1&&lineBreaks!==0&&state.lineIndent<checkIndent){throwWarning(state,"deficient indentation")}return lineBreaks}function testDocumentSeparator(state){var _position=state.position,ch;ch=state.input.charCodeAt(_position);if((ch===45||ch===46)&&ch===state.input.charCodeAt(_position+1)&&ch===state.input.charCodeAt(_position+2)){_position+=3;ch=state.input.charCodeAt(_position);if(ch===0||is_WS_OR_EOL(ch)){return true}}return false}function writeFoldedLines(state,count){if(count===1){state.result+=" "}else if(count>1){state.result+=common.repeat("\n",count-1)}}function readPlainScalar(state,nodeIndent,withinFlowCollection){var preceding,following,captureStart,captureEnd,hasPendingContent,_line,_lineStart,_lineIndent,_kind=state.kind,_result=state.result,ch;ch=state.input.charCodeAt(state.position);if(is_WS_OR_EOL(ch)||is_FLOW_INDICATOR(ch)||ch===35||ch===38||ch===42||ch===33||ch===124||ch===62||ch===39||ch===34||ch===37||ch===64||ch===96){return false}if(ch===63||ch===45){following=state.input.charCodeAt(state.position+1);if(is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following)){return false}}state.kind="scalar";state.result="";captureStart=captureEnd=state.position;hasPendingContent=false;while(ch!==0){if(ch===58){following=state.input.charCodeAt(state.position+1);if(is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following)){break}}else if(ch===35){preceding=state.input.charCodeAt(state.position-1);if(is_WS_OR_EOL(preceding)){break}}else if(state.position===state.lineStart&&testDocumentSeparator(state)||withinFlowCollection&&is_FLOW_INDICATOR(ch)){break}else if(is_EOL(ch)){_line=state.line;_lineStart=state.lineStart;_lineIndent=state.lineIndent;skipSeparationSpace(state,false,-1);if(state.lineIndent>=nodeIndent){hasPendingContent=true;ch=state.input.charCodeAt(state.position);continue}else{state.position=captureEnd;state.line=_line;state.lineStart=_lineStart;state.lineIndent=_lineIndent;break}}if(hasPendingContent){captureSegment(state,captureStart,captureEnd,false);writeFoldedLines(state,state.line-_line);captureStart=captureEnd=state.position;hasPendingContent=false}if(!is_WHITE_SPACE(ch)){captureEnd=state.position+1}ch=state.input.charCodeAt(++state.position)}captureSegment(state,captureStart,captureEnd,false);if(state.result){return true}state.kind=_kind;state.result=_result;return false}function readSingleQuotedScalar(state,nodeIndent){var ch,captureStart,captureEnd;ch=state.input.charCodeAt(state.position);if(ch!==39){return false}state.kind="scalar";state.result="";state.position++;captureStart=captureEnd=state.position;while((ch=state.input.charCodeAt(state.position))!==0){if(ch===39){captureSegment(state,captureStart,state.position,true);ch=state.input.charCodeAt(++state.position);if(ch===39){captureStart=state.position;state.position++;captureEnd=state.position}else{return true}}else if(is_EOL(ch)){captureSegment(state,captureStart,captureEnd,true);writeFoldedLines(state,skipSeparationSpace(state,false,nodeIndent));captureStart=captureEnd=state.position}else if(state.position===state.lineStart&&testDocumentSeparator(state)){throwError(state,"unexpected end of the document within a single quoted scalar")}else{state.position++;captureEnd=state.position}}throwError(state,"unexpected end of the stream within a single quoted scalar")}function readDoubleQuotedScalar(state,nodeIndent){var captureStart,captureEnd,hexLength,hexResult,tmp,ch;ch=state.input.charCodeAt(state.position);if(ch!==34){return false}state.kind="scalar";state.result="";state.position++;captureStart=captureEnd=state.position;while((ch=state.input.charCodeAt(state.position))!==0){if(ch===34){captureSegment(state,captureStart,state.position,true);state.position++;return true}else if(ch===92){captureSegment(state,captureStart,state.position,true);ch=state.input.charCodeAt(++state.position);if(is_EOL(ch)){skipSeparationSpace(state,false,nodeIndent)}else if(ch<256&&simpleEscapeCheck[ch]){state.result+=simpleEscapeMap[ch];state.position++}else if((tmp=escapedHexLen(ch))>0){hexLength=tmp;hexResult=0;for(;hexLength>0;hexLength--){ch=state.input.charCodeAt(++state.position);if((tmp=fromHexCode(ch))>=0){hexResult=(hexResult<<4)+tmp}else{throwError(state,"expected hexadecimal character")}}state.result+=charFromCodepoint(hexResult);state.position++}else{throwError(state,"unknown escape sequence")}captureStart=captureEnd=state.position}else if(is_EOL(ch)){captureSegment(state,captureStart,captureEnd,true);writeFoldedLines(state,skipSeparationSpace(state,false,nodeIndent));captureStart=captureEnd=state.position}else if(state.position===state.lineStart&&testDocumentSeparator(state)){throwError(state,"unexpected end of the document within a double quoted scalar")}else{state.position++;captureEnd=state.position}}throwError(state,"unexpected end of the stream within a double quoted scalar")}function readFlowCollection(state,nodeIndent){var readNext=true,_line,_tag=state.tag,_result,_anchor=state.anchor,following,terminator,isPair,isExplicitPair,isMapping,overridableKeys={},keyNode,keyTag,valueNode,ch;ch=state.input.charCodeAt(state.position);if(ch===91){terminator=93;isMapping=false;_result=[]}else if(ch===123){terminator=125;isMapping=true;_result={}}else{return false}if(state.anchor!==null){state.anchorMap[state.anchor]=_result}ch=state.input.charCodeAt(++state.position);while(ch!==0){skipSeparationSpace(state,true,nodeIndent);ch=state.input.charCodeAt(state.position);if(ch===terminator){state.position++;state.tag=_tag;state.anchor=_anchor;state.kind=isMapping?"mapping":"sequence";state.result=_result;return true}else if(!readNext){throwError(state,"missed comma between flow collection entries")}keyTag=keyNode=valueNode=null;isPair=isExplicitPair=false;if(ch===63){following=state.input.charCodeAt(state.position+1);if(is_WS_OR_EOL(following)){isPair=isExplicitPair=true;state.position++;skipSeparationSpace(state,true,nodeIndent)}}_line=state.line;composeNode(state,nodeIndent,CONTEXT_FLOW_IN,false,true);keyTag=state.tag;keyNode=state.result;skipSeparationSpace(state,true,nodeIndent);ch=state.input.charCodeAt(state.position);if((isExplicitPair||state.line===_line)&&ch===58){isPair=true;ch=state.input.charCodeAt(++state.position);skipSeparationSpace(state,true,nodeIndent);composeNode(state,nodeIndent,CONTEXT_FLOW_IN,false,true);valueNode=state.result}if(isMapping){storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode)}else if(isPair){_result.push(storeMappingPair(state,null,overridableKeys,keyTag,keyNode,valueNode))}else{_result.push(keyNode)}skipSeparationSpace(state,true,nodeIndent);ch=state.input.charCodeAt(state.position);if(ch===44){readNext=true;ch=state.input.charCodeAt(++state.position)}else{readNext=false}}throwError(state,"unexpected end of the stream within a flow collection")}function readBlockScalar(state,nodeIndent){var captureStart,folding,chomping=CHOMPING_CLIP,didReadContent=false,detectedIndent=false,textIndent=nodeIndent,emptyLines=0,atMoreIndented=false,tmp,ch;ch=state.input.charCodeAt(state.position);if(ch===124){folding=false}else if(ch===62){folding=true}else{return false}state.kind="scalar";state.result="";while(ch!==0){ch=state.input.charCodeAt(++state.position);if(ch===43||ch===45){if(CHOMPING_CLIP===chomping){chomping=ch===43?CHOMPING_KEEP:CHOMPING_STRIP}else{throwError(state,"repeat of a chomping mode identifier")}}else if((tmp=fromDecimalCode(ch))>=0){if(tmp===0){throwError(state,"bad explicit indentation width of a block scalar; it cannot be less than one")}else if(!detectedIndent){textIndent=nodeIndent+tmp-1;detectedIndent=true}else{throwError(state,"repeat of an indentation width identifier")}}else{break}}if(is_WHITE_SPACE(ch)){do{ch=state.input.charCodeAt(++state.position)}while(is_WHITE_SPACE(ch));if(ch===35){do{ch=state.input.charCodeAt(++state.position)}while(!is_EOL(ch)&&ch!==0)}}while(ch!==0){readLineBreak(state);state.lineIndent=0;ch=state.input.charCodeAt(state.position);while((!detectedIndent||state.lineIndent<textIndent)&&ch===32){state.lineIndent++;ch=state.input.charCodeAt(++state.position)}if(!detectedIndent&&state.lineIndent>textIndent){textIndent=state.lineIndent}if(is_EOL(ch)){emptyLines++;continue}if(state.lineIndent<textIndent){if(chomping===CHOMPING_KEEP){state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines)}else if(chomping===CHOMPING_CLIP){if(didReadContent){state.result+="\n"}}break}if(folding){if(is_WHITE_SPACE(ch)){atMoreIndented=true;state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines)}else if(atMoreIndented){atMoreIndented=false;state.result+=common.repeat("\n",emptyLines+1)}else if(emptyLines===0){if(didReadContent){state.result+=" "}}else{state.result+=common.repeat("\n",emptyLines)}}else{state.result+=common.repeat("\n",didReadContent?1+emptyLines:emptyLines)}didReadContent=true;detectedIndent=true;emptyLines=0;captureStart=state.position;while(!is_EOL(ch)&&ch!==0){ch=state.input.charCodeAt(++state.position)}captureSegment(state,captureStart,state.position,false)}return true}function readBlockSequence(state,nodeIndent){var _line,_tag=state.tag,_anchor=state.anchor,_result=[],following,detected=false,ch;if(state.anchor!==null){state.anchorMap[state.anchor]=_result}ch=state.input.charCodeAt(state.position);while(ch!==0){if(ch!==45){break}following=state.input.charCodeAt(state.position+1);if(!is_WS_OR_EOL(following)){break}detected=true;state.position++;if(skipSeparationSpace(state,true,-1)){if(state.lineIndent<=nodeIndent){_result.push(null);ch=state.input.charCodeAt(state.position);continue}}_line=state.line;composeNode(state,nodeIndent,CONTEXT_BLOCK_IN,false,true);_result.push(state.result);skipSeparationSpace(state,true,-1);ch=state.input.charCodeAt(state.position);if((state.line===_line||state.lineIndent>nodeIndent)&&ch!==0){throwError(state,"bad indentation of a sequence entry")}else if(state.lineIndent<nodeIndent){break}}if(detected){state.tag=_tag;state.anchor=_anchor;state.kind="sequence";state.result=_result;return true}return false}function readBlockMapping(state,nodeIndent,flowIndent){var following,allowCompact,_line,_pos,_tag=state.tag,_anchor=state.anchor,_result={},overridableKeys={},keyTag=null,keyNode=null,valueNode=null,atExplicitKey=false,detected=false,ch;if(state.anchor!==null){state.anchorMap[state.anchor]=_result}ch=state.input.charCodeAt(state.position);while(ch!==0){following=state.input.charCodeAt(state.position+1);_line=state.line;_pos=state.position;if((ch===63||ch===58)&&is_WS_OR_EOL(following)){if(ch===63){if(atExplicitKey){storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null);keyTag=keyNode=valueNode=null}detected=true;atExplicitKey=true;allowCompact=true}else if(atExplicitKey){atExplicitKey=false;allowCompact=true}else{throwError(state,"incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line")}state.position+=1;ch=following}else if(composeNode(state,flowIndent,CONTEXT_FLOW_OUT,false,true)){if(state.line===_line){ch=state.input.charCodeAt(state.position);while(is_WHITE_SPACE(ch)){ch=state.input.charCodeAt(++state.position)}if(ch===58){ch=state.input.charCodeAt(++state.position);if(!is_WS_OR_EOL(ch)){throwError(state,"a whitespace character is expected after the key-value separator within a block mapping")}if(atExplicitKey){storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null);keyTag=keyNode=valueNode=null}detected=true;atExplicitKey=false;allowCompact=false;keyTag=state.tag;keyNode=state.result}else if(detected){throwError(state,"can not read an implicit mapping pair; a colon is missed")}else{state.tag=_tag;state.anchor=_anchor;return true}}else if(detected){throwError(state,"can not read a block mapping entry; a multiline key may not be an implicit key")}else{state.tag=_tag;state.anchor=_anchor;return true}}else{break}if(state.line===_line||state.lineIndent>nodeIndent){if(composeNode(state,nodeIndent,CONTEXT_BLOCK_OUT,true,allowCompact)){if(atExplicitKey){keyNode=state.result}else{valueNode=state.result}}if(!atExplicitKey){storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,valueNode,_line,_pos);keyTag=keyNode=valueNode=null}skipSeparationSpace(state,true,-1);ch=state.input.charCodeAt(state.position)}if(state.lineIndent>nodeIndent&&ch!==0){throwError(state,"bad indentation of a mapping entry")}else if(state.lineIndent<nodeIndent){break}}if(atExplicitKey){storeMappingPair(state,_result,overridableKeys,keyTag,keyNode,null)}if(detected){state.tag=_tag;state.anchor=_anchor;state.kind="mapping";state.result=_result}return detected}function readTagProperty(state){var _position,isVerbatim=false,isNamed=false,tagHandle,tagName,ch;ch=state.input.charCodeAt(state.position);if(ch!==33)return false;if(state.tag!==null){throwError(state,"duplication of a tag property")}ch=state.input.charCodeAt(++state.position);if(ch===60){isVerbatim=true;ch=state.input.charCodeAt(++state.position)}else if(ch===33){isNamed=true;tagHandle="!!";ch=state.input.charCodeAt(++state.position)}else{tagHandle="!"}_position=state.position;if(isVerbatim){do{ch=state.input.charCodeAt(++state.position)}while(ch!==0&&ch!==62);if(state.position<state.length){tagName=state.input.slice(_position,state.position);ch=state.input.charCodeAt(++state.position)}else{throwError(state,"unexpected end of the stream within a verbatim tag")}}else{while(ch!==0&&!is_WS_OR_EOL(ch)){if(ch===33){if(!isNamed){tagHandle=state.input.slice(_position-1,state.position+1);if(!PATTERN_TAG_HANDLE.test(tagHandle)){throwError(state,"named tag handle cannot contain such characters")}isNamed=true;_position=state.position+1}else{throwError(state,"tag suffix cannot contain exclamation marks")}}ch=state.input.charCodeAt(++state.position)}tagName=state.input.slice(_position,state.position);if(PATTERN_FLOW_INDICATORS.test(tagName)){throwError(state,"tag suffix cannot contain flow indicator characters")}}if(tagName&&!PATTERN_TAG_URI.test(tagName)){throwError(state,"tag name cannot contain such characters: "+tagName)}if(isVerbatim){state.tag=tagName}else if(_hasOwnProperty.call(state.tagMap,tagHandle)){state.tag=state.tagMap[tagHandle]+tagName}else if(tagHandle==="!"){state.tag="!"+tagName}else if(tagHandle==="!!"){state.tag="tag:yaml.org,2002:"+tagName}else{throwError(state,'undeclared tag handle "'+tagHandle+'"')}return true}function readAnchorProperty(state){var _position,ch;ch=state.input.charCodeAt(state.position);if(ch!==38)return false;if(state.anchor!==null){throwError(state,"duplication of an anchor property")}ch=state.input.charCodeAt(++state.position);_position=state.position;while(ch!==0&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch)){ch=state.input.charCodeAt(++state.position)}if(state.position===_position){throwError(state,"name of an anchor node must contain at least one character")}state.anchor=state.input.slice(_position,state.position);return true}function readAlias(state){var _position,alias,ch;ch=state.input.charCodeAt(state.position);if(ch!==42)return false;ch=state.input.charCodeAt(++state.position);_position=state.position;while(ch!==0&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch)){ch=state.input.charCodeAt(++state.position)}if(state.position===_position){throwError(state,"name of an alias node must contain at least one character")}alias=state.input.slice(_position,state.position);if(!_hasOwnProperty.call(state.anchorMap,alias)){throwError(state,'unidentified alias "'+alias+'"')}state.result=state.anchorMap[alias];skipSeparationSpace(state,true,-1);return true}function composeNode(state,parentIndent,nodeContext,allowToSeek,allowCompact){var allowBlockStyles,allowBlockScalars,allowBlockCollections,indentStatus=1,atNewLine=false,hasContent=false,typeIndex,typeQuantity,type,flowIndent,blockIndent;if(state.listener!==null){state.listener("open",state)}state.tag=null;state.anchor=null;state.kind=null;state.result=null;allowBlockStyles=allowBlockScalars=allowBlockCollections=CONTEXT_BLOCK_OUT===nodeContext||CONTEXT_BLOCK_IN===nodeContext;if(allowToSeek){if(skipSeparationSpace(state,true,-1)){atNewLine=true;if(state.lineIndent>parentIndent){indentStatus=1}else if(state.lineIndent===parentIndent){indentStatus=0}else if(state.lineIndent<parentIndent){indentStatus=-1}}}if(indentStatus===1){while(readTagProperty(state)||readAnchorProperty(state)){if(skipSeparationSpace(state,true,-1)){atNewLine=true;allowBlockCollections=allowBlockStyles;if(state.lineIndent>parentIndent){indentStatus=1}else if(state.lineIndent===parentIndent){indentStatus=0}else if(state.lineIndent<parentIndent){indentStatus=-1}}else{allowBlockCollections=false}}}if(allowBlockCollections){allowBlockCollections=atNewLine||allowCompact}if(indentStatus===1||CONTEXT_BLOCK_OUT===nodeContext){if(CONTEXT_FLOW_IN===nodeContext||CONTEXT_FLOW_OUT===nodeContext){flowIndent=parentIndent}else{flowIndent=parentIndent+1}blockIndent=state.position-state.lineStart;if(indentStatus===1){if(allowBlockCollections&&(readBlockSequence(state,blockIndent)||readBlockMapping(state,blockIndent,flowIndent))||readFlowCollection(state,flowIndent)){hasContent=true}else{if(allowBlockScalars&&readBlockScalar(state,flowIndent)||readSingleQuotedScalar(state,flowIndent)||readDoubleQuotedScalar(state,flowIndent)){hasContent=true}else if(readAlias(state)){hasContent=true;if(state.tag!==null||state.anchor!==null){throwError(state,"alias node should not have any properties")}}else if(readPlainScalar(state,flowIndent,CONTEXT_FLOW_IN===nodeContext)){hasContent=true;if(state.tag===null){state.tag="?"}}if(state.anchor!==null){state.anchorMap[state.anchor]=state.result}}}else if(indentStatus===0){hasContent=allowBlockCollections&&readBlockSequence(state,blockIndent)}}if(state.tag!==null&&state.tag!=="!"){if(state.tag==="?"){if(state.result!==null&&state.kind!=="scalar"){throwError(state,'unacceptable node kind for !<?> tag; it should be "scalar", not "'+state.kind+'"')}for(typeIndex=0,typeQuantity=state.implicitTypes.length;typeIndex<typeQuantity;typeIndex+=1){type=state.implicitTypes[typeIndex];if(type.resolve(state.result)){state.result=type.construct(state.result);state.tag=type.tag;if(state.anchor!==null){state.anchorMap[state.anchor]=state.result}break}}}else if(_hasOwnProperty.call(state.typeMap[state.kind||"fallback"],state.tag)){type=state.typeMap[state.kind||"fallback"][state.tag];if(state.result!==null&&type.kind!==state.kind){throwError(state,"unacceptable node kind for !<"+state.tag+'> tag; it should be "'+type.kind+'", not "'+state.kind+'"')}if(!type.resolve(state.result)){throwError(state,"cannot resolve a node with !<"+state.tag+"> explicit tag")}else{state.result=type.construct(state.result);if(state.anchor!==null){state.anchorMap[state.anchor]=state.result}}}else{throwError(state,"unknown tag !<"+state.tag+">")}}if(state.listener!==null){state.listener("close",state)}return state.tag!==null||state.anchor!==null||hasContent}function readDocument(state){var documentStart=state.position,_position,directiveName,directiveArgs,hasDirectives=false,ch;state.version=null;state.checkLineBreaks=state.legacy;state.tagMap={};state.anchorMap={};while((ch=state.input.charCodeAt(state.position))!==0){skipSeparationSpace(state,true,-1);ch=state.input.charCodeAt(state.position);if(state.lineIndent>0||ch!==37){break}hasDirectives=true;ch=state.input.charCodeAt(++state.position);_position=state.position;while(ch!==0&&!is_WS_OR_EOL(ch)){ch=state.input.charCodeAt(++state.position)}directiveName=state.input.slice(_position,state.position);directiveArgs=[];if(directiveName.length<1){throwError(state,"directive name must not be less than one character in length")}while(ch!==0){while(is_WHITE_SPACE(ch)){ch=state.input.charCodeAt(++state.position)}if(ch===35){do{ch=state.input.charCodeAt(++state.position)}while(ch!==0&&!is_EOL(ch));break}if(is_EOL(ch))break;_position=state.position;while(ch!==0&&!is_WS_OR_EOL(ch)){ch=state.input.charCodeAt(++state.position)}directiveArgs.push(state.input.slice(_position,state.position))}if(ch!==0)readLineBreak(state);if(_hasOwnProperty.call(directiveHandlers,directiveName)){directiveHandlers[directiveName](state,directiveName,directiveArgs)}else{throwWarning(state,'unknown document directive "'+directiveName+'"')}}skipSeparationSpace(state,true,-1);if(state.lineIndent===0&&state.input.charCodeAt(state.position)===45&&state.input.charCodeAt(state.position+1)===45&&state.input.charCodeAt(state.position+2)===45){state.position+=3;skipSeparationSpace(state,true,-1)}else if(hasDirectives){throwError(state,"directives end mark is expected")}composeNode(state,state.lineIndent-1,CONTEXT_BLOCK_OUT,false,true);skipSeparationSpace(state,true,-1);if(state.checkLineBreaks&&PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart,state.position))){throwWarning(state,"non-ASCII line breaks are interpreted as content")}state.documents.push(state.result);if(state.position===state.lineStart&&testDocumentSeparator(state)){if(state.input.charCodeAt(state.position)===46){state.position+=3;skipSeparationSpace(state,true,-1)}return}if(state.position<state.length-1){throwError(state,"end of the stream or a document separator is expected")}else{return}}function loadDocuments(input,options){input=String(input);options=options||{};if(input.length!==0){if(input.charCodeAt(input.length-1)!==10&&input.charCodeAt(input.length-1)!==13){input+="\n"}if(input.charCodeAt(0)===65279){input=input.slice(1)}}var state=new State(input,options);var nullpos=input.indexOf("\0");if(nullpos!==-1){state.position=nullpos;throwError(state,"null byte is not allowed in input")}state.input+="\0";while(state.input.charCodeAt(state.position)===32){state.lineIndent+=1;state.position+=1}while(state.position<state.length-1){readDocument(state)}return state.documents}function loadAll(input,iterator,options){if(iterator!==null&&typeof iterator==="object"&&typeof options==="undefined"){options=iterator;iterator=null}var documents=loadDocuments(input,options);if(typeof iterator!=="function"){return documents}for(var index=0,length=documents.length;index<length;index+=1){iterator(documents[index])}}function load(input,options){var documents=loadDocuments(input,options);if(documents.length===0){return undefined}else if(documents.length===1){return documents[0]}throw new YAMLException("expected a single document in the stream, but found more")}function safeLoadAll(input,iterator,options){if(typeof iterator==="object"&&iterator!==null&&typeof options==="undefined"){options=iterator;iterator=null}return loadAll(input,iterator,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}function safeLoad(input,options){return load(input,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}module.exports.loadAll=loadAll;module.exports.load=load;module.exports.safeLoadAll=safeLoadAll;module.exports.safeLoad=safeLoad},module=>{"use strict";function isNothing(subject){return typeof subject==="undefined"||subject===null}function isObject(subject){return typeof subject==="object"&&subject!==null}function toArray(sequence){if(Array.isArray(sequence))return sequence;else if(isNothing(sequence))return[];return[sequence]}function extend(target,source){var index,length,key,sourceKeys;if(source){sourceKeys=Object.keys(source);for(index=0,length=sourceKeys.length;index<length;index+=1){key=sourceKeys[index];target[key]=source[key]}}return target}function repeat(string,count){var result="",cycle;for(cycle=0;cycle<count;cycle+=1){result+=string}return result}function isNegativeZero(number){return number===0&&Number.NEGATIVE_INFINITY===1/number}module.exports.isNothing=isNothing;module.exports.isObject=isObject;module.exports.toArray=toArray;module.exports.repeat=repeat;module.exports.isNegativeZero=isNegativeZero;module.exports.extend=extend},module=>{"use strict";function YAMLException(reason,mark){Error.call(this);this.name="YAMLException";this.reason=reason;this.mark=mark;this.message=(this.reason||"(unknown reason)")+(this.mark?" "+this.mark.toString():"");if(Error.captureStackTrace){Error.captureStackTrace(this,this.constructor)}else{this.stack=(new Error).stack||""}}YAMLException.prototype=Object.create(Error.prototype);YAMLException.prototype.constructor=YAMLException;YAMLException.prototype.toString=function toString(compact){var result=this.name+": ";result+=this.reason||"(unknown reason)";if(!compact&&this.mark){result+=" "+this.mark.toString()}return result};module.exports=YAMLException},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);function Mark(name,buffer,position,line,column){this.name=name;this.buffer=buffer;this.position=position;this.line=line;this.column=column}Mark.prototype.getSnippet=function getSnippet(indent,maxLength){var head,start,tail,end,snippet;if(!this.buffer)return null;indent=indent||4;maxLength=maxLength||75;head="";start=this.position;while(start>0&&"\0\r\n\u2028\u2029".indexOf(this.buffer.charAt(start-1))===-1){start-=1;if(this.position-start>maxLength/2-1){head=" ... ";start+=5;break}}tail="";end=this.position;while(end<this.buffer.length&&"\0\r\n\u2028\u2029".indexOf(this.buffer.charAt(end))===-1){end+=1;if(end-this.position>maxLength/2-1){tail=" ... ";end-=5;break}}snippet=this.buffer.slice(start,end);return common.repeat(" ",indent)+head+snippet+tail+"\n"+common.repeat(" ",indent+this.position-start+head.length)+"^"};Mark.prototype.toString=function toString(compact){var snippet,where="";if(this.name){where+='in "'+this.name+'" '}where+="at line "+(this.line+1)+", column "+(this.column+1);if(!compact){snippet=this.getSnippet();if(snippet){where+=":\n"+snippet}}return where};module.exports=Mark},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Schema=__webpack_require__(76);module.exports=new Schema({include:[__webpack_require__(78)],implicit:[__webpack_require__(88),__webpack_require__(89)],explicit:[__webpack_require__(90),__webpack_require__(92),__webpack_require__(93),__webpack_require__(94)]})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);var YAMLException=__webpack_require__(73);var Type=__webpack_require__(77);function compileList(schema,name,result){var exclude=[];schema.include.forEach((function(includedSchema){result=compileList(includedSchema,name,result)}));schema[name].forEach((function(currentType){result.forEach((function(previousType,previousIndex){if(previousType.tag===currentType.tag&&previousType.kind===currentType.kind){exclude.push(previousIndex)}}));result.push(currentType)}));return result.filter((function(type,index){return exclude.indexOf(index)===-1}))}function compileMap(){var result={scalar:{},sequence:{},mapping:{},fallback:{}},index,length;function collectType(type){result[type.kind][type.tag]=result["fallback"][type.tag]=type}for(index=0,length=arguments.length;index<length;index+=1){arguments[index].forEach(collectType)}return result}function Schema(definition){this.include=definition.include||[];this.implicit=definition.implicit||[];this.explicit=definition.explicit||[];this.implicit.forEach((function(type){if(type.loadKind&&type.loadKind!=="scalar"){throw new YAMLException("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.")}}));this.compiledImplicit=compileList(this,"implicit",[]);this.compiledExplicit=compileList(this,"explicit",[]);this.compiledTypeMap=compileMap(this.compiledImplicit,this.compiledExplicit)}Schema.DEFAULT=null;Schema.create=function createSchema(){var schemas,types;switch(arguments.length){case 1:schemas=Schema.DEFAULT;types=arguments[0];break;case 2:schemas=arguments[0];types=arguments[1];break;default:throw new YAMLException("Wrong number of arguments for Schema.create function")}schemas=common.toArray(schemas);types=common.toArray(types);if(!schemas.every((function(schema){return schema instanceof Schema}))){throw new YAMLException("Specified list of super schemas (or a single Schema object) contains a non-Schema object.")}if(!types.every((function(type){return type instanceof Type}))){throw new YAMLException("Specified list of YAML types (or a single Type object) contains a non-Type object.")}return new Schema({include:schemas,explicit:types})};module.exports=Schema},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var YAMLException=__webpack_require__(73);var TYPE_CONSTRUCTOR_OPTIONS=["kind","resolve","construct","instanceOf","predicate","represent","defaultStyle","styleAliases"];var YAML_NODE_KINDS=["scalar","sequence","mapping"];function compileStyleAliases(map){var result={};if(map!==null){Object.keys(map).forEach((function(style){map[style].forEach((function(alias){result[String(alias)]=style}))}))}return result}function Type(tag,options){options=options||{};Object.keys(options).forEach((function(name){if(TYPE_CONSTRUCTOR_OPTIONS.indexOf(name)===-1){throw new YAMLException('Unknown option "'+name+'" is met in definition of "'+tag+'" YAML type.')}}));this.tag=tag;this.kind=options["kind"]||null;this.resolve=options["resolve"]||function(){return true};this.construct=options["construct"]||function(data){return data};this.instanceOf=options["instanceOf"]||null;this.predicate=options["predicate"]||null;this.represent=options["represent"]||null;this.defaultStyle=options["defaultStyle"]||null;this.styleAliases=compileStyleAliases(options["styleAliases"]||null);if(YAML_NODE_KINDS.indexOf(this.kind)===-1){throw new YAMLException('Unknown kind "'+this.kind+'" is specified for "'+tag+'" YAML type.')}}module.exports=Type},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Schema=__webpack_require__(76);module.exports=new Schema({include:[__webpack_require__(79)]})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Schema=__webpack_require__(76);module.exports=new Schema({include:[__webpack_require__(80)],implicit:[__webpack_require__(84),__webpack_require__(85),__webpack_require__(86),__webpack_require__(87)]})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Schema=__webpack_require__(76);module.exports=new Schema({explicit:[__webpack_require__(81),__webpack_require__(82),__webpack_require__(83)]})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);module.exports=new Type("tag:yaml.org,2002:str",{kind:"scalar",construct:function(data){return data!==null?data:""}})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);module.exports=new Type("tag:yaml.org,2002:seq",{kind:"sequence",construct:function(data){return data!==null?data:[]}})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);module.exports=new Type("tag:yaml.org,2002:map",{kind:"mapping",construct:function(data){return data!==null?data:{}}})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);function resolveYamlNull(data){if(data===null)return true;var max=data.length;return max===1&&data==="~"||max===4&&(data==="null"||data==="Null"||data==="NULL")}function constructYamlNull(){return null}function isNull(object){return object===null}module.exports=new Type("tag:yaml.org,2002:null",{kind:"scalar",resolve:resolveYamlNull,construct:constructYamlNull,predicate:isNull,represent:{canonical:function(){return"~"},lowercase:function(){return"null"},uppercase:function(){return"NULL"},camelcase:function(){return"Null"}},defaultStyle:"lowercase"})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);function resolveYamlBoolean(data){if(data===null)return false;var max=data.length;return max===4&&(data==="true"||data==="True"||data==="TRUE")||max===5&&(data==="false"||data==="False"||data==="FALSE")}function constructYamlBoolean(data){return data==="true"||data==="True"||data==="TRUE"}function isBoolean(object){return Object.prototype.toString.call(object)==="[object Boolean]"}module.exports=new Type("tag:yaml.org,2002:bool",{kind:"scalar",resolve:resolveYamlBoolean,construct:constructYamlBoolean,predicate:isBoolean,represent:{lowercase:function(object){return object?"true":"false"},uppercase:function(object){return object?"TRUE":"FALSE"},camelcase:function(object){return object?"True":"False"}},defaultStyle:"lowercase"})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);var Type=__webpack_require__(77);function isHexCode(c){return 48<=c&&c<=57||65<=c&&c<=70||97<=c&&c<=102}function isOctCode(c){return 48<=c&&c<=55}function isDecCode(c){return 48<=c&&c<=57}function resolveYamlInteger(data){if(data===null)return false;var max=data.length,index=0,hasDigits=false,ch;if(!max)return false;ch=data[index];if(ch==="-"||ch==="+"){ch=data[++index]}if(ch==="0"){if(index+1===max)return true;ch=data[++index];if(ch==="b"){index++;for(;index<max;index++){ch=data[index];if(ch==="_")continue;if(ch!=="0"&&ch!=="1")return false;hasDigits=true}return hasDigits&&ch!=="_"}if(ch==="x"){index++;for(;index<max;index++){ch=data[index];if(ch==="_")continue;if(!isHexCode(data.charCodeAt(index)))return false;hasDigits=true}return hasDigits&&ch!=="_"}for(;index<max;index++){ch=data[index];if(ch==="_")continue;if(!isOctCode(data.charCodeAt(index)))return false;hasDigits=true}return hasDigits&&ch!=="_"}if(ch==="_")return false;for(;index<max;index++){ch=data[index];if(ch==="_")continue;if(ch===":")break;if(!isDecCode(data.charCodeAt(index))){return false}hasDigits=true}if(!hasDigits||ch==="_")return false;if(ch!==":")return true;return/^(:[0-5]?[0-9])+$/.test(data.slice(index))}function constructYamlInteger(data){var value=data,sign=1,ch,base,digits=[];if(value.indexOf("_")!==-1){value=value.replace(/_/g,"")}ch=value[0];if(ch==="-"||ch==="+"){if(ch==="-")sign=-1;value=value.slice(1);ch=value[0]}if(value==="0")return 0;if(ch==="0"){if(value[1]==="b")return sign*parseInt(value.slice(2),2);if(value[1]==="x")return sign*parseInt(value,16);return sign*parseInt(value,8)}if(value.indexOf(":")!==-1){value.split(":").forEach((function(v){digits.unshift(parseInt(v,10))}));value=0;base=1;digits.forEach((function(d){value+=d*base;base*=60}));return sign*value}return sign*parseInt(value,10)}function isInteger(object){return Object.prototype.toString.call(object)==="[object Number]"&&(object%1===0&&!common.isNegativeZero(object))}module.exports=new Type("tag:yaml.org,2002:int",{kind:"scalar",resolve:resolveYamlInteger,construct:constructYamlInteger,predicate:isInteger,represent:{binary:function(obj){return obj>=0?"0b"+obj.toString(2):"-0b"+obj.toString(2).slice(1)},octal:function(obj){return obj>=0?"0"+obj.toString(8):"-0"+obj.toString(8).slice(1)},decimal:function(obj){return obj.toString(10)},hexadecimal:function(obj){return obj>=0?"0x"+obj.toString(16).toUpperCase():"-0x"+obj.toString(16).toUpperCase().slice(1)}},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);var Type=__webpack_require__(77);var YAML_FLOAT_PATTERN=new RegExp("^(?:[-+]?(?:0|[1-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?"+"|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?"+"|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*"+"|[-+]?\\.(?:inf|Inf|INF)"+"|\\.(?:nan|NaN|NAN))$");function resolveYamlFloat(data){if(data===null)return false;if(!YAML_FLOAT_PATTERN.test(data)||data[data.length-1]==="_"){return false}return true}function constructYamlFloat(data){var value,sign,base,digits;value=data.replace(/_/g,"").toLowerCase();sign=value[0]==="-"?-1:1;digits=[];if("+-".indexOf(value[0])>=0){value=value.slice(1)}if(value===".inf"){return sign===1?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY}else if(value===".nan"){return NaN}else if(value.indexOf(":")>=0){value.split(":").forEach((function(v){digits.unshift(parseFloat(v,10))}));value=0;base=1;digits.forEach((function(d){value+=d*base;base*=60}));return sign*value}return sign*parseFloat(value,10)}var SCIENTIFIC_WITHOUT_DOT=/^[-+]?[0-9]+e/;function representYamlFloat(object,style){var res;if(isNaN(object)){switch(style){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}}else if(Number.POSITIVE_INFINITY===object){switch(style){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}}else if(Number.NEGATIVE_INFINITY===object){switch(style){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}}else if(common.isNegativeZero(object)){return"-0.0"}res=object.toString(10);return SCIENTIFIC_WITHOUT_DOT.test(res)?res.replace("e",".e"):res}function isFloat(object){return Object.prototype.toString.call(object)==="[object Number]"&&(object%1!==0||common.isNegativeZero(object))}module.exports=new Type("tag:yaml.org,2002:float",{kind:"scalar",resolve:resolveYamlFloat,construct:constructYamlFloat,predicate:isFloat,represent:representYamlFloat,defaultStyle:"lowercase"})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);var YAML_DATE_REGEXP=new RegExp("^([0-9][0-9][0-9][0-9])"+"-([0-9][0-9])"+"-([0-9][0-9])$");var YAML_TIMESTAMP_REGEXP=new RegExp("^([0-9][0-9][0-9][0-9])"+"-([0-9][0-9]?)"+"-([0-9][0-9]?)"+"(?:[Tt]|[ \\t]+)"+"([0-9][0-9]?)"+":([0-9][0-9])"+":([0-9][0-9])"+"(?:\\.([0-9]*))?"+"(?:[ \\t]*(Z|([-+])([0-9][0-9]?)"+"(?::([0-9][0-9]))?))?$");function resolveYamlTimestamp(data){if(data===null)return false;if(YAML_DATE_REGEXP.exec(data)!==null)return true;if(YAML_TIMESTAMP_REGEXP.exec(data)!==null)return true;return false}function constructYamlTimestamp(data){var match,year,month,day,hour,minute,second,fraction=0,delta=null,tz_hour,tz_minute,date;match=YAML_DATE_REGEXP.exec(data);if(match===null)match=YAML_TIMESTAMP_REGEXP.exec(data);if(match===null)throw new Error("Date resolve error");year=+match[1];month=+match[2]-1;day=+match[3];if(!match[4]){return new Date(Date.UTC(year,month,day))}hour=+match[4];minute=+match[5];second=+match[6];if(match[7]){fraction=match[7].slice(0,3);while(fraction.length<3){fraction+="0"}fraction=+fraction}if(match[9]){tz_hour=+match[10];tz_minute=+(match[11]||0);delta=(tz_hour*60+tz_minute)*6e4;if(match[9]==="-")delta=-delta}date=new Date(Date.UTC(year,month,day,hour,minute,second,fraction));if(delta)date.setTime(date.getTime()-delta);return date}function representYamlTimestamp(object){return object.toISOString()}module.exports=new Type("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:resolveYamlTimestamp,construct:constructYamlTimestamp,instanceOf:Date,represent:representYamlTimestamp})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);function resolveYamlMerge(data){return data==="<<"||data===null}module.exports=new Type("tag:yaml.org,2002:merge",{kind:"scalar",resolve:resolveYamlMerge})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var NodeBuffer;try{var _require=undefined;NodeBuffer=__webpack_require__(91).Buffer}catch(__){}var Type=__webpack_require__(77);var BASE64_MAP="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";function resolveYamlBinary(data){if(data===null)return false;var code,idx,bitlen=0,max=data.length,map=BASE64_MAP;for(idx=0;idx<max;idx++){code=map.indexOf(data.charAt(idx));if(code>64)continue;if(code<0)return false;bitlen+=6}return bitlen%8===0}function constructYamlBinary(data){var idx,tailbits,input=data.replace(/[\r\n=]/g,""),max=input.length,map=BASE64_MAP,bits=0,result=[];for(idx=0;idx<max;idx++){if(idx%4===0&&idx){result.push(bits>>16&255);result.push(bits>>8&255);result.push(bits&255)}bits=bits<<6|map.indexOf(input.charAt(idx))}tailbits=max%4*6;if(tailbits===0){result.push(bits>>16&255);result.push(bits>>8&255);result.push(bits&255)}else if(tailbits===18){result.push(bits>>10&255);result.push(bits>>2&255)}else if(tailbits===12){result.push(bits>>4&255)}if(NodeBuffer){return NodeBuffer.from?NodeBuffer.from(result):new NodeBuffer(result)}return result}function representYamlBinary(object){var result="",bits=0,idx,tail,max=object.length,map=BASE64_MAP;for(idx=0;idx<max;idx++){if(idx%3===0&&idx){result+=map[bits>>18&63];result+=map[bits>>12&63];result+=map[bits>>6&63];result+=map[bits&63]}bits=(bits<<8)+object[idx]}tail=max%3;if(tail===0){result+=map[bits>>18&63];result+=map[bits>>12&63];result+=map[bits>>6&63];result+=map[bits&63]}else if(tail===2){result+=map[bits>>10&63];result+=map[bits>>4&63];result+=map[bits<<2&63];result+=map[64]}else if(tail===1){result+=map[bits>>2&63];result+=map[bits<<4&63];result+=map[64];result+=map[64]}return result}function isBinary(object){return NodeBuffer&&NodeBuffer.isBuffer(object)}module.exports=new Type("tag:yaml.org,2002:binary",{kind:"scalar",resolve:resolveYamlBinary,construct:constructYamlBinary,predicate:isBinary,represent:representYamlBinary})},module=>{"use strict";module.exports=require("buffer")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);var _hasOwnProperty=Object.prototype.hasOwnProperty;var _toString=Object.prototype.toString;function resolveYamlOmap(data){if(data===null)return true;var objectKeys=[],index,length,pair,pairKey,pairHasKey,object=data;for(index=0,length=object.length;index<length;index+=1){pair=object[index];pairHasKey=false;if(_toString.call(pair)!=="[object Object]")return false;for(pairKey in pair){if(_hasOwnProperty.call(pair,pairKey)){if(!pairHasKey)pairHasKey=true;else return false}}if(!pairHasKey)return false;if(objectKeys.indexOf(pairKey)===-1)objectKeys.push(pairKey);else return false}return true}function constructYamlOmap(data){return data!==null?data:[]}module.exports=new Type("tag:yaml.org,2002:omap",{kind:"sequence",resolve:resolveYamlOmap,construct:constructYamlOmap})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);var _toString=Object.prototype.toString;function resolveYamlPairs(data){if(data===null)return true;var index,length,pair,keys,result,object=data;result=new Array(object.length);for(index=0,length=object.length;index<length;index+=1){pair=object[index];if(_toString.call(pair)!=="[object Object]")return false;keys=Object.keys(pair);if(keys.length!==1)return false;result[index]=[keys[0],pair[keys[0]]]}return true}function constructYamlPairs(data){if(data===null)return[];var index,length,pair,keys,result,object=data;result=new Array(object.length);for(index=0,length=object.length;index<length;index+=1){pair=object[index];keys=Object.keys(pair);result[index]=[keys[0],pair[keys[0]]]}return result}module.exports=new Type("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:resolveYamlPairs,construct:constructYamlPairs})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);var _hasOwnProperty=Object.prototype.hasOwnProperty;function resolveYamlSet(data){if(data===null)return true;var key,object=data;for(key in object){if(_hasOwnProperty.call(object,key)){if(object[key]!==null)return false}}return true}function constructYamlSet(data){return data!==null?data:{}}module.exports=new Type("tag:yaml.org,2002:set",{kind:"mapping",resolve:resolveYamlSet,construct:constructYamlSet})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Schema=__webpack_require__(76);module.exports=Schema.DEFAULT=new Schema({include:[__webpack_require__(75)],explicit:[__webpack_require__(96),__webpack_require__(97),__webpack_require__(98)]})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);function resolveJavascriptUndefined(){return true}function constructJavascriptUndefined(){return undefined}function representJavascriptUndefined(){return""}function isUndefined(object){return typeof object==="undefined"}module.exports=new Type("tag:yaml.org,2002:js/undefined",{kind:"scalar",resolve:resolveJavascriptUndefined,construct:constructJavascriptUndefined,predicate:isUndefined,represent:representJavascriptUndefined})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Type=__webpack_require__(77);function resolveJavascriptRegExp(data){if(data===null)return false;if(data.length===0)return false;var regexp=data,tail=/\/([gim]*)$/.exec(data),modifiers="";if(regexp[0]==="/"){if(tail)modifiers=tail[1];if(modifiers.length>3)return false;if(regexp[regexp.length-modifiers.length-1]!=="/")return false}return true}function constructJavascriptRegExp(data){var regexp=data,tail=/\/([gim]*)$/.exec(data),modifiers="";if(regexp[0]==="/"){if(tail)modifiers=tail[1];regexp=regexp.slice(1,regexp.length-modifiers.length-1)}return new RegExp(regexp,modifiers)}function representJavascriptRegExp(object){var result="/"+object.source+"/";if(object.global)result+="g";if(object.multiline)result+="m";if(object.ignoreCase)result+="i";return result}function isRegExp(object){return Object.prototype.toString.call(object)==="[object RegExp]"}module.exports=new Type("tag:yaml.org,2002:js/regexp",{kind:"scalar",resolve:resolveJavascriptRegExp,construct:constructJavascriptRegExp,predicate:isRegExp,represent:representJavascriptRegExp})},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var esprima;try{var _require=undefined;esprima=__webpack_require__(99)}catch(_){if(typeof window!=="undefined")esprima=window.esprima}var Type=__webpack_require__(77);function resolveJavascriptFunction(data){if(data===null)return false;try{var source="("+data+")",ast=esprima.parse(source,{range:true});if(ast.type!=="Program"||ast.body.length!==1||ast.body[0].type!=="ExpressionStatement"||ast.body[0].expression.type!=="ArrowFunctionExpression"&&ast.body[0].expression.type!=="FunctionExpression"){return false}return true}catch(err){return false}}function constructJavascriptFunction(data){var source="("+data+")",ast=esprima.parse(source,{range:true}),params=[],body;if(ast.type!=="Program"||ast.body.length!==1||ast.body[0].type!=="ExpressionStatement"||ast.body[0].expression.type!=="ArrowFunctionExpression"&&ast.body[0].expression.type!=="FunctionExpression"){throw new Error("Failed to resolve function")}ast.body[0].expression.params.forEach((function(param){params.push(param.name)}));body=ast.body[0].expression.body.range;if(ast.body[0].expression.body.type==="BlockStatement"){return new Function(params,source.slice(body[0]+1,body[1]-1))}return new Function(params,"return "+source.slice(body[0],body[1]))}function representJavascriptFunction(object){return object.toString()}function isFunction(object){return Object.prototype.toString.call(object)==="[object Function]"}module.exports=new Type("tag:yaml.org,2002:js/function",{kind:"scalar",resolve:resolveJavascriptFunction,construct:constructJavascriptFunction,predicate:isFunction,represent:representJavascriptFunction})},function(module){(function webpackUniversalModuleDefinition(root,factory){if(true)module.exports=factory();else{}})(this,(function(){return function(modules){var installedModules={};function __nested_webpack_require_583__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:false};modules[moduleId].call(module.exports,module,module.exports,__nested_webpack_require_583__);module.loaded=true;return module.exports}__nested_webpack_require_583__.m=modules;__nested_webpack_require_583__.c=installedModules;__nested_webpack_require_583__.p="";return __nested_webpack_require_583__(0)}([function(module,exports,__nested_webpack_require_1808__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var comment_handler_1=__nested_webpack_require_1808__(1);var jsx_parser_1=__nested_webpack_require_1808__(3);var parser_1=__nested_webpack_require_1808__(8);var tokenizer_1=__nested_webpack_require_1808__(15);function parse(code,options,delegate){var commentHandler=null;var proxyDelegate=function(node,metadata){if(delegate){delegate(node,metadata)}if(commentHandler){commentHandler.visit(node,metadata)}};var parserDelegate=typeof delegate==="function"?proxyDelegate:null;var collectComment=false;if(options){collectComment=typeof options.comment==="boolean"&&options.comment;var attachComment=typeof options.attachComment==="boolean"&&options.attachComment;if(collectComment||attachComment){commentHandler=new comment_handler_1.CommentHandler;commentHandler.attach=attachComment;options.comment=true;parserDelegate=proxyDelegate}}var isModule=false;if(options&&typeof options.sourceType==="string"){isModule=options.sourceType==="module"}var parser;if(options&&typeof options.jsx==="boolean"&&options.jsx){parser=new jsx_parser_1.JSXParser(code,options,parserDelegate)}else{parser=new parser_1.Parser(code,options,parserDelegate)}var program=isModule?parser.parseModule():parser.parseScript();var ast=program;if(collectComment&&commentHandler){ast.comments=commentHandler.comments}if(parser.config.tokens){ast.tokens=parser.tokens}if(parser.config.tolerant){ast.errors=parser.errorHandler.errors}return ast}exports.parse=parse;function parseModule(code,options,delegate){var parsingOptions=options||{};parsingOptions.sourceType="module";return parse(code,parsingOptions,delegate)}exports.parseModule=parseModule;function parseScript(code,options,delegate){var parsingOptions=options||{};parsingOptions.sourceType="script";return parse(code,parsingOptions,delegate)}exports.parseScript=parseScript;function tokenize(code,options,delegate){var tokenizer=new tokenizer_1.Tokenizer(code,options);var tokens;tokens=[];try{while(true){var token=tokenizer.getNextToken();if(!token){break}if(delegate){token=delegate(token)}tokens.push(token)}}catch(e){tokenizer.errorHandler.tolerate(e)}if(tokenizer.errorHandler.tolerant){tokens.errors=tokenizer.errors()}return tokens}exports.tokenize=tokenize;var syntax_1=__nested_webpack_require_1808__(2);exports.Syntax=syntax_1.Syntax;exports.version="4.0.1"},function(module,exports,__nested_webpack_require_6456__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var syntax_1=__nested_webpack_require_6456__(2);var CommentHandler=function(){function CommentHandler(){this.attach=false;this.comments=[];this.stack=[];this.leading=[];this.trailing=[]}CommentHandler.prototype.insertInnerComments=function(node,metadata){if(node.type===syntax_1.Syntax.BlockStatement&&node.body.length===0){var innerComments=[];for(var i=this.leading.length-1;i>=0;--i){var entry=this.leading[i];if(metadata.end.offset>=entry.start){innerComments.unshift(entry.comment);this.leading.splice(i,1);this.trailing.splice(i,1)}}if(innerComments.length){node.innerComments=innerComments}}};CommentHandler.prototype.findTrailingComments=function(metadata){var trailingComments=[];if(this.trailing.length>0){for(var i=this.trailing.length-1;i>=0;--i){var entry_1=this.trailing[i];if(entry_1.start>=metadata.end.offset){trailingComments.unshift(entry_1.comment)}}this.trailing.length=0;return trailingComments}var entry=this.stack[this.stack.length-1];if(entry&&entry.node.trailingComments){var firstComment=entry.node.trailingComments[0];if(firstComment&&firstComment.range[0]>=metadata.end.offset){trailingComments=entry.node.trailingComments;delete entry.node.trailingComments}}return trailingComments};CommentHandler.prototype.findLeadingComments=function(metadata){var leadingComments=[];var target;while(this.stack.length>0){var entry=this.stack[this.stack.length-1];if(entry&&entry.start>=metadata.start.offset){target=entry.node;this.stack.pop()}else{break}}if(target){var count=target.leadingComments?target.leadingComments.length:0;for(var i=count-1;i>=0;--i){var comment=target.leadingComments[i];if(comment.range[1]<=metadata.start.offset){leadingComments.unshift(comment);target.leadingComments.splice(i,1)}}if(target.leadingComments&&target.leadingComments.length===0){delete target.leadingComments}return leadingComments}for(var i=this.leading.length-1;i>=0;--i){var entry=this.leading[i];if(entry.start<=metadata.start.offset){leadingComments.unshift(entry.comment);this.leading.splice(i,1)}}return leadingComments};CommentHandler.prototype.visitNode=function(node,metadata){if(node.type===syntax_1.Syntax.Program&&node.body.length>0){return}this.insertInnerComments(node,metadata);var trailingComments=this.findTrailingComments(metadata);var leadingComments=this.findLeadingComments(metadata);if(leadingComments.length>0){node.leadingComments=leadingComments}if(trailingComments.length>0){node.trailingComments=trailingComments}this.stack.push({node,start:metadata.start.offset})};CommentHandler.prototype.visitComment=function(node,metadata){var type=node.type[0]==="L"?"Line":"Block";var comment={type,value:node.value};if(node.range){comment.range=node.range}if(node.loc){comment.loc=node.loc}this.comments.push(comment);if(this.attach){var entry={comment:{type,value:node.value,range:[metadata.start.offset,metadata.end.offset]},start:metadata.start.offset};if(node.loc){entry.comment.loc=node.loc}node.type=type;this.leading.push(entry);this.trailing.push(entry)}};CommentHandler.prototype.visit=function(node,metadata){if(node.type==="LineComment"){this.visitComment(node,metadata)}else if(node.type==="BlockComment"){this.visitComment(node,metadata)}else if(this.attach){this.visitNode(node,metadata)}};return CommentHandler}();exports.CommentHandler=CommentHandler},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Syntax={AssignmentExpression:"AssignmentExpression",AssignmentPattern:"AssignmentPattern",ArrayExpression:"ArrayExpression",ArrayPattern:"ArrayPattern",ArrowFunctionExpression:"ArrowFunctionExpression",AwaitExpression:"AwaitExpression",BlockStatement:"BlockStatement",BinaryExpression:"BinaryExpression",BreakStatement:"BreakStatement",CallExpression:"CallExpression",CatchClause:"CatchClause",ClassBody:"ClassBody",ClassDeclaration:"ClassDeclaration",ClassExpression:"ClassExpression",ConditionalExpression:"ConditionalExpression",ContinueStatement:"ContinueStatement",DoWhileStatement:"DoWhileStatement",DebuggerStatement:"DebuggerStatement",EmptyStatement:"EmptyStatement",ExportAllDeclaration:"ExportAllDeclaration",ExportDefaultDeclaration:"ExportDefaultDeclaration",ExportNamedDeclaration:"ExportNamedDeclaration",ExportSpecifier:"ExportSpecifier",ExpressionStatement:"ExpressionStatement",ForStatement:"ForStatement",ForOfStatement:"ForOfStatement",ForInStatement:"ForInStatement",FunctionDeclaration:"FunctionDeclaration",FunctionExpression:"FunctionExpression",Identifier:"Identifier",IfStatement:"IfStatement",ImportDeclaration:"ImportDeclaration",ImportDefaultSpecifier:"ImportDefaultSpecifier",ImportNamespaceSpecifier:"ImportNamespaceSpecifier",ImportSpecifier:"ImportSpecifier",Literal:"Literal",LabeledStatement:"LabeledStatement",LogicalExpression:"LogicalExpression",MemberExpression:"MemberExpression",MetaProperty:"MetaProperty",MethodDefinition:"MethodDefinition",NewExpression:"NewExpression",ObjectExpression:"ObjectExpression",ObjectPattern:"ObjectPattern",Program:"Program",Property:"Property",RestElement:"RestElement",ReturnStatement:"ReturnStatement",SequenceExpression:"SequenceExpression",SpreadElement:"SpreadElement",Super:"Super",SwitchCase:"SwitchCase",SwitchStatement:"SwitchStatement",TaggedTemplateExpression:"TaggedTemplateExpression",TemplateElement:"TemplateElement",TemplateLiteral:"TemplateLiteral",ThisExpression:"ThisExpression",ThrowStatement:"ThrowStatement",TryStatement:"TryStatement",UnaryExpression:"UnaryExpression",UpdateExpression:"UpdateExpression",VariableDeclaration:"VariableDeclaration",VariableDeclarator:"VariableDeclarator",WhileStatement:"WhileStatement",WithStatement:"WithStatement",YieldExpression:"YieldExpression"}},function(module,exports,__nested_webpack_require_15019__){"use strict";var __extends=this&&this.__extends||function(){var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:true});var character_1=__nested_webpack_require_15019__(4);var JSXNode=__nested_webpack_require_15019__(5);var jsx_syntax_1=__nested_webpack_require_15019__(6);var Node=__nested_webpack_require_15019__(7);var parser_1=__nested_webpack_require_15019__(8);var token_1=__nested_webpack_require_15019__(13);var xhtml_entities_1=__nested_webpack_require_15019__(14);token_1.TokenName[100]="JSXIdentifier";token_1.TokenName[101]="JSXText";function getQualifiedElementName(elementName){var qualifiedName;switch(elementName.type){case jsx_syntax_1.JSXSyntax.JSXIdentifier:var id=elementName;qualifiedName=id.name;break;case jsx_syntax_1.JSXSyntax.JSXNamespacedName:var ns=elementName;qualifiedName=getQualifiedElementName(ns.namespace)+":"+getQualifiedElementName(ns.name);break;case jsx_syntax_1.JSXSyntax.JSXMemberExpression:var expr=elementName;qualifiedName=getQualifiedElementName(expr.object)+"."+getQualifiedElementName(expr.property);break;default:break}return qualifiedName}var JSXParser=function(_super){__extends(JSXParser,_super);function JSXParser(code,options,delegate){return _super.call(this,code,options,delegate)||this}JSXParser.prototype.parsePrimaryExpression=function(){return this.match("<")?this.parseJSXRoot():_super.prototype.parsePrimaryExpression.call(this)};JSXParser.prototype.startJSX=function(){this.scanner.index=this.startMarker.index;this.scanner.lineNumber=this.startMarker.line;this.scanner.lineStart=this.startMarker.index-this.startMarker.column};JSXParser.prototype.finishJSX=function(){this.nextToken()};JSXParser.prototype.reenterJSX=function(){this.startJSX();this.expectJSX("}");if(this.config.tokens){this.tokens.pop()}};JSXParser.prototype.createJSXNode=function(){this.collectComments();return{index:this.scanner.index,line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart}};JSXParser.prototype.createJSXChildNode=function(){return{index:this.scanner.index,line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart}};JSXParser.prototype.scanXHTMLEntity=function(quote){var result="&";var valid=true;var terminated=false;var numeric=false;var hex=false;while(!this.scanner.eof()&&valid&&!terminated){var ch=this.scanner.source[this.scanner.index];if(ch===quote){break}terminated=ch===";";result+=ch;++this.scanner.index;if(!terminated){switch(result.length){case 2:numeric=ch==="#";break;case 3:if(numeric){hex=ch==="x";valid=hex||character_1.Character.isDecimalDigit(ch.charCodeAt(0));numeric=numeric&&!hex}break;default:valid=valid&&!(numeric&&!character_1.Character.isDecimalDigit(ch.charCodeAt(0)));valid=valid&&!(hex&&!character_1.Character.isHexDigit(ch.charCodeAt(0)));break}}}if(valid&&terminated&&result.length>2){var str=result.substr(1,result.length-2);if(numeric&&str.length>1){result=String.fromCharCode(parseInt(str.substr(1),10))}else if(hex&&str.length>2){result=String.fromCharCode(parseInt("0"+str.substr(1),16))}else if(!numeric&&!hex&&xhtml_entities_1.XHTMLEntities[str]){result=xhtml_entities_1.XHTMLEntities[str]}}return result};JSXParser.prototype.lexJSX=function(){var cp=this.scanner.source.charCodeAt(this.scanner.index);if(cp===60||cp===62||cp===47||cp===58||cp===61||cp===123||cp===125){var value=this.scanner.source[this.scanner.index++];return{type:7,value,lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start:this.scanner.index-1,end:this.scanner.index}}if(cp===34||cp===39){var start=this.scanner.index;var quote=this.scanner.source[this.scanner.index++];var str="";while(!this.scanner.eof()){var ch=this.scanner.source[this.scanner.index++];if(ch===quote){break}else if(ch==="&"){str+=this.scanXHTMLEntity(quote)}else{str+=ch}}return{type:8,value:str,lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start,end:this.scanner.index}}if(cp===46){var n1=this.scanner.source.charCodeAt(this.scanner.index+1);var n2=this.scanner.source.charCodeAt(this.scanner.index+2);var value=n1===46&&n2===46?"...":".";var start=this.scanner.index;this.scanner.index+=value.length;return{type:7,value,lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start,end:this.scanner.index}}if(cp===96){return{type:10,value:"",lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start:this.scanner.index,end:this.scanner.index}}if(character_1.Character.isIdentifierStart(cp)&&cp!==92){var start=this.scanner.index;++this.scanner.index;while(!this.scanner.eof()){var ch=this.scanner.source.charCodeAt(this.scanner.index);if(character_1.Character.isIdentifierPart(ch)&&ch!==92){++this.scanner.index}else if(ch===45){++this.scanner.index}else{break}}var id=this.scanner.source.slice(start,this.scanner.index);return{type:100,value:id,lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start,end:this.scanner.index}}return this.scanner.lex()};JSXParser.prototype.nextJSXToken=function(){this.collectComments();this.startMarker.index=this.scanner.index;this.startMarker.line=this.scanner.lineNumber;this.startMarker.column=this.scanner.index-this.scanner.lineStart;var token=this.lexJSX();this.lastMarker.index=this.scanner.index;this.lastMarker.line=this.scanner.lineNumber;this.lastMarker.column=this.scanner.index-this.scanner.lineStart;if(this.config.tokens){this.tokens.push(this.convertToken(token))}return token};JSXParser.prototype.nextJSXText=function(){this.startMarker.index=this.scanner.index;this.startMarker.line=this.scanner.lineNumber;this.startMarker.column=this.scanner.index-this.scanner.lineStart;var start=this.scanner.index;var text="";while(!this.scanner.eof()){var ch=this.scanner.source[this.scanner.index];if(ch==="{"||ch==="<"){break}++this.scanner.index;text+=ch;if(character_1.Character.isLineTerminator(ch.charCodeAt(0))){++this.scanner.lineNumber;if(ch==="\r"&&this.scanner.source[this.scanner.index]==="\n"){++this.scanner.index}this.scanner.lineStart=this.scanner.index}}this.lastMarker.index=this.scanner.index;this.lastMarker.line=this.scanner.lineNumber;this.lastMarker.column=this.scanner.index-this.scanner.lineStart;var token={type:101,value:text,lineNumber:this.scanner.lineNumber,lineStart:this.scanner.lineStart,start,end:this.scanner.index};if(text.length>0&&this.config.tokens){this.tokens.push(this.convertToken(token))}return token};JSXParser.prototype.peekJSXToken=function(){var state=this.scanner.saveState();this.scanner.scanComments();var next=this.lexJSX();this.scanner.restoreState(state);return next};JSXParser.prototype.expectJSX=function(value){var token=this.nextJSXToken();if(token.type!==7||token.value!==value){this.throwUnexpectedToken(token)}};JSXParser.prototype.matchJSX=function(value){var next=this.peekJSXToken();return next.type===7&&next.value===value};JSXParser.prototype.parseJSXIdentifier=function(){var node=this.createJSXNode();var token=this.nextJSXToken();if(token.type!==100){this.throwUnexpectedToken(token)}return this.finalize(node,new JSXNode.JSXIdentifier(token.value))};JSXParser.prototype.parseJSXElementName=function(){var node=this.createJSXNode();var elementName=this.parseJSXIdentifier();if(this.matchJSX(":")){var namespace=elementName;this.expectJSX(":");var name_1=this.parseJSXIdentifier();elementName=this.finalize(node,new JSXNode.JSXNamespacedName(namespace,name_1))}else if(this.matchJSX(".")){while(this.matchJSX(".")){var object=elementName;this.expectJSX(".");var property=this.parseJSXIdentifier();elementName=this.finalize(node,new JSXNode.JSXMemberExpression(object,property))}}return elementName};JSXParser.prototype.parseJSXAttributeName=function(){var node=this.createJSXNode();var attributeName;var identifier=this.parseJSXIdentifier();if(this.matchJSX(":")){var namespace=identifier;this.expectJSX(":");var name_2=this.parseJSXIdentifier();attributeName=this.finalize(node,new JSXNode.JSXNamespacedName(namespace,name_2))}else{attributeName=identifier}return attributeName};JSXParser.prototype.parseJSXStringLiteralAttribute=function(){var node=this.createJSXNode();var token=this.nextJSXToken();if(token.type!==8){this.throwUnexpectedToken(token)}var raw=this.getTokenRaw(token);return this.finalize(node,new Node.Literal(token.value,raw))};JSXParser.prototype.parseJSXExpressionAttribute=function(){var node=this.createJSXNode();this.expectJSX("{");this.finishJSX();if(this.match("}")){this.tolerateError("JSX attributes must only be assigned a non-empty expression")}var expression=this.parseAssignmentExpression();this.reenterJSX();return this.finalize(node,new JSXNode.JSXExpressionContainer(expression))};JSXParser.prototype.parseJSXAttributeValue=function(){return this.matchJSX("{")?this.parseJSXExpressionAttribute():this.matchJSX("<")?this.parseJSXElement():this.parseJSXStringLiteralAttribute()};JSXParser.prototype.parseJSXNameValueAttribute=function(){var node=this.createJSXNode();var name=this.parseJSXAttributeName();var value=null;if(this.matchJSX("=")){this.expectJSX("=");value=this.parseJSXAttributeValue()}return this.finalize(node,new JSXNode.JSXAttribute(name,value))};JSXParser.prototype.parseJSXSpreadAttribute=function(){var node=this.createJSXNode();this.expectJSX("{");this.expectJSX("...");this.finishJSX();var argument=this.parseAssignmentExpression();this.reenterJSX();return this.finalize(node,new JSXNode.JSXSpreadAttribute(argument))};JSXParser.prototype.parseJSXAttributes=function(){var attributes=[];while(!this.matchJSX("/")&&!this.matchJSX(">")){var attribute=this.matchJSX("{")?this.parseJSXSpreadAttribute():this.parseJSXNameValueAttribute();attributes.push(attribute)}return attributes};JSXParser.prototype.parseJSXOpeningElement=function(){var node=this.createJSXNode();this.expectJSX("<");var name=this.parseJSXElementName();var attributes=this.parseJSXAttributes();var selfClosing=this.matchJSX("/");if(selfClosing){this.expectJSX("/")}this.expectJSX(">");return this.finalize(node,new JSXNode.JSXOpeningElement(name,selfClosing,attributes))};JSXParser.prototype.parseJSXBoundaryElement=function(){var node=this.createJSXNode();this.expectJSX("<");if(this.matchJSX("/")){this.expectJSX("/");var name_3=this.parseJSXElementName();this.expectJSX(">");return this.finalize(node,new JSXNode.JSXClosingElement(name_3))}var name=this.parseJSXElementName();var attributes=this.parseJSXAttributes();var selfClosing=this.matchJSX("/");if(selfClosing){this.expectJSX("/")}this.expectJSX(">");return this.finalize(node,new JSXNode.JSXOpeningElement(name,selfClosing,attributes))};JSXParser.prototype.parseJSXEmptyExpression=function(){var node=this.createJSXChildNode();this.collectComments();this.lastMarker.index=this.scanner.index;this.lastMarker.line=this.scanner.lineNumber;this.lastMarker.column=this.scanner.index-this.scanner.lineStart;return this.finalize(node,new JSXNode.JSXEmptyExpression)};JSXParser.prototype.parseJSXExpressionContainer=function(){var node=this.createJSXNode();this.expectJSX("{");var expression;if(this.matchJSX("}")){expression=this.parseJSXEmptyExpression();this.expectJSX("}")}else{this.finishJSX();expression=this.parseAssignmentExpression();this.reenterJSX()}return this.finalize(node,new JSXNode.JSXExpressionContainer(expression))};JSXParser.prototype.parseJSXChildren=function(){var children=[];while(!this.scanner.eof()){var node=this.createJSXChildNode();var token=this.nextJSXText();if(token.start<token.end){var raw=this.getTokenRaw(token);var child=this.finalize(node,new JSXNode.JSXText(token.value,raw));children.push(child)}if(this.scanner.source[this.scanner.index]==="{"){var container=this.parseJSXExpressionContainer();children.push(container)}else{break}}return children};JSXParser.prototype.parseComplexJSXElement=function(el){var stack=[];while(!this.scanner.eof()){el.children=el.children.concat(this.parseJSXChildren());var node=this.createJSXChildNode();var element=this.parseJSXBoundaryElement();if(element.type===jsx_syntax_1.JSXSyntax.JSXOpeningElement){var opening=element;if(opening.selfClosing){var child=this.finalize(node,new JSXNode.JSXElement(opening,[],null));el.children.push(child)}else{stack.push(el);el={node,opening,closing:null,children:[]}}}if(element.type===jsx_syntax_1.JSXSyntax.JSXClosingElement){el.closing=element;var open_1=getQualifiedElementName(el.opening.name);var close_1=getQualifiedElementName(el.closing.name);if(open_1!==close_1){this.tolerateError("Expected corresponding JSX closing tag for %0",open_1)}if(stack.length>0){var child=this.finalize(el.node,new JSXNode.JSXElement(el.opening,el.children,el.closing));el=stack[stack.length-1];el.children.push(child);stack.pop()}else{break}}}return el};JSXParser.prototype.parseJSXElement=function(){var node=this.createJSXNode();var opening=this.parseJSXOpeningElement();var children=[];var closing=null;if(!opening.selfClosing){var el=this.parseComplexJSXElement({node,opening,closing,children});children=el.children;closing=el.closing}return this.finalize(node,new JSXNode.JSXElement(opening,children,closing))};JSXParser.prototype.parseJSXRoot=function(){if(this.config.tokens){this.tokens.pop()}this.startJSX();var element=this.parseJSXElement();this.finishJSX();return element};JSXParser.prototype.isStartOfExpression=function(){return _super.prototype.isStartOfExpression.call(this)||this.match("<")};return JSXParser}(parser_1.Parser);exports.JSXParser=JSXParser},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var Regex={NonAsciiIdentifierStart:/[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]/,NonAsciiIdentifierPart:/[\xAA\xB5\xB7\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B4\u08E3-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0AF9\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D5F-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1369-\u1371\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA8FD\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDCA-\uDDCC\uDDD0-\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE37\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDDD8-\uDDDD\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF39]|\uD806[\uDCA0-\uDCE9\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF]/};exports.Character={fromCodePoint:function(cp){return cp<65536?String.fromCharCode(cp):String.fromCharCode(55296+(cp-65536>>10))+String.fromCharCode(56320+(cp-65536&1023))},isWhiteSpace:function(cp){return cp===32||cp===9||cp===11||cp===12||cp===160||cp>=5760&&[5760,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8239,8287,12288,65279].indexOf(cp)>=0},isLineTerminator:function(cp){return cp===10||cp===13||cp===8232||cp===8233},isIdentifierStart:function(cp){return cp===36||cp===95||cp>=65&&cp<=90||cp>=97&&cp<=122||cp===92||cp>=128&&Regex.NonAsciiIdentifierStart.test(exports.Character.fromCodePoint(cp))},isIdentifierPart:function(cp){return cp===36||cp===95||cp>=65&&cp<=90||cp>=97&&cp<=122||cp>=48&&cp<=57||cp===92||cp>=128&&Regex.NonAsciiIdentifierPart.test(exports.Character.fromCodePoint(cp))},isDecimalDigit:function(cp){return cp>=48&&cp<=57},isHexDigit:function(cp){return cp>=48&&cp<=57||cp>=65&&cp<=70||cp>=97&&cp<=102},isOctalDigit:function(cp){return cp>=48&&cp<=55}}},function(module,exports,__nested_webpack_require_54354__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var jsx_syntax_1=__nested_webpack_require_54354__(6);var JSXClosingElement=function(){function JSXClosingElement(name){this.type=jsx_syntax_1.JSXSyntax.JSXClosingElement;this.name=name}return JSXClosingElement}();exports.JSXClosingElement=JSXClosingElement;var JSXElement=function(){function JSXElement(openingElement,children,closingElement){this.type=jsx_syntax_1.JSXSyntax.JSXElement;this.openingElement=openingElement;this.children=children;this.closingElement=closingElement}return JSXElement}();exports.JSXElement=JSXElement;var JSXEmptyExpression=function(){function JSXEmptyExpression(){this.type=jsx_syntax_1.JSXSyntax.JSXEmptyExpression}return JSXEmptyExpression}();exports.JSXEmptyExpression=JSXEmptyExpression;var JSXExpressionContainer=function(){function JSXExpressionContainer(expression){this.type=jsx_syntax_1.JSXSyntax.JSXExpressionContainer;this.expression=expression}return JSXExpressionContainer}();exports.JSXExpressionContainer=JSXExpressionContainer;var JSXIdentifier=function(){function JSXIdentifier(name){this.type=jsx_syntax_1.JSXSyntax.JSXIdentifier;this.name=name}return JSXIdentifier}();exports.JSXIdentifier=JSXIdentifier;var JSXMemberExpression=function(){function JSXMemberExpression(object,property){this.type=jsx_syntax_1.JSXSyntax.JSXMemberExpression;this.object=object;this.property=property}return JSXMemberExpression}();exports.JSXMemberExpression=JSXMemberExpression;var JSXAttribute=function(){function JSXAttribute(name,value){this.type=jsx_syntax_1.JSXSyntax.JSXAttribute;this.name=name;this.value=value}return JSXAttribute}();exports.JSXAttribute=JSXAttribute;var JSXNamespacedName=function(){function JSXNamespacedName(namespace,name){this.type=jsx_syntax_1.JSXSyntax.JSXNamespacedName;this.namespace=namespace;this.name=name}return JSXNamespacedName}();exports.JSXNamespacedName=JSXNamespacedName;var JSXOpeningElement=function(){function JSXOpeningElement(name,selfClosing,attributes){this.type=jsx_syntax_1.JSXSyntax.JSXOpeningElement;this.name=name;this.selfClosing=selfClosing;this.attributes=attributes}return JSXOpeningElement}();exports.JSXOpeningElement=JSXOpeningElement;var JSXSpreadAttribute=function(){function JSXSpreadAttribute(argument){this.type=jsx_syntax_1.JSXSyntax.JSXSpreadAttribute;this.argument=argument}return JSXSpreadAttribute}();exports.JSXSpreadAttribute=JSXSpreadAttribute;var JSXText=function(){function JSXText(value,raw){this.type=jsx_syntax_1.JSXSyntax.JSXText;this.value=value;this.raw=raw}return JSXText}();exports.JSXText=JSXText},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.JSXSyntax={JSXAttribute:"JSXAttribute",JSXClosingElement:"JSXClosingElement",JSXElement:"JSXElement",JSXEmptyExpression:"JSXEmptyExpression",JSXExpressionContainer:"JSXExpressionContainer",JSXIdentifier:"JSXIdentifier",JSXMemberExpression:"JSXMemberExpression",JSXNamespacedName:"JSXNamespacedName",JSXOpeningElement:"JSXOpeningElement",JSXSpreadAttribute:"JSXSpreadAttribute",JSXText:"JSXText"}},function(module,exports,__nested_webpack_require_58416__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var syntax_1=__nested_webpack_require_58416__(2);var ArrayExpression=function(){function ArrayExpression(elements){this.type=syntax_1.Syntax.ArrayExpression;this.elements=elements}return ArrayExpression}();exports.ArrayExpression=ArrayExpression;var ArrayPattern=function(){function ArrayPattern(elements){this.type=syntax_1.Syntax.ArrayPattern;this.elements=elements}return ArrayPattern}();exports.ArrayPattern=ArrayPattern;var ArrowFunctionExpression=function(){function ArrowFunctionExpression(params,body,expression){this.type=syntax_1.Syntax.ArrowFunctionExpression;this.id=null;this.params=params;this.body=body;this.generator=false;this.expression=expression;this.async=false}return ArrowFunctionExpression}();exports.ArrowFunctionExpression=ArrowFunctionExpression;var AssignmentExpression=function(){function AssignmentExpression(operator,left,right){this.type=syntax_1.Syntax.AssignmentExpression;this.operator=operator;this.left=left;this.right=right}return AssignmentExpression}();exports.AssignmentExpression=AssignmentExpression;var AssignmentPattern=function(){function AssignmentPattern(left,right){this.type=syntax_1.Syntax.AssignmentPattern;this.left=left;this.right=right}return AssignmentPattern}();exports.AssignmentPattern=AssignmentPattern;var AsyncArrowFunctionExpression=function(){function AsyncArrowFunctionExpression(params,body,expression){this.type=syntax_1.Syntax.ArrowFunctionExpression;this.id=null;this.params=params;this.body=body;this.generator=false;this.expression=expression;this.async=true}return AsyncArrowFunctionExpression}();exports.AsyncArrowFunctionExpression=AsyncArrowFunctionExpression;var AsyncFunctionDeclaration=function(){function AsyncFunctionDeclaration(id,params,body){this.type=syntax_1.Syntax.FunctionDeclaration;this.id=id;this.params=params;this.body=body;this.generator=false;this.expression=false;this.async=true}return AsyncFunctionDeclaration}();exports.AsyncFunctionDeclaration=AsyncFunctionDeclaration;var AsyncFunctionExpression=function(){function AsyncFunctionExpression(id,params,body){this.type=syntax_1.Syntax.FunctionExpression;this.id=id;this.params=params;this.body=body;this.generator=false;this.expression=false;this.async=true}return AsyncFunctionExpression}();exports.AsyncFunctionExpression=AsyncFunctionExpression;var AwaitExpression=function(){function AwaitExpression(argument){this.type=syntax_1.Syntax.AwaitExpression;this.argument=argument}return AwaitExpression}();exports.AwaitExpression=AwaitExpression;var BinaryExpression=function(){function BinaryExpression(operator,left,right){var logical=operator==="||"||operator==="&&";this.type=logical?syntax_1.Syntax.LogicalExpression:syntax_1.Syntax.BinaryExpression;this.operator=operator;this.left=left;this.right=right}return BinaryExpression}();exports.BinaryExpression=BinaryExpression;var BlockStatement=function(){function BlockStatement(body){this.type=syntax_1.Syntax.BlockStatement;this.body=body}return BlockStatement}();exports.BlockStatement=BlockStatement;var BreakStatement=function(){function BreakStatement(label){this.type=syntax_1.Syntax.BreakStatement;this.label=label}return BreakStatement}();exports.BreakStatement=BreakStatement;var CallExpression=function(){function CallExpression(callee,args){this.type=syntax_1.Syntax.CallExpression;this.callee=callee;this.arguments=args}return CallExpression}();exports.CallExpression=CallExpression;var CatchClause=function(){function CatchClause(param,body){this.type=syntax_1.Syntax.CatchClause;this.param=param;this.body=body}return CatchClause}();exports.CatchClause=CatchClause;var ClassBody=function(){function ClassBody(body){this.type=syntax_1.Syntax.ClassBody;this.body=body}return ClassBody}();exports.ClassBody=ClassBody;var ClassDeclaration=function(){function ClassDeclaration(id,superClass,body){this.type=syntax_1.Syntax.ClassDeclaration;this.id=id;this.superClass=superClass;this.body=body}return ClassDeclaration}();exports.ClassDeclaration=ClassDeclaration;var ClassExpression=function(){function ClassExpression(id,superClass,body){this.type=syntax_1.Syntax.ClassExpression;this.id=id;this.superClass=superClass;this.body=body}return ClassExpression}();exports.ClassExpression=ClassExpression;var ComputedMemberExpression=function(){function ComputedMemberExpression(object,property){this.type=syntax_1.Syntax.MemberExpression;this.computed=true;this.object=object;this.property=property}return ComputedMemberExpression}();exports.ComputedMemberExpression=ComputedMemberExpression;var ConditionalExpression=function(){function ConditionalExpression(test,consequent,alternate){this.type=syntax_1.Syntax.ConditionalExpression;this.test=test;this.consequent=consequent;this.alternate=alternate}return ConditionalExpression}();exports.ConditionalExpression=ConditionalExpression;var ContinueStatement=function(){function ContinueStatement(label){this.type=syntax_1.Syntax.ContinueStatement;this.label=label}return ContinueStatement}();exports.ContinueStatement=ContinueStatement;var DebuggerStatement=function(){function DebuggerStatement(){this.type=syntax_1.Syntax.DebuggerStatement}return DebuggerStatement}();exports.DebuggerStatement=DebuggerStatement;var Directive=function(){function Directive(expression,directive){this.type=syntax_1.Syntax.ExpressionStatement;this.expression=expression;this.directive=directive}return Directive}();exports.Directive=Directive;var DoWhileStatement=function(){function DoWhileStatement(body,test){this.type=syntax_1.Syntax.DoWhileStatement;this.body=body;this.test=test}return DoWhileStatement}();exports.DoWhileStatement=DoWhileStatement;var EmptyStatement=function(){function EmptyStatement(){this.type=syntax_1.Syntax.EmptyStatement}return EmptyStatement}();exports.EmptyStatement=EmptyStatement;var ExportAllDeclaration=function(){function ExportAllDeclaration(source){this.type=syntax_1.Syntax.ExportAllDeclaration;this.source=source}return ExportAllDeclaration}();exports.ExportAllDeclaration=ExportAllDeclaration;var ExportDefaultDeclaration=function(){function ExportDefaultDeclaration(declaration){this.type=syntax_1.Syntax.ExportDefaultDeclaration;this.declaration=declaration}return ExportDefaultDeclaration}();exports.ExportDefaultDeclaration=ExportDefaultDeclaration;var ExportNamedDeclaration=function(){function ExportNamedDeclaration(declaration,specifiers,source){this.type=syntax_1.Syntax.ExportNamedDeclaration;this.declaration=declaration;this.specifiers=specifiers;this.source=source}return ExportNamedDeclaration}();exports.ExportNamedDeclaration=ExportNamedDeclaration;var ExportSpecifier=function(){function ExportSpecifier(local,exported){this.type=syntax_1.Syntax.ExportSpecifier;this.exported=exported;this.local=local}return ExportSpecifier}();exports.ExportSpecifier=ExportSpecifier;var ExpressionStatement=function(){function ExpressionStatement(expression){this.type=syntax_1.Syntax.ExpressionStatement;this.expression=expression}return ExpressionStatement}();exports.ExpressionStatement=ExpressionStatement;var ForInStatement=function(){function ForInStatement(left,right,body){this.type=syntax_1.Syntax.ForInStatement;this.left=left;this.right=right;this.body=body;this.each=false}return ForInStatement}();exports.ForInStatement=ForInStatement;var ForOfStatement=function(){function ForOfStatement(left,right,body){this.type=syntax_1.Syntax.ForOfStatement;this.left=left;this.right=right;this.body=body}return ForOfStatement}();exports.ForOfStatement=ForOfStatement;var ForStatement=function(){function ForStatement(init,test,update,body){this.type=syntax_1.Syntax.ForStatement;this.init=init;this.test=test;this.update=update;this.body=body}return ForStatement}();exports.ForStatement=ForStatement;var FunctionDeclaration=function(){function FunctionDeclaration(id,params,body,generator){this.type=syntax_1.Syntax.FunctionDeclaration;this.id=id;this.params=params;this.body=body;this.generator=generator;this.expression=false;this.async=false}return FunctionDeclaration}();exports.FunctionDeclaration=FunctionDeclaration;var FunctionExpression=function(){function FunctionExpression(id,params,body,generator){this.type=syntax_1.Syntax.FunctionExpression;this.id=id;this.params=params;this.body=body;this.generator=generator;this.expression=false;this.async=false}return FunctionExpression}();exports.FunctionExpression=FunctionExpression;var Identifier=function(){function Identifier(name){this.type=syntax_1.Syntax.Identifier;this.name=name}return Identifier}();exports.Identifier=Identifier;var IfStatement=function(){function IfStatement(test,consequent,alternate){this.type=syntax_1.Syntax.IfStatement;this.test=test;this.consequent=consequent;this.alternate=alternate}return IfStatement}();exports.IfStatement=IfStatement;var ImportDeclaration=function(){function ImportDeclaration(specifiers,source){this.type=syntax_1.Syntax.ImportDeclaration;this.specifiers=specifiers;this.source=source}return ImportDeclaration}();exports.ImportDeclaration=ImportDeclaration;var ImportDefaultSpecifier=function(){function ImportDefaultSpecifier(local){this.type=syntax_1.Syntax.ImportDefaultSpecifier;this.local=local}return ImportDefaultSpecifier}();exports.ImportDefaultSpecifier=ImportDefaultSpecifier;var ImportNamespaceSpecifier=function(){function ImportNamespaceSpecifier(local){this.type=syntax_1.Syntax.ImportNamespaceSpecifier;this.local=local}return ImportNamespaceSpecifier}();exports.ImportNamespaceSpecifier=ImportNamespaceSpecifier;var ImportSpecifier=function(){function ImportSpecifier(local,imported){this.type=syntax_1.Syntax.ImportSpecifier;this.local=local;this.imported=imported}return ImportSpecifier}();exports.ImportSpecifier=ImportSpecifier;var LabeledStatement=function(){function LabeledStatement(label,body){this.type=syntax_1.Syntax.LabeledStatement;this.label=label;this.body=body}return LabeledStatement}();exports.LabeledStatement=LabeledStatement;var Literal=function(){function Literal(value,raw){this.type=syntax_1.Syntax.Literal;this.value=value;this.raw=raw}return Literal}();exports.Literal=Literal;var MetaProperty=function(){function MetaProperty(meta,property){this.type=syntax_1.Syntax.MetaProperty;this.meta=meta;this.property=property}return MetaProperty}();exports.MetaProperty=MetaProperty;var MethodDefinition=function(){function MethodDefinition(key,computed,value,kind,isStatic){this.type=syntax_1.Syntax.MethodDefinition;this.key=key;this.computed=computed;this.value=value;this.kind=kind;this.static=isStatic}return MethodDefinition}();exports.MethodDefinition=MethodDefinition;var Module=function(){function Module(body){this.type=syntax_1.Syntax.Program;this.body=body;this.sourceType="module"}return Module}();exports.Module=Module;var NewExpression=function(){function NewExpression(callee,args){this.type=syntax_1.Syntax.NewExpression;this.callee=callee;this.arguments=args}return NewExpression}();exports.NewExpression=NewExpression;var ObjectExpression=function(){function ObjectExpression(properties){this.type=syntax_1.Syntax.ObjectExpression;this.properties=properties}return ObjectExpression}();exports.ObjectExpression=ObjectExpression;var ObjectPattern=function(){function ObjectPattern(properties){this.type=syntax_1.Syntax.ObjectPattern;this.properties=properties}return ObjectPattern}();exports.ObjectPattern=ObjectPattern;var Property=function(){function Property(kind,key,computed,value,method,shorthand){this.type=syntax_1.Syntax.Property;this.key=key;this.computed=computed;this.value=value;this.kind=kind;this.method=method;this.shorthand=shorthand}return Property}();exports.Property=Property;var RegexLiteral=function(){function RegexLiteral(value,raw,pattern,flags){this.type=syntax_1.Syntax.Literal;this.value=value;this.raw=raw;this.regex={pattern,flags}}return RegexLiteral}();exports.RegexLiteral=RegexLiteral;var RestElement=function(){function RestElement(argument){this.type=syntax_1.Syntax.RestElement;this.argument=argument}return RestElement}();exports.RestElement=RestElement;var ReturnStatement=function(){function ReturnStatement(argument){this.type=syntax_1.Syntax.ReturnStatement;this.argument=argument}return ReturnStatement}();exports.ReturnStatement=ReturnStatement;var Script=function(){function Script(body){this.type=syntax_1.Syntax.Program;this.body=body;this.sourceType="script"}return Script}();exports.Script=Script;var SequenceExpression=function(){function SequenceExpression(expressions){this.type=syntax_1.Syntax.SequenceExpression;this.expressions=expressions}return SequenceExpression}();exports.SequenceExpression=SequenceExpression;var SpreadElement=function(){function SpreadElement(argument){this.type=syntax_1.Syntax.SpreadElement;this.argument=argument}return SpreadElement}();exports.SpreadElement=SpreadElement;var StaticMemberExpression=function(){function StaticMemberExpression(object,property){this.type=syntax_1.Syntax.MemberExpression;this.computed=false;this.object=object;this.property=property}return StaticMemberExpression}();exports.StaticMemberExpression=StaticMemberExpression;var Super=function(){function Super(){this.type=syntax_1.Syntax.Super}return Super}();exports.Super=Super;var SwitchCase=function(){function SwitchCase(test,consequent){this.type=syntax_1.Syntax.SwitchCase;this.test=test;this.consequent=consequent}return SwitchCase}();exports.SwitchCase=SwitchCase;var SwitchStatement=function(){function SwitchStatement(discriminant,cases){this.type=syntax_1.Syntax.SwitchStatement;this.discriminant=discriminant;this.cases=cases}return SwitchStatement}();exports.SwitchStatement=SwitchStatement;var TaggedTemplateExpression=function(){function TaggedTemplateExpression(tag,quasi){this.type=syntax_1.Syntax.TaggedTemplateExpression;this.tag=tag;this.quasi=quasi}return TaggedTemplateExpression}();exports.TaggedTemplateExpression=TaggedTemplateExpression;var TemplateElement=function(){function TemplateElement(value,tail){this.type=syntax_1.Syntax.TemplateElement;this.value=value;this.tail=tail}return TemplateElement}();exports.TemplateElement=TemplateElement;var TemplateLiteral=function(){function TemplateLiteral(quasis,expressions){this.type=syntax_1.Syntax.TemplateLiteral;this.quasis=quasis;this.expressions=expressions}return TemplateLiteral}();exports.TemplateLiteral=TemplateLiteral;var ThisExpression=function(){function ThisExpression(){this.type=syntax_1.Syntax.ThisExpression}return ThisExpression}();exports.ThisExpression=ThisExpression;var ThrowStatement=function(){function ThrowStatement(argument){this.type=syntax_1.Syntax.ThrowStatement;this.argument=argument}return ThrowStatement}();exports.ThrowStatement=ThrowStatement;var TryStatement=function(){function TryStatement(block,handler,finalizer){this.type=syntax_1.Syntax.TryStatement;this.block=block;this.handler=handler;this.finalizer=finalizer}return TryStatement}();exports.TryStatement=TryStatement;var UnaryExpression=function(){function UnaryExpression(operator,argument){this.type=syntax_1.Syntax.UnaryExpression;this.operator=operator;this.argument=argument;this.prefix=true}return UnaryExpression}();exports.UnaryExpression=UnaryExpression;var UpdateExpression=function(){function UpdateExpression(operator,argument,prefix){this.type=syntax_1.Syntax.UpdateExpression;this.operator=operator;this.argument=argument;this.prefix=prefix}return UpdateExpression}();exports.UpdateExpression=UpdateExpression;var VariableDeclaration=function(){function VariableDeclaration(declarations,kind){this.type=syntax_1.Syntax.VariableDeclaration;this.declarations=declarations;this.kind=kind}return VariableDeclaration}();exports.VariableDeclaration=VariableDeclaration;var VariableDeclarator=function(){function VariableDeclarator(id,init){this.type=syntax_1.Syntax.VariableDeclarator;this.id=id;this.init=init}return VariableDeclarator}();exports.VariableDeclarator=VariableDeclarator;var WhileStatement=function(){function WhileStatement(test,body){this.type=syntax_1.Syntax.WhileStatement;this.test=test;this.body=body}return WhileStatement}();exports.WhileStatement=WhileStatement;var WithStatement=function(){function WithStatement(object,body){this.type=syntax_1.Syntax.WithStatement;this.object=object;this.body=body}return WithStatement}();exports.WithStatement=WithStatement;var YieldExpression=function(){function YieldExpression(argument,delegate){this.type=syntax_1.Syntax.YieldExpression;this.argument=argument;this.delegate=delegate}return YieldExpression}();exports.YieldExpression=YieldExpression},function(module,exports,__nested_webpack_require_80491__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var assert_1=__nested_webpack_require_80491__(9);var error_handler_1=__nested_webpack_require_80491__(10);var messages_1=__nested_webpack_require_80491__(11);var Node=__nested_webpack_require_80491__(7);var scanner_1=__nested_webpack_require_80491__(12);var syntax_1=__nested_webpack_require_80491__(2);var token_1=__nested_webpack_require_80491__(13);var ArrowParameterPlaceHolder="ArrowParameterPlaceHolder";var Parser=function(){function Parser(code,options,delegate){if(options===void 0){options={}}this.config={range:typeof options.range==="boolean"&&options.range,loc:typeof options.loc==="boolean"&&options.loc,source:null,tokens:typeof options.tokens==="boolean"&&options.tokens,comment:typeof options.comment==="boolean"&&options.comment,tolerant:typeof options.tolerant==="boolean"&&options.tolerant};if(this.config.loc&&options.source&&options.source!==null){this.config.source=String(options.source)}this.delegate=delegate;this.errorHandler=new error_handler_1.ErrorHandler;this.errorHandler.tolerant=this.config.tolerant;this.scanner=new scanner_1.Scanner(code,this.errorHandler);this.scanner.trackComment=this.config.comment;this.operatorPrecedence={")":0,";":0,",":0,"=":0,"]":0,"||":1,"&&":2,"|":3,"^":4,"&":5,"==":6,"!=":6,"===":6,"!==":6,"<":7,">":7,"<=":7,">=":7,"<<":8,">>":8,">>>":8,"+":9,"-":9,"*":11,"/":11,"%":11};this.lookahead={type:2,value:"",lineNumber:this.scanner.lineNumber,lineStart:0,start:0,end:0};this.hasLineTerminator=false;this.context={isModule:false,await:false,allowIn:true,allowStrictDirective:true,allowYield:true,firstCoverInitializedNameError:null,isAssignmentTarget:false,isBindingElement:false,inFunctionBody:false,inIteration:false,inSwitch:false,labelSet:{},strict:false};this.tokens=[];this.startMarker={index:0,line:this.scanner.lineNumber,column:0};this.lastMarker={index:0,line:this.scanner.lineNumber,column:0};this.nextToken();this.lastMarker={index:this.scanner.index,line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart}}Parser.prototype.throwError=function(messageFormat){var values=[];for(var _i=1;_i<arguments.length;_i++){values[_i-1]=arguments[_i]}var args=Array.prototype.slice.call(arguments,1);var msg=messageFormat.replace(/%(\d)/g,(function(whole,idx){assert_1.assert(idx<args.length,"Message reference must be in range");return args[idx]}));var index=this.lastMarker.index;var line=this.lastMarker.line;var column=this.lastMarker.column+1;throw this.errorHandler.createError(index,line,column,msg)};Parser.prototype.tolerateError=function(messageFormat){var values=[];for(var _i=1;_i<arguments.length;_i++){values[_i-1]=arguments[_i]}var args=Array.prototype.slice.call(arguments,1);var msg=messageFormat.replace(/%(\d)/g,(function(whole,idx){assert_1.assert(idx<args.length,"Message reference must be in range");return args[idx]}));var index=this.lastMarker.index;var line=this.scanner.lineNumber;var column=this.lastMarker.column+1;this.errorHandler.tolerateError(index,line,column,msg)};Parser.prototype.unexpectedTokenError=function(token,message){var msg=message||messages_1.Messages.UnexpectedToken;var value;if(token){if(!message){msg=token.type===2?messages_1.Messages.UnexpectedEOS:token.type===3?messages_1.Messages.UnexpectedIdentifier:token.type===6?messages_1.Messages.UnexpectedNumber:token.type===8?messages_1.Messages.UnexpectedString:token.type===10?messages_1.Messages.UnexpectedTemplate:messages_1.Messages.UnexpectedToken;if(token.type===4){if(this.scanner.isFutureReservedWord(token.value)){msg=messages_1.Messages.UnexpectedReserved}else if(this.context.strict&&this.scanner.isStrictModeReservedWord(token.value)){msg=messages_1.Messages.StrictReservedWord}}}value=token.value}else{value="ILLEGAL"}msg=msg.replace("%0",value);if(token&&typeof token.lineNumber==="number"){var index=token.start;var line=token.lineNumber;var lastMarkerLineStart=this.lastMarker.index-this.lastMarker.column;var column=token.start-lastMarkerLineStart+1;return this.errorHandler.createError(index,line,column,msg)}else{var index=this.lastMarker.index;var line=this.lastMarker.line;var column=this.lastMarker.column+1;return this.errorHandler.createError(index,line,column,msg)}};Parser.prototype.throwUnexpectedToken=function(token,message){throw this.unexpectedTokenError(token,message)};Parser.prototype.tolerateUnexpectedToken=function(token,message){this.errorHandler.tolerate(this.unexpectedTokenError(token,message))};Parser.prototype.collectComments=function(){if(!this.config.comment){this.scanner.scanComments()}else{var comments=this.scanner.scanComments();if(comments.length>0&&this.delegate){for(var i=0;i<comments.length;++i){var e=comments[i];var node=void 0;node={type:e.multiLine?"BlockComment":"LineComment",value:this.scanner.source.slice(e.slice[0],e.slice[1])};if(this.config.range){node.range=e.range}if(this.config.loc){node.loc=e.loc}var metadata={start:{line:e.loc.start.line,column:e.loc.start.column,offset:e.range[0]},end:{line:e.loc.end.line,column:e.loc.end.column,offset:e.range[1]}};this.delegate(node,metadata)}}}};Parser.prototype.getTokenRaw=function(token){return this.scanner.source.slice(token.start,token.end)};Parser.prototype.convertToken=function(token){var t={type:token_1.TokenName[token.type],value:this.getTokenRaw(token)};if(this.config.range){t.range=[token.start,token.end]}if(this.config.loc){t.loc={start:{line:this.startMarker.line,column:this.startMarker.column},end:{line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart}}}if(token.type===9){var pattern=token.pattern;var flags=token.flags;t.regex={pattern,flags}}return t};Parser.prototype.nextToken=function(){var token=this.lookahead;this.lastMarker.index=this.scanner.index;this.lastMarker.line=this.scanner.lineNumber;this.lastMarker.column=this.scanner.index-this.scanner.lineStart;this.collectComments();if(this.scanner.index!==this.startMarker.index){this.startMarker.index=this.scanner.index;this.startMarker.line=this.scanner.lineNumber;this.startMarker.column=this.scanner.index-this.scanner.lineStart}var next=this.scanner.lex();this.hasLineTerminator=token.lineNumber!==next.lineNumber;if(next&&this.context.strict&&next.type===3){if(this.scanner.isStrictModeReservedWord(next.value)){next.type=4}}this.lookahead=next;if(this.config.tokens&&next.type!==2){this.tokens.push(this.convertToken(next))}return token};Parser.prototype.nextRegexToken=function(){this.collectComments();var token=this.scanner.scanRegExp();if(this.config.tokens){this.tokens.pop();this.tokens.push(this.convertToken(token))}this.lookahead=token;this.nextToken();return token};Parser.prototype.createNode=function(){return{index:this.startMarker.index,line:this.startMarker.line,column:this.startMarker.column}};Parser.prototype.startNode=function(token,lastLineStart){if(lastLineStart===void 0){lastLineStart=0}var column=token.start-token.lineStart;var line=token.lineNumber;if(column<0){column+=lastLineStart;line--}return{index:token.start,line,column}};Parser.prototype.finalize=function(marker,node){if(this.config.range){node.range=[marker.index,this.lastMarker.index]}if(this.config.loc){node.loc={start:{line:marker.line,column:marker.column},end:{line:this.lastMarker.line,column:this.lastMarker.column}};if(this.config.source){node.loc.source=this.config.source}}if(this.delegate){var metadata={start:{line:marker.line,column:marker.column,offset:marker.index},end:{line:this.lastMarker.line,column:this.lastMarker.column,offset:this.lastMarker.index}};this.delegate(node,metadata)}return node};Parser.prototype.expect=function(value){var token=this.nextToken();if(token.type!==7||token.value!==value){this.throwUnexpectedToken(token)}};Parser.prototype.expectCommaSeparator=function(){if(this.config.tolerant){var token=this.lookahead;if(token.type===7&&token.value===","){this.nextToken()}else if(token.type===7&&token.value===";"){this.nextToken();this.tolerateUnexpectedToken(token)}else{this.tolerateUnexpectedToken(token,messages_1.Messages.UnexpectedToken)}}else{this.expect(",")}};Parser.prototype.expectKeyword=function(keyword){var token=this.nextToken();if(token.type!==4||token.value!==keyword){this.throwUnexpectedToken(token)}};Parser.prototype.match=function(value){return this.lookahead.type===7&&this.lookahead.value===value};Parser.prototype.matchKeyword=function(keyword){return this.lookahead.type===4&&this.lookahead.value===keyword};Parser.prototype.matchContextualKeyword=function(keyword){return this.lookahead.type===3&&this.lookahead.value===keyword};Parser.prototype.matchAssign=function(){if(this.lookahead.type!==7){return false}var op=this.lookahead.value;return op==="="||op==="*="||op==="**="||op==="/="||op==="%="||op==="+="||op==="-="||op==="<<="||op===">>="||op===">>>="||op==="&="||op==="^="||op==="|="};Parser.prototype.isolateCoverGrammar=function(parseFunction){var previousIsBindingElement=this.context.isBindingElement;var previousIsAssignmentTarget=this.context.isAssignmentTarget;var previousFirstCoverInitializedNameError=this.context.firstCoverInitializedNameError;this.context.isBindingElement=true;this.context.isAssignmentTarget=true;this.context.firstCoverInitializedNameError=null;var result=parseFunction.call(this);if(this.context.firstCoverInitializedNameError!==null){this.throwUnexpectedToken(this.context.firstCoverInitializedNameError)}this.context.isBindingElement=previousIsBindingElement;this.context.isAssignmentTarget=previousIsAssignmentTarget;this.context.firstCoverInitializedNameError=previousFirstCoverInitializedNameError;return result};Parser.prototype.inheritCoverGrammar=function(parseFunction){var previousIsBindingElement=this.context.isBindingElement;var previousIsAssignmentTarget=this.context.isAssignmentTarget;var previousFirstCoverInitializedNameError=this.context.firstCoverInitializedNameError;this.context.isBindingElement=true;this.context.isAssignmentTarget=true;this.context.firstCoverInitializedNameError=null;var result=parseFunction.call(this);this.context.isBindingElement=this.context.isBindingElement&&previousIsBindingElement;this.context.isAssignmentTarget=this.context.isAssignmentTarget&&previousIsAssignmentTarget;this.context.firstCoverInitializedNameError=previousFirstCoverInitializedNameError||this.context.firstCoverInitializedNameError;return result};Parser.prototype.consumeSemicolon=function(){if(this.match(";")){this.nextToken()}else if(!this.hasLineTerminator){if(this.lookahead.type!==2&&!this.match("}")){this.throwUnexpectedToken(this.lookahead)}this.lastMarker.index=this.startMarker.index;this.lastMarker.line=this.startMarker.line;this.lastMarker.column=this.startMarker.column}};Parser.prototype.parsePrimaryExpression=function(){var node=this.createNode();var expr;var token,raw;switch(this.lookahead.type){case 3:if((this.context.isModule||this.context.await)&&this.lookahead.value==="await"){this.tolerateUnexpectedToken(this.lookahead)}expr=this.matchAsyncFunction()?this.parseFunctionExpression():this.finalize(node,new Node.Identifier(this.nextToken().value));break;case 6:case 8:if(this.context.strict&&this.lookahead.octal){this.tolerateUnexpectedToken(this.lookahead,messages_1.Messages.StrictOctalLiteral)}this.context.isAssignmentTarget=false;this.context.isBindingElement=false;token=this.nextToken();raw=this.getTokenRaw(token);expr=this.finalize(node,new Node.Literal(token.value,raw));break;case 1:this.context.isAssignmentTarget=false;this.context.isBindingElement=false;token=this.nextToken();raw=this.getTokenRaw(token);expr=this.finalize(node,new Node.Literal(token.value==="true",raw));break;case 5:this.context.isAssignmentTarget=false;this.context.isBindingElement=false;token=this.nextToken();raw=this.getTokenRaw(token);expr=this.finalize(node,new Node.Literal(null,raw));break;case 10:expr=this.parseTemplateLiteral();break;case 7:switch(this.lookahead.value){case"(":this.context.isBindingElement=false;expr=this.inheritCoverGrammar(this.parseGroupExpression);break;case"[":expr=this.inheritCoverGrammar(this.parseArrayInitializer);break;case"{":expr=this.inheritCoverGrammar(this.parseObjectInitializer);break;case"/":case"/=":this.context.isAssignmentTarget=false;this.context.isBindingElement=false;this.scanner.index=this.startMarker.index;token=this.nextRegexToken();raw=this.getTokenRaw(token);expr=this.finalize(node,new Node.RegexLiteral(token.regex,raw,token.pattern,token.flags));break;default:expr=this.throwUnexpectedToken(this.nextToken())}break;case 4:if(!this.context.strict&&this.context.allowYield&&this.matchKeyword("yield")){expr=this.parseIdentifierName()}else if(!this.context.strict&&this.matchKeyword("let")){expr=this.finalize(node,new Node.Identifier(this.nextToken().value))}else{this.context.isAssignmentTarget=false;this.context.isBindingElement=false;if(this.matchKeyword("function")){expr=this.parseFunctionExpression()}else if(this.matchKeyword("this")){this.nextToken();expr=this.finalize(node,new Node.ThisExpression)}else if(this.matchKeyword("class")){expr=this.parseClassExpression()}else{expr=this.throwUnexpectedToken(this.nextToken())}}break;default:expr=this.throwUnexpectedToken(this.nextToken())}return expr};Parser.prototype.parseSpreadElement=function(){var node=this.createNode();this.expect("...");var arg=this.inheritCoverGrammar(this.parseAssignmentExpression);return this.finalize(node,new Node.SpreadElement(arg))};Parser.prototype.parseArrayInitializer=function(){var node=this.createNode();var elements=[];this.expect("[");while(!this.match("]")){if(this.match(",")){this.nextToken();elements.push(null)}else if(this.match("...")){var element=this.parseSpreadElement();if(!this.match("]")){this.context.isAssignmentTarget=false;this.context.isBindingElement=false;this.expect(",")}elements.push(element)}else{elements.push(this.inheritCoverGrammar(this.parseAssignmentExpression));if(!this.match("]")){this.expect(",")}}}this.expect("]");return this.finalize(node,new Node.ArrayExpression(elements))};Parser.prototype.parsePropertyMethod=function(params){this.context.isAssignmentTarget=false;this.context.isBindingElement=false;var previousStrict=this.context.strict;var previousAllowStrictDirective=this.context.allowStrictDirective;this.context.allowStrictDirective=params.simple;var body=this.isolateCoverGrammar(this.parseFunctionSourceElements);if(this.context.strict&&params.firstRestricted){this.tolerateUnexpectedToken(params.firstRestricted,params.message)}if(this.context.strict&&params.stricted){this.tolerateUnexpectedToken(params.stricted,params.message)}this.context.strict=previousStrict;this.context.allowStrictDirective=previousAllowStrictDirective;return body};Parser.prototype.parsePropertyMethodFunction=function(){var isGenerator=false;var node=this.createNode();var previousAllowYield=this.context.allowYield;this.context.allowYield=true;var params=this.parseFormalParameters();var method=this.parsePropertyMethod(params);this.context.allowYield=previousAllowYield;return this.finalize(node,new Node.FunctionExpression(null,params.params,method,isGenerator))};Parser.prototype.parsePropertyMethodAsyncFunction=function(){var node=this.createNode();var previousAllowYield=this.context.allowYield;var previousAwait=this.context.await;this.context.allowYield=false;this.context.await=true;var params=this.parseFormalParameters();var method=this.parsePropertyMethod(params);this.context.allowYield=previousAllowYield;this.context.await=previousAwait;return this.finalize(node,new Node.AsyncFunctionExpression(null,params.params,method))};Parser.prototype.parseObjectPropertyKey=function(){var node=this.createNode();var token=this.nextToken();var key;switch(token.type){case 8:case 6:if(this.context.strict&&token.octal){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictOctalLiteral)}var raw=this.getTokenRaw(token);key=this.finalize(node,new Node.Literal(token.value,raw));break;case 3:case 1:case 5:case 4:key=this.finalize(node,new Node.Identifier(token.value));break;case 7:if(token.value==="["){key=this.isolateCoverGrammar(this.parseAssignmentExpression);this.expect("]")}else{key=this.throwUnexpectedToken(token)}break;default:key=this.throwUnexpectedToken(token)}return key};Parser.prototype.isPropertyKey=function(key,value){return key.type===syntax_1.Syntax.Identifier&&key.name===value||key.type===syntax_1.Syntax.Literal&&key.value===value};Parser.prototype.parseObjectProperty=function(hasProto){var node=this.createNode();var token=this.lookahead;var kind;var key=null;var value=null;var computed=false;var method=false;var shorthand=false;var isAsync=false;if(token.type===3){var id=token.value;this.nextToken();computed=this.match("[");isAsync=!this.hasLineTerminator&&id==="async"&&!this.match(":")&&!this.match("(")&&!this.match("*")&&!this.match(",");key=isAsync?this.parseObjectPropertyKey():this.finalize(node,new Node.Identifier(id))}else if(this.match("*")){this.nextToken()}else{computed=this.match("[");key=this.parseObjectPropertyKey()}var lookaheadPropertyKey=this.qualifiedPropertyName(this.lookahead);if(token.type===3&&!isAsync&&token.value==="get"&&lookaheadPropertyKey){kind="get";computed=this.match("[");key=this.parseObjectPropertyKey();this.context.allowYield=false;value=this.parseGetterMethod()}else if(token.type===3&&!isAsync&&token.value==="set"&&lookaheadPropertyKey){kind="set";computed=this.match("[");key=this.parseObjectPropertyKey();value=this.parseSetterMethod()}else if(token.type===7&&token.value==="*"&&lookaheadPropertyKey){kind="init";computed=this.match("[");key=this.parseObjectPropertyKey();value=this.parseGeneratorMethod();method=true}else{if(!key){this.throwUnexpectedToken(this.lookahead)}kind="init";if(this.match(":")&&!isAsync){if(!computed&&this.isPropertyKey(key,"__proto__")){if(hasProto.value){this.tolerateError(messages_1.Messages.DuplicateProtoProperty)}hasProto.value=true}this.nextToken();value=this.inheritCoverGrammar(this.parseAssignmentExpression)}else if(this.match("(")){value=isAsync?this.parsePropertyMethodAsyncFunction():this.parsePropertyMethodFunction();method=true}else if(token.type===3){var id=this.finalize(node,new Node.Identifier(token.value));if(this.match("=")){this.context.firstCoverInitializedNameError=this.lookahead;this.nextToken();shorthand=true;var init=this.isolateCoverGrammar(this.parseAssignmentExpression);value=this.finalize(node,new Node.AssignmentPattern(id,init))}else{shorthand=true;value=id}}else{this.throwUnexpectedToken(this.nextToken())}}return this.finalize(node,new Node.Property(kind,key,computed,value,method,shorthand))};Parser.prototype.parseObjectInitializer=function(){var node=this.createNode();this.expect("{");var properties=[];var hasProto={value:false};while(!this.match("}")){properties.push(this.parseObjectProperty(hasProto));if(!this.match("}")){this.expectCommaSeparator()}}this.expect("}");return this.finalize(node,new Node.ObjectExpression(properties))};Parser.prototype.parseTemplateHead=function(){assert_1.assert(this.lookahead.head,"Template literal must start with a template head");var node=this.createNode();var token=this.nextToken();var raw=token.value;var cooked=token.cooked;return this.finalize(node,new Node.TemplateElement({raw,cooked},token.tail))};Parser.prototype.parseTemplateElement=function(){if(this.lookahead.type!==10){this.throwUnexpectedToken()}var node=this.createNode();var token=this.nextToken();var raw=token.value;var cooked=token.cooked;return this.finalize(node,new Node.TemplateElement({raw,cooked},token.tail))};Parser.prototype.parseTemplateLiteral=function(){var node=this.createNode();var expressions=[];var quasis=[];var quasi=this.parseTemplateHead();quasis.push(quasi);while(!quasi.tail){expressions.push(this.parseExpression());quasi=this.parseTemplateElement();quasis.push(quasi)}return this.finalize(node,new Node.TemplateLiteral(quasis,expressions))};Parser.prototype.reinterpretExpressionAsPattern=function(expr){switch(expr.type){case syntax_1.Syntax.Identifier:case syntax_1.Syntax.MemberExpression:case syntax_1.Syntax.RestElement:case syntax_1.Syntax.AssignmentPattern:break;case syntax_1.Syntax.SpreadElement:expr.type=syntax_1.Syntax.RestElement;this.reinterpretExpressionAsPattern(expr.argument);break;case syntax_1.Syntax.ArrayExpression:expr.type=syntax_1.Syntax.ArrayPattern;for(var i=0;i<expr.elements.length;i++){if(expr.elements[i]!==null){this.reinterpretExpressionAsPattern(expr.elements[i])}}break;case syntax_1.Syntax.ObjectExpression:expr.type=syntax_1.Syntax.ObjectPattern;for(var i=0;i<expr.properties.length;i++){this.reinterpretExpressionAsPattern(expr.properties[i].value)}break;case syntax_1.Syntax.AssignmentExpression:expr.type=syntax_1.Syntax.AssignmentPattern;delete expr.operator;this.reinterpretExpressionAsPattern(expr.left);break;default:break}};Parser.prototype.parseGroupExpression=function(){var expr;this.expect("(");if(this.match(")")){this.nextToken();if(!this.match("=>")){this.expect("=>")}expr={type:ArrowParameterPlaceHolder,params:[],async:false}}else{var startToken=this.lookahead;var params=[];if(this.match("...")){expr=this.parseRestElement(params);this.expect(")");if(!this.match("=>")){this.expect("=>")}expr={type:ArrowParameterPlaceHolder,params:[expr],async:false}}else{var arrow=false;this.context.isBindingElement=true;expr=this.inheritCoverGrammar(this.parseAssignmentExpression);if(this.match(",")){var expressions=[];this.context.isAssignmentTarget=false;expressions.push(expr);while(this.lookahead.type!==2){if(!this.match(",")){break}this.nextToken();if(this.match(")")){this.nextToken();for(var i=0;i<expressions.length;i++){this.reinterpretExpressionAsPattern(expressions[i])}arrow=true;expr={type:ArrowParameterPlaceHolder,params:expressions,async:false}}else if(this.match("...")){if(!this.context.isBindingElement){this.throwUnexpectedToken(this.lookahead)}expressions.push(this.parseRestElement(params));this.expect(")");if(!this.match("=>")){this.expect("=>")}this.context.isBindingElement=false;for(var i=0;i<expressions.length;i++){this.reinterpretExpressionAsPattern(expressions[i])}arrow=true;expr={type:ArrowParameterPlaceHolder,params:expressions,async:false}}else{expressions.push(this.inheritCoverGrammar(this.parseAssignmentExpression))}if(arrow){break}}if(!arrow){expr=this.finalize(this.startNode(startToken),new Node.SequenceExpression(expressions))}}if(!arrow){this.expect(")");if(this.match("=>")){if(expr.type===syntax_1.Syntax.Identifier&&expr.name==="yield"){arrow=true;expr={type:ArrowParameterPlaceHolder,params:[expr],async:false}}if(!arrow){if(!this.context.isBindingElement){this.throwUnexpectedToken(this.lookahead)}if(expr.type===syntax_1.Syntax.SequenceExpression){for(var i=0;i<expr.expressions.length;i++){this.reinterpretExpressionAsPattern(expr.expressions[i])}}else{this.reinterpretExpressionAsPattern(expr)}var parameters=expr.type===syntax_1.Syntax.SequenceExpression?expr.expressions:[expr];expr={type:ArrowParameterPlaceHolder,params:parameters,async:false}}}this.context.isBindingElement=false}}}return expr};Parser.prototype.parseArguments=function(){this.expect("(");var args=[];if(!this.match(")")){while(true){var expr=this.match("...")?this.parseSpreadElement():this.isolateCoverGrammar(this.parseAssignmentExpression);args.push(expr);if(this.match(")")){break}this.expectCommaSeparator();if(this.match(")")){break}}}this.expect(")");return args};Parser.prototype.isIdentifierName=function(token){return token.type===3||token.type===4||token.type===1||token.type===5};Parser.prototype.parseIdentifierName=function(){var node=this.createNode();var token=this.nextToken();if(!this.isIdentifierName(token)){this.throwUnexpectedToken(token)}return this.finalize(node,new Node.Identifier(token.value))};Parser.prototype.parseNewExpression=function(){var node=this.createNode();var id=this.parseIdentifierName();assert_1.assert(id.name==="new","New expression must start with `new`");var expr;if(this.match(".")){this.nextToken();if(this.lookahead.type===3&&this.context.inFunctionBody&&this.lookahead.value==="target"){var property=this.parseIdentifierName();expr=new Node.MetaProperty(id,property)}else{this.throwUnexpectedToken(this.lookahead)}}else{var callee=this.isolateCoverGrammar(this.parseLeftHandSideExpression);var args=this.match("(")?this.parseArguments():[];expr=new Node.NewExpression(callee,args);this.context.isAssignmentTarget=false;this.context.isBindingElement=false}return this.finalize(node,expr)};Parser.prototype.parseAsyncArgument=function(){var arg=this.parseAssignmentExpression();this.context.firstCoverInitializedNameError=null;return arg};Parser.prototype.parseAsyncArguments=function(){this.expect("(");var args=[];if(!this.match(")")){while(true){var expr=this.match("...")?this.parseSpreadElement():this.isolateCoverGrammar(this.parseAsyncArgument);args.push(expr);if(this.match(")")){break}this.expectCommaSeparator();if(this.match(")")){break}}}this.expect(")");return args};Parser.prototype.parseLeftHandSideExpressionAllowCall=function(){var startToken=this.lookahead;var maybeAsync=this.matchContextualKeyword("async");var previousAllowIn=this.context.allowIn;this.context.allowIn=true;var expr;if(this.matchKeyword("super")&&this.context.inFunctionBody){expr=this.createNode();this.nextToken();expr=this.finalize(expr,new Node.Super);if(!this.match("(")&&!this.match(".")&&!this.match("[")){this.throwUnexpectedToken(this.lookahead)}}else{expr=this.inheritCoverGrammar(this.matchKeyword("new")?this.parseNewExpression:this.parsePrimaryExpression)}while(true){if(this.match(".")){this.context.isBindingElement=false;this.context.isAssignmentTarget=true;this.expect(".");var property=this.parseIdentifierName();expr=this.finalize(this.startNode(startToken),new Node.StaticMemberExpression(expr,property))}else if(this.match("(")){var asyncArrow=maybeAsync&&startToken.lineNumber===this.lookahead.lineNumber;this.context.isBindingElement=false;this.context.isAssignmentTarget=false;var args=asyncArrow?this.parseAsyncArguments():this.parseArguments();expr=this.finalize(this.startNode(startToken),new Node.CallExpression(expr,args));if(asyncArrow&&this.match("=>")){for(var i=0;i<args.length;++i){this.reinterpretExpressionAsPattern(args[i])}expr={type:ArrowParameterPlaceHolder,params:args,async:true}}}else if(this.match("[")){this.context.isBindingElement=false;this.context.isAssignmentTarget=true;this.expect("[");var property=this.isolateCoverGrammar(this.parseExpression);this.expect("]");expr=this.finalize(this.startNode(startToken),new Node.ComputedMemberExpression(expr,property))}else if(this.lookahead.type===10&&this.lookahead.head){var quasi=this.parseTemplateLiteral();expr=this.finalize(this.startNode(startToken),new Node.TaggedTemplateExpression(expr,quasi))}else{break}}this.context.allowIn=previousAllowIn;return expr};Parser.prototype.parseSuper=function(){var node=this.createNode();this.expectKeyword("super");if(!this.match("[")&&!this.match(".")){this.throwUnexpectedToken(this.lookahead)}return this.finalize(node,new Node.Super)};Parser.prototype.parseLeftHandSideExpression=function(){assert_1.assert(this.context.allowIn,"callee of new expression always allow in keyword.");var node=this.startNode(this.lookahead);var expr=this.matchKeyword("super")&&this.context.inFunctionBody?this.parseSuper():this.inheritCoverGrammar(this.matchKeyword("new")?this.parseNewExpression:this.parsePrimaryExpression);while(true){if(this.match("[")){this.context.isBindingElement=false;this.context.isAssignmentTarget=true;this.expect("[");var property=this.isolateCoverGrammar(this.parseExpression);this.expect("]");expr=this.finalize(node,new Node.ComputedMemberExpression(expr,property))}else if(this.match(".")){this.context.isBindingElement=false;this.context.isAssignmentTarget=true;this.expect(".");var property=this.parseIdentifierName();expr=this.finalize(node,new Node.StaticMemberExpression(expr,property))}else if(this.lookahead.type===10&&this.lookahead.head){var quasi=this.parseTemplateLiteral();expr=this.finalize(node,new Node.TaggedTemplateExpression(expr,quasi))}else{break}}return expr};Parser.prototype.parseUpdateExpression=function(){var expr;var startToken=this.lookahead;if(this.match("++")||this.match("--")){var node=this.startNode(startToken);var token=this.nextToken();expr=this.inheritCoverGrammar(this.parseUnaryExpression);if(this.context.strict&&expr.type===syntax_1.Syntax.Identifier&&this.scanner.isRestrictedWord(expr.name)){this.tolerateError(messages_1.Messages.StrictLHSPrefix)}if(!this.context.isAssignmentTarget){this.tolerateError(messages_1.Messages.InvalidLHSInAssignment)}var prefix=true;expr=this.finalize(node,new Node.UpdateExpression(token.value,expr,prefix));this.context.isAssignmentTarget=false;this.context.isBindingElement=false}else{expr=this.inheritCoverGrammar(this.parseLeftHandSideExpressionAllowCall);if(!this.hasLineTerminator&&this.lookahead.type===7){if(this.match("++")||this.match("--")){if(this.context.strict&&expr.type===syntax_1.Syntax.Identifier&&this.scanner.isRestrictedWord(expr.name)){this.tolerateError(messages_1.Messages.StrictLHSPostfix)}if(!this.context.isAssignmentTarget){this.tolerateError(messages_1.Messages.InvalidLHSInAssignment)}this.context.isAssignmentTarget=false;this.context.isBindingElement=false;var operator=this.nextToken().value;var prefix=false;expr=this.finalize(this.startNode(startToken),new Node.UpdateExpression(operator,expr,prefix))}}}return expr};Parser.prototype.parseAwaitExpression=function(){var node=this.createNode();this.nextToken();var argument=this.parseUnaryExpression();return this.finalize(node,new Node.AwaitExpression(argument))};Parser.prototype.parseUnaryExpression=function(){var expr;if(this.match("+")||this.match("-")||this.match("~")||this.match("!")||this.matchKeyword("delete")||this.matchKeyword("void")||this.matchKeyword("typeof")){var node=this.startNode(this.lookahead);var token=this.nextToken();expr=this.inheritCoverGrammar(this.parseUnaryExpression);expr=this.finalize(node,new Node.UnaryExpression(token.value,expr));if(this.context.strict&&expr.operator==="delete"&&expr.argument.type===syntax_1.Syntax.Identifier){this.tolerateError(messages_1.Messages.StrictDelete)}this.context.isAssignmentTarget=false;this.context.isBindingElement=false}else if(this.context.await&&this.matchContextualKeyword("await")){expr=this.parseAwaitExpression()}else{expr=this.parseUpdateExpression()}return expr};Parser.prototype.parseExponentiationExpression=function(){var startToken=this.lookahead;var expr=this.inheritCoverGrammar(this.parseUnaryExpression);if(expr.type!==syntax_1.Syntax.UnaryExpression&&this.match("**")){this.nextToken();this.context.isAssignmentTarget=false;this.context.isBindingElement=false;var left=expr;var right=this.isolateCoverGrammar(this.parseExponentiationExpression);expr=this.finalize(this.startNode(startToken),new Node.BinaryExpression("**",left,right))}return expr};Parser.prototype.binaryPrecedence=function(token){var op=token.value;var precedence;if(token.type===7){precedence=this.operatorPrecedence[op]||0}else if(token.type===4){precedence=op==="instanceof"||this.context.allowIn&&op==="in"?7:0}else{precedence=0}return precedence};Parser.prototype.parseBinaryExpression=function(){var startToken=this.lookahead;var expr=this.inheritCoverGrammar(this.parseExponentiationExpression);var token=this.lookahead;var prec=this.binaryPrecedence(token);if(prec>0){this.nextToken();this.context.isAssignmentTarget=false;this.context.isBindingElement=false;var markers=[startToken,this.lookahead];var left=expr;var right=this.isolateCoverGrammar(this.parseExponentiationExpression);var stack=[left,token.value,right];var precedences=[prec];while(true){prec=this.binaryPrecedence(this.lookahead);if(prec<=0){break}while(stack.length>2&&prec<=precedences[precedences.length-1]){right=stack.pop();var operator=stack.pop();precedences.pop();left=stack.pop();markers.pop();var node=this.startNode(markers[markers.length-1]);stack.push(this.finalize(node,new Node.BinaryExpression(operator,left,right)))}stack.push(this.nextToken().value);precedences.push(prec);markers.push(this.lookahead);stack.push(this.isolateCoverGrammar(this.parseExponentiationExpression))}var i=stack.length-1;expr=stack[i];var lastMarker=markers.pop();while(i>1){var marker=markers.pop();var lastLineStart=lastMarker&&lastMarker.lineStart;var node=this.startNode(marker,lastLineStart);var operator=stack[i-1];expr=this.finalize(node,new Node.BinaryExpression(operator,stack[i-2],expr));i-=2;lastMarker=marker}}return expr};Parser.prototype.parseConditionalExpression=function(){var startToken=this.lookahead;var expr=this.inheritCoverGrammar(this.parseBinaryExpression);if(this.match("?")){this.nextToken();var previousAllowIn=this.context.allowIn;this.context.allowIn=true;var consequent=this.isolateCoverGrammar(this.parseAssignmentExpression);this.context.allowIn=previousAllowIn;this.expect(":");var alternate=this.isolateCoverGrammar(this.parseAssignmentExpression);expr=this.finalize(this.startNode(startToken),new Node.ConditionalExpression(expr,consequent,alternate));this.context.isAssignmentTarget=false;this.context.isBindingElement=false}return expr};Parser.prototype.checkPatternParam=function(options,param){switch(param.type){case syntax_1.Syntax.Identifier:this.validateParam(options,param,param.name);break;case syntax_1.Syntax.RestElement:this.checkPatternParam(options,param.argument);break;case syntax_1.Syntax.AssignmentPattern:this.checkPatternParam(options,param.left);break;case syntax_1.Syntax.ArrayPattern:for(var i=0;i<param.elements.length;i++){if(param.elements[i]!==null){this.checkPatternParam(options,param.elements[i])}}break;case syntax_1.Syntax.ObjectPattern:for(var i=0;i<param.properties.length;i++){this.checkPatternParam(options,param.properties[i].value)}break;default:break}options.simple=options.simple&&param instanceof Node.Identifier};Parser.prototype.reinterpretAsCoverFormalsList=function(expr){var params=[expr];var options;var asyncArrow=false;switch(expr.type){case syntax_1.Syntax.Identifier:break;case ArrowParameterPlaceHolder:params=expr.params;asyncArrow=expr.async;break;default:return null}options={simple:true,paramSet:{}};for(var i=0;i<params.length;++i){var param=params[i];if(param.type===syntax_1.Syntax.AssignmentPattern){if(param.right.type===syntax_1.Syntax.YieldExpression){if(param.right.argument){this.throwUnexpectedToken(this.lookahead)}param.right.type=syntax_1.Syntax.Identifier;param.right.name="yield";delete param.right.argument;delete param.right.delegate}}else if(asyncArrow&&param.type===syntax_1.Syntax.Identifier&&param.name==="await"){this.throwUnexpectedToken(this.lookahead)}this.checkPatternParam(options,param);params[i]=param}if(this.context.strict||!this.context.allowYield){for(var i=0;i<params.length;++i){var param=params[i];if(param.type===syntax_1.Syntax.YieldExpression){this.throwUnexpectedToken(this.lookahead)}}}if(options.message===messages_1.Messages.StrictParamDupe){var token=this.context.strict?options.stricted:options.firstRestricted;this.throwUnexpectedToken(token,options.message)}return{simple:options.simple,params,stricted:options.stricted,firstRestricted:options.firstRestricted,message:options.message}};Parser.prototype.parseAssignmentExpression=function(){var expr;if(!this.context.allowYield&&this.matchKeyword("yield")){expr=this.parseYieldExpression()}else{var startToken=this.lookahead;var token=startToken;expr=this.parseConditionalExpression();if(token.type===3&&token.lineNumber===this.lookahead.lineNumber&&token.value==="async"){if(this.lookahead.type===3||this.matchKeyword("yield")){var arg=this.parsePrimaryExpression();this.reinterpretExpressionAsPattern(arg);expr={type:ArrowParameterPlaceHolder,params:[arg],async:true}}}if(expr.type===ArrowParameterPlaceHolder||this.match("=>")){this.context.isAssignmentTarget=false;this.context.isBindingElement=false;var isAsync=expr.async;var list=this.reinterpretAsCoverFormalsList(expr);if(list){if(this.hasLineTerminator){this.tolerateUnexpectedToken(this.lookahead)}this.context.firstCoverInitializedNameError=null;var previousStrict=this.context.strict;var previousAllowStrictDirective=this.context.allowStrictDirective;this.context.allowStrictDirective=list.simple;var previousAllowYield=this.context.allowYield;var previousAwait=this.context.await;this.context.allowYield=true;this.context.await=isAsync;var node=this.startNode(startToken);this.expect("=>");var body=void 0;if(this.match("{")){var previousAllowIn=this.context.allowIn;this.context.allowIn=true;body=this.parseFunctionSourceElements();this.context.allowIn=previousAllowIn}else{body=this.isolateCoverGrammar(this.parseAssignmentExpression)}var expression=body.type!==syntax_1.Syntax.BlockStatement;if(this.context.strict&&list.firstRestricted){this.throwUnexpectedToken(list.firstRestricted,list.message)}if(this.context.strict&&list.stricted){this.tolerateUnexpectedToken(list.stricted,list.message)}expr=isAsync?this.finalize(node,new Node.AsyncArrowFunctionExpression(list.params,body,expression)):this.finalize(node,new Node.ArrowFunctionExpression(list.params,body,expression));this.context.strict=previousStrict;this.context.allowStrictDirective=previousAllowStrictDirective;this.context.allowYield=previousAllowYield;this.context.await=previousAwait}}else{if(this.matchAssign()){if(!this.context.isAssignmentTarget){this.tolerateError(messages_1.Messages.InvalidLHSInAssignment)}if(this.context.strict&&expr.type===syntax_1.Syntax.Identifier){var id=expr;if(this.scanner.isRestrictedWord(id.name)){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictLHSAssignment)}if(this.scanner.isStrictModeReservedWord(id.name)){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictReservedWord)}}if(!this.match("=")){this.context.isAssignmentTarget=false;this.context.isBindingElement=false}else{this.reinterpretExpressionAsPattern(expr)}token=this.nextToken();var operator=token.value;var right=this.isolateCoverGrammar(this.parseAssignmentExpression);expr=this.finalize(this.startNode(startToken),new Node.AssignmentExpression(operator,expr,right));this.context.firstCoverInitializedNameError=null}}}return expr};Parser.prototype.parseExpression=function(){var startToken=this.lookahead;var expr=this.isolateCoverGrammar(this.parseAssignmentExpression);if(this.match(",")){var expressions=[];expressions.push(expr);while(this.lookahead.type!==2){if(!this.match(",")){break}this.nextToken();expressions.push(this.isolateCoverGrammar(this.parseAssignmentExpression))}expr=this.finalize(this.startNode(startToken),new Node.SequenceExpression(expressions))}return expr};Parser.prototype.parseStatementListItem=function(){var statement;this.context.isAssignmentTarget=true;this.context.isBindingElement=true;if(this.lookahead.type===4){switch(this.lookahead.value){case"export":if(!this.context.isModule){this.tolerateUnexpectedToken(this.lookahead,messages_1.Messages.IllegalExportDeclaration)}statement=this.parseExportDeclaration();break;case"import":if(!this.context.isModule){this.tolerateUnexpectedToken(this.lookahead,messages_1.Messages.IllegalImportDeclaration)}statement=this.parseImportDeclaration();break;case"const":statement=this.parseLexicalDeclaration({inFor:false});break;case"function":statement=this.parseFunctionDeclaration();break;case"class":statement=this.parseClassDeclaration();break;case"let":statement=this.isLexicalDeclaration()?this.parseLexicalDeclaration({inFor:false}):this.parseStatement();break;default:statement=this.parseStatement();break}}else{statement=this.parseStatement()}return statement};Parser.prototype.parseBlock=function(){var node=this.createNode();this.expect("{");var block=[];while(true){if(this.match("}")){break}block.push(this.parseStatementListItem())}this.expect("}");return this.finalize(node,new Node.BlockStatement(block))};Parser.prototype.parseLexicalBinding=function(kind,options){var node=this.createNode();var params=[];var id=this.parsePattern(params,kind);if(this.context.strict&&id.type===syntax_1.Syntax.Identifier){if(this.scanner.isRestrictedWord(id.name)){this.tolerateError(messages_1.Messages.StrictVarName)}}var init=null;if(kind==="const"){if(!this.matchKeyword("in")&&!this.matchContextualKeyword("of")){if(this.match("=")){this.nextToken();init=this.isolateCoverGrammar(this.parseAssignmentExpression)}else{this.throwError(messages_1.Messages.DeclarationMissingInitializer,"const")}}}else if(!options.inFor&&id.type!==syntax_1.Syntax.Identifier||this.match("=")){this.expect("=");init=this.isolateCoverGrammar(this.parseAssignmentExpression)}return this.finalize(node,new Node.VariableDeclarator(id,init))};Parser.prototype.parseBindingList=function(kind,options){var list=[this.parseLexicalBinding(kind,options)];while(this.match(",")){this.nextToken();list.push(this.parseLexicalBinding(kind,options))}return list};Parser.prototype.isLexicalDeclaration=function(){var state=this.scanner.saveState();this.scanner.scanComments();var next=this.scanner.lex();this.scanner.restoreState(state);return next.type===3||next.type===7&&next.value==="["||next.type===7&&next.value==="{"||next.type===4&&next.value==="let"||next.type===4&&next.value==="yield"};Parser.prototype.parseLexicalDeclaration=function(options){var node=this.createNode();var kind=this.nextToken().value;assert_1.assert(kind==="let"||kind==="const","Lexical declaration must be either let or const");var declarations=this.parseBindingList(kind,options);this.consumeSemicolon();return this.finalize(node,new Node.VariableDeclaration(declarations,kind))};Parser.prototype.parseBindingRestElement=function(params,kind){var node=this.createNode();this.expect("...");var arg=this.parsePattern(params,kind);return this.finalize(node,new Node.RestElement(arg))};Parser.prototype.parseArrayPattern=function(params,kind){var node=this.createNode();this.expect("[");var elements=[];while(!this.match("]")){if(this.match(",")){this.nextToken();elements.push(null)}else{if(this.match("...")){elements.push(this.parseBindingRestElement(params,kind));break}else{elements.push(this.parsePatternWithDefault(params,kind))}if(!this.match("]")){this.expect(",")}}}this.expect("]");return this.finalize(node,new Node.ArrayPattern(elements))};Parser.prototype.parsePropertyPattern=function(params,kind){var node=this.createNode();var computed=false;var shorthand=false;var method=false;var key;var value;if(this.lookahead.type===3){var keyToken=this.lookahead;key=this.parseVariableIdentifier();var init=this.finalize(node,new Node.Identifier(keyToken.value));if(this.match("=")){params.push(keyToken);shorthand=true;this.nextToken();var expr=this.parseAssignmentExpression();value=this.finalize(this.startNode(keyToken),new Node.AssignmentPattern(init,expr))}else if(!this.match(":")){params.push(keyToken);shorthand=true;value=init}else{this.expect(":");value=this.parsePatternWithDefault(params,kind)}}else{computed=this.match("[");key=this.parseObjectPropertyKey();this.expect(":");value=this.parsePatternWithDefault(params,kind)}return this.finalize(node,new Node.Property("init",key,computed,value,method,shorthand))};Parser.prototype.parseObjectPattern=function(params,kind){var node=this.createNode();var properties=[];this.expect("{");while(!this.match("}")){properties.push(this.parsePropertyPattern(params,kind));if(!this.match("}")){this.expect(",")}}this.expect("}");return this.finalize(node,new Node.ObjectPattern(properties))};Parser.prototype.parsePattern=function(params,kind){var pattern;if(this.match("[")){pattern=this.parseArrayPattern(params,kind)}else if(this.match("{")){pattern=this.parseObjectPattern(params,kind)}else{if(this.matchKeyword("let")&&(kind==="const"||kind==="let")){this.tolerateUnexpectedToken(this.lookahead,messages_1.Messages.LetInLexicalBinding)}params.push(this.lookahead);pattern=this.parseVariableIdentifier(kind)}return pattern};Parser.prototype.parsePatternWithDefault=function(params,kind){var startToken=this.lookahead;var pattern=this.parsePattern(params,kind);if(this.match("=")){this.nextToken();var previousAllowYield=this.context.allowYield;this.context.allowYield=true;var right=this.isolateCoverGrammar(this.parseAssignmentExpression);this.context.allowYield=previousAllowYield;pattern=this.finalize(this.startNode(startToken),new Node.AssignmentPattern(pattern,right))}return pattern};Parser.prototype.parseVariableIdentifier=function(kind){var node=this.createNode();var token=this.nextToken();if(token.type===4&&token.value==="yield"){if(this.context.strict){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictReservedWord)}else if(!this.context.allowYield){this.throwUnexpectedToken(token)}}else if(token.type!==3){if(this.context.strict&&token.type===4&&this.scanner.isStrictModeReservedWord(token.value)){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictReservedWord)}else{if(this.context.strict||token.value!=="let"||kind!=="var"){this.throwUnexpectedToken(token)}}}else if((this.context.isModule||this.context.await)&&token.type===3&&token.value==="await"){this.tolerateUnexpectedToken(token)}return this.finalize(node,new Node.Identifier(token.value))};Parser.prototype.parseVariableDeclaration=function(options){var node=this.createNode();var params=[];var id=this.parsePattern(params,"var");if(this.context.strict&&id.type===syntax_1.Syntax.Identifier){if(this.scanner.isRestrictedWord(id.name)){this.tolerateError(messages_1.Messages.StrictVarName)}}var init=null;if(this.match("=")){this.nextToken();init=this.isolateCoverGrammar(this.parseAssignmentExpression)}else if(id.type!==syntax_1.Syntax.Identifier&&!options.inFor){this.expect("=")}return this.finalize(node,new Node.VariableDeclarator(id,init))};Parser.prototype.parseVariableDeclarationList=function(options){var opt={inFor:options.inFor};var list=[];list.push(this.parseVariableDeclaration(opt));while(this.match(",")){this.nextToken();list.push(this.parseVariableDeclaration(opt))}return list};Parser.prototype.parseVariableStatement=function(){var node=this.createNode();this.expectKeyword("var");var declarations=this.parseVariableDeclarationList({inFor:false});this.consumeSemicolon();return this.finalize(node,new Node.VariableDeclaration(declarations,"var"))};Parser.prototype.parseEmptyStatement=function(){var node=this.createNode();this.expect(";");return this.finalize(node,new Node.EmptyStatement)};Parser.prototype.parseExpressionStatement=function(){var node=this.createNode();var expr=this.parseExpression();this.consumeSemicolon();return this.finalize(node,new Node.ExpressionStatement(expr))};Parser.prototype.parseIfClause=function(){if(this.context.strict&&this.matchKeyword("function")){this.tolerateError(messages_1.Messages.StrictFunction)}return this.parseStatement()};Parser.prototype.parseIfStatement=function(){var node=this.createNode();var consequent;var alternate=null;this.expectKeyword("if");this.expect("(");var test=this.parseExpression();if(!this.match(")")&&this.config.tolerant){this.tolerateUnexpectedToken(this.nextToken());consequent=this.finalize(this.createNode(),new Node.EmptyStatement)}else{this.expect(")");consequent=this.parseIfClause();if(this.matchKeyword("else")){this.nextToken();alternate=this.parseIfClause()}}return this.finalize(node,new Node.IfStatement(test,consequent,alternate))};Parser.prototype.parseDoWhileStatement=function(){var node=this.createNode();this.expectKeyword("do");var previousInIteration=this.context.inIteration;this.context.inIteration=true;var body=this.parseStatement();this.context.inIteration=previousInIteration;this.expectKeyword("while");this.expect("(");var test=this.parseExpression();if(!this.match(")")&&this.config.tolerant){this.tolerateUnexpectedToken(this.nextToken())}else{this.expect(")");if(this.match(";")){this.nextToken()}}return this.finalize(node,new Node.DoWhileStatement(body,test))};Parser.prototype.parseWhileStatement=function(){var node=this.createNode();var body;this.expectKeyword("while");this.expect("(");var test=this.parseExpression();if(!this.match(")")&&this.config.tolerant){this.tolerateUnexpectedToken(this.nextToken());body=this.finalize(this.createNode(),new Node.EmptyStatement)}else{this.expect(")");var previousInIteration=this.context.inIteration;this.context.inIteration=true;body=this.parseStatement();this.context.inIteration=previousInIteration}return this.finalize(node,new Node.WhileStatement(test,body))};Parser.prototype.parseForStatement=function(){var init=null;var test=null;var update=null;var forIn=true;var left,right;var node=this.createNode();this.expectKeyword("for");this.expect("(");if(this.match(";")){this.nextToken()}else{if(this.matchKeyword("var")){init=this.createNode();this.nextToken();var previousAllowIn=this.context.allowIn;this.context.allowIn=false;var declarations=this.parseVariableDeclarationList({inFor:true});this.context.allowIn=previousAllowIn;if(declarations.length===1&&this.matchKeyword("in")){var decl=declarations[0];if(decl.init&&(decl.id.type===syntax_1.Syntax.ArrayPattern||decl.id.type===syntax_1.Syntax.ObjectPattern||this.context.strict)){this.tolerateError(messages_1.Messages.ForInOfLoopInitializer,"for-in")}init=this.finalize(init,new Node.VariableDeclaration(declarations,"var"));this.nextToken();left=init;right=this.parseExpression();init=null}else if(declarations.length===1&&declarations[0].init===null&&this.matchContextualKeyword("of")){init=this.finalize(init,new Node.VariableDeclaration(declarations,"var"));this.nextToken();left=init;right=this.parseAssignmentExpression();init=null;forIn=false}else{init=this.finalize(init,new Node.VariableDeclaration(declarations,"var"));this.expect(";")}}else if(this.matchKeyword("const")||this.matchKeyword("let")){init=this.createNode();var kind=this.nextToken().value;if(!this.context.strict&&this.lookahead.value==="in"){init=this.finalize(init,new Node.Identifier(kind));this.nextToken();left=init;right=this.parseExpression();init=null}else{var previousAllowIn=this.context.allowIn;this.context.allowIn=false;var declarations=this.parseBindingList(kind,{inFor:true});this.context.allowIn=previousAllowIn;if(declarations.length===1&&declarations[0].init===null&&this.matchKeyword("in")){init=this.finalize(init,new Node.VariableDeclaration(declarations,kind));this.nextToken();left=init;right=this.parseExpression();init=null}else if(declarations.length===1&&declarations[0].init===null&&this.matchContextualKeyword("of")){init=this.finalize(init,new Node.VariableDeclaration(declarations,kind));this.nextToken();left=init;right=this.parseAssignmentExpression();init=null;forIn=false}else{this.consumeSemicolon();init=this.finalize(init,new Node.VariableDeclaration(declarations,kind))}}}else{var initStartToken=this.lookahead;var previousAllowIn=this.context.allowIn;this.context.allowIn=false;init=this.inheritCoverGrammar(this.parseAssignmentExpression);this.context.allowIn=previousAllowIn;if(this.matchKeyword("in")){if(!this.context.isAssignmentTarget||init.type===syntax_1.Syntax.AssignmentExpression){this.tolerateError(messages_1.Messages.InvalidLHSInForIn)}this.nextToken();this.reinterpretExpressionAsPattern(init);left=init;right=this.parseExpression();init=null}else if(this.matchContextualKeyword("of")){if(!this.context.isAssignmentTarget||init.type===syntax_1.Syntax.AssignmentExpression){this.tolerateError(messages_1.Messages.InvalidLHSInForLoop)}this.nextToken();this.reinterpretExpressionAsPattern(init);left=init;right=this.parseAssignmentExpression();init=null;forIn=false}else{if(this.match(",")){var initSeq=[init];while(this.match(",")){this.nextToken();initSeq.push(this.isolateCoverGrammar(this.parseAssignmentExpression))}init=this.finalize(this.startNode(initStartToken),new Node.SequenceExpression(initSeq))}this.expect(";")}}}if(typeof left==="undefined"){if(!this.match(";")){test=this.parseExpression()}this.expect(";");if(!this.match(")")){update=this.parseExpression()}}var body;if(!this.match(")")&&this.config.tolerant){this.tolerateUnexpectedToken(this.nextToken());body=this.finalize(this.createNode(),new Node.EmptyStatement)}else{this.expect(")");var previousInIteration=this.context.inIteration;this.context.inIteration=true;body=this.isolateCoverGrammar(this.parseStatement);this.context.inIteration=previousInIteration}return typeof left==="undefined"?this.finalize(node,new Node.ForStatement(init,test,update,body)):forIn?this.finalize(node,new Node.ForInStatement(left,right,body)):this.finalize(node,new Node.ForOfStatement(left,right,body))};Parser.prototype.parseContinueStatement=function(){var node=this.createNode();this.expectKeyword("continue");var label=null;if(this.lookahead.type===3&&!this.hasLineTerminator){var id=this.parseVariableIdentifier();label=id;var key="$"+id.name;if(!Object.prototype.hasOwnProperty.call(this.context.labelSet,key)){this.throwError(messages_1.Messages.UnknownLabel,id.name)}}this.consumeSemicolon();if(label===null&&!this.context.inIteration){this.throwError(messages_1.Messages.IllegalContinue)}return this.finalize(node,new Node.ContinueStatement(label))};Parser.prototype.parseBreakStatement=function(){var node=this.createNode();this.expectKeyword("break");var label=null;if(this.lookahead.type===3&&!this.hasLineTerminator){var id=this.parseVariableIdentifier();var key="$"+id.name;if(!Object.prototype.hasOwnProperty.call(this.context.labelSet,key)){this.throwError(messages_1.Messages.UnknownLabel,id.name)}label=id}this.consumeSemicolon();if(label===null&&!this.context.inIteration&&!this.context.inSwitch){this.throwError(messages_1.Messages.IllegalBreak)}return this.finalize(node,new Node.BreakStatement(label))};Parser.prototype.parseReturnStatement=function(){if(!this.context.inFunctionBody){this.tolerateError(messages_1.Messages.IllegalReturn)}var node=this.createNode();this.expectKeyword("return");var hasArgument=!this.match(";")&&!this.match("}")&&!this.hasLineTerminator&&this.lookahead.type!==2||this.lookahead.type===8||this.lookahead.type===10;var argument=hasArgument?this.parseExpression():null;this.consumeSemicolon();return this.finalize(node,new Node.ReturnStatement(argument))};Parser.prototype.parseWithStatement=function(){if(this.context.strict){this.tolerateError(messages_1.Messages.StrictModeWith)}var node=this.createNode();var body;this.expectKeyword("with");this.expect("(");var object=this.parseExpression();if(!this.match(")")&&this.config.tolerant){this.tolerateUnexpectedToken(this.nextToken());body=this.finalize(this.createNode(),new Node.EmptyStatement)}else{this.expect(")");body=this.parseStatement()}return this.finalize(node,new Node.WithStatement(object,body))};Parser.prototype.parseSwitchCase=function(){var node=this.createNode();var test;if(this.matchKeyword("default")){this.nextToken();test=null}else{this.expectKeyword("case");test=this.parseExpression()}this.expect(":");var consequent=[];while(true){if(this.match("}")||this.matchKeyword("default")||this.matchKeyword("case")){break}consequent.push(this.parseStatementListItem())}return this.finalize(node,new Node.SwitchCase(test,consequent))};Parser.prototype.parseSwitchStatement=function(){var node=this.createNode();this.expectKeyword("switch");this.expect("(");var discriminant=this.parseExpression();this.expect(")");var previousInSwitch=this.context.inSwitch;this.context.inSwitch=true;var cases=[];var defaultFound=false;this.expect("{");while(true){if(this.match("}")){break}var clause=this.parseSwitchCase();if(clause.test===null){if(defaultFound){this.throwError(messages_1.Messages.MultipleDefaultsInSwitch)}defaultFound=true}cases.push(clause)}this.expect("}");this.context.inSwitch=previousInSwitch;return this.finalize(node,new Node.SwitchStatement(discriminant,cases))};Parser.prototype.parseLabelledStatement=function(){var node=this.createNode();var expr=this.parseExpression();var statement;if(expr.type===syntax_1.Syntax.Identifier&&this.match(":")){this.nextToken();var id=expr;var key="$"+id.name;if(Object.prototype.hasOwnProperty.call(this.context.labelSet,key)){this.throwError(messages_1.Messages.Redeclaration,"Label",id.name)}this.context.labelSet[key]=true;var body=void 0;if(this.matchKeyword("class")){this.tolerateUnexpectedToken(this.lookahead);body=this.parseClassDeclaration()}else if(this.matchKeyword("function")){var token=this.lookahead;var declaration=this.parseFunctionDeclaration();if(this.context.strict){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictFunction)}else if(declaration.generator){this.tolerateUnexpectedToken(token,messages_1.Messages.GeneratorInLegacyContext)}body=declaration}else{body=this.parseStatement()}delete this.context.labelSet[key];statement=new Node.LabeledStatement(id,body)}else{this.consumeSemicolon();statement=new Node.ExpressionStatement(expr)}return this.finalize(node,statement)};Parser.prototype.parseThrowStatement=function(){var node=this.createNode();this.expectKeyword("throw");if(this.hasLineTerminator){this.throwError(messages_1.Messages.NewlineAfterThrow)}var argument=this.parseExpression();this.consumeSemicolon();return this.finalize(node,new Node.ThrowStatement(argument))};Parser.prototype.parseCatchClause=function(){var node=this.createNode();this.expectKeyword("catch");this.expect("(");if(this.match(")")){this.throwUnexpectedToken(this.lookahead)}var params=[];var param=this.parsePattern(params);var paramMap={};for(var i=0;i<params.length;i++){var key="$"+params[i].value;if(Object.prototype.hasOwnProperty.call(paramMap,key)){this.tolerateError(messages_1.Messages.DuplicateBinding,params[i].value)}paramMap[key]=true}if(this.context.strict&&param.type===syntax_1.Syntax.Identifier){if(this.scanner.isRestrictedWord(param.name)){this.tolerateError(messages_1.Messages.StrictCatchVariable)}}this.expect(")");var body=this.parseBlock();return this.finalize(node,new Node.CatchClause(param,body))};Parser.prototype.parseFinallyClause=function(){this.expectKeyword("finally");return this.parseBlock()};Parser.prototype.parseTryStatement=function(){var node=this.createNode();this.expectKeyword("try");var block=this.parseBlock();var handler=this.matchKeyword("catch")?this.parseCatchClause():null;var finalizer=this.matchKeyword("finally")?this.parseFinallyClause():null;if(!handler&&!finalizer){this.throwError(messages_1.Messages.NoCatchOrFinally)}return this.finalize(node,new Node.TryStatement(block,handler,finalizer))};Parser.prototype.parseDebuggerStatement=function(){var node=this.createNode();this.expectKeyword("debugger");this.consumeSemicolon();return this.finalize(node,new Node.DebuggerStatement)};Parser.prototype.parseStatement=function(){var statement;switch(this.lookahead.type){case 1:case 5:case 6:case 8:case 10:case 9:statement=this.parseExpressionStatement();break;case 7:var value=this.lookahead.value;if(value==="{"){statement=this.parseBlock()}else if(value==="("){statement=this.parseExpressionStatement()}else if(value===";"){statement=this.parseEmptyStatement()}else{statement=this.parseExpressionStatement()}break;case 3:statement=this.matchAsyncFunction()?this.parseFunctionDeclaration():this.parseLabelledStatement();break;case 4:switch(this.lookahead.value){case"break":statement=this.parseBreakStatement();break;case"continue":statement=this.parseContinueStatement();break;case"debugger":statement=this.parseDebuggerStatement();break;case"do":statement=this.parseDoWhileStatement();break;case"for":statement=this.parseForStatement();break;case"function":statement=this.parseFunctionDeclaration();break;case"if":statement=this.parseIfStatement();break;case"return":statement=this.parseReturnStatement();break;case"switch":statement=this.parseSwitchStatement();break;case"throw":statement=this.parseThrowStatement();break;case"try":statement=this.parseTryStatement();break;case"var":statement=this.parseVariableStatement();break;case"while":statement=this.parseWhileStatement();break;case"with":statement=this.parseWithStatement();break;default:statement=this.parseExpressionStatement();break}break;default:statement=this.throwUnexpectedToken(this.lookahead)}return statement};Parser.prototype.parseFunctionSourceElements=function(){var node=this.createNode();this.expect("{");var body=this.parseDirectivePrologues();var previousLabelSet=this.context.labelSet;var previousInIteration=this.context.inIteration;var previousInSwitch=this.context.inSwitch;var previousInFunctionBody=this.context.inFunctionBody;this.context.labelSet={};this.context.inIteration=false;this.context.inSwitch=false;this.context.inFunctionBody=true;while(this.lookahead.type!==2){if(this.match("}")){break}body.push(this.parseStatementListItem())}this.expect("}");this.context.labelSet=previousLabelSet;this.context.inIteration=previousInIteration;this.context.inSwitch=previousInSwitch;this.context.inFunctionBody=previousInFunctionBody;return this.finalize(node,new Node.BlockStatement(body))};Parser.prototype.validateParam=function(options,param,name){var key="$"+name;if(this.context.strict){if(this.scanner.isRestrictedWord(name)){options.stricted=param;options.message=messages_1.Messages.StrictParamName}if(Object.prototype.hasOwnProperty.call(options.paramSet,key)){options.stricted=param;options.message=messages_1.Messages.StrictParamDupe}}else if(!options.firstRestricted){if(this.scanner.isRestrictedWord(name)){options.firstRestricted=param;options.message=messages_1.Messages.StrictParamName}else if(this.scanner.isStrictModeReservedWord(name)){options.firstRestricted=param;options.message=messages_1.Messages.StrictReservedWord}else if(Object.prototype.hasOwnProperty.call(options.paramSet,key)){options.stricted=param;options.message=messages_1.Messages.StrictParamDupe}}if(typeof Object.defineProperty==="function"){Object.defineProperty(options.paramSet,key,{value:true,enumerable:true,writable:true,configurable:true})}else{options.paramSet[key]=true}};Parser.prototype.parseRestElement=function(params){var node=this.createNode();this.expect("...");var arg=this.parsePattern(params);if(this.match("=")){this.throwError(messages_1.Messages.DefaultRestParameter)}if(!this.match(")")){this.throwError(messages_1.Messages.ParameterAfterRestParameter)}return this.finalize(node,new Node.RestElement(arg))};Parser.prototype.parseFormalParameter=function(options){var params=[];var param=this.match("...")?this.parseRestElement(params):this.parsePatternWithDefault(params);for(var i=0;i<params.length;i++){this.validateParam(options,params[i],params[i].value)}options.simple=options.simple&&param instanceof Node.Identifier;options.params.push(param)};Parser.prototype.parseFormalParameters=function(firstRestricted){var options;options={simple:true,params:[],firstRestricted};this.expect("(");if(!this.match(")")){options.paramSet={};while(this.lookahead.type!==2){this.parseFormalParameter(options);if(this.match(")")){break}this.expect(",");if(this.match(")")){break}}}this.expect(")");return{simple:options.simple,params:options.params,stricted:options.stricted,firstRestricted:options.firstRestricted,message:options.message}};Parser.prototype.matchAsyncFunction=function(){var match=this.matchContextualKeyword("async");if(match){var state=this.scanner.saveState();this.scanner.scanComments();var next=this.scanner.lex();this.scanner.restoreState(state);match=state.lineNumber===next.lineNumber&&next.type===4&&next.value==="function"}return match};Parser.prototype.parseFunctionDeclaration=function(identifierIsOptional){var node=this.createNode();var isAsync=this.matchContextualKeyword("async");if(isAsync){this.nextToken()}this.expectKeyword("function");var isGenerator=isAsync?false:this.match("*");if(isGenerator){this.nextToken()}var message;var id=null;var firstRestricted=null;if(!identifierIsOptional||!this.match("(")){var token=this.lookahead;id=this.parseVariableIdentifier();if(this.context.strict){if(this.scanner.isRestrictedWord(token.value)){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictFunctionName)}}else{if(this.scanner.isRestrictedWord(token.value)){firstRestricted=token;message=messages_1.Messages.StrictFunctionName}else if(this.scanner.isStrictModeReservedWord(token.value)){firstRestricted=token;message=messages_1.Messages.StrictReservedWord}}}var previousAllowAwait=this.context.await;var previousAllowYield=this.context.allowYield;this.context.await=isAsync;this.context.allowYield=!isGenerator;var formalParameters=this.parseFormalParameters(firstRestricted);var params=formalParameters.params;var stricted=formalParameters.stricted;firstRestricted=formalParameters.firstRestricted;if(formalParameters.message){message=formalParameters.message}var previousStrict=this.context.strict;var previousAllowStrictDirective=this.context.allowStrictDirective;this.context.allowStrictDirective=formalParameters.simple;var body=this.parseFunctionSourceElements();if(this.context.strict&&firstRestricted){this.throwUnexpectedToken(firstRestricted,message)}if(this.context.strict&&stricted){this.tolerateUnexpectedToken(stricted,message)}this.context.strict=previousStrict;this.context.allowStrictDirective=previousAllowStrictDirective;this.context.await=previousAllowAwait;this.context.allowYield=previousAllowYield;return isAsync?this.finalize(node,new Node.AsyncFunctionDeclaration(id,params,body)):this.finalize(node,new Node.FunctionDeclaration(id,params,body,isGenerator))};Parser.prototype.parseFunctionExpression=function(){var node=this.createNode();var isAsync=this.matchContextualKeyword("async");if(isAsync){this.nextToken()}this.expectKeyword("function");var isGenerator=isAsync?false:this.match("*");if(isGenerator){this.nextToken()}var message;var id=null;var firstRestricted;var previousAllowAwait=this.context.await;var previousAllowYield=this.context.allowYield;this.context.await=isAsync;this.context.allowYield=!isGenerator;if(!this.match("(")){var token=this.lookahead;id=!this.context.strict&&!isGenerator&&this.matchKeyword("yield")?this.parseIdentifierName():this.parseVariableIdentifier();if(this.context.strict){if(this.scanner.isRestrictedWord(token.value)){this.tolerateUnexpectedToken(token,messages_1.Messages.StrictFunctionName)}}else{if(this.scanner.isRestrictedWord(token.value)){firstRestricted=token;message=messages_1.Messages.StrictFunctionName}else if(this.scanner.isStrictModeReservedWord(token.value)){firstRestricted=token;message=messages_1.Messages.StrictReservedWord}}}var formalParameters=this.parseFormalParameters(firstRestricted);var params=formalParameters.params;var stricted=formalParameters.stricted;firstRestricted=formalParameters.firstRestricted;if(formalParameters.message){message=formalParameters.message}var previousStrict=this.context.strict;var previousAllowStrictDirective=this.context.allowStrictDirective;this.context.allowStrictDirective=formalParameters.simple;var body=this.parseFunctionSourceElements();if(this.context.strict&&firstRestricted){this.throwUnexpectedToken(firstRestricted,message)}if(this.context.strict&&stricted){this.tolerateUnexpectedToken(stricted,message)}this.context.strict=previousStrict;this.context.allowStrictDirective=previousAllowStrictDirective;this.context.await=previousAllowAwait;this.context.allowYield=previousAllowYield;return isAsync?this.finalize(node,new Node.AsyncFunctionExpression(id,params,body)):this.finalize(node,new Node.FunctionExpression(id,params,body,isGenerator))};Parser.prototype.parseDirective=function(){var token=this.lookahead;var node=this.createNode();var expr=this.parseExpression();var directive=expr.type===syntax_1.Syntax.Literal?this.getTokenRaw(token).slice(1,-1):null;this.consumeSemicolon();return this.finalize(node,directive?new Node.Directive(expr,directive):new Node.ExpressionStatement(expr))};Parser.prototype.parseDirectivePrologues=function(){var firstRestricted=null;var body=[];while(true){var token=this.lookahead;if(token.type!==8){break}var statement=this.parseDirective();body.push(statement);var directive=statement.directive;if(typeof directive!=="string"){break}if(directive==="use strict"){this.context.strict=true;if(firstRestricted){this.tolerateUnexpectedToken(firstRestricted,messages_1.Messages.StrictOctalLiteral)}if(!this.context.allowStrictDirective){this.tolerateUnexpectedToken(token,messages_1.Messages.IllegalLanguageModeDirective)}}else{if(!firstRestricted&&token.octal){firstRestricted=token}}}return body};Parser.prototype.qualifiedPropertyName=function(token){switch(token.type){case 3:case 8:case 1:case 5:case 6:case 4:return true;case 7:return token.value==="[";default:break}return false};Parser.prototype.parseGetterMethod=function(){var node=this.createNode();var isGenerator=false;var previousAllowYield=this.context.allowYield;this.context.allowYield=!isGenerator;var formalParameters=this.parseFormalParameters();if(formalParameters.params.length>0){this.tolerateError(messages_1.Messages.BadGetterArity)}var method=this.parsePropertyMethod(formalParameters);this.context.allowYield=previousAllowYield;return this.finalize(node,new Node.FunctionExpression(null,formalParameters.params,method,isGenerator))};Parser.prototype.parseSetterMethod=function(){var node=this.createNode();var isGenerator=false;var previousAllowYield=this.context.allowYield;this.context.allowYield=!isGenerator;var formalParameters=this.parseFormalParameters();if(formalParameters.params.length!==1){this.tolerateError(messages_1.Messages.BadSetterArity)}else if(formalParameters.params[0]instanceof Node.RestElement){this.tolerateError(messages_1.Messages.BadSetterRestParameter)}var method=this.parsePropertyMethod(formalParameters);this.context.allowYield=previousAllowYield;return this.finalize(node,new Node.FunctionExpression(null,formalParameters.params,method,isGenerator))};Parser.prototype.parseGeneratorMethod=function(){var node=this.createNode();var isGenerator=true;var previousAllowYield=this.context.allowYield;this.context.allowYield=true;var params=this.parseFormalParameters();this.context.allowYield=false;var method=this.parsePropertyMethod(params);this.context.allowYield=previousAllowYield;return this.finalize(node,new Node.FunctionExpression(null,params.params,method,isGenerator))};Parser.prototype.isStartOfExpression=function(){var start=true;var value=this.lookahead.value;switch(this.lookahead.type){case 7:start=value==="["||value==="("||value==="{"||value==="+"||value==="-"||value==="!"||value==="~"||value==="++"||value==="--"||value==="/"||value==="/=";break;case 4:start=value==="class"||value==="delete"||value==="function"||value==="let"||value==="new"||value==="super"||value==="this"||value==="typeof"||value==="void"||value==="yield";break;default:break}return start};Parser.prototype.parseYieldExpression=function(){var node=this.createNode();this.expectKeyword("yield");var argument=null;var delegate=false;if(!this.hasLineTerminator){var previousAllowYield=this.context.allowYield;this.context.allowYield=false;delegate=this.match("*");if(delegate){this.nextToken();argument=this.parseAssignmentExpression()}else if(this.isStartOfExpression()){argument=this.parseAssignmentExpression()}this.context.allowYield=previousAllowYield}return this.finalize(node,new Node.YieldExpression(argument,delegate))};Parser.prototype.parseClassElement=function(hasConstructor){var token=this.lookahead;var node=this.createNode();var kind="";var key=null;var value=null;var computed=false;var method=false;var isStatic=false;var isAsync=false;if(this.match("*")){this.nextToken()}else{computed=this.match("[");key=this.parseObjectPropertyKey();var id=key;if(id.name==="static"&&(this.qualifiedPropertyName(this.lookahead)||this.match("*"))){token=this.lookahead;isStatic=true;computed=this.match("[");if(this.match("*")){this.nextToken()}else{key=this.parseObjectPropertyKey()}}if(token.type===3&&!this.hasLineTerminator&&token.value==="async"){var punctuator=this.lookahead.value;if(punctuator!==":"&&punctuator!=="("&&punctuator!=="*"){isAsync=true;token=this.lookahead;key=this.parseObjectPropertyKey();if(token.type===3&&token.value==="constructor"){this.tolerateUnexpectedToken(token,messages_1.Messages.ConstructorIsAsync)}}}}var lookaheadPropertyKey=this.qualifiedPropertyName(this.lookahead);if(token.type===3){if(token.value==="get"&&lookaheadPropertyKey){kind="get";computed=this.match("[");key=this.parseObjectPropertyKey();this.context.allowYield=false;value=this.parseGetterMethod()}else if(token.value==="set"&&lookaheadPropertyKey){kind="set";computed=this.match("[");key=this.parseObjectPropertyKey();value=this.parseSetterMethod()}}else if(token.type===7&&token.value==="*"&&lookaheadPropertyKey){kind="init";computed=this.match("[");key=this.parseObjectPropertyKey();value=this.parseGeneratorMethod();method=true}if(!kind&&key&&this.match("(")){kind="init";value=isAsync?this.parsePropertyMethodAsyncFunction():this.parsePropertyMethodFunction();method=true}if(!kind){this.throwUnexpectedToken(this.lookahead)}if(kind==="init"){kind="method"}if(!computed){if(isStatic&&this.isPropertyKey(key,"prototype")){this.throwUnexpectedToken(token,messages_1.Messages.StaticPrototype)}if(!isStatic&&this.isPropertyKey(key,"constructor")){if(kind!=="method"||!method||value&&value.generator){this.throwUnexpectedToken(token,messages_1.Messages.ConstructorSpecialMethod)}if(hasConstructor.value){this.throwUnexpectedToken(token,messages_1.Messages.DuplicateConstructor)}else{hasConstructor.value=true}kind="constructor"}}return this.finalize(node,new Node.MethodDefinition(key,computed,value,kind,isStatic))};Parser.prototype.parseClassElementList=function(){var body=[];var hasConstructor={value:false};this.expect("{");while(!this.match("}")){if(this.match(";")){this.nextToken()}else{body.push(this.parseClassElement(hasConstructor))}}this.expect("}");return body};Parser.prototype.parseClassBody=function(){var node=this.createNode();var elementList=this.parseClassElementList();return this.finalize(node,new Node.ClassBody(elementList))};Parser.prototype.parseClassDeclaration=function(identifierIsOptional){var node=this.createNode();var previousStrict=this.context.strict;this.context.strict=true;this.expectKeyword("class");var id=identifierIsOptional&&this.lookahead.type!==3?null:this.parseVariableIdentifier();var superClass=null;if(this.matchKeyword("extends")){this.nextToken();superClass=this.isolateCoverGrammar(this.parseLeftHandSideExpressionAllowCall)}var classBody=this.parseClassBody();this.context.strict=previousStrict;return this.finalize(node,new Node.ClassDeclaration(id,superClass,classBody))};Parser.prototype.parseClassExpression=function(){var node=this.createNode();var previousStrict=this.context.strict;this.context.strict=true;this.expectKeyword("class");var id=this.lookahead.type===3?this.parseVariableIdentifier():null;var superClass=null;if(this.matchKeyword("extends")){this.nextToken();superClass=this.isolateCoverGrammar(this.parseLeftHandSideExpressionAllowCall)}var classBody=this.parseClassBody();this.context.strict=previousStrict;return this.finalize(node,new Node.ClassExpression(id,superClass,classBody))};Parser.prototype.parseModule=function(){this.context.strict=true;this.context.isModule=true;this.scanner.isModule=true;var node=this.createNode();var body=this.parseDirectivePrologues();while(this.lookahead.type!==2){body.push(this.parseStatementListItem())}return this.finalize(node,new Node.Module(body))};Parser.prototype.parseScript=function(){var node=this.createNode();var body=this.parseDirectivePrologues();while(this.lookahead.type!==2){body.push(this.parseStatementListItem())}return this.finalize(node,new Node.Script(body))};Parser.prototype.parseModuleSpecifier=function(){var node=this.createNode();if(this.lookahead.type!==8){this.throwError(messages_1.Messages.InvalidModuleSpecifier)}var token=this.nextToken();var raw=this.getTokenRaw(token);return this.finalize(node,new Node.Literal(token.value,raw))};Parser.prototype.parseImportSpecifier=function(){var node=this.createNode();var imported;var local;if(this.lookahead.type===3){imported=this.parseVariableIdentifier();local=imported;if(this.matchContextualKeyword("as")){this.nextToken();local=this.parseVariableIdentifier()}}else{imported=this.parseIdentifierName();local=imported;if(this.matchContextualKeyword("as")){this.nextToken();local=this.parseVariableIdentifier()}else{this.throwUnexpectedToken(this.nextToken())}}return this.finalize(node,new Node.ImportSpecifier(local,imported))};Parser.prototype.parseNamedImports=function(){this.expect("{");var specifiers=[];while(!this.match("}")){specifiers.push(this.parseImportSpecifier());if(!this.match("}")){this.expect(",")}}this.expect("}");return specifiers};Parser.prototype.parseImportDefaultSpecifier=function(){var node=this.createNode();var local=this.parseIdentifierName();return this.finalize(node,new Node.ImportDefaultSpecifier(local))};Parser.prototype.parseImportNamespaceSpecifier=function(){var node=this.createNode();this.expect("*");if(!this.matchContextualKeyword("as")){this.throwError(messages_1.Messages.NoAsAfterImportNamespace)}this.nextToken();var local=this.parseIdentifierName();return this.finalize(node,new Node.ImportNamespaceSpecifier(local))};Parser.prototype.parseImportDeclaration=function(){if(this.context.inFunctionBody){this.throwError(messages_1.Messages.IllegalImportDeclaration)}var node=this.createNode();this.expectKeyword("import");var src;var specifiers=[];if(this.lookahead.type===8){src=this.parseModuleSpecifier()}else{if(this.match("{")){specifiers=specifiers.concat(this.parseNamedImports())}else if(this.match("*")){specifiers.push(this.parseImportNamespaceSpecifier())}else if(this.isIdentifierName(this.lookahead)&&!this.matchKeyword("default")){specifiers.push(this.parseImportDefaultSpecifier());if(this.match(",")){this.nextToken();if(this.match("*")){specifiers.push(this.parseImportNamespaceSpecifier())}else if(this.match("{")){specifiers=specifiers.concat(this.parseNamedImports())}else{this.throwUnexpectedToken(this.lookahead)}}}else{this.throwUnexpectedToken(this.nextToken())}if(!this.matchContextualKeyword("from")){var message=this.lookahead.value?messages_1.Messages.UnexpectedToken:messages_1.Messages.MissingFromClause;this.throwError(message,this.lookahead.value)}this.nextToken();src=this.parseModuleSpecifier()}this.consumeSemicolon();return this.finalize(node,new Node.ImportDeclaration(specifiers,src))};Parser.prototype.parseExportSpecifier=function(){var node=this.createNode();var local=this.parseIdentifierName();var exported=local;if(this.matchContextualKeyword("as")){this.nextToken();exported=this.parseIdentifierName()}return this.finalize(node,new Node.ExportSpecifier(local,exported))};Parser.prototype.parseExportDeclaration=function(){if(this.context.inFunctionBody){this.throwError(messages_1.Messages.IllegalExportDeclaration)}var node=this.createNode();this.expectKeyword("export");var exportDeclaration;if(this.matchKeyword("default")){this.nextToken();if(this.matchKeyword("function")){var declaration=this.parseFunctionDeclaration(true);exportDeclaration=this.finalize(node,new Node.ExportDefaultDeclaration(declaration))}else if(this.matchKeyword("class")){var declaration=this.parseClassDeclaration(true);exportDeclaration=this.finalize(node,new Node.ExportDefaultDeclaration(declaration))}else if(this.matchContextualKeyword("async")){var declaration=this.matchAsyncFunction()?this.parseFunctionDeclaration(true):this.parseAssignmentExpression();exportDeclaration=this.finalize(node,new Node.ExportDefaultDeclaration(declaration))}else{if(this.matchContextualKeyword("from")){this.throwError(messages_1.Messages.UnexpectedToken,this.lookahead.value)}var declaration=this.match("{")?this.parseObjectInitializer():this.match("[")?this.parseArrayInitializer():this.parseAssignmentExpression();this.consumeSemicolon();exportDeclaration=this.finalize(node,new Node.ExportDefaultDeclaration(declaration))}}else if(this.match("*")){this.nextToken();if(!this.matchContextualKeyword("from")){var message=this.lookahead.value?messages_1.Messages.UnexpectedToken:messages_1.Messages.MissingFromClause;this.throwError(message,this.lookahead.value)}this.nextToken();var src=this.parseModuleSpecifier();this.consumeSemicolon();exportDeclaration=this.finalize(node,new Node.ExportAllDeclaration(src))}else if(this.lookahead.type===4){var declaration=void 0;switch(this.lookahead.value){case"let":case"const":declaration=this.parseLexicalDeclaration({inFor:false});break;case"var":case"class":case"function":declaration=this.parseStatementListItem();break;default:this.throwUnexpectedToken(this.lookahead)}exportDeclaration=this.finalize(node,new Node.ExportNamedDeclaration(declaration,[],null))}else if(this.matchAsyncFunction()){var declaration=this.parseFunctionDeclaration();exportDeclaration=this.finalize(node,new Node.ExportNamedDeclaration(declaration,[],null))}else{var specifiers=[];var source=null;var isExportFromIdentifier=false;this.expect("{");while(!this.match("}")){isExportFromIdentifier=isExportFromIdentifier||this.matchKeyword("default");specifiers.push(this.parseExportSpecifier());if(!this.match("}")){this.expect(",")}}this.expect("}");if(this.matchContextualKeyword("from")){this.nextToken();source=this.parseModuleSpecifier();this.consumeSemicolon()}else if(isExportFromIdentifier){var message=this.lookahead.value?messages_1.Messages.UnexpectedToken:messages_1.Messages.MissingFromClause;this.throwError(message,this.lookahead.value)}else{this.consumeSemicolon()}exportDeclaration=this.finalize(node,new Node.ExportNamedDeclaration(null,specifiers,source))}return exportDeclaration};return Parser}();exports.Parser=Parser},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function assert(condition,message){if(!condition){throw new Error("ASSERT: "+message)}}exports.assert=assert},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var ErrorHandler=function(){function ErrorHandler(){this.errors=[];this.tolerant=false}ErrorHandler.prototype.recordError=function(error){this.errors.push(error)};ErrorHandler.prototype.tolerate=function(error){if(this.tolerant){this.recordError(error)}else{throw error}};ErrorHandler.prototype.constructError=function(msg,column){var error=new Error(msg);try{throw error}catch(base){if(Object.create&&Object.defineProperty){error=Object.create(base);Object.defineProperty(error,"column",{value:column})}}return error};ErrorHandler.prototype.createError=function(index,line,col,description){var msg="Line "+line+": "+description;var error=this.constructError(msg,col);error.index=index;error.lineNumber=line;error.description=description;return error};ErrorHandler.prototype.throwError=function(index,line,col,description){throw this.createError(index,line,col,description)};ErrorHandler.prototype.tolerateError=function(index,line,col,description){var error=this.createError(index,line,col,description);if(this.tolerant){this.recordError(error)}else{throw error}};return ErrorHandler}();exports.ErrorHandler=ErrorHandler},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Messages={BadGetterArity:"Getter must not have any formal parameters",BadSetterArity:"Setter must have exactly one formal parameter",BadSetterRestParameter:"Setter function argument must not be a rest parameter",ConstructorIsAsync:"Class constructor may not be an async method",ConstructorSpecialMethod:"Class constructor may not be an accessor",DeclarationMissingInitializer:"Missing initializer in %0 declaration",DefaultRestParameter:"Unexpected token =",DuplicateBinding:"Duplicate binding %0",DuplicateConstructor:"A class may only have one constructor",DuplicateProtoProperty:"Duplicate __proto__ fields are not allowed in object literals",ForInOfLoopInitializer:"%0 loop variable declaration may not have an initializer",GeneratorInLegacyContext:"Generator declarations are not allowed in legacy contexts",IllegalBreak:"Illegal break statement",IllegalContinue:"Illegal continue statement",IllegalExportDeclaration:"Unexpected token",IllegalImportDeclaration:"Unexpected token",IllegalLanguageModeDirective:"Illegal 'use strict' directive in function with non-simple parameter list",IllegalReturn:"Illegal return statement",InvalidEscapedReservedWord:"Keyword must not contain escaped characters",InvalidHexEscapeSequence:"Invalid hexadecimal escape sequence",InvalidLHSInAssignment:"Invalid left-hand side in assignment",InvalidLHSInForIn:"Invalid left-hand side in for-in",InvalidLHSInForLoop:"Invalid left-hand side in for-loop",InvalidModuleSpecifier:"Unexpected token",InvalidRegExp:"Invalid regular expression",LetInLexicalBinding:"let is disallowed as a lexically bound name",MissingFromClause:"Unexpected token",MultipleDefaultsInSwitch:"More than one default clause in switch statement",NewlineAfterThrow:"Illegal newline after throw",NoAsAfterImportNamespace:"Unexpected token",NoCatchOrFinally:"Missing catch or finally after try",ParameterAfterRestParameter:"Rest parameter must be last formal parameter",Redeclaration:"%0 '%1' has already been declared",StaticPrototype:"Classes may not have static property named prototype",StrictCatchVariable:"Catch variable may not be eval or arguments in strict mode",StrictDelete:"Delete of an unqualified identifier in strict mode.",StrictFunction:"In strict mode code, functions can only be declared at top level or inside a block",StrictFunctionName:"Function name may not be eval or arguments in strict mode",StrictLHSAssignment:"Assignment to eval or arguments is not allowed in strict mode",StrictLHSPostfix:"Postfix increment/decrement may not have eval or arguments operand in strict mode",StrictLHSPrefix:"Prefix increment/decrement may not have eval or arguments operand in strict mode",StrictModeWith:"Strict mode code may not include a with statement",StrictOctalLiteral:"Octal literals are not allowed in strict mode.",StrictParamDupe:"Strict mode function may not have duplicate parameter names",StrictParamName:"Parameter name eval or arguments is not allowed in strict mode",StrictReservedWord:"Use of future reserved word in strict mode",StrictVarName:"Variable name may not be eval or arguments in strict mode",TemplateOctalLiteral:"Octal literals are not allowed in template strings.",UnexpectedEOS:"Unexpected end of input",UnexpectedIdentifier:"Unexpected identifier",UnexpectedNumber:"Unexpected number",UnexpectedReserved:"Unexpected reserved word",UnexpectedString:"Unexpected string",UnexpectedTemplate:"Unexpected quasi %0",UnexpectedToken:"Unexpected token %0",UnexpectedTokenIllegal:"Unexpected token ILLEGAL",UnknownLabel:"Undefined label '%0'",UnterminatedRegExp:"Invalid regular expression: missing /"}},function(module,exports,__nested_webpack_require_226595__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var assert_1=__nested_webpack_require_226595__(9);var character_1=__nested_webpack_require_226595__(4);var messages_1=__nested_webpack_require_226595__(11);function hexValue(ch){return"0123456789abcdef".indexOf(ch.toLowerCase())}function octalValue(ch){return"01234567".indexOf(ch)}var Scanner=function(){function Scanner(code,handler){this.source=code;this.errorHandler=handler;this.trackComment=false;this.isModule=false;this.length=code.length;this.index=0;this.lineNumber=code.length>0?1:0;this.lineStart=0;this.curlyStack=[]}Scanner.prototype.saveState=function(){return{index:this.index,lineNumber:this.lineNumber,lineStart:this.lineStart}};Scanner.prototype.restoreState=function(state){this.index=state.index;this.lineNumber=state.lineNumber;this.lineStart=state.lineStart};Scanner.prototype.eof=function(){return this.index>=this.length};Scanner.prototype.throwUnexpectedToken=function(message){if(message===void 0){message=messages_1.Messages.UnexpectedTokenIllegal}return this.errorHandler.throwError(this.index,this.lineNumber,this.index-this.lineStart+1,message)};Scanner.prototype.tolerateUnexpectedToken=function(message){if(message===void 0){message=messages_1.Messages.UnexpectedTokenIllegal}this.errorHandler.tolerateError(this.index,this.lineNumber,this.index-this.lineStart+1,message)};Scanner.prototype.skipSingleLineComment=function(offset){var comments=[];var start,loc;if(this.trackComment){comments=[];start=this.index-offset;loc={start:{line:this.lineNumber,column:this.index-this.lineStart-offset},end:{}}}while(!this.eof()){var ch=this.source.charCodeAt(this.index);++this.index;if(character_1.Character.isLineTerminator(ch)){if(this.trackComment){loc.end={line:this.lineNumber,column:this.index-this.lineStart-1};var entry={multiLine:false,slice:[start+offset,this.index-1],range:[start,this.index-1],loc};comments.push(entry)}if(ch===13&&this.source.charCodeAt(this.index)===10){++this.index}++this.lineNumber;this.lineStart=this.index;return comments}}if(this.trackComment){loc.end={line:this.lineNumber,column:this.index-this.lineStart};var entry={multiLine:false,slice:[start+offset,this.index],range:[start,this.index],loc};comments.push(entry)}return comments};Scanner.prototype.skipMultiLineComment=function(){var comments=[];var start,loc;if(this.trackComment){comments=[];start=this.index-2;loc={start:{line:this.lineNumber,column:this.index-this.lineStart-2},end:{}}}while(!this.eof()){var ch=this.source.charCodeAt(this.index);if(character_1.Character.isLineTerminator(ch)){if(ch===13&&this.source.charCodeAt(this.index+1)===10){++this.index}++this.lineNumber;++this.index;this.lineStart=this.index}else if(ch===42){if(this.source.charCodeAt(this.index+1)===47){this.index+=2;if(this.trackComment){loc.end={line:this.lineNumber,column:this.index-this.lineStart};var entry={multiLine:true,slice:[start+2,this.index-2],range:[start,this.index],loc};comments.push(entry)}return comments}++this.index}else{++this.index}}if(this.trackComment){loc.end={line:this.lineNumber,column:this.index-this.lineStart};var entry={multiLine:true,slice:[start+2,this.index],range:[start,this.index],loc};comments.push(entry)}this.tolerateUnexpectedToken();return comments};Scanner.prototype.scanComments=function(){var comments;if(this.trackComment){comments=[]}var start=this.index===0;while(!this.eof()){var ch=this.source.charCodeAt(this.index);if(character_1.Character.isWhiteSpace(ch)){++this.index}else if(character_1.Character.isLineTerminator(ch)){++this.index;if(ch===13&&this.source.charCodeAt(this.index)===10){++this.index}++this.lineNumber;this.lineStart=this.index;start=true}else if(ch===47){ch=this.source.charCodeAt(this.index+1);if(ch===47){this.index+=2;var comment=this.skipSingleLineComment(2);if(this.trackComment){comments=comments.concat(comment)}start=true}else if(ch===42){this.index+=2;var comment=this.skipMultiLineComment();if(this.trackComment){comments=comments.concat(comment)}}else{break}}else if(start&&ch===45){if(this.source.charCodeAt(this.index+1)===45&&this.source.charCodeAt(this.index+2)===62){this.index+=3;var comment=this.skipSingleLineComment(3);if(this.trackComment){comments=comments.concat(comment)}}else{break}}else if(ch===60&&!this.isModule){if(this.source.slice(this.index+1,this.index+4)==="!--"){this.index+=4;var comment=this.skipSingleLineComment(4);if(this.trackComment){comments=comments.concat(comment)}}else{break}}else{break}}return comments};Scanner.prototype.isFutureReservedWord=function(id){switch(id){case"enum":case"export":case"import":case"super":return true;default:return false}};Scanner.prototype.isStrictModeReservedWord=function(id){switch(id){case"implements":case"interface":case"package":case"private":case"protected":case"public":case"static":case"yield":case"let":return true;default:return false}};Scanner.prototype.isRestrictedWord=function(id){return id==="eval"||id==="arguments"};Scanner.prototype.isKeyword=function(id){switch(id.length){case 2:return id==="if"||id==="in"||id==="do";case 3:return id==="var"||id==="for"||id==="new"||id==="try"||id==="let";case 4:return id==="this"||id==="else"||id==="case"||id==="void"||id==="with"||id==="enum";case 5:return id==="while"||id==="break"||id==="catch"||id==="throw"||id==="const"||id==="yield"||id==="class"||id==="super";case 6:return id==="return"||id==="typeof"||id==="delete"||id==="switch"||id==="export"||id==="import";case 7:return id==="default"||id==="finally"||id==="extends";case 8:return id==="function"||id==="continue"||id==="debugger";case 10:return id==="instanceof";default:return false}};Scanner.prototype.codePointAt=function(i){var cp=this.source.charCodeAt(i);if(cp>=55296&&cp<=56319){var second=this.source.charCodeAt(i+1);if(second>=56320&&second<=57343){var first=cp;cp=(first-55296)*1024+second-56320+65536}}return cp};Scanner.prototype.scanHexEscape=function(prefix){var len=prefix==="u"?4:2;var code=0;for(var i=0;i<len;++i){if(!this.eof()&&character_1.Character.isHexDigit(this.source.charCodeAt(this.index))){code=code*16+hexValue(this.source[this.index++])}else{return null}}return String.fromCharCode(code)};Scanner.prototype.scanUnicodeCodePointEscape=function(){var ch=this.source[this.index];var code=0;if(ch==="}"){this.throwUnexpectedToken()}while(!this.eof()){ch=this.source[this.index++];if(!character_1.Character.isHexDigit(ch.charCodeAt(0))){break}code=code*16+hexValue(ch)}if(code>1114111||ch!=="}"){this.throwUnexpectedToken()}return character_1.Character.fromCodePoint(code)};Scanner.prototype.getIdentifier=function(){var start=this.index++;while(!this.eof()){var ch=this.source.charCodeAt(this.index);if(ch===92){this.index=start;return this.getComplexIdentifier()}else if(ch>=55296&&ch<57343){this.index=start;return this.getComplexIdentifier()}if(character_1.Character.isIdentifierPart(ch)){++this.index}else{break}}return this.source.slice(start,this.index)};Scanner.prototype.getComplexIdentifier=function(){var cp=this.codePointAt(this.index);var id=character_1.Character.fromCodePoint(cp);this.index+=id.length;var ch;if(cp===92){if(this.source.charCodeAt(this.index)!==117){this.throwUnexpectedToken()}++this.index;if(this.source[this.index]==="{"){++this.index;ch=this.scanUnicodeCodePointEscape()}else{ch=this.scanHexEscape("u");if(ch===null||ch==="\\"||!character_1.Character.isIdentifierStart(ch.charCodeAt(0))){this.throwUnexpectedToken()}}id=ch}while(!this.eof()){cp=this.codePointAt(this.index);if(!character_1.Character.isIdentifierPart(cp)){break}ch=character_1.Character.fromCodePoint(cp);id+=ch;this.index+=ch.length;if(cp===92){id=id.substr(0,id.length-1);if(this.source.charCodeAt(this.index)!==117){this.throwUnexpectedToken()}++this.index;if(this.source[this.index]==="{"){++this.index;ch=this.scanUnicodeCodePointEscape()}else{ch=this.scanHexEscape("u");if(ch===null||ch==="\\"||!character_1.Character.isIdentifierPart(ch.charCodeAt(0))){this.throwUnexpectedToken()}}id+=ch}}return id};Scanner.prototype.octalToDecimal=function(ch){var octal=ch!=="0";var code=octalValue(ch);if(!this.eof()&&character_1.Character.isOctalDigit(this.source.charCodeAt(this.index))){octal=true;code=code*8+octalValue(this.source[this.index++]);if("0123".indexOf(ch)>=0&&!this.eof()&&character_1.Character.isOctalDigit(this.source.charCodeAt(this.index))){code=code*8+octalValue(this.source[this.index++])}}return{code,octal}};Scanner.prototype.scanIdentifier=function(){var type;var start=this.index;var id=this.source.charCodeAt(start)===92?this.getComplexIdentifier():this.getIdentifier();if(id.length===1){type=3}else if(this.isKeyword(id)){type=4}else if(id==="null"){type=5}else if(id==="true"||id==="false"){type=1}else{type=3}if(type!==3&&start+id.length!==this.index){var restore=this.index;this.index=start;this.tolerateUnexpectedToken(messages_1.Messages.InvalidEscapedReservedWord);this.index=restore}return{type,value:id,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanPunctuator=function(){var start=this.index;var str=this.source[this.index];switch(str){case"(":case"{":if(str==="{"){this.curlyStack.push("{")}++this.index;break;case".":++this.index;if(this.source[this.index]==="."&&this.source[this.index+1]==="."){this.index+=2;str="..."}break;case"}":++this.index;this.curlyStack.pop();break;case")":case";":case",":case"[":case"]":case":":case"?":case"~":++this.index;break;default:str=this.source.substr(this.index,4);if(str===">>>="){this.index+=4}else{str=str.substr(0,3);if(str==="==="||str==="!=="||str===">>>"||str==="<<="||str===">>="||str==="**="){this.index+=3}else{str=str.substr(0,2);if(str==="&&"||str==="||"||str==="=="||str==="!="||str==="+="||str==="-="||str==="*="||str==="/="||str==="++"||str==="--"||str==="<<"||str===">>"||str==="&="||str==="|="||str==="^="||str==="%="||str==="<="||str===">="||str==="=>"||str==="**"){this.index+=2}else{str=this.source[this.index];if("<>=!+-*%&|^/".indexOf(str)>=0){++this.index}}}}}if(this.index===start){this.throwUnexpectedToken()}return{type:7,value:str,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanHexLiteral=function(start){var num="";while(!this.eof()){if(!character_1.Character.isHexDigit(this.source.charCodeAt(this.index))){break}num+=this.source[this.index++]}if(num.length===0){this.throwUnexpectedToken()}if(character_1.Character.isIdentifierStart(this.source.charCodeAt(this.index))){this.throwUnexpectedToken()}return{type:6,value:parseInt("0x"+num,16),lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanBinaryLiteral=function(start){var num="";var ch;while(!this.eof()){ch=this.source[this.index];if(ch!=="0"&&ch!=="1"){break}num+=this.source[this.index++]}if(num.length===0){this.throwUnexpectedToken()}if(!this.eof()){ch=this.source.charCodeAt(this.index);if(character_1.Character.isIdentifierStart(ch)||character_1.Character.isDecimalDigit(ch)){this.throwUnexpectedToken()}}return{type:6,value:parseInt(num,2),lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanOctalLiteral=function(prefix,start){var num="";var octal=false;if(character_1.Character.isOctalDigit(prefix.charCodeAt(0))){octal=true;num="0"+this.source[this.index++]}else{++this.index}while(!this.eof()){if(!character_1.Character.isOctalDigit(this.source.charCodeAt(this.index))){break}num+=this.source[this.index++]}if(!octal&&num.length===0){this.throwUnexpectedToken()}if(character_1.Character.isIdentifierStart(this.source.charCodeAt(this.index))||character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){this.throwUnexpectedToken()}return{type:6,value:parseInt(num,8),octal,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.isImplicitOctalLiteral=function(){for(var i=this.index+1;i<this.length;++i){var ch=this.source[i];if(ch==="8"||ch==="9"){return false}if(!character_1.Character.isOctalDigit(ch.charCodeAt(0))){return true}}return true};Scanner.prototype.scanNumericLiteral=function(){var start=this.index;var ch=this.source[start];assert_1.assert(character_1.Character.isDecimalDigit(ch.charCodeAt(0))||ch===".","Numeric literal must start with a decimal digit or a decimal point");var num="";if(ch!=="."){num=this.source[this.index++];ch=this.source[this.index];if(num==="0"){if(ch==="x"||ch==="X"){++this.index;return this.scanHexLiteral(start)}if(ch==="b"||ch==="B"){++this.index;return this.scanBinaryLiteral(start)}if(ch==="o"||ch==="O"){return this.scanOctalLiteral(ch,start)}if(ch&&character_1.Character.isOctalDigit(ch.charCodeAt(0))){if(this.isImplicitOctalLiteral()){return this.scanOctalLiteral(ch,start)}}}while(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){num+=this.source[this.index++]}ch=this.source[this.index]}if(ch==="."){num+=this.source[this.index++];while(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){num+=this.source[this.index++]}ch=this.source[this.index]}if(ch==="e"||ch==="E"){num+=this.source[this.index++];ch=this.source[this.index];if(ch==="+"||ch==="-"){num+=this.source[this.index++]}if(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){while(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){num+=this.source[this.index++]}}else{this.throwUnexpectedToken()}}if(character_1.Character.isIdentifierStart(this.source.charCodeAt(this.index))){this.throwUnexpectedToken()}return{type:6,value:parseFloat(num),lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanStringLiteral=function(){var start=this.index;var quote=this.source[start];assert_1.assert(quote==="'"||quote==='"',"String literal must starts with a quote");++this.index;var octal=false;var str="";while(!this.eof()){var ch=this.source[this.index++];if(ch===quote){quote="";break}else if(ch==="\\"){ch=this.source[this.index++];if(!ch||!character_1.Character.isLineTerminator(ch.charCodeAt(0))){switch(ch){case"u":if(this.source[this.index]==="{"){++this.index;str+=this.scanUnicodeCodePointEscape()}else{var unescaped_1=this.scanHexEscape(ch);if(unescaped_1===null){this.throwUnexpectedToken()}str+=unescaped_1}break;case"x":var unescaped=this.scanHexEscape(ch);if(unescaped===null){this.throwUnexpectedToken(messages_1.Messages.InvalidHexEscapeSequence)}str+=unescaped;break;case"n":str+="\n";break;case"r":str+="\r";break;case"t":str+="\t";break;case"b":str+="\b";break;case"f":str+="\f";break;case"v":str+="\v";break;case"8":case"9":str+=ch;this.tolerateUnexpectedToken();break;default:if(ch&&character_1.Character.isOctalDigit(ch.charCodeAt(0))){var octToDec=this.octalToDecimal(ch);octal=octToDec.octal||octal;str+=String.fromCharCode(octToDec.code)}else{str+=ch}break}}else{++this.lineNumber;if(ch==="\r"&&this.source[this.index]==="\n"){++this.index}this.lineStart=this.index}}else if(character_1.Character.isLineTerminator(ch.charCodeAt(0))){break}else{str+=ch}}if(quote!==""){this.index=start;this.throwUnexpectedToken()}return{type:8,value:str,octal,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.scanTemplate=function(){var cooked="";var terminated=false;var start=this.index;var head=this.source[start]==="`";var tail=false;var rawOffset=2;++this.index;while(!this.eof()){var ch=this.source[this.index++];if(ch==="`"){rawOffset=1;tail=true;terminated=true;break}else if(ch==="$"){if(this.source[this.index]==="{"){this.curlyStack.push("${");++this.index;terminated=true;break}cooked+=ch}else if(ch==="\\"){ch=this.source[this.index++];if(!character_1.Character.isLineTerminator(ch.charCodeAt(0))){switch(ch){case"n":cooked+="\n";break;case"r":cooked+="\r";break;case"t":cooked+="\t";break;case"u":if(this.source[this.index]==="{"){++this.index;cooked+=this.scanUnicodeCodePointEscape()}else{var restore=this.index;var unescaped_2=this.scanHexEscape(ch);if(unescaped_2!==null){cooked+=unescaped_2}else{this.index=restore;cooked+=ch}}break;case"x":var unescaped=this.scanHexEscape(ch);if(unescaped===null){this.throwUnexpectedToken(messages_1.Messages.InvalidHexEscapeSequence)}cooked+=unescaped;break;case"b":cooked+="\b";break;case"f":cooked+="\f";break;case"v":cooked+="\v";break;default:if(ch==="0"){if(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index))){this.throwUnexpectedToken(messages_1.Messages.TemplateOctalLiteral)}cooked+="\0"}else if(character_1.Character.isOctalDigit(ch.charCodeAt(0))){this.throwUnexpectedToken(messages_1.Messages.TemplateOctalLiteral)}else{cooked+=ch}break}}else{++this.lineNumber;if(ch==="\r"&&this.source[this.index]==="\n"){++this.index}this.lineStart=this.index}}else if(character_1.Character.isLineTerminator(ch.charCodeAt(0))){++this.lineNumber;if(ch==="\r"&&this.source[this.index]==="\n"){++this.index}this.lineStart=this.index;cooked+="\n"}else{cooked+=ch}}if(!terminated){this.throwUnexpectedToken()}if(!head){this.curlyStack.pop()}return{type:10,value:this.source.slice(start+1,this.index-rawOffset),cooked,head,tail,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.testRegExp=function(pattern,flags){var astralSubstitute="￿";var tmp=pattern;var self=this;if(flags.indexOf("u")>=0){tmp=tmp.replace(/\\u\{([0-9a-fA-F]+)\}|\\u([a-fA-F0-9]{4})/g,(function($0,$1,$2){var codePoint=parseInt($1||$2,16);if(codePoint>1114111){self.throwUnexpectedToken(messages_1.Messages.InvalidRegExp)}if(codePoint<=65535){return String.fromCharCode(codePoint)}return astralSubstitute})).replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g,astralSubstitute)}try{RegExp(tmp)}catch(e){this.throwUnexpectedToken(messages_1.Messages.InvalidRegExp)}try{return new RegExp(pattern,flags)}catch(exception){return null}};Scanner.prototype.scanRegExpBody=function(){var ch=this.source[this.index];assert_1.assert(ch==="/","Regular expression literal must start with a slash");var str=this.source[this.index++];var classMarker=false;var terminated=false;while(!this.eof()){ch=this.source[this.index++];str+=ch;if(ch==="\\"){ch=this.source[this.index++];if(character_1.Character.isLineTerminator(ch.charCodeAt(0))){this.throwUnexpectedToken(messages_1.Messages.UnterminatedRegExp)}str+=ch}else if(character_1.Character.isLineTerminator(ch.charCodeAt(0))){this.throwUnexpectedToken(messages_1.Messages.UnterminatedRegExp)}else if(classMarker){if(ch==="]"){classMarker=false}}else{if(ch==="/"){terminated=true;break}else if(ch==="["){classMarker=true}}}if(!terminated){this.throwUnexpectedToken(messages_1.Messages.UnterminatedRegExp)}return str.substr(1,str.length-2)};Scanner.prototype.scanRegExpFlags=function(){var str="";var flags="";while(!this.eof()){var ch=this.source[this.index];if(!character_1.Character.isIdentifierPart(ch.charCodeAt(0))){break}++this.index;if(ch==="\\"&&!this.eof()){ch=this.source[this.index];if(ch==="u"){++this.index;var restore=this.index;var char=this.scanHexEscape("u");if(char!==null){flags+=char;for(str+="\\u";restore<this.index;++restore){str+=this.source[restore]}}else{this.index=restore;flags+="u";str+="\\u"}this.tolerateUnexpectedToken()}else{str+="\\";this.tolerateUnexpectedToken()}}else{flags+=ch;str+=ch}}return flags};Scanner.prototype.scanRegExp=function(){var start=this.index;var pattern=this.scanRegExpBody();var flags=this.scanRegExpFlags();var value=this.testRegExp(pattern,flags);return{type:9,value:"",pattern,flags,regex:value,lineNumber:this.lineNumber,lineStart:this.lineStart,start,end:this.index}};Scanner.prototype.lex=function(){if(this.eof()){return{type:2,value:"",lineNumber:this.lineNumber,lineStart:this.lineStart,start:this.index,end:this.index}}var cp=this.source.charCodeAt(this.index);if(character_1.Character.isIdentifierStart(cp)){return this.scanIdentifier()}if(cp===40||cp===41||cp===59){return this.scanPunctuator()}if(cp===39||cp===34){return this.scanStringLiteral()}if(cp===46){if(character_1.Character.isDecimalDigit(this.source.charCodeAt(this.index+1))){return this.scanNumericLiteral()}return this.scanPunctuator()}if(character_1.Character.isDecimalDigit(cp)){return this.scanNumericLiteral()}if(cp===96||cp===125&&this.curlyStack[this.curlyStack.length-1]==="${"){return this.scanTemplate()}if(cp>=55296&&cp<57343){if(character_1.Character.isIdentifierStart(this.codePointAt(this.index))){return this.scanIdentifier()}}return this.scanPunctuator()};return Scanner}();exports.Scanner=Scanner},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.TokenName={};exports.TokenName[1]="Boolean";exports.TokenName[2]="<end>";exports.TokenName[3]="Identifier";exports.TokenName[4]="Keyword";exports.TokenName[5]="Null";exports.TokenName[6]="Numeric";exports.TokenName[7]="Punctuator";exports.TokenName[8]="String";exports.TokenName[9]="RegularExpression";exports.TokenName[10]="Template"},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.XHTMLEntities={quot:'"',amp:"&",apos:"'",gt:">",nbsp:" ",iexcl:"¡",cent:"¢",pound:"£",curren:"¤",yen:"¥",brvbar:"¦",sect:"§",uml:"¨",copy:"©",ordf:"ª",laquo:"«",not:"¬",shy:"­",reg:"®",macr:"¯",deg:"°",plusmn:"±",sup2:"²",sup3:"³",acute:"´",micro:"µ",para:"¶",middot:"·",cedil:"¸",sup1:"¹",ordm:"º",raquo:"»",frac14:"¼",frac12:"½",frac34:"¾",iquest:"¿",Agrave:"À",Aacute:"Á",Acirc:"Â",Atilde:"Ã",Auml:"Ä",Aring:"Å",AElig:"Æ",Ccedil:"Ç",Egrave:"È",Eacute:"É",Ecirc:"Ê",Euml:"Ë",Igrave:"Ì",Iacute:"Í",Icirc:"Î",Iuml:"Ï",ETH:"Ð",Ntilde:"Ñ",Ograve:"Ò",Oacute:"Ó",Ocirc:"Ô",Otilde:"Õ",Ouml:"Ö",times:"×",Oslash:"Ø",Ugrave:"Ù",Uacute:"Ú",Ucirc:"Û",Uuml:"Ü",Yacute:"Ý",THORN:"Þ",szlig:"ß",agrave:"à",aacute:"á",acirc:"â",atilde:"ã",auml:"ä",aring:"å",aelig:"æ",ccedil:"ç",egrave:"è",eacute:"é",ecirc:"ê",euml:"ë",igrave:"ì",iacute:"í",icirc:"î",iuml:"ï",eth:"ð",ntilde:"ñ",ograve:"ò",oacute:"ó",ocirc:"ô",otilde:"õ",ouml:"ö",divide:"÷",oslash:"ø",ugrave:"ù",uacute:"ú",ucirc:"û",uuml:"ü",yacute:"ý",thorn:"þ",yuml:"ÿ",OElig:"Œ",oelig:"œ",Scaron:"Š",scaron:"š",Yuml:"Ÿ",fnof:"ƒ",circ:"ˆ",tilde:"˜",Alpha:"Α",Beta:"Β",Gamma:"Γ",Delta:"Δ",Epsilon:"Ε",Zeta:"Ζ",Eta:"Η",Theta:"Θ",Iota:"Ι",Kappa:"Κ",Lambda:"Λ",Mu:"Μ",Nu:"Ν",Xi:"Ξ",Omicron:"Ο",Pi:"Π",Rho:"Ρ",Sigma:"Σ",Tau:"Τ",Upsilon:"Υ",Phi:"Φ",Chi:"Χ",Psi:"Ψ",Omega:"Ω",alpha:"α",beta:"β",gamma:"γ",delta:"δ",epsilon:"ε",zeta:"ζ",eta:"η",theta:"θ",iota:"ι",kappa:"κ",lambda:"λ",mu:"μ",nu:"ν",xi:"ξ",omicron:"ο",pi:"π",rho:"ρ",sigmaf:"ς",sigma:"σ",tau:"τ",upsilon:"υ",phi:"φ",chi:"χ",psi:"ψ",omega:"ω",thetasym:"ϑ",upsih:"ϒ",piv:"ϖ",ensp:" ",emsp:" ",thinsp:" ",zwnj:"‌",zwj:"‍",lrm:"‎",rlm:"‏",ndash:"–",mdash:"—",lsquo:"‘",rsquo:"’",sbquo:"‚",ldquo:"“",rdquo:"”",bdquo:"„",dagger:"†",Dagger:"‡",bull:"•",hellip:"…",permil:"‰",prime:"′",Prime:"″",lsaquo:"‹",rsaquo:"›",oline:"‾",frasl:"⁄",euro:"€",image:"ℑ",weierp:"℘",real:"ℜ",trade:"™",alefsym:"ℵ",larr:"←",uarr:"↑",rarr:"→",darr:"↓",harr:"↔",crarr:"↵",lArr:"⇐",uArr:"⇑",rArr:"⇒",dArr:"⇓",hArr:"⇔",forall:"∀",part:"∂",exist:"∃",empty:"∅",nabla:"∇",isin:"∈",notin:"∉",ni:"∋",prod:"∏",sum:"∑",minus:"−",lowast:"∗",radic:"√",prop:"∝",infin:"∞",ang:"∠",and:"∧",or:"∨",cap:"∩",cup:"∪",int:"∫",there4:"∴",sim:"∼",cong:"≅",asymp:"≈",ne:"≠",equiv:"≡",le:"≤",ge:"≥",sub:"⊂",sup:"⊃",nsub:"⊄",sube:"⊆",supe:"⊇",oplus:"⊕",otimes:"⊗",perp:"⊥",sdot:"⋅",lceil:"⌈",rceil:"⌉",lfloor:"⌊",rfloor:"⌋",loz:"◊",spades:"♠",clubs:"♣",hearts:"♥",diams:"♦",lang:"⟨",rang:"⟩"}},function(module,exports,__nested_webpack_require_277122__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var error_handler_1=__nested_webpack_require_277122__(10);var scanner_1=__nested_webpack_require_277122__(12);var token_1=__nested_webpack_require_277122__(13);var Reader=function(){function Reader(){this.values=[];this.curly=this.paren=-1}Reader.prototype.beforeFunctionExpression=function(t){return["(","{","[","in","typeof","instanceof","new","return","case","delete","throw","void","=","+=","-=","*=","**=","/=","%=","<<=",">>=",">>>=","&=","|=","^=",",","+","-","*","**","/","%","++","--","<<",">>",">>>","&","|","^","!","~","&&","||","?",":","===","==",">=","<=","<",">","!=","!=="].indexOf(t)>=0};Reader.prototype.isRegexStart=function(){var previous=this.values[this.values.length-1];var regex=previous!==null;switch(previous){case"this":case"]":regex=false;break;case")":var keyword=this.values[this.paren-1];regex=keyword==="if"||keyword==="while"||keyword==="for"||keyword==="with";break;case"}":regex=false;if(this.values[this.curly-3]==="function"){var check=this.values[this.curly-4];regex=check?!this.beforeFunctionExpression(check):false}else if(this.values[this.curly-4]==="function"){var check=this.values[this.curly-5];regex=check?!this.beforeFunctionExpression(check):true}break;default:break}return regex};Reader.prototype.push=function(token){if(token.type===7||token.type===4){if(token.value==="{"){this.curly=this.values.length}else if(token.value==="("){this.paren=this.values.length}this.values.push(token.value)}else{this.values.push(null)}};return Reader}();var Tokenizer=function(){function Tokenizer(code,config){this.errorHandler=new error_handler_1.ErrorHandler;this.errorHandler.tolerant=config?typeof config.tolerant==="boolean"&&config.tolerant:false;this.scanner=new scanner_1.Scanner(code,this.errorHandler);this.scanner.trackComment=config?typeof config.comment==="boolean"&&config.comment:false;this.trackRange=config?typeof config.range==="boolean"&&config.range:false;this.trackLoc=config?typeof config.loc==="boolean"&&config.loc:false;this.buffer=[];this.reader=new Reader}Tokenizer.prototype.errors=function(){return this.errorHandler.errors};Tokenizer.prototype.getNextToken=function(){if(this.buffer.length===0){var comments=this.scanner.scanComments();if(this.scanner.trackComment){for(var i=0;i<comments.length;++i){var e=comments[i];var value=this.scanner.source.slice(e.slice[0],e.slice[1]);var comment={type:e.multiLine?"BlockComment":"LineComment",value};if(this.trackRange){comment.range=e.range}if(this.trackLoc){comment.loc=e.loc}this.buffer.push(comment)}}if(!this.scanner.eof()){var loc=void 0;if(this.trackLoc){loc={start:{line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart},end:{}}}var startRegex=this.scanner.source[this.scanner.index]==="/"&&this.reader.isRegexStart();var token=startRegex?this.scanner.scanRegExp():this.scanner.lex();this.reader.push(token);var entry={type:token_1.TokenName[token.type],value:this.scanner.source.slice(token.start,token.end)};if(this.trackRange){entry.range=[token.start,token.end]}if(this.trackLoc){loc.end={line:this.scanner.lineNumber,column:this.scanner.index-this.scanner.lineStart};entry.loc=loc}if(token.type===9){var pattern=token.pattern;var flags=token.flags;entry.regex={pattern,flags}}this.buffer.push(entry)}}return this.buffer.shift()};return Tokenizer}();exports.Tokenizer=Tokenizer}])}))},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var common=__webpack_require__(72);var YAMLException=__webpack_require__(73);var DEFAULT_FULL_SCHEMA=__webpack_require__(95);var DEFAULT_SAFE_SCHEMA=__webpack_require__(75);var _toString=Object.prototype.toString;var _hasOwnProperty=Object.prototype.hasOwnProperty;var CHAR_TAB=9;var CHAR_LINE_FEED=10;var CHAR_CARRIAGE_RETURN=13;var CHAR_SPACE=32;var CHAR_EXCLAMATION=33;var CHAR_DOUBLE_QUOTE=34;var CHAR_SHARP=35;var CHAR_PERCENT=37;var CHAR_AMPERSAND=38;var CHAR_SINGLE_QUOTE=39;var CHAR_ASTERISK=42;var CHAR_COMMA=44;var CHAR_MINUS=45;var CHAR_COLON=58;var CHAR_EQUALS=61;var CHAR_GREATER_THAN=62;var CHAR_QUESTION=63;var CHAR_COMMERCIAL_AT=64;var CHAR_LEFT_SQUARE_BRACKET=91;var CHAR_RIGHT_SQUARE_BRACKET=93;var CHAR_GRAVE_ACCENT=96;var CHAR_LEFT_CURLY_BRACKET=123;var CHAR_VERTICAL_LINE=124;var CHAR_RIGHT_CURLY_BRACKET=125;var ESCAPE_SEQUENCES={};ESCAPE_SEQUENCES[0]="\\0";ESCAPE_SEQUENCES[7]="\\a";ESCAPE_SEQUENCES[8]="\\b";ESCAPE_SEQUENCES[9]="\\t";ESCAPE_SEQUENCES[10]="\\n";ESCAPE_SEQUENCES[11]="\\v";ESCAPE_SEQUENCES[12]="\\f";ESCAPE_SEQUENCES[13]="\\r";ESCAPE_SEQUENCES[27]="\\e";ESCAPE_SEQUENCES[34]='\\"';ESCAPE_SEQUENCES[92]="\\\\";ESCAPE_SEQUENCES[133]="\\N";ESCAPE_SEQUENCES[160]="\\_";ESCAPE_SEQUENCES[8232]="\\L";ESCAPE_SEQUENCES[8233]="\\P";var DEPRECATED_BOOLEANS_SYNTAX=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"];function compileStyleMap(schema,map){var result,keys,index,length,tag,style,type;if(map===null)return{};result={};keys=Object.keys(map);for(index=0,length=keys.length;index<length;index+=1){tag=keys[index];style=String(map[tag]);if(tag.slice(0,2)==="!!"){tag="tag:yaml.org,2002:"+tag.slice(2)}type=schema.compiledTypeMap["fallback"][tag];if(type&&_hasOwnProperty.call(type.styleAliases,style)){style=type.styleAliases[style]}result[tag]=style}return result}function encodeHex(character){var string,handle,length;string=character.toString(16).toUpperCase();if(character<=255){handle="x";length=2}else if(character<=65535){handle="u";length=4}else if(character<=4294967295){handle="U";length=8}else{throw new YAMLException("code point within a string may not be greater than 0xFFFFFFFF")}return"\\"+handle+common.repeat("0",length-string.length)+string}function State(options){this.schema=options["schema"]||DEFAULT_FULL_SCHEMA;this.indent=Math.max(1,options["indent"]||2);this.noArrayIndent=options["noArrayIndent"]||false;this.skipInvalid=options["skipInvalid"]||false;this.flowLevel=common.isNothing(options["flowLevel"])?-1:options["flowLevel"];this.styleMap=compileStyleMap(this.schema,options["styles"]||null);this.sortKeys=options["sortKeys"]||false;this.lineWidth=options["lineWidth"]||80;this.noRefs=options["noRefs"]||false;this.noCompatMode=options["noCompatMode"]||false;this.condenseFlow=options["condenseFlow"]||false;this.implicitTypes=this.schema.compiledImplicit;this.explicitTypes=this.schema.compiledExplicit;this.tag=null;this.result="";this.duplicates=[];this.usedDuplicates=null}function indentString(string,spaces){var ind=common.repeat(" ",spaces),position=0,next=-1,result="",line,length=string.length;while(position<length){next=string.indexOf("\n",position);if(next===-1){line=string.slice(position);position=length}else{line=string.slice(position,next+1);position=next+1}if(line.length&&line!=="\n")result+=ind;result+=line}return result}function generateNextLine(state,level){return"\n"+common.repeat(" ",state.indent*level)}function testImplicitResolving(state,str){var index,length,type;for(index=0,length=state.implicitTypes.length;index<length;index+=1){type=state.implicitTypes[index];if(type.resolve(str)){return true}}return false}function isWhitespace(c){return c===CHAR_SPACE||c===CHAR_TAB}function isPrintable(c){return 32<=c&&c<=126||161<=c&&c<=55295&&c!==8232&&c!==8233||57344<=c&&c<=65533&&c!==65279||65536<=c&&c<=1114111}function isNsChar(c){return isPrintable(c)&&!isWhitespace(c)&&c!==65279&&c!==CHAR_CARRIAGE_RETURN&&c!==CHAR_LINE_FEED}function isPlainSafe(c,prev){return isPrintable(c)&&c!==65279&&c!==CHAR_COMMA&&c!==CHAR_LEFT_SQUARE_BRACKET&&c!==CHAR_RIGHT_SQUARE_BRACKET&&c!==CHAR_LEFT_CURLY_BRACKET&&c!==CHAR_RIGHT_CURLY_BRACKET&&c!==CHAR_COLON&&(c!==CHAR_SHARP||prev&&isNsChar(prev))}function isPlainSafeFirst(c){return isPrintable(c)&&c!==65279&&!isWhitespace(c)&&c!==CHAR_MINUS&&c!==CHAR_QUESTION&&c!==CHAR_COLON&&c!==CHAR_COMMA&&c!==CHAR_LEFT_SQUARE_BRACKET&&c!==CHAR_RIGHT_SQUARE_BRACKET&&c!==CHAR_LEFT_CURLY_BRACKET&&c!==CHAR_RIGHT_CURLY_BRACKET&&c!==CHAR_SHARP&&c!==CHAR_AMPERSAND&&c!==CHAR_ASTERISK&&c!==CHAR_EXCLAMATION&&c!==CHAR_VERTICAL_LINE&&c!==CHAR_EQUALS&&c!==CHAR_GREATER_THAN&&c!==CHAR_SINGLE_QUOTE&&c!==CHAR_DOUBLE_QUOTE&&c!==CHAR_PERCENT&&c!==CHAR_COMMERCIAL_AT&&c!==CHAR_GRAVE_ACCENT}function needIndentIndicator(string){var leadingSpaceRe=/^\n* /;return leadingSpaceRe.test(string)}var STYLE_PLAIN=1,STYLE_SINGLE=2,STYLE_LITERAL=3,STYLE_FOLDED=4,STYLE_DOUBLE=5;function chooseScalarStyle(string,singleLineOnly,indentPerLevel,lineWidth,testAmbiguousType){var i;var char,prev_char;var hasLineBreak=false;var hasFoldableLine=false;var shouldTrackWidth=lineWidth!==-1;var previousLineBreak=-1;var plain=isPlainSafeFirst(string.charCodeAt(0))&&!isWhitespace(string.charCodeAt(string.length-1));if(singleLineOnly){for(i=0;i<string.length;i++){char=string.charCodeAt(i);if(!isPrintable(char)){return STYLE_DOUBLE}prev_char=i>0?string.charCodeAt(i-1):null;plain=plain&&isPlainSafe(char,prev_char)}}else{for(i=0;i<string.length;i++){char=string.charCodeAt(i);if(char===CHAR_LINE_FEED){hasLineBreak=true;if(shouldTrackWidth){hasFoldableLine=hasFoldableLine||i-previousLineBreak-1>lineWidth&&string[previousLineBreak+1]!==" ";previousLineBreak=i}}else if(!isPrintable(char)){return STYLE_DOUBLE}prev_char=i>0?string.charCodeAt(i-1):null;plain=plain&&isPlainSafe(char,prev_char)}hasFoldableLine=hasFoldableLine||shouldTrackWidth&&(i-previousLineBreak-1>lineWidth&&string[previousLineBreak+1]!==" ")}if(!hasLineBreak&&!hasFoldableLine){return plain&&!testAmbiguousType(string)?STYLE_PLAIN:STYLE_SINGLE}if(indentPerLevel>9&&needIndentIndicator(string)){return STYLE_DOUBLE}return hasFoldableLine?STYLE_FOLDED:STYLE_LITERAL}function writeScalar(state,string,level,iskey){state.dump=function(){if(string.length===0){return"''"}if(!state.noCompatMode&&DEPRECATED_BOOLEANS_SYNTAX.indexOf(string)!==-1){return"'"+string+"'"}var indent=state.indent*Math.max(1,level);var lineWidth=state.lineWidth===-1?-1:Math.max(Math.min(state.lineWidth,40),state.lineWidth-indent);var singleLineOnly=iskey||state.flowLevel>-1&&level>=state.flowLevel;function testAmbiguity(string){return testImplicitResolving(state,string)}switch(chooseScalarStyle(string,singleLineOnly,state.indent,lineWidth,testAmbiguity)){case STYLE_PLAIN:return string;case STYLE_SINGLE:return"'"+string.replace(/'/g,"''")+"'";case STYLE_LITERAL:return"|"+blockHeader(string,state.indent)+dropEndingNewline(indentString(string,indent));case STYLE_FOLDED:return">"+blockHeader(string,state.indent)+dropEndingNewline(indentString(foldString(string,lineWidth),indent));case STYLE_DOUBLE:return'"'+escapeString(string,lineWidth)+'"';default:throw new YAMLException("impossible error: invalid scalar style")}}()}function blockHeader(string,indentPerLevel){var indentIndicator=needIndentIndicator(string)?String(indentPerLevel):"";var clip=string[string.length-1]==="\n";var keep=clip&&(string[string.length-2]==="\n"||string==="\n");var chomp=keep?"+":clip?"":"-";return indentIndicator+chomp+"\n"}function dropEndingNewline(string){return string[string.length-1]==="\n"?string.slice(0,-1):string}function foldString(string,width){var lineRe=/(\n+)([^\n]*)/g;var result=function(){var nextLF=string.indexOf("\n");nextLF=nextLF!==-1?nextLF:string.length;lineRe.lastIndex=nextLF;return foldLine(string.slice(0,nextLF),width)}();var prevMoreIndented=string[0]==="\n"||string[0]===" ";var moreIndented;var match;while(match=lineRe.exec(string)){var prefix=match[1],line=match[2];moreIndented=line[0]===" ";result+=prefix+(!prevMoreIndented&&!moreIndented&&line!==""?"\n":"")+foldLine(line,width);prevMoreIndented=moreIndented}return result}function foldLine(line,width){if(line===""||line[0]===" ")return line;var breakRe=/ [^ ]/g;var match;var start=0,end,curr=0,next=0;var result="";while(match=breakRe.exec(line)){next=match.index;if(next-start>width){end=curr>start?curr:next;result+="\n"+line.slice(start,end);start=end+1}curr=next}result+="\n";if(line.length-start>width&&curr>start){result+=line.slice(start,curr)+"\n"+line.slice(curr+1)}else{result+=line.slice(start)}return result.slice(1)}function escapeString(string){var result="";var char,nextChar;var escapeSeq;for(var i=0;i<string.length;i++){char=string.charCodeAt(i);if(char>=55296&&char<=56319){nextChar=string.charCodeAt(i+1);if(nextChar>=56320&&nextChar<=57343){result+=encodeHex((char-55296)*1024+nextChar-56320+65536);i++;continue}}escapeSeq=ESCAPE_SEQUENCES[char];result+=!escapeSeq&&isPrintable(char)?string[i]:escapeSeq||encodeHex(char)}return result}function writeFlowSequence(state,level,object){var _result="",_tag=state.tag,index,length;for(index=0,length=object.length;index<length;index+=1){if(writeNode(state,level,object[index],false,false)){if(index!==0)_result+=","+(!state.condenseFlow?" ":"");_result+=state.dump}}state.tag=_tag;state.dump="["+_result+"]"}function writeBlockSequence(state,level,object,compact){var _result="",_tag=state.tag,index,length;for(index=0,length=object.length;index<length;index+=1){if(writeNode(state,level+1,object[index],true,true)){if(!compact||index!==0){_result+=generateNextLine(state,level)}if(state.dump&&CHAR_LINE_FEED===state.dump.charCodeAt(0)){_result+="-"}else{_result+="- "}_result+=state.dump}}state.tag=_tag;state.dump=_result||"[]"}function writeFlowMapping(state,level,object){var _result="",_tag=state.tag,objectKeyList=Object.keys(object),index,length,objectKey,objectValue,pairBuffer;for(index=0,length=objectKeyList.length;index<length;index+=1){pairBuffer="";if(index!==0)pairBuffer+=", ";if(state.condenseFlow)pairBuffer+='"';objectKey=objectKeyList[index];objectValue=object[objectKey];if(!writeNode(state,level,objectKey,false,false)){continue}if(state.dump.length>1024)pairBuffer+="? ";pairBuffer+=state.dump+(state.condenseFlow?'"':"")+":"+(state.condenseFlow?"":" ");if(!writeNode(state,level,objectValue,false,false)){continue}pairBuffer+=state.dump;_result+=pairBuffer}state.tag=_tag;state.dump="{"+_result+"}"}function writeBlockMapping(state,level,object,compact){var _result="",_tag=state.tag,objectKeyList=Object.keys(object),index,length,objectKey,objectValue,explicitPair,pairBuffer;if(state.sortKeys===true){objectKeyList.sort()}else if(typeof state.sortKeys==="function"){objectKeyList.sort(state.sortKeys)}else if(state.sortKeys){throw new YAMLException("sortKeys must be a boolean or a function")}for(index=0,length=objectKeyList.length;index<length;index+=1){pairBuffer="";if(!compact||index!==0){pairBuffer+=generateNextLine(state,level)}objectKey=objectKeyList[index];objectValue=object[objectKey];if(!writeNode(state,level+1,objectKey,true,true,true)){continue}explicitPair=state.tag!==null&&state.tag!=="?"||state.dump&&state.dump.length>1024;if(explicitPair){if(state.dump&&CHAR_LINE_FEED===state.dump.charCodeAt(0)){pairBuffer+="?"}else{pairBuffer+="? "}}pairBuffer+=state.dump;if(explicitPair){pairBuffer+=generateNextLine(state,level)}if(!writeNode(state,level+1,objectValue,true,explicitPair)){continue}if(state.dump&&CHAR_LINE_FEED===state.dump.charCodeAt(0)){pairBuffer+=":"}else{pairBuffer+=": "}pairBuffer+=state.dump;_result+=pairBuffer}state.tag=_tag;state.dump=_result||"{}"}function detectType(state,object,explicit){var _result,typeList,index,length,type,style;typeList=explicit?state.explicitTypes:state.implicitTypes;for(index=0,length=typeList.length;index<length;index+=1){type=typeList[index];if((type.instanceOf||type.predicate)&&(!type.instanceOf||typeof object==="object"&&object instanceof type.instanceOf)&&(!type.predicate||type.predicate(object))){state.tag=explicit?type.tag:"?";if(type.represent){style=state.styleMap[type.tag]||type.defaultStyle;if(_toString.call(type.represent)==="[object Function]"){_result=type.represent(object,style)}else if(_hasOwnProperty.call(type.represent,style)){_result=type.represent[style](object,style)}else{throw new YAMLException("!<"+type.tag+'> tag resolver accepts not "'+style+'" style')}state.dump=_result}return true}}return false}function writeNode(state,level,object,block,compact,iskey){state.tag=null;state.dump=object;if(!detectType(state,object,false)){detectType(state,object,true)}var type=_toString.call(state.dump);if(block){block=state.flowLevel<0||state.flowLevel>level}var objectOrArray=type==="[object Object]"||type==="[object Array]",duplicateIndex,duplicate;if(objectOrArray){duplicateIndex=state.duplicates.indexOf(object);duplicate=duplicateIndex!==-1}if(state.tag!==null&&state.tag!=="?"||duplicate||state.indent!==2&&level>0){compact=false}if(duplicate&&state.usedDuplicates[duplicateIndex]){state.dump="*ref_"+duplicateIndex}else{if(objectOrArray&&duplicate&&!state.usedDuplicates[duplicateIndex]){state.usedDuplicates[duplicateIndex]=true}if(type==="[object Object]"){if(block&&Object.keys(state.dump).length!==0){writeBlockMapping(state,level,state.dump,compact);if(duplicate){state.dump="&ref_"+duplicateIndex+state.dump}}else{writeFlowMapping(state,level,state.dump);if(duplicate){state.dump="&ref_"+duplicateIndex+" "+state.dump}}}else if(type==="[object Array]"){var arrayLevel=state.noArrayIndent&&level>0?level-1:level;if(block&&state.dump.length!==0){writeBlockSequence(state,arrayLevel,state.dump,compact);if(duplicate){state.dump="&ref_"+duplicateIndex+state.dump}}else{writeFlowSequence(state,arrayLevel,state.dump);if(duplicate){state.dump="&ref_"+duplicateIndex+" "+state.dump}}}else if(type==="[object String]"){if(state.tag!=="?"){writeScalar(state,state.dump,level,iskey)}}else{if(state.skipInvalid)return false;throw new YAMLException("unacceptable kind of an object to dump "+type)}if(state.tag!==null&&state.tag!=="?"){state.dump="!<"+state.tag+"> "+state.dump}}return true}function getDuplicateReferences(object,state){var objects=[],duplicatesIndexes=[],index,length;inspectNode(object,objects,duplicatesIndexes);for(index=0,length=duplicatesIndexes.length;index<length;index+=1){state.duplicates.push(objects[duplicatesIndexes[index]])}state.usedDuplicates=new Array(length)}function inspectNode(object,objects,duplicatesIndexes){var objectKeyList,index,length;if(object!==null&&typeof object==="object"){index=objects.indexOf(object);if(index!==-1){if(duplicatesIndexes.indexOf(index)===-1){duplicatesIndexes.push(index)}}else{objects.push(object);if(Array.isArray(object)){for(index=0,length=object.length;index<length;index+=1){inspectNode(object[index],objects,duplicatesIndexes)}}else{objectKeyList=Object.keys(object);for(index=0,length=objectKeyList.length;index<length;index+=1){inspectNode(object[objectKeyList[index]],objects,duplicatesIndexes)}}}}}function dump(input,options){options=options||{};var state=new State(options);if(!state.noRefs)getDuplicateReferences(input,state);if(writeNode(state,0,input,true,true))return state.dump+"\n";return""}function safeDump(input,options){return dump(input,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}module.exports.dump=dump;module.exports.safeDump=safeDump},(__unused_webpack_module,exports)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Lazy=void 0;class Lazy{constructor(creator){this._value=null;this.creator=creator}get hasValue(){return this.creator==null}get value(){if(this.creator==null){return this._value}const result=this.creator();this.value=result;return result}set value(value){this._value=value;this.creator=null}}exports.Lazy=Lazy},(module,__unused_webpack_exports,__webpack_require__)=>{const internalRe=__webpack_require__(103);module.exports={re:internalRe.re,src:internalRe.src,tokens:internalRe.t,SEMVER_SPEC_VERSION:__webpack_require__(104).SEMVER_SPEC_VERSION,SemVer:__webpack_require__(106),compareIdentifiers:__webpack_require__(107).compareIdentifiers,rcompareIdentifiers:__webpack_require__(107).rcompareIdentifiers,parse:__webpack_require__(108),valid:__webpack_require__(109),clean:__webpack_require__(110),inc:__webpack_require__(111),diff:__webpack_require__(112),major:__webpack_require__(115),minor:__webpack_require__(116),patch:__webpack_require__(117),prerelease:__webpack_require__(118),compare:__webpack_require__(114),rcompare:__webpack_require__(119),compareLoose:__webpack_require__(120),compareBuild:__webpack_require__(121),sort:__webpack_require__(122),rsort:__webpack_require__(123),gt:__webpack_require__(124),lt:__webpack_require__(125),eq:__webpack_require__(113),neq:__webpack_require__(126),gte:__webpack_require__(127),lte:__webpack_require__(128),cmp:__webpack_require__(129),coerce:__webpack_require__(130),Comparator:__webpack_require__(131),Range:__webpack_require__(132),satisfies:__webpack_require__(133),toComparators:__webpack_require__(134),maxSatisfying:__webpack_require__(135),minSatisfying:__webpack_require__(136),minVersion:__webpack_require__(137),validRange:__webpack_require__(138),outside:__webpack_require__(139),gtr:__webpack_require__(140),ltr:__webpack_require__(141),intersects:__webpack_require__(142),simplifyRange:__webpack_require__(143),subset:__webpack_require__(144)}},(module,exports,__webpack_require__)=>{const{MAX_SAFE_COMPONENT_LENGTH}=__webpack_require__(104);const debug=__webpack_require__(105);exports=module.exports={};const re=exports.re=[];const src=exports.src=[];const t=exports.t={};let R=0;const createToken=(name,value,isGlobal)=>{const index=R++;debug(index,value);t[name]=index;src[index]=value;re[index]=new RegExp(value,isGlobal?"g":undefined)};createToken("NUMERICIDENTIFIER","0|[1-9]\\d*");createToken("NUMERICIDENTIFIERLOOSE","[0-9]+");createToken("NONNUMERICIDENTIFIER","\\d*[a-zA-Z-][a-zA-Z0-9-]*");createToken("MAINVERSION",`(${src[t.NUMERICIDENTIFIER]})\\.`+`(${src[t.NUMERICIDENTIFIER]})\\.`+`(${src[t.NUMERICIDENTIFIER]})`);createToken("MAINVERSIONLOOSE",`(${src[t.NUMERICIDENTIFIERLOOSE]})\\.`+`(${src[t.NUMERICIDENTIFIERLOOSE]})\\.`+`(${src[t.NUMERICIDENTIFIERLOOSE]})`);createToken("PRERELEASEIDENTIFIER",`(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASEIDENTIFIERLOOSE",`(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASE",`(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);createToken("PRERELEASELOOSE",`(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);createToken("BUILDIDENTIFIER","[0-9A-Za-z-]+");createToken("BUILD",`(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);createToken("FULLPLAIN",`v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);createToken("FULL",`^${src[t.FULLPLAIN]}$`);createToken("LOOSEPLAIN",`[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);createToken("LOOSE",`^${src[t.LOOSEPLAIN]}$`);createToken("GTLT","((?:<|>)?=?)");createToken("XRANGEIDENTIFIERLOOSE",`${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);createToken("XRANGEIDENTIFIER",`${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);createToken("XRANGEPLAIN",`[v=\\s]*(${src[t.XRANGEIDENTIFIER]})`+`(?:\\.(${src[t.XRANGEIDENTIFIER]})`+`(?:\\.(${src[t.XRANGEIDENTIFIER]})`+`(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?`+`)?)?`);createToken("XRANGEPLAINLOOSE",`[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?`+`)?)?`);createToken("XRANGE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);createToken("XRANGELOOSE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);createToken("COERCE",`${"(^|[^\\d])"+"(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})`+`(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`+`(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`+`(?:$|[^\\d])`);createToken("COERCERTL",src[t.COERCE],true);createToken("LONETILDE","(?:~>?)");createToken("TILDETRIM",`(\\s*)${src[t.LONETILDE]}\\s+`,true);exports.tildeTrimReplace="$1~";createToken("TILDE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);createToken("TILDELOOSE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("LONECARET","(?:\\^)");createToken("CARETTRIM",`(\\s*)${src[t.LONECARET]}\\s+`,true);exports.caretTrimReplace="$1^";createToken("CARET",`^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);createToken("CARETLOOSE",`^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("COMPARATORLOOSE",`^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);createToken("COMPARATOR",`^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);createToken("COMPARATORTRIM",`(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`,true);exports.comparatorTrimReplace="$1$2$3";createToken("HYPHENRANGE",`^\\s*(${src[t.XRANGEPLAIN]})`+`\\s+-\\s+`+`(${src[t.XRANGEPLAIN]})`+`\\s*$`);createToken("HYPHENRANGELOOSE",`^\\s*(${src[t.XRANGEPLAINLOOSE]})`+`\\s+-\\s+`+`(${src[t.XRANGEPLAINLOOSE]})`+`\\s*$`);createToken("STAR","(<|>)?=?\\s*\\*");createToken("GTE0","^\\s*>=\\s*0.0.0\\s*$");createToken("GTE0PRE","^\\s*>=\\s*0.0.0-0\\s*$")},module=>{const SEMVER_SPEC_VERSION="2.0.0";const MAX_LENGTH=256;const MAX_SAFE_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991;const MAX_SAFE_COMPONENT_LENGTH=16;module.exports={SEMVER_SPEC_VERSION,MAX_LENGTH,MAX_SAFE_INTEGER,MAX_SAFE_COMPONENT_LENGTH}},module=>{const debug=typeof process==="object"&&process.env&&process.env.NODE_DEBUG&&/\bsemver\b/i.test(process.env.NODE_DEBUG)?(...args)=>console.error("SEMVER",...args):()=>{};module.exports=debug},(module,__unused_webpack_exports,__webpack_require__)=>{const debug=__webpack_require__(105);const{MAX_LENGTH,MAX_SAFE_INTEGER}=__webpack_require__(104);const{re,t}=__webpack_require__(103);const{compareIdentifiers}=__webpack_require__(107);class SemVer{constructor(version,options){if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(version instanceof SemVer){if(version.loose===!!options.loose&&version.includePrerelease===!!options.includePrerelease){return version}else{version=version.version}}else if(typeof version!=="string"){throw new TypeError(`Invalid Version: ${version}`)}if(version.length>MAX_LENGTH){throw new TypeError(`version is longer than ${MAX_LENGTH} characters`)}debug("SemVer",version,options);this.options=options;this.loose=!!options.loose;this.includePrerelease=!!options.includePrerelease;const m=version.trim().match(options.loose?re[t.LOOSE]:re[t.FULL]);if(!m){throw new TypeError(`Invalid Version: ${version}`)}this.raw=version;this.major=+m[1];this.minor=+m[2];this.patch=+m[3];if(this.major>MAX_SAFE_INTEGER||this.major<0){throw new TypeError("Invalid major version")}if(this.minor>MAX_SAFE_INTEGER||this.minor<0){throw new TypeError("Invalid minor version")}if(this.patch>MAX_SAFE_INTEGER||this.patch<0){throw new TypeError("Invalid patch version")}if(!m[4]){this.prerelease=[]}else{this.prerelease=m[4].split(".").map((id=>{if(/^[0-9]+$/.test(id)){const num=+id;if(num>=0&&num<MAX_SAFE_INTEGER){return num}}return id}))}this.build=m[5]?m[5].split("."):[];this.format()}format(){this.version=`${this.major}.${this.minor}.${this.patch}`;if(this.prerelease.length){this.version+=`-${this.prerelease.join(".")}`}return this.version}toString(){return this.version}compare(other){debug("SemVer.compare",this.version,this.options,other);if(!(other instanceof SemVer)){if(typeof other==="string"&&other===this.version){return 0}other=new SemVer(other,this.options)}if(other.version===this.version){return 0}return this.compareMain(other)||this.comparePre(other)}compareMain(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}return compareIdentifiers(this.major,other.major)||compareIdentifiers(this.minor,other.minor)||compareIdentifiers(this.patch,other.patch)}comparePre(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}if(this.prerelease.length&&!other.prerelease.length){return-1}else if(!this.prerelease.length&&other.prerelease.length){return 1}else if(!this.prerelease.length&&!other.prerelease.length){return 0}let i=0;do{const a=this.prerelease[i];const b=other.prerelease[i];debug("prerelease compare",i,a,b);if(a===undefined&&b===undefined){return 0}else if(b===undefined){return 1}else if(a===undefined){return-1}else if(a===b){continue}else{return compareIdentifiers(a,b)}}while(++i)}compareBuild(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}let i=0;do{const a=this.build[i];const b=other.build[i];debug("prerelease compare",i,a,b);if(a===undefined&&b===undefined){return 0}else if(b===undefined){return 1}else if(a===undefined){return-1}else if(a===b){continue}else{return compareIdentifiers(a,b)}}while(++i)}inc(release,identifier){switch(release){case"premajor":this.prerelease.length=0;this.patch=0;this.minor=0;this.major++;this.inc("pre",identifier);break;case"preminor":this.prerelease.length=0;this.patch=0;this.minor++;this.inc("pre",identifier);break;case"prepatch":this.prerelease.length=0;this.inc("patch",identifier);this.inc("pre",identifier);break;case"prerelease":if(this.prerelease.length===0){this.inc("patch",identifier)}this.inc("pre",identifier);break;case"major":if(this.minor!==0||this.patch!==0||this.prerelease.length===0){this.major++}this.minor=0;this.patch=0;this.prerelease=[];break;case"minor":if(this.patch!==0||this.prerelease.length===0){this.minor++}this.patch=0;this.prerelease=[];break;case"patch":if(this.prerelease.length===0){this.patch++}this.prerelease=[];break;case"pre":if(this.prerelease.length===0){this.prerelease=[0]}else{let i=this.prerelease.length;while(--i>=0){if(typeof this.prerelease[i]==="number"){this.prerelease[i]++;i=-2}}if(i===-1){this.prerelease.push(0)}}if(identifier){if(this.prerelease[0]===identifier){if(isNaN(this.prerelease[1])){this.prerelease=[identifier,0]}}else{this.prerelease=[identifier,0]}}break;default:throw new Error(`invalid increment argument: ${release}`)}this.format();this.raw=this.version;return this}}module.exports=SemVer},module=>{const numeric=/^[0-9]+$/;const compareIdentifiers=(a,b)=>{const anum=numeric.test(a);const bnum=numeric.test(b);if(anum&&bnum){a=+a;b=+b}return a===b?0:anum&&!bnum?-1:bnum&&!anum?1:a<b?-1:1};const rcompareIdentifiers=(a,b)=>compareIdentifiers(b,a);module.exports={compareIdentifiers,rcompareIdentifiers}},(module,__unused_webpack_exports,__webpack_require__)=>{const{MAX_LENGTH}=__webpack_require__(104);const{re,t}=__webpack_require__(103);const SemVer=__webpack_require__(106);const parse=(version,options)=>{if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(version instanceof SemVer){return version}if(typeof version!=="string"){return null}if(version.length>MAX_LENGTH){return null}const r=options.loose?re[t.LOOSE]:re[t.FULL];if(!r.test(version)){return null}try{return new SemVer(version,options)}catch(er){return null}};module.exports=parse},(module,__unused_webpack_exports,__webpack_require__)=>{const parse=__webpack_require__(108);const valid=(version,options)=>{const v=parse(version,options);return v?v.version:null};module.exports=valid},(module,__unused_webpack_exports,__webpack_require__)=>{const parse=__webpack_require__(108);const clean=(version,options)=>{const s=parse(version.trim().replace(/^[=v]+/,""),options);return s?s.version:null};module.exports=clean},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const inc=(version,release,options,identifier)=>{if(typeof options==="string"){identifier=options;options=undefined}try{return new SemVer(version,options).inc(release,identifier).version}catch(er){return null}};module.exports=inc},(module,__unused_webpack_exports,__webpack_require__)=>{const parse=__webpack_require__(108);const eq=__webpack_require__(113);const diff=(version1,version2)=>{if(eq(version1,version2)){return null}else{const v1=parse(version1);const v2=parse(version2);const hasPre=v1.prerelease.length||v2.prerelease.length;const prefix=hasPre?"pre":"";const defaultResult=hasPre?"prerelease":"";for(const key in v1){if(key==="major"||key==="minor"||key==="patch"){if(v1[key]!==v2[key]){return prefix+key}}}return defaultResult}};module.exports=diff},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const eq=(a,b,loose)=>compare(a,b,loose)===0;module.exports=eq},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const compare=(a,b,loose)=>new SemVer(a,loose).compare(new SemVer(b,loose));module.exports=compare},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const major=(a,loose)=>new SemVer(a,loose).major;module.exports=major},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const minor=(a,loose)=>new SemVer(a,loose).minor;module.exports=minor},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const patch=(a,loose)=>new SemVer(a,loose).patch;module.exports=patch},(module,__unused_webpack_exports,__webpack_require__)=>{const parse=__webpack_require__(108);const prerelease=(version,options)=>{const parsed=parse(version,options);return parsed&&parsed.prerelease.length?parsed.prerelease:null};module.exports=prerelease},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const rcompare=(a,b,loose)=>compare(b,a,loose);module.exports=rcompare},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const compareLoose=(a,b)=>compare(a,b,true);module.exports=compareLoose},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const compareBuild=(a,b,loose)=>{const versionA=new SemVer(a,loose);const versionB=new SemVer(b,loose);return versionA.compare(versionB)||versionA.compareBuild(versionB)};module.exports=compareBuild},(module,__unused_webpack_exports,__webpack_require__)=>{const compareBuild=__webpack_require__(121);const sort=(list,loose)=>list.sort(((a,b)=>compareBuild(a,b,loose)));module.exports=sort},(module,__unused_webpack_exports,__webpack_require__)=>{const compareBuild=__webpack_require__(121);const rsort=(list,loose)=>list.sort(((a,b)=>compareBuild(b,a,loose)));module.exports=rsort},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const gt=(a,b,loose)=>compare(a,b,loose)>0;module.exports=gt},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const lt=(a,b,loose)=>compare(a,b,loose)<0;module.exports=lt},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const neq=(a,b,loose)=>compare(a,b,loose)!==0;module.exports=neq},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const gte=(a,b,loose)=>compare(a,b,loose)>=0;module.exports=gte},(module,__unused_webpack_exports,__webpack_require__)=>{const compare=__webpack_require__(114);const lte=(a,b,loose)=>compare(a,b,loose)<=0;module.exports=lte},(module,__unused_webpack_exports,__webpack_require__)=>{const eq=__webpack_require__(113);const neq=__webpack_require__(126);const gt=__webpack_require__(124);const gte=__webpack_require__(127);const lt=__webpack_require__(125);const lte=__webpack_require__(128);const cmp=(a,op,b,loose)=>{switch(op){case"===":if(typeof a==="object")a=a.version;if(typeof b==="object")b=b.version;return a===b;case"!==":if(typeof a==="object")a=a.version;if(typeof b==="object")b=b.version;return a!==b;case"":case"=":case"==":return eq(a,b,loose);case"!=":return neq(a,b,loose);case">":return gt(a,b,loose);case">=":return gte(a,b,loose);case"<":return lt(a,b,loose);case"<=":return lte(a,b,loose);default:throw new TypeError(`Invalid operator: ${op}`)}};module.exports=cmp},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const parse=__webpack_require__(108);const{re,t}=__webpack_require__(103);const coerce=(version,options)=>{if(version instanceof SemVer){return version}if(typeof version==="number"){version=String(version)}if(typeof version!=="string"){return null}options=options||{};let match=null;if(!options.rtl){match=version.match(re[t.COERCE])}else{let next;while((next=re[t.COERCERTL].exec(version))&&(!match||match.index+match[0].length!==version.length)){if(!match||next.index+next[0].length!==match.index+match[0].length){match=next}re[t.COERCERTL].lastIndex=next.index+next[1].length+next[2].length}re[t.COERCERTL].lastIndex=-1}if(match===null)return null;return parse(`${match[2]}.${match[3]||"0"}.${match[4]||"0"}`,options)};module.exports=coerce},(module,__unused_webpack_exports,__webpack_require__)=>{const ANY=Symbol("SemVer ANY");class Comparator{static get ANY(){return ANY}constructor(comp,options){if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(comp instanceof Comparator){if(comp.loose===!!options.loose){return comp}else{comp=comp.value}}debug("comparator",comp,options);this.options=options;this.loose=!!options.loose;this.parse(comp);if(this.semver===ANY){this.value=""}else{this.value=this.operator+this.semver.version}debug("comp",this)}parse(comp){const r=this.options.loose?re[t.COMPARATORLOOSE]:re[t.COMPARATOR];const m=comp.match(r);if(!m){throw new TypeError(`Invalid comparator: ${comp}`)}this.operator=m[1]!==undefined?m[1]:"";if(this.operator==="="){this.operator=""}if(!m[2]){this.semver=ANY}else{this.semver=new SemVer(m[2],this.options.loose)}}toString(){return this.value}test(version){debug("Comparator.test",version,this.options.loose);if(this.semver===ANY||version===ANY){return true}if(typeof version==="string"){try{version=new SemVer(version,this.options)}catch(er){return false}}return cmp(version,this.operator,this.semver,this.options)}intersects(comp,options){if(!(comp instanceof Comparator)){throw new TypeError("a Comparator is required")}if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(this.operator===""){if(this.value===""){return true}return new Range(comp.value,options).test(this.value)}else if(comp.operator===""){if(comp.value===""){return true}return new Range(this.value,options).test(comp.semver)}const sameDirectionIncreasing=(this.operator===">="||this.operator===">")&&(comp.operator===">="||comp.operator===">");const sameDirectionDecreasing=(this.operator==="<="||this.operator==="<")&&(comp.operator==="<="||comp.operator==="<");const sameSemVer=this.semver.version===comp.semver.version;const differentDirectionsInclusive=(this.operator===">="||this.operator==="<=")&&(comp.operator===">="||comp.operator==="<=");const oppositeDirectionsLessThan=cmp(this.semver,"<",comp.semver,options)&&(this.operator===">="||this.operator===">")&&(comp.operator==="<="||comp.operator==="<");const oppositeDirectionsGreaterThan=cmp(this.semver,">",comp.semver,options)&&(this.operator==="<="||this.operator==="<")&&(comp.operator===">="||comp.operator===">");return sameDirectionIncreasing||sameDirectionDecreasing||sameSemVer&&differentDirectionsInclusive||oppositeDirectionsLessThan||oppositeDirectionsGreaterThan}}module.exports=Comparator;const{re,t}=__webpack_require__(103);const cmp=__webpack_require__(129);const debug=__webpack_require__(105);const SemVer=__webpack_require__(106);const Range=__webpack_require__(132)},(module,__unused_webpack_exports,__webpack_require__)=>{class Range{constructor(range,options){if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(range instanceof Range){if(range.loose===!!options.loose&&range.includePrerelease===!!options.includePrerelease){return range}else{return new Range(range.raw,options)}}if(range instanceof Comparator){this.raw=range.value;this.set=[[range]];this.format();return this}this.options=options;this.loose=!!options.loose;this.includePrerelease=!!options.includePrerelease;this.raw=range;this.set=range.split(/\s*\|\|\s*/).map((range=>this.parseRange(range.trim()))).filter((c=>c.length));if(!this.set.length){throw new TypeError(`Invalid SemVer Range: ${range}`)}this.format()}format(){this.range=this.set.map((comps=>comps.join(" ").trim())).join("||").trim();return this.range}toString(){return this.range}parseRange(range){const loose=this.options.loose;range=range.trim();const hr=loose?re[t.HYPHENRANGELOOSE]:re[t.HYPHENRANGE];range=range.replace(hr,hyphenReplace(this.options.includePrerelease));debug("hyphen replace",range);range=range.replace(re[t.COMPARATORTRIM],comparatorTrimReplace);debug("comparator trim",range,re[t.COMPARATORTRIM]);range=range.replace(re[t.TILDETRIM],tildeTrimReplace);range=range.replace(re[t.CARETTRIM],caretTrimReplace);range=range.split(/\s+/).join(" ");const compRe=loose?re[t.COMPARATORLOOSE]:re[t.COMPARATOR];return range.split(" ").map((comp=>parseComparator(comp,this.options))).join(" ").split(/\s+/).map((comp=>replaceGTE0(comp,this.options))).filter(this.options.loose?comp=>!!comp.match(compRe):()=>true).map((comp=>new Comparator(comp,this.options)))}intersects(range,options){if(!(range instanceof Range)){throw new TypeError("a Range is required")}return this.set.some((thisComparators=>isSatisfiable(thisComparators,options)&&range.set.some((rangeComparators=>isSatisfiable(rangeComparators,options)&&thisComparators.every((thisComparator=>rangeComparators.every((rangeComparator=>thisComparator.intersects(rangeComparator,options)))))))))}test(version){if(!version){return false}if(typeof version==="string"){try{version=new SemVer(version,this.options)}catch(er){return false}}for(let i=0;i<this.set.length;i++){if(testSet(this.set[i],version,this.options)){return true}}return false}}module.exports=Range;const Comparator=__webpack_require__(131);const debug=__webpack_require__(105);const SemVer=__webpack_require__(106);const{re,t,comparatorTrimReplace,tildeTrimReplace,caretTrimReplace}=__webpack_require__(103);const isSatisfiable=(comparators,options)=>{let result=true;const remainingComparators=comparators.slice();let testComparator=remainingComparators.pop();while(result&&remainingComparators.length){result=remainingComparators.every((otherComparator=>testComparator.intersects(otherComparator,options)));testComparator=remainingComparators.pop()}return result};const parseComparator=(comp,options)=>{debug("comp",comp,options);comp=replaceCarets(comp,options);debug("caret",comp);comp=replaceTildes(comp,options);debug("tildes",comp);comp=replaceXRanges(comp,options);debug("xrange",comp);comp=replaceStars(comp,options);debug("stars",comp);return comp};const isX=id=>!id||id.toLowerCase()==="x"||id==="*";const replaceTildes=(comp,options)=>comp.trim().split(/\s+/).map((comp=>replaceTilde(comp,options))).join(" ");const replaceTilde=(comp,options)=>{const r=options.loose?re[t.TILDELOOSE]:re[t.TILDE];return comp.replace(r,((_,M,m,p,pr)=>{debug("tilde",comp,_,M,m,p,pr);let ret;if(isX(M)){ret=""}else if(isX(m)){ret=`>=${M}.0.0 <${+M+1}.0.0-0`}else if(isX(p)){ret=`>=${M}.${m}.0 <${M}.${+m+1}.0-0`}else if(pr){debug("replaceTilde pr",pr);ret=`>=${M}.${m}.${p}-${pr} <${M}.${+m+1}.0-0`}else{ret=`>=${M}.${m}.${p} <${M}.${+m+1}.0-0`}debug("tilde return",ret);return ret}))};const replaceCarets=(comp,options)=>comp.trim().split(/\s+/).map((comp=>replaceCaret(comp,options))).join(" ");const replaceCaret=(comp,options)=>{debug("caret",comp,options);const r=options.loose?re[t.CARETLOOSE]:re[t.CARET];const z=options.includePrerelease?"-0":"";return comp.replace(r,((_,M,m,p,pr)=>{debug("caret",comp,_,M,m,p,pr);let ret;if(isX(M)){ret=""}else if(isX(m)){ret=`>=${M}.0.0${z} <${+M+1}.0.0-0`}else if(isX(p)){if(M==="0"){ret=`>=${M}.${m}.0${z} <${M}.${+m+1}.0-0`}else{ret=`>=${M}.${m}.0${z} <${+M+1}.0.0-0`}}else if(pr){debug("replaceCaret pr",pr);if(M==="0"){if(m==="0"){ret=`>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p+1}-0`}else{ret=`>=${M}.${m}.${p}-${pr} <${M}.${+m+1}.0-0`}}else{ret=`>=${M}.${m}.${p}-${pr} <${+M+1}.0.0-0`}}else{debug("no pr");if(M==="0"){if(m==="0"){ret=`>=${M}.${m}.${p}${z} <${M}.${m}.${+p+1}-0`}else{ret=`>=${M}.${m}.${p}${z} <${M}.${+m+1}.0-0`}}else{ret=`>=${M}.${m}.${p} <${+M+1}.0.0-0`}}debug("caret return",ret);return ret}))};const replaceXRanges=(comp,options)=>{debug("replaceXRanges",comp,options);return comp.split(/\s+/).map((comp=>replaceXRange(comp,options))).join(" ")};const replaceXRange=(comp,options)=>{comp=comp.trim();const r=options.loose?re[t.XRANGELOOSE]:re[t.XRANGE];return comp.replace(r,((ret,gtlt,M,m,p,pr)=>{debug("xRange",comp,ret,gtlt,M,m,p,pr);const xM=isX(M);const xm=xM||isX(m);const xp=xm||isX(p);const anyX=xp;if(gtlt==="="&&anyX){gtlt=""}pr=options.includePrerelease?"-0":"";if(xM){if(gtlt===">"||gtlt==="<"){ret="<0.0.0-0"}else{ret="*"}}else if(gtlt&&anyX){if(xm){m=0}p=0;if(gtlt===">"){gtlt=">=";if(xm){M=+M+1;m=0;p=0}else{m=+m+1;p=0}}else if(gtlt==="<="){gtlt="<";if(xm){M=+M+1}else{m=+m+1}}if(gtlt==="<")pr="-0";ret=`${gtlt+M}.${m}.${p}${pr}`}else if(xm){ret=`>=${M}.0.0${pr} <${+M+1}.0.0-0`}else if(xp){ret=`>=${M}.${m}.0${pr} <${M}.${+m+1}.0-0`}debug("xRange return",ret);return ret}))};const replaceStars=(comp,options)=>{debug("replaceStars",comp,options);return comp.trim().replace(re[t.STAR],"")};const replaceGTE0=(comp,options)=>{debug("replaceGTE0",comp,options);return comp.trim().replace(re[options.includePrerelease?t.GTE0PRE:t.GTE0],"")};const hyphenReplace=incPr=>($0,from,fM,fm,fp,fpr,fb,to,tM,tm,tp,tpr,tb)=>{if(isX(fM)){from=""}else if(isX(fm)){from=`>=${fM}.0.0${incPr?"-0":""}`}else if(isX(fp)){from=`>=${fM}.${fm}.0${incPr?"-0":""}`}else if(fpr){from=`>=${from}`}else{from=`>=${from}${incPr?"-0":""}`}if(isX(tM)){to=""}else if(isX(tm)){to=`<${+tM+1}.0.0-0`}else if(isX(tp)){to=`<${tM}.${+tm+1}.0-0`}else if(tpr){to=`<=${tM}.${tm}.${tp}-${tpr}`}else if(incPr){to=`<${tM}.${tm}.${+tp+1}-0`}else{to=`<=${to}`}return`${from} ${to}`.trim()};const testSet=(set,version,options)=>{for(let i=0;i<set.length;i++){if(!set[i].test(version)){return false}}if(version.prerelease.length&&!options.includePrerelease){for(let i=0;i<set.length;i++){debug(set[i].semver);if(set[i].semver===Comparator.ANY){continue}if(set[i].semver.prerelease.length>0){const allowed=set[i].semver;if(allowed.major===version.major&&allowed.minor===version.minor&&allowed.patch===version.patch){return true}}}return false}return true}},(module,__unused_webpack_exports,__webpack_require__)=>{const Range=__webpack_require__(132);const satisfies=(version,range,options)=>{try{range=new Range(range,options)}catch(er){return false}return range.test(version)};module.exports=satisfies},(module,__unused_webpack_exports,__webpack_require__)=>{const Range=__webpack_require__(132);const toComparators=(range,options)=>new Range(range,options).set.map((comp=>comp.map((c=>c.value)).join(" ").trim().split(" ")));module.exports=toComparators},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const Range=__webpack_require__(132);const maxSatisfying=(versions,range,options)=>{let max=null;let maxSV=null;let rangeObj=null;try{rangeObj=new Range(range,options)}catch(er){return null}versions.forEach((v=>{if(rangeObj.test(v)){if(!max||maxSV.compare(v)===-1){max=v;maxSV=new SemVer(max,options)}}}));return max};module.exports=maxSatisfying},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const Range=__webpack_require__(132);const minSatisfying=(versions,range,options)=>{let min=null;let minSV=null;let rangeObj=null;try{rangeObj=new Range(range,options)}catch(er){return null}versions.forEach((v=>{if(rangeObj.test(v)){if(!min||minSV.compare(v)===1){min=v;minSV=new SemVer(min,options)}}}));return min};module.exports=minSatisfying},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const Range=__webpack_require__(132);const gt=__webpack_require__(124);const minVersion=(range,loose)=>{range=new Range(range,loose);let minver=new SemVer("0.0.0");if(range.test(minver)){return minver}minver=new SemVer("0.0.0-0");if(range.test(minver)){return minver}minver=null;for(let i=0;i<range.set.length;++i){const comparators=range.set[i];comparators.forEach((comparator=>{const compver=new SemVer(comparator.semver.version);switch(comparator.operator){case">":if(compver.prerelease.length===0){compver.patch++}else{compver.prerelease.push(0)}compver.raw=compver.format();case"":case">=":if(!minver||gt(minver,compver)){minver=compver}break;case"<":case"<=":break;default:throw new Error(`Unexpected operation: ${comparator.operator}`)}}))}if(minver&&range.test(minver)){return minver}return null};module.exports=minVersion},(module,__unused_webpack_exports,__webpack_require__)=>{const Range=__webpack_require__(132);const validRange=(range,options)=>{try{return new Range(range,options).range||"*"}catch(er){return null}};module.exports=validRange},(module,__unused_webpack_exports,__webpack_require__)=>{const SemVer=__webpack_require__(106);const Comparator=__webpack_require__(131);const{ANY}=Comparator;const Range=__webpack_require__(132);const satisfies=__webpack_require__(133);const gt=__webpack_require__(124);const lt=__webpack_require__(125);const lte=__webpack_require__(128);const gte=__webpack_require__(127);const outside=(version,range,hilo,options)=>{version=new SemVer(version,options);range=new Range(range,options);let gtfn,ltefn,ltfn,comp,ecomp;switch(hilo){case">":gtfn=gt;ltefn=lte;ltfn=lt;comp=">";ecomp=">=";break;case"<":gtfn=lt;ltefn=gte;ltfn=gt;comp="<";ecomp="<=";break;default:throw new TypeError('Must provide a hilo val of "<" or ">"')}if(satisfies(version,range,options)){return false}for(let i=0;i<range.set.length;++i){const comparators=range.set[i];let high=null;let low=null;comparators.forEach((comparator=>{if(comparator.semver===ANY){comparator=new Comparator(">=0.0.0")}high=high||comparator;low=low||comparator;if(gtfn(comparator.semver,high.semver,options)){high=comparator}else if(ltfn(comparator.semver,low.semver,options)){low=comparator}}));if(high.operator===comp||high.operator===ecomp){return false}if((!low.operator||low.operator===comp)&&ltefn(version,low.semver)){return false}else if(low.operator===ecomp&&ltfn(version,low.semver)){return false}}return true};module.exports=outside},(module,__unused_webpack_exports,__webpack_require__)=>{const outside=__webpack_require__(139);const gtr=(version,range,options)=>outside(version,range,">",options);module.exports=gtr},(module,__unused_webpack_exports,__webpack_require__)=>{const outside=__webpack_require__(139);const ltr=(version,range,options)=>outside(version,range,"<",options);module.exports=ltr},(module,__unused_webpack_exports,__webpack_require__)=>{const Range=__webpack_require__(132);const intersects=(r1,r2,options)=>{r1=new Range(r1,options);r2=new Range(r2,options);return r1.intersects(r2)};module.exports=intersects},(module,__unused_webpack_exports,__webpack_require__)=>{const satisfies=__webpack_require__(133);const compare=__webpack_require__(114);module.exports=(versions,range,options)=>{const set=[];let min=null;let prev=null;const v=versions.sort(((a,b)=>compare(a,b,options)));for(const version of v){const included=satisfies(version,range,options);if(included){prev=version;if(!min)min=version}else{if(prev){set.push([min,prev])}prev=null;min=null}}if(min)set.push([min,null]);const ranges=[];for(const[min,max]of set){if(min===max)ranges.push(min);else if(!max&&min===v[0])ranges.push("*");else if(!max)ranges.push(`>=${min}`);else if(min===v[0])ranges.push(`<=${max}`);else ranges.push(`${min} - ${max}`)}const simplified=ranges.join(" || ");const original=typeof range.raw==="string"?range.raw:String(range);return simplified.length<original.length?simplified:range}},(module,__unused_webpack_exports,__webpack_require__)=>{const Range=__webpack_require__(132);const{ANY}=__webpack_require__(131);const satisfies=__webpack_require__(133);const compare=__webpack_require__(114);const subset=(sub,dom,options)=>{sub=new Range(sub,options);dom=new Range(dom,options);let sawNonNull=false;OUTER:for(const simpleSub of sub.set){for(const simpleDom of dom.set){const isSub=simpleSubset(simpleSub,simpleDom,options);sawNonNull=sawNonNull||isSub!==null;if(isSub)continue OUTER}if(sawNonNull)return false}return true};const simpleSubset=(sub,dom,options)=>{if(sub.length===1&&sub[0].semver===ANY)return dom.length===1&&dom[0].semver===ANY;const eqSet=new Set;let gt,lt;for(const c of sub){if(c.operator===">"||c.operator===">=")gt=higherGT(gt,c,options);else if(c.operator==="<"||c.operator==="<=")lt=lowerLT(lt,c,options);else eqSet.add(c.semver)}if(eqSet.size>1)return null;let gtltComp;if(gt&&lt){gtltComp=compare(gt.semver,lt.semver,options);if(gtltComp>0)return null;else if(gtltComp===0&&(gt.operator!==">="||lt.operator!=="<="))return null}for(const eq of eqSet){if(gt&&!satisfies(eq,String(gt),options))return null;if(lt&&!satisfies(eq,String(lt),options))return null;for(const c of dom){if(!satisfies(eq,String(c),options))return false}return true}let higher,lower;let hasDomLT,hasDomGT;for(const c of dom){hasDomGT=hasDomGT||c.operator===">"||c.operator===">=";hasDomLT=hasDomLT||c.operator==="<"||c.operator==="<=";if(gt){if(c.operator===">"||c.operator===">="){higher=higherGT(gt,c,options);if(higher===c)return false}else if(gt.operator===">="&&!satisfies(gt.semver,String(c),options))return false}if(lt){if(c.operator==="<"||c.operator==="<="){lower=lowerLT(lt,c,options);if(lower===c)return false}else if(lt.operator==="<="&&!satisfies(lt.semver,String(c),options))return false}if(!c.operator&&(lt||gt)&&gtltComp!==0)return false}if(gt&&hasDomLT&&!lt&&gtltComp!==0)return false;if(lt&&hasDomGT&&!gt&&gtltComp!==0)return false;return true};const higherGT=(a,b,options)=>{if(!a)return b;const comp=compare(a.semver,b.semver,options);return comp>0?a:comp<0?b:b.operator===">"&&a.operator===">="?b:a};const lowerLT=(a,b,options)=>{if(!a)return b;const comp=compare(a.semver,b.semver,options);return comp<0?a:comp>0?b:b.operator==="<"&&a.operator==="<="?b:a};module.exports=subset},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.createTempUpdateFile=createTempUpdateFile;exports.DownloadedUpdateHelper=void 0;function _crypto(){const data=__webpack_require__(9);_crypto=function(){return data};return data}var _fs=__webpack_require__(20);function _lodash(){const data=_interopRequireDefault(__webpack_require__(146));_lodash=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}var path=_interopRequireWildcard(__webpack_require__(40));function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}class DownloadedUpdateHelper{constructor(cacheDir){this.cacheDir=cacheDir;this._file=null;this._packageFile=null;this.versionInfo=null;this.fileInfo=null;this._downloadedFileInfo=null}get downloadedFileInfo(){return this._downloadedFileInfo}get file(){return this._file}get packageFile(){return this._packageFile}get cacheDirForPendingUpdate(){return path.join(this.cacheDir,"pending")}async validateDownloadedPath(updateFile,updateInfo,fileInfo,logger){if(this.versionInfo!=null&&this.file===updateFile&&this.fileInfo!=null){if((0,_lodash().default)(this.versionInfo,updateInfo)&&(0,_lodash().default)(this.fileInfo.info,fileInfo.info)&&await(0,_fsExtra().pathExists)(updateFile)){return updateFile}else{return null}}const cachedUpdateFile=await this.getValidCachedUpdateFile(fileInfo,logger);if(cachedUpdateFile===null){return null}logger.info(`Update has already been downloaded to ${updateFile}).`);this._file=cachedUpdateFile;return cachedUpdateFile}async setDownloadedFile(downloadedFile,packageFile,versionInfo,fileInfo,updateFileName,isSaveCache){this._file=downloadedFile;this._packageFile=packageFile;this.versionInfo=versionInfo;this.fileInfo=fileInfo;this._downloadedFileInfo={fileName:updateFileName,sha512:fileInfo.info.sha512,isAdminRightsRequired:fileInfo.info.isAdminRightsRequired===true};if(isSaveCache){await(0,_fsExtra().outputJson)(this.getUpdateInfoFile(),this._downloadedFileInfo)}}async clear(){this._file=null;this._packageFile=null;this.versionInfo=null;this.fileInfo=null;await this.cleanCacheDirForPendingUpdate()}async cleanCacheDirForPendingUpdate(){try{await(0,_fsExtra().emptyDir)(this.cacheDirForPendingUpdate)}catch(ignore){}}async getValidCachedUpdateFile(fileInfo,logger){var _a;const updateInfoFilePath=this.getUpdateInfoFile();const doesUpdateInfoFileExist=await(0,_fsExtra().pathExistsSync)(updateInfoFilePath);if(!doesUpdateInfoFileExist){return null}let cachedInfo;try{cachedInfo=await(0,_fsExtra().readJson)(updateInfoFilePath)}catch(error){let message=`No cached update info available`;if(error.code!=="ENOENT"){await this.cleanCacheDirForPendingUpdate();message+=` (error on read: ${error.message})`}logger.info(message);return null}const isCachedInfoFileNameValid=(_a=(cachedInfo===null||cachedInfo===void 0?void 0:cachedInfo.fileName)!==null)!==null&&_a!==void 0?_a:false;if(!isCachedInfoFileNameValid){logger.warn(`Cached update info is corrupted: no fileName, directory for cached update will be cleaned`);await this.cleanCacheDirForPendingUpdate();return null}if(fileInfo.info.sha512!==cachedInfo.sha512){logger.info(`Cached update sha512 checksum doesn't match the latest available update. New update must be downloaded. Cached: ${cachedInfo.sha512}, expected: ${fileInfo.info.sha512}. Directory for cached update will be cleaned`);await this.cleanCacheDirForPendingUpdate();return null}const updateFile=path.join(this.cacheDirForPendingUpdate,cachedInfo.fileName);if(!await(0,_fsExtra().pathExists)(updateFile)){logger.info("Cached update file doesn't exist, directory for cached update will be cleaned");await this.cleanCacheDirForPendingUpdate();return null}const sha512=await hashFile(updateFile);if(fileInfo.info.sha512!==sha512){logger.warn(`Sha512 checksum doesn't match the latest available update. New update must be downloaded. Cached: ${sha512}, expected: ${fileInfo.info.sha512}`);await this.cleanCacheDirForPendingUpdate();return null}this._downloadedFileInfo=cachedInfo;return updateFile}getUpdateInfoFile(){return path.join(this.cacheDirForPendingUpdate,"update-info.json")}}exports.DownloadedUpdateHelper=DownloadedUpdateHelper;function hashFile(file,algorithm="sha512",encoding="base64",options){return new Promise(((resolve,reject)=>{const hash=(0,_crypto().createHash)(algorithm);hash.on("error",reject).setEncoding(encoding);(0,_fs.createReadStream)(file,{...options,highWaterMark:1024*1024}).on("error",reject).on("end",(()=>{hash.end();resolve(hash.read())})).pipe(hash,{end:false})}))}async function createTempUpdateFile(name,cacheDir,log){let nameCounter=0;let result=path.join(cacheDir,name);for(let i=0;i<3;i++){try{await(0,_fsExtra().unlink)(result);return result}catch(e){if(e.code==="ENOENT"){return result}log.warn(`Error on remove temp update file: ${e}`);result=path.join(cacheDir,`${nameCounter++}-${name}`)}}return result}},(module,exports,__webpack_require__)=>{module=__webpack_require__.nmd(module);var LARGE_ARRAY_SIZE=200;var HASH_UNDEFINED="__lodash_hash_undefined__";var COMPARE_PARTIAL_FLAG=1,COMPARE_UNORDERED_FLAG=2;var MAX_SAFE_INTEGER=9007199254740991;var argsTag="[object Arguments]",arrayTag="[object Array]",asyncTag="[object AsyncFunction]",boolTag="[object Boolean]",dateTag="[object Date]",errorTag="[object Error]",funcTag="[object Function]",genTag="[object GeneratorFunction]",mapTag="[object Map]",numberTag="[object Number]",nullTag="[object Null]",objectTag="[object Object]",promiseTag="[object Promise]",proxyTag="[object Proxy]",regexpTag="[object RegExp]",setTag="[object Set]",stringTag="[object String]",symbolTag="[object Symbol]",undefinedTag="[object Undefined]",weakMapTag="[object WeakMap]";var arrayBufferTag="[object ArrayBuffer]",dataViewTag="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]";var reRegExpChar=/[\\^$.*+?()[\]{}|]/g;var reIsHostCtor=/^\[object .+?Constructor\]$/;var reIsUint=/^(?:0|[1-9]\d*)$/;var typedArrayTags={};typedArrayTags[float32Tag]=typedArrayTags[float64Tag]=typedArrayTags[int8Tag]=typedArrayTags[int16Tag]=typedArrayTags[int32Tag]=typedArrayTags[uint8Tag]=typedArrayTags[uint8ClampedTag]=typedArrayTags[uint16Tag]=typedArrayTags[uint32Tag]=true;typedArrayTags[argsTag]=typedArrayTags[arrayTag]=typedArrayTags[arrayBufferTag]=typedArrayTags[boolTag]=typedArrayTags[dataViewTag]=typedArrayTags[dateTag]=typedArrayTags[errorTag]=typedArrayTags[funcTag]=typedArrayTags[mapTag]=typedArrayTags[numberTag]=typedArrayTags[objectTag]=typedArrayTags[regexpTag]=typedArrayTags[setTag]=typedArrayTags[stringTag]=typedArrayTags[weakMapTag]=false;var freeGlobal=typeof global=="object"&&global&&global.Object===Object&&global;var freeSelf=typeof self=="object"&&self&&self.Object===Object&&self;var root=freeGlobal||freeSelf||Function("return this")();var freeExports=true&&exports&&!exports.nodeType&&exports;var freeModule=freeExports&&"object"=="object"&&module&&!module.nodeType&&module;var moduleExports=freeModule&&freeModule.exports===freeExports;var freeProcess=moduleExports&&freeGlobal.process;var nodeUtil=function(){try{return freeProcess&&freeProcess.binding&&freeProcess.binding("util")}catch(e){}}();var nodeIsTypedArray=nodeUtil&&nodeUtil.isTypedArray;function arrayFilter(array,predicate){var index=-1,length=array==null?0:array.length,resIndex=0,result=[];while(++index<length){var value=array[index];if(predicate(value,index,array)){result[resIndex++]=value}}return result}function arrayPush(array,values){var index=-1,length=values.length,offset=array.length;while(++index<length){array[offset+index]=values[index]}return array}function arraySome(array,predicate){var index=-1,length=array==null?0:array.length;while(++index<length){if(predicate(array[index],index,array)){return true}}return false}function baseTimes(n,iteratee){var index=-1,result=Array(n);while(++index<n){result[index]=iteratee(index)}return result}function baseUnary(func){return function(value){return func(value)}}function cacheHas(cache,key){return cache.has(key)}function getValue(object,key){return object==null?undefined:object[key]}function mapToArray(map){var index=-1,result=Array(map.size);map.forEach((function(value,key){result[++index]=[key,value]}));return result}function overArg(func,transform){return function(arg){return func(transform(arg))}}function setToArray(set){var index=-1,result=Array(set.size);set.forEach((function(value){result[++index]=value}));return result}var arrayProto=Array.prototype,funcProto=Function.prototype,objectProto=Object.prototype;var coreJsData=root["__core-js_shared__"];var funcToString=funcProto.toString;var hasOwnProperty=objectProto.hasOwnProperty;var maskSrcKey=function(){var uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||"");return uid?"Symbol(src)_1."+uid:""}();var nativeObjectToString=objectProto.toString;var reIsNative=RegExp("^"+funcToString.call(hasOwnProperty).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Buffer=moduleExports?root.Buffer:undefined,Symbol=root.Symbol,Uint8Array=root.Uint8Array,propertyIsEnumerable=objectProto.propertyIsEnumerable,splice=arrayProto.splice,symToStringTag=Symbol?Symbol.toStringTag:undefined;var nativeGetSymbols=Object.getOwnPropertySymbols,nativeIsBuffer=Buffer?Buffer.isBuffer:undefined,nativeKeys=overArg(Object.keys,Object);var DataView=getNative(root,"DataView"),Map=getNative(root,"Map"),Promise=getNative(root,"Promise"),Set=getNative(root,"Set"),WeakMap=getNative(root,"WeakMap"),nativeCreate=getNative(Object,"create");var dataViewCtorString=toSource(DataView),mapCtorString=toSource(Map),promiseCtorString=toSource(Promise),setCtorString=toSource(Set),weakMapCtorString=toSource(WeakMap);var symbolProto=Symbol?Symbol.prototype:undefined,symbolValueOf=symbolProto?symbolProto.valueOf:undefined;function Hash(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function hashClear(){this.__data__=nativeCreate?nativeCreate(null):{};this.size=0}function hashDelete(key){var result=this.has(key)&&delete this.__data__[key];this.size-=result?1:0;return result}function hashGet(key){var data=this.__data__;if(nativeCreate){var result=data[key];return result===HASH_UNDEFINED?undefined:result}return hasOwnProperty.call(data,key)?data[key]:undefined}function hashHas(key){var data=this.__data__;return nativeCreate?data[key]!==undefined:hasOwnProperty.call(data,key)}function hashSet(key,value){var data=this.__data__;this.size+=this.has(key)?0:1;data[key]=nativeCreate&&value===undefined?HASH_UNDEFINED:value;return this}Hash.prototype.clear=hashClear;Hash.prototype["delete"]=hashDelete;Hash.prototype.get=hashGet;Hash.prototype.has=hashHas;Hash.prototype.set=hashSet;function ListCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function listCacheClear(){this.__data__=[];this.size=0}function listCacheDelete(key){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){return false}var lastIndex=data.length-1;if(index==lastIndex){data.pop()}else{splice.call(data,index,1)}--this.size;return true}function listCacheGet(key){var data=this.__data__,index=assocIndexOf(data,key);return index<0?undefined:data[index][1]}function listCacheHas(key){return assocIndexOf(this.__data__,key)>-1}function listCacheSet(key,value){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){++this.size;data.push([key,value])}else{data[index][1]=value}return this}ListCache.prototype.clear=listCacheClear;ListCache.prototype["delete"]=listCacheDelete;ListCache.prototype.get=listCacheGet;ListCache.prototype.has=listCacheHas;ListCache.prototype.set=listCacheSet;function MapCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function mapCacheClear(){this.size=0;this.__data__={hash:new Hash,map:new(Map||ListCache),string:new Hash}}function mapCacheDelete(key){var result=getMapData(this,key)["delete"](key);this.size-=result?1:0;return result}function mapCacheGet(key){return getMapData(this,key).get(key)}function mapCacheHas(key){return getMapData(this,key).has(key)}function mapCacheSet(key,value){var data=getMapData(this,key),size=data.size;data.set(key,value);this.size+=data.size==size?0:1;return this}MapCache.prototype.clear=mapCacheClear;MapCache.prototype["delete"]=mapCacheDelete;MapCache.prototype.get=mapCacheGet;MapCache.prototype.has=mapCacheHas;MapCache.prototype.set=mapCacheSet;function SetCache(values){var index=-1,length=values==null?0:values.length;this.__data__=new MapCache;while(++index<length){this.add(values[index])}}function setCacheAdd(value){this.__data__.set(value,HASH_UNDEFINED);return this}function setCacheHas(value){return this.__data__.has(value)}SetCache.prototype.add=SetCache.prototype.push=setCacheAdd;SetCache.prototype.has=setCacheHas;function Stack(entries){var data=this.__data__=new ListCache(entries);this.size=data.size}function stackClear(){this.__data__=new ListCache;this.size=0}function stackDelete(key){var data=this.__data__,result=data["delete"](key);this.size=data.size;return result}function stackGet(key){return this.__data__.get(key)}function stackHas(key){return this.__data__.has(key)}function stackSet(key,value){var data=this.__data__;if(data instanceof ListCache){var pairs=data.__data__;if(!Map||pairs.length<LARGE_ARRAY_SIZE-1){pairs.push([key,value]);this.size=++data.size;return this}data=this.__data__=new MapCache(pairs)}data.set(key,value);this.size=data.size;return this}Stack.prototype.clear=stackClear;Stack.prototype["delete"]=stackDelete;Stack.prototype.get=stackGet;Stack.prototype.has=stackHas;Stack.prototype.set=stackSet;function arrayLikeKeys(value,inherited){var isArr=isArray(value),isArg=!isArr&&isArguments(value),isBuff=!isArr&&!isArg&&isBuffer(value),isType=!isArr&&!isArg&&!isBuff&&isTypedArray(value),skipIndexes=isArr||isArg||isBuff||isType,result=skipIndexes?baseTimes(value.length,String):[],length=result.length;for(var key in value){if((inherited||hasOwnProperty.call(value,key))&&!(skipIndexes&&(key=="length"||isBuff&&(key=="offset"||key=="parent")||isType&&(key=="buffer"||key=="byteLength"||key=="byteOffset")||isIndex(key,length)))){result.push(key)}}return result}function assocIndexOf(array,key){var length=array.length;while(length--){if(eq(array[length][0],key)){return length}}return-1}function baseGetAllKeys(object,keysFunc,symbolsFunc){var result=keysFunc(object);return isArray(object)?result:arrayPush(result,symbolsFunc(object))}function baseGetTag(value){if(value==null){return value===undefined?undefinedTag:nullTag}return symToStringTag&&symToStringTag in Object(value)?getRawTag(value):objectToString(value)}function baseIsArguments(value){return isObjectLike(value)&&baseGetTag(value)==argsTag}function baseIsEqual(value,other,bitmask,customizer,stack){if(value===other){return true}if(value==null||other==null||!isObjectLike(value)&&!isObjectLike(other)){return value!==value&&other!==other}return baseIsEqualDeep(value,other,bitmask,customizer,baseIsEqual,stack)}function baseIsEqualDeep(object,other,bitmask,customizer,equalFunc,stack){var objIsArr=isArray(object),othIsArr=isArray(other),objTag=objIsArr?arrayTag:getTag(object),othTag=othIsArr?arrayTag:getTag(other);objTag=objTag==argsTag?objectTag:objTag;othTag=othTag==argsTag?objectTag:othTag;var objIsObj=objTag==objectTag,othIsObj=othTag==objectTag,isSameTag=objTag==othTag;if(isSameTag&&isBuffer(object)){if(!isBuffer(other)){return false}objIsArr=true;objIsObj=false}if(isSameTag&&!objIsObj){stack||(stack=new Stack);return objIsArr||isTypedArray(object)?equalArrays(object,other,bitmask,customizer,equalFunc,stack):equalByTag(object,other,objTag,bitmask,customizer,equalFunc,stack)}if(!(bitmask&COMPARE_PARTIAL_FLAG)){var objIsWrapped=objIsObj&&hasOwnProperty.call(object,"__wrapped__"),othIsWrapped=othIsObj&&hasOwnProperty.call(other,"__wrapped__");if(objIsWrapped||othIsWrapped){var objUnwrapped=objIsWrapped?object.value():object,othUnwrapped=othIsWrapped?other.value():other;stack||(stack=new Stack);return equalFunc(objUnwrapped,othUnwrapped,bitmask,customizer,stack)}}if(!isSameTag){return false}stack||(stack=new Stack);return equalObjects(object,other,bitmask,customizer,equalFunc,stack)}function baseIsNative(value){if(!isObject(value)||isMasked(value)){return false}var pattern=isFunction(value)?reIsNative:reIsHostCtor;return pattern.test(toSource(value))}function baseIsTypedArray(value){return isObjectLike(value)&&isLength(value.length)&&!!typedArrayTags[baseGetTag(value)]}function baseKeys(object){if(!isPrototype(object)){return nativeKeys(object)}var result=[];for(var key in Object(object)){if(hasOwnProperty.call(object,key)&&key!="constructor"){result.push(key)}}return result}function equalArrays(array,other,bitmask,customizer,equalFunc,stack){var isPartial=bitmask&COMPARE_PARTIAL_FLAG,arrLength=array.length,othLength=other.length;if(arrLength!=othLength&&!(isPartial&&othLength>arrLength)){return false}var stacked=stack.get(array);if(stacked&&stack.get(other)){return stacked==other}var index=-1,result=true,seen=bitmask&COMPARE_UNORDERED_FLAG?new SetCache:undefined;stack.set(array,other);stack.set(other,array);while(++index<arrLength){var arrValue=array[index],othValue=other[index];if(customizer){var compared=isPartial?customizer(othValue,arrValue,index,other,array,stack):customizer(arrValue,othValue,index,array,other,stack)}if(compared!==undefined){if(compared){continue}result=false;break}if(seen){if(!arraySome(other,(function(othValue,othIndex){if(!cacheHas(seen,othIndex)&&(arrValue===othValue||equalFunc(arrValue,othValue,bitmask,customizer,stack))){return seen.push(othIndex)}}))){result=false;break}}else if(!(arrValue===othValue||equalFunc(arrValue,othValue,bitmask,customizer,stack))){result=false;break}}stack["delete"](array);stack["delete"](other);return result}function equalByTag(object,other,tag,bitmask,customizer,equalFunc,stack){switch(tag){case dataViewTag:if(object.byteLength!=other.byteLength||object.byteOffset!=other.byteOffset){return false}object=object.buffer;other=other.buffer;case arrayBufferTag:if(object.byteLength!=other.byteLength||!equalFunc(new Uint8Array(object),new Uint8Array(other))){return false}return true;case boolTag:case dateTag:case numberTag:return eq(+object,+other);case errorTag:return object.name==other.name&&object.message==other.message;case regexpTag:case stringTag:return object==other+"";case mapTag:var convert=mapToArray;case setTag:var isPartial=bitmask&COMPARE_PARTIAL_FLAG;convert||(convert=setToArray);if(object.size!=other.size&&!isPartial){return false}var stacked=stack.get(object);if(stacked){return stacked==other}bitmask|=COMPARE_UNORDERED_FLAG;stack.set(object,other);var result=equalArrays(convert(object),convert(other),bitmask,customizer,equalFunc,stack);stack["delete"](object);return result;case symbolTag:if(symbolValueOf){return symbolValueOf.call(object)==symbolValueOf.call(other)}}return false}function equalObjects(object,other,bitmask,customizer,equalFunc,stack){var isPartial=bitmask&COMPARE_PARTIAL_FLAG,objProps=getAllKeys(object),objLength=objProps.length,othProps=getAllKeys(other),othLength=othProps.length;if(objLength!=othLength&&!isPartial){return false}var index=objLength;while(index--){var key=objProps[index];if(!(isPartial?key in other:hasOwnProperty.call(other,key))){return false}}var stacked=stack.get(object);if(stacked&&stack.get(other)){return stacked==other}var result=true;stack.set(object,other);stack.set(other,object);var skipCtor=isPartial;while(++index<objLength){key=objProps[index];var objValue=object[key],othValue=other[key];if(customizer){var compared=isPartial?customizer(othValue,objValue,key,other,object,stack):customizer(objValue,othValue,key,object,other,stack)}if(!(compared===undefined?objValue===othValue||equalFunc(objValue,othValue,bitmask,customizer,stack):compared)){result=false;break}skipCtor||(skipCtor=key=="constructor")}if(result&&!skipCtor){var objCtor=object.constructor,othCtor=other.constructor;if(objCtor!=othCtor&&("constructor"in object&&"constructor"in other)&&!(typeof objCtor=="function"&&objCtor instanceof objCtor&&typeof othCtor=="function"&&othCtor instanceof othCtor)){result=false}}stack["delete"](object);stack["delete"](other);return result}function getAllKeys(object){return baseGetAllKeys(object,keys,getSymbols)}function getMapData(map,key){var data=map.__data__;return isKeyable(key)?data[typeof key=="string"?"string":"hash"]:data.map}function getNative(object,key){var value=getValue(object,key);return baseIsNative(value)?value:undefined}function getRawTag(value){var isOwn=hasOwnProperty.call(value,symToStringTag),tag=value[symToStringTag];try{value[symToStringTag]=undefined;var unmasked=true}catch(e){}var result=nativeObjectToString.call(value);if(unmasked){if(isOwn){value[symToStringTag]=tag}else{delete value[symToStringTag]}}return result}var getSymbols=!nativeGetSymbols?stubArray:function(object){if(object==null){return[]}object=Object(object);return arrayFilter(nativeGetSymbols(object),(function(symbol){return propertyIsEnumerable.call(object,symbol)}))};var getTag=baseGetTag;if(DataView&&getTag(new DataView(new ArrayBuffer(1)))!=dataViewTag||Map&&getTag(new Map)!=mapTag||Promise&&getTag(Promise.resolve())!=promiseTag||Set&&getTag(new Set)!=setTag||WeakMap&&getTag(new WeakMap)!=weakMapTag){getTag=function(value){var result=baseGetTag(value),Ctor=result==objectTag?value.constructor:undefined,ctorString=Ctor?toSource(Ctor):"";if(ctorString){switch(ctorString){case dataViewCtorString:return dataViewTag;case mapCtorString:return mapTag;case promiseCtorString:return promiseTag;case setCtorString:return setTag;case weakMapCtorString:return weakMapTag}}return result}}function isIndex(value,length){length=length==null?MAX_SAFE_INTEGER:length;return!!length&&(typeof value=="number"||reIsUint.test(value))&&(value>-1&&value%1==0&&value<length)}function isKeyable(value){var type=typeof value;return type=="string"||type=="number"||type=="symbol"||type=="boolean"?value!=="__proto__":value===null}function isMasked(func){return!!maskSrcKey&&maskSrcKey in func}function isPrototype(value){var Ctor=value&&value.constructor,proto=typeof Ctor=="function"&&Ctor.prototype||objectProto;return value===proto}function objectToString(value){return nativeObjectToString.call(value)}function toSource(func){if(func!=null){try{return funcToString.call(func)}catch(e){}try{return func+""}catch(e){}}return""}function eq(value,other){return value===other||value!==value&&other!==other}var isArguments=baseIsArguments(function(){return arguments}())?baseIsArguments:function(value){return isObjectLike(value)&&hasOwnProperty.call(value,"callee")&&!propertyIsEnumerable.call(value,"callee")};var isArray=Array.isArray;function isArrayLike(value){return value!=null&&isLength(value.length)&&!isFunction(value)}var isBuffer=nativeIsBuffer||stubFalse;function isEqual(value,other){return baseIsEqual(value,other)}function isFunction(value){if(!isObject(value)){return false}var tag=baseGetTag(value);return tag==funcTag||tag==genTag||tag==asyncTag||tag==proxyTag}function isLength(value){return typeof value=="number"&&value>-1&&value%1==0&&value<=MAX_SAFE_INTEGER}function isObject(value){var type=typeof value;return value!=null&&(type=="object"||type=="function")}function isObjectLike(value){return value!=null&&typeof value=="object"}var isTypedArray=nodeIsTypedArray?baseUnary(nodeIsTypedArray):baseIsTypedArray;function keys(object){return isArrayLike(object)?arrayLikeKeys(object):baseKeys(object)}function stubArray(){return[]}function stubFalse(){return false}module.exports=isEqual},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ElectronAppAdapter=void 0;var path=_interopRequireWildcard(__webpack_require__(40));function _AppAdapter(){const data=__webpack_require__(148);_AppAdapter=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class ElectronAppAdapter{constructor(app=__webpack_require__(1).app){this.app=app}whenReady(){return this.app.whenReady()}get version(){return this.app.getVersion()}get name(){return this.app.getName()}get isPackaged(){return this.app.isPackaged===true}get appUpdateConfigPath(){return this.isPackaged?path.join(process.resourcesPath,"app-update.yml"):path.join(this.app.getAppPath(),"dev-app-update.yml")}get userDataPath(){return this.app.getPath("userData")}get baseCachePath(){return(0,_AppAdapter().getAppCacheDir)()}quit(){this.app.quit()}onQuit(handler){this.app.once("quit",((_,exitCode)=>handler(exitCode)))}}exports.ElectronAppAdapter=ElectronAppAdapter},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getAppCacheDir=getAppCacheDir;var path=_interopRequireWildcard(__webpack_require__(40));function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}function getAppCacheDir(){const homedir=__webpack_require__(18).homedir();let result;if(process.platform==="win32"){result=process.env.LOCALAPPDATA||path.join(homedir,"AppData","Local")}else if(process.platform==="darwin"){result=path.join(homedir,"Library","Application Support","Caches")}else{result=process.env.XDG_CACHE_HOME||path.join(homedir,".cache")}return result}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getNetSession=getNetSession;exports.ElectronHttpExecutor=exports.NET_SESSION_NAME=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _electron(){const data=__webpack_require__(1);_electron=function(){return data};return data}const NET_SESSION_NAME="electron-updater";exports.NET_SESSION_NAME=NET_SESSION_NAME;function getNetSession(){return _electron().session.fromPartition(NET_SESSION_NAME,{cache:false})}class ElectronHttpExecutor extends _builderUtilRuntime().HttpExecutor{constructor(proxyLoginCallback){super();this.proxyLoginCallback=proxyLoginCallback;this.cachedSession=null}async download(url,destination,options){return await options.cancellationToken.createPromise(((resolve,reject,onCancel)=>{const requestOptions={headers:options.headers||undefined,redirect:"manual"};(0,_builderUtilRuntime().configureRequestUrl)(url,requestOptions);(0,_builderUtilRuntime().configureRequestOptions)(requestOptions);this.doDownload(requestOptions,{destination,options,onCancel,callback:error=>{if(error==null){resolve(destination)}else{reject(error)}},responseHandler:null},0)}))}createRequest(options,callback){if(options.headers&&options.headers.Host){options.host=options.headers.Host;delete options.headers.Host}if(this.cachedSession==null){this.cachedSession=getNetSession()}const request=_electron().net.request({...options,session:this.cachedSession});request.on("response",callback);if(this.proxyLoginCallback!=null){request.on("login",this.proxyLoginCallback)}return request}addRedirectHandlers(request,options,reject,redirectCount,handler){request.on("redirect",((statusCode,method,redirectUrl)=>{request.abort();if(redirectCount>this.maxRedirects){reject(this.createMaxRedirectError())}else{handler(_builderUtilRuntime().HttpExecutor.prepareRedirectUrlOptions(redirectUrl,options))}}))}}exports.ElectronHttpExecutor=ElectronHttpExecutor},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.GenericProvider=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}class GenericProvider extends _main().Provider{constructor(configuration,updater,runtimeOptions){super(runtimeOptions);this.configuration=configuration;this.updater=updater;this.baseUrl=(0,_main().newBaseUrl)(this.configuration.url)}get channel(){const result=this.updater.channel||this.configuration.channel;return result==null?this.getDefaultChannelName():this.getCustomChannelName(result)}async getLatestVersion(){const channelFile=(0,_main().getChannelFilename)(this.channel);const channelUrl=(0,_main().newUrlFromBase)(channelFile,this.baseUrl,this.updater.isAddNoCacheQuery);for(let attemptNumber=0;;attemptNumber++){try{return(0,_Provider().parseUpdateInfo)(await this.httpRequest(channelUrl),channelFile,channelUrl)}catch(e){if(e instanceof _builderUtilRuntime().HttpError&&e.statusCode===404){throw(0,_builderUtilRuntime().newError)(`Cannot find channel "${channelFile}" update info: ${e.stack||e.message}`,"ERR_UPDATER_CHANNEL_FILE_NOT_FOUND")}else if(e.code==="ECONNREFUSED"){if(attemptNumber<3){await new Promise(((resolve,reject)=>{try{setTimeout(resolve,1e3*attemptNumber)}catch(e){reject(e)}}));continue}}throw e}}}resolveFiles(updateInfo){return(0,_Provider().resolveFiles)(updateInfo,this.baseUrl)}}exports.GenericProvider=GenericProvider},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.findFile=findFile;exports.parseUpdateInfo=parseUpdateInfo;exports.getFileList=getFileList;exports.resolveFiles=resolveFiles;exports.Provider=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _jsYaml(){const data=__webpack_require__(69);_jsYaml=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}class Provider{constructor(runtimeOptions){this.runtimeOptions=runtimeOptions;this.requestHeaders=null;this.executor=runtimeOptions.executor}get isUseMultipleRangeRequest(){return this.runtimeOptions.isUseMultipleRangeRequest!==false}getChannelFilePrefix(){if(this.runtimeOptions.platform==="linux"){const arch=process.env.TEST_UPDATER_ARCH||process.arch;const archSuffix=arch==="x64"?"":`-${arch}`;return"-linux"+archSuffix}else{return this.runtimeOptions.platform==="darwin"?"-mac":""}}getDefaultChannelName(){return this.getCustomChannelName("latest")}getCustomChannelName(channel){return`${channel}${this.getChannelFilePrefix()}`}get fileExtraDownloadHeaders(){return null}setRequestHeaders(value){this.requestHeaders=value}httpRequest(url,headers,cancellationToken){return this.executor.request(this.createRequestOptions(url,headers),cancellationToken)}createRequestOptions(url,headers){const result={};if(this.requestHeaders==null){if(headers!=null){result.headers=headers}}else{result.headers=headers==null?this.requestHeaders:{...this.requestHeaders,...headers}}(0,_builderUtilRuntime().configureRequestUrl)(url,result);return result}}exports.Provider=Provider;function findFile(files,extension,not){if(files.length===0){throw(0,_builderUtilRuntime().newError)("No files provided","ERR_UPDATER_NO_FILES_PROVIDED")}const result=files.find((it=>it.url.pathname.toLowerCase().endsWith(`.${extension}`)));if(result!=null){return result}else if(not==null){return files[0]}else{return files.find((fileInfo=>!not.some((ext=>fileInfo.url.pathname.toLowerCase().endsWith(`.${ext}`)))))}}function parseUpdateInfo(rawData,channelFile,channelFileUrl){if(rawData==null){throw(0,_builderUtilRuntime().newError)(`Cannot parse update info from ${channelFile} in the latest release artifacts (${channelFileUrl}): rawData: null`,"ERR_UPDATER_INVALID_UPDATE_INFO")}let result;try{result=(0,_jsYaml().safeLoad)(rawData)}catch(e){throw(0,_builderUtilRuntime().newError)(`Cannot parse update info from ${channelFile} in the latest release artifacts (${channelFileUrl}): ${e.stack||e.message}, rawData: ${rawData}`,"ERR_UPDATER_INVALID_UPDATE_INFO")}return result}function getFileList(updateInfo){const files=updateInfo.files;if(files!=null&&files.length>0){return files}if(updateInfo.path!=null){return[{url:updateInfo.path,sha2:updateInfo.sha2,sha512:updateInfo.sha512}]}else{throw(0,_builderUtilRuntime().newError)(`No files provided: ${(0,_builderUtilRuntime().safeStringifyJson)(updateInfo)}`,"ERR_UPDATER_NO_FILES_PROVIDED")}}function resolveFiles(updateInfo,baseUrl,pathTransformer=(p=>p)){const files=getFileList(updateInfo);const result=files.map((fileInfo=>{if(fileInfo.sha2==null&&fileInfo.sha512==null){throw(0,_builderUtilRuntime().newError)(`Update info doesn't contain nor sha256 neither sha512 checksum: ${(0,_builderUtilRuntime().safeStringifyJson)(fileInfo)}`,"ERR_UPDATER_NO_CHECKSUM")}return{url:(0,_main().newUrlFromBase)(pathTransformer(fileInfo.url),baseUrl),info:fileInfo}}));const packages=updateInfo.packages;const packageInfo=packages==null?null:packages[process.arch]||packages.ia32;if(packageInfo!=null){result[0].packageInfo={...packageInfo,path:(0,_main().newUrlFromBase)(pathTransformer(packageInfo.path),baseUrl).href}}return result}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isUrlProbablySupportMultiRangeRequests=isUrlProbablySupportMultiRangeRequests;exports.createClient=createClient;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _BintrayProvider(){const data=__webpack_require__(153);_BintrayProvider=function(){return data};return data}function _GenericProvider(){const data=__webpack_require__(150);_GenericProvider=function(){return data};return data}function _GitHubProvider(){const data=__webpack_require__(155);_GitHubProvider=function(){return data};return data}function _PrivateGitHubProvider(){const data=__webpack_require__(156);_PrivateGitHubProvider=function(){return data};return data}function isUrlProbablySupportMultiRangeRequests(url){return!url.includes("s3.amazonaws.com")}function createClient(data,updater,runtimeOptions){if(typeof data==="string"){throw(0,_builderUtilRuntime().newError)("Please pass PublishConfiguration object","ERR_UPDATER_INVALID_PROVIDER_CONFIGURATION")}const provider=data.provider;switch(provider){case"github":{const githubOptions=data;const token=(githubOptions.private?process.env.GH_TOKEN||process.env.GITHUB_TOKEN:null)||githubOptions.token;if(token==null){return new(_GitHubProvider().GitHubProvider)(githubOptions,updater,runtimeOptions)}else{return new(_PrivateGitHubProvider().PrivateGitHubProvider)(githubOptions,updater,token,runtimeOptions)}}case"s3":case"spaces":return new(_GenericProvider().GenericProvider)({provider:"generic",url:(0,_builderUtilRuntime().getS3LikeProviderBaseUrl)(data),channel:data.channel||null},updater,{...runtimeOptions,isUseMultipleRangeRequest:false});case"generic":{const options=data;return new(_GenericProvider().GenericProvider)(options,updater,{...runtimeOptions,isUseMultipleRangeRequest:options.useMultipleRangeRequest!==false&&isUrlProbablySupportMultiRangeRequests(options.url)})}case"bintray":return new(_BintrayProvider().BintrayProvider)(data,runtimeOptions);default:throw(0,_builderUtilRuntime().newError)(`Unsupported provider: ${provider}`,"ERR_UPDATER_UNSUPPORTED_PROVIDER")}}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.BintrayProvider=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _bintray(){const data=__webpack_require__(154);_bintray=function(){return data};return data}function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}class BintrayProvider extends _main().Provider{constructor(configuration,runtimeOptions){super(runtimeOptions);this.client=new(_bintray().BintrayClient)(configuration,runtimeOptions.executor,new(_builderUtilRuntime().CancellationToken));this.baseUrl=(0,_main().newBaseUrl)(`https://dl.bintray.com/${this.client.owner}/${this.client.repo}`)}setRequestHeaders(value){super.setRequestHeaders(value);this.client.setRequestHeaders(value)}async getLatestVersion(){try{const data=await this.client.getVersion("_latest");const channelFilename=(0,_main().getChannelFilename)(this.getDefaultChannelName());const files=await this.client.getVersionFiles(data.name);const channelFile=files.find((it=>it.name.endsWith(`_${channelFilename}`)||it.name.endsWith(`-${channelFilename}`)));if(channelFile==null){throw(0,_builderUtilRuntime().newError)(`Cannot find channel file "${channelFilename}", existing files:\n${files.map((it=>JSON.stringify(it,null,2))).join(",\n")}`,"ERR_UPDATER_CHANNEL_FILE_NOT_FOUND")}const channelFileUrl=new(_url().URL)(`https://dl.bintray.com/${this.client.owner}/${this.client.repo}/${channelFile.name}`);return(0,_Provider().parseUpdateInfo)(await this.httpRequest(channelFileUrl),channelFilename,channelFileUrl)}catch(e){if("statusCode"in e&&e.statusCode===404){throw(0,_builderUtilRuntime().newError)(`No latest version, please ensure that user, package and repository correctly configured. Or at least one version is published. ${e.stack||e.message}`,"ERR_UPDATER_LATEST_VERSION_NOT_FOUND")}throw e}}resolveFiles(updateInfo){return(0,_Provider().resolveFiles)(updateInfo,this.baseUrl)}}exports.BintrayProvider=BintrayProvider},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.BintrayClient=void 0;function _httpExecutor(){const data=__webpack_require__(8);_httpExecutor=function(){return data};return data}class BintrayClient{constructor(options,httpExecutor,cancellationToken,apiKey){this.httpExecutor=httpExecutor;this.cancellationToken=cancellationToken;this.requestHeaders=null;if(options.owner==null){throw new Error("owner is not specified")}if(options.package==null){throw new Error("package is not specified")}this.repo=options.repo||"generic";this.packageName=options.package;this.owner=options.owner;this.user=options.user||options.owner;this.component=options.component||null;this.distribution=options.distribution||"stable";this.auth=apiKey==null?null:`Basic ${Buffer.from(`${this.user}:${apiKey}`).toString("base64")}`;this.basePath=`/packages/${this.owner}/${this.repo}/${this.packageName}`}setRequestHeaders(value){this.requestHeaders=value}bintrayRequest(path,auth,data=null,cancellationToken,method){return(0,_httpExecutor().parseJson)(this.httpExecutor.request((0,_httpExecutor().configureRequestOptions)({hostname:"api.bintray.com",path,headers:this.requestHeaders||undefined},auth,method),cancellationToken,data))}getVersion(version){return this.bintrayRequest(`${this.basePath}/versions/${version}`,this.auth,null,this.cancellationToken)}getVersionFiles(version){return this.bintrayRequest(`${this.basePath}/versions/${version}/files`,this.auth,null,this.cancellationToken)}createVersion(version){return this.bintrayRequest(`${this.basePath}/versions`,this.auth,{name:version},this.cancellationToken)}deleteVersion(version){return this.bintrayRequest(`${this.basePath}/versions/${version}`,this.auth,null,this.cancellationToken,"DELETE")}}exports.BintrayClient=BintrayClient},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.computeReleaseNotes=computeReleaseNotes;exports.GitHubProvider=exports.BaseGitHubProvider=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function semver(){const data=_interopRequireWildcard(__webpack_require__(102));semver=function(){return data};return data}function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}const hrefRegExp=/\/tag\/v?([^/]+)$/;class BaseGitHubProvider extends _main().Provider{constructor(options,defaultHost,runtimeOptions){super({...runtimeOptions,isUseMultipleRangeRequest:false});this.options=options;this.baseUrl=(0,_main().newBaseUrl)((0,_builderUtilRuntime().githubUrl)(options,defaultHost));const apiHost=defaultHost==="github.com"?"api.github.com":defaultHost;this.baseApiUrl=(0,_main().newBaseUrl)((0,_builderUtilRuntime().githubUrl)(options,apiHost))}computeGithubBasePath(result){const host=this.options.host;return host!=null&&host!=="github.com"&&host!=="api.github.com"?`/api/v3${result}`:result}}exports.BaseGitHubProvider=BaseGitHubProvider;class GitHubProvider extends BaseGitHubProvider{constructor(options,updater,runtimeOptions){super(options,"github.com",runtimeOptions);this.options=options;this.updater=updater}async getLatestVersion(){const cancellationToken=new(_builderUtilRuntime().CancellationToken);const feedXml=await this.httpRequest((0,_main().newUrlFromBase)(`${this.basePath}.atom`,this.baseUrl),{accept:"application/xml, application/atom+xml, text/xml, */*"},cancellationToken);const feed=(0,_builderUtilRuntime().parseXml)(feedXml);let latestRelease=feed.element("entry",false,`No published versions on GitHub`);let version;try{if(this.updater.allowPrerelease){version=latestRelease.element("link").attribute("href").match(hrefRegExp)[1]}else{version=await this.getLatestVersionString(cancellationToken);for(const element of feed.getElements("entry")){if(element.element("link").attribute("href").match(hrefRegExp)[1]===version){latestRelease=element;break}}}}catch(e){throw(0,_builderUtilRuntime().newError)(`Cannot parse releases feed: ${e.stack||e.message},\nXML:\n${feedXml}`,"ERR_UPDATER_INVALID_RELEASE_FEED")}if(version==null){throw(0,_builderUtilRuntime().newError)(`No published versions on GitHub`,"ERR_UPDATER_NO_PUBLISHED_VERSIONS")}const channelFile=(0,_main().getChannelFilename)(this.getDefaultChannelName());const channelFileUrl=(0,_main().newUrlFromBase)(this.getBaseDownloadPath(version,channelFile),this.baseUrl);const requestOptions=this.createRequestOptions(channelFileUrl);let rawData;try{rawData=await this.executor.request(requestOptions,cancellationToken)}catch(e){if(!this.updater.allowPrerelease&&e instanceof _builderUtilRuntime().HttpError&&e.statusCode===404){throw(0,_builderUtilRuntime().newError)(`Cannot find ${channelFile} in the latest release artifacts (${channelFileUrl}): ${e.stack||e.message}`,"ERR_UPDATER_CHANNEL_FILE_NOT_FOUND")}throw e}const result=(0,_Provider().parseUpdateInfo)(rawData,channelFile,channelFileUrl);if(result.releaseName==null){result.releaseName=latestRelease.elementValueOrEmpty("title")}if(result.releaseNotes==null){result.releaseNotes=computeReleaseNotes(this.updater.currentVersion,this.updater.fullChangelog,feed,latestRelease)}return result}async getLatestVersionString(cancellationToken){const options=this.options;const url=options.host==null||options.host==="github.com"?(0,_main().newUrlFromBase)(`${this.basePath}/latest`,this.baseUrl):new(_url().URL)(`${this.computeGithubBasePath(`/repos/${options.owner}/${options.repo}/releases`)}/latest`,this.baseApiUrl);try{const rawData=await this.httpRequest(url,{Accept:"application/json"},cancellationToken);if(rawData==null){return null}const releaseInfo=JSON.parse(rawData);return releaseInfo.tag_name.startsWith("v")?releaseInfo.tag_name.substring(1):releaseInfo.tag_name}catch(e){throw(0,_builderUtilRuntime().newError)(`Unable to find latest version on GitHub (${url}), please ensure a production release exists: ${e.stack||e.message}`,"ERR_UPDATER_LATEST_VERSION_NOT_FOUND")}}get basePath(){return`/${this.options.owner}/${this.options.repo}/releases`}resolveFiles(updateInfo){return(0,_Provider().resolveFiles)(updateInfo,this.baseUrl,(p=>this.getBaseDownloadPath(updateInfo.version,p.replace(/ /g,"-"))))}getBaseDownloadPath(version,fileName){return`${this.basePath}/download/${this.options.vPrefixedTagName===false?"":"v"}${version}/${fileName}`}}exports.GitHubProvider=GitHubProvider;function getNoteValue(parent){const result=parent.elementValueOrEmpty("content");return result==="No content."?"":result}function computeReleaseNotes(currentVersion,isFullChangelog,feed,latestRelease){if(!isFullChangelog){return getNoteValue(latestRelease)}const releaseNotes=[];for(const release of feed.getElements("entry")){const versionRelease=release.element("link").attribute("href").match(/\/tag\/v?([^/]+)$/)[1];if(semver().lt(currentVersion,versionRelease)){releaseNotes.push({version:versionRelease,note:getNoteValue(release)})}}return releaseNotes.sort(((a,b)=>semver().rcompare(a.version,b.version)))}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.PrivateGitHubProvider=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _jsYaml(){const data=__webpack_require__(69);_jsYaml=function(){return data};return data}var path=_interopRequireWildcard(__webpack_require__(40));function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _GitHubProvider(){const data=__webpack_require__(155);_GitHubProvider=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class PrivateGitHubProvider extends _GitHubProvider().BaseGitHubProvider{constructor(options,updater,token,runtimeOptions){super(options,"api.github.com",runtimeOptions);this.updater=updater;this.token=token}createRequestOptions(url,headers){const result=super.createRequestOptions(url,headers);result.redirect="manual";return result}async getLatestVersion(){const cancellationToken=new(_builderUtilRuntime().CancellationToken);const channelFile=(0,_main().getChannelFilename)(this.getDefaultChannelName());const releaseInfo=await this.getLatestVersionInfo(cancellationToken);const asset=releaseInfo.assets.find((it=>it.name===channelFile));if(asset==null){throw(0,_builderUtilRuntime().newError)(`Cannot find ${channelFile} in the release ${releaseInfo.html_url||releaseInfo.name}`,"ERR_UPDATER_CHANNEL_FILE_NOT_FOUND")}const url=new(_url().URL)(asset.url);let result;try{result=(0,_jsYaml().safeLoad)(await this.httpRequest(url,this.configureHeaders("application/octet-stream"),cancellationToken))}catch(e){if(e instanceof _builderUtilRuntime().HttpError&&e.statusCode===404){throw(0,_builderUtilRuntime().newError)(`Cannot find ${channelFile} in the latest release artifacts (${url}): ${e.stack||e.message}`,"ERR_UPDATER_CHANNEL_FILE_NOT_FOUND")}throw e}result.assets=releaseInfo.assets;return result}get fileExtraDownloadHeaders(){return this.configureHeaders("application/octet-stream")}configureHeaders(accept){return{accept,authorization:`token ${this.token}`}}async getLatestVersionInfo(cancellationToken){const allowPrerelease=this.updater.allowPrerelease;let basePath=this.basePath;if(!allowPrerelease){basePath=`${basePath}/latest`}const url=(0,_main().newUrlFromBase)(basePath,this.baseUrl);try{const version=JSON.parse(await this.httpRequest(url,this.configureHeaders("application/vnd.github.v3+json"),cancellationToken));if(allowPrerelease){return version.find((v=>v.prerelease))||version[0]}else{return version}}catch(e){throw(0,_builderUtilRuntime().newError)(`Unable to find latest version on GitHub (${url}), please ensure a production release exists: ${e.stack||e.message}`,"ERR_UPDATER_LATEST_VERSION_NOT_FOUND")}}get basePath(){return this.computeGithubBasePath(`/repos/${this.options.owner}/${this.options.repo}/releases`)}resolveFiles(updateInfo){return(0,_Provider().getFileList)(updateInfo).map((it=>{const name=path.posix.basename(it.url).replace(/ /g,"-");const asset=updateInfo.assets.find((it=>it!=null&&it.name===name));if(asset==null){throw(0,_builderUtilRuntime().newError)(`Cannot find asset "${name}" in: ${JSON.stringify(updateInfo.assets,null,2)}`,"ERR_UPDATER_ASSET_NOT_FOUND")}return{url:new(_url().URL)(asset.url),info:it}}))}}exports.PrivateGitHubProvider=PrivateGitHubProvider},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AppImageUpdater=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _child_process(){const data=__webpack_require__(158);_child_process=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}var _fs=__webpack_require__(20);var path=_interopRequireWildcard(__webpack_require__(40));function _BaseUpdater(){const data=__webpack_require__(159);_BaseUpdater=function(){return data};return data}function _FileWithEmbeddedBlockMapDifferentialDownloader(){const data=__webpack_require__(160);_FileWithEmbeddedBlockMapDifferentialDownloader=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class AppImageUpdater extends _BaseUpdater().BaseUpdater{constructor(options,app){super(options,app)}isUpdaterActive(){if(process.env.APPIMAGE==null){if(process.env.SNAP==null){this._logger.warn("APPIMAGE env is not defined, current application is not an AppImage")}else{this._logger.info("SNAP env is defined, updater is disabled")}return false}return super.isUpdaterActive()}doDownloadUpdate(downloadUpdateOptions){const provider=downloadUpdateOptions.updateInfoAndProvider.provider;const fileInfo=(0,_Provider().findFile)(provider.resolveFiles(downloadUpdateOptions.updateInfoAndProvider.info),"AppImage");return this.executeDownload({fileExtension:"AppImage",fileInfo,downloadUpdateOptions,task:async(updateFile,downloadOptions)=>{const oldFile=process.env.APPIMAGE;if(oldFile==null){throw(0,_builderUtilRuntime().newError)("APPIMAGE env is not defined","ERR_UPDATER_OLD_FILE_NOT_FOUND")}let isDownloadFull=false;try{await new(_FileWithEmbeddedBlockMapDifferentialDownloader().FileWithEmbeddedBlockMapDifferentialDownloader)(fileInfo.info,this.httpExecutor,{newUrl:fileInfo.url,oldFile,logger:this._logger,newFile:updateFile,isUseMultipleRangeRequest:provider.isUseMultipleRangeRequest,requestHeaders:downloadUpdateOptions.requestHeaders}).download()}catch(e){this._logger.error(`Cannot download differentially, fallback to full download: ${e.stack||e}`);isDownloadFull=process.platform==="linux"}if(isDownloadFull){await this.httpExecutor.download(fileInfo.url,updateFile,downloadOptions)}await(0,_fsExtra().chmod)(updateFile,493)}})}doInstall(options){const appImageFile=process.env.APPIMAGE;if(appImageFile==null){throw(0,_builderUtilRuntime().newError)("APPIMAGE env is not defined","ERR_UPDATER_OLD_FILE_NOT_FOUND")}(0,_fs.unlinkSync)(appImageFile);let destination;const existingBaseName=path.basename(appImageFile);if(path.basename(options.installerPath)===existingBaseName||!/\d+\.\d+\.\d+/.test(existingBaseName)){destination=appImageFile}else{destination=path.join(path.dirname(appImageFile),path.basename(options.installerPath))}(0,_child_process().execFileSync)("mv",["-f",options.installerPath,destination]);const env={...process.env,APPIMAGE_SILENT_INSTALL:"true"};if(options.isForceRunAfter){(0,_child_process().spawn)(destination,[],{detached:true,stdio:"ignore",env}).unref()}else{env.APPIMAGE_EXIT_AFTER_INSTALL="true";(0,_child_process().execFileSync)(destination,[],{env})}return true}}exports.AppImageUpdater=AppImageUpdater},module=>{"use strict";module.exports=require("child_process")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.BaseUpdater=void 0;function _AppUpdater(){const data=__webpack_require__(4);_AppUpdater=function(){return data};return data}class BaseUpdater extends _AppUpdater().AppUpdater{constructor(options,app){super(options,app);this.quitAndInstallCalled=false;this.quitHandlerAdded=false}quitAndInstall(isSilent=false,isForceRunAfter=false){this._logger.info(`Install on explicit quitAndInstall`);const isInstalled=this.install(isSilent,isSilent?isForceRunAfter:true);if(isInstalled){setImmediate((()=>{this.app.quit()}))}else{this.quitAndInstallCalled=false}}executeDownload(taskOptions){return super.executeDownload({...taskOptions,done:async event=>{this.dispatchUpdateDownloaded(event);this.addQuitHandler()}})}install(isSilent,isForceRunAfter){if(this.quitAndInstallCalled){this._logger.warn("install call ignored: quitAndInstallCalled is set to true");return false}const downloadedUpdateHelper=this.downloadedUpdateHelper;const installerPath=downloadedUpdateHelper==null?null:downloadedUpdateHelper.file;const downloadedFileInfo=downloadedUpdateHelper==null?null:downloadedUpdateHelper.downloadedFileInfo;if(installerPath==null||downloadedFileInfo==null){this.dispatchError(new Error("No valid update available, can't quit and install"));return false}this.quitAndInstallCalled=true;try{this._logger.info(`Install: isSilent: ${isSilent}, isForceRunAfter: ${isForceRunAfter}`);return this.doInstall({installerPath,isSilent,isForceRunAfter,isAdminRightsRequired:downloadedFileInfo.isAdminRightsRequired})}catch(e){this.dispatchError(e);return false}}addQuitHandler(){if(this.quitHandlerAdded||!this.autoInstallOnAppQuit){return}this.quitHandlerAdded=true;this.app.onQuit((exitCode=>{if(this.quitAndInstallCalled){this._logger.info("Update installer has already been triggered. Quitting application.");return}if(exitCode!==0){this._logger.info(`Update will be not installed on quit because application is quitting with exit code ${exitCode}`);return}this._logger.info("Auto install update on quit");this.install(true,false)}))}}exports.BaseUpdater=BaseUpdater},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.FileWithEmbeddedBlockMapDifferentialDownloader=void 0;function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}function _DifferentialDownloader(){const data=__webpack_require__(161);_DifferentialDownloader=function(){return data};return data}function _zlib(){const data=__webpack_require__(165);_zlib=function(){return data};return data}class FileWithEmbeddedBlockMapDifferentialDownloader extends _DifferentialDownloader().DifferentialDownloader{async download(){const packageInfo=this.blockAwareFileInfo;const fileSize=packageInfo.size;const offset=fileSize-(packageInfo.blockMapSize+4);this.fileMetadataBuffer=await this.readRemoteBytes(offset,fileSize-1);const newBlockMap=readBlockMap(this.fileMetadataBuffer.slice(0,this.fileMetadataBuffer.length-4));await this.doDownload(await readEmbeddedBlockMapData(this.options.oldFile),newBlockMap)}}exports.FileWithEmbeddedBlockMapDifferentialDownloader=FileWithEmbeddedBlockMapDifferentialDownloader;function readBlockMap(data){return JSON.parse((0,_zlib().inflateRawSync)(data).toString())}async function readEmbeddedBlockMapData(file){const fd=await(0,_fsExtra().open)(file,"r");try{const fileSize=(await(0,_fsExtra().fstat)(fd)).size;const sizeBuffer=Buffer.allocUnsafe(4);await(0,_fsExtra().read)(fd,sizeBuffer,0,sizeBuffer.length,fileSize-sizeBuffer.length);const dataBuffer=Buffer.allocUnsafe(sizeBuffer.readUInt32BE(0));await(0,_fsExtra().read)(fd,dataBuffer,0,dataBuffer.length,fileSize-sizeBuffer.length-dataBuffer.length);await(0,_fsExtra().close)(fd);return readBlockMap(dataBuffer)}catch(e){await(0,_fsExtra().close)(fd);throw e}}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DifferentialDownloader=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}var _fs=__webpack_require__(20);function _DataSplitter(){const data=__webpack_require__(162);_DataSplitter=function(){return data};return data}function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _downloadPlanBuilder(){const data=__webpack_require__(163);_downloadPlanBuilder=function(){return data};return data}function _multipleRangeDownloader(){const data=__webpack_require__(164);_multipleRangeDownloader=function(){return data};return data}class DifferentialDownloader{constructor(blockAwareFileInfo,httpExecutor,options){this.blockAwareFileInfo=blockAwareFileInfo;this.httpExecutor=httpExecutor;this.options=options;this.fileMetadataBuffer=null;this.logger=options.logger}createRequestOptions(){const result={headers:{...this.options.requestHeaders,accept:"*/*"}};(0,_builderUtilRuntime().configureRequestUrl)(this.options.newUrl,result);(0,_builderUtilRuntime().configureRequestOptions)(result);return result}doDownload(oldBlockMap,newBlockMap){if(oldBlockMap.version!==newBlockMap.version){throw new Error(`version is different (${oldBlockMap.version} - ${newBlockMap.version}), full download is required`)}const logger=this.logger;const operations=(0,_downloadPlanBuilder().computeOperations)(oldBlockMap,newBlockMap,logger);if(logger.debug!=null){logger.debug(JSON.stringify(operations,null,2))}let downloadSize=0;let copySize=0;for(const operation of operations){const length=operation.end-operation.start;if(operation.kind===_downloadPlanBuilder().OperationKind.DOWNLOAD){downloadSize+=length}else{copySize+=length}}const newSize=this.blockAwareFileInfo.size;if(downloadSize+copySize+(this.fileMetadataBuffer==null?0:this.fileMetadataBuffer.length)!==newSize){throw new Error(`Internal error, size mismatch: downloadSize: ${downloadSize}, copySize: ${copySize}, newSize: ${newSize}`)}logger.info(`Full: ${formatBytes(newSize)}, To download: ${formatBytes(downloadSize)} (${Math.round(downloadSize/(newSize/100))}%)`);return this.downloadFile(operations)}downloadFile(tasks){const fdList=[];const closeFiles=()=>Promise.all(fdList.map((openedFile=>(0,_fsExtra().close)(openedFile.descriptor).catch((e=>{this.logger.error(`cannot close file "${openedFile.path}": ${e}`)})))));return this.doDownloadFile(tasks,fdList).then(closeFiles).catch((e=>closeFiles().catch((closeFilesError=>{try{this.logger.error(`cannot close files: ${closeFilesError}`)}catch(errorOnLog){try{console.error(errorOnLog)}catch(ignored){}}throw e})).then((()=>{throw e}))))}async doDownloadFile(tasks,fdList){const oldFileFd=await(0,_fsExtra().open)(this.options.oldFile,"r");fdList.push({descriptor:oldFileFd,path:this.options.oldFile});const newFileFd=await(0,_fsExtra().open)(this.options.newFile,"w");fdList.push({descriptor:newFileFd,path:this.options.newFile});const fileOut=(0,_fs.createWriteStream)(this.options.newFile,{fd:newFileFd});await new Promise(((resolve,reject)=>{const streams=[];const digestTransform=new(_builderUtilRuntime().DigestTransform)(this.blockAwareFileInfo.sha512);digestTransform.isValidateOnEnd=false;streams.push(digestTransform);fileOut.on("finish",(()=>{fileOut.close((()=>{fdList.splice(1,1);try{digestTransform.validate()}catch(e){reject(e);return}resolve()}))}));streams.push(fileOut);let lastStream=null;for(const stream of streams){stream.on("error",reject);if(lastStream==null){lastStream=stream}else{lastStream=lastStream.pipe(stream)}}const firstStream=streams[0];let w;if(this.options.isUseMultipleRangeRequest){w=(0,_multipleRangeDownloader().executeTasksUsingMultipleRangeRequests)(this,tasks,firstStream,oldFileFd,reject);w(0);return}let downloadOperationCount=0;let actualUrl=null;this.logger.info(`Differential download: ${this.options.newUrl}`);const requestOptions=this.createRequestOptions();requestOptions.redirect="manual";w=index=>{if(index>=tasks.length){if(this.fileMetadataBuffer!=null){firstStream.write(this.fileMetadataBuffer)}firstStream.end();return}const operation=tasks[index++];if(operation.kind===_downloadPlanBuilder().OperationKind.COPY){(0,_DataSplitter().copyData)(operation,firstStream,oldFileFd,reject,(()=>w(index)));return}const range=`bytes=${operation.start}-${operation.end-1}`;requestOptions.headers.range=range;const debug=this.logger.debug;if(debug!=null){debug(`download range: ${range}`)}const request=this.httpExecutor.createRequest(requestOptions,(response=>{if(response.statusCode>=400){reject((0,_builderUtilRuntime().createHttpError)(response))}response.pipe(firstStream,{end:false});response.once("end",(()=>{if(++downloadOperationCount===100){downloadOperationCount=0;setTimeout((()=>w(index)),1e3)}else{w(index)}}))}));request.on("redirect",((statusCode,method,redirectUrl)=>{this.logger.info(`Redirect to ${removeQuery(redirectUrl)}`);actualUrl=redirectUrl;(0,_builderUtilRuntime().configureRequestUrl)(new(_url().URL)(actualUrl),requestOptions);request.followRedirect()}));this.httpExecutor.addErrorAndTimeoutHandlers(request,reject);request.end()};w(0)}))}async readRemoteBytes(start,endInclusive){const buffer=Buffer.allocUnsafe(endInclusive+1-start);const requestOptions=this.createRequestOptions();requestOptions.headers.range=`bytes=${start}-${endInclusive}`;let position=0;await this.request(requestOptions,(chunk=>{chunk.copy(buffer,position);position+=chunk.length}));if(position!==buffer.length){throw new Error(`Received data length ${position} is not equal to expected ${buffer.length}`)}return buffer}request(requestOptions,dataHandler){return new Promise(((resolve,reject)=>{const request=this.httpExecutor.createRequest(requestOptions,(response=>{if(!(0,_multipleRangeDownloader().checkIsRangesSupported)(response,reject)){return}response.on("data",dataHandler);response.on("end",(()=>resolve()))}));this.httpExecutor.addErrorAndTimeoutHandlers(request,reject);request.end()}))}}exports.DifferentialDownloader=DifferentialDownloader;function formatBytes(value,symbol=" KB"){return new Intl.NumberFormat("en").format((value/1024).toFixed(2))+symbol}function removeQuery(url){const index=url.indexOf("?");return index<0?url:url.substring(0,index)}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.copyData=copyData;exports.DataSplitter=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}var _fs=__webpack_require__(20);function _stream(){const data=__webpack_require__(21);_stream=function(){return data};return data}function _downloadPlanBuilder(){const data=__webpack_require__(163);_downloadPlanBuilder=function(){return data};return data}const DOUBLE_CRLF=Buffer.from("\r\n\r\n");var ReadState;(function(ReadState){ReadState[ReadState["INIT"]=0]="INIT";ReadState[ReadState["HEADER"]=1]="HEADER";ReadState[ReadState["BODY"]=2]="BODY"})(ReadState||(ReadState={}));function copyData(task,out,oldFileFd,reject,resolve){const readStream=(0,_fs.createReadStream)("",{fd:oldFileFd,autoClose:false,start:task.start,end:task.end-1});readStream.on("error",reject);readStream.once("end",resolve);readStream.pipe(out,{end:false})}class DataSplitter extends _stream().Writable{constructor(out,options,partIndexToTaskIndex,boundary,partIndexToLength,finishHandler){super();this.out=out;this.options=options;this.partIndexToTaskIndex=partIndexToTaskIndex;this.partIndexToLength=partIndexToLength;this.finishHandler=finishHandler;this.partIndex=-1;this.headerListBuffer=null;this.readState=ReadState.INIT;this.ignoreByteCount=0;this.remainingPartDataCount=0;this.actualPartLength=0;this.boundaryLength=boundary.length+4;this.ignoreByteCount=this.boundaryLength-2}get isFinished(){return this.partIndex===this.partIndexToLength.length}_write(data,encoding,callback){if(this.isFinished){console.error(`Trailing ignored data: ${data.length} bytes`);return}this.handleData(data).then(callback).catch(callback)}async handleData(chunk){let start=0;if(this.ignoreByteCount!==0&&this.remainingPartDataCount!==0){throw(0,_builderUtilRuntime().newError)("Internal error","ERR_DATA_SPLITTER_BYTE_COUNT_MISMATCH")}if(this.ignoreByteCount>0){const toIgnore=Math.min(this.ignoreByteCount,chunk.length);this.ignoreByteCount-=toIgnore;start=toIgnore}else if(this.remainingPartDataCount>0){const toRead=Math.min(this.remainingPartDataCount,chunk.length);this.remainingPartDataCount-=toRead;await this.processPartData(chunk,0,toRead);start=toRead}if(start===chunk.length){return}if(this.readState===ReadState.HEADER){const headerListEnd=this.searchHeaderListEnd(chunk,start);if(headerListEnd===-1){return}start=headerListEnd;this.readState=ReadState.BODY;this.headerListBuffer=null}while(true){if(this.readState===ReadState.BODY){this.readState=ReadState.INIT}else{this.partIndex++;let taskIndex=this.partIndexToTaskIndex.get(this.partIndex);if(taskIndex==null){if(this.isFinished){taskIndex=this.options.end}else{throw(0,_builderUtilRuntime().newError)("taskIndex is null","ERR_DATA_SPLITTER_TASK_INDEX_IS_NULL")}}const prevTaskIndex=this.partIndex===0?this.options.start:this.partIndexToTaskIndex.get(this.partIndex-1)+1;if(prevTaskIndex<taskIndex){await this.copyExistingData(prevTaskIndex,taskIndex)}else if(prevTaskIndex>taskIndex){throw(0,_builderUtilRuntime().newError)("prevTaskIndex must be < taskIndex","ERR_DATA_SPLITTER_TASK_INDEX_ASSERT_FAILED")}if(this.isFinished){this.onPartEnd();this.finishHandler();return}start=this.searchHeaderListEnd(chunk,start);if(start===-1){this.readState=ReadState.HEADER;return}}const partLength=this.partIndexToLength[this.partIndex];const end=start+partLength;const effectiveEnd=Math.min(end,chunk.length);await this.processPartStarted(chunk,start,effectiveEnd);this.remainingPartDataCount=partLength-(effectiveEnd-start);if(this.remainingPartDataCount>0){return}start=end+this.boundaryLength;if(start>=chunk.length){this.ignoreByteCount=this.boundaryLength-(chunk.length-end);return}}}copyExistingData(index,end){return new Promise(((resolve,reject)=>{const w=()=>{if(index===end){resolve();return}const task=this.options.tasks[index];if(task.kind!==_downloadPlanBuilder().OperationKind.COPY){reject(new Error("Task kind must be COPY"));return}copyData(task,this.out,this.options.oldFileFd,reject,(()=>{index++;w()}))};w()}))}searchHeaderListEnd(chunk,readOffset){const headerListEnd=chunk.indexOf(DOUBLE_CRLF,readOffset);if(headerListEnd!==-1){return headerListEnd+DOUBLE_CRLF.length}const partialChunk=readOffset===0?chunk:chunk.slice(readOffset);if(this.headerListBuffer==null){this.headerListBuffer=partialChunk}else{this.headerListBuffer=Buffer.concat([this.headerListBuffer,partialChunk])}return-1}onPartEnd(){const expectedLength=this.partIndexToLength[this.partIndex-1];if(this.actualPartLength!==expectedLength){throw(0,_builderUtilRuntime().newError)(`Expected length: ${expectedLength} differs from actual: ${this.actualPartLength}`,"ERR_DATA_SPLITTER_LENGTH_MISMATCH")}this.actualPartLength=0}processPartStarted(data,start,end){if(this.partIndex!==0){this.onPartEnd()}return this.processPartData(data,start,end)}processPartData(data,start,end){this.actualPartLength+=end-start;const out=this.out;if(out.write(start===0&&data.length===end?data:data.slice(start,end))){return Promise.resolve()}else{return new Promise(((resolve,reject)=>{out.on("error",reject);out.once("drain",(()=>{out.removeListener("error",reject);resolve()}))}))}}}exports.DataSplitter=DataSplitter},(__unused_webpack_module,exports)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.computeOperations=computeOperations;exports.OperationKind=void 0;var OperationKind;exports.OperationKind=OperationKind;(function(OperationKind){OperationKind[OperationKind["COPY"]=0]="COPY";OperationKind[OperationKind["DOWNLOAD"]=1]="DOWNLOAD"})(OperationKind||(exports.OperationKind=OperationKind={}));function computeOperations(oldBlockMap,newBlockMap,logger){const nameToOldBlocks=buildBlockFileMap(oldBlockMap.files);const nameToNewBlocks=buildBlockFileMap(newBlockMap.files);let lastOperation=null;const blockMapFile=newBlockMap.files[0];const operations=[];const name=blockMapFile.name;const oldEntry=nameToOldBlocks.get(name);if(oldEntry==null){throw new Error(`no file ${name} in old blockmap`)}const newFile=nameToNewBlocks.get(name);let changedBlockCount=0;const{checksumToOffset:checksumToOldOffset,checksumToOldSize}=buildChecksumMap(nameToOldBlocks.get(name),oldEntry.offset,logger);let newOffset=blockMapFile.offset;for(let i=0;i<newFile.checksums.length;newOffset+=newFile.sizes[i],i++){const blockSize=newFile.sizes[i];const checksum=newFile.checksums[i];let oldOffset=checksumToOldOffset.get(checksum);if(oldOffset!=null&&checksumToOldSize.get(checksum)!==blockSize){logger.warn(`Checksum ("${checksum}") matches, but size differs (old: ${checksumToOldSize.get(checksum)}, new: ${blockSize})`);oldOffset=undefined}if(oldOffset===undefined){changedBlockCount++;if(lastOperation!=null&&lastOperation.kind===OperationKind.DOWNLOAD&&lastOperation.end===newOffset){lastOperation.end+=blockSize}else{lastOperation={kind:OperationKind.DOWNLOAD,start:newOffset,end:newOffset+blockSize};validateAndAdd(lastOperation,operations,checksum,i)}}else{if(lastOperation!=null&&lastOperation.kind===OperationKind.COPY&&lastOperation.end===oldOffset){lastOperation.end+=blockSize}else{lastOperation={kind:OperationKind.COPY,start:oldOffset,end:oldOffset+blockSize};validateAndAdd(lastOperation,operations,checksum,i)}}}if(changedBlockCount>0){logger.info(`File${blockMapFile.name==="file"?"":" "+blockMapFile.name} has ${changedBlockCount} changed blocks`)}return operations}const isValidateOperationRange=process.env.DIFFERENTIAL_DOWNLOAD_PLAN_BUILDER_VALIDATE_RANGES==="true";function validateAndAdd(operation,operations,checksum,index){if(isValidateOperationRange&&operations.length!==0){const lastOperation=operations[operations.length-1];if(lastOperation.kind===operation.kind&&operation.start<lastOperation.end&&operation.start>lastOperation.start){const min=[lastOperation.start,lastOperation.end,operation.start,operation.end].reduce(((p,v)=>p<v?p:v));throw new Error(`operation (block index: ${index}, checksum: ${checksum}, kind: ${OperationKind[operation.kind]}) overlaps previous operation (checksum: ${checksum}):\n`+`abs: ${lastOperation.start} until ${lastOperation.end} and ${operation.start} until ${operation.end}\n`+`rel: ${lastOperation.start-min} until ${lastOperation.end-min} and ${operation.start-min} until ${operation.end-min}`)}}operations.push(operation)}function buildChecksumMap(file,fileOffset,logger){const checksumToOffset=new Map;const checksumToSize=new Map;let offset=fileOffset;const debugLog=logger.debug;for(let i=0;i<file.checksums.length;i++){const checksum=file.checksums[i];const size=file.sizes[i];const existing=checksumToSize.get(checksum);if(existing===undefined){checksumToOffset.set(checksum,offset);checksumToSize.set(checksum,size)}else if(debugLog!=null){const sizeExplanation=existing===size?"(same size)":`(size: ${existing}, this size: ${size})`;debugLog(`${checksum} duplicated in blockmap ${sizeExplanation}, it doesn't lead to broken differential downloader, just corresponding block will be skipped)`)}offset+=size}return{checksumToOffset,checksumToOldSize:checksumToSize}}function buildBlockFileMap(list){const result=new Map;for(const item of list){result.set(item.name,item)}return result}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.executeTasksUsingMultipleRangeRequests=executeTasksUsingMultipleRangeRequests;exports.checkIsRangesSupported=checkIsRangesSupported;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _DataSplitter(){const data=__webpack_require__(162);_DataSplitter=function(){return data};return data}function _downloadPlanBuilder(){const data=__webpack_require__(163);_downloadPlanBuilder=function(){return data};return data}function executeTasksUsingMultipleRangeRequests(differentialDownloader,tasks,out,oldFileFd,reject){const w=taskOffset=>{if(taskOffset>=tasks.length){if(differentialDownloader.fileMetadataBuffer!=null){out.write(differentialDownloader.fileMetadataBuffer)}out.end();return}const nextOffset=taskOffset+1e3;doExecuteTasks(differentialDownloader,{tasks,start:taskOffset,end:Math.min(tasks.length,nextOffset),oldFileFd},out,(()=>w(nextOffset)),reject)};return w}function doExecuteTasks(differentialDownloader,options,out,resolve,reject){let ranges="bytes=";let partCount=0;const partIndexToTaskIndex=new Map;const partIndexToLength=[];for(let i=options.start;i<options.end;i++){const task=options.tasks[i];if(task.kind===_downloadPlanBuilder().OperationKind.DOWNLOAD){ranges+=`${task.start}-${task.end-1}, `;partIndexToTaskIndex.set(partCount,i);partCount++;partIndexToLength.push(task.end-task.start)}}if(partCount<=1){const w=index=>{if(index>=options.end){resolve();return}const task=options.tasks[index++];if(task.kind===_downloadPlanBuilder().OperationKind.COPY){(0,_DataSplitter().copyData)(task,out,options.oldFileFd,reject,(()=>w(index)))}else{const requestOptions=differentialDownloader.createRequestOptions();requestOptions.headers.Range=`bytes=${task.start}-${task.end-1}`;const request=differentialDownloader.httpExecutor.createRequest(requestOptions,(response=>{if(!checkIsRangesSupported(response,reject)){return}response.pipe(out,{end:false});response.once("end",(()=>w(index)))}));differentialDownloader.httpExecutor.addErrorAndTimeoutHandlers(request,reject);request.end()}};w(options.start);return}const requestOptions=differentialDownloader.createRequestOptions();requestOptions.headers.Range=ranges.substring(0,ranges.length-2);const request=differentialDownloader.httpExecutor.createRequest(requestOptions,(response=>{if(!checkIsRangesSupported(response,reject)){return}const contentType=(0,_builderUtilRuntime().safeGetHeader)(response,"content-type");const m=/^multipart\/.+?(?:; boundary=(?:(?:"(.+)")|(?:([^\s]+))))$/i.exec(contentType);if(m==null){reject(new Error(`Content-Type "multipart/byteranges" is expected, but got "${contentType}"`));return}const dicer=new(_DataSplitter().DataSplitter)(out,options,partIndexToTaskIndex,m[1]||m[2],partIndexToLength,resolve);dicer.on("error",reject);response.pipe(dicer);response.on("end",(()=>{setTimeout((()=>{request.abort();reject(new Error("Response ends without calling any handlers"))}),1e4)}))}));differentialDownloader.httpExecutor.addErrorAndTimeoutHandlers(request,reject);request.end()}function checkIsRangesSupported(response,reject){if(response.statusCode>=400){reject((0,_builderUtilRuntime().createHttpError)(response));return false}if(response.statusCode!==206){const acceptRanges=(0,_builderUtilRuntime().safeGetHeader)(response,"accept-ranges");if(acceptRanges==null||acceptRanges==="none"){reject(new Error(`Server doesn't support Accept-Ranges (response code ${response.statusCode})`));return false}}return true}},module=>{"use strict";module.exports=require("zlib")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.MacUpdater=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}var _fs=__webpack_require__(20);function _http(){const data=__webpack_require__(167);_http=function(){return data};return data}function _AppUpdater(){const data=__webpack_require__(4);_AppUpdater=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}class MacUpdater extends _AppUpdater().AppUpdater{constructor(options,app){super(options,app);this.nativeUpdater=__webpack_require__(1).autoUpdater;this.updateInfoForPendingUpdateDownloadedEvent=null;this.nativeUpdater.on("error",(it=>{this._logger.warn(it);this.emit("error",it)}));this.nativeUpdater.on("update-downloaded",(()=>{const updateInfo=this.updateInfoForPendingUpdateDownloadedEvent;this.updateInfoForPendingUpdateDownloadedEvent=null;this.dispatchUpdateDownloaded(updateInfo)}))}doDownloadUpdate(downloadUpdateOptions){this.updateInfoForPendingUpdateDownloadedEvent=null;const files=downloadUpdateOptions.updateInfoAndProvider.provider.resolveFiles(downloadUpdateOptions.updateInfoAndProvider.info);const zipFileInfo=(0,_Provider().findFile)(files,"zip",["pkg","dmg"]);if(zipFileInfo==null){throw(0,_builderUtilRuntime().newError)(`ZIP file not provided: ${(0,_builderUtilRuntime().safeStringifyJson)(files)}`,"ERR_UPDATER_ZIP_FILE_NOT_FOUND")}const server=(0,_http().createServer)();server.on("close",(()=>{this._logger.info(`Proxy server for native Squirrel.Mac is closed (was started to download ${zipFileInfo.url.href})`)}));function getServerUrl(){const address=server.address();return`http://127.0.0.1:${address.port}`}return this.executeDownload({fileExtension:"zip",fileInfo:zipFileInfo,downloadUpdateOptions,task:(destinationFile,downloadOptions)=>this.httpExecutor.download(zipFileInfo.url,destinationFile,downloadOptions),done:async event=>{const downloadedFile=event.downloadedFile;this.updateInfoForPendingUpdateDownloadedEvent=event;let updateFileSize=zipFileInfo.info.size;if(updateFileSize==null){updateFileSize=(await(0,_fsExtra().stat)(downloadedFile)).size}return await new Promise(((resolve,reject)=>{const fileUrl="/"+Date.now()+"-"+Math.floor(Math.random()*9999)+".zip";server.on("request",((request,response)=>{const requestUrl=request.url;this._logger.info(`${requestUrl} requested`);if(requestUrl==="/"){const data=Buffer.from(`{ "url": "${getServerUrl()}${fileUrl}" }`);response.writeHead(200,{"Content-Type":"application/json","Content-Length":data.length});response.end(data);return}if(!requestUrl.startsWith(fileUrl)){this._logger.warn(`${requestUrl} requested, but not supported`);response.writeHead(404);response.end();return}this._logger.info(`${fileUrl} requested by Squirrel.Mac, pipe ${downloadedFile}`);let errorOccurred=false;response.on("finish",(()=>{try{setImmediate((()=>server.close()))}finally{if(!errorOccurred){this.nativeUpdater.removeListener("error",reject);resolve([])}}}));const readStream=(0,_fs.createReadStream)(downloadedFile);readStream.on("error",(error=>{try{response.end()}catch(e){this._logger.warn(`cannot end response: ${e}`)}errorOccurred=true;this.nativeUpdater.removeListener("error",reject);reject(new Error(`Cannot pipe "${downloadedFile}": ${error}`))}));response.writeHead(200,{"Content-Type":"application/zip","Content-Length":updateFileSize});readStream.pipe(response)}));server.listen(0,"127.0.0.1",(()=>{this.nativeUpdater.setFeedURL({url:getServerUrl(),headers:{"Cache-Control":"no-cache"}});this.nativeUpdater.once("error",reject);this.nativeUpdater.checkForUpdates()}))}))}})}quitAndInstall(){this.nativeUpdater.quitAndInstall()}}exports.MacUpdater=MacUpdater},module=>{"use strict";module.exports=require("http")},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NsisUpdater=void 0;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _child_process(){const data=__webpack_require__(158);_child_process=function(){return data};return data}var path=_interopRequireWildcard(__webpack_require__(40));function _BaseUpdater(){const data=__webpack_require__(159);_BaseUpdater=function(){return data};return data}function _FileWithEmbeddedBlockMapDifferentialDownloader(){const data=__webpack_require__(160);_FileWithEmbeddedBlockMapDifferentialDownloader=function(){return data};return data}function _GenericDifferentialDownloader(){const data=__webpack_require__(169);_GenericDifferentialDownloader=function(){return data};return data}function _main(){const data=__webpack_require__(2);_main=function(){return data};return data}function _Provider(){const data=__webpack_require__(151);_Provider=function(){return data};return data}function _fsExtra(){const data=__webpack_require__(29);_fsExtra=function(){return data};return data}function _windowsExecutableCodeSignatureVerifier(){const data=__webpack_require__(170);_windowsExecutableCodeSignatureVerifier=function(){return data};return data}function _url(){const data=__webpack_require__(3);_url=function(){return data};return data}function _zlib(){const data=__webpack_require__(165);_zlib=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}class NsisUpdater extends _BaseUpdater().BaseUpdater{constructor(options,app){super(options,app)}doDownloadUpdate(downloadUpdateOptions){const provider=downloadUpdateOptions.updateInfoAndProvider.provider;const fileInfo=(0,_Provider().findFile)(provider.resolveFiles(downloadUpdateOptions.updateInfoAndProvider.info),"exe");return this.executeDownload({fileExtension:"exe",downloadUpdateOptions,fileInfo,task:async(destinationFile,downloadOptions,packageFile,removeTempDirIfAny)=>{const packageInfo=fileInfo.packageInfo;const isWebInstaller=packageInfo!=null&&packageFile!=null;if(isWebInstaller||await this.differentialDownloadInstaller(fileInfo,downloadUpdateOptions,destinationFile,provider)){await this.httpExecutor.download(fileInfo.url,destinationFile,downloadOptions)}const signatureVerificationStatus=await this.verifySignature(destinationFile);if(signatureVerificationStatus!=null){await removeTempDirIfAny();throw(0,_builderUtilRuntime().newError)(`New version ${downloadUpdateOptions.updateInfoAndProvider.info.version} is not signed by the application owner: ${signatureVerificationStatus}`,"ERR_UPDATER_INVALID_SIGNATURE")}if(isWebInstaller){if(await this.differentialDownloadWebPackage(packageInfo,packageFile,provider)){try{await this.httpExecutor.download(new(_url().URL)(packageInfo.path),packageFile,{headers:downloadUpdateOptions.requestHeaders,cancellationToken:downloadUpdateOptions.cancellationToken,sha512:packageInfo.sha512})}catch(e){try{await(0,_fsExtra().unlink)(packageFile)}catch(ignored){}throw e}}}}})}async verifySignature(tempUpdateFile){let publisherName;try{publisherName=(await this.configOnDisk.value).publisherName;if(publisherName==null){return null}}catch(e){if(e.code==="ENOENT"){return null}throw e}return await(0,_windowsExecutableCodeSignatureVerifier().verifySignature)(Array.isArray(publisherName)?publisherName:[publisherName],tempUpdateFile,this._logger)}doInstall(options){const args=["--updated"];if(options.isSilent){args.push("/S")}if(options.isForceRunAfter){args.push("--force-run")}const packagePath=this.downloadedUpdateHelper==null?null:this.downloadedUpdateHelper.packageFile;if(packagePath!=null){args.push(`--package-file=${packagePath}`)}const callUsingElevation=()=>{_spawn(path.join(process.resourcesPath,"elevate.exe"),[options.installerPath].concat(args)).catch((e=>this.dispatchError(e)))};if(options.isAdminRightsRequired){this._logger.info("isAdminRightsRequired is set to true, run installer using elevate.exe");callUsingElevation();return true}_spawn(options.installerPath,args).catch((e=>{const errorCode=e.code;this._logger.info(`Cannot run installer: error code: ${errorCode}, error message: "${e.message}", will be executed again using elevate if EACCES"`);if(errorCode==="UNKNOWN"||errorCode==="EACCES"){callUsingElevation()}else{this.dispatchError(e)}}));return true}async differentialDownloadInstaller(fileInfo,downloadUpdateOptions,installerPath,provider){try{if(this._testOnlyOptions!=null&&!this._testOnlyOptions.isUseDifferentialDownload){return true}const newBlockMapUrl=(0,_main().newUrlFromBase)(`${fileInfo.url.pathname}.blockmap`,fileInfo.url);const oldBlockMapUrl=(0,_main().newUrlFromBase)(`${fileInfo.url.pathname.replace(new RegExp(downloadUpdateOptions.updateInfoAndProvider.info.version,"g"),this.app.version)}.blockmap`,fileInfo.url);this._logger.info(`Download block maps (old: "${oldBlockMapUrl.href}", new: ${newBlockMapUrl.href})`);const downloadBlockMap=async url=>{const data=await this.httpExecutor.downloadToBuffer(url,{headers:downloadUpdateOptions.requestHeaders,cancellationToken:downloadUpdateOptions.cancellationToken});if(data==null||data.length===0){throw new Error(`Blockmap "${url.href}" is empty`)}try{return JSON.parse((0,_zlib().gunzipSync)(data).toString())}catch(e){throw new Error(`Cannot parse blockmap "${url.href}", error: ${e}, raw data: ${data}`)}};const blockMapDataList=await Promise.all([downloadBlockMap(oldBlockMapUrl),downloadBlockMap(newBlockMapUrl)]);await new(_GenericDifferentialDownloader().GenericDifferentialDownloader)(fileInfo.info,this.httpExecutor,{newUrl:fileInfo.url,oldFile:path.join(this.downloadedUpdateHelper.cacheDir,_builderUtilRuntime().CURRENT_APP_INSTALLER_FILE_NAME),logger:this._logger,newFile:installerPath,isUseMultipleRangeRequest:provider.isUseMultipleRangeRequest,requestHeaders:downloadUpdateOptions.requestHeaders}).download(blockMapDataList[0],blockMapDataList[1]);return false}catch(e){this._logger.error(`Cannot download differentially, fallback to full download: ${e.stack||e}`);if(this._testOnlyOptions!=null){throw e}return true}}async differentialDownloadWebPackage(packageInfo,packagePath,provider){if(packageInfo.blockMapSize==null){return true}try{await new(_FileWithEmbeddedBlockMapDifferentialDownloader().FileWithEmbeddedBlockMapDifferentialDownloader)(packageInfo,this.httpExecutor,{newUrl:new(_url().URL)(packageInfo.path),oldFile:path.join(this.downloadedUpdateHelper.cacheDir,_builderUtilRuntime().CURRENT_APP_PACKAGE_FILE_NAME),logger:this._logger,newFile:packagePath,requestHeaders:this.requestHeaders,isUseMultipleRangeRequest:provider.isUseMultipleRangeRequest}).download()}catch(e){this._logger.error(`Cannot download differentially, fallback to full download: ${e.stack||e}`);return process.platform==="win32"}return false}}exports.NsisUpdater=NsisUpdater;async function _spawn(exe,args){return new Promise(((resolve,reject)=>{try{const process=(0,_child_process().spawn)(exe,args,{detached:true,stdio:"ignore"});process.on("error",(error=>{reject(error)}));process.unref();if(process.pid!==undefined){resolve(true)}}catch(error){reject(error)}}))}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.GenericDifferentialDownloader=void 0;function _DifferentialDownloader(){const data=__webpack_require__(161);_DifferentialDownloader=function(){return data};return data}class GenericDifferentialDownloader extends _DifferentialDownloader().DifferentialDownloader{download(oldBlockMap,newBlockMap){return this.doDownload(oldBlockMap,newBlockMap)}}exports.GenericDifferentialDownloader=GenericDifferentialDownloader},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.verifySignature=verifySignature;function _builderUtilRuntime(){const data=__webpack_require__(5);_builderUtilRuntime=function(){return data};return data}function _child_process(){const data=__webpack_require__(158);_child_process=function(){return data};return data}function os(){const data=_interopRequireWildcard(__webpack_require__(18));os=function(){return data};return data}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj.default=obj;if(cache){cache.set(obj,newObj)}return newObj}function verifySignature(publisherNames,unescapedTempUpdateFile,logger){return new Promise((resolve=>{const tempUpdateFile=unescapedTempUpdateFile.replace(/'/g,"''").replace(/`/g,"``");(0,_child_process().execFile)("powershell.exe",["-NoProfile","-NonInteractive","-InputFormat","None","-Command",`Get-AuthenticodeSignature '${tempUpdateFile}' | ConvertTo-Json -Compress | ForEach-Object { [Convert]::ToBase64String([System.Text.Encoding]::UTF8.GetBytes($_)) }`],{timeout:20*1e3},((error,stdout,stderr)=>{try{if(error!=null||stderr){handleError(logger,error,stderr);resolve(null);return}const data=parseOut(Buffer.from(stdout,"base64").toString("utf-8"));if(data.Status===0){const name=(0,_builderUtilRuntime().parseDn)(data.SignerCertificate.Subject).get("CN");if(publisherNames.includes(name)){resolve(null);return}}const result=`publisherNames: ${publisherNames.join(" | ")}, raw info: `+JSON.stringify(data,((name,value)=>name==="RawData"?undefined:value),2);logger.warn(`Sign verification failed, installer signed with incorrect certificate: ${result}`);resolve(result)}catch(e){logger.warn(`Cannot execute Get-AuthenticodeSignature: ${error}. Ignoring signature validation due to unknown error.`);resolve(null);return}}))}))}function parseOut(out){const data=JSON.parse(out);delete data.PrivateKey;delete data.IsOSBinary;delete data.SignatureType;const signerCertificate=data.SignerCertificate;if(signerCertificate!=null){delete signerCertificate.Archived;delete signerCertificate.Extensions;delete signerCertificate.Handle;delete signerCertificate.HasPrivateKey;delete signerCertificate.SubjectName}delete data.Path;return data}function handleError(logger,error,stderr){if(isOldWin6()){logger.warn(`Cannot execute Get-AuthenticodeSignature: ${error||stderr}. Ignoring signature validation due to unsupported powershell version. Please upgrade to powershell 3 or higher.`);return}try{(0,_child_process().execFileSync)("powershell.exe",["-NoProfile","-NonInteractive","-Command","ConvertTo-Json test"],{timeout:10*1e3})}catch(testError){logger.warn(`Cannot execute ConvertTo-Json: ${testError.message}. Ignoring signature validation due to unsupported powershell version. Please upgrade to powershell 3 or higher.`);return}if(error!=null){throw error}if(stderr){logger.warn(`Cannot execute Get-AuthenticodeSignature, stderr: ${stderr}. Ignoring signature validation due to unknown stderr.`);return}}function isOldWin6(){const winVersion=os().release();return winVersion.startsWith("6.")&&!winVersion.startsWith("6.3")}},module=>{"use strict";module.exports=require("../package.json")},(module,__unused_webpack_exports,__webpack_require__)=>{module.exports=__webpack_require__(173)},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var bind=__webpack_require__(175);var Axios=__webpack_require__(176);var mergeConfig=__webpack_require__(194);var defaults=__webpack_require__(181);function createInstance(defaultConfig){var context=new Axios(defaultConfig);var instance=bind(Axios.prototype.request,context);utils.extend(instance,Axios.prototype,context);utils.extend(instance,context);return instance}var axios=createInstance(defaults);axios.Axios=Axios;axios.create=function create(instanceConfig){return createInstance(mergeConfig(axios.defaults,instanceConfig))};axios.Cancel=__webpack_require__(196);axios.CancelToken=__webpack_require__(197);axios.isCancel=__webpack_require__(193);axios.all=function all(promises){return Promise.all(promises)};axios.spread=__webpack_require__(198);axios.isAxiosError=__webpack_require__(199);module.exports=axios;module.exports.default=axios},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var bind=__webpack_require__(175);var toString=Object.prototype.toString;function isArray(val){return toString.call(val)==="[object Array]"}function isUndefined(val){return typeof val==="undefined"}function isBuffer(val){return val!==null&&!isUndefined(val)&&val.constructor!==null&&!isUndefined(val.constructor)&&typeof val.constructor.isBuffer==="function"&&val.constructor.isBuffer(val)}function isArrayBuffer(val){return toString.call(val)==="[object ArrayBuffer]"}function isFormData(val){return typeof FormData!=="undefined"&&val instanceof FormData}function isArrayBufferView(val){var result;if(typeof ArrayBuffer!=="undefined"&&ArrayBuffer.isView){result=ArrayBuffer.isView(val)}else{result=val&&val.buffer&&val.buffer instanceof ArrayBuffer}return result}function isString(val){return typeof val==="string"}function isNumber(val){return typeof val==="number"}function isObject(val){return val!==null&&typeof val==="object"}function isPlainObject(val){if(toString.call(val)!=="[object Object]"){return false}var prototype=Object.getPrototypeOf(val);return prototype===null||prototype===Object.prototype}function isDate(val){return toString.call(val)==="[object Date]"}function isFile(val){return toString.call(val)==="[object File]"}function isBlob(val){return toString.call(val)==="[object Blob]"}function isFunction(val){return toString.call(val)==="[object Function]"}function isStream(val){return isObject(val)&&isFunction(val.pipe)}function isURLSearchParams(val){return typeof URLSearchParams!=="undefined"&&val instanceof URLSearchParams}function trim(str){return str.trim?str.trim():str.replace(/^\s+|\s+$/g,"")}function isStandardBrowserEnv(){if(typeof navigator!=="undefined"&&(navigator.product==="ReactNative"||navigator.product==="NativeScript"||navigator.product==="NS")){return false}return typeof window!=="undefined"&&typeof document!=="undefined"}function forEach(obj,fn){if(obj===null||typeof obj==="undefined"){return}if(typeof obj!=="object"){obj=[obj]}if(isArray(obj)){for(var i=0,l=obj.length;i<l;i++){fn.call(null,obj[i],i,obj)}}else{for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){fn.call(null,obj[key],key,obj)}}}}function merge(){var result={};function assignValue(val,key){if(isPlainObject(result[key])&&isPlainObject(val)){result[key]=merge(result[key],val)}else if(isPlainObject(val)){result[key]=merge({},val)}else if(isArray(val)){result[key]=val.slice()}else{result[key]=val}}for(var i=0,l=arguments.length;i<l;i++){forEach(arguments[i],assignValue)}return result}function extend(a,b,thisArg){forEach(b,(function assignValue(val,key){if(thisArg&&typeof val==="function"){a[key]=bind(val,thisArg)}else{a[key]=val}}));return a}function stripBOM(content){if(content.charCodeAt(0)===65279){content=content.slice(1)}return content}module.exports={isArray,isArrayBuffer,isBuffer,isFormData,isArrayBufferView,isString,isNumber,isObject,isPlainObject,isUndefined,isDate,isFile,isBlob,isFunction,isStream,isURLSearchParams,isStandardBrowserEnv,forEach,merge,extend,trim,stripBOM}},module=>{"use strict";module.exports=function bind(fn,thisArg){return function wrap(){var args=new Array(arguments.length);for(var i=0;i<args.length;i++){args[i]=arguments[i]}return fn.apply(thisArg,args)}}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var buildURL=__webpack_require__(177);var InterceptorManager=__webpack_require__(178);var dispatchRequest=__webpack_require__(179);var mergeConfig=__webpack_require__(194);var validator=__webpack_require__(195);var validators=validator.validators;function Axios(instanceConfig){this.defaults=instanceConfig;this.interceptors={request:new InterceptorManager,response:new InterceptorManager}}Axios.prototype.request=function request(config){if(typeof config==="string"){config=arguments[1]||{};config.url=arguments[0]}else{config=config||{}}config=mergeConfig(this.defaults,config);if(config.method){config.method=config.method.toLowerCase()}else if(this.defaults.method){config.method=this.defaults.method.toLowerCase()}else{config.method="get"}var transitional=config.transitional;if(transitional!==undefined){validator.assertOptions(transitional,{silentJSONParsing:validators.transitional(validators.boolean,"1.0.0"),forcedJSONParsing:validators.transitional(validators.boolean,"1.0.0"),clarifyTimeoutError:validators.transitional(validators.boolean,"1.0.0")},false)}var requestInterceptorChain=[];var synchronousRequestInterceptors=true;this.interceptors.request.forEach((function unshiftRequestInterceptors(interceptor){if(typeof interceptor.runWhen==="function"&&interceptor.runWhen(config)===false){return}synchronousRequestInterceptors=synchronousRequestInterceptors&&interceptor.synchronous;requestInterceptorChain.unshift(interceptor.fulfilled,interceptor.rejected)}));var responseInterceptorChain=[];this.interceptors.response.forEach((function pushResponseInterceptors(interceptor){responseInterceptorChain.push(interceptor.fulfilled,interceptor.rejected)}));var promise;if(!synchronousRequestInterceptors){var chain=[dispatchRequest,undefined];Array.prototype.unshift.apply(chain,requestInterceptorChain);chain=chain.concat(responseInterceptorChain);promise=Promise.resolve(config);while(chain.length){promise=promise.then(chain.shift(),chain.shift())}return promise}var newConfig=config;while(requestInterceptorChain.length){var onFulfilled=requestInterceptorChain.shift();var onRejected=requestInterceptorChain.shift();try{newConfig=onFulfilled(newConfig)}catch(error){onRejected(error);break}}try{promise=dispatchRequest(newConfig)}catch(error){return Promise.reject(error)}while(responseInterceptorChain.length){promise=promise.then(responseInterceptorChain.shift(),responseInterceptorChain.shift())}return promise};Axios.prototype.getUri=function getUri(config){config=mergeConfig(this.defaults,config);return buildURL(config.url,config.params,config.paramsSerializer).replace(/^\?/,"")};utils.forEach(["delete","get","head","options"],(function forEachMethodNoData(method){Axios.prototype[method]=function(url,config){return this.request(mergeConfig(config||{},{method,url,data:(config||{}).data}))}}));utils.forEach(["post","put","patch"],(function forEachMethodWithData(method){Axios.prototype[method]=function(url,data,config){return this.request(mergeConfig(config||{},{method,url,data}))}}));module.exports=Axios},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);function encode(val){return encodeURIComponent(val).replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",").replace(/%20/g,"+").replace(/%5B/gi,"[").replace(/%5D/gi,"]")}module.exports=function buildURL(url,params,paramsSerializer){if(!params){return url}var serializedParams;if(paramsSerializer){serializedParams=paramsSerializer(params)}else if(utils.isURLSearchParams(params)){serializedParams=params.toString()}else{var parts=[];utils.forEach(params,(function serialize(val,key){if(val===null||typeof val==="undefined"){return}if(utils.isArray(val)){key=key+"[]"}else{val=[val]}utils.forEach(val,(function parseValue(v){if(utils.isDate(v)){v=v.toISOString()}else if(utils.isObject(v)){v=JSON.stringify(v)}parts.push(encode(key)+"="+encode(v))}))}));serializedParams=parts.join("&")}if(serializedParams){var hashmarkIndex=url.indexOf("#");if(hashmarkIndex!==-1){url=url.slice(0,hashmarkIndex)}url+=(url.indexOf("?")===-1?"?":"&")+serializedParams}return url}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);function InterceptorManager(){this.handlers=[]}InterceptorManager.prototype.use=function use(fulfilled,rejected,options){this.handlers.push({fulfilled,rejected,synchronous:options?options.synchronous:false,runWhen:options?options.runWhen:null});return this.handlers.length-1};InterceptorManager.prototype.eject=function eject(id){if(this.handlers[id]){this.handlers[id]=null}};InterceptorManager.prototype.forEach=function forEach(fn){utils.forEach(this.handlers,(function forEachHandler(h){if(h!==null){fn(h)}}))};module.exports=InterceptorManager},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var transformData=__webpack_require__(180);var isCancel=__webpack_require__(193);var defaults=__webpack_require__(181);function throwIfCancellationRequested(config){if(config.cancelToken){config.cancelToken.throwIfRequested()}}module.exports=function dispatchRequest(config){throwIfCancellationRequested(config);config.headers=config.headers||{};config.data=transformData.call(config,config.data,config.headers,config.transformRequest);config.headers=utils.merge(config.headers.common||{},config.headers[config.method]||{},config.headers);utils.forEach(["delete","get","head","post","put","patch","common"],(function cleanHeaderConfig(method){delete config.headers[method]}));var adapter=config.adapter||defaults.adapter;return adapter(config).then((function onAdapterResolution(response){throwIfCancellationRequested(config);response.data=transformData.call(config,response.data,response.headers,config.transformResponse);return response}),(function onAdapterRejection(reason){if(!isCancel(reason)){throwIfCancellationRequested(config);if(reason&&reason.response){reason.response.data=transformData.call(config,reason.response.data,reason.response.headers,config.transformResponse)}}return Promise.reject(reason)}))}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var defaults=__webpack_require__(181);module.exports=function transformData(data,headers,fns){var context=this||defaults;utils.forEach(fns,(function transform(fn){data=fn.call(context,data,headers)}));return data}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var normalizeHeaderName=__webpack_require__(182);var enhanceError=__webpack_require__(183);var DEFAULT_CONTENT_TYPE={"Content-Type":"application/x-www-form-urlencoded"};function setContentTypeIfUnset(headers,value){if(!utils.isUndefined(headers)&&utils.isUndefined(headers["Content-Type"])){headers["Content-Type"]=value}}function getDefaultAdapter(){var adapter;if(typeof XMLHttpRequest!=="undefined"){adapter=__webpack_require__(184)}else if(typeof process!=="undefined"&&Object.prototype.toString.call(process)==="[object process]"){adapter=__webpack_require__(184)}return adapter}function stringifySafely(rawValue,parser,encoder){if(utils.isString(rawValue)){try{(parser||JSON.parse)(rawValue);return utils.trim(rawValue)}catch(e){if(e.name!=="SyntaxError"){throw e}}}return(encoder||JSON.stringify)(rawValue)}var defaults={transitional:{silentJSONParsing:true,forcedJSONParsing:true,clarifyTimeoutError:false},adapter:getDefaultAdapter(),transformRequest:[function transformRequest(data,headers){normalizeHeaderName(headers,"Accept");normalizeHeaderName(headers,"Content-Type");if(utils.isFormData(data)||utils.isArrayBuffer(data)||utils.isBuffer(data)||utils.isStream(data)||utils.isFile(data)||utils.isBlob(data)){return data}if(utils.isArrayBufferView(data)){return data.buffer}if(utils.isURLSearchParams(data)){setContentTypeIfUnset(headers,"application/x-www-form-urlencoded;charset=utf-8");return data.toString()}if(utils.isObject(data)||headers&&headers["Content-Type"]==="application/json"){setContentTypeIfUnset(headers,"application/json");return stringifySafely(data)}return data}],transformResponse:[function transformResponse(data){var transitional=this.transitional;var silentJSONParsing=transitional&&transitional.silentJSONParsing;var forcedJSONParsing=transitional&&transitional.forcedJSONParsing;var strictJSONParsing=!silentJSONParsing&&this.responseType==="json";if(strictJSONParsing||forcedJSONParsing&&utils.isString(data)&&data.length){try{return JSON.parse(data)}catch(e){if(strictJSONParsing){if(e.name==="SyntaxError"){throw enhanceError(e,this,"E_JSON_PARSE")}throw e}}}return data}],timeout:0,xsrfCookieName:"XSRF-TOKEN",xsrfHeaderName:"X-XSRF-TOKEN",maxContentLength:-1,maxBodyLength:-1,validateStatus:function validateStatus(status){return status>=200&&status<300}};defaults.headers={common:{Accept:"application/json, text/plain, */*"}};utils.forEach(["delete","get","head"],(function forEachMethodNoData(method){defaults.headers[method]={}}));utils.forEach(["post","put","patch"],(function forEachMethodWithData(method){defaults.headers[method]=utils.merge(DEFAULT_CONTENT_TYPE)}));module.exports=defaults},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);module.exports=function normalizeHeaderName(headers,normalizedName){utils.forEach(headers,(function processHeader(value,name){if(name!==normalizedName&&name.toUpperCase()===normalizedName.toUpperCase()){headers[normalizedName]=value;delete headers[name]}}))}},module=>{"use strict";module.exports=function enhanceError(error,config,code,request,response){error.config=config;if(code){error.code=code}error.request=request;error.response=response;error.isAxiosError=true;error.toJSON=function toJSON(){return{message:this.message,name:this.name,description:this.description,number:this.number,fileName:this.fileName,lineNumber:this.lineNumber,columnNumber:this.columnNumber,stack:this.stack,config:this.config,code:this.code}};return error}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);var settle=__webpack_require__(185);var buildFullPath=__webpack_require__(187);var buildURL=__webpack_require__(177);var http=__webpack_require__(167);var https=__webpack_require__(190);var httpFollow=__webpack_require__(191).http;var httpsFollow=__webpack_require__(191).https;var url=__webpack_require__(3);var zlib=__webpack_require__(165);var pkg=__webpack_require__(171);var createError=__webpack_require__(186);var enhanceError=__webpack_require__(183);var isHttps=/https:?/;function setProxy(options,proxy,location){options.hostname=proxy.host;options.host=proxy.host;options.port=proxy.port;options.path=location;if(proxy.auth){var base64=Buffer.from(proxy.auth.username+":"+proxy.auth.password,"utf8").toString("base64");options.headers["Proxy-Authorization"]="Basic "+base64}options.beforeRedirect=function beforeRedirect(redirection){redirection.headers.host=redirection.host;setProxy(redirection,proxy,redirection.href)}}module.exports=function httpAdapter(config){return new Promise((function dispatchHttpRequest(resolvePromise,rejectPromise){var resolve=function resolve(value){resolvePromise(value)};var reject=function reject(value){rejectPromise(value)};var data=config.data;var headers=config.headers;if("User-Agent"in headers||"user-agent"in headers){if(!headers["User-Agent"]&&!headers["user-agent"]){delete headers["User-Agent"];delete headers["user-agent"]}}else{headers["User-Agent"]="axios/"+pkg.version}if(data&&!utils.isStream(data)){if(Buffer.isBuffer(data)){}else if(utils.isArrayBuffer(data)){data=Buffer.from(new Uint8Array(data))}else if(utils.isString(data)){data=Buffer.from(data,"utf-8")}else{return reject(createError("Data after transformation must be a string, an ArrayBuffer, a Buffer, or a Stream",config))}headers["Content-Length"]=data.length}var auth=undefined;if(config.auth){var username=config.auth.username||"";var password=config.auth.password||"";auth=username+":"+password}var fullPath=buildFullPath(config.baseURL,config.url);var parsed=url.parse(fullPath);var protocol=parsed.protocol||"http:";if(!auth&&parsed.auth){var urlAuth=parsed.auth.split(":");var urlUsername=urlAuth[0]||"";var urlPassword=urlAuth[1]||"";auth=urlUsername+":"+urlPassword}if(auth){delete headers.Authorization}var isHttpsRequest=isHttps.test(protocol);var agent=isHttpsRequest?config.httpsAgent:config.httpAgent;var options={path:buildURL(parsed.path,config.params,config.paramsSerializer).replace(/^\?/,""),method:config.method.toUpperCase(),headers,agent,agents:{http:config.httpAgent,https:config.httpsAgent},auth};if(config.socketPath){options.socketPath=config.socketPath}else{options.hostname=parsed.hostname;options.port=parsed.port}var proxy=config.proxy;if(!proxy&&proxy!==false){var proxyEnv=protocol.slice(0,-1)+"_proxy";var proxyUrl=process.env[proxyEnv]||process.env[proxyEnv.toUpperCase()];if(proxyUrl){var parsedProxyUrl=url.parse(proxyUrl);var noProxyEnv=process.env.no_proxy||process.env.NO_PROXY;var shouldProxy=true;if(noProxyEnv){var noProxy=noProxyEnv.split(",").map((function trim(s){return s.trim()}));shouldProxy=!noProxy.some((function proxyMatch(proxyElement){if(!proxyElement){return false}if(proxyElement==="*"){return true}if(proxyElement[0]==="."&&parsed.hostname.substr(parsed.hostname.length-proxyElement.length)===proxyElement){return true}return parsed.hostname===proxyElement}))}if(shouldProxy){proxy={host:parsedProxyUrl.hostname,port:parsedProxyUrl.port,protocol:parsedProxyUrl.protocol};if(parsedProxyUrl.auth){var proxyUrlAuth=parsedProxyUrl.auth.split(":");proxy.auth={username:proxyUrlAuth[0],password:proxyUrlAuth[1]}}}}}if(proxy){options.headers.host=parsed.hostname+(parsed.port?":"+parsed.port:"");setProxy(options,proxy,protocol+"//"+parsed.hostname+(parsed.port?":"+parsed.port:"")+options.path)}var transport;var isHttpsProxy=isHttpsRequest&&(proxy?isHttps.test(proxy.protocol):true);if(config.transport){transport=config.transport}else if(config.maxRedirects===0){transport=isHttpsProxy?https:http}else{if(config.maxRedirects){options.maxRedirects=config.maxRedirects}transport=isHttpsProxy?httpsFollow:httpFollow}if(config.maxBodyLength>-1){options.maxBodyLength=config.maxBodyLength}var req=transport.request(options,(function handleResponse(res){if(req.aborted)return;var stream=res;var lastRequest=res.req||req;if(res.statusCode!==204&&lastRequest.method!=="HEAD"&&config.decompress!==false){switch(res.headers["content-encoding"]){case"gzip":case"compress":case"deflate":stream=stream.pipe(zlib.createUnzip());delete res.headers["content-encoding"];break}}var response={status:res.statusCode,statusText:res.statusMessage,headers:res.headers,config,request:lastRequest};if(config.responseType==="stream"){response.data=stream;settle(resolve,reject,response)}else{var responseBuffer=[];var totalResponseBytes=0;stream.on("data",(function handleStreamData(chunk){responseBuffer.push(chunk);totalResponseBytes+=chunk.length;if(config.maxContentLength>-1&&totalResponseBytes>config.maxContentLength){stream.destroy();reject(createError("maxContentLength size of "+config.maxContentLength+" exceeded",config,null,lastRequest))}}));stream.on("error",(function handleStreamError(err){if(req.aborted)return;reject(enhanceError(err,config,null,lastRequest))}));stream.on("end",(function handleStreamEnd(){var responseData=Buffer.concat(responseBuffer);if(config.responseType!=="arraybuffer"){responseData=responseData.toString(config.responseEncoding);if(!config.responseEncoding||config.responseEncoding==="utf8"){responseData=utils.stripBOM(responseData)}}response.data=responseData;settle(resolve,reject,response)}))}}));req.on("error",(function handleRequestError(err){if(req.aborted&&err.code!=="ERR_FR_TOO_MANY_REDIRECTS")return;reject(enhanceError(err,config,null,req))}));if(config.timeout){var timeout=parseInt(config.timeout,10);if(isNaN(timeout)){reject(createError("error trying to parse `config.timeout` to int",config,"ERR_PARSE_TIMEOUT",req));return}req.setTimeout(timeout,(function handleRequestTimeout(){req.abort();reject(createError("timeout of "+timeout+"ms exceeded",config,config.transitional&&config.transitional.clarifyTimeoutError?"ETIMEDOUT":"ECONNABORTED",req))}))}if(config.cancelToken){config.cancelToken.promise.then((function onCanceled(cancel){if(req.aborted)return;req.abort();reject(cancel)}))}if(utils.isStream(data)){data.on("error",(function handleStreamError(err){reject(enhanceError(err,config,null,req))})).pipe(req)}else{req.end(data)}}))}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var createError=__webpack_require__(186);module.exports=function settle(resolve,reject,response){var validateStatus=response.config.validateStatus;if(!response.status||!validateStatus||validateStatus(response.status)){resolve(response)}else{reject(createError("Request failed with status code "+response.status,response.config,null,response.request,response))}}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var enhanceError=__webpack_require__(183);module.exports=function createError(message,config,code,request,response){var error=new Error(message);return enhanceError(error,config,code,request,response)}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var isAbsoluteURL=__webpack_require__(188);var combineURLs=__webpack_require__(189);module.exports=function buildFullPath(baseURL,requestedURL){if(baseURL&&!isAbsoluteURL(requestedURL)){return combineURLs(baseURL,requestedURL)}return requestedURL}},module=>{"use strict";module.exports=function isAbsoluteURL(url){return/^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url)}},module=>{"use strict";module.exports=function combineURLs(baseURL,relativeURL){return relativeURL?baseURL.replace(/\/+$/,"")+"/"+relativeURL.replace(/^\/+/,""):baseURL}},module=>{"use strict";module.exports=require("https")},(module,__unused_webpack_exports,__webpack_require__)=>{var url=__webpack_require__(3);var URL=url.URL;var http=__webpack_require__(167);var https=__webpack_require__(190);var Writable=__webpack_require__(21).Writable;var assert=__webpack_require__(37);var debug=__webpack_require__(192);var events=["abort","aborted","connect","error","socket","timeout"];var eventHandlers=Object.create(null);events.forEach((function(event){eventHandlers[event]=function(arg1,arg2,arg3){this._redirectable.emit(event,arg1,arg2,arg3)}}));var RedirectionError=createErrorType("ERR_FR_REDIRECTION_FAILURE","Redirected request failed");var TooManyRedirectsError=createErrorType("ERR_FR_TOO_MANY_REDIRECTS","Maximum number of redirects exceeded");var MaxBodyLengthExceededError=createErrorType("ERR_FR_MAX_BODY_LENGTH_EXCEEDED","Request body larger than maxBodyLength limit");var WriteAfterEndError=createErrorType("ERR_STREAM_WRITE_AFTER_END","write after end");function RedirectableRequest(options,responseCallback){Writable.call(this);this._sanitizeOptions(options);this._options=options;this._ended=false;this._ending=false;this._redirectCount=0;this._redirects=[];this._requestBodyLength=0;this._requestBodyBuffers=[];if(responseCallback){this.on("response",responseCallback)}var self=this;this._onNativeResponse=function(response){self._processResponse(response)};this._performRequest()}RedirectableRequest.prototype=Object.create(Writable.prototype);RedirectableRequest.prototype.abort=function(){abortRequest(this._currentRequest);this.emit("abort")};RedirectableRequest.prototype.write=function(data,encoding,callback){if(this._ending){throw new WriteAfterEndError}if(!(typeof data==="string"||typeof data==="object"&&"length"in data)){throw new TypeError("data should be a string, Buffer or Uint8Array")}if(typeof encoding==="function"){callback=encoding;encoding=null}if(data.length===0){if(callback){callback()}return}if(this._requestBodyLength+data.length<=this._options.maxBodyLength){this._requestBodyLength+=data.length;this._requestBodyBuffers.push({data,encoding});this._currentRequest.write(data,encoding,callback)}else{this.emit("error",new MaxBodyLengthExceededError);this.abort()}};RedirectableRequest.prototype.end=function(data,encoding,callback){if(typeof data==="function"){callback=data;data=encoding=null}else if(typeof encoding==="function"){callback=encoding;encoding=null}if(!data){this._ended=this._ending=true;this._currentRequest.end(null,null,callback)}else{var self=this;var currentRequest=this._currentRequest;this.write(data,encoding,(function(){self._ended=true;currentRequest.end(null,null,callback)}));this._ending=true}};RedirectableRequest.prototype.setHeader=function(name,value){this._options.headers[name]=value;this._currentRequest.setHeader(name,value)};RedirectableRequest.prototype.removeHeader=function(name){delete this._options.headers[name];this._currentRequest.removeHeader(name)};RedirectableRequest.prototype.setTimeout=function(msecs,callback){var self=this;function destroyOnTimeout(socket){socket.setTimeout(msecs);socket.removeListener("timeout",socket.destroy);socket.addListener("timeout",socket.destroy)}function startTimer(socket){if(self._timeout){clearTimeout(self._timeout)}self._timeout=setTimeout((function(){self.emit("timeout");clearTimer()}),msecs);destroyOnTimeout(socket)}function clearTimer(){if(self._timeout){clearTimeout(self._timeout);self._timeout=null}self.removeListener("abort",clearTimer);self.removeListener("error",clearTimer);self.removeListener("response",clearTimer);if(callback){self.removeListener("timeout",callback)}if(!self.socket){self._currentRequest.removeListener("socket",startTimer)}}if(callback){this.on("timeout",callback)}if(this.socket){startTimer(this.socket)}else{this._currentRequest.once("socket",startTimer)}this.on("socket",destroyOnTimeout);this.on("abort",clearTimer);this.on("error",clearTimer);this.on("response",clearTimer);return this};["flushHeaders","getHeader","setNoDelay","setSocketKeepAlive"].forEach((function(method){RedirectableRequest.prototype[method]=function(a,b){return this._currentRequest[method](a,b)}}));["aborted","connection","socket"].forEach((function(property){Object.defineProperty(RedirectableRequest.prototype,property,{get:function(){return this._currentRequest[property]}})}));RedirectableRequest.prototype._sanitizeOptions=function(options){if(!options.headers){options.headers={}}if(options.host){if(!options.hostname){options.hostname=options.host}delete options.host}if(!options.pathname&&options.path){var searchPos=options.path.indexOf("?");if(searchPos<0){options.pathname=options.path}else{options.pathname=options.path.substring(0,searchPos);options.search=options.path.substring(searchPos)}}};RedirectableRequest.prototype._performRequest=function(){var protocol=this._options.protocol;var nativeProtocol=this._options.nativeProtocols[protocol];if(!nativeProtocol){this.emit("error",new TypeError("Unsupported protocol "+protocol));return}if(this._options.agents){var scheme=protocol.substr(0,protocol.length-1);this._options.agent=this._options.agents[scheme]}var request=this._currentRequest=nativeProtocol.request(this._options,this._onNativeResponse);this._currentUrl=url.format(this._options);request._redirectable=this;for(var e=0;e<events.length;e++){request.on(events[e],eventHandlers[events[e]])}if(this._isRedirect){var i=0;var self=this;var buffers=this._requestBodyBuffers;(function writeNext(error){if(request===self._currentRequest){if(error){self.emit("error",error)}else if(i<buffers.length){var buffer=buffers[i++];if(!request.finished){request.write(buffer.data,buffer.encoding,writeNext)}}else if(self._ended){request.end()}}})()}};RedirectableRequest.prototype._processResponse=function(response){var statusCode=response.statusCode;if(this._options.trackRedirects){this._redirects.push({url:this._currentUrl,headers:response.headers,statusCode})}var location=response.headers.location;if(location&&this._options.followRedirects!==false&&statusCode>=300&&statusCode<400){abortRequest(this._currentRequest);response.destroy();if(++this._redirectCount>this._options.maxRedirects){this.emit("error",new TooManyRedirectsError);return}if((statusCode===301||statusCode===302)&&this._options.method==="POST"||statusCode===303&&!/^(?:GET|HEAD)$/.test(this._options.method)){this._options.method="GET";this._requestBodyBuffers=[];removeMatchingHeaders(/^content-/i,this._options.headers)}var currentHostHeader=removeMatchingHeaders(/^host$/i,this._options.headers);var currentUrlParts=url.parse(this._currentUrl);var currentHost=currentHostHeader||currentUrlParts.host;var currentUrl=/^\w+:/.test(location)?this._currentUrl:url.format(Object.assign(currentUrlParts,{host:currentHost}));var redirectUrl;try{redirectUrl=url.resolve(currentUrl,location)}catch(cause){this.emit("error",new RedirectionError(cause));return}debug("redirecting to",redirectUrl);this._isRedirect=true;var redirectUrlParts=url.parse(redirectUrl);Object.assign(this._options,redirectUrlParts);if(!(redirectUrlParts.host===currentHost||isSubdomainOf(redirectUrlParts.host,currentHost))){removeMatchingHeaders(/^authorization$/i,this._options.headers)}if(typeof this._options.beforeRedirect==="function"){var responseDetails={headers:response.headers};try{this._options.beforeRedirect.call(null,this._options,responseDetails)}catch(err){this.emit("error",err);return}this._sanitizeOptions(this._options)}try{this._performRequest()}catch(cause){this.emit("error",new RedirectionError(cause))}}else{response.responseUrl=this._currentUrl;response.redirects=this._redirects;this.emit("response",response);this._requestBodyBuffers=[]}};function wrap(protocols){var exports={maxRedirects:21,maxBodyLength:10*1024*1024};var nativeProtocols={};Object.keys(protocols).forEach((function(scheme){var protocol=scheme+":";var nativeProtocol=nativeProtocols[protocol]=protocols[scheme];var wrappedProtocol=exports[scheme]=Object.create(nativeProtocol);function request(input,options,callback){if(typeof input==="string"){var urlStr=input;try{input=urlToOptions(new URL(urlStr))}catch(err){input=url.parse(urlStr)}}else if(URL&&input instanceof URL){input=urlToOptions(input)}else{callback=options;options=input;input={protocol}}if(typeof options==="function"){callback=options;options=null}options=Object.assign({maxRedirects:exports.maxRedirects,maxBodyLength:exports.maxBodyLength},input,options);options.nativeProtocols=nativeProtocols;assert.equal(options.protocol,protocol,"protocol mismatch");debug("options",options);return new RedirectableRequest(options,callback)}function get(input,options,callback){var wrappedRequest=wrappedProtocol.request(input,options,callback);wrappedRequest.end();return wrappedRequest}Object.defineProperties(wrappedProtocol,{request:{value:request,configurable:true,enumerable:true,writable:true},get:{value:get,configurable:true,enumerable:true,writable:true}})}));return exports}function noop(){}function urlToOptions(urlObject){var options={protocol:urlObject.protocol,hostname:urlObject.hostname.startsWith("[")?urlObject.hostname.slice(1,-1):urlObject.hostname,hash:urlObject.hash,search:urlObject.search,pathname:urlObject.pathname,path:urlObject.pathname+urlObject.search,href:urlObject.href};if(urlObject.port!==""){options.port=Number(urlObject.port)}return options}function removeMatchingHeaders(regex,headers){var lastValue;for(var header in headers){if(regex.test(header)){lastValue=headers[header].toString().trim();delete headers[header]}}return lastValue}function createErrorType(code,defaultMessage){function CustomError(cause){Error.captureStackTrace(this,this.constructor);if(!cause){this.message=defaultMessage}else{this.message=defaultMessage+": "+cause.message;this.cause=cause}}CustomError.prototype=new Error;CustomError.prototype.constructor=CustomError;CustomError.prototype.name="Error ["+code+"]";CustomError.prototype.code=code;return CustomError}function abortRequest(request){for(var e=0;e<events.length;e++){request.removeListener(events[e],eventHandlers[events[e]])}request.on("error",noop);request.abort()}function isSubdomainOf(subdomain,domain){const dot=subdomain.length-domain.length-1;return dot>0&&subdomain[dot]==="."&&subdomain.endsWith(domain)}module.exports=wrap({http,https});module.exports.wrap=wrap},(module,__unused_webpack_exports,__webpack_require__)=>{var debug;module.exports=function(){if(!debug){try{debug=__webpack_require__(10)("follow-redirects")}catch(error){}if(typeof debug!=="function"){debug=function(){}}}debug.apply(null,arguments)}},module=>{"use strict";module.exports=function isCancel(value){return!!(value&&value.__CANCEL__)}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var utils=__webpack_require__(174);module.exports=function mergeConfig(config1,config2){config2=config2||{};var config={};var valueFromConfig2Keys=["url","method","data"];var mergeDeepPropertiesKeys=["headers","auth","proxy","params"];var defaultToConfig2Keys=["baseURL","transformRequest","transformResponse","paramsSerializer","timeout","timeoutMessage","withCredentials","adapter","responseType","xsrfCookieName","xsrfHeaderName","onUploadProgress","onDownloadProgress","decompress","maxContentLength","maxBodyLength","maxRedirects","transport","httpAgent","httpsAgent","cancelToken","socketPath","responseEncoding"];var directMergeKeys=["validateStatus"];function getMergedValue(target,source){if(utils.isPlainObject(target)&&utils.isPlainObject(source)){return utils.merge(target,source)}else if(utils.isPlainObject(source)){return utils.merge({},source)}else if(utils.isArray(source)){return source.slice()}return source}function mergeDeepProperties(prop){if(!utils.isUndefined(config2[prop])){config[prop]=getMergedValue(config1[prop],config2[prop])}else if(!utils.isUndefined(config1[prop])){config[prop]=getMergedValue(undefined,config1[prop])}}utils.forEach(valueFromConfig2Keys,(function valueFromConfig2(prop){if(!utils.isUndefined(config2[prop])){config[prop]=getMergedValue(undefined,config2[prop])}}));utils.forEach(mergeDeepPropertiesKeys,mergeDeepProperties);utils.forEach(defaultToConfig2Keys,(function defaultToConfig2(prop){if(!utils.isUndefined(config2[prop])){config[prop]=getMergedValue(undefined,config2[prop])}else if(!utils.isUndefined(config1[prop])){config[prop]=getMergedValue(undefined,config1[prop])}}));utils.forEach(directMergeKeys,(function merge(prop){if(prop in config2){config[prop]=getMergedValue(config1[prop],config2[prop])}else if(prop in config1){config[prop]=getMergedValue(undefined,config1[prop])}}));var axiosKeys=valueFromConfig2Keys.concat(mergeDeepPropertiesKeys).concat(defaultToConfig2Keys).concat(directMergeKeys);var otherKeys=Object.keys(config1).concat(Object.keys(config2)).filter((function filterAxiosKeys(key){return axiosKeys.indexOf(key)===-1}));utils.forEach(otherKeys,mergeDeepProperties);return config}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var pkg=__webpack_require__(171);var validators={};["object","boolean","number","function","string","symbol"].forEach((function(type,i){validators[type]=function validator(thing){return typeof thing===type||"a"+(i<1?"n ":" ")+type}}));var deprecatedWarnings={};var currentVerArr=pkg.version.split(".");function isOlderVersion(version,thanVersion){var pkgVersionArr=thanVersion?thanVersion.split("."):currentVerArr;var destVer=version.split(".");for(var i=0;i<3;i++){if(pkgVersionArr[i]>destVer[i]){return true}else if(pkgVersionArr[i]<destVer[i]){return false}}return false}validators.transitional=function transitional(validator,version,message){var isDeprecated=version&&isOlderVersion(version);function formatMessage(opt,desc){return"[Axios v"+pkg.version+"] Transitional option '"+opt+"'"+desc+(message?". "+message:"")}return function(value,opt,opts){if(validator===false){throw new Error(formatMessage(opt," has been removed in "+version))}if(isDeprecated&&!deprecatedWarnings[opt]){deprecatedWarnings[opt]=true;console.warn(formatMessage(opt," has been deprecated since v"+version+" and will be removed in the near future"))}return validator?validator(value,opt,opts):true}};function assertOptions(options,schema,allowUnknown){if(typeof options!=="object"){throw new TypeError("options must be an object")}var keys=Object.keys(options);var i=keys.length;while(i-- >0){var opt=keys[i];var validator=schema[opt];if(validator){var value=options[opt];var result=value===undefined||validator(value,opt,options);if(result!==true){throw new TypeError("option "+opt+" must be "+result)}continue}if(allowUnknown!==true){throw Error("Unknown option "+opt)}}}module.exports={isOlderVersion,assertOptions,validators}},module=>{"use strict";function Cancel(message){this.message=message}Cancel.prototype.toString=function toString(){return"Cancel"+(this.message?": "+this.message:"")};Cancel.prototype.__CANCEL__=true;module.exports=Cancel},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var Cancel=__webpack_require__(196);function CancelToken(executor){if(typeof executor!=="function"){throw new TypeError("executor must be a function.")}var resolvePromise;this.promise=new Promise((function promiseExecutor(resolve){resolvePromise=resolve}));var token=this;executor((function cancel(message){if(token.reason){return}token.reason=new Cancel(message);resolvePromise(token.reason)}))}CancelToken.prototype.throwIfRequested=function throwIfRequested(){if(this.reason){throw this.reason}};CancelToken.source=function source(){var cancel;var token=new CancelToken((function executor(c){cancel=c}));return{token,cancel}};module.exports=CancelToken},module=>{"use strict";module.exports=function spread(callback){return function wrap(arr){return callback.apply(null,arr)}}},module=>{"use strict";module.exports=function isAxiosError(payload){return typeof payload==="object"&&payload.isAxiosError===true}},function(module,exports,__webpack_require__){module=__webpack_require__.nmd(module);var __WEBPACK_AMD_DEFINE_RESULT__;(function(){var undefined;var VERSION="4.17.10";var LARGE_ARRAY_SIZE=200;var CORE_ERROR_TEXT="Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",FUNC_ERROR_TEXT="Expected a function";var HASH_UNDEFINED="__lodash_hash_undefined__";var MAX_MEMOIZE_SIZE=500;var PLACEHOLDER="__lodash_placeholder__";var CLONE_DEEP_FLAG=1,CLONE_FLAT_FLAG=2,CLONE_SYMBOLS_FLAG=4;var COMPARE_PARTIAL_FLAG=1,COMPARE_UNORDERED_FLAG=2;var WRAP_BIND_FLAG=1,WRAP_BIND_KEY_FLAG=2,WRAP_CURRY_BOUND_FLAG=4,WRAP_CURRY_FLAG=8,WRAP_CURRY_RIGHT_FLAG=16,WRAP_PARTIAL_FLAG=32,WRAP_PARTIAL_RIGHT_FLAG=64,WRAP_ARY_FLAG=128,WRAP_REARG_FLAG=256,WRAP_FLIP_FLAG=512;var DEFAULT_TRUNC_LENGTH=30,DEFAULT_TRUNC_OMISSION="...";var HOT_COUNT=800,HOT_SPAN=16;var LAZY_FILTER_FLAG=1,LAZY_MAP_FLAG=2,LAZY_WHILE_FLAG=3;var INFINITY=1/0,MAX_SAFE_INTEGER=9007199254740991,MAX_INTEGER=17976931348623157e292,NAN=0/0;var MAX_ARRAY_LENGTH=4294967295,MAX_ARRAY_INDEX=MAX_ARRAY_LENGTH-1,HALF_MAX_ARRAY_LENGTH=MAX_ARRAY_LENGTH>>>1;var wrapFlags=[["ary",WRAP_ARY_FLAG],["bind",WRAP_BIND_FLAG],["bindKey",WRAP_BIND_KEY_FLAG],["curry",WRAP_CURRY_FLAG],["curryRight",WRAP_CURRY_RIGHT_FLAG],["flip",WRAP_FLIP_FLAG],["partial",WRAP_PARTIAL_FLAG],["partialRight",WRAP_PARTIAL_RIGHT_FLAG],["rearg",WRAP_REARG_FLAG]];var argsTag="[object Arguments]",arrayTag="[object Array]",asyncTag="[object AsyncFunction]",boolTag="[object Boolean]",dateTag="[object Date]",domExcTag="[object DOMException]",errorTag="[object Error]",funcTag="[object Function]",genTag="[object GeneratorFunction]",mapTag="[object Map]",numberTag="[object Number]",nullTag="[object Null]",objectTag="[object Object]",promiseTag="[object Promise]",proxyTag="[object Proxy]",regexpTag="[object RegExp]",setTag="[object Set]",stringTag="[object String]",symbolTag="[object Symbol]",undefinedTag="[object Undefined]",weakMapTag="[object WeakMap]",weakSetTag="[object WeakSet]";var arrayBufferTag="[object ArrayBuffer]",dataViewTag="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]";var reEmptyStringLeading=/\b__p \+= '';/g,reEmptyStringMiddle=/\b(__p \+=) '' \+/g,reEmptyStringTrailing=/(__e\(.*?\)|\b__t\)) \+\n'';/g;var reEscapedHtml=/&(?:amp|lt|gt|quot|#39);/g,reUnescapedHtml=/[&<>"']/g,reHasEscapedHtml=RegExp(reEscapedHtml.source),reHasUnescapedHtml=RegExp(reUnescapedHtml.source);var reEscape=/<%-([\s\S]+?)%>/g,reEvaluate=/<%([\s\S]+?)%>/g,reInterpolate=/<%=([\s\S]+?)%>/g;var reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/,rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var reRegExpChar=/[\\^$.*+?()[\]{}|]/g,reHasRegExpChar=RegExp(reRegExpChar.source);var reTrim=/^\s+|\s+$/g,reTrimStart=/^\s+/,reTrimEnd=/\s+$/;var reWrapComment=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,reWrapDetails=/\{\n\/\* \[wrapped with (.+)\] \*/,reSplitDetails=/,? & /;var reAsciiWord=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;var reEscapeChar=/\\(\\)?/g;var reEsTemplate=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;var reFlags=/\w*$/;var reIsBadHex=/^[-+]0x[0-9a-f]+$/i;var reIsBinary=/^0b[01]+$/i;var reIsHostCtor=/^\[object .+?Constructor\]$/;var reIsOctal=/^0o[0-7]+$/i;var reIsUint=/^(?:0|[1-9]\d*)$/;var reLatin=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;var reNoMatch=/($^)/;var reUnescapedString=/['\n\r\u2028\u2029\\]/g;var rsAstralRange="\\ud800-\\udfff",rsComboMarksRange="\\u0300-\\u036f",reComboHalfMarksRange="\\ufe20-\\ufe2f",rsComboSymbolsRange="\\u20d0-\\u20ff",rsComboRange=rsComboMarksRange+reComboHalfMarksRange+rsComboSymbolsRange,rsDingbatRange="\\u2700-\\u27bf",rsLowerRange="a-z\\xdf-\\xf6\\xf8-\\xff",rsMathOpRange="\\xac\\xb1\\xd7\\xf7",rsNonCharRange="\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf",rsPunctuationRange="\\u2000-\\u206f",rsSpaceRange=" \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",rsUpperRange="A-Z\\xc0-\\xd6\\xd8-\\xde",rsVarRange="\\ufe0e\\ufe0f",rsBreakRange=rsMathOpRange+rsNonCharRange+rsPunctuationRange+rsSpaceRange;var rsApos="['’]",rsAstral="["+rsAstralRange+"]",rsBreak="["+rsBreakRange+"]",rsCombo="["+rsComboRange+"]",rsDigits="\\d+",rsDingbat="["+rsDingbatRange+"]",rsLower="["+rsLowerRange+"]",rsMisc="[^"+rsAstralRange+rsBreakRange+rsDigits+rsDingbatRange+rsLowerRange+rsUpperRange+"]",rsFitz="\\ud83c[\\udffb-\\udfff]",rsModifier="(?:"+rsCombo+"|"+rsFitz+")",rsNonAstral="[^"+rsAstralRange+"]",rsRegional="(?:\\ud83c[\\udde6-\\uddff]){2}",rsSurrPair="[\\ud800-\\udbff][\\udc00-\\udfff]",rsUpper="["+rsUpperRange+"]",rsZWJ="\\u200d";var rsMiscLower="(?:"+rsLower+"|"+rsMisc+")",rsMiscUpper="(?:"+rsUpper+"|"+rsMisc+")",rsOptContrLower="(?:"+rsApos+"(?:d|ll|m|re|s|t|ve))?",rsOptContrUpper="(?:"+rsApos+"(?:D|LL|M|RE|S|T|VE))?",reOptMod=rsModifier+"?",rsOptVar="["+rsVarRange+"]?",rsOptJoin="(?:"+rsZWJ+"(?:"+[rsNonAstral,rsRegional,rsSurrPair].join("|")+")"+rsOptVar+reOptMod+")*",rsOrdLower="\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",rsOrdUpper="\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])",rsSeq=rsOptVar+reOptMod+rsOptJoin,rsEmoji="(?:"+[rsDingbat,rsRegional,rsSurrPair].join("|")+")"+rsSeq,rsSymbol="(?:"+[rsNonAstral+rsCombo+"?",rsCombo,rsRegional,rsSurrPair,rsAstral].join("|")+")";var reApos=RegExp(rsApos,"g");var reComboMark=RegExp(rsCombo,"g");var reUnicode=RegExp(rsFitz+"(?="+rsFitz+")|"+rsSymbol+rsSeq,"g");var reUnicodeWord=RegExp([rsUpper+"?"+rsLower+"+"+rsOptContrLower+"(?="+[rsBreak,rsUpper,"$"].join("|")+")",rsMiscUpper+"+"+rsOptContrUpper+"(?="+[rsBreak,rsUpper+rsMiscLower,"$"].join("|")+")",rsUpper+"?"+rsMiscLower+"+"+rsOptContrLower,rsUpper+"+"+rsOptContrUpper,rsOrdUpper,rsOrdLower,rsDigits,rsEmoji].join("|"),"g");var reHasUnicode=RegExp("["+rsZWJ+rsAstralRange+rsComboRange+rsVarRange+"]");var reHasUnicodeWord=/[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;var contextProps=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"];var templateCounter=-1;var typedArrayTags={};typedArrayTags[float32Tag]=typedArrayTags[float64Tag]=typedArrayTags[int8Tag]=typedArrayTags[int16Tag]=typedArrayTags[int32Tag]=typedArrayTags[uint8Tag]=typedArrayTags[uint8ClampedTag]=typedArrayTags[uint16Tag]=typedArrayTags[uint32Tag]=true;typedArrayTags[argsTag]=typedArrayTags[arrayTag]=typedArrayTags[arrayBufferTag]=typedArrayTags[boolTag]=typedArrayTags[dataViewTag]=typedArrayTags[dateTag]=typedArrayTags[errorTag]=typedArrayTags[funcTag]=typedArrayTags[mapTag]=typedArrayTags[numberTag]=typedArrayTags[objectTag]=typedArrayTags[regexpTag]=typedArrayTags[setTag]=typedArrayTags[stringTag]=typedArrayTags[weakMapTag]=false;var cloneableTags={};cloneableTags[argsTag]=cloneableTags[arrayTag]=cloneableTags[arrayBufferTag]=cloneableTags[dataViewTag]=cloneableTags[boolTag]=cloneableTags[dateTag]=cloneableTags[float32Tag]=cloneableTags[float64Tag]=cloneableTags[int8Tag]=cloneableTags[int16Tag]=cloneableTags[int32Tag]=cloneableTags[mapTag]=cloneableTags[numberTag]=cloneableTags[objectTag]=cloneableTags[regexpTag]=cloneableTags[setTag]=cloneableTags[stringTag]=cloneableTags[symbolTag]=cloneableTags[uint8Tag]=cloneableTags[uint8ClampedTag]=cloneableTags[uint16Tag]=cloneableTags[uint32Tag]=true;cloneableTags[errorTag]=cloneableTags[funcTag]=cloneableTags[weakMapTag]=false;var deburredLetters={À:"A",Á:"A",Â:"A",Ã:"A",Ä:"A",Å:"A",à:"a",á:"a",â:"a",ã:"a",ä:"a",å:"a",Ç:"C",ç:"c",Ð:"D",ð:"d",È:"E",É:"E",Ê:"E",Ë:"E",è:"e",é:"e",ê:"e",ë:"e",Ì:"I",Í:"I",Î:"I",Ï:"I",ì:"i",í:"i",î:"i",ï:"i",Ñ:"N",ñ:"n",Ò:"O",Ó:"O",Ô:"O",Õ:"O",Ö:"O",Ø:"O",ò:"o",ó:"o",ô:"o",õ:"o",ö:"o",ø:"o",Ù:"U",Ú:"U",Û:"U",Ü:"U",ù:"u",ú:"u",û:"u",ü:"u",Ý:"Y",ý:"y",ÿ:"y",Æ:"Ae",æ:"ae",Þ:"Th",þ:"th",ß:"ss",Ā:"A",Ă:"A",Ą:"A",ā:"a",ă:"a",ą:"a",Ć:"C",Ĉ:"C",Ċ:"C",Č:"C",ć:"c",ĉ:"c",ċ:"c",č:"c",Ď:"D",Đ:"D",ď:"d",đ:"d",Ē:"E",Ĕ:"E",Ė:"E",Ę:"E",Ě:"E",ē:"e",ĕ:"e",ė:"e",ę:"e",ě:"e",Ĝ:"G",Ğ:"G",Ġ:"G",Ģ:"G",ĝ:"g",ğ:"g",ġ:"g",ģ:"g",Ĥ:"H",Ħ:"H",ĥ:"h",ħ:"h",Ĩ:"I",Ī:"I",Ĭ:"I",Į:"I",İ:"I",ĩ:"i",ī:"i",ĭ:"i",į:"i",ı:"i",Ĵ:"J",ĵ:"j",Ķ:"K",ķ:"k",ĸ:"k",Ĺ:"L",Ļ:"L",Ľ:"L",Ŀ:"L",Ł:"L",ĺ:"l",ļ:"l",ľ:"l",ŀ:"l",ł:"l",Ń:"N",Ņ:"N",Ň:"N",Ŋ:"N",ń:"n",ņ:"n",ň:"n",ŋ:"n",Ō:"O",Ŏ:"O",Ő:"O",ō:"o",ŏ:"o",ő:"o",Ŕ:"R",Ŗ:"R",Ř:"R",ŕ:"r",ŗ:"r",ř:"r",Ś:"S",Ŝ:"S",Ş:"S",Š:"S",ś:"s",ŝ:"s",ş:"s",š:"s",Ţ:"T",Ť:"T",Ŧ:"T",ţ:"t",ť:"t",ŧ:"t",Ũ:"U",Ū:"U",Ŭ:"U",Ů:"U",Ű:"U",Ų:"U",ũ:"u",ū:"u",ŭ:"u",ů:"u",ű:"u",ų:"u",Ŵ:"W",ŵ:"w",Ŷ:"Y",ŷ:"y",Ÿ:"Y",Ź:"Z",Ż:"Z",Ž:"Z",ź:"z",ż:"z",ž:"z",Ĳ:"IJ",ĳ:"ij",Œ:"Oe",œ:"oe",ŉ:"'n",ſ:"s"};var htmlEscapes={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"};var htmlUnescapes={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"};var stringEscapes={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"};var freeParseFloat=parseFloat,freeParseInt=parseInt;var freeGlobal=typeof global=="object"&&global&&global.Object===Object&&global;var freeSelf=typeof self=="object"&&self&&self.Object===Object&&self;var root=freeGlobal||freeSelf||Function("return this")();var freeExports=true&&exports&&!exports.nodeType&&exports;var freeModule=freeExports&&"object"=="object"&&module&&!module.nodeType&&module;var moduleExports=freeModule&&freeModule.exports===freeExports;var freeProcess=moduleExports&&freeGlobal.process;var nodeUtil=function(){try{var types=freeModule&&freeModule.require&&freeModule.require("util").types;if(types){return types}return freeProcess&&freeProcess.binding&&freeProcess.binding("util")}catch(e){}}();var nodeIsArrayBuffer=nodeUtil&&nodeUtil.isArrayBuffer,nodeIsDate=nodeUtil&&nodeUtil.isDate,nodeIsMap=nodeUtil&&nodeUtil.isMap,nodeIsRegExp=nodeUtil&&nodeUtil.isRegExp,nodeIsSet=nodeUtil&&nodeUtil.isSet,nodeIsTypedArray=nodeUtil&&nodeUtil.isTypedArray;function apply(func,thisArg,args){switch(args.length){case 0:return func.call(thisArg);case 1:return func.call(thisArg,args[0]);case 2:return func.call(thisArg,args[0],args[1]);case 3:return func.call(thisArg,args[0],args[1],args[2])}return func.apply(thisArg,args)}function arrayAggregator(array,setter,iteratee,accumulator){var index=-1,length=array==null?0:array.length;while(++index<length){var value=array[index];setter(accumulator,value,iteratee(value),array)}return accumulator}function arrayEach(array,iteratee){var index=-1,length=array==null?0:array.length;while(++index<length){if(iteratee(array[index],index,array)===false){break}}return array}function arrayEachRight(array,iteratee){var length=array==null?0:array.length;while(length--){if(iteratee(array[length],length,array)===false){break}}return array}function arrayEvery(array,predicate){var index=-1,length=array==null?0:array.length;while(++index<length){if(!predicate(array[index],index,array)){return false}}return true}function arrayFilter(array,predicate){var index=-1,length=array==null?0:array.length,resIndex=0,result=[];while(++index<length){var value=array[index];if(predicate(value,index,array)){result[resIndex++]=value}}return result}function arrayIncludes(array,value){var length=array==null?0:array.length;return!!length&&baseIndexOf(array,value,0)>-1}function arrayIncludesWith(array,value,comparator){var index=-1,length=array==null?0:array.length;while(++index<length){if(comparator(value,array[index])){return true}}return false}function arrayMap(array,iteratee){var index=-1,length=array==null?0:array.length,result=Array(length);while(++index<length){result[index]=iteratee(array[index],index,array)}return result}function arrayPush(array,values){var index=-1,length=values.length,offset=array.length;while(++index<length){array[offset+index]=values[index]}return array}function arrayReduce(array,iteratee,accumulator,initAccum){var index=-1,length=array==null?0:array.length;if(initAccum&&length){accumulator=array[++index]}while(++index<length){accumulator=iteratee(accumulator,array[index],index,array)}return accumulator}function arrayReduceRight(array,iteratee,accumulator,initAccum){var length=array==null?0:array.length;if(initAccum&&length){accumulator=array[--length]}while(length--){accumulator=iteratee(accumulator,array[length],length,array)}return accumulator}function arraySome(array,predicate){var index=-1,length=array==null?0:array.length;while(++index<length){if(predicate(array[index],index,array)){return true}}return false}var asciiSize=baseProperty("length");function asciiToArray(string){return string.split("")}function asciiWords(string){return string.match(reAsciiWord)||[]}function baseFindKey(collection,predicate,eachFunc){var result;eachFunc(collection,(function(value,key,collection){if(predicate(value,key,collection)){result=key;return false}}));return result}function baseFindIndex(array,predicate,fromIndex,fromRight){var length=array.length,index=fromIndex+(fromRight?1:-1);while(fromRight?index--:++index<length){if(predicate(array[index],index,array)){return index}}return-1}function baseIndexOf(array,value,fromIndex){return value===value?strictIndexOf(array,value,fromIndex):baseFindIndex(array,baseIsNaN,fromIndex)}function baseIndexOfWith(array,value,fromIndex,comparator){var index=fromIndex-1,length=array.length;while(++index<length){if(comparator(array[index],value)){return index}}return-1}function baseIsNaN(value){return value!==value}function baseMean(array,iteratee){var length=array==null?0:array.length;return length?baseSum(array,iteratee)/length:NAN}function baseProperty(key){return function(object){return object==null?undefined:object[key]}}function basePropertyOf(object){return function(key){return object==null?undefined:object[key]}}function baseReduce(collection,iteratee,accumulator,initAccum,eachFunc){eachFunc(collection,(function(value,index,collection){accumulator=initAccum?(initAccum=false,value):iteratee(accumulator,value,index,collection)}));return accumulator}function baseSortBy(array,comparer){var length=array.length;array.sort(comparer);while(length--){array[length]=array[length].value}return array}function baseSum(array,iteratee){var result,index=-1,length=array.length;while(++index<length){var current=iteratee(array[index]);if(current!==undefined){result=result===undefined?current:result+current}}return result}function baseTimes(n,iteratee){var index=-1,result=Array(n);while(++index<n){result[index]=iteratee(index)}return result}function baseToPairs(object,props){return arrayMap(props,(function(key){return[key,object[key]]}))}function baseUnary(func){return function(value){return func(value)}}function baseValues(object,props){return arrayMap(props,(function(key){return object[key]}))}function cacheHas(cache,key){return cache.has(key)}function charsStartIndex(strSymbols,chrSymbols){var index=-1,length=strSymbols.length;while(++index<length&&baseIndexOf(chrSymbols,strSymbols[index],0)>-1){}return index}function charsEndIndex(strSymbols,chrSymbols){var index=strSymbols.length;while(index--&&baseIndexOf(chrSymbols,strSymbols[index],0)>-1){}return index}function countHolders(array,placeholder){var length=array.length,result=0;while(length--){if(array[length]===placeholder){++result}}return result}var deburrLetter=basePropertyOf(deburredLetters);var escapeHtmlChar=basePropertyOf(htmlEscapes);function escapeStringChar(chr){return"\\"+stringEscapes[chr]}function getValue(object,key){return object==null?undefined:object[key]}function hasUnicode(string){return reHasUnicode.test(string)}function hasUnicodeWord(string){return reHasUnicodeWord.test(string)}function iteratorToArray(iterator){var data,result=[];while(!(data=iterator.next()).done){result.push(data.value)}return result}function mapToArray(map){var index=-1,result=Array(map.size);map.forEach((function(value,key){result[++index]=[key,value]}));return result}function overArg(func,transform){return function(arg){return func(transform(arg))}}function replaceHolders(array,placeholder){var index=-1,length=array.length,resIndex=0,result=[];while(++index<length){var value=array[index];if(value===placeholder||value===PLACEHOLDER){array[index]=PLACEHOLDER;result[resIndex++]=index}}return result}function safeGet(object,key){return key=="__proto__"?undefined:object[key]}function setToArray(set){var index=-1,result=Array(set.size);set.forEach((function(value){result[++index]=value}));return result}function setToPairs(set){var index=-1,result=Array(set.size);set.forEach((function(value){result[++index]=[value,value]}));return result}function strictIndexOf(array,value,fromIndex){var index=fromIndex-1,length=array.length;while(++index<length){if(array[index]===value){return index}}return-1}function strictLastIndexOf(array,value,fromIndex){var index=fromIndex+1;while(index--){if(array[index]===value){return index}}return index}function stringSize(string){return hasUnicode(string)?unicodeSize(string):asciiSize(string)}function stringToArray(string){return hasUnicode(string)?unicodeToArray(string):asciiToArray(string)}var unescapeHtmlChar=basePropertyOf(htmlUnescapes);function unicodeSize(string){var result=reUnicode.lastIndex=0;while(reUnicode.test(string)){++result}return result}function unicodeToArray(string){return string.match(reUnicode)||[]}function unicodeWords(string){return string.match(reUnicodeWord)||[]}var runInContext=function runInContext(context){context=context==null?root:_.defaults(root.Object(),context,_.pick(root,contextProps));var Array=context.Array,Date=context.Date,Error=context.Error,Function=context.Function,Math=context.Math,Object=context.Object,RegExp=context.RegExp,String=context.String,TypeError=context.TypeError;var arrayProto=Array.prototype,funcProto=Function.prototype,objectProto=Object.prototype;var coreJsData=context["__core-js_shared__"];var funcToString=funcProto.toString;var hasOwnProperty=objectProto.hasOwnProperty;var idCounter=0;var maskSrcKey=function(){var uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||"");return uid?"Symbol(src)_1."+uid:""}();var nativeObjectToString=objectProto.toString;var objectCtorString=funcToString.call(Object);var oldDash=root._;var reIsNative=RegExp("^"+funcToString.call(hasOwnProperty).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Buffer=moduleExports?context.Buffer:undefined,Symbol=context.Symbol,Uint8Array=context.Uint8Array,allocUnsafe=Buffer?Buffer.allocUnsafe:undefined,getPrototype=overArg(Object.getPrototypeOf,Object),objectCreate=Object.create,propertyIsEnumerable=objectProto.propertyIsEnumerable,splice=arrayProto.splice,spreadableSymbol=Symbol?Symbol.isConcatSpreadable:undefined,symIterator=Symbol?Symbol.iterator:undefined,symToStringTag=Symbol?Symbol.toStringTag:undefined;var defineProperty=function(){try{var func=getNative(Object,"defineProperty");func({},"",{});return func}catch(e){}}();var ctxClearTimeout=context.clearTimeout!==root.clearTimeout&&context.clearTimeout,ctxNow=Date&&Date.now!==root.Date.now&&Date.now,ctxSetTimeout=context.setTimeout!==root.setTimeout&&context.setTimeout;var nativeCeil=Math.ceil,nativeFloor=Math.floor,nativeGetSymbols=Object.getOwnPropertySymbols,nativeIsBuffer=Buffer?Buffer.isBuffer:undefined,nativeIsFinite=context.isFinite,nativeJoin=arrayProto.join,nativeKeys=overArg(Object.keys,Object),nativeMax=Math.max,nativeMin=Math.min,nativeNow=Date.now,nativeParseInt=context.parseInt,nativeRandom=Math.random,nativeReverse=arrayProto.reverse;var DataView=getNative(context,"DataView"),Map=getNative(context,"Map"),Promise=getNative(context,"Promise"),Set=getNative(context,"Set"),WeakMap=getNative(context,"WeakMap"),nativeCreate=getNative(Object,"create");var metaMap=WeakMap&&new WeakMap;var realNames={};var dataViewCtorString=toSource(DataView),mapCtorString=toSource(Map),promiseCtorString=toSource(Promise),setCtorString=toSource(Set),weakMapCtorString=toSource(WeakMap);var symbolProto=Symbol?Symbol.prototype:undefined,symbolValueOf=symbolProto?symbolProto.valueOf:undefined,symbolToString=symbolProto?symbolProto.toString:undefined;function lodash(value){if(isObjectLike(value)&&!isArray(value)&&!(value instanceof LazyWrapper)){if(value instanceof LodashWrapper){return value}if(hasOwnProperty.call(value,"__wrapped__")){return wrapperClone(value)}}return new LodashWrapper(value)}var baseCreate=function(){function object(){}return function(proto){if(!isObject(proto)){return{}}if(objectCreate){return objectCreate(proto)}object.prototype=proto;var result=new object;object.prototype=undefined;return result}}();function baseLodash(){}function LodashWrapper(value,chainAll){this.__wrapped__=value;this.__actions__=[];this.__chain__=!!chainAll;this.__index__=0;this.__values__=undefined}lodash.templateSettings={escape:reEscape,evaluate:reEvaluate,interpolate:reInterpolate,variable:"",imports:{_:lodash}};lodash.prototype=baseLodash.prototype;lodash.prototype.constructor=lodash;LodashWrapper.prototype=baseCreate(baseLodash.prototype);LodashWrapper.prototype.constructor=LodashWrapper;function LazyWrapper(value){this.__wrapped__=value;this.__actions__=[];this.__dir__=1;this.__filtered__=false;this.__iteratees__=[];this.__takeCount__=MAX_ARRAY_LENGTH;this.__views__=[]}function lazyClone(){var result=new LazyWrapper(this.__wrapped__);result.__actions__=copyArray(this.__actions__);result.__dir__=this.__dir__;result.__filtered__=this.__filtered__;result.__iteratees__=copyArray(this.__iteratees__);result.__takeCount__=this.__takeCount__;result.__views__=copyArray(this.__views__);return result}function lazyReverse(){if(this.__filtered__){var result=new LazyWrapper(this);result.__dir__=-1;result.__filtered__=true}else{result=this.clone();result.__dir__*=-1}return result}function lazyValue(){var array=this.__wrapped__.value(),dir=this.__dir__,isArr=isArray(array),isRight=dir<0,arrLength=isArr?array.length:0,view=getView(0,arrLength,this.__views__),start=view.start,end=view.end,length=end-start,index=isRight?end:start-1,iteratees=this.__iteratees__,iterLength=iteratees.length,resIndex=0,takeCount=nativeMin(length,this.__takeCount__);if(!isArr||!isRight&&arrLength==length&&takeCount==length){return baseWrapperValue(array,this.__actions__)}var result=[];outer:while(length--&&resIndex<takeCount){index+=dir;var iterIndex=-1,value=array[index];while(++iterIndex<iterLength){var data=iteratees[iterIndex],iteratee=data.iteratee,type=data.type,computed=iteratee(value);if(type==LAZY_MAP_FLAG){value=computed}else if(!computed){if(type==LAZY_FILTER_FLAG){continue outer}else{break outer}}}result[resIndex++]=value}return result}LazyWrapper.prototype=baseCreate(baseLodash.prototype);LazyWrapper.prototype.constructor=LazyWrapper;function Hash(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function hashClear(){this.__data__=nativeCreate?nativeCreate(null):{};this.size=0}function hashDelete(key){var result=this.has(key)&&delete this.__data__[key];this.size-=result?1:0;return result}function hashGet(key){var data=this.__data__;if(nativeCreate){var result=data[key];return result===HASH_UNDEFINED?undefined:result}return hasOwnProperty.call(data,key)?data[key]:undefined}function hashHas(key){var data=this.__data__;return nativeCreate?data[key]!==undefined:hasOwnProperty.call(data,key)}function hashSet(key,value){var data=this.__data__;this.size+=this.has(key)?0:1;data[key]=nativeCreate&&value===undefined?HASH_UNDEFINED:value;return this}Hash.prototype.clear=hashClear;Hash.prototype["delete"]=hashDelete;Hash.prototype.get=hashGet;Hash.prototype.has=hashHas;Hash.prototype.set=hashSet;function ListCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function listCacheClear(){this.__data__=[];this.size=0}function listCacheDelete(key){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){return false}var lastIndex=data.length-1;if(index==lastIndex){data.pop()}else{splice.call(data,index,1)}--this.size;return true}function listCacheGet(key){var data=this.__data__,index=assocIndexOf(data,key);return index<0?undefined:data[index][1]}function listCacheHas(key){return assocIndexOf(this.__data__,key)>-1}function listCacheSet(key,value){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){++this.size;data.push([key,value])}else{data[index][1]=value}return this}ListCache.prototype.clear=listCacheClear;ListCache.prototype["delete"]=listCacheDelete;ListCache.prototype.get=listCacheGet;ListCache.prototype.has=listCacheHas;ListCache.prototype.set=listCacheSet;function MapCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}function mapCacheClear(){this.size=0;this.__data__={hash:new Hash,map:new(Map||ListCache),string:new Hash}}function mapCacheDelete(key){var result=getMapData(this,key)["delete"](key);this.size-=result?1:0;return result}function mapCacheGet(key){return getMapData(this,key).get(key)}function mapCacheHas(key){return getMapData(this,key).has(key)}function mapCacheSet(key,value){var data=getMapData(this,key),size=data.size;data.set(key,value);this.size+=data.size==size?0:1;return this}MapCache.prototype.clear=mapCacheClear;MapCache.prototype["delete"]=mapCacheDelete;MapCache.prototype.get=mapCacheGet;MapCache.prototype.has=mapCacheHas;MapCache.prototype.set=mapCacheSet;function SetCache(values){var index=-1,length=values==null?0:values.length;this.__data__=new MapCache;while(++index<length){this.add(values[index])}}function setCacheAdd(value){this.__data__.set(value,HASH_UNDEFINED);return this}function setCacheHas(value){return this.__data__.has(value)}SetCache.prototype.add=SetCache.prototype.push=setCacheAdd;SetCache.prototype.has=setCacheHas;function Stack(entries){var data=this.__data__=new ListCache(entries);this.size=data.size}function stackClear(){this.__data__=new ListCache;this.size=0}function stackDelete(key){var data=this.__data__,result=data["delete"](key);this.size=data.size;return result}function stackGet(key){return this.__data__.get(key)}function stackHas(key){return this.__data__.has(key)}function stackSet(key,value){var data=this.__data__;if(data instanceof ListCache){var pairs=data.__data__;if(!Map||pairs.length<LARGE_ARRAY_SIZE-1){pairs.push([key,value]);this.size=++data.size;return this}data=this.__data__=new MapCache(pairs)}data.set(key,value);this.size=data.size;return this}Stack.prototype.clear=stackClear;Stack.prototype["delete"]=stackDelete;Stack.prototype.get=stackGet;Stack.prototype.has=stackHas;Stack.prototype.set=stackSet;function arrayLikeKeys(value,inherited){var isArr=isArray(value),isArg=!isArr&&isArguments(value),isBuff=!isArr&&!isArg&&isBuffer(value),isType=!isArr&&!isArg&&!isBuff&&isTypedArray(value),skipIndexes=isArr||isArg||isBuff||isType,result=skipIndexes?baseTimes(value.length,String):[],length=result.length;for(var key in value){if((inherited||hasOwnProperty.call(value,key))&&!(skipIndexes&&(key=="length"||isBuff&&(key=="offset"||key=="parent")||isType&&(key=="buffer"||key=="byteLength"||key=="byteOffset")||isIndex(key,length)))){result.push(key)}}return result}function arraySample(array){var length=array.length;return length?array[baseRandom(0,length-1)]:undefined}function arraySampleSize(array,n){return shuffleSelf(copyArray(array),baseClamp(n,0,array.length))}function arrayShuffle(array){return shuffleSelf(copyArray(array))}function assignMergeValue(object,key,value){if(value!==undefined&&!eq(object[key],value)||value===undefined&&!(key in object)){baseAssignValue(object,key,value)}}function assignValue(object,key,value){var objValue=object[key];if(!(hasOwnProperty.call(object,key)&&eq(objValue,value))||value===undefined&&!(key in object)){baseAssignValue(object,key,value)}}function assocIndexOf(array,key){var length=array.length;while(length--){if(eq(array[length][0],key)){return length}}return-1}function baseAggregator(collection,setter,iteratee,accumulator){baseEach(collection,(function(value,key,collection){setter(accumulator,value,iteratee(value),collection)}));return accumulator}function baseAssign(object,source){return object&&copyObject(source,keys(source),object)}function baseAssignIn(object,source){return object&&copyObject(source,keysIn(source),object)}function baseAssignValue(object,key,value){if(key=="__proto__"&&defineProperty){defineProperty(object,key,{configurable:true,enumerable:true,value,writable:true})}else{object[key]=value}}function baseAt(object,paths){var index=-1,length=paths.length,result=Array(length),skip=object==null;while(++index<length){result[index]=skip?undefined:get(object,paths[index])}return result}function baseClamp(number,lower,upper){if(number===number){if(upper!==undefined){number=number<=upper?number:upper}if(lower!==undefined){number=number>=lower?number:lower}}return number}function baseClone(value,bitmask,customizer,key,object,stack){var result,isDeep=bitmask&CLONE_DEEP_FLAG,isFlat=bitmask&CLONE_FLAT_FLAG,isFull=bitmask&CLONE_SYMBOLS_FLAG;if(customizer){result=object?customizer(value,key,object,stack):customizer(value)}if(result!==undefined){return result}if(!isObject(value)){return value}var isArr=isArray(value);if(isArr){result=initCloneArray(value);if(!isDeep){return copyArray(value,result)}}else{var tag=getTag(value),isFunc=tag==funcTag||tag==genTag;if(isBuffer(value)){return cloneBuffer(value,isDeep)}if(tag==objectTag||tag==argsTag||isFunc&&!object){result=isFlat||isFunc?{}:initCloneObject(value);if(!isDeep){return isFlat?copySymbolsIn(value,baseAssignIn(result,value)):copySymbols(value,baseAssign(result,value))}}else{if(!cloneableTags[tag]){return object?value:{}}result=initCloneByTag(value,tag,isDeep)}}stack||(stack=new Stack);var stacked=stack.get(value);if(stacked){return stacked}stack.set(value,result);if(isSet(value)){value.forEach((function(subValue){result.add(baseClone(subValue,bitmask,customizer,subValue,value,stack))}));return result}if(isMap(value)){value.forEach((function(subValue,key){result.set(key,baseClone(subValue,bitmask,customizer,key,value,stack))}));return result}var keysFunc=isFull?isFlat?getAllKeysIn:getAllKeys:isFlat?keysIn:keys;var props=isArr?undefined:keysFunc(value);arrayEach(props||value,(function(subValue,key){if(props){key=subValue;subValue=value[key]}assignValue(result,key,baseClone(subValue,bitmask,customizer,key,value,stack))}));return result}function baseConforms(source){var props=keys(source);return function(object){return baseConformsTo(object,source,props)}}function baseConformsTo(object,source,props){var length=props.length;if(object==null){return!length}object=Object(object);while(length--){var key=props[length],predicate=source[key],value=object[key];if(value===undefined&&!(key in object)||!predicate(value)){return false}}return true}function baseDelay(func,wait,args){if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}return setTimeout((function(){func.apply(undefined,args)}),wait)}function baseDifference(array,values,iteratee,comparator){var index=-1,includes=arrayIncludes,isCommon=true,length=array.length,result=[],valuesLength=values.length;if(!length){return result}if(iteratee){values=arrayMap(values,baseUnary(iteratee))}if(comparator){includes=arrayIncludesWith;isCommon=false}else if(values.length>=LARGE_ARRAY_SIZE){includes=cacheHas;isCommon=false;values=new SetCache(values)}outer:while(++index<length){var value=array[index],computed=iteratee==null?value:iteratee(value);value=comparator||value!==0?value:0;if(isCommon&&computed===computed){var valuesIndex=valuesLength;while(valuesIndex--){if(values[valuesIndex]===computed){continue outer}}result.push(value)}else if(!includes(values,computed,comparator)){result.push(value)}}return result}var baseEach=createBaseEach(baseForOwn);var baseEachRight=createBaseEach(baseForOwnRight,true);function baseEvery(collection,predicate){var result=true;baseEach(collection,(function(value,index,collection){result=!!predicate(value,index,collection);return result}));return result}function baseExtremum(array,iteratee,comparator){var index=-1,length=array.length;while(++index<length){var value=array[index],current=iteratee(value);if(current!=null&&(computed===undefined?current===current&&!isSymbol(current):comparator(current,computed))){var computed=current,result=value}}return result}function baseFill(array,value,start,end){var length=array.length;start=toInteger(start);if(start<0){start=-start>length?0:length+start}end=end===undefined||end>length?length:toInteger(end);if(end<0){end+=length}end=start>end?0:toLength(end);while(start<end){array[start++]=value}return array}function baseFilter(collection,predicate){var result=[];baseEach(collection,(function(value,index,collection){if(predicate(value,index,collection)){result.push(value)}}));return result}function baseFlatten(array,depth,predicate,isStrict,result){var index=-1,length=array.length;predicate||(predicate=isFlattenable);result||(result=[]);while(++index<length){var value=array[index];if(depth>0&&predicate(value)){if(depth>1){baseFlatten(value,depth-1,predicate,isStrict,result)}else{arrayPush(result,value)}}else if(!isStrict){result[result.length]=value}}return result}var baseFor=createBaseFor();var baseForRight=createBaseFor(true);function baseForOwn(object,iteratee){return object&&baseFor(object,iteratee,keys)}function baseForOwnRight(object,iteratee){return object&&baseForRight(object,iteratee,keys)}function baseFunctions(object,props){return arrayFilter(props,(function(key){return isFunction(object[key])}))}function baseGet(object,path){path=castPath(path,object);var index=0,length=path.length;while(object!=null&&index<length){object=object[toKey(path[index++])]}return index&&index==length?object:undefined}function baseGetAllKeys(object,keysFunc,symbolsFunc){var result=keysFunc(object);return isArray(object)?result:arrayPush(result,symbolsFunc(object))}function baseGetTag(value){if(value==null){return value===undefined?undefinedTag:nullTag}return symToStringTag&&symToStringTag in Object(value)?getRawTag(value):objectToString(value)}function baseGt(value,other){return value>other}function baseHas(object,key){return object!=null&&hasOwnProperty.call(object,key)}function baseHasIn(object,key){return object!=null&&key in Object(object)}function baseInRange(number,start,end){return number>=nativeMin(start,end)&&number<nativeMax(start,end)}function baseIntersection(arrays,iteratee,comparator){var includes=comparator?arrayIncludesWith:arrayIncludes,length=arrays[0].length,othLength=arrays.length,othIndex=othLength,caches=Array(othLength),maxLength=Infinity,result=[];while(othIndex--){var array=arrays[othIndex];if(othIndex&&iteratee){array=arrayMap(array,baseUnary(iteratee))}maxLength=nativeMin(array.length,maxLength);caches[othIndex]=!comparator&&(iteratee||length>=120&&array.length>=120)?new SetCache(othIndex&&array):undefined}array=arrays[0];var index=-1,seen=caches[0];outer:while(++index<length&&result.length<maxLength){var value=array[index],computed=iteratee?iteratee(value):value;value=comparator||value!==0?value:0;if(!(seen?cacheHas(seen,computed):includes(result,computed,comparator))){othIndex=othLength;while(--othIndex){var cache=caches[othIndex];if(!(cache?cacheHas(cache,computed):includes(arrays[othIndex],computed,comparator))){continue outer}}if(seen){seen.push(computed)}result.push(value)}}return result}function baseInverter(object,setter,iteratee,accumulator){baseForOwn(object,(function(value,key,object){setter(accumulator,iteratee(value),key,object)}));return accumulator}function baseInvoke(object,path,args){path=castPath(path,object);object=parent(object,path);var func=object==null?object:object[toKey(last(path))];return func==null?undefined:apply(func,object,args)}function baseIsArguments(value){return isObjectLike(value)&&baseGetTag(value)==argsTag}function baseIsArrayBuffer(value){return isObjectLike(value)&&baseGetTag(value)==arrayBufferTag}function baseIsDate(value){return isObjectLike(value)&&baseGetTag(value)==dateTag}function baseIsEqual(value,other,bitmask,customizer,stack){if(value===other){return true}if(value==null||other==null||!isObjectLike(value)&&!isObjectLike(other)){return value!==value&&other!==other}return baseIsEqualDeep(value,other,bitmask,customizer,baseIsEqual,stack)}function baseIsEqualDeep(object,other,bitmask,customizer,equalFunc,stack){var objIsArr=isArray(object),othIsArr=isArray(other),objTag=objIsArr?arrayTag:getTag(object),othTag=othIsArr?arrayTag:getTag(other);objTag=objTag==argsTag?objectTag:objTag;othTag=othTag==argsTag?objectTag:othTag;var objIsObj=objTag==objectTag,othIsObj=othTag==objectTag,isSameTag=objTag==othTag;if(isSameTag&&isBuffer(object)){if(!isBuffer(other)){return false}objIsArr=true;objIsObj=false}if(isSameTag&&!objIsObj){stack||(stack=new Stack);return objIsArr||isTypedArray(object)?equalArrays(object,other,bitmask,customizer,equalFunc,stack):equalByTag(object,other,objTag,bitmask,customizer,equalFunc,stack)}if(!(bitmask&COMPARE_PARTIAL_FLAG)){var objIsWrapped=objIsObj&&hasOwnProperty.call(object,"__wrapped__"),othIsWrapped=othIsObj&&hasOwnProperty.call(other,"__wrapped__");if(objIsWrapped||othIsWrapped){var objUnwrapped=objIsWrapped?object.value():object,othUnwrapped=othIsWrapped?other.value():other;stack||(stack=new Stack);return equalFunc(objUnwrapped,othUnwrapped,bitmask,customizer,stack)}}if(!isSameTag){return false}stack||(stack=new Stack);return equalObjects(object,other,bitmask,customizer,equalFunc,stack)}function baseIsMap(value){return isObjectLike(value)&&getTag(value)==mapTag}function baseIsMatch(object,source,matchData,customizer){var index=matchData.length,length=index,noCustomizer=!customizer;if(object==null){return!length}object=Object(object);while(index--){var data=matchData[index];if(noCustomizer&&data[2]?data[1]!==object[data[0]]:!(data[0]in object)){return false}}while(++index<length){data=matchData[index];var key=data[0],objValue=object[key],srcValue=data[1];if(noCustomizer&&data[2]){if(objValue===undefined&&!(key in object)){return false}}else{var stack=new Stack;if(customizer){var result=customizer(objValue,srcValue,key,object,source,stack)}if(!(result===undefined?baseIsEqual(srcValue,objValue,COMPARE_PARTIAL_FLAG|COMPARE_UNORDERED_FLAG,customizer,stack):result)){return false}}}return true}function baseIsNative(value){if(!isObject(value)||isMasked(value)){return false}var pattern=isFunction(value)?reIsNative:reIsHostCtor;return pattern.test(toSource(value))}function baseIsRegExp(value){return isObjectLike(value)&&baseGetTag(value)==regexpTag}function baseIsSet(value){return isObjectLike(value)&&getTag(value)==setTag}function baseIsTypedArray(value){return isObjectLike(value)&&isLength(value.length)&&!!typedArrayTags[baseGetTag(value)]}function baseIteratee(value){if(typeof value=="function"){return value}if(value==null){return identity}if(typeof value=="object"){return isArray(value)?baseMatchesProperty(value[0],value[1]):baseMatches(value)}return property(value)}function baseKeys(object){if(!isPrototype(object)){return nativeKeys(object)}var result=[];for(var key in Object(object)){if(hasOwnProperty.call(object,key)&&key!="constructor"){result.push(key)}}return result}function baseKeysIn(object){if(!isObject(object)){return nativeKeysIn(object)}var isProto=isPrototype(object),result=[];for(var key in object){if(!(key=="constructor"&&(isProto||!hasOwnProperty.call(object,key)))){result.push(key)}}return result}function baseLt(value,other){return value<other}function baseMap(collection,iteratee){var index=-1,result=isArrayLike(collection)?Array(collection.length):[];baseEach(collection,(function(value,key,collection){result[++index]=iteratee(value,key,collection)}));return result}function baseMatches(source){var matchData=getMatchData(source);if(matchData.length==1&&matchData[0][2]){return matchesStrictComparable(matchData[0][0],matchData[0][1])}return function(object){return object===source||baseIsMatch(object,source,matchData)}}function baseMatchesProperty(path,srcValue){if(isKey(path)&&isStrictComparable(srcValue)){return matchesStrictComparable(toKey(path),srcValue)}return function(object){var objValue=get(object,path);return objValue===undefined&&objValue===srcValue?hasIn(object,path):baseIsEqual(srcValue,objValue,COMPARE_PARTIAL_FLAG|COMPARE_UNORDERED_FLAG)}}function baseMerge(object,source,srcIndex,customizer,stack){if(object===source){return}baseFor(source,(function(srcValue,key){if(isObject(srcValue)){stack||(stack=new Stack);baseMergeDeep(object,source,key,srcIndex,baseMerge,customizer,stack)}else{var newValue=customizer?customizer(safeGet(object,key),srcValue,key+"",object,source,stack):undefined;if(newValue===undefined){newValue=srcValue}assignMergeValue(object,key,newValue)}}),keysIn)}function baseMergeDeep(object,source,key,srcIndex,mergeFunc,customizer,stack){var objValue=safeGet(object,key),srcValue=safeGet(source,key),stacked=stack.get(srcValue);if(stacked){assignMergeValue(object,key,stacked);return}var newValue=customizer?customizer(objValue,srcValue,key+"",object,source,stack):undefined;var isCommon=newValue===undefined;if(isCommon){var isArr=isArray(srcValue),isBuff=!isArr&&isBuffer(srcValue),isTyped=!isArr&&!isBuff&&isTypedArray(srcValue);newValue=srcValue;if(isArr||isBuff||isTyped){if(isArray(objValue)){newValue=objValue}else if(isArrayLikeObject(objValue)){newValue=copyArray(objValue)}else if(isBuff){isCommon=false;newValue=cloneBuffer(srcValue,true)}else if(isTyped){isCommon=false;newValue=cloneTypedArray(srcValue,true)}else{newValue=[]}}else if(isPlainObject(srcValue)||isArguments(srcValue)){newValue=objValue;if(isArguments(objValue)){newValue=toPlainObject(objValue)}else if(!isObject(objValue)||srcIndex&&isFunction(objValue)){newValue=initCloneObject(srcValue)}}else{isCommon=false}}if(isCommon){stack.set(srcValue,newValue);mergeFunc(newValue,srcValue,srcIndex,customizer,stack);stack["delete"](srcValue)}assignMergeValue(object,key,newValue)}function baseNth(array,n){var length=array.length;if(!length){return}n+=n<0?length:0;return isIndex(n,length)?array[n]:undefined}function baseOrderBy(collection,iteratees,orders){var index=-1;iteratees=arrayMap(iteratees.length?iteratees:[identity],baseUnary(getIteratee()));var result=baseMap(collection,(function(value,key,collection){var criteria=arrayMap(iteratees,(function(iteratee){return iteratee(value)}));return{criteria,index:++index,value}}));return baseSortBy(result,(function(object,other){return compareMultiple(object,other,orders)}))}function basePick(object,paths){return basePickBy(object,paths,(function(value,path){return hasIn(object,path)}))}function basePickBy(object,paths,predicate){var index=-1,length=paths.length,result={};while(++index<length){var path=paths[index],value=baseGet(object,path);if(predicate(value,path)){baseSet(result,castPath(path,object),value)}}return result}function basePropertyDeep(path){return function(object){return baseGet(object,path)}}function basePullAll(array,values,iteratee,comparator){var indexOf=comparator?baseIndexOfWith:baseIndexOf,index=-1,length=values.length,seen=array;if(array===values){values=copyArray(values)}if(iteratee){seen=arrayMap(array,baseUnary(iteratee))}while(++index<length){var fromIndex=0,value=values[index],computed=iteratee?iteratee(value):value;while((fromIndex=indexOf(seen,computed,fromIndex,comparator))>-1){if(seen!==array){splice.call(seen,fromIndex,1)}splice.call(array,fromIndex,1)}}return array}function basePullAt(array,indexes){var length=array?indexes.length:0,lastIndex=length-1;while(length--){var index=indexes[length];if(length==lastIndex||index!==previous){var previous=index;if(isIndex(index)){splice.call(array,index,1)}else{baseUnset(array,index)}}}return array}function baseRandom(lower,upper){return lower+nativeFloor(nativeRandom()*(upper-lower+1))}function baseRange(start,end,step,fromRight){var index=-1,length=nativeMax(nativeCeil((end-start)/(step||1)),0),result=Array(length);while(length--){result[fromRight?length:++index]=start;start+=step}return result}function baseRepeat(string,n){var result="";if(!string||n<1||n>MAX_SAFE_INTEGER){return result}do{if(n%2){result+=string}n=nativeFloor(n/2);if(n){string+=string}}while(n);return result}function baseRest(func,start){return setToString(overRest(func,start,identity),func+"")}function baseSample(collection){return arraySample(values(collection))}function baseSampleSize(collection,n){var array=values(collection);return shuffleSelf(array,baseClamp(n,0,array.length))}function baseSet(object,path,value,customizer){if(!isObject(object)){return object}path=castPath(path,object);var index=-1,length=path.length,lastIndex=length-1,nested=object;while(nested!=null&&++index<length){var key=toKey(path[index]),newValue=value;if(index!=lastIndex){var objValue=nested[key];newValue=customizer?customizer(objValue,key,nested):undefined;if(newValue===undefined){newValue=isObject(objValue)?objValue:isIndex(path[index+1])?[]:{}}}assignValue(nested,key,newValue);nested=nested[key]}return object}var baseSetData=!metaMap?identity:function(func,data){metaMap.set(func,data);return func};var baseSetToString=!defineProperty?identity:function(func,string){return defineProperty(func,"toString",{configurable:true,enumerable:false,value:constant(string),writable:true})};function baseShuffle(collection){return shuffleSelf(values(collection))}function baseSlice(array,start,end){var index=-1,length=array.length;if(start<0){start=-start>length?0:length+start}end=end>length?length:end;if(end<0){end+=length}length=start>end?0:end-start>>>0;start>>>=0;var result=Array(length);while(++index<length){result[index]=array[index+start]}return result}function baseSome(collection,predicate){var result;baseEach(collection,(function(value,index,collection){result=predicate(value,index,collection);return!result}));return!!result}function baseSortedIndex(array,value,retHighest){var low=0,high=array==null?low:array.length;if(typeof value=="number"&&value===value&&high<=HALF_MAX_ARRAY_LENGTH){while(low<high){var mid=low+high>>>1,computed=array[mid];if(computed!==null&&!isSymbol(computed)&&(retHighest?computed<=value:computed<value)){low=mid+1}else{high=mid}}return high}return baseSortedIndexBy(array,value,identity,retHighest)}function baseSortedIndexBy(array,value,iteratee,retHighest){value=iteratee(value);var low=0,high=array==null?0:array.length,valIsNaN=value!==value,valIsNull=value===null,valIsSymbol=isSymbol(value),valIsUndefined=value===undefined;while(low<high){var mid=nativeFloor((low+high)/2),computed=iteratee(array[mid]),othIsDefined=computed!==undefined,othIsNull=computed===null,othIsReflexive=computed===computed,othIsSymbol=isSymbol(computed);if(valIsNaN){var setLow=retHighest||othIsReflexive}else if(valIsUndefined){setLow=othIsReflexive&&(retHighest||othIsDefined)}else if(valIsNull){setLow=othIsReflexive&&othIsDefined&&(retHighest||!othIsNull)}else if(valIsSymbol){setLow=othIsReflexive&&othIsDefined&&!othIsNull&&(retHighest||!othIsSymbol)}else if(othIsNull||othIsSymbol){setLow=false}else{setLow=retHighest?computed<=value:computed<value}if(setLow){low=mid+1}else{high=mid}}return nativeMin(high,MAX_ARRAY_INDEX)}function baseSortedUniq(array,iteratee){var index=-1,length=array.length,resIndex=0,result=[];while(++index<length){var value=array[index],computed=iteratee?iteratee(value):value;if(!index||!eq(computed,seen)){var seen=computed;result[resIndex++]=value===0?0:value}}return result}function baseToNumber(value){if(typeof value=="number"){return value}if(isSymbol(value)){return NAN}return+value}function baseToString(value){if(typeof value=="string"){return value}if(isArray(value)){return arrayMap(value,baseToString)+""}if(isSymbol(value)){return symbolToString?symbolToString.call(value):""}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}function baseUniq(array,iteratee,comparator){var index=-1,includes=arrayIncludes,length=array.length,isCommon=true,result=[],seen=result;if(comparator){isCommon=false;includes=arrayIncludesWith}else if(length>=LARGE_ARRAY_SIZE){var set=iteratee?null:createSet(array);if(set){return setToArray(set)}isCommon=false;includes=cacheHas;seen=new SetCache}else{seen=iteratee?[]:result}outer:while(++index<length){var value=array[index],computed=iteratee?iteratee(value):value;value=comparator||value!==0?value:0;if(isCommon&&computed===computed){var seenIndex=seen.length;while(seenIndex--){if(seen[seenIndex]===computed){continue outer}}if(iteratee){seen.push(computed)}result.push(value)}else if(!includes(seen,computed,comparator)){if(seen!==result){seen.push(computed)}result.push(value)}}return result}function baseUnset(object,path){path=castPath(path,object);object=parent(object,path);return object==null||delete object[toKey(last(path))]}function baseUpdate(object,path,updater,customizer){return baseSet(object,path,updater(baseGet(object,path)),customizer)}function baseWhile(array,predicate,isDrop,fromRight){var length=array.length,index=fromRight?length:-1;while((fromRight?index--:++index<length)&&predicate(array[index],index,array)){}return isDrop?baseSlice(array,fromRight?0:index,fromRight?index+1:length):baseSlice(array,fromRight?index+1:0,fromRight?length:index)}function baseWrapperValue(value,actions){var result=value;if(result instanceof LazyWrapper){result=result.value()}return arrayReduce(actions,(function(result,action){return action.func.apply(action.thisArg,arrayPush([result],action.args))}),result)}function baseXor(arrays,iteratee,comparator){var length=arrays.length;if(length<2){return length?baseUniq(arrays[0]):[]}var index=-1,result=Array(length);while(++index<length){var array=arrays[index],othIndex=-1;while(++othIndex<length){if(othIndex!=index){result[index]=baseDifference(result[index]||array,arrays[othIndex],iteratee,comparator)}}}return baseUniq(baseFlatten(result,1),iteratee,comparator)}function baseZipObject(props,values,assignFunc){var index=-1,length=props.length,valsLength=values.length,result={};while(++index<length){var value=index<valsLength?values[index]:undefined;assignFunc(result,props[index],value)}return result}function castArrayLikeObject(value){return isArrayLikeObject(value)?value:[]}function castFunction(value){return typeof value=="function"?value:identity}function castPath(value,object){if(isArray(value)){return value}return isKey(value,object)?[value]:stringToPath(toString(value))}var castRest=baseRest;function castSlice(array,start,end){var length=array.length;end=end===undefined?length:end;return!start&&end>=length?array:baseSlice(array,start,end)}var clearTimeout=ctxClearTimeout||function(id){return root.clearTimeout(id)};function cloneBuffer(buffer,isDeep){if(isDeep){return buffer.slice()}var length=buffer.length,result=allocUnsafe?allocUnsafe(length):new buffer.constructor(length);buffer.copy(result);return result}function cloneArrayBuffer(arrayBuffer){var result=new arrayBuffer.constructor(arrayBuffer.byteLength);new Uint8Array(result).set(new Uint8Array(arrayBuffer));return result}function cloneDataView(dataView,isDeep){var buffer=isDeep?cloneArrayBuffer(dataView.buffer):dataView.buffer;return new dataView.constructor(buffer,dataView.byteOffset,dataView.byteLength)}function cloneRegExp(regexp){var result=new regexp.constructor(regexp.source,reFlags.exec(regexp));result.lastIndex=regexp.lastIndex;return result}function cloneSymbol(symbol){return symbolValueOf?Object(symbolValueOf.call(symbol)):{}}function cloneTypedArray(typedArray,isDeep){var buffer=isDeep?cloneArrayBuffer(typedArray.buffer):typedArray.buffer;return new typedArray.constructor(buffer,typedArray.byteOffset,typedArray.length)}function compareAscending(value,other){if(value!==other){var valIsDefined=value!==undefined,valIsNull=value===null,valIsReflexive=value===value,valIsSymbol=isSymbol(value);var othIsDefined=other!==undefined,othIsNull=other===null,othIsReflexive=other===other,othIsSymbol=isSymbol(other);if(!othIsNull&&!othIsSymbol&&!valIsSymbol&&value>other||valIsSymbol&&othIsDefined&&othIsReflexive&&!othIsNull&&!othIsSymbol||valIsNull&&othIsDefined&&othIsReflexive||!valIsDefined&&othIsReflexive||!valIsReflexive){return 1}if(!valIsNull&&!valIsSymbol&&!othIsSymbol&&value<other||othIsSymbol&&valIsDefined&&valIsReflexive&&!valIsNull&&!valIsSymbol||othIsNull&&valIsDefined&&valIsReflexive||!othIsDefined&&valIsReflexive||!othIsReflexive){return-1}}return 0}function compareMultiple(object,other,orders){var index=-1,objCriteria=object.criteria,othCriteria=other.criteria,length=objCriteria.length,ordersLength=orders.length;while(++index<length){var result=compareAscending(objCriteria[index],othCriteria[index]);if(result){if(index>=ordersLength){return result}var order=orders[index];return result*(order=="desc"?-1:1)}}return object.index-other.index}function composeArgs(args,partials,holders,isCurried){var argsIndex=-1,argsLength=args.length,holdersLength=holders.length,leftIndex=-1,leftLength=partials.length,rangeLength=nativeMax(argsLength-holdersLength,0),result=Array(leftLength+rangeLength),isUncurried=!isCurried;while(++leftIndex<leftLength){result[leftIndex]=partials[leftIndex]}while(++argsIndex<holdersLength){if(isUncurried||argsIndex<argsLength){result[holders[argsIndex]]=args[argsIndex]}}while(rangeLength--){result[leftIndex++]=args[argsIndex++]}return result}function composeArgsRight(args,partials,holders,isCurried){var argsIndex=-1,argsLength=args.length,holdersIndex=-1,holdersLength=holders.length,rightIndex=-1,rightLength=partials.length,rangeLength=nativeMax(argsLength-holdersLength,0),result=Array(rangeLength+rightLength),isUncurried=!isCurried;while(++argsIndex<rangeLength){result[argsIndex]=args[argsIndex]}var offset=argsIndex;while(++rightIndex<rightLength){result[offset+rightIndex]=partials[rightIndex]}while(++holdersIndex<holdersLength){if(isUncurried||argsIndex<argsLength){result[offset+holders[holdersIndex]]=args[argsIndex++]}}return result}function copyArray(source,array){var index=-1,length=source.length;array||(array=Array(length));while(++index<length){array[index]=source[index]}return array}function copyObject(source,props,object,customizer){var isNew=!object;object||(object={});var index=-1,length=props.length;while(++index<length){var key=props[index];var newValue=customizer?customizer(object[key],source[key],key,object,source):undefined;if(newValue===undefined){newValue=source[key]}if(isNew){baseAssignValue(object,key,newValue)}else{assignValue(object,key,newValue)}}return object}function copySymbols(source,object){return copyObject(source,getSymbols(source),object)}function copySymbolsIn(source,object){return copyObject(source,getSymbolsIn(source),object)}function createAggregator(setter,initializer){return function(collection,iteratee){var func=isArray(collection)?arrayAggregator:baseAggregator,accumulator=initializer?initializer():{};return func(collection,setter,getIteratee(iteratee,2),accumulator)}}function createAssigner(assigner){return baseRest((function(object,sources){var index=-1,length=sources.length,customizer=length>1?sources[length-1]:undefined,guard=length>2?sources[2]:undefined;customizer=assigner.length>3&&typeof customizer=="function"?(length--,customizer):undefined;if(guard&&isIterateeCall(sources[0],sources[1],guard)){customizer=length<3?undefined:customizer;length=1}object=Object(object);while(++index<length){var source=sources[index];if(source){assigner(object,source,index,customizer)}}return object}))}function createBaseEach(eachFunc,fromRight){return function(collection,iteratee){if(collection==null){return collection}if(!isArrayLike(collection)){return eachFunc(collection,iteratee)}var length=collection.length,index=fromRight?length:-1,iterable=Object(collection);while(fromRight?index--:++index<length){if(iteratee(iterable[index],index,iterable)===false){break}}return collection}}function createBaseFor(fromRight){return function(object,iteratee,keysFunc){var index=-1,iterable=Object(object),props=keysFunc(object),length=props.length;while(length--){var key=props[fromRight?length:++index];if(iteratee(iterable[key],key,iterable)===false){break}}return object}}function createBind(func,bitmask,thisArg){var isBind=bitmask&WRAP_BIND_FLAG,Ctor=createCtor(func);function wrapper(){var fn=this&&this!==root&&this instanceof wrapper?Ctor:func;return fn.apply(isBind?thisArg:this,arguments)}return wrapper}function createCaseFirst(methodName){return function(string){string=toString(string);var strSymbols=hasUnicode(string)?stringToArray(string):undefined;var chr=strSymbols?strSymbols[0]:string.charAt(0);var trailing=strSymbols?castSlice(strSymbols,1).join(""):string.slice(1);return chr[methodName]()+trailing}}function createCompounder(callback){return function(string){return arrayReduce(words(deburr(string).replace(reApos,"")),callback,"")}}function createCtor(Ctor){return function(){var args=arguments;switch(args.length){case 0:return new Ctor;case 1:return new Ctor(args[0]);case 2:return new Ctor(args[0],args[1]);case 3:return new Ctor(args[0],args[1],args[2]);case 4:return new Ctor(args[0],args[1],args[2],args[3]);case 5:return new Ctor(args[0],args[1],args[2],args[3],args[4]);case 6:return new Ctor(args[0],args[1],args[2],args[3],args[4],args[5]);case 7:return new Ctor(args[0],args[1],args[2],args[3],args[4],args[5],args[6])}var thisBinding=baseCreate(Ctor.prototype),result=Ctor.apply(thisBinding,args);return isObject(result)?result:thisBinding}}function createCurry(func,bitmask,arity){var Ctor=createCtor(func);function wrapper(){var length=arguments.length,args=Array(length),index=length,placeholder=getHolder(wrapper);while(index--){args[index]=arguments[index]}var holders=length<3&&args[0]!==placeholder&&args[length-1]!==placeholder?[]:replaceHolders(args,placeholder);length-=holders.length;if(length<arity){return createRecurry(func,bitmask,createHybrid,wrapper.placeholder,undefined,args,holders,undefined,undefined,arity-length)}var fn=this&&this!==root&&this instanceof wrapper?Ctor:func;return apply(fn,this,args)}return wrapper}function createFind(findIndexFunc){return function(collection,predicate,fromIndex){var iterable=Object(collection);if(!isArrayLike(collection)){var iteratee=getIteratee(predicate,3);collection=keys(collection);predicate=function(key){return iteratee(iterable[key],key,iterable)}}var index=findIndexFunc(collection,predicate,fromIndex);return index>-1?iterable[iteratee?collection[index]:index]:undefined}}function createFlow(fromRight){return flatRest((function(funcs){var length=funcs.length,index=length,prereq=LodashWrapper.prototype.thru;if(fromRight){funcs.reverse()}while(index--){var func=funcs[index];if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}if(prereq&&!wrapper&&getFuncName(func)=="wrapper"){var wrapper=new LodashWrapper([],true)}}index=wrapper?index:length;while(++index<length){func=funcs[index];var funcName=getFuncName(func),data=funcName=="wrapper"?getData(func):undefined;if(data&&isLaziable(data[0])&&data[1]==(WRAP_ARY_FLAG|WRAP_CURRY_FLAG|WRAP_PARTIAL_FLAG|WRAP_REARG_FLAG)&&!data[4].length&&data[9]==1){wrapper=wrapper[getFuncName(data[0])].apply(wrapper,data[3])}else{wrapper=func.length==1&&isLaziable(func)?wrapper[funcName]():wrapper.thru(func)}}return function(){var args=arguments,value=args[0];if(wrapper&&args.length==1&&isArray(value)){return wrapper.plant(value).value()}var index=0,result=length?funcs[index].apply(this,args):value;while(++index<length){result=funcs[index].call(this,result)}return result}}))}function createHybrid(func,bitmask,thisArg,partials,holders,partialsRight,holdersRight,argPos,ary,arity){var isAry=bitmask&WRAP_ARY_FLAG,isBind=bitmask&WRAP_BIND_FLAG,isBindKey=bitmask&WRAP_BIND_KEY_FLAG,isCurried=bitmask&(WRAP_CURRY_FLAG|WRAP_CURRY_RIGHT_FLAG),isFlip=bitmask&WRAP_FLIP_FLAG,Ctor=isBindKey?undefined:createCtor(func);function wrapper(){var length=arguments.length,args=Array(length),index=length;while(index--){args[index]=arguments[index]}if(isCurried){var placeholder=getHolder(wrapper),holdersCount=countHolders(args,placeholder)}if(partials){args=composeArgs(args,partials,holders,isCurried)}if(partialsRight){args=composeArgsRight(args,partialsRight,holdersRight,isCurried)}length-=holdersCount;if(isCurried&&length<arity){var newHolders=replaceHolders(args,placeholder);return createRecurry(func,bitmask,createHybrid,wrapper.placeholder,thisArg,args,newHolders,argPos,ary,arity-length)}var thisBinding=isBind?thisArg:this,fn=isBindKey?thisBinding[func]:func;length=args.length;if(argPos){args=reorder(args,argPos)}else if(isFlip&&length>1){args.reverse()}if(isAry&&ary<length){args.length=ary}if(this&&this!==root&&this instanceof wrapper){fn=Ctor||createCtor(fn)}return fn.apply(thisBinding,args)}return wrapper}function createInverter(setter,toIteratee){return function(object,iteratee){return baseInverter(object,setter,toIteratee(iteratee),{})}}function createMathOperation(operator,defaultValue){return function(value,other){var result;if(value===undefined&&other===undefined){return defaultValue}if(value!==undefined){result=value}if(other!==undefined){if(result===undefined){return other}if(typeof value=="string"||typeof other=="string"){value=baseToString(value);other=baseToString(other)}else{value=baseToNumber(value);other=baseToNumber(other)}result=operator(value,other)}return result}}function createOver(arrayFunc){return flatRest((function(iteratees){iteratees=arrayMap(iteratees,baseUnary(getIteratee()));return baseRest((function(args){var thisArg=this;return arrayFunc(iteratees,(function(iteratee){return apply(iteratee,thisArg,args)}))}))}))}function createPadding(length,chars){chars=chars===undefined?" ":baseToString(chars);var charsLength=chars.length;if(charsLength<2){return charsLength?baseRepeat(chars,length):chars}var result=baseRepeat(chars,nativeCeil(length/stringSize(chars)));return hasUnicode(chars)?castSlice(stringToArray(result),0,length).join(""):result.slice(0,length)}function createPartial(func,bitmask,thisArg,partials){var isBind=bitmask&WRAP_BIND_FLAG,Ctor=createCtor(func);function wrapper(){var argsIndex=-1,argsLength=arguments.length,leftIndex=-1,leftLength=partials.length,args=Array(leftLength+argsLength),fn=this&&this!==root&&this instanceof wrapper?Ctor:func;while(++leftIndex<leftLength){args[leftIndex]=partials[leftIndex]}while(argsLength--){args[leftIndex++]=arguments[++argsIndex]}return apply(fn,isBind?thisArg:this,args)}return wrapper}function createRange(fromRight){return function(start,end,step){if(step&&typeof step!="number"&&isIterateeCall(start,end,step)){end=step=undefined}start=toFinite(start);if(end===undefined){end=start;start=0}else{end=toFinite(end)}step=step===undefined?start<end?1:-1:toFinite(step);return baseRange(start,end,step,fromRight)}}function createRelationalOperation(operator){return function(value,other){if(!(typeof value=="string"&&typeof other=="string")){value=toNumber(value);other=toNumber(other)}return operator(value,other)}}function createRecurry(func,bitmask,wrapFunc,placeholder,thisArg,partials,holders,argPos,ary,arity){var isCurry=bitmask&WRAP_CURRY_FLAG,newHolders=isCurry?holders:undefined,newHoldersRight=isCurry?undefined:holders,newPartials=isCurry?partials:undefined,newPartialsRight=isCurry?undefined:partials;bitmask|=isCurry?WRAP_PARTIAL_FLAG:WRAP_PARTIAL_RIGHT_FLAG;bitmask&=~(isCurry?WRAP_PARTIAL_RIGHT_FLAG:WRAP_PARTIAL_FLAG);if(!(bitmask&WRAP_CURRY_BOUND_FLAG)){bitmask&=~(WRAP_BIND_FLAG|WRAP_BIND_KEY_FLAG)}var newData=[func,bitmask,thisArg,newPartials,newHolders,newPartialsRight,newHoldersRight,argPos,ary,arity];var result=wrapFunc.apply(undefined,newData);if(isLaziable(func)){setData(result,newData)}result.placeholder=placeholder;return setWrapToString(result,func,bitmask)}function createRound(methodName){var func=Math[methodName];return function(number,precision){number=toNumber(number);precision=precision==null?0:nativeMin(toInteger(precision),292);if(precision){var pair=(toString(number)+"e").split("e"),value=func(pair[0]+"e"+(+pair[1]+precision));pair=(toString(value)+"e").split("e");return+(pair[0]+"e"+(+pair[1]-precision))}return func(number)}}var createSet=!(Set&&1/setToArray(new Set([,-0]))[1]==INFINITY)?noop:function(values){return new Set(values)};function createToPairs(keysFunc){return function(object){var tag=getTag(object);if(tag==mapTag){return mapToArray(object)}if(tag==setTag){return setToPairs(object)}return baseToPairs(object,keysFunc(object))}}function createWrap(func,bitmask,thisArg,partials,holders,argPos,ary,arity){var isBindKey=bitmask&WRAP_BIND_KEY_FLAG;if(!isBindKey&&typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}var length=partials?partials.length:0;if(!length){bitmask&=~(WRAP_PARTIAL_FLAG|WRAP_PARTIAL_RIGHT_FLAG);partials=holders=undefined}ary=ary===undefined?ary:nativeMax(toInteger(ary),0);arity=arity===undefined?arity:toInteger(arity);length-=holders?holders.length:0;if(bitmask&WRAP_PARTIAL_RIGHT_FLAG){var partialsRight=partials,holdersRight=holders;partials=holders=undefined}var data=isBindKey?undefined:getData(func);var newData=[func,bitmask,thisArg,partials,holders,partialsRight,holdersRight,argPos,ary,arity];if(data){mergeData(newData,data)}func=newData[0];bitmask=newData[1];thisArg=newData[2];partials=newData[3];holders=newData[4];arity=newData[9]=newData[9]===undefined?isBindKey?0:func.length:nativeMax(newData[9]-length,0);if(!arity&&bitmask&(WRAP_CURRY_FLAG|WRAP_CURRY_RIGHT_FLAG)){bitmask&=~(WRAP_CURRY_FLAG|WRAP_CURRY_RIGHT_FLAG)}if(!bitmask||bitmask==WRAP_BIND_FLAG){var result=createBind(func,bitmask,thisArg)}else if(bitmask==WRAP_CURRY_FLAG||bitmask==WRAP_CURRY_RIGHT_FLAG){result=createCurry(func,bitmask,arity)}else if((bitmask==WRAP_PARTIAL_FLAG||bitmask==(WRAP_BIND_FLAG|WRAP_PARTIAL_FLAG))&&!holders.length){result=createPartial(func,bitmask,thisArg,partials)}else{result=createHybrid.apply(undefined,newData)}var setter=data?baseSetData:setData;return setWrapToString(setter(result,newData),func,bitmask)}function customDefaultsAssignIn(objValue,srcValue,key,object){if(objValue===undefined||eq(objValue,objectProto[key])&&!hasOwnProperty.call(object,key)){return srcValue}return objValue}function customDefaultsMerge(objValue,srcValue,key,object,source,stack){if(isObject(objValue)&&isObject(srcValue)){stack.set(srcValue,objValue);baseMerge(objValue,srcValue,undefined,customDefaultsMerge,stack);stack["delete"](srcValue)}return objValue}function customOmitClone(value){return isPlainObject(value)?undefined:value}function equalArrays(array,other,bitmask,customizer,equalFunc,stack){var isPartial=bitmask&COMPARE_PARTIAL_FLAG,arrLength=array.length,othLength=other.length;if(arrLength!=othLength&&!(isPartial&&othLength>arrLength)){return false}var stacked=stack.get(array);if(stacked&&stack.get(other)){return stacked==other}var index=-1,result=true,seen=bitmask&COMPARE_UNORDERED_FLAG?new SetCache:undefined;stack.set(array,other);stack.set(other,array);while(++index<arrLength){var arrValue=array[index],othValue=other[index];if(customizer){var compared=isPartial?customizer(othValue,arrValue,index,other,array,stack):customizer(arrValue,othValue,index,array,other,stack)}if(compared!==undefined){if(compared){continue}result=false;break}if(seen){if(!arraySome(other,(function(othValue,othIndex){if(!cacheHas(seen,othIndex)&&(arrValue===othValue||equalFunc(arrValue,othValue,bitmask,customizer,stack))){return seen.push(othIndex)}}))){result=false;break}}else if(!(arrValue===othValue||equalFunc(arrValue,othValue,bitmask,customizer,stack))){result=false;break}}stack["delete"](array);stack["delete"](other);return result}function equalByTag(object,other,tag,bitmask,customizer,equalFunc,stack){switch(tag){case dataViewTag:if(object.byteLength!=other.byteLength||object.byteOffset!=other.byteOffset){return false}object=object.buffer;other=other.buffer;case arrayBufferTag:if(object.byteLength!=other.byteLength||!equalFunc(new Uint8Array(object),new Uint8Array(other))){return false}return true;case boolTag:case dateTag:case numberTag:return eq(+object,+other);case errorTag:return object.name==other.name&&object.message==other.message;case regexpTag:case stringTag:return object==other+"";case mapTag:var convert=mapToArray;case setTag:var isPartial=bitmask&COMPARE_PARTIAL_FLAG;convert||(convert=setToArray);if(object.size!=other.size&&!isPartial){return false}var stacked=stack.get(object);if(stacked){return stacked==other}bitmask|=COMPARE_UNORDERED_FLAG;stack.set(object,other);var result=equalArrays(convert(object),convert(other),bitmask,customizer,equalFunc,stack);stack["delete"](object);return result;case symbolTag:if(symbolValueOf){return symbolValueOf.call(object)==symbolValueOf.call(other)}}return false}function equalObjects(object,other,bitmask,customizer,equalFunc,stack){var isPartial=bitmask&COMPARE_PARTIAL_FLAG,objProps=getAllKeys(object),objLength=objProps.length,othProps=getAllKeys(other),othLength=othProps.length;if(objLength!=othLength&&!isPartial){return false}var index=objLength;while(index--){var key=objProps[index];if(!(isPartial?key in other:hasOwnProperty.call(other,key))){return false}}var stacked=stack.get(object);if(stacked&&stack.get(other)){return stacked==other}var result=true;stack.set(object,other);stack.set(other,object);var skipCtor=isPartial;while(++index<objLength){key=objProps[index];var objValue=object[key],othValue=other[key];if(customizer){var compared=isPartial?customizer(othValue,objValue,key,other,object,stack):customizer(objValue,othValue,key,object,other,stack)}if(!(compared===undefined?objValue===othValue||equalFunc(objValue,othValue,bitmask,customizer,stack):compared)){result=false;break}skipCtor||(skipCtor=key=="constructor")}if(result&&!skipCtor){var objCtor=object.constructor,othCtor=other.constructor;if(objCtor!=othCtor&&("constructor"in object&&"constructor"in other)&&!(typeof objCtor=="function"&&objCtor instanceof objCtor&&typeof othCtor=="function"&&othCtor instanceof othCtor)){result=false}}stack["delete"](object);stack["delete"](other);return result}function flatRest(func){return setToString(overRest(func,undefined,flatten),func+"")}function getAllKeys(object){return baseGetAllKeys(object,keys,getSymbols)}function getAllKeysIn(object){return baseGetAllKeys(object,keysIn,getSymbolsIn)}var getData=!metaMap?noop:function(func){return metaMap.get(func)};function getFuncName(func){var result=func.name+"",array=realNames[result],length=hasOwnProperty.call(realNames,result)?array.length:0;while(length--){var data=array[length],otherFunc=data.func;if(otherFunc==null||otherFunc==func){return data.name}}return result}function getHolder(func){var object=hasOwnProperty.call(lodash,"placeholder")?lodash:func;return object.placeholder}function getIteratee(){var result=lodash.iteratee||iteratee;result=result===iteratee?baseIteratee:result;return arguments.length?result(arguments[0],arguments[1]):result}function getMapData(map,key){var data=map.__data__;return isKeyable(key)?data[typeof key=="string"?"string":"hash"]:data.map}function getMatchData(object){var result=keys(object),length=result.length;while(length--){var key=result[length],value=object[key];result[length]=[key,value,isStrictComparable(value)]}return result}function getNative(object,key){var value=getValue(object,key);return baseIsNative(value)?value:undefined}function getRawTag(value){var isOwn=hasOwnProperty.call(value,symToStringTag),tag=value[symToStringTag];try{value[symToStringTag]=undefined;var unmasked=true}catch(e){}var result=nativeObjectToString.call(value);if(unmasked){if(isOwn){value[symToStringTag]=tag}else{delete value[symToStringTag]}}return result}var getSymbols=!nativeGetSymbols?stubArray:function(object){if(object==null){return[]}object=Object(object);return arrayFilter(nativeGetSymbols(object),(function(symbol){return propertyIsEnumerable.call(object,symbol)}))};var getSymbolsIn=!nativeGetSymbols?stubArray:function(object){var result=[];while(object){arrayPush(result,getSymbols(object));object=getPrototype(object)}return result};var getTag=baseGetTag;if(DataView&&getTag(new DataView(new ArrayBuffer(1)))!=dataViewTag||Map&&getTag(new Map)!=mapTag||Promise&&getTag(Promise.resolve())!=promiseTag||Set&&getTag(new Set)!=setTag||WeakMap&&getTag(new WeakMap)!=weakMapTag){getTag=function(value){var result=baseGetTag(value),Ctor=result==objectTag?value.constructor:undefined,ctorString=Ctor?toSource(Ctor):"";if(ctorString){switch(ctorString){case dataViewCtorString:return dataViewTag;case mapCtorString:return mapTag;case promiseCtorString:return promiseTag;case setCtorString:return setTag;case weakMapCtorString:return weakMapTag}}return result}}function getView(start,end,transforms){var index=-1,length=transforms.length;while(++index<length){var data=transforms[index],size=data.size;switch(data.type){case"drop":start+=size;break;case"dropRight":end-=size;break;case"take":end=nativeMin(end,start+size);break;case"takeRight":start=nativeMax(start,end-size);break}}return{start,end}}function getWrapDetails(source){var match=source.match(reWrapDetails);return match?match[1].split(reSplitDetails):[]}function hasPath(object,path,hasFunc){path=castPath(path,object);var index=-1,length=path.length,result=false;while(++index<length){var key=toKey(path[index]);if(!(result=object!=null&&hasFunc(object,key))){break}object=object[key]}if(result||++index!=length){return result}length=object==null?0:object.length;return!!length&&isLength(length)&&isIndex(key,length)&&(isArray(object)||isArguments(object))}function initCloneArray(array){var length=array.length,result=new array.constructor(length);if(length&&typeof array[0]=="string"&&hasOwnProperty.call(array,"index")){result.index=array.index;result.input=array.input}return result}function initCloneObject(object){return typeof object.constructor=="function"&&!isPrototype(object)?baseCreate(getPrototype(object)):{}}function initCloneByTag(object,tag,isDeep){var Ctor=object.constructor;switch(tag){case arrayBufferTag:return cloneArrayBuffer(object);case boolTag:case dateTag:return new Ctor(+object);case dataViewTag:return cloneDataView(object,isDeep);case float32Tag:case float64Tag:case int8Tag:case int16Tag:case int32Tag:case uint8Tag:case uint8ClampedTag:case uint16Tag:case uint32Tag:return cloneTypedArray(object,isDeep);case mapTag:return new Ctor;case numberTag:case stringTag:return new Ctor(object);case regexpTag:return cloneRegExp(object);case setTag:return new Ctor;case symbolTag:return cloneSymbol(object)}}function insertWrapDetails(source,details){var length=details.length;if(!length){return source}var lastIndex=length-1;details[lastIndex]=(length>1?"& ":"")+details[lastIndex];details=details.join(length>2?", ":" ");return source.replace(reWrapComment,"{\n/* [wrapped with "+details+"] */\n")}function isFlattenable(value){return isArray(value)||isArguments(value)||!!(spreadableSymbol&&value&&value[spreadableSymbol])}function isIndex(value,length){var type=typeof value;length=length==null?MAX_SAFE_INTEGER:length;return!!length&&(type=="number"||type!="symbol"&&reIsUint.test(value))&&(value>-1&&value%1==0&&value<length)}function isIterateeCall(value,index,object){if(!isObject(object)){return false}var type=typeof index;if(type=="number"?isArrayLike(object)&&isIndex(index,object.length):type=="string"&&index in object){return eq(object[index],value)}return false}function isKey(value,object){if(isArray(value)){return false}var type=typeof value;if(type=="number"||type=="symbol"||type=="boolean"||value==null||isSymbol(value)){return true}return reIsPlainProp.test(value)||!reIsDeepProp.test(value)||object!=null&&value in Object(object)}function isKeyable(value){var type=typeof value;return type=="string"||type=="number"||type=="symbol"||type=="boolean"?value!=="__proto__":value===null}function isLaziable(func){var funcName=getFuncName(func),other=lodash[funcName];if(typeof other!="function"||!(funcName in LazyWrapper.prototype)){return false}if(func===other){return true}var data=getData(other);return!!data&&func===data[0]}function isMasked(func){return!!maskSrcKey&&maskSrcKey in func}var isMaskable=coreJsData?isFunction:stubFalse;function isPrototype(value){var Ctor=value&&value.constructor,proto=typeof Ctor=="function"&&Ctor.prototype||objectProto;return value===proto}function isStrictComparable(value){return value===value&&!isObject(value)}function matchesStrictComparable(key,srcValue){return function(object){if(object==null){return false}return object[key]===srcValue&&(srcValue!==undefined||key in Object(object))}}function memoizeCapped(func){var result=memoize(func,(function(key){if(cache.size===MAX_MEMOIZE_SIZE){cache.clear()}return key}));var cache=result.cache;return result}function mergeData(data,source){var bitmask=data[1],srcBitmask=source[1],newBitmask=bitmask|srcBitmask,isCommon=newBitmask<(WRAP_BIND_FLAG|WRAP_BIND_KEY_FLAG|WRAP_ARY_FLAG);var isCombo=srcBitmask==WRAP_ARY_FLAG&&bitmask==WRAP_CURRY_FLAG||srcBitmask==WRAP_ARY_FLAG&&bitmask==WRAP_REARG_FLAG&&data[7].length<=source[8]||srcBitmask==(WRAP_ARY_FLAG|WRAP_REARG_FLAG)&&source[7].length<=source[8]&&bitmask==WRAP_CURRY_FLAG;if(!(isCommon||isCombo)){return data}if(srcBitmask&WRAP_BIND_FLAG){data[2]=source[2];newBitmask|=bitmask&WRAP_BIND_FLAG?0:WRAP_CURRY_BOUND_FLAG}var value=source[3];if(value){var partials=data[3];data[3]=partials?composeArgs(partials,value,source[4]):value;data[4]=partials?replaceHolders(data[3],PLACEHOLDER):source[4]}value=source[5];if(value){partials=data[5];data[5]=partials?composeArgsRight(partials,value,source[6]):value;data[6]=partials?replaceHolders(data[5],PLACEHOLDER):source[6]}value=source[7];if(value){data[7]=value}if(srcBitmask&WRAP_ARY_FLAG){data[8]=data[8]==null?source[8]:nativeMin(data[8],source[8])}if(data[9]==null){data[9]=source[9]}data[0]=source[0];data[1]=newBitmask;return data}function nativeKeysIn(object){var result=[];if(object!=null){for(var key in Object(object)){result.push(key)}}return result}function objectToString(value){return nativeObjectToString.call(value)}function overRest(func,start,transform){start=nativeMax(start===undefined?func.length-1:start,0);return function(){var args=arguments,index=-1,length=nativeMax(args.length-start,0),array=Array(length);while(++index<length){array[index]=args[start+index]}index=-1;var otherArgs=Array(start+1);while(++index<start){otherArgs[index]=args[index]}otherArgs[start]=transform(array);return apply(func,this,otherArgs)}}function parent(object,path){return path.length<2?object:baseGet(object,baseSlice(path,0,-1))}function reorder(array,indexes){var arrLength=array.length,length=nativeMin(indexes.length,arrLength),oldArray=copyArray(array);while(length--){var index=indexes[length];array[length]=isIndex(index,arrLength)?oldArray[index]:undefined}return array}var setData=shortOut(baseSetData);var setTimeout=ctxSetTimeout||function(func,wait){return root.setTimeout(func,wait)};var setToString=shortOut(baseSetToString);function setWrapToString(wrapper,reference,bitmask){var source=reference+"";return setToString(wrapper,insertWrapDetails(source,updateWrapDetails(getWrapDetails(source),bitmask)))}function shortOut(func){var count=0,lastCalled=0;return function(){var stamp=nativeNow(),remaining=HOT_SPAN-(stamp-lastCalled);lastCalled=stamp;if(remaining>0){if(++count>=HOT_COUNT){return arguments[0]}}else{count=0}return func.apply(undefined,arguments)}}function shuffleSelf(array,size){var index=-1,length=array.length,lastIndex=length-1;size=size===undefined?length:size;while(++index<size){var rand=baseRandom(index,lastIndex),value=array[rand];array[rand]=array[index];array[index]=value}array.length=size;return array}var stringToPath=memoizeCapped((function(string){var result=[];if(string.charCodeAt(0)===46){result.push("")}string.replace(rePropName,(function(match,number,quote,subString){result.push(quote?subString.replace(reEscapeChar,"$1"):number||match)}));return result}));function toKey(value){if(typeof value=="string"||isSymbol(value)){return value}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}function toSource(func){if(func!=null){try{return funcToString.call(func)}catch(e){}try{return func+""}catch(e){}}return""}function updateWrapDetails(details,bitmask){arrayEach(wrapFlags,(function(pair){var value="_."+pair[0];if(bitmask&pair[1]&&!arrayIncludes(details,value)){details.push(value)}}));return details.sort()}function wrapperClone(wrapper){if(wrapper instanceof LazyWrapper){return wrapper.clone()}var result=new LodashWrapper(wrapper.__wrapped__,wrapper.__chain__);result.__actions__=copyArray(wrapper.__actions__);result.__index__=wrapper.__index__;result.__values__=wrapper.__values__;return result}function chunk(array,size,guard){if(guard?isIterateeCall(array,size,guard):size===undefined){size=1}else{size=nativeMax(toInteger(size),0)}var length=array==null?0:array.length;if(!length||size<1){return[]}var index=0,resIndex=0,result=Array(nativeCeil(length/size));while(index<length){result[resIndex++]=baseSlice(array,index,index+=size)}return result}function compact(array){var index=-1,length=array==null?0:array.length,resIndex=0,result=[];while(++index<length){var value=array[index];if(value){result[resIndex++]=value}}return result}function concat(){var length=arguments.length;if(!length){return[]}var args=Array(length-1),array=arguments[0],index=length;while(index--){args[index-1]=arguments[index]}return arrayPush(isArray(array)?copyArray(array):[array],baseFlatten(args,1))}var difference=baseRest((function(array,values){return isArrayLikeObject(array)?baseDifference(array,baseFlatten(values,1,isArrayLikeObject,true)):[]}));var differenceBy=baseRest((function(array,values){var iteratee=last(values);if(isArrayLikeObject(iteratee)){iteratee=undefined}return isArrayLikeObject(array)?baseDifference(array,baseFlatten(values,1,isArrayLikeObject,true),getIteratee(iteratee,2)):[]}));var differenceWith=baseRest((function(array,values){var comparator=last(values);if(isArrayLikeObject(comparator)){comparator=undefined}return isArrayLikeObject(array)?baseDifference(array,baseFlatten(values,1,isArrayLikeObject,true),undefined,comparator):[]}));function drop(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined?1:toInteger(n);return baseSlice(array,n<0?0:n,length)}function dropRight(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined?1:toInteger(n);n=length-n;return baseSlice(array,0,n<0?0:n)}function dropRightWhile(array,predicate){return array&&array.length?baseWhile(array,getIteratee(predicate,3),true,true):[]}function dropWhile(array,predicate){return array&&array.length?baseWhile(array,getIteratee(predicate,3),true):[]}function fill(array,value,start,end){var length=array==null?0:array.length;if(!length){return[]}if(start&&typeof start!="number"&&isIterateeCall(array,value,start)){start=0;end=length}return baseFill(array,value,start,end)}function findIndex(array,predicate,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=fromIndex==null?0:toInteger(fromIndex);if(index<0){index=nativeMax(length+index,0)}return baseFindIndex(array,getIteratee(predicate,3),index)}function findLastIndex(array,predicate,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=length-1;if(fromIndex!==undefined){index=toInteger(fromIndex);index=fromIndex<0?nativeMax(length+index,0):nativeMin(index,length-1)}return baseFindIndex(array,getIteratee(predicate,3),index,true)}function flatten(array){var length=array==null?0:array.length;return length?baseFlatten(array,1):[]}function flattenDeep(array){var length=array==null?0:array.length;return length?baseFlatten(array,INFINITY):[]}function flattenDepth(array,depth){var length=array==null?0:array.length;if(!length){return[]}depth=depth===undefined?1:toInteger(depth);return baseFlatten(array,depth)}function fromPairs(pairs){var index=-1,length=pairs==null?0:pairs.length,result={};while(++index<length){var pair=pairs[index];result[pair[0]]=pair[1]}return result}function head(array){return array&&array.length?array[0]:undefined}function indexOf(array,value,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=fromIndex==null?0:toInteger(fromIndex);if(index<0){index=nativeMax(length+index,0)}return baseIndexOf(array,value,index)}function initial(array){var length=array==null?0:array.length;return length?baseSlice(array,0,-1):[]}var intersection=baseRest((function(arrays){var mapped=arrayMap(arrays,castArrayLikeObject);return mapped.length&&mapped[0]===arrays[0]?baseIntersection(mapped):[]}));var intersectionBy=baseRest((function(arrays){var iteratee=last(arrays),mapped=arrayMap(arrays,castArrayLikeObject);if(iteratee===last(mapped)){iteratee=undefined}else{mapped.pop()}return mapped.length&&mapped[0]===arrays[0]?baseIntersection(mapped,getIteratee(iteratee,2)):[]}));var intersectionWith=baseRest((function(arrays){var comparator=last(arrays),mapped=arrayMap(arrays,castArrayLikeObject);comparator=typeof comparator=="function"?comparator:undefined;if(comparator){mapped.pop()}return mapped.length&&mapped[0]===arrays[0]?baseIntersection(mapped,undefined,comparator):[]}));function join(array,separator){return array==null?"":nativeJoin.call(array,separator)}function last(array){var length=array==null?0:array.length;return length?array[length-1]:undefined}function lastIndexOf(array,value,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=length;if(fromIndex!==undefined){index=toInteger(fromIndex);index=index<0?nativeMax(length+index,0):nativeMin(index,length-1)}return value===value?strictLastIndexOf(array,value,index):baseFindIndex(array,baseIsNaN,index,true)}function nth(array,n){return array&&array.length?baseNth(array,toInteger(n)):undefined}var pull=baseRest(pullAll);function pullAll(array,values){return array&&array.length&&values&&values.length?basePullAll(array,values):array}function pullAllBy(array,values,iteratee){return array&&array.length&&values&&values.length?basePullAll(array,values,getIteratee(iteratee,2)):array}function pullAllWith(array,values,comparator){return array&&array.length&&values&&values.length?basePullAll(array,values,undefined,comparator):array}var pullAt=flatRest((function(array,indexes){var length=array==null?0:array.length,result=baseAt(array,indexes);basePullAt(array,arrayMap(indexes,(function(index){return isIndex(index,length)?+index:index})).sort(compareAscending));return result}));function remove(array,predicate){var result=[];if(!(array&&array.length)){return result}var index=-1,indexes=[],length=array.length;predicate=getIteratee(predicate,3);while(++index<length){var value=array[index];if(predicate(value,index,array)){result.push(value);indexes.push(index)}}basePullAt(array,indexes);return result}function reverse(array){return array==null?array:nativeReverse.call(array)}function slice(array,start,end){var length=array==null?0:array.length;if(!length){return[]}if(end&&typeof end!="number"&&isIterateeCall(array,start,end)){start=0;end=length}else{start=start==null?0:toInteger(start);end=end===undefined?length:toInteger(end)}return baseSlice(array,start,end)}function sortedIndex(array,value){return baseSortedIndex(array,value)}function sortedIndexBy(array,value,iteratee){return baseSortedIndexBy(array,value,getIteratee(iteratee,2))}function sortedIndexOf(array,value){var length=array==null?0:array.length;if(length){var index=baseSortedIndex(array,value);if(index<length&&eq(array[index],value)){return index}}return-1}function sortedLastIndex(array,value){return baseSortedIndex(array,value,true)}function sortedLastIndexBy(array,value,iteratee){return baseSortedIndexBy(array,value,getIteratee(iteratee,2),true)}function sortedLastIndexOf(array,value){var length=array==null?0:array.length;if(length){var index=baseSortedIndex(array,value,true)-1;if(eq(array[index],value)){return index}}return-1}function sortedUniq(array){return array&&array.length?baseSortedUniq(array):[]}function sortedUniqBy(array,iteratee){return array&&array.length?baseSortedUniq(array,getIteratee(iteratee,2)):[]}function tail(array){var length=array==null?0:array.length;return length?baseSlice(array,1,length):[]}function take(array,n,guard){if(!(array&&array.length)){return[]}n=guard||n===undefined?1:toInteger(n);return baseSlice(array,0,n<0?0:n)}function takeRight(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined?1:toInteger(n);n=length-n;return baseSlice(array,n<0?0:n,length)}function takeRightWhile(array,predicate){return array&&array.length?baseWhile(array,getIteratee(predicate,3),false,true):[]}function takeWhile(array,predicate){return array&&array.length?baseWhile(array,getIteratee(predicate,3)):[]}var union=baseRest((function(arrays){return baseUniq(baseFlatten(arrays,1,isArrayLikeObject,true))}));var unionBy=baseRest((function(arrays){var iteratee=last(arrays);if(isArrayLikeObject(iteratee)){iteratee=undefined}return baseUniq(baseFlatten(arrays,1,isArrayLikeObject,true),getIteratee(iteratee,2))}));var unionWith=baseRest((function(arrays){var comparator=last(arrays);comparator=typeof comparator=="function"?comparator:undefined;return baseUniq(baseFlatten(arrays,1,isArrayLikeObject,true),undefined,comparator)}));function uniq(array){return array&&array.length?baseUniq(array):[]}function uniqBy(array,iteratee){return array&&array.length?baseUniq(array,getIteratee(iteratee,2)):[]}function uniqWith(array,comparator){comparator=typeof comparator=="function"?comparator:undefined;return array&&array.length?baseUniq(array,undefined,comparator):[]}function unzip(array){if(!(array&&array.length)){return[]}var length=0;array=arrayFilter(array,(function(group){if(isArrayLikeObject(group)){length=nativeMax(group.length,length);return true}}));return baseTimes(length,(function(index){return arrayMap(array,baseProperty(index))}))}function unzipWith(array,iteratee){if(!(array&&array.length)){return[]}var result=unzip(array);if(iteratee==null){return result}return arrayMap(result,(function(group){return apply(iteratee,undefined,group)}))}var without=baseRest((function(array,values){return isArrayLikeObject(array)?baseDifference(array,values):[]}));var xor=baseRest((function(arrays){return baseXor(arrayFilter(arrays,isArrayLikeObject))}));var xorBy=baseRest((function(arrays){var iteratee=last(arrays);if(isArrayLikeObject(iteratee)){iteratee=undefined}return baseXor(arrayFilter(arrays,isArrayLikeObject),getIteratee(iteratee,2))}));var xorWith=baseRest((function(arrays){var comparator=last(arrays);comparator=typeof comparator=="function"?comparator:undefined;return baseXor(arrayFilter(arrays,isArrayLikeObject),undefined,comparator)}));var zip=baseRest(unzip);function zipObject(props,values){return baseZipObject(props||[],values||[],assignValue)}function zipObjectDeep(props,values){return baseZipObject(props||[],values||[],baseSet)}var zipWith=baseRest((function(arrays){var length=arrays.length,iteratee=length>1?arrays[length-1]:undefined;iteratee=typeof iteratee=="function"?(arrays.pop(),iteratee):undefined;return unzipWith(arrays,iteratee)}));function chain(value){var result=lodash(value);result.__chain__=true;return result}function tap(value,interceptor){interceptor(value);return value}function thru(value,interceptor){return interceptor(value)}var wrapperAt=flatRest((function(paths){var length=paths.length,start=length?paths[0]:0,value=this.__wrapped__,interceptor=function(object){return baseAt(object,paths)};if(length>1||this.__actions__.length||!(value instanceof LazyWrapper)||!isIndex(start)){return this.thru(interceptor)}value=value.slice(start,+start+(length?1:0));value.__actions__.push({func:thru,args:[interceptor],thisArg:undefined});return new LodashWrapper(value,this.__chain__).thru((function(array){if(length&&!array.length){array.push(undefined)}return array}))}));function wrapperChain(){return chain(this)}function wrapperCommit(){return new LodashWrapper(this.value(),this.__chain__)}function wrapperNext(){if(this.__values__===undefined){this.__values__=toArray(this.value())}var done=this.__index__>=this.__values__.length,value=done?undefined:this.__values__[this.__index__++];return{done,value}}function wrapperToIterator(){return this}function wrapperPlant(value){var result,parent=this;while(parent instanceof baseLodash){var clone=wrapperClone(parent);clone.__index__=0;clone.__values__=undefined;if(result){previous.__wrapped__=clone}else{result=clone}var previous=clone;parent=parent.__wrapped__}previous.__wrapped__=value;return result}function wrapperReverse(){var value=this.__wrapped__;if(value instanceof LazyWrapper){var wrapped=value;if(this.__actions__.length){wrapped=new LazyWrapper(this)}wrapped=wrapped.reverse();wrapped.__actions__.push({func:thru,args:[reverse],thisArg:undefined});return new LodashWrapper(wrapped,this.__chain__)}return this.thru(reverse)}function wrapperValue(){return baseWrapperValue(this.__wrapped__,this.__actions__)}var countBy=createAggregator((function(result,value,key){if(hasOwnProperty.call(result,key)){++result[key]}else{baseAssignValue(result,key,1)}}));function every(collection,predicate,guard){var func=isArray(collection)?arrayEvery:baseEvery;if(guard&&isIterateeCall(collection,predicate,guard)){predicate=undefined}return func(collection,getIteratee(predicate,3))}function filter(collection,predicate){var func=isArray(collection)?arrayFilter:baseFilter;return func(collection,getIteratee(predicate,3))}var find=createFind(findIndex);var findLast=createFind(findLastIndex);function flatMap(collection,iteratee){return baseFlatten(map(collection,iteratee),1)}function flatMapDeep(collection,iteratee){return baseFlatten(map(collection,iteratee),INFINITY)}function flatMapDepth(collection,iteratee,depth){depth=depth===undefined?1:toInteger(depth);return baseFlatten(map(collection,iteratee),depth)}function forEach(collection,iteratee){var func=isArray(collection)?arrayEach:baseEach;return func(collection,getIteratee(iteratee,3))}function forEachRight(collection,iteratee){var func=isArray(collection)?arrayEachRight:baseEachRight;return func(collection,getIteratee(iteratee,3))}var groupBy=createAggregator((function(result,value,key){if(hasOwnProperty.call(result,key)){result[key].push(value)}else{baseAssignValue(result,key,[value])}}));function includes(collection,value,fromIndex,guard){collection=isArrayLike(collection)?collection:values(collection);fromIndex=fromIndex&&!guard?toInteger(fromIndex):0;var length=collection.length;if(fromIndex<0){fromIndex=nativeMax(length+fromIndex,0)}return isString(collection)?fromIndex<=length&&collection.indexOf(value,fromIndex)>-1:!!length&&baseIndexOf(collection,value,fromIndex)>-1}var invokeMap=baseRest((function(collection,path,args){var index=-1,isFunc=typeof path=="function",result=isArrayLike(collection)?Array(collection.length):[];baseEach(collection,(function(value){result[++index]=isFunc?apply(path,value,args):baseInvoke(value,path,args)}));return result}));var keyBy=createAggregator((function(result,value,key){baseAssignValue(result,key,value)}));function map(collection,iteratee){var func=isArray(collection)?arrayMap:baseMap;return func(collection,getIteratee(iteratee,3))}function orderBy(collection,iteratees,orders,guard){if(collection==null){return[]}if(!isArray(iteratees)){iteratees=iteratees==null?[]:[iteratees]}orders=guard?undefined:orders;if(!isArray(orders)){orders=orders==null?[]:[orders]}return baseOrderBy(collection,iteratees,orders)}var partition=createAggregator((function(result,value,key){result[key?0:1].push(value)}),(function(){return[[],[]]}));function reduce(collection,iteratee,accumulator){var func=isArray(collection)?arrayReduce:baseReduce,initAccum=arguments.length<3;return func(collection,getIteratee(iteratee,4),accumulator,initAccum,baseEach)}function reduceRight(collection,iteratee,accumulator){var func=isArray(collection)?arrayReduceRight:baseReduce,initAccum=arguments.length<3;return func(collection,getIteratee(iteratee,4),accumulator,initAccum,baseEachRight)}function reject(collection,predicate){var func=isArray(collection)?arrayFilter:baseFilter;return func(collection,negate(getIteratee(predicate,3)))}function sample(collection){var func=isArray(collection)?arraySample:baseSample;return func(collection)}function sampleSize(collection,n,guard){if(guard?isIterateeCall(collection,n,guard):n===undefined){n=1}else{n=toInteger(n)}var func=isArray(collection)?arraySampleSize:baseSampleSize;return func(collection,n)}function shuffle(collection){var func=isArray(collection)?arrayShuffle:baseShuffle;return func(collection)}function size(collection){if(collection==null){return 0}if(isArrayLike(collection)){return isString(collection)?stringSize(collection):collection.length}var tag=getTag(collection);if(tag==mapTag||tag==setTag){return collection.size}return baseKeys(collection).length}function some(collection,predicate,guard){var func=isArray(collection)?arraySome:baseSome;if(guard&&isIterateeCall(collection,predicate,guard)){predicate=undefined}return func(collection,getIteratee(predicate,3))}var sortBy=baseRest((function(collection,iteratees){if(collection==null){return[]}var length=iteratees.length;if(length>1&&isIterateeCall(collection,iteratees[0],iteratees[1])){iteratees=[]}else if(length>2&&isIterateeCall(iteratees[0],iteratees[1],iteratees[2])){iteratees=[iteratees[0]]}return baseOrderBy(collection,baseFlatten(iteratees,1),[])}));var now=ctxNow||function(){return root.Date.now()};function after(n,func){if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}n=toInteger(n);return function(){if(--n<1){return func.apply(this,arguments)}}}function ary(func,n,guard){n=guard?undefined:n;n=func&&n==null?func.length:n;return createWrap(func,WRAP_ARY_FLAG,undefined,undefined,undefined,undefined,n)}function before(n,func){var result;if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}n=toInteger(n);return function(){if(--n>0){result=func.apply(this,arguments)}if(n<=1){func=undefined}return result}}var bind=baseRest((function(func,thisArg,partials){var bitmask=WRAP_BIND_FLAG;if(partials.length){var holders=replaceHolders(partials,getHolder(bind));bitmask|=WRAP_PARTIAL_FLAG}return createWrap(func,bitmask,thisArg,partials,holders)}));var bindKey=baseRest((function(object,key,partials){var bitmask=WRAP_BIND_FLAG|WRAP_BIND_KEY_FLAG;if(partials.length){var holders=replaceHolders(partials,getHolder(bindKey));bitmask|=WRAP_PARTIAL_FLAG}return createWrap(key,bitmask,object,partials,holders)}));function curry(func,arity,guard){arity=guard?undefined:arity;var result=createWrap(func,WRAP_CURRY_FLAG,undefined,undefined,undefined,undefined,undefined,arity);result.placeholder=curry.placeholder;return result}function curryRight(func,arity,guard){arity=guard?undefined:arity;var result=createWrap(func,WRAP_CURRY_RIGHT_FLAG,undefined,undefined,undefined,undefined,undefined,arity);result.placeholder=curryRight.placeholder;return result}function debounce(func,wait,options){var lastArgs,lastThis,maxWait,result,timerId,lastCallTime,lastInvokeTime=0,leading=false,maxing=false,trailing=true;if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}wait=toNumber(wait)||0;if(isObject(options)){leading=!!options.leading;maxing="maxWait"in options;maxWait=maxing?nativeMax(toNumber(options.maxWait)||0,wait):maxWait;trailing="trailing"in options?!!options.trailing:trailing}function invokeFunc(time){var args=lastArgs,thisArg=lastThis;lastArgs=lastThis=undefined;lastInvokeTime=time;result=func.apply(thisArg,args);return result}function leadingEdge(time){lastInvokeTime=time;timerId=setTimeout(timerExpired,wait);return leading?invokeFunc(time):result}function remainingWait(time){var timeSinceLastCall=time-lastCallTime,timeSinceLastInvoke=time-lastInvokeTime,timeWaiting=wait-timeSinceLastCall;return maxing?nativeMin(timeWaiting,maxWait-timeSinceLastInvoke):timeWaiting}function shouldInvoke(time){var timeSinceLastCall=time-lastCallTime,timeSinceLastInvoke=time-lastInvokeTime;return lastCallTime===undefined||timeSinceLastCall>=wait||timeSinceLastCall<0||maxing&&timeSinceLastInvoke>=maxWait}function timerExpired(){var time=now();if(shouldInvoke(time)){return trailingEdge(time)}timerId=setTimeout(timerExpired,remainingWait(time))}function trailingEdge(time){timerId=undefined;if(trailing&&lastArgs){return invokeFunc(time)}lastArgs=lastThis=undefined;return result}function cancel(){if(timerId!==undefined){clearTimeout(timerId)}lastInvokeTime=0;lastArgs=lastCallTime=lastThis=timerId=undefined}function flush(){return timerId===undefined?result:trailingEdge(now())}function debounced(){var time=now(),isInvoking=shouldInvoke(time);lastArgs=arguments;lastThis=this;lastCallTime=time;if(isInvoking){if(timerId===undefined){return leadingEdge(lastCallTime)}if(maxing){timerId=setTimeout(timerExpired,wait);return invokeFunc(lastCallTime)}}if(timerId===undefined){timerId=setTimeout(timerExpired,wait)}return result}debounced.cancel=cancel;debounced.flush=flush;return debounced}var defer=baseRest((function(func,args){return baseDelay(func,1,args)}));var delay=baseRest((function(func,wait,args){return baseDelay(func,toNumber(wait)||0,args)}));function flip(func){return createWrap(func,WRAP_FLIP_FLAG)}function memoize(func,resolver){if(typeof func!="function"||resolver!=null&&typeof resolver!="function"){throw new TypeError(FUNC_ERROR_TEXT)}var memoized=function(){var args=arguments,key=resolver?resolver.apply(this,args):args[0],cache=memoized.cache;if(cache.has(key)){return cache.get(key)}var result=func.apply(this,args);memoized.cache=cache.set(key,result)||cache;return result};memoized.cache=new(memoize.Cache||MapCache);return memoized}memoize.Cache=MapCache;function negate(predicate){if(typeof predicate!="function"){throw new TypeError(FUNC_ERROR_TEXT)}return function(){var args=arguments;switch(args.length){case 0:return!predicate.call(this);case 1:return!predicate.call(this,args[0]);case 2:return!predicate.call(this,args[0],args[1]);case 3:return!predicate.call(this,args[0],args[1],args[2])}return!predicate.apply(this,args)}}function once(func){return before(2,func)}var overArgs=castRest((function(func,transforms){transforms=transforms.length==1&&isArray(transforms[0])?arrayMap(transforms[0],baseUnary(getIteratee())):arrayMap(baseFlatten(transforms,1),baseUnary(getIteratee()));var funcsLength=transforms.length;return baseRest((function(args){var index=-1,length=nativeMin(args.length,funcsLength);while(++index<length){args[index]=transforms[index].call(this,args[index])}return apply(func,this,args)}))}));var partial=baseRest((function(func,partials){var holders=replaceHolders(partials,getHolder(partial));return createWrap(func,WRAP_PARTIAL_FLAG,undefined,partials,holders)}));var partialRight=baseRest((function(func,partials){var holders=replaceHolders(partials,getHolder(partialRight));return createWrap(func,WRAP_PARTIAL_RIGHT_FLAG,undefined,partials,holders)}));var rearg=flatRest((function(func,indexes){return createWrap(func,WRAP_REARG_FLAG,undefined,undefined,undefined,indexes)}));function rest(func,start){if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}start=start===undefined?start:toInteger(start);return baseRest(func,start)}function spread(func,start){if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}start=start==null?0:nativeMax(toInteger(start),0);return baseRest((function(args){var array=args[start],otherArgs=castSlice(args,0,start);if(array){arrayPush(otherArgs,array)}return apply(func,this,otherArgs)}))}function throttle(func,wait,options){var leading=true,trailing=true;if(typeof func!="function"){throw new TypeError(FUNC_ERROR_TEXT)}if(isObject(options)){leading="leading"in options?!!options.leading:leading;trailing="trailing"in options?!!options.trailing:trailing}return debounce(func,wait,{leading,maxWait:wait,trailing})}function unary(func){return ary(func,1)}function wrap(value,wrapper){return partial(castFunction(wrapper),value)}function castArray(){if(!arguments.length){return[]}var value=arguments[0];return isArray(value)?value:[value]}function clone(value){return baseClone(value,CLONE_SYMBOLS_FLAG)}function cloneWith(value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return baseClone(value,CLONE_SYMBOLS_FLAG,customizer)}function cloneDeep(value){return baseClone(value,CLONE_DEEP_FLAG|CLONE_SYMBOLS_FLAG)}function cloneDeepWith(value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return baseClone(value,CLONE_DEEP_FLAG|CLONE_SYMBOLS_FLAG,customizer)}function conformsTo(object,source){return source==null||baseConformsTo(object,source,keys(source))}function eq(value,other){return value===other||value!==value&&other!==other}var gt=createRelationalOperation(baseGt);var gte=createRelationalOperation((function(value,other){return value>=other}));var isArguments=baseIsArguments(function(){return arguments}())?baseIsArguments:function(value){return isObjectLike(value)&&hasOwnProperty.call(value,"callee")&&!propertyIsEnumerable.call(value,"callee")};var isArray=Array.isArray;var isArrayBuffer=nodeIsArrayBuffer?baseUnary(nodeIsArrayBuffer):baseIsArrayBuffer;function isArrayLike(value){return value!=null&&isLength(value.length)&&!isFunction(value)}function isArrayLikeObject(value){return isObjectLike(value)&&isArrayLike(value)}function isBoolean(value){return value===true||value===false||isObjectLike(value)&&baseGetTag(value)==boolTag}var isBuffer=nativeIsBuffer||stubFalse;var isDate=nodeIsDate?baseUnary(nodeIsDate):baseIsDate;function isElement(value){return isObjectLike(value)&&value.nodeType===1&&!isPlainObject(value)}function isEmpty(value){if(value==null){return true}if(isArrayLike(value)&&(isArray(value)||typeof value=="string"||typeof value.splice=="function"||isBuffer(value)||isTypedArray(value)||isArguments(value))){return!value.length}var tag=getTag(value);if(tag==mapTag||tag==setTag){return!value.size}if(isPrototype(value)){return!baseKeys(value).length}for(var key in value){if(hasOwnProperty.call(value,key)){return false}}return true}function isEqual(value,other){return baseIsEqual(value,other)}function isEqualWith(value,other,customizer){customizer=typeof customizer=="function"?customizer:undefined;var result=customizer?customizer(value,other):undefined;return result===undefined?baseIsEqual(value,other,undefined,customizer):!!result}function isError(value){if(!isObjectLike(value)){return false}var tag=baseGetTag(value);return tag==errorTag||tag==domExcTag||typeof value.message=="string"&&typeof value.name=="string"&&!isPlainObject(value)}function isFinite(value){return typeof value=="number"&&nativeIsFinite(value)}function isFunction(value){if(!isObject(value)){return false}var tag=baseGetTag(value);return tag==funcTag||tag==genTag||tag==asyncTag||tag==proxyTag}function isInteger(value){return typeof value=="number"&&value==toInteger(value)}function isLength(value){return typeof value=="number"&&value>-1&&value%1==0&&value<=MAX_SAFE_INTEGER}function isObject(value){var type=typeof value;return value!=null&&(type=="object"||type=="function")}function isObjectLike(value){return value!=null&&typeof value=="object"}var isMap=nodeIsMap?baseUnary(nodeIsMap):baseIsMap;function isMatch(object,source){return object===source||baseIsMatch(object,source,getMatchData(source))}function isMatchWith(object,source,customizer){customizer=typeof customizer=="function"?customizer:undefined;return baseIsMatch(object,source,getMatchData(source),customizer)}function isNaN(value){return isNumber(value)&&value!=+value}function isNative(value){if(isMaskable(value)){throw new Error(CORE_ERROR_TEXT)}return baseIsNative(value)}function isNull(value){return value===null}function isNil(value){return value==null}function isNumber(value){return typeof value=="number"||isObjectLike(value)&&baseGetTag(value)==numberTag}function isPlainObject(value){if(!isObjectLike(value)||baseGetTag(value)!=objectTag){return false}var proto=getPrototype(value);if(proto===null){return true}var Ctor=hasOwnProperty.call(proto,"constructor")&&proto.constructor;return typeof Ctor=="function"&&Ctor instanceof Ctor&&funcToString.call(Ctor)==objectCtorString}var isRegExp=nodeIsRegExp?baseUnary(nodeIsRegExp):baseIsRegExp;function isSafeInteger(value){return isInteger(value)&&value>=-MAX_SAFE_INTEGER&&value<=MAX_SAFE_INTEGER}var isSet=nodeIsSet?baseUnary(nodeIsSet):baseIsSet;function isString(value){return typeof value=="string"||!isArray(value)&&isObjectLike(value)&&baseGetTag(value)==stringTag}function isSymbol(value){return typeof value=="symbol"||isObjectLike(value)&&baseGetTag(value)==symbolTag}var isTypedArray=nodeIsTypedArray?baseUnary(nodeIsTypedArray):baseIsTypedArray;function isUndefined(value){return value===undefined}function isWeakMap(value){return isObjectLike(value)&&getTag(value)==weakMapTag}function isWeakSet(value){return isObjectLike(value)&&baseGetTag(value)==weakSetTag}var lt=createRelationalOperation(baseLt);var lte=createRelationalOperation((function(value,other){return value<=other}));function toArray(value){if(!value){return[]}if(isArrayLike(value)){return isString(value)?stringToArray(value):copyArray(value)}if(symIterator&&value[symIterator]){return iteratorToArray(value[symIterator]())}var tag=getTag(value),func=tag==mapTag?mapToArray:tag==setTag?setToArray:values;return func(value)}function toFinite(value){if(!value){return value===0?value:0}value=toNumber(value);if(value===INFINITY||value===-INFINITY){var sign=value<0?-1:1;return sign*MAX_INTEGER}return value===value?value:0}function toInteger(value){var result=toFinite(value),remainder=result%1;return result===result?remainder?result-remainder:result:0}function toLength(value){return value?baseClamp(toInteger(value),0,MAX_ARRAY_LENGTH):0}function toNumber(value){if(typeof value=="number"){return value}if(isSymbol(value)){return NAN}if(isObject(value)){var other=typeof value.valueOf=="function"?value.valueOf():value;value=isObject(other)?other+"":other}if(typeof value!="string"){return value===0?value:+value}value=value.replace(reTrim,"");var isBinary=reIsBinary.test(value);return isBinary||reIsOctal.test(value)?freeParseInt(value.slice(2),isBinary?2:8):reIsBadHex.test(value)?NAN:+value}function toPlainObject(value){return copyObject(value,keysIn(value))}function toSafeInteger(value){return value?baseClamp(toInteger(value),-MAX_SAFE_INTEGER,MAX_SAFE_INTEGER):value===0?value:0}function toString(value){return value==null?"":baseToString(value)}var assign=createAssigner((function(object,source){if(isPrototype(source)||isArrayLike(source)){copyObject(source,keys(source),object);return}for(var key in source){if(hasOwnProperty.call(source,key)){assignValue(object,key,source[key])}}}));var assignIn=createAssigner((function(object,source){copyObject(source,keysIn(source),object)}));var assignInWith=createAssigner((function(object,source,srcIndex,customizer){copyObject(source,keysIn(source),object,customizer)}));var assignWith=createAssigner((function(object,source,srcIndex,customizer){copyObject(source,keys(source),object,customizer)}));var at=flatRest(baseAt);function create(prototype,properties){var result=baseCreate(prototype);return properties==null?result:baseAssign(result,properties)}var defaults=baseRest((function(object,sources){object=Object(object);var index=-1;var length=sources.length;var guard=length>2?sources[2]:undefined;if(guard&&isIterateeCall(sources[0],sources[1],guard)){length=1}while(++index<length){var source=sources[index];var props=keysIn(source);var propsIndex=-1;var propsLength=props.length;while(++propsIndex<propsLength){var key=props[propsIndex];var value=object[key];if(value===undefined||eq(value,objectProto[key])&&!hasOwnProperty.call(object,key)){object[key]=source[key]}}}return object}));var defaultsDeep=baseRest((function(args){args.push(undefined,customDefaultsMerge);return apply(mergeWith,undefined,args)}));function findKey(object,predicate){return baseFindKey(object,getIteratee(predicate,3),baseForOwn)}function findLastKey(object,predicate){return baseFindKey(object,getIteratee(predicate,3),baseForOwnRight)}function forIn(object,iteratee){return object==null?object:baseFor(object,getIteratee(iteratee,3),keysIn)}function forInRight(object,iteratee){return object==null?object:baseForRight(object,getIteratee(iteratee,3),keysIn)}function forOwn(object,iteratee){return object&&baseForOwn(object,getIteratee(iteratee,3))}function forOwnRight(object,iteratee){return object&&baseForOwnRight(object,getIteratee(iteratee,3))}function functions(object){return object==null?[]:baseFunctions(object,keys(object))}function functionsIn(object){return object==null?[]:baseFunctions(object,keysIn(object))}function get(object,path,defaultValue){var result=object==null?undefined:baseGet(object,path);return result===undefined?defaultValue:result}function has(object,path){return object!=null&&hasPath(object,path,baseHas)}function hasIn(object,path){return object!=null&&hasPath(object,path,baseHasIn)}var invert=createInverter((function(result,value,key){if(value!=null&&typeof value.toString!="function"){value=nativeObjectToString.call(value)}result[value]=key}),constant(identity));var invertBy=createInverter((function(result,value,key){if(value!=null&&typeof value.toString!="function"){value=nativeObjectToString.call(value)}if(hasOwnProperty.call(result,value)){result[value].push(key)}else{result[value]=[key]}}),getIteratee);var invoke=baseRest(baseInvoke);function keys(object){return isArrayLike(object)?arrayLikeKeys(object):baseKeys(object)}function keysIn(object){return isArrayLike(object)?arrayLikeKeys(object,true):baseKeysIn(object)}function mapKeys(object,iteratee){var result={};iteratee=getIteratee(iteratee,3);baseForOwn(object,(function(value,key,object){baseAssignValue(result,iteratee(value,key,object),value)}));return result}function mapValues(object,iteratee){var result={};iteratee=getIteratee(iteratee,3);baseForOwn(object,(function(value,key,object){baseAssignValue(result,key,iteratee(value,key,object))}));return result}var merge=createAssigner((function(object,source,srcIndex){baseMerge(object,source,srcIndex)}));var mergeWith=createAssigner((function(object,source,srcIndex,customizer){baseMerge(object,source,srcIndex,customizer)}));var omit=flatRest((function(object,paths){var result={};if(object==null){return result}var isDeep=false;paths=arrayMap(paths,(function(path){path=castPath(path,object);isDeep||(isDeep=path.length>1);return path}));copyObject(object,getAllKeysIn(object),result);if(isDeep){result=baseClone(result,CLONE_DEEP_FLAG|CLONE_FLAT_FLAG|CLONE_SYMBOLS_FLAG,customOmitClone)}var length=paths.length;while(length--){baseUnset(result,paths[length])}return result}));function omitBy(object,predicate){return pickBy(object,negate(getIteratee(predicate)))}var pick=flatRest((function(object,paths){return object==null?{}:basePick(object,paths)}));function pickBy(object,predicate){if(object==null){return{}}var props=arrayMap(getAllKeysIn(object),(function(prop){return[prop]}));predicate=getIteratee(predicate);return basePickBy(object,props,(function(value,path){return predicate(value,path[0])}))}function result(object,path,defaultValue){path=castPath(path,object);var index=-1,length=path.length;if(!length){length=1;object=undefined}while(++index<length){var value=object==null?undefined:object[toKey(path[index])];if(value===undefined){index=length;value=defaultValue}object=isFunction(value)?value.call(object):value}return object}function set(object,path,value){return object==null?object:baseSet(object,path,value)}function setWith(object,path,value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return object==null?object:baseSet(object,path,value,customizer)}var toPairs=createToPairs(keys);var toPairsIn=createToPairs(keysIn);function transform(object,iteratee,accumulator){var isArr=isArray(object),isArrLike=isArr||isBuffer(object)||isTypedArray(object);iteratee=getIteratee(iteratee,4);if(accumulator==null){var Ctor=object&&object.constructor;if(isArrLike){accumulator=isArr?new Ctor:[]}else if(isObject(object)){accumulator=isFunction(Ctor)?baseCreate(getPrototype(object)):{}}else{accumulator={}}}(isArrLike?arrayEach:baseForOwn)(object,(function(value,index,object){return iteratee(accumulator,value,index,object)}));return accumulator}function unset(object,path){return object==null?true:baseUnset(object,path)}function update(object,path,updater){return object==null?object:baseUpdate(object,path,castFunction(updater))}function updateWith(object,path,updater,customizer){customizer=typeof customizer=="function"?customizer:undefined;return object==null?object:baseUpdate(object,path,castFunction(updater),customizer)}function values(object){return object==null?[]:baseValues(object,keys(object))}function valuesIn(object){return object==null?[]:baseValues(object,keysIn(object))}function clamp(number,lower,upper){if(upper===undefined){upper=lower;lower=undefined}if(upper!==undefined){upper=toNumber(upper);upper=upper===upper?upper:0}if(lower!==undefined){lower=toNumber(lower);lower=lower===lower?lower:0}return baseClamp(toNumber(number),lower,upper)}function inRange(number,start,end){start=toFinite(start);if(end===undefined){end=start;start=0}else{end=toFinite(end)}number=toNumber(number);return baseInRange(number,start,end)}function random(lower,upper,floating){if(floating&&typeof floating!="boolean"&&isIterateeCall(lower,upper,floating)){upper=floating=undefined}if(floating===undefined){if(typeof upper=="boolean"){floating=upper;upper=undefined}else if(typeof lower=="boolean"){floating=lower;lower=undefined}}if(lower===undefined&&upper===undefined){lower=0;upper=1}else{lower=toFinite(lower);if(upper===undefined){upper=lower;lower=0}else{upper=toFinite(upper)}}if(lower>upper){var temp=lower;lower=upper;upper=temp}if(floating||lower%1||upper%1){var rand=nativeRandom();return nativeMin(lower+rand*(upper-lower+freeParseFloat("1e-"+((rand+"").length-1))),upper)}return baseRandom(lower,upper)}var camelCase=createCompounder((function(result,word,index){word=word.toLowerCase();return result+(index?capitalize(word):word)}));function capitalize(string){return upperFirst(toString(string).toLowerCase())}function deburr(string){string=toString(string);return string&&string.replace(reLatin,deburrLetter).replace(reComboMark,"")}function endsWith(string,target,position){string=toString(string);target=baseToString(target);var length=string.length;position=position===undefined?length:baseClamp(toInteger(position),0,length);var end=position;position-=target.length;return position>=0&&string.slice(position,end)==target}function escape(string){string=toString(string);return string&&reHasUnescapedHtml.test(string)?string.replace(reUnescapedHtml,escapeHtmlChar):string}function escapeRegExp(string){string=toString(string);return string&&reHasRegExpChar.test(string)?string.replace(reRegExpChar,"\\$&"):string}var kebabCase=createCompounder((function(result,word,index){return result+(index?"-":"")+word.toLowerCase()}));var lowerCase=createCompounder((function(result,word,index){return result+(index?" ":"")+word.toLowerCase()}));var lowerFirst=createCaseFirst("toLowerCase");function pad(string,length,chars){string=toString(string);length=toInteger(length);var strLength=length?stringSize(string):0;if(!length||strLength>=length){return string}var mid=(length-strLength)/2;return createPadding(nativeFloor(mid),chars)+string+createPadding(nativeCeil(mid),chars)}function padEnd(string,length,chars){string=toString(string);length=toInteger(length);var strLength=length?stringSize(string):0;return length&&strLength<length?string+createPadding(length-strLength,chars):string}function padStart(string,length,chars){string=toString(string);length=toInteger(length);var strLength=length?stringSize(string):0;return length&&strLength<length?createPadding(length-strLength,chars)+string:string}function parseInt(string,radix,guard){if(guard||radix==null){radix=0}else if(radix){radix=+radix}return nativeParseInt(toString(string).replace(reTrimStart,""),radix||0)}function repeat(string,n,guard){if(guard?isIterateeCall(string,n,guard):n===undefined){n=1}else{n=toInteger(n)}return baseRepeat(toString(string),n)}function replace(){var args=arguments,string=toString(args[0]);return args.length<3?string:string.replace(args[1],args[2])}var snakeCase=createCompounder((function(result,word,index){return result+(index?"_":"")+word.toLowerCase()}));function split(string,separator,limit){if(limit&&typeof limit!="number"&&isIterateeCall(string,separator,limit)){separator=limit=undefined}limit=limit===undefined?MAX_ARRAY_LENGTH:limit>>>0;if(!limit){return[]}string=toString(string);if(string&&(typeof separator=="string"||separator!=null&&!isRegExp(separator))){separator=baseToString(separator);if(!separator&&hasUnicode(string)){return castSlice(stringToArray(string),0,limit)}}return string.split(separator,limit)}var startCase=createCompounder((function(result,word,index){return result+(index?" ":"")+upperFirst(word)}));function startsWith(string,target,position){string=toString(string);position=position==null?0:baseClamp(toInteger(position),0,string.length);target=baseToString(target);return string.slice(position,position+target.length)==target}function template(string,options,guard){var settings=lodash.templateSettings;if(guard&&isIterateeCall(string,options,guard)){options=undefined}string=toString(string);options=assignInWith({},options,settings,customDefaultsAssignIn);var imports=assignInWith({},options.imports,settings.imports,customDefaultsAssignIn),importsKeys=keys(imports),importsValues=baseValues(imports,importsKeys);var isEscaping,isEvaluating,index=0,interpolate=options.interpolate||reNoMatch,source="__p += '";var reDelimiters=RegExp((options.escape||reNoMatch).source+"|"+interpolate.source+"|"+(interpolate===reInterpolate?reEsTemplate:reNoMatch).source+"|"+(options.evaluate||reNoMatch).source+"|$","g");var sourceURL="//# sourceURL="+("sourceURL"in options?options.sourceURL:"lodash.templateSources["+ ++templateCounter+"]")+"\n";string.replace(reDelimiters,(function(match,escapeValue,interpolateValue,esTemplateValue,evaluateValue,offset){interpolateValue||(interpolateValue=esTemplateValue);source+=string.slice(index,offset).replace(reUnescapedString,escapeStringChar);if(escapeValue){isEscaping=true;source+="' +\n__e("+escapeValue+") +\n'"}if(evaluateValue){isEvaluating=true;source+="';\n"+evaluateValue+";\n__p += '"}if(interpolateValue){source+="' +\n((__t = ("+interpolateValue+")) == null ? '' : __t) +\n'"}index=offset+match.length;return match}));source+="';\n";var variable=options.variable;if(!variable){source="with (obj) {\n"+source+"\n}\n"}source=(isEvaluating?source.replace(reEmptyStringLeading,""):source).replace(reEmptyStringMiddle,"$1").replace(reEmptyStringTrailing,"$1;");source="function("+(variable||"obj")+") {\n"+(variable?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(isEscaping?", __e = _.escape":"")+(isEvaluating?", __j = Array.prototype.join;\n"+"function print() { __p += __j.call(arguments, '') }\n":";\n")+source+"return __p\n}";var result=attempt((function(){return Function(importsKeys,sourceURL+"return "+source).apply(undefined,importsValues)}));result.source=source;if(isError(result)){throw result}return result}function toLower(value){return toString(value).toLowerCase()}function toUpper(value){return toString(value).toUpperCase()}function trim(string,chars,guard){string=toString(string);if(string&&(guard||chars===undefined)){return string.replace(reTrim,"")}if(!string||!(chars=baseToString(chars))){return string}var strSymbols=stringToArray(string),chrSymbols=stringToArray(chars),start=charsStartIndex(strSymbols,chrSymbols),end=charsEndIndex(strSymbols,chrSymbols)+1;return castSlice(strSymbols,start,end).join("")}function trimEnd(string,chars,guard){string=toString(string);if(string&&(guard||chars===undefined)){return string.replace(reTrimEnd,"")}if(!string||!(chars=baseToString(chars))){return string}var strSymbols=stringToArray(string),end=charsEndIndex(strSymbols,stringToArray(chars))+1;return castSlice(strSymbols,0,end).join("")}function trimStart(string,chars,guard){string=toString(string);if(string&&(guard||chars===undefined)){return string.replace(reTrimStart,"")}if(!string||!(chars=baseToString(chars))){return string}var strSymbols=stringToArray(string),start=charsStartIndex(strSymbols,stringToArray(chars));return castSlice(strSymbols,start).join("")}function truncate(string,options){var length=DEFAULT_TRUNC_LENGTH,omission=DEFAULT_TRUNC_OMISSION;if(isObject(options)){var separator="separator"in options?options.separator:separator;length="length"in options?toInteger(options.length):length;omission="omission"in options?baseToString(options.omission):omission}string=toString(string);var strLength=string.length;if(hasUnicode(string)){var strSymbols=stringToArray(string);strLength=strSymbols.length}if(length>=strLength){return string}var end=length-stringSize(omission);if(end<1){return omission}var result=strSymbols?castSlice(strSymbols,0,end).join(""):string.slice(0,end);if(separator===undefined){return result+omission}if(strSymbols){end+=result.length-end}if(isRegExp(separator)){if(string.slice(end).search(separator)){var match,substring=result;if(!separator.global){separator=RegExp(separator.source,toString(reFlags.exec(separator))+"g")}separator.lastIndex=0;while(match=separator.exec(substring)){var newEnd=match.index}result=result.slice(0,newEnd===undefined?end:newEnd)}}else if(string.indexOf(baseToString(separator),end)!=end){var index=result.lastIndexOf(separator);if(index>-1){result=result.slice(0,index)}}return result+omission}function unescape(string){string=toString(string);return string&&reHasEscapedHtml.test(string)?string.replace(reEscapedHtml,unescapeHtmlChar):string}var upperCase=createCompounder((function(result,word,index){return result+(index?" ":"")+word.toUpperCase()}));var upperFirst=createCaseFirst("toUpperCase");function words(string,pattern,guard){string=toString(string);pattern=guard?undefined:pattern;if(pattern===undefined){return hasUnicodeWord(string)?unicodeWords(string):asciiWords(string)}return string.match(pattern)||[]}var attempt=baseRest((function(func,args){try{return apply(func,undefined,args)}catch(e){return isError(e)?e:new Error(e)}}));var bindAll=flatRest((function(object,methodNames){arrayEach(methodNames,(function(key){key=toKey(key);baseAssignValue(object,key,bind(object[key],object))}));return object}));function cond(pairs){var length=pairs==null?0:pairs.length,toIteratee=getIteratee();pairs=!length?[]:arrayMap(pairs,(function(pair){if(typeof pair[1]!="function"){throw new TypeError(FUNC_ERROR_TEXT)}return[toIteratee(pair[0]),pair[1]]}));return baseRest((function(args){var index=-1;while(++index<length){var pair=pairs[index];if(apply(pair[0],this,args)){return apply(pair[1],this,args)}}}))}function conforms(source){return baseConforms(baseClone(source,CLONE_DEEP_FLAG))}function constant(value){return function(){return value}}function defaultTo(value,defaultValue){return value==null||value!==value?defaultValue:value}var flow=createFlow();var flowRight=createFlow(true);function identity(value){return value}function iteratee(func){return baseIteratee(typeof func=="function"?func:baseClone(func,CLONE_DEEP_FLAG))}function matches(source){return baseMatches(baseClone(source,CLONE_DEEP_FLAG))}function matchesProperty(path,srcValue){return baseMatchesProperty(path,baseClone(srcValue,CLONE_DEEP_FLAG))}var method=baseRest((function(path,args){return function(object){return baseInvoke(object,path,args)}}));var methodOf=baseRest((function(object,args){return function(path){return baseInvoke(object,path,args)}}));function mixin(object,source,options){var props=keys(source),methodNames=baseFunctions(source,props);if(options==null&&!(isObject(source)&&(methodNames.length||!props.length))){options=source;source=object;object=this;methodNames=baseFunctions(source,keys(source))}var chain=!(isObject(options)&&"chain"in options)||!!options.chain,isFunc=isFunction(object);arrayEach(methodNames,(function(methodName){var func=source[methodName];object[methodName]=func;if(isFunc){object.prototype[methodName]=function(){var chainAll=this.__chain__;if(chain||chainAll){var result=object(this.__wrapped__),actions=result.__actions__=copyArray(this.__actions__);actions.push({func,args:arguments,thisArg:object});result.__chain__=chainAll;return result}return func.apply(object,arrayPush([this.value()],arguments))}}}));return object}function noConflict(){if(root._===this){root._=oldDash}return this}function noop(){}function nthArg(n){n=toInteger(n);return baseRest((function(args){return baseNth(args,n)}))}var over=createOver(arrayMap);var overEvery=createOver(arrayEvery);var overSome=createOver(arraySome);function property(path){return isKey(path)?baseProperty(toKey(path)):basePropertyDeep(path)}function propertyOf(object){return function(path){return object==null?undefined:baseGet(object,path)}}var range=createRange();var rangeRight=createRange(true);function stubArray(){return[]}function stubFalse(){return false}function stubObject(){return{}}function stubString(){return""}function stubTrue(){return true}function times(n,iteratee){n=toInteger(n);if(n<1||n>MAX_SAFE_INTEGER){return[]}var index=MAX_ARRAY_LENGTH,length=nativeMin(n,MAX_ARRAY_LENGTH);iteratee=getIteratee(iteratee);n-=MAX_ARRAY_LENGTH;var result=baseTimes(length,iteratee);while(++index<n){iteratee(index)}return result}function toPath(value){if(isArray(value)){return arrayMap(value,toKey)}return isSymbol(value)?[value]:copyArray(stringToPath(toString(value)))}function uniqueId(prefix){var id=++idCounter;return toString(prefix)+id}var add=createMathOperation((function(augend,addend){return augend+addend}),0);var ceil=createRound("ceil");var divide=createMathOperation((function(dividend,divisor){return dividend/divisor}),1);var floor=createRound("floor");function max(array){return array&&array.length?baseExtremum(array,identity,baseGt):undefined}function maxBy(array,iteratee){return array&&array.length?baseExtremum(array,getIteratee(iteratee,2),baseGt):undefined}function mean(array){return baseMean(array,identity)}function meanBy(array,iteratee){return baseMean(array,getIteratee(iteratee,2))}function min(array){return array&&array.length?baseExtremum(array,identity,baseLt):undefined}function minBy(array,iteratee){return array&&array.length?baseExtremum(array,getIteratee(iteratee,2),baseLt):undefined}var multiply=createMathOperation((function(multiplier,multiplicand){return multiplier*multiplicand}),1);var round=createRound("round");var subtract=createMathOperation((function(minuend,subtrahend){return minuend-subtrahend}),0);function sum(array){return array&&array.length?baseSum(array,identity):0}function sumBy(array,iteratee){return array&&array.length?baseSum(array,getIteratee(iteratee,2)):0}lodash.after=after;lodash.ary=ary;lodash.assign=assign;lodash.assignIn=assignIn;lodash.assignInWith=assignInWith;lodash.assignWith=assignWith;lodash.at=at;lodash.before=before;lodash.bind=bind;lodash.bindAll=bindAll;lodash.bindKey=bindKey;lodash.castArray=castArray;lodash.chain=chain;lodash.chunk=chunk;lodash.compact=compact;lodash.concat=concat;lodash.cond=cond;lodash.conforms=conforms;lodash.constant=constant;lodash.countBy=countBy;lodash.create=create;lodash.curry=curry;lodash.curryRight=curryRight;lodash.debounce=debounce;lodash.defaults=defaults;lodash.defaultsDeep=defaultsDeep;lodash.defer=defer;lodash.delay=delay;lodash.difference=difference;lodash.differenceBy=differenceBy;lodash.differenceWith=differenceWith;lodash.drop=drop;lodash.dropRight=dropRight;lodash.dropRightWhile=dropRightWhile;lodash.dropWhile=dropWhile;lodash.fill=fill;lodash.filter=filter;lodash.flatMap=flatMap;lodash.flatMapDeep=flatMapDeep;lodash.flatMapDepth=flatMapDepth;lodash.flatten=flatten;lodash.flattenDeep=flattenDeep;lodash.flattenDepth=flattenDepth;lodash.flip=flip;lodash.flow=flow;lodash.flowRight=flowRight;lodash.fromPairs=fromPairs;lodash.functions=functions;lodash.functionsIn=functionsIn;lodash.groupBy=groupBy;lodash.initial=initial;lodash.intersection=intersection;lodash.intersectionBy=intersectionBy;lodash.intersectionWith=intersectionWith;lodash.invert=invert;lodash.invertBy=invertBy;lodash.invokeMap=invokeMap;lodash.iteratee=iteratee;lodash.keyBy=keyBy;lodash.keys=keys;lodash.keysIn=keysIn;lodash.map=map;lodash.mapKeys=mapKeys;lodash.mapValues=mapValues;lodash.matches=matches;lodash.matchesProperty=matchesProperty;lodash.memoize=memoize;lodash.merge=merge;lodash.mergeWith=mergeWith;lodash.method=method;lodash.methodOf=methodOf;lodash.mixin=mixin;lodash.negate=negate;lodash.nthArg=nthArg;lodash.omit=omit;lodash.omitBy=omitBy;lodash.once=once;lodash.orderBy=orderBy;lodash.over=over;lodash.overArgs=overArgs;lodash.overEvery=overEvery;lodash.overSome=overSome;lodash.partial=partial;lodash.partialRight=partialRight;lodash.partition=partition;lodash.pick=pick;lodash.pickBy=pickBy;lodash.property=property;lodash.propertyOf=propertyOf;lodash.pull=pull;lodash.pullAll=pullAll;lodash.pullAllBy=pullAllBy;lodash.pullAllWith=pullAllWith;lodash.pullAt=pullAt;lodash.range=range;lodash.rangeRight=rangeRight;lodash.rearg=rearg;lodash.reject=reject;lodash.remove=remove;lodash.rest=rest;lodash.reverse=reverse;lodash.sampleSize=sampleSize;lodash.set=set;lodash.setWith=setWith;lodash.shuffle=shuffle;lodash.slice=slice;lodash.sortBy=sortBy;lodash.sortedUniq=sortedUniq;lodash.sortedUniqBy=sortedUniqBy;lodash.split=split;lodash.spread=spread;lodash.tail=tail;lodash.take=take;lodash.takeRight=takeRight;lodash.takeRightWhile=takeRightWhile;lodash.takeWhile=takeWhile;lodash.tap=tap;lodash.throttle=throttle;lodash.thru=thru;lodash.toArray=toArray;lodash.toPairs=toPairs;lodash.toPairsIn=toPairsIn;lodash.toPath=toPath;lodash.toPlainObject=toPlainObject;lodash.transform=transform;lodash.unary=unary;lodash.union=union;lodash.unionBy=unionBy;lodash.unionWith=unionWith;lodash.uniq=uniq;lodash.uniqBy=uniqBy;lodash.uniqWith=uniqWith;lodash.unset=unset;lodash.unzip=unzip;lodash.unzipWith=unzipWith;lodash.update=update;lodash.updateWith=updateWith;lodash.values=values;lodash.valuesIn=valuesIn;lodash.without=without;lodash.words=words;lodash.wrap=wrap;lodash.xor=xor;lodash.xorBy=xorBy;lodash.xorWith=xorWith;lodash.zip=zip;lodash.zipObject=zipObject;lodash.zipObjectDeep=zipObjectDeep;lodash.zipWith=zipWith;lodash.entries=toPairs;lodash.entriesIn=toPairsIn;lodash.extend=assignIn;lodash.extendWith=assignInWith;mixin(lodash,lodash);lodash.add=add;lodash.attempt=attempt;lodash.camelCase=camelCase;lodash.capitalize=capitalize;lodash.ceil=ceil;lodash.clamp=clamp;lodash.clone=clone;lodash.cloneDeep=cloneDeep;lodash.cloneDeepWith=cloneDeepWith;lodash.cloneWith=cloneWith;lodash.conformsTo=conformsTo;lodash.deburr=deburr;lodash.defaultTo=defaultTo;lodash.divide=divide;lodash.endsWith=endsWith;lodash.eq=eq;lodash.escape=escape;lodash.escapeRegExp=escapeRegExp;lodash.every=every;lodash.find=find;lodash.findIndex=findIndex;lodash.findKey=findKey;lodash.findLast=findLast;lodash.findLastIndex=findLastIndex;lodash.findLastKey=findLastKey;lodash.floor=floor;lodash.forEach=forEach;lodash.forEachRight=forEachRight;lodash.forIn=forIn;lodash.forInRight=forInRight;lodash.forOwn=forOwn;lodash.forOwnRight=forOwnRight;lodash.get=get;lodash.gt=gt;lodash.gte=gte;lodash.has=has;lodash.hasIn=hasIn;lodash.head=head;lodash.identity=identity;lodash.includes=includes;lodash.indexOf=indexOf;lodash.inRange=inRange;lodash.invoke=invoke;lodash.isArguments=isArguments;lodash.isArray=isArray;lodash.isArrayBuffer=isArrayBuffer;lodash.isArrayLike=isArrayLike;lodash.isArrayLikeObject=isArrayLikeObject;lodash.isBoolean=isBoolean;lodash.isBuffer=isBuffer;lodash.isDate=isDate;lodash.isElement=isElement;lodash.isEmpty=isEmpty;lodash.isEqual=isEqual;lodash.isEqualWith=isEqualWith;lodash.isError=isError;lodash.isFinite=isFinite;lodash.isFunction=isFunction;lodash.isInteger=isInteger;lodash.isLength=isLength;lodash.isMap=isMap;lodash.isMatch=isMatch;lodash.isMatchWith=isMatchWith;lodash.isNaN=isNaN;lodash.isNative=isNative;lodash.isNil=isNil;lodash.isNull=isNull;lodash.isNumber=isNumber;lodash.isObject=isObject;lodash.isObjectLike=isObjectLike;lodash.isPlainObject=isPlainObject;lodash.isRegExp=isRegExp;lodash.isSafeInteger=isSafeInteger;lodash.isSet=isSet;lodash.isString=isString;lodash.isSymbol=isSymbol;lodash.isTypedArray=isTypedArray;lodash.isUndefined=isUndefined;lodash.isWeakMap=isWeakMap;lodash.isWeakSet=isWeakSet;lodash.join=join;lodash.kebabCase=kebabCase;lodash.last=last;lodash.lastIndexOf=lastIndexOf;lodash.lowerCase=lowerCase;lodash.lowerFirst=lowerFirst;lodash.lt=lt;lodash.lte=lte;lodash.max=max;lodash.maxBy=maxBy;lodash.mean=mean;lodash.meanBy=meanBy;lodash.min=min;lodash.minBy=minBy;lodash.stubArray=stubArray;lodash.stubFalse=stubFalse;lodash.stubObject=stubObject;lodash.stubString=stubString;lodash.stubTrue=stubTrue;lodash.multiply=multiply;lodash.nth=nth;lodash.noConflict=noConflict;lodash.noop=noop;lodash.now=now;lodash.pad=pad;lodash.padEnd=padEnd;lodash.padStart=padStart;lodash.parseInt=parseInt;lodash.random=random;lodash.reduce=reduce;lodash.reduceRight=reduceRight;lodash.repeat=repeat;lodash.replace=replace;lodash.result=result;lodash.round=round;lodash.runInContext=runInContext;lodash.sample=sample;lodash.size=size;lodash.snakeCase=snakeCase;lodash.some=some;lodash.sortedIndex=sortedIndex;lodash.sortedIndexBy=sortedIndexBy;lodash.sortedIndexOf=sortedIndexOf;lodash.sortedLastIndex=sortedLastIndex;lodash.sortedLastIndexBy=sortedLastIndexBy;lodash.sortedLastIndexOf=sortedLastIndexOf;lodash.startCase=startCase;lodash.startsWith=startsWith;lodash.subtract=subtract;lodash.sum=sum;lodash.sumBy=sumBy;lodash.template=template;lodash.times=times;lodash.toFinite=toFinite;lodash.toInteger=toInteger;lodash.toLength=toLength;lodash.toLower=toLower;lodash.toNumber=toNumber;lodash.toSafeInteger=toSafeInteger;lodash.toString=toString;lodash.toUpper=toUpper;lodash.trim=trim;lodash.trimEnd=trimEnd;lodash.trimStart=trimStart;lodash.truncate=truncate;lodash.unescape=unescape;lodash.uniqueId=uniqueId;lodash.upperCase=upperCase;lodash.upperFirst=upperFirst;lodash.each=forEach;lodash.eachRight=forEachRight;lodash.first=head;mixin(lodash,function(){var source={};baseForOwn(lodash,(function(func,methodName){if(!hasOwnProperty.call(lodash.prototype,methodName)){source[methodName]=func}}));return source}(),{chain:false});lodash.VERSION=VERSION;arrayEach(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(methodName){lodash[methodName].placeholder=lodash}));arrayEach(["drop","take"],(function(methodName,index){LazyWrapper.prototype[methodName]=function(n){n=n===undefined?1:nativeMax(toInteger(n),0);var result=this.__filtered__&&!index?new LazyWrapper(this):this.clone();if(result.__filtered__){result.__takeCount__=nativeMin(n,result.__takeCount__)}else{result.__views__.push({size:nativeMin(n,MAX_ARRAY_LENGTH),type:methodName+(result.__dir__<0?"Right":"")})}return result};LazyWrapper.prototype[methodName+"Right"]=function(n){return this.reverse()[methodName](n).reverse()}}));arrayEach(["filter","map","takeWhile"],(function(methodName,index){var type=index+1,isFilter=type==LAZY_FILTER_FLAG||type==LAZY_WHILE_FLAG;LazyWrapper.prototype[methodName]=function(iteratee){var result=this.clone();result.__iteratees__.push({iteratee:getIteratee(iteratee,3),type});result.__filtered__=result.__filtered__||isFilter;return result}}));arrayEach(["head","last"],(function(methodName,index){var takeName="take"+(index?"Right":"");LazyWrapper.prototype[methodName]=function(){return this[takeName](1).value()[0]}}));arrayEach(["initial","tail"],(function(methodName,index){var dropName="drop"+(index?"":"Right");LazyWrapper.prototype[methodName]=function(){return this.__filtered__?new LazyWrapper(this):this[dropName](1)}}));LazyWrapper.prototype.compact=function(){return this.filter(identity)};LazyWrapper.prototype.find=function(predicate){return this.filter(predicate).head()};LazyWrapper.prototype.findLast=function(predicate){return this.reverse().find(predicate)};LazyWrapper.prototype.invokeMap=baseRest((function(path,args){if(typeof path=="function"){return new LazyWrapper(this)}return this.map((function(value){return baseInvoke(value,path,args)}))}));LazyWrapper.prototype.reject=function(predicate){return this.filter(negate(getIteratee(predicate)))};LazyWrapper.prototype.slice=function(start,end){start=toInteger(start);var result=this;if(result.__filtered__&&(start>0||end<0)){return new LazyWrapper(result)}if(start<0){result=result.takeRight(-start)}else if(start){result=result.drop(start)}if(end!==undefined){end=toInteger(end);result=end<0?result.dropRight(-end):result.take(end-start)}return result};LazyWrapper.prototype.takeRightWhile=function(predicate){return this.reverse().takeWhile(predicate).reverse()};LazyWrapper.prototype.toArray=function(){return this.take(MAX_ARRAY_LENGTH)};baseForOwn(LazyWrapper.prototype,(function(func,methodName){var checkIteratee=/^(?:filter|find|map|reject)|While$/.test(methodName),isTaker=/^(?:head|last)$/.test(methodName),lodashFunc=lodash[isTaker?"take"+(methodName=="last"?"Right":""):methodName],retUnwrapped=isTaker||/^find/.test(methodName);if(!lodashFunc){return}lodash.prototype[methodName]=function(){var value=this.__wrapped__,args=isTaker?[1]:arguments,isLazy=value instanceof LazyWrapper,iteratee=args[0],useLazy=isLazy||isArray(value);var interceptor=function(value){var result=lodashFunc.apply(lodash,arrayPush([value],args));return isTaker&&chainAll?result[0]:result};if(useLazy&&checkIteratee&&typeof iteratee=="function"&&iteratee.length!=1){isLazy=useLazy=false}var chainAll=this.__chain__,isHybrid=!!this.__actions__.length,isUnwrapped=retUnwrapped&&!chainAll,onlyLazy=isLazy&&!isHybrid;if(!retUnwrapped&&useLazy){value=onlyLazy?value:new LazyWrapper(this);var result=func.apply(value,args);result.__actions__.push({func:thru,args:[interceptor],thisArg:undefined});return new LodashWrapper(result,chainAll)}if(isUnwrapped&&onlyLazy){return func.apply(this,args)}result=this.thru(interceptor);return isUnwrapped?isTaker?result.value()[0]:result.value():result}}));arrayEach(["pop","push","shift","sort","splice","unshift"],(function(methodName){var func=arrayProto[methodName],chainName=/^(?:push|sort|unshift)$/.test(methodName)?"tap":"thru",retUnwrapped=/^(?:pop|shift)$/.test(methodName);lodash.prototype[methodName]=function(){var args=arguments;if(retUnwrapped&&!this.__chain__){var value=this.value();return func.apply(isArray(value)?value:[],args)}return this[chainName]((function(value){return func.apply(isArray(value)?value:[],args)}))}}));baseForOwn(LazyWrapper.prototype,(function(func,methodName){var lodashFunc=lodash[methodName];if(lodashFunc){var key=lodashFunc.name+"",names=realNames[key]||(realNames[key]=[]);names.push({name:methodName,func:lodashFunc})}}));realNames[createHybrid(undefined,WRAP_BIND_KEY_FLAG).name]=[{name:"wrapper",func:undefined}];LazyWrapper.prototype.clone=lazyClone;LazyWrapper.prototype.reverse=lazyReverse;LazyWrapper.prototype.value=lazyValue;lodash.prototype.at=wrapperAt;lodash.prototype.chain=wrapperChain;lodash.prototype.commit=wrapperCommit;lodash.prototype.next=wrapperNext;lodash.prototype.plant=wrapperPlant;lodash.prototype.reverse=wrapperReverse;lodash.prototype.toJSON=lodash.prototype.valueOf=lodash.prototype.value=wrapperValue;lodash.prototype.first=lodash.prototype.head;if(symIterator){lodash.prototype[symIterator]=wrapperToIterator}return lodash};var _=runInContext();if(true){root._=_;!(__WEBPACK_AMD_DEFINE_RESULT__=function(){return _}.call(exports,__webpack_require__,exports,module),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}}).call(this)},(module,__unused_webpack_exports,__webpack_require__)=>{const SentryLib=__webpack_require__(202);const MixpanelLib=__webpack_require__(203);module.exports=__webpack_require__(204)(SentryLib,MixpanelLib)},module=>{(function(f){if(true){module.exports=f()}else{var g}})((function(){var define,module,exports;return function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=undefined;if(!u&&a)return require(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,(function(e){var n=t[o][1][e];return s(n?n:e)}),l,l.exports,e,t,n,r)}return n[o].exports}var i=undefined;for(var o=0;o<r.length;o++)s(r[o]);return s}({1:[function(_dereq_,module,exports){function RavenConfigError(message){this.name="RavenConfigError";this.message=message}RavenConfigError.prototype=new Error;RavenConfigError.prototype.constructor=RavenConfigError;module.exports=RavenConfigError},{}],2:[function(_dereq_,module,exports){var utils=_dereq_(5);var wrapMethod=function(console,level,callback){var originalConsoleLevel=console[level];var originalConsole=console;if(!(level in console)){return}var sentryLevel=level==="warn"?"warning":level;console[level]=function(){var args=[].slice.call(arguments);var msg=utils.safeJoin(args," ");var data={level:sentryLevel,logger:"console",extra:{arguments:args}};if(level==="assert"){if(args[0]===false){msg="Assertion failed: "+(utils.safeJoin(args.slice(1)," ")||"console.assert");data.extra.arguments=args.slice(1);callback&&callback(msg,data)}}else{callback&&callback(msg,data)}if(originalConsoleLevel){Function.prototype.apply.call(originalConsoleLevel,originalConsole,args)}}};module.exports={wrapMethod}},{5:5}],3:[function(_dereq_,module,exports){(function(global){var TraceKit=_dereq_(6);var stringify=_dereq_(7);var md5=_dereq_(8);var RavenConfigError=_dereq_(1);var utils=_dereq_(5);var isErrorEvent=utils.isErrorEvent;var isDOMError=utils.isDOMError;var isDOMException=utils.isDOMException;var isError=utils.isError;var isObject=utils.isObject;var isPlainObject=utils.isPlainObject;var isUndefined=utils.isUndefined;var isFunction=utils.isFunction;var isString=utils.isString;var isArray=utils.isArray;var isEmptyObject=utils.isEmptyObject;var each=utils.each;var objectMerge=utils.objectMerge;var truncate=utils.truncate;var objectFrozen=utils.objectFrozen;var hasKey=utils.hasKey;var joinRegExp=utils.joinRegExp;var urlencode=utils.urlencode;var uuid4=utils.uuid4;var htmlTreeAsString=utils.htmlTreeAsString;var isSameException=utils.isSameException;var isSameStacktrace=utils.isSameStacktrace;var parseUrl=utils.parseUrl;var fill=utils.fill;var supportsFetch=utils.supportsFetch;var supportsReferrerPolicy=utils.supportsReferrerPolicy;var serializeKeysForMessage=utils.serializeKeysForMessage;var serializeException=utils.serializeException;var sanitize=utils.sanitize;var wrapConsoleMethod=_dereq_(2).wrapMethod;var dsnKeys="source protocol user pass host port path".split(" "),dsnPattern=/^(?:(\w+):)?\/\/(?:(\w+)(:\w+)?@)?([\w\.-]+)(?::(\d+))?(\/.*)/;function now(){return+new Date}var _window=typeof window!=="undefined"?window:typeof global!=="undefined"?global:typeof self!=="undefined"?self:{};var _document=_window.document;var _navigator=_window.navigator;function keepOriginalCallback(original,callback){return isFunction(callback)?function(data){return callback(data,original)}:callback}function Raven(){this._hasJSON=!!(typeof JSON==="object"&&JSON.stringify);this._hasDocument=!isUndefined(_document);this._hasNavigator=!isUndefined(_navigator);this._lastCapturedException=null;this._lastData=null;this._lastEventId=null;this._globalServer=null;this._globalKey=null;this._globalProject=null;this._globalContext={};this._globalOptions={release:_window.SENTRY_RELEASE&&_window.SENTRY_RELEASE.id,logger:"javascript",ignoreErrors:[],ignoreUrls:[],whitelistUrls:[],includePaths:[],headers:null,collectWindowErrors:true,captureUnhandledRejections:true,maxMessageLength:0,maxUrlLength:250,stackTraceLimit:50,autoBreadcrumbs:true,instrument:true,sampleRate:1,sanitizeKeys:[]};this._fetchDefaults={method:"POST",referrerPolicy:supportsReferrerPolicy()?"origin":""};this._ignoreOnError=0;this._isRavenInstalled=false;this._originalErrorStackTraceLimit=Error.stackTraceLimit;this._originalConsole=_window.console||{};this._originalConsoleMethods={};this._plugins=[];this._startTime=now();this._wrappedBuiltIns=[];this._breadcrumbs=[];this._lastCapturedEvent=null;this._keypressTimeout;this._location=_window.location;this._lastHref=this._location&&this._location.href;this._resetBackoff();for(var method in this._originalConsole){this._originalConsoleMethods[method]=this._originalConsole[method]}}Raven.prototype={VERSION:"3.27.2",debug:false,TraceKit,config:function(dsn,options){var self=this;if(self._globalServer){this._logDebug("error","Error: Raven has already been configured");return self}if(!dsn)return self;var globalOptions=self._globalOptions;if(options){each(options,(function(key,value){if(key==="tags"||key==="extra"||key==="user"){self._globalContext[key]=value}else{globalOptions[key]=value}}))}self.setDSN(dsn);globalOptions.ignoreErrors.push(/^Script error\.?$/);globalOptions.ignoreErrors.push(/^Javascript error: Script error\.? on line 0$/);globalOptions.ignoreErrors=joinRegExp(globalOptions.ignoreErrors);globalOptions.ignoreUrls=globalOptions.ignoreUrls.length?joinRegExp(globalOptions.ignoreUrls):false;globalOptions.whitelistUrls=globalOptions.whitelistUrls.length?joinRegExp(globalOptions.whitelistUrls):false;globalOptions.includePaths=joinRegExp(globalOptions.includePaths);globalOptions.maxBreadcrumbs=Math.max(0,Math.min(globalOptions.maxBreadcrumbs||100,100));var autoBreadcrumbDefaults={xhr:true,console:true,dom:true,location:true,sentry:true};var autoBreadcrumbs=globalOptions.autoBreadcrumbs;if({}.toString.call(autoBreadcrumbs)==="[object Object]"){autoBreadcrumbs=objectMerge(autoBreadcrumbDefaults,autoBreadcrumbs)}else if(autoBreadcrumbs!==false){autoBreadcrumbs=autoBreadcrumbDefaults}globalOptions.autoBreadcrumbs=autoBreadcrumbs;var instrumentDefaults={tryCatch:true};var instrument=globalOptions.instrument;if({}.toString.call(instrument)==="[object Object]"){instrument=objectMerge(instrumentDefaults,instrument)}else if(instrument!==false){instrument=instrumentDefaults}globalOptions.instrument=instrument;TraceKit.collectWindowErrors=!!globalOptions.collectWindowErrors;return self},install:function(){var self=this;if(self.isSetup()&&!self._isRavenInstalled){TraceKit.report.subscribe((function(){self._handleOnErrorStackInfo.apply(self,arguments)}));if(self._globalOptions.captureUnhandledRejections){self._attachPromiseRejectionHandler()}self._patchFunctionToString();if(self._globalOptions.instrument&&self._globalOptions.instrument.tryCatch){self._instrumentTryCatch()}if(self._globalOptions.autoBreadcrumbs)self._instrumentBreadcrumbs();self._drainPlugins();self._isRavenInstalled=true}Error.stackTraceLimit=self._globalOptions.stackTraceLimit;return this},setDSN:function(dsn){var self=this,uri=self._parseDSN(dsn),lastSlash=uri.path.lastIndexOf("/"),path=uri.path.substr(1,lastSlash);self._dsn=dsn;self._globalKey=uri.user;self._globalSecret=uri.pass&&uri.pass.substr(1);self._globalProject=uri.path.substr(lastSlash+1);self._globalServer=self._getGlobalServer(uri);self._globalEndpoint=self._globalServer+"/"+path+"api/"+self._globalProject+"/store/";this._resetBackoff()},context:function(options,func,args){if(isFunction(options)){args=func||[];func=options;options={}}return this.wrap(options,func).apply(this,args)},wrap:function(options,func,_before){var self=this;if(isUndefined(func)&&!isFunction(options)){return options}if(isFunction(options)){func=options;options=undefined}if(!isFunction(func)){return func}try{if(func.__raven__){return func}if(func.__raven_wrapper__){return func.__raven_wrapper__}}catch(e){return func}function wrapped(){var args=[],i=arguments.length,deep=!options||options&&options.deep!==false;if(_before&&isFunction(_before)){_before.apply(this,arguments)}while(i--)args[i]=deep?self.wrap(options,arguments[i]):arguments[i];try{return func.apply(this,args)}catch(e){self._ignoreNextOnError();self.captureException(e,options);throw e}}for(var property in func){if(hasKey(func,property)){wrapped[property]=func[property]}}wrapped.prototype=func.prototype;func.__raven_wrapper__=wrapped;wrapped.__raven__=true;wrapped.__orig__=func;return wrapped},uninstall:function(){TraceKit.report.uninstall();this._detachPromiseRejectionHandler();this._unpatchFunctionToString();this._restoreBuiltIns();this._restoreConsole();Error.stackTraceLimit=this._originalErrorStackTraceLimit;this._isRavenInstalled=false;return this},_promiseRejectionHandler:function(event){this._logDebug("debug","Raven caught unhandled promise rejection:",event);this.captureException(event.reason,{mechanism:{type:"onunhandledrejection",handled:false}})},_attachPromiseRejectionHandler:function(){this._promiseRejectionHandler=this._promiseRejectionHandler.bind(this);_window.addEventListener&&_window.addEventListener("unhandledrejection",this._promiseRejectionHandler);return this},_detachPromiseRejectionHandler:function(){_window.removeEventListener&&_window.removeEventListener("unhandledrejection",this._promiseRejectionHandler);return this},captureException:function(ex,options){options=objectMerge({trimHeadFrames:0},options?options:{});if(isErrorEvent(ex)&&ex.error){ex=ex.error}else if(isDOMError(ex)||isDOMException(ex)){var name=ex.name||(isDOMError(ex)?"DOMError":"DOMException");var message=ex.message?name+": "+ex.message:name;return this.captureMessage(message,objectMerge(options,{stacktrace:true,trimHeadFrames:options.trimHeadFrames+1}))}else if(isError(ex)){ex=ex}else if(isPlainObject(ex)){options=this._getCaptureExceptionOptionsFromPlainObject(options,ex);ex=new Error(options.message)}else{return this.captureMessage(ex,objectMerge(options,{stacktrace:true,trimHeadFrames:options.trimHeadFrames+1}))}this._lastCapturedException=ex;try{var stack=TraceKit.computeStackTrace(ex);this._handleStackInfo(stack,options)}catch(ex1){if(ex!==ex1){throw ex1}}return this},_getCaptureExceptionOptionsFromPlainObject:function(currentOptions,ex){var exKeys=Object.keys(ex).sort();var options=objectMerge(currentOptions,{message:"Non-Error exception captured with keys: "+serializeKeysForMessage(exKeys),fingerprint:[md5(exKeys)],extra:currentOptions.extra||{}});options.extra.__serialized__=serializeException(ex);return options},captureMessage:function(msg,options){if(!!this._globalOptions.ignoreErrors.test&&this._globalOptions.ignoreErrors.test(msg)){return}options=options||{};msg=msg+"";var data=objectMerge({message:msg},options);var ex;try{throw new Error(msg)}catch(ex1){ex=ex1}ex.name=null;var stack=TraceKit.computeStackTrace(ex);var initialCall=isArray(stack.stack)&&stack.stack[1];if(initialCall&&initialCall.func==="Raven.captureException"){initialCall=stack.stack[2]}var fileurl=initialCall&&initialCall.url||"";if(!!this._globalOptions.ignoreUrls.test&&this._globalOptions.ignoreUrls.test(fileurl)){return}if(!!this._globalOptions.whitelistUrls.test&&!this._globalOptions.whitelistUrls.test(fileurl)){return}if(this._globalOptions.stacktrace||options.stacktrace||data.message===""){data.fingerprint=data.fingerprint==null?msg:data.fingerprint;options=objectMerge({trimHeadFrames:0},options);options.trimHeadFrames+=1;var frames=this._prepareFrames(stack,options);data.stacktrace={frames:frames.reverse()}}if(data.fingerprint){data.fingerprint=isArray(data.fingerprint)?data.fingerprint:[data.fingerprint]}this._send(data);return this},captureBreadcrumb:function(obj){var crumb=objectMerge({timestamp:now()/1e3},obj);if(isFunction(this._globalOptions.breadcrumbCallback)){var result=this._globalOptions.breadcrumbCallback(crumb);if(isObject(result)&&!isEmptyObject(result)){crumb=result}else if(result===false){return this}}this._breadcrumbs.push(crumb);if(this._breadcrumbs.length>this._globalOptions.maxBreadcrumbs){this._breadcrumbs.shift()}return this},addPlugin:function(plugin){var pluginArgs=[].slice.call(arguments,1);this._plugins.push([plugin,pluginArgs]);if(this._isRavenInstalled){this._drainPlugins()}return this},setUserContext:function(user){this._globalContext.user=user;return this},setExtraContext:function(extra){this._mergeContext("extra",extra);return this},setTagsContext:function(tags){this._mergeContext("tags",tags);return this},clearContext:function(){this._globalContext={};return this},getContext:function(){return JSON.parse(stringify(this._globalContext))},setEnvironment:function(environment){this._globalOptions.environment=environment;return this},setRelease:function(release){this._globalOptions.release=release;return this},setDataCallback:function(callback){var original=this._globalOptions.dataCallback;this._globalOptions.dataCallback=keepOriginalCallback(original,callback);return this},setBreadcrumbCallback:function(callback){var original=this._globalOptions.breadcrumbCallback;this._globalOptions.breadcrumbCallback=keepOriginalCallback(original,callback);return this},setShouldSendCallback:function(callback){var original=this._globalOptions.shouldSendCallback;this._globalOptions.shouldSendCallback=keepOriginalCallback(original,callback);return this},setTransport:function(transport){this._globalOptions.transport=transport;return this},lastException:function(){return this._lastCapturedException},lastEventId:function(){return this._lastEventId},isSetup:function(){if(!this._hasJSON)return false;if(!this._globalServer){if(!this.ravenNotConfiguredError){this.ravenNotConfiguredError=true;this._logDebug("error","Error: Raven has not been configured.")}return false}return true},afterLoad:function(){var RavenConfig=_window.RavenConfig;if(RavenConfig){this.config(RavenConfig.dsn,RavenConfig.config).install()}},showReportDialog:function(options){if(!_document)return;options=objectMerge({eventId:this.lastEventId(),dsn:this._dsn,user:this._globalContext.user||{}},options);if(!options.eventId){throw new RavenConfigError("Missing eventId")}if(!options.dsn){throw new RavenConfigError("Missing DSN")}var encode=encodeURIComponent;var encodedOptions=[];for(var key in options){if(key==="user"){var user=options.user;if(user.name)encodedOptions.push("name="+encode(user.name));if(user.email)encodedOptions.push("email="+encode(user.email))}else{encodedOptions.push(encode(key)+"="+encode(options[key]))}}var globalServer=this._getGlobalServer(this._parseDSN(options.dsn));var script=_document.createElement("script");script.async=true;script.src=globalServer+"/api/embed/error-page/?"+encodedOptions.join("&");(_document.head||_document.body).appendChild(script)},_ignoreNextOnError:function(){var self=this;this._ignoreOnError+=1;setTimeout((function(){self._ignoreOnError-=1}))},_triggerEvent:function(eventType,options){var evt,key;if(!this._hasDocument)return;options=options||{};eventType="raven"+eventType.substr(0,1).toUpperCase()+eventType.substr(1);if(_document.createEvent){evt=_document.createEvent("HTMLEvents");evt.initEvent(eventType,true,true)}else{evt=_document.createEventObject();evt.eventType=eventType}for(key in options)if(hasKey(options,key)){evt[key]=options[key]}if(_document.createEvent){_document.dispatchEvent(evt)}else{try{_document.fireEvent("on"+evt.eventType.toLowerCase(),evt)}catch(e){}}},_breadcrumbEventHandler:function(evtName){var self=this;return function(evt){self._keypressTimeout=null;if(self._lastCapturedEvent===evt)return;self._lastCapturedEvent=evt;var target;try{target=htmlTreeAsString(evt.target)}catch(e){target="<unknown>"}self.captureBreadcrumb({category:"ui."+evtName,message:target})}},_keypressEventHandler:function(){var self=this,debounceDuration=1e3;return function(evt){var target;try{target=evt.target}catch(e){return}var tagName=target&&target.tagName;if(!tagName||tagName!=="INPUT"&&tagName!=="TEXTAREA"&&!target.isContentEditable)return;var timeout=self._keypressTimeout;if(!timeout){self._breadcrumbEventHandler("input")(evt)}clearTimeout(timeout);self._keypressTimeout=setTimeout((function(){self._keypressTimeout=null}),debounceDuration)}},_captureUrlChange:function(from,to){var parsedLoc=parseUrl(this._location.href);var parsedTo=parseUrl(to);var parsedFrom=parseUrl(from);this._lastHref=to;if(parsedLoc.protocol===parsedTo.protocol&&parsedLoc.host===parsedTo.host)to=parsedTo.relative;if(parsedLoc.protocol===parsedFrom.protocol&&parsedLoc.host===parsedFrom.host)from=parsedFrom.relative;this.captureBreadcrumb({category:"navigation",data:{to,from}})},_patchFunctionToString:function(){var self=this;self._originalFunctionToString=Function.prototype.toString;Function.prototype.toString=function(){if(typeof this==="function"&&this.__raven__){return self._originalFunctionToString.apply(this.__orig__,arguments)}return self._originalFunctionToString.apply(this,arguments)}},_unpatchFunctionToString:function(){if(this._originalFunctionToString){Function.prototype.toString=this._originalFunctionToString}},_instrumentTryCatch:function(){var self=this;var wrappedBuiltIns=self._wrappedBuiltIns;function wrapTimeFn(orig){return function(fn,t){var args=new Array(arguments.length);for(var i=0;i<args.length;++i){args[i]=arguments[i]}var originalCallback=args[0];if(isFunction(originalCallback)){args[0]=self.wrap({mechanism:{type:"instrument",data:{function:orig.name||"<anonymous>"}}},originalCallback)}if(orig.apply){return orig.apply(this,args)}else{return orig(args[0],args[1])}}}var autoBreadcrumbs=this._globalOptions.autoBreadcrumbs;function wrapEventTarget(global){var proto=_window[global]&&_window[global].prototype;if(proto&&proto.hasOwnProperty&&proto.hasOwnProperty("addEventListener")){fill(proto,"addEventListener",(function(orig){return function(evtName,fn,capture,secure){try{if(fn&&fn.handleEvent){fn.handleEvent=self.wrap({mechanism:{type:"instrument",data:{target:global,function:"handleEvent",handler:fn&&fn.name||"<anonymous>"}}},fn.handleEvent)}}catch(err){}var before,clickHandler,keypressHandler;if(autoBreadcrumbs&&autoBreadcrumbs.dom&&(global==="EventTarget"||global==="Node")){clickHandler=self._breadcrumbEventHandler("click");keypressHandler=self._keypressEventHandler();before=function(evt){if(!evt)return;var eventType;try{eventType=evt.type}catch(e){return}if(eventType==="click")return clickHandler(evt);else if(eventType==="keypress")return keypressHandler(evt)}}return orig.call(this,evtName,self.wrap({mechanism:{type:"instrument",data:{target:global,function:"addEventListener",handler:fn&&fn.name||"<anonymous>"}}},fn,before),capture,secure)}}),wrappedBuiltIns);fill(proto,"removeEventListener",(function(orig){return function(evt,fn,capture,secure){try{fn=fn&&(fn.__raven_wrapper__?fn.__raven_wrapper__:fn)}catch(e){}return orig.call(this,evt,fn,capture,secure)}}),wrappedBuiltIns)}}fill(_window,"setTimeout",wrapTimeFn,wrappedBuiltIns);fill(_window,"setInterval",wrapTimeFn,wrappedBuiltIns);if(_window.requestAnimationFrame){fill(_window,"requestAnimationFrame",(function(orig){return function(cb){return orig(self.wrap({mechanism:{type:"instrument",data:{function:"requestAnimationFrame",handler:orig&&orig.name||"<anonymous>"}}},cb))}}),wrappedBuiltIns)}var eventTargets=["EventTarget","Window","Node","ApplicationCache","AudioTrackList","ChannelMergerNode","CryptoOperation","EventSource","FileReader","HTMLUnknownElement","IDBDatabase","IDBRequest","IDBTransaction","KeyOperation","MediaController","MessagePort","ModalWindow","Notification","SVGElementInstance","Screen","TextTrack","TextTrackCue","TextTrackList","WebSocket","WebSocketWorker","Worker","XMLHttpRequest","XMLHttpRequestEventTarget","XMLHttpRequestUpload"];for(var i=0;i<eventTargets.length;i++){wrapEventTarget(eventTargets[i])}},_instrumentBreadcrumbs:function(){var self=this;var autoBreadcrumbs=this._globalOptions.autoBreadcrumbs;var wrappedBuiltIns=self._wrappedBuiltIns;function wrapProp(prop,xhr){if(prop in xhr&&isFunction(xhr[prop])){fill(xhr,prop,(function(orig){return self.wrap({mechanism:{type:"instrument",data:{function:prop,handler:orig&&orig.name||"<anonymous>"}}},orig)}))}}if(autoBreadcrumbs.xhr&&"XMLHttpRequest"in _window){var xhrproto=_window.XMLHttpRequest&&_window.XMLHttpRequest.prototype;fill(xhrproto,"open",(function(origOpen){return function(method,url){if(isString(url)&&url.indexOf(self._globalKey)===-1){this.__raven_xhr={method,url,status_code:null}}return origOpen.apply(this,arguments)}}),wrappedBuiltIns);fill(xhrproto,"send",(function(origSend){return function(){var xhr=this;function onreadystatechangeHandler(){if(xhr.__raven_xhr&&xhr.readyState===4){try{xhr.__raven_xhr.status_code=xhr.status}catch(e){}self.captureBreadcrumb({type:"http",category:"xhr",data:xhr.__raven_xhr})}}var props=["onload","onerror","onprogress"];for(var j=0;j<props.length;j++){wrapProp(props[j],xhr)}if("onreadystatechange"in xhr&&isFunction(xhr.onreadystatechange)){fill(xhr,"onreadystatechange",(function(orig){return self.wrap({mechanism:{type:"instrument",data:{function:"onreadystatechange",handler:orig&&orig.name||"<anonymous>"}}},orig,onreadystatechangeHandler)}))}else{xhr.onreadystatechange=onreadystatechangeHandler}return origSend.apply(this,arguments)}}),wrappedBuiltIns)}if(autoBreadcrumbs.xhr&&supportsFetch()){fill(_window,"fetch",(function(origFetch){return function(){var args=new Array(arguments.length);for(var i=0;i<args.length;++i){args[i]=arguments[i]}var fetchInput=args[0];var method="GET";var url;if(typeof fetchInput==="string"){url=fetchInput}else if("Request"in _window&&fetchInput instanceof _window.Request){url=fetchInput.url;if(fetchInput.method){method=fetchInput.method}}else{url=""+fetchInput}if(url.indexOf(self._globalKey)!==-1){return origFetch.apply(this,args)}if(args[1]&&args[1].method){method=args[1].method}var fetchData={method,url,status_code:null};return origFetch.apply(this,args).then((function(response){fetchData.status_code=response.status;self.captureBreadcrumb({type:"http",category:"fetch",data:fetchData});return response}))["catch"]((function(err){self.captureBreadcrumb({type:"http",category:"fetch",data:fetchData,level:"error"});throw err}))}}),wrappedBuiltIns)}if(autoBreadcrumbs.dom&&this._hasDocument){if(_document.addEventListener){_document.addEventListener("click",self._breadcrumbEventHandler("click"),false);_document.addEventListener("keypress",self._keypressEventHandler(),false)}else if(_document.attachEvent){_document.attachEvent("onclick",self._breadcrumbEventHandler("click"));_document.attachEvent("onkeypress",self._keypressEventHandler())}}var chrome=_window.chrome;var isChromePackagedApp=chrome&&chrome.app&&chrome.app.runtime;var hasPushAndReplaceState=!isChromePackagedApp&&_window.history&&_window.history.pushState&&_window.history.replaceState;if(autoBreadcrumbs.location&&hasPushAndReplaceState){var oldOnPopState=_window.onpopstate;_window.onpopstate=function(){var currentHref=self._location.href;self._captureUrlChange(self._lastHref,currentHref);if(oldOnPopState){return oldOnPopState.apply(this,arguments)}};var historyReplacementFunction=function(origHistFunction){return function(){var url=arguments.length>2?arguments[2]:undefined;if(url){self._captureUrlChange(self._lastHref,url+"")}return origHistFunction.apply(this,arguments)}};fill(_window.history,"pushState",historyReplacementFunction,wrappedBuiltIns);fill(_window.history,"replaceState",historyReplacementFunction,wrappedBuiltIns)}if(autoBreadcrumbs.console&&"console"in _window&&console.log){var consoleMethodCallback=function(msg,data){self.captureBreadcrumb({message:msg,level:data.level,category:"console"})};each(["debug","info","warn","error","log"],(function(_,level){wrapConsoleMethod(console,level,consoleMethodCallback)}))}},_restoreBuiltIns:function(){var builtin;while(this._wrappedBuiltIns.length){builtin=this._wrappedBuiltIns.shift();var obj=builtin[0],name=builtin[1],orig=builtin[2];obj[name]=orig}},_restoreConsole:function(){for(var method in this._originalConsoleMethods){this._originalConsole[method]=this._originalConsoleMethods[method]}},_drainPlugins:function(){var self=this;each(this._plugins,(function(_,plugin){var installer=plugin[0];var args=plugin[1];installer.apply(self,[self].concat(args))}))},_parseDSN:function(str){var m=dsnPattern.exec(str),dsn={},i=7;try{while(i--)dsn[dsnKeys[i]]=m[i]||""}catch(e){throw new RavenConfigError("Invalid DSN: "+str)}if(dsn.pass&&!this._globalOptions.allowSecretKey){throw new RavenConfigError("Do not specify your secret key in the DSN. See: http://bit.ly/raven-secret-key")}return dsn},_getGlobalServer:function(uri){var globalServer="//"+uri.host+(uri.port?":"+uri.port:"");if(uri.protocol){globalServer=uri.protocol+":"+globalServer}return globalServer},_handleOnErrorStackInfo:function(stackInfo,options){options=options||{};options.mechanism=options.mechanism||{type:"onerror",handled:false};if(!this._ignoreOnError){this._handleStackInfo(stackInfo,options)}},_handleStackInfo:function(stackInfo,options){var frames=this._prepareFrames(stackInfo,options);this._triggerEvent("handle",{stackInfo,options});this._processException(stackInfo.name,stackInfo.message,stackInfo.url,stackInfo.lineno,frames,options)},_prepareFrames:function(stackInfo,options){var self=this;var frames=[];if(stackInfo.stack&&stackInfo.stack.length){each(stackInfo.stack,(function(i,stack){var frame=self._normalizeFrame(stack,stackInfo.url);if(frame){frames.push(frame)}}));if(options&&options.trimHeadFrames){for(var j=0;j<options.trimHeadFrames&&j<frames.length;j++){frames[j].in_app=false}}}frames=frames.slice(0,this._globalOptions.stackTraceLimit);return frames},_normalizeFrame:function(frame,stackInfoUrl){var normalized={filename:frame.url,lineno:frame.line,colno:frame.column,function:frame.func||"?"};if(!frame.url){normalized.filename=stackInfoUrl}normalized.in_app=!(!!this._globalOptions.includePaths.test&&!this._globalOptions.includePaths.test(normalized.filename)||/(Raven|TraceKit)\./.test(normalized["function"])||/raven\.(min\.)?js$/.test(normalized.filename));return normalized},_processException:function(type,message,fileurl,lineno,frames,options){var prefixedMessage=(type?type+": ":"")+(message||"");if(!!this._globalOptions.ignoreErrors.test&&(this._globalOptions.ignoreErrors.test(message)||this._globalOptions.ignoreErrors.test(prefixedMessage))){return}var stacktrace;if(frames&&frames.length){fileurl=frames[0].filename||fileurl;frames.reverse();stacktrace={frames}}else if(fileurl){stacktrace={frames:[{filename:fileurl,lineno,in_app:true}]}}if(!!this._globalOptions.ignoreUrls.test&&this._globalOptions.ignoreUrls.test(fileurl)){return}if(!!this._globalOptions.whitelistUrls.test&&!this._globalOptions.whitelistUrls.test(fileurl)){return}var data=objectMerge({exception:{values:[{type,value:message,stacktrace}]},transaction:fileurl},options);var ex=data.exception.values[0];if(ex.type==null&&ex.value===""){ex.value="Unrecoverable error caught"}if(!data.exception.mechanism&&data.mechanism){data.exception.mechanism=data.mechanism;delete data.mechanism}data.exception.mechanism=objectMerge({type:"generic",handled:true},data.exception.mechanism||{});this._send(data)},_trimPacket:function(data){var max=this._globalOptions.maxMessageLength;if(data.message){data.message=truncate(data.message,max)}if(data.exception){var exception=data.exception.values[0];exception.value=truncate(exception.value,max)}var request=data.request;if(request){if(request.url){request.url=truncate(request.url,this._globalOptions.maxUrlLength)}if(request.Referer){request.Referer=truncate(request.Referer,this._globalOptions.maxUrlLength)}}if(data.breadcrumbs&&data.breadcrumbs.values)this._trimBreadcrumbs(data.breadcrumbs);return data},_trimBreadcrumbs:function(breadcrumbs){var urlProps=["to","from","url"],urlProp,crumb,data;for(var i=0;i<breadcrumbs.values.length;++i){crumb=breadcrumbs.values[i];if(!crumb.hasOwnProperty("data")||!isObject(crumb.data)||objectFrozen(crumb.data))continue;data=objectMerge({},crumb.data);for(var j=0;j<urlProps.length;++j){urlProp=urlProps[j];if(data.hasOwnProperty(urlProp)&&data[urlProp]){data[urlProp]=truncate(data[urlProp],this._globalOptions.maxUrlLength)}}breadcrumbs.values[i].data=data}},_getHttpData:function(){if(!this._hasNavigator&&!this._hasDocument)return;var httpData={};if(this._hasNavigator&&_navigator.userAgent){httpData.headers={"User-Agent":_navigator.userAgent}}if(_window.location&&_window.location.href){httpData.url=_window.location.href}if(this._hasDocument&&_document.referrer){if(!httpData.headers)httpData.headers={};httpData.headers.Referer=_document.referrer}return httpData},_resetBackoff:function(){this._backoffDuration=0;this._backoffStart=null},_shouldBackoff:function(){return this._backoffDuration&&now()-this._backoffStart<this._backoffDuration},_isRepeatData:function(current){var last=this._lastData;if(!last||current.message!==last.message||current.transaction!==last.transaction)return false;if(current.stacktrace||last.stacktrace){return isSameStacktrace(current.stacktrace,last.stacktrace)}else if(current.exception||last.exception){return isSameException(current.exception,last.exception)}else if(current.fingerprint||last.fingerprint){return Boolean(current.fingerprint&&last.fingerprint)&&JSON.stringify(current.fingerprint)===JSON.stringify(last.fingerprint)}return true},_setBackoffState:function(request){if(this._shouldBackoff()){return}var status=request.status;if(!(status===400||status===401||status===429))return;var retry;try{if(supportsFetch()){retry=request.headers.get("Retry-After")}else{retry=request.getResponseHeader("Retry-After")}retry=parseInt(retry,10)*1e3}catch(e){}this._backoffDuration=retry?retry:this._backoffDuration*2||1e3;this._backoffStart=now()},_send:function(data){var globalOptions=this._globalOptions;var baseData={project:this._globalProject,logger:globalOptions.logger,platform:"javascript"},httpData=this._getHttpData();if(httpData){baseData.request=httpData}if(data.trimHeadFrames)delete data.trimHeadFrames;data=objectMerge(baseData,data);data.tags=objectMerge(objectMerge({},this._globalContext.tags),data.tags);data.extra=objectMerge(objectMerge({},this._globalContext.extra),data.extra);data.extra["session:duration"]=now()-this._startTime;if(this._breadcrumbs&&this._breadcrumbs.length>0){data.breadcrumbs={values:[].slice.call(this._breadcrumbs,0)}}if(this._globalContext.user){data.user=this._globalContext.user}if(globalOptions.environment)data.environment=globalOptions.environment;if(globalOptions.release)data.release=globalOptions.release;if(globalOptions.serverName)data.server_name=globalOptions.serverName;data=this._sanitizeData(data);Object.keys(data).forEach((function(key){if(data[key]==null||data[key]===""||isEmptyObject(data[key])){delete data[key]}}));if(isFunction(globalOptions.dataCallback)){data=globalOptions.dataCallback(data)||data}if(!data||isEmptyObject(data)){return}if(isFunction(globalOptions.shouldSendCallback)&&!globalOptions.shouldSendCallback(data)){return}if(this._shouldBackoff()){this._logDebug("warn","Raven dropped error due to backoff: ",data);return}if(typeof globalOptions.sampleRate==="number"){if(Math.random()<globalOptions.sampleRate){this._sendProcessedPayload(data)}}else{this._sendProcessedPayload(data)}},_sanitizeData:function(data){return sanitize(data,this._globalOptions.sanitizeKeys)},_getUuid:function(){return uuid4()},_sendProcessedPayload:function(data,callback){var self=this;var globalOptions=this._globalOptions;if(!this.isSetup())return;data=this._trimPacket(data);if(!this._globalOptions.allowDuplicates&&this._isRepeatData(data)){this._logDebug("warn","Raven dropped repeat event: ",data);return}this._lastEventId=data.event_id||(data.event_id=this._getUuid());this._lastData=data;this._logDebug("debug","Raven about to send:",data);var auth={sentry_version:"7",sentry_client:"raven-js/"+this.VERSION,sentry_key:this._globalKey};if(this._globalSecret){auth.sentry_secret=this._globalSecret}var exception=data.exception&&data.exception.values[0];if(this._globalOptions.autoBreadcrumbs&&this._globalOptions.autoBreadcrumbs.sentry){this.captureBreadcrumb({category:"sentry",message:exception?(exception.type?exception.type+": ":"")+exception.value:data.message,event_id:data.event_id,level:data.level||"error"})}var url=this._globalEndpoint;(globalOptions.transport||this._makeRequest).call(this,{url,auth,data,options:globalOptions,onSuccess:function success(){self._resetBackoff();self._triggerEvent("success",{data,src:url});callback&&callback()},onError:function failure(error){self._logDebug("error","Raven transport failed to send: ",error);if(error.request){self._setBackoffState(error.request)}self._triggerEvent("failure",{data,src:url});error=error||new Error("Raven send failed (no additional details provided)");callback&&callback(error)}})},_makeRequest:function(opts){var url=opts.url+"?"+urlencode(opts.auth);var evaluatedHeaders=null;var evaluatedFetchParameters={};if(opts.options.headers){evaluatedHeaders=this._evaluateHash(opts.options.headers)}if(opts.options.fetchParameters){evaluatedFetchParameters=this._evaluateHash(opts.options.fetchParameters)}if(supportsFetch()){evaluatedFetchParameters.body=stringify(opts.data);var defaultFetchOptions=objectMerge({},this._fetchDefaults);var fetchOptions=objectMerge(defaultFetchOptions,evaluatedFetchParameters);if(evaluatedHeaders){fetchOptions.headers=evaluatedHeaders}return _window.fetch(url,fetchOptions).then((function(response){if(response.ok){opts.onSuccess&&opts.onSuccess()}else{var error=new Error("Sentry error code: "+response.status);error.request=response;opts.onError&&opts.onError(error)}}))["catch"]((function(){opts.onError&&opts.onError(new Error("Sentry error code: network unavailable"))}))}var request=_window.XMLHttpRequest&&new _window.XMLHttpRequest;if(!request)return;var hasCORS="withCredentials"in request||typeof XDomainRequest!=="undefined";if(!hasCORS)return;if("withCredentials"in request){request.onreadystatechange=function(){if(request.readyState!==4){return}else if(request.status===200){opts.onSuccess&&opts.onSuccess()}else if(opts.onError){var err=new Error("Sentry error code: "+request.status);err.request=request;opts.onError(err)}}}else{request=new XDomainRequest;url=url.replace(/^https?:/,"");if(opts.onSuccess){request.onload=opts.onSuccess}if(opts.onError){request.onerror=function(){var err=new Error("Sentry error code: XDomainRequest");err.request=request;opts.onError(err)}}}request.open("POST",url);if(evaluatedHeaders){each(evaluatedHeaders,(function(key,value){request.setRequestHeader(key,value)}))}request.send(stringify(opts.data))},_evaluateHash:function(hash){var evaluated={};for(var key in hash){if(hash.hasOwnProperty(key)){var value=hash[key];evaluated[key]=typeof value==="function"?value():value}}return evaluated},_logDebug:function(level){if(this._originalConsoleMethods[level]&&(this.debug||this._globalOptions.debug)){Function.prototype.apply.call(this._originalConsoleMethods[level],this._originalConsole,[].slice.call(arguments,1))}},_mergeContext:function(key,context){if(isUndefined(context)){delete this._globalContext[key]}else{this._globalContext[key]=objectMerge(this._globalContext[key]||{},context)}}};Raven.prototype.setUser=Raven.prototype.setUserContext;Raven.prototype.setReleaseContext=Raven.prototype.setRelease;module.exports=Raven}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{1:1,2:2,5:5,6:6,7:7,8:8}],4:[function(_dereq_,module,exports){(function(global){var RavenConstructor=_dereq_(3);var _window=typeof window!=="undefined"?window:typeof global!=="undefined"?global:typeof self!=="undefined"?self:{};var _Raven=_window.Raven;var Raven=new RavenConstructor;Raven.noConflict=function(){_window.Raven=_Raven;return Raven};Raven.afterLoad();module.exports=Raven;module.exports.Client=RavenConstructor}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{3:3}],5:[function(_dereq_,module,exports){(function(global){var stringify=_dereq_(7);var _window=typeof window!=="undefined"?window:typeof global!=="undefined"?global:typeof self!=="undefined"?self:{};function isObject(what){return typeof what==="object"&&what!==null}function isError(value){switch(Object.prototype.toString.call(value)){case"[object Error]":return true;case"[object Exception]":return true;case"[object DOMException]":return true;default:return value instanceof Error}}function isErrorEvent(value){return Object.prototype.toString.call(value)==="[object ErrorEvent]"}function isDOMError(value){return Object.prototype.toString.call(value)==="[object DOMError]"}function isDOMException(value){return Object.prototype.toString.call(value)==="[object DOMException]"}function isUndefined(what){return what===void 0}function isFunction(what){return typeof what==="function"}function isPlainObject(what){return Object.prototype.toString.call(what)==="[object Object]"}function isString(what){return Object.prototype.toString.call(what)==="[object String]"}function isArray(what){return Object.prototype.toString.call(what)==="[object Array]"}function isEmptyObject(what){if(!isPlainObject(what))return false;for(var _ in what){if(what.hasOwnProperty(_)){return false}}return true}function supportsErrorEvent(){try{new ErrorEvent("");return true}catch(e){return false}}function supportsDOMError(){try{new DOMError("");return true}catch(e){return false}}function supportsDOMException(){try{new DOMException("");return true}catch(e){return false}}function supportsFetch(){if(!("fetch"in _window))return false;try{new Headers;new Request("");new Response;return true}catch(e){return false}}function supportsReferrerPolicy(){if(!supportsFetch())return false;try{new Request("pickleRick",{referrerPolicy:"origin"});return true}catch(e){return false}}function supportsPromiseRejectionEvent(){return typeof PromiseRejectionEvent==="function"}function wrappedCallback(callback){function dataCallback(data,original){var normalizedData=callback(data)||data;if(original){return original(normalizedData)||normalizedData}return normalizedData}return dataCallback}function each(obj,callback){var i,j;if(isUndefined(obj.length)){for(i in obj){if(hasKey(obj,i)){callback.call(null,i,obj[i])}}}else{j=obj.length;if(j){for(i=0;i<j;i++){callback.call(null,i,obj[i])}}}}function objectMerge(obj1,obj2){if(!obj2){return obj1}each(obj2,(function(key,value){obj1[key]=value}));return obj1}function objectFrozen(obj){if(!Object.isFrozen){return false}return Object.isFrozen(obj)}function truncate(str,max){if(typeof max!=="number"){throw new Error("2nd argument to `truncate` function should be a number")}if(typeof str!=="string"||max===0){return str}return str.length<=max?str:str.substr(0,max)+"…"}function hasKey(object,key){return Object.prototype.hasOwnProperty.call(object,key)}function joinRegExp(patterns){var sources=[],i=0,len=patterns.length,pattern;for(;i<len;i++){pattern=patterns[i];if(isString(pattern)){sources.push(pattern.replace(/([.*+?^=!:${}()|\[\]\/\\])/g,"\\$1"))}else if(pattern&&pattern.source){sources.push(pattern.source)}}return new RegExp(sources.join("|"),"i")}function urlencode(o){var pairs=[];each(o,(function(key,value){pairs.push(encodeURIComponent(key)+"="+encodeURIComponent(value))}));return pairs.join("&")}function parseUrl(url){if(typeof url!=="string")return{};var match=url.match(/^(([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?$/);var query=match[6]||"";var fragment=match[8]||"";return{protocol:match[2],host:match[4],path:match[5],relative:match[5]+query+fragment}}function uuid4(){var crypto=_window.crypto||_window.msCrypto;if(!isUndefined(crypto)&&crypto.getRandomValues){var arr=new Uint16Array(8);crypto.getRandomValues(arr);arr[3]=arr[3]&4095|16384;arr[4]=arr[4]&16383|32768;var pad=function(num){var v=num.toString(16);while(v.length<4){v="0"+v}return v};return pad(arr[0])+pad(arr[1])+pad(arr[2])+pad(arr[3])+pad(arr[4])+pad(arr[5])+pad(arr[6])+pad(arr[7])}else{return"xxxxxxxxxxxx4xxxyxxxxxxxxxxxxxxx".replace(/[xy]/g,(function(c){var r=Math.random()*16|0,v=c==="x"?r:r&3|8;return v.toString(16)}))}}function htmlTreeAsString(elem){var MAX_TRAVERSE_HEIGHT=5,MAX_OUTPUT_LEN=80,out=[],height=0,len=0,separator=" > ",sepLength=separator.length,nextStr;while(elem&&height++<MAX_TRAVERSE_HEIGHT){nextStr=htmlElementAsString(elem);if(nextStr==="html"||height>1&&len+out.length*sepLength+nextStr.length>=MAX_OUTPUT_LEN){break}out.push(nextStr);len+=nextStr.length;elem=elem.parentNode}return out.reverse().join(separator)}function htmlElementAsString(elem){var out=[],className,classes,key,attr,i;if(!elem||!elem.tagName){return""}out.push(elem.tagName.toLowerCase());if(elem.id){out.push("#"+elem.id)}className=elem.className;if(className&&isString(className)){classes=className.split(/\s+/);for(i=0;i<classes.length;i++){out.push("."+classes[i])}}var attrWhitelist=["type","name","title","alt"];for(i=0;i<attrWhitelist.length;i++){key=attrWhitelist[i];attr=elem.getAttribute(key);if(attr){out.push("["+key+'="'+attr+'"]')}}return out.join("")}function isOnlyOneTruthy(a,b){return!!(!!a^!!b)}function isBothUndefined(a,b){return isUndefined(a)&&isUndefined(b)}function isSameException(ex1,ex2){if(isOnlyOneTruthy(ex1,ex2))return false;ex1=ex1.values[0];ex2=ex2.values[0];if(ex1.type!==ex2.type||ex1.value!==ex2.value)return false;if(isBothUndefined(ex1.stacktrace,ex2.stacktrace))return false;return isSameStacktrace(ex1.stacktrace,ex2.stacktrace)}function isSameStacktrace(stack1,stack2){if(isOnlyOneTruthy(stack1,stack2))return false;var frames1=stack1.frames;var frames2=stack2.frames;if(frames1===undefined||frames2===undefined)return false;if(frames1.length!==frames2.length)return false;var a,b;for(var i=0;i<frames1.length;i++){a=frames1[i];b=frames2[i];if(a.filename!==b.filename||a.lineno!==b.lineno||a.colno!==b.colno||a["function"]!==b["function"])return false}return true}function fill(obj,name,replacement,track){if(obj==null)return;var orig=obj[name];obj[name]=replacement(orig);obj[name].__raven__=true;obj[name].__orig__=orig;if(track){track.push([obj,name,orig])}}function safeJoin(input,delimiter){if(!isArray(input))return"";var output=[];for(var i=0;i<input.length;i++){try{output.push(String(input[i]))}catch(e){output.push("[value cannot be serialized]")}}return output.join(delimiter)}var MAX_SERIALIZE_EXCEPTION_DEPTH=3;var MAX_SERIALIZE_EXCEPTION_SIZE=50*1024;var MAX_SERIALIZE_KEYS_LENGTH=40;function utf8Length(value){return~-encodeURI(value).split(/%..|./).length}function jsonSize(value){return utf8Length(JSON.stringify(value))}function serializeValue(value){if(typeof value==="string"){var maxLength=40;return truncate(value,maxLength)}else if(typeof value==="number"||typeof value==="boolean"||typeof value==="undefined"){return value}var type=Object.prototype.toString.call(value);if(type==="[object Object]")return"[Object]";if(type==="[object Array]")return"[Array]";if(type==="[object Function]")return value.name?"[Function: "+value.name+"]":"[Function]";return value}function serializeObject(value,depth){if(depth===0)return serializeValue(value);if(isPlainObject(value)){return Object.keys(value).reduce((function(acc,key){acc[key]=serializeObject(value[key],depth-1);return acc}),{})}else if(Array.isArray(value)){return value.map((function(val){return serializeObject(val,depth-1)}))}return serializeValue(value)}function serializeException(ex,depth,maxSize){if(!isPlainObject(ex))return ex;depth=typeof depth!=="number"?MAX_SERIALIZE_EXCEPTION_DEPTH:depth;maxSize=typeof depth!=="number"?MAX_SERIALIZE_EXCEPTION_SIZE:maxSize;var serialized=serializeObject(ex,depth);if(jsonSize(stringify(serialized))>maxSize){return serializeException(ex,depth-1)}return serialized}function serializeKeysForMessage(keys,maxLength){if(typeof keys==="number"||typeof keys==="string")return keys.toString();if(!Array.isArray(keys))return"";keys=keys.filter((function(key){return typeof key==="string"}));if(keys.length===0)return"[object has no keys]";maxLength=typeof maxLength!=="number"?MAX_SERIALIZE_KEYS_LENGTH:maxLength;if(keys[0].length>=maxLength)return keys[0];for(var usedKeys=keys.length;usedKeys>0;usedKeys--){var serialized=keys.slice(0,usedKeys).join(", ");if(serialized.length>maxLength)continue;if(usedKeys===keys.length)return serialized;return serialized+"…"}return""}function sanitize(input,sanitizeKeys){if(!isArray(sanitizeKeys)||isArray(sanitizeKeys)&&sanitizeKeys.length===0)return input;var sanitizeRegExp=joinRegExp(sanitizeKeys);var sanitizeMask="********";var safeInput;try{safeInput=JSON.parse(stringify(input))}catch(o_O){return input}function sanitizeWorker(workerInput){if(isArray(workerInput)){return workerInput.map((function(val){return sanitizeWorker(val)}))}if(isPlainObject(workerInput)){return Object.keys(workerInput).reduce((function(acc,k){if(sanitizeRegExp.test(k)){acc[k]=sanitizeMask}else{acc[k]=sanitizeWorker(workerInput[k])}return acc}),{})}return workerInput}return sanitizeWorker(safeInput)}module.exports={isObject,isError,isErrorEvent,isDOMError,isDOMException,isUndefined,isFunction,isPlainObject,isString,isArray,isEmptyObject,supportsErrorEvent,supportsDOMError,supportsDOMException,supportsFetch,supportsReferrerPolicy,supportsPromiseRejectionEvent,wrappedCallback,each,objectMerge,truncate,objectFrozen,hasKey,joinRegExp,urlencode,uuid4,htmlTreeAsString,htmlElementAsString,isSameException,isSameStacktrace,parseUrl,fill,safeJoin,serializeException,serializeKeysForMessage,sanitize}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{7:7}],6:[function(_dereq_,module,exports){(function(global){var utils=_dereq_(5);var TraceKit={collectWindowErrors:true,debug:false};var _window=typeof window!=="undefined"?window:typeof global!=="undefined"?global:typeof self!=="undefined"?self:{};var _slice=[].slice;var UNKNOWN_FUNCTION="?";var ERROR_TYPES_RE=/^(?:[Uu]ncaught (?:exception: )?)?(?:((?:Eval|Internal|Range|Reference|Syntax|Type|URI|)Error): )?(.*)$/;function getLocationHref(){if(typeof document==="undefined"||document.location==null)return"";return document.location.href}function getLocationOrigin(){if(typeof document==="undefined"||document.location==null)return"";if(!document.location.origin){return document.location.protocol+"//"+document.location.hostname+(document.location.port?":"+document.location.port:"")}return document.location.origin}TraceKit.report=function reportModuleWrapper(){var handlers=[],lastArgs=null,lastException=null,lastExceptionStack=null;function subscribe(handler){installGlobalHandler();handlers.push(handler)}function unsubscribe(handler){for(var i=handlers.length-1;i>=0;--i){if(handlers[i]===handler){handlers.splice(i,1)}}}function unsubscribeAll(){uninstallGlobalHandler();handlers=[]}function notifyHandlers(stack,isWindowError){var exception=null;if(isWindowError&&!TraceKit.collectWindowErrors){return}for(var i in handlers){if(handlers.hasOwnProperty(i)){try{handlers[i].apply(null,[stack].concat(_slice.call(arguments,2)))}catch(inner){exception=inner}}}if(exception){throw exception}}var _oldOnerrorHandler,_onErrorHandlerInstalled;function traceKitWindowOnError(msg,url,lineNo,colNo,ex){var stack=null;var exception=utils.isErrorEvent(ex)?ex.error:ex;var message=utils.isErrorEvent(msg)?msg.message:msg;if(lastExceptionStack){TraceKit.computeStackTrace.augmentStackTraceWithInitialElement(lastExceptionStack,url,lineNo,message);processLastException()}else if(exception&&utils.isError(exception)){stack=TraceKit.computeStackTrace(exception);notifyHandlers(stack,true)}else{var location={url,line:lineNo,column:colNo};var name=undefined;var groups;if({}.toString.call(message)==="[object String]"){var groups=message.match(ERROR_TYPES_RE);if(groups){name=groups[1];message=groups[2]}}location.func=UNKNOWN_FUNCTION;stack={name,message,url:getLocationHref(),stack:[location]};notifyHandlers(stack,true)}if(_oldOnerrorHandler){return _oldOnerrorHandler.apply(this,arguments)}return false}function installGlobalHandler(){if(_onErrorHandlerInstalled){return}_oldOnerrorHandler=_window.onerror;_window.onerror=traceKitWindowOnError;_onErrorHandlerInstalled=true}function uninstallGlobalHandler(){if(!_onErrorHandlerInstalled){return}_window.onerror=_oldOnerrorHandler;_onErrorHandlerInstalled=false;_oldOnerrorHandler=undefined}function processLastException(){var _lastExceptionStack=lastExceptionStack,_lastArgs=lastArgs;lastArgs=null;lastExceptionStack=null;lastException=null;notifyHandlers.apply(null,[_lastExceptionStack,false].concat(_lastArgs))}function report(ex,rethrow){var args=_slice.call(arguments,1);if(lastExceptionStack){if(lastException===ex){return}else{processLastException()}}var stack=TraceKit.computeStackTrace(ex);lastExceptionStack=stack;lastException=ex;lastArgs=args;setTimeout((function(){if(lastException===ex){processLastException()}}),stack.incomplete?2e3:0);if(rethrow!==false){throw ex}}report.subscribe=subscribe;report.unsubscribe=unsubscribe;report.uninstall=unsubscribeAll;return report}();TraceKit.computeStackTrace=function computeStackTraceWrapper(){function computeStackTraceFromStackProp(ex){if(typeof ex.stack==="undefined"||!ex.stack)return;var chrome=/^\s*at (?:(.*?) ?\()?((?:file|https?|blob|chrome-extension|native|eval|webpack|<anonymous>|[a-z]:|\/).*?)(?::(\d+))?(?::(\d+))?\)?\s*$/i;var winjs=/^\s*at (?:((?:\[object object\])?.+) )?\(?((?:file|ms-appx(?:-web)|https?|webpack|blob):.*?):(\d+)(?::(\d+))?\)?\s*$/i;var gecko=/^\s*(.*?)(?:\((.*?)\))?(?:^|@)((?:file|https?|blob|chrome|webpack|resource|moz-extension).*?:\/.*?|\[native code\]|[^@]*(?:bundle|\d+\.js))(?::(\d+))?(?::(\d+))?\s*$/i;var geckoEval=/(\S+) line (\d+)(?: > eval line \d+)* > eval/i;var chromeEval=/\((\S*)(?::(\d+))(?::(\d+))\)/;var lines=ex.stack.split("\n");var stack=[];var submatch;var parts;var element;var reference=/^(.*) is undefined$/.exec(ex.message);for(var i=0,j=lines.length;i<j;++i){if(parts=chrome.exec(lines[i])){var isNative=parts[2]&&parts[2].indexOf("native")===0;var isEval=parts[2]&&parts[2].indexOf("eval")===0;if(isEval&&(submatch=chromeEval.exec(parts[2]))){parts[2]=submatch[1];parts[3]=submatch[2];parts[4]=submatch[3]}element={url:!isNative?parts[2]:null,func:parts[1]||UNKNOWN_FUNCTION,args:isNative?[parts[2]]:[],line:parts[3]?+parts[3]:null,column:parts[4]?+parts[4]:null}}else if(parts=winjs.exec(lines[i])){element={url:parts[2],func:parts[1]||UNKNOWN_FUNCTION,args:[],line:+parts[3],column:parts[4]?+parts[4]:null}}else if(parts=gecko.exec(lines[i])){var isEval=parts[3]&&parts[3].indexOf(" > eval")>-1;if(isEval&&(submatch=geckoEval.exec(parts[3]))){parts[3]=submatch[1];parts[4]=submatch[2];parts[5]=null}else if(i===0&&!parts[5]&&typeof ex.columnNumber!=="undefined"){stack[0].column=ex.columnNumber+1}element={url:parts[3],func:parts[1]||UNKNOWN_FUNCTION,args:parts[2]?parts[2].split(","):[],line:parts[4]?+parts[4]:null,column:parts[5]?+parts[5]:null}}else{continue}if(!element.func&&element.line){element.func=UNKNOWN_FUNCTION}if(element.url&&element.url.substr(0,5)==="blob:"){var xhr=new XMLHttpRequest;xhr.open("GET",element.url,false);xhr.send(null);if(xhr.status===200){var source=xhr.responseText||"";source=source.slice(-300);var sourceMaps=source.match(/\/\/# sourceMappingURL=(.*)$/);if(sourceMaps){var sourceMapAddress=sourceMaps[1];if(sourceMapAddress.charAt(0)==="~"){sourceMapAddress=getLocationOrigin()+sourceMapAddress.slice(1)}element.url=sourceMapAddress.slice(0,-4)}}}stack.push(element)}if(!stack.length){return null}return{name:ex.name,message:ex.message,url:getLocationHref(),stack}}function augmentStackTraceWithInitialElement(stackInfo,url,lineNo,message){var initial={url,line:lineNo};if(initial.url&&initial.line){stackInfo.incomplete=false;if(!initial.func){initial.func=UNKNOWN_FUNCTION}if(stackInfo.stack.length>0){if(stackInfo.stack[0].url===initial.url){if(stackInfo.stack[0].line===initial.line){return false}else if(!stackInfo.stack[0].line&&stackInfo.stack[0].func===initial.func){stackInfo.stack[0].line=initial.line;return false}}}stackInfo.stack.unshift(initial);stackInfo.partial=true;return true}else{stackInfo.incomplete=true}return false}function computeStackTraceByWalkingCallerChain(ex,depth){var functionName=/function\s+([_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*)?\s*\(/i,stack=[],funcs={},recursion=false,parts,item,source;for(var curr=computeStackTraceByWalkingCallerChain.caller;curr&&!recursion;curr=curr.caller){if(curr===computeStackTrace||curr===TraceKit.report){continue}item={url:null,func:UNKNOWN_FUNCTION,line:null,column:null};if(curr.name){item.func=curr.name}else if(parts=functionName.exec(curr.toString())){item.func=parts[1]}if(typeof item.func==="undefined"){try{item.func=parts.input.substring(0,parts.input.indexOf("{"))}catch(e){}}if(funcs[""+curr]){recursion=true}else{funcs[""+curr]=true}stack.push(item)}if(depth){stack.splice(0,depth)}var result={name:ex.name,message:ex.message,url:getLocationHref(),stack};augmentStackTraceWithInitialElement(result,ex.sourceURL||ex.fileName,ex.line||ex.lineNumber,ex.message||ex.description);return result}function computeStackTrace(ex,depth){var stack=null;depth=depth==null?0:+depth;try{stack=computeStackTraceFromStackProp(ex);if(stack){return stack}}catch(e){if(TraceKit.debug){throw e}}try{stack=computeStackTraceByWalkingCallerChain(ex,depth+1);if(stack){return stack}}catch(e){if(TraceKit.debug){throw e}}return{name:ex.name,message:ex.message,url:getLocationHref()}}computeStackTrace.augmentStackTraceWithInitialElement=augmentStackTraceWithInitialElement;computeStackTrace.computeStackTraceFromStackProp=computeStackTraceFromStackProp;return computeStackTrace}();module.exports=TraceKit}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{5:5}],7:[function(_dereq_,module,exports){exports=module.exports=stringify;exports.getSerialize=serializer;function indexOf(haystack,needle){for(var i=0;i<haystack.length;++i){if(haystack[i]===needle)return i}return-1}function stringify(obj,replacer,spaces,cycleReplacer){return JSON.stringify(obj,serializer(replacer,cycleReplacer),spaces)}function stringifyError(value){var err={stack:value.stack,message:value.message,name:value.name};for(var i in value){if(Object.prototype.hasOwnProperty.call(value,i)){err[i]=value[i]}}return err}function serializer(replacer,cycleReplacer){var stack=[];var keys=[];if(cycleReplacer==null){cycleReplacer=function(key,value){if(stack[0]===value){return"[Circular ~]"}return"[Circular ~."+keys.slice(0,indexOf(stack,value)).join(".")+"]"}}return function(key,value){if(stack.length>0){var thisPos=indexOf(stack,this);~thisPos?stack.splice(thisPos+1):stack.push(this);~thisPos?keys.splice(thisPos,Infinity,key):keys.push(key);if(~indexOf(stack,value)){value=cycleReplacer.call(this,key,value)}}else{stack.push(value)}return replacer==null?value instanceof Error?stringifyError(value):value:replacer.call(this,key,value)}}},{}],8:[function(_dereq_,module,exports){function safeAdd(x,y){var lsw=(x&65535)+(y&65535);var msw=(x>>16)+(y>>16)+(lsw>>16);return msw<<16|lsw&65535}function bitRotateLeft(num,cnt){return num<<cnt|num>>>32-cnt}function md5cmn(q,a,b,x,s,t){return safeAdd(bitRotateLeft(safeAdd(safeAdd(a,q),safeAdd(x,t)),s),b)}function md5ff(a,b,c,d,x,s,t){return md5cmn(b&c|~b&d,a,b,x,s,t)}function md5gg(a,b,c,d,x,s,t){return md5cmn(b&d|c&~d,a,b,x,s,t)}function md5hh(a,b,c,d,x,s,t){return md5cmn(b^c^d,a,b,x,s,t)}function md5ii(a,b,c,d,x,s,t){return md5cmn(c^(b|~d),a,b,x,s,t)}function binlMD5(x,len){x[len>>5]|=128<<len%32;x[(len+64>>>9<<4)+14]=len;var i;var olda;var oldb;var oldc;var oldd;var a=1732584193;var b=-271733879;var c=-1732584194;var d=271733878;for(i=0;i<x.length;i+=16){olda=a;oldb=b;oldc=c;oldd=d;a=md5ff(a,b,c,d,x[i],7,-680876936);d=md5ff(d,a,b,c,x[i+1],12,-389564586);c=md5ff(c,d,a,b,x[i+2],17,606105819);b=md5ff(b,c,d,a,x[i+3],22,-1044525330);a=md5ff(a,b,c,d,x[i+4],7,-176418897);d=md5ff(d,a,b,c,x[i+5],12,1200080426);c=md5ff(c,d,a,b,x[i+6],17,-1473231341);b=md5ff(b,c,d,a,x[i+7],22,-45705983);a=md5ff(a,b,c,d,x[i+8],7,1770035416);d=md5ff(d,a,b,c,x[i+9],12,-1958414417);c=md5ff(c,d,a,b,x[i+10],17,-42063);b=md5ff(b,c,d,a,x[i+11],22,-1990404162);a=md5ff(a,b,c,d,x[i+12],7,1804603682);d=md5ff(d,a,b,c,x[i+13],12,-40341101);c=md5ff(c,d,a,b,x[i+14],17,-1502002290);b=md5ff(b,c,d,a,x[i+15],22,1236535329);a=md5gg(a,b,c,d,x[i+1],5,-165796510);d=md5gg(d,a,b,c,x[i+6],9,-1069501632);c=md5gg(c,d,a,b,x[i+11],14,643717713);b=md5gg(b,c,d,a,x[i],20,-373897302);a=md5gg(a,b,c,d,x[i+5],5,-701558691);d=md5gg(d,a,b,c,x[i+10],9,38016083);c=md5gg(c,d,a,b,x[i+15],14,-660478335);b=md5gg(b,c,d,a,x[i+4],20,-405537848);a=md5gg(a,b,c,d,x[i+9],5,568446438);d=md5gg(d,a,b,c,x[i+14],9,-1019803690);c=md5gg(c,d,a,b,x[i+3],14,-187363961);b=md5gg(b,c,d,a,x[i+8],20,1163531501);a=md5gg(a,b,c,d,x[i+13],5,-1444681467);d=md5gg(d,a,b,c,x[i+2],9,-51403784);c=md5gg(c,d,a,b,x[i+7],14,1735328473);b=md5gg(b,c,d,a,x[i+12],20,-1926607734);a=md5hh(a,b,c,d,x[i+5],4,-378558);d=md5hh(d,a,b,c,x[i+8],11,-2022574463);c=md5hh(c,d,a,b,x[i+11],16,1839030562);b=md5hh(b,c,d,a,x[i+14],23,-35309556);a=md5hh(a,b,c,d,x[i+1],4,-1530992060);d=md5hh(d,a,b,c,x[i+4],11,1272893353);c=md5hh(c,d,a,b,x[i+7],16,-155497632);b=md5hh(b,c,d,a,x[i+10],23,-1094730640);a=md5hh(a,b,c,d,x[i+13],4,681279174);d=md5hh(d,a,b,c,x[i],11,-358537222);c=md5hh(c,d,a,b,x[i+3],16,-722521979);b=md5hh(b,c,d,a,x[i+6],23,76029189);a=md5hh(a,b,c,d,x[i+9],4,-640364487);d=md5hh(d,a,b,c,x[i+12],11,-421815835);c=md5hh(c,d,a,b,x[i+15],16,530742520);b=md5hh(b,c,d,a,x[i+2],23,-995338651);a=md5ii(a,b,c,d,x[i],6,-198630844);d=md5ii(d,a,b,c,x[i+7],10,1126891415);c=md5ii(c,d,a,b,x[i+14],15,-1416354905);b=md5ii(b,c,d,a,x[i+5],21,-57434055);a=md5ii(a,b,c,d,x[i+12],6,1700485571);d=md5ii(d,a,b,c,x[i+3],10,-1894986606);c=md5ii(c,d,a,b,x[i+10],15,-1051523);b=md5ii(b,c,d,a,x[i+1],21,-2054922799);a=md5ii(a,b,c,d,x[i+8],6,1873313359);d=md5ii(d,a,b,c,x[i+15],10,-30611744);c=md5ii(c,d,a,b,x[i+6],15,-1560198380);b=md5ii(b,c,d,a,x[i+13],21,1309151649);a=md5ii(a,b,c,d,x[i+4],6,-145523070);d=md5ii(d,a,b,c,x[i+11],10,-1120210379);c=md5ii(c,d,a,b,x[i+2],15,718787259);b=md5ii(b,c,d,a,x[i+9],21,-343485551);a=safeAdd(a,olda);b=safeAdd(b,oldb);c=safeAdd(c,oldc);d=safeAdd(d,oldd)}return[a,b,c,d]}function binl2rstr(input){var i;var output="";var length32=input.length*32;for(i=0;i<length32;i+=8){output+=String.fromCharCode(input[i>>5]>>>i%32&255)}return output}function rstr2binl(input){var i;var output=[];output[(input.length>>2)-1]=undefined;for(i=0;i<output.length;i+=1){output[i]=0}var length8=input.length*8;for(i=0;i<length8;i+=8){output[i>>5]|=(input.charCodeAt(i/8)&255)<<i%32}return output}function rstrMD5(s){return binl2rstr(binlMD5(rstr2binl(s),s.length*8))}function rstrHMACMD5(key,data){var i;var bkey=rstr2binl(key);var ipad=[];var opad=[];var hash;ipad[15]=opad[15]=undefined;if(bkey.length>16){bkey=binlMD5(bkey,key.length*8)}for(i=0;i<16;i+=1){ipad[i]=bkey[i]^909522486;opad[i]=bkey[i]^1549556828}hash=binlMD5(ipad.concat(rstr2binl(data)),512+data.length*8);return binl2rstr(binlMD5(opad.concat(hash),512+128))}function rstr2hex(input){var hexTab="0123456789abcdef";var output="";var x;var i;for(i=0;i<input.length;i+=1){x=input.charCodeAt(i);output+=hexTab.charAt(x>>>4&15)+hexTab.charAt(x&15)}return output}function str2rstrUTF8(input){return unescape(encodeURIComponent(input))}function rawMD5(s){return rstrMD5(str2rstrUTF8(s))}function hexMD5(s){return rstr2hex(rawMD5(s))}function rawHMACMD5(k,d){return rstrHMACMD5(str2rstrUTF8(k),str2rstrUTF8(d))}function hexHMACMD5(k,d){return rstr2hex(rawHMACMD5(k,d))}function md5(string,key,raw){if(!key){if(!raw){return hexMD5(string)}return rawMD5(string)}if(!raw){return hexHMACMD5(key,string)}return rawHMACMD5(key,string)}module.exports=md5},{}]},{},[4])(4)}))},module=>{"use strict";var Config={DEBUG:false,LIB_VERSION:"2.30.1"};var window$1;if(typeof window==="undefined"){var loc={hostname:""};window$1={navigator:{userAgent:""},document:{location:loc,referrer:""},screen:{width:0,height:0},location:loc}}else{window$1=window}var ArrayProto=Array.prototype;var FuncProto=Function.prototype;var ObjProto=Object.prototype;var slice=ArrayProto.slice;var toString=ObjProto.toString;var hasOwnProperty=ObjProto.hasOwnProperty;var windowConsole=window$1.console;var navigator$1=window$1.navigator;var document$1=window$1.document;var windowOpera=window$1.opera;var screen=window$1.screen;var userAgent=navigator$1.userAgent;var nativeBind=FuncProto.bind;var nativeForEach=ArrayProto.forEach;var nativeIndexOf=ArrayProto.indexOf;var nativeIsArray=Array.isArray;var breaker={};var DOMAIN_MATCH_REGEX=/[a-z0-9][a-z0-9-]+\.[a-z.]{2,6}$/i;var _={trim:function(str){return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")}};var console$1={log:function(){if(Config.DEBUG&&!_.isUndefined(windowConsole)&&windowConsole){try{windowConsole.log.apply(windowConsole,arguments)}catch(err){_.each(arguments,(function(arg){windowConsole.log(arg)}))}}},error:function(){if(Config.DEBUG&&!_.isUndefined(windowConsole)&&windowConsole){var args=["Mixpanel error:"].concat(_.toArray(arguments));try{windowConsole.error.apply(windowConsole,args)}catch(err){_.each(args,(function(arg){windowConsole.error(arg)}))}}},critical:function(){if(!_.isUndefined(windowConsole)&&windowConsole){var args=["Mixpanel error:"].concat(_.toArray(arguments));try{windowConsole.error.apply(windowConsole,args)}catch(err){_.each(args,(function(arg){windowConsole.error(arg)}))}}}};_.bind=function(func,context){var args,bound;if(nativeBind&&func.bind===nativeBind){return nativeBind.apply(func,slice.call(arguments,1))}if(!_.isFunction(func)){throw new TypeError}args=slice.call(arguments,2);bound=function(){if(!(this instanceof bound)){return func.apply(context,args.concat(slice.call(arguments)))}var ctor={};ctor.prototype=func.prototype;var self=new ctor;ctor.prototype=null;var result=func.apply(self,args.concat(slice.call(arguments)));if(Object(result)===result){return result}return self};return bound};_.bind_instance_methods=function(obj){for(var func in obj){if(typeof obj[func]==="function"){obj[func]=_.bind(obj[func],obj)}}};_.each=function(obj,iterator,context){if(obj===null||obj===undefined){return}if(nativeForEach&&obj.forEach===nativeForEach){obj.forEach(iterator,context)}else if(obj.length===+obj.length){for(var i=0,l=obj.length;i<l;i++){if(i in obj&&iterator.call(context,obj[i],i,obj)===breaker){return}}}else{for(var key in obj){if(hasOwnProperty.call(obj,key)){if(iterator.call(context,obj[key],key,obj)===breaker){return}}}}};_.escapeHTML=function(s){var escaped=s;if(escaped&&_.isString(escaped)){escaped=escaped.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}return escaped};_.extend=function(obj){_.each(slice.call(arguments,1),(function(source){for(var prop in source){if(source[prop]!==void 0){obj[prop]=source[prop]}}}));return obj};_.isArray=nativeIsArray||function(obj){return toString.call(obj)==="[object Array]"};_.isFunction=function(f){try{return/^\s*\bfunction\b/.test(f)}catch(x){return false}};_.isArguments=function(obj){return!!(obj&&hasOwnProperty.call(obj,"callee"))};_.toArray=function(iterable){if(!iterable){return[]}if(iterable.toArray){return iterable.toArray()}if(_.isArray(iterable)){return slice.call(iterable)}if(_.isArguments(iterable)){return slice.call(iterable)}return _.values(iterable)};_.keys=function(obj){var results=[];if(obj===null){return results}_.each(obj,(function(value,key){results[results.length]=key}));return results};_.values=function(obj){var results=[];if(obj===null){return results}_.each(obj,(function(value){results[results.length]=value}));return results};_.identity=function(value){return value};_.include=function(obj,target){var found=false;if(obj===null){return found}if(nativeIndexOf&&obj.indexOf===nativeIndexOf){return obj.indexOf(target)!=-1}_.each(obj,(function(value){if(found||(found=value===target)){return breaker}}));return found};_.includes=function(str,needle){return str.indexOf(needle)!==-1};_.inherit=function(subclass,superclass){subclass.prototype=new superclass;subclass.prototype.constructor=subclass;subclass.superclass=superclass.prototype;return subclass};_.isObject=function(obj){return obj===Object(obj)&&!_.isArray(obj)};_.isEmptyObject=function(obj){if(_.isObject(obj)){for(var key in obj){if(hasOwnProperty.call(obj,key)){return false}}return true}return false};_.isUndefined=function(obj){return obj===void 0};_.isString=function(obj){return toString.call(obj)=="[object String]"};_.isDate=function(obj){return toString.call(obj)=="[object Date]"};_.isNumber=function(obj){return toString.call(obj)=="[object Number]"};_.isElement=function(obj){return!!(obj&&obj.nodeType===1)};_.encodeDates=function(obj){_.each(obj,(function(v,k){if(_.isDate(v)){obj[k]=_.formatDate(v)}else if(_.isObject(v)){obj[k]=_.encodeDates(v)}}));return obj};_.timestamp=function(){Date.now=Date.now||function(){return+new Date};return Date.now()};_.formatDate=function(d){function pad(n){return n<10?"0"+n:n}return d.getUTCFullYear()+"-"+pad(d.getUTCMonth()+1)+"-"+pad(d.getUTCDate())+"T"+pad(d.getUTCHours())+":"+pad(d.getUTCMinutes())+":"+pad(d.getUTCSeconds())};_.safewrap=function(f){return function(){try{return f.apply(this,arguments)}catch(e){console$1.critical("Implementation error. Please turn on debug and contact support@mixpanel.com.");if(Config.DEBUG){console$1.critical(e)}}}};_.safewrap_class=function(klass,functions){for(var i=0;i<functions.length;i++){klass.prototype[functions[i]]=_.safewrap(klass.prototype[functions[i]])}};_.safewrap_instance_methods=function(obj){for(var func in obj){if(typeof obj[func]==="function"){obj[func]=_.safewrap(obj[func])}}};_.strip_empty_properties=function(p){var ret={};_.each(p,(function(v,k){if(_.isString(v)&&v.length>0){ret[k]=v}}));return ret};_.truncate=function(obj,length){var ret;if(typeof obj==="string"){ret=obj.slice(0,length)}else if(_.isArray(obj)){ret=[];_.each(obj,(function(val){ret.push(_.truncate(val,length))}))}else if(_.isObject(obj)){ret={};_.each(obj,(function(val,key){ret[key]=_.truncate(val,length)}))}else{ret=obj}return ret};_.JSONEncode=function(){return function(mixed_val){var value=mixed_val;var quote=function(string){var escapable=/[\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;var meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"};escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,(function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)}))+'"':'"'+string+'"'};var str=function(key,holder){var gap="";var indent="    ";var i=0;var k="";var v="";var length=0;var mind=gap;var partial=[];var value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}for(k in value){if(hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}v=partial.length===0?"{}":gap?"{"+partial.join(",")+""+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}};return str("",{"":value})}}();_.JSONDecode=function(){var at,ch,escapee={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"},text,error=function(m){var e=new SyntaxError(m);e.at=at;e.text=text;throw e},next=function(c){if(c&&c!==ch){error("Expected '"+c+"' instead of '"+ch+"'")}ch=text.charAt(at);at+=1;return ch},number=function(){var number,string="";if(ch==="-"){string="-";next("-")}while(ch>="0"&&ch<="9"){string+=ch;next()}if(ch==="."){string+=".";while(next()&&ch>="0"&&ch<="9"){string+=ch}}if(ch==="e"||ch==="E"){string+=ch;next();if(ch==="-"||ch==="+"){string+=ch;next()}while(ch>="0"&&ch<="9"){string+=ch;next()}}number=+string;if(!isFinite(number)){error("Bad number")}else{return number}},string=function(){var hex,i,string="",uffff;if(ch==='"'){while(next()){if(ch==='"'){next();return string}if(ch==="\\"){next();if(ch==="u"){uffff=0;for(i=0;i<4;i+=1){hex=parseInt(next(),16);if(!isFinite(hex)){break}uffff=uffff*16+hex}string+=String.fromCharCode(uffff)}else if(typeof escapee[ch]==="string"){string+=escapee[ch]}else{break}}else{string+=ch}}}error("Bad string")},white=function(){while(ch&&ch<=" "){next()}},word=function(){switch(ch){case"t":next("t");next("r");next("u");next("e");return true;case"f":next("f");next("a");next("l");next("s");next("e");return false;case"n":next("n");next("u");next("l");next("l");return null}error('Unexpected "'+ch+'"')},value,array=function(){var array=[];if(ch==="["){next("[");white();if(ch==="]"){next("]");return array}while(ch){array.push(value());white();if(ch==="]"){next("]");return array}next(",");white()}}error("Bad array")},object=function(){var key,object={};if(ch==="{"){next("{");white();if(ch==="}"){next("}");return object}while(ch){key=string();white();next(":");if(Object.hasOwnProperty.call(object,key)){error('Duplicate key "'+key+'"')}object[key]=value();white();if(ch==="}"){next("}");return object}next(",");white()}}error("Bad object")};value=function(){white();switch(ch){case"{":return object();case"[":return array();case'"':return string();case"-":return number();default:return ch>="0"&&ch<="9"?number():word()}};return function(source){var result;text=source;at=0;ch=" ";result=value();white();if(ch){error("Syntax error")}return result}}();_.base64Encode=function(data){var b64="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var o1,o2,o3,h1,h2,h3,h4,bits,i=0,ac=0,enc="",tmp_arr=[];if(!data){return data}data=_.utf8Encode(data);do{o1=data.charCodeAt(i++);o2=data.charCodeAt(i++);o3=data.charCodeAt(i++);bits=o1<<16|o2<<8|o3;h1=bits>>18&63;h2=bits>>12&63;h3=bits>>6&63;h4=bits&63;tmp_arr[ac++]=b64.charAt(h1)+b64.charAt(h2)+b64.charAt(h3)+b64.charAt(h4)}while(i<data.length);enc=tmp_arr.join("");switch(data.length%3){case 1:enc=enc.slice(0,-2)+"==";break;case 2:enc=enc.slice(0,-1)+"=";break}return enc};_.utf8Encode=function(string){string=(string+"").replace(/\r\n/g,"\n").replace(/\r/g,"\n");var utftext="",start,end;var stringl=0,n;start=end=0;stringl=string.length;for(n=0;n<stringl;n++){var c1=string.charCodeAt(n);var enc=null;if(c1<128){end++}else if(c1>127&&c1<2048){enc=String.fromCharCode(c1>>6|192,c1&63|128)}else{enc=String.fromCharCode(c1>>12|224,c1>>6&63|128,c1&63|128)}if(enc!==null){if(end>start){utftext+=string.substring(start,end)}utftext+=enc;start=end=n+1}}if(end>start){utftext+=string.substring(start,string.length)}return utftext};_.UUID=function(){var T=function(){var d=1*new Date,i=0;while(d==1*new Date){i++}return d.toString(16)+i.toString(16)};var R=function(){return Math.random().toString(16).replace(".","")};var UA=function(){var ua=userAgent,i,ch,buffer=[],ret=0;function xor(result,byte_array){var j,tmp=0;for(j=0;j<byte_array.length;j++){tmp|=buffer[j]<<j*8}return result^tmp}for(i=0;i<ua.length;i++){ch=ua.charCodeAt(i);buffer.unshift(ch&255);if(buffer.length>=4){ret=xor(ret,buffer);buffer=[]}}if(buffer.length>0){ret=xor(ret,buffer)}return ret.toString(16)};return function(){var se=(screen.height*screen.width).toString(16);return T()+"-"+R()+"-"+UA()+"-"+se+"-"+T()}}();_.isBlockedUA=function(ua){if(/(google web preview|baiduspider|yandexbot|bingbot|googlebot|yahoo! slurp)/i.test(ua)){return true}return false};_.HTTPBuildQuery=function(formdata,arg_separator){var use_val,use_key,tmp_arr=[];if(_.isUndefined(arg_separator)){arg_separator="&"}_.each(formdata,(function(val,key){use_val=encodeURIComponent(val.toString());use_key=encodeURIComponent(key);tmp_arr[tmp_arr.length]=use_key+"="+use_val}));return tmp_arr.join(arg_separator)};_.getQueryParam=function(url,param){param=param.replace(/[[]/,"\\[").replace(/[\]]/,"\\]");var regexS="[\\?&]"+param+"=([^&#]*)",regex=new RegExp(regexS),results=regex.exec(url);if(results===null||results&&typeof results[1]!=="string"&&results[1].length){return""}else{return decodeURIComponent(results[1]).replace(/\+/g," ")}};_.getHashParam=function(hash,param){var matches=hash.match(new RegExp(param+"=([^&]*)"));return matches?matches[1]:null};_.cookie={get:function(name){var nameEQ=name+"=";var ca=document$1.cookie.split(";");for(var i=0;i<ca.length;i++){var c=ca[i];while(c.charAt(0)==" "){c=c.substring(1,c.length)}if(c.indexOf(nameEQ)===0){return decodeURIComponent(c.substring(nameEQ.length,c.length))}}return null},parse:function(name){var cookie;try{cookie=_.JSONDecode(_.cookie.get(name))||{}}catch(err){}return cookie},set_seconds:function(name,value,seconds,cross_subdomain,is_secure){var cdomain="",expires="",secure="";if(cross_subdomain){var matches=document$1.location.hostname.match(DOMAIN_MATCH_REGEX),domain=matches?matches[0]:"";cdomain=domain?"; domain=."+domain:""}if(seconds){var date=new Date;date.setTime(date.getTime()+seconds*1e3);expires="; expires="+date.toGMTString()}if(is_secure){secure="; secure"}document$1.cookie=name+"="+encodeURIComponent(value)+expires+"; path=/"+cdomain+secure},set:function(name,value,days,cross_subdomain,is_secure){var cdomain="",expires="",secure="";if(cross_subdomain){var matches=document$1.location.hostname.match(DOMAIN_MATCH_REGEX),domain=matches?matches[0]:"";cdomain=domain?"; domain=."+domain:""}if(days){var date=new Date;date.setTime(date.getTime()+days*24*60*60*1e3);expires="; expires="+date.toGMTString()}if(is_secure){secure="; secure"}var new_cookie_val=name+"="+encodeURIComponent(value)+expires+"; path=/"+cdomain+secure;document$1.cookie=new_cookie_val;return new_cookie_val},remove:function(name,cross_subdomain){_.cookie.set(name,"",-1,cross_subdomain)}};var _localStorage_supported=null;_.localStorage={is_supported:function(){if(_localStorage_supported!==null){return _localStorage_supported}var supported=true;try{var key="__mplssupport__",val="xyz";_.localStorage.set(key,val);if(_.localStorage.get(key)!==val){supported=false}_.localStorage.remove(key)}catch(err){supported=false}if(!supported){console$1.error("localStorage unsupported; falling back to cookie store")}_localStorage_supported=supported;return supported},error:function(msg){console$1.error("localStorage error: "+msg)},get:function(name){try{return window.localStorage.getItem(name)}catch(err){_.localStorage.error(err)}return null},parse:function(name){try{return _.JSONDecode(_.localStorage.get(name))||{}}catch(err){}return null},set:function(name,value){try{window.localStorage.setItem(name,value)}catch(err){_.localStorage.error(err)}},remove:function(name){try{window.localStorage.removeItem(name)}catch(err){_.localStorage.error(err)}}};_.register_event=function(){var register_event=function(element,type,handler,oldSchool,useCapture){if(!element){console$1.error("No valid element provided to register_event");return}if(element.addEventListener&&!oldSchool){element.addEventListener(type,handler,!!useCapture)}else{var ontype="on"+type;var old_handler=element[ontype];element[ontype]=makeHandler(element,handler,old_handler)}};function makeHandler(element,new_handler,old_handlers){var handler=function(event){event=event||fixEvent(window.event);if(!event){return undefined}var ret=true;var old_result,new_result;if(_.isFunction(old_handlers)){old_result=old_handlers(event)}new_result=new_handler.call(element,event);if(false===old_result||false===new_result){ret=false}return ret};return handler}function fixEvent(event){if(event){event.preventDefault=fixEvent.preventDefault;event.stopPropagation=fixEvent.stopPropagation}return event}fixEvent.preventDefault=function(){this.returnValue=false};fixEvent.stopPropagation=function(){this.cancelBubble=true};return register_event}();var TOKEN_MATCH_REGEX=new RegExp('^(\\w*)\\[(\\w+)([=~\\|\\^\\$\\*]?)=?"?([^\\]"]*)"?\\]$');_.dom_query=function(){function getAllChildren(e){return e.all?e.all:e.getElementsByTagName("*")}var bad_whitespace=/[\t\r\n]/g;function hasClass(elem,selector){var className=" "+selector+" ";return(" "+elem.className+" ").replace(bad_whitespace," ").indexOf(className)>=0}function getElementsBySelector(selector){if(!document$1.getElementsByTagName){return[]}var tokens=selector.split(" ");var token,bits,tagName,found,foundCount,i,j,k,elements,currentContextIndex;var currentContext=[document$1];for(i=0;i<tokens.length;i++){token=tokens[i].replace(/^\s+/,"").replace(/\s+$/,"");if(token.indexOf("#")>-1){bits=token.split("#");tagName=bits[0];var id=bits[1];var element=document$1.getElementById(id);if(!element||tagName&&element.nodeName.toLowerCase()!=tagName){return[]}currentContext=[element];continue}if(token.indexOf(".")>-1){bits=token.split(".");tagName=bits[0];var className=bits[1];if(!tagName){tagName="*"}found=[];foundCount=0;for(j=0;j<currentContext.length;j++){if(tagName=="*"){elements=getAllChildren(currentContext[j])}else{elements=currentContext[j].getElementsByTagName(tagName)}for(k=0;k<elements.length;k++){found[foundCount++]=elements[k]}}currentContext=[];currentContextIndex=0;for(j=0;j<found.length;j++){if(found[j].className&&_.isString(found[j].className)&&hasClass(found[j],className)){currentContext[currentContextIndex++]=found[j]}}continue}var token_match=token.match(TOKEN_MATCH_REGEX);if(token_match){tagName=token_match[1];var attrName=token_match[2];var attrOperator=token_match[3];var attrValue=token_match[4];if(!tagName){tagName="*"}found=[];foundCount=0;for(j=0;j<currentContext.length;j++){if(tagName=="*"){elements=getAllChildren(currentContext[j])}else{elements=currentContext[j].getElementsByTagName(tagName)}for(k=0;k<elements.length;k++){found[foundCount++]=elements[k]}}currentContext=[];currentContextIndex=0;var checkFunction;switch(attrOperator){case"=":checkFunction=function(e){return e.getAttribute(attrName)==attrValue};break;case"~":checkFunction=function(e){return e.getAttribute(attrName).match(new RegExp("\\b"+attrValue+"\\b"))};break;case"|":checkFunction=function(e){return e.getAttribute(attrName).match(new RegExp("^"+attrValue+"-?"))};break;case"^":checkFunction=function(e){return e.getAttribute(attrName).indexOf(attrValue)===0};break;case"$":checkFunction=function(e){return e.getAttribute(attrName).lastIndexOf(attrValue)==e.getAttribute(attrName).length-attrValue.length};break;case"*":checkFunction=function(e){return e.getAttribute(attrName).indexOf(attrValue)>-1};break;default:checkFunction=function(e){return e.getAttribute(attrName)}}currentContext=[];currentContextIndex=0;for(j=0;j<found.length;j++){if(checkFunction(found[j])){currentContext[currentContextIndex++]=found[j]}}continue}tagName=token;found=[];foundCount=0;for(j=0;j<currentContext.length;j++){elements=currentContext[j].getElementsByTagName(tagName);for(k=0;k<elements.length;k++){found[foundCount++]=elements[k]}}currentContext=found}return currentContext}return function(query){if(_.isElement(query)){return[query]}else if(_.isObject(query)&&!_.isUndefined(query.length)){return query}else{return getElementsBySelector.call(this,query)}}}();_.info={campaignParams:function(){var campaign_keywords="utm_source utm_medium utm_campaign utm_content utm_term".split(" "),kw="",params={};_.each(campaign_keywords,(function(kwkey){kw=_.getQueryParam(document$1.URL,kwkey);if(kw.length){params[kwkey]=kw}}));return params},searchEngine:function(referrer){if(referrer.search("https?://(.*)google.([^/?]*)")===0){return"google"}else if(referrer.search("https?://(.*)bing.com")===0){return"bing"}else if(referrer.search("https?://(.*)yahoo.com")===0){return"yahoo"}else if(referrer.search("https?://(.*)duckduckgo.com")===0){return"duckduckgo"}else{return null}},searchInfo:function(referrer){var search=_.info.searchEngine(referrer),param=search!="yahoo"?"q":"p",ret={};if(search!==null){ret["$search_engine"]=search;var keyword=_.getQueryParam(referrer,param);if(keyword.length){ret["mp_keyword"]=keyword}}return ret},browser:function(user_agent,vendor,opera){vendor=vendor||"";if(opera||_.includes(user_agent," OPR/")){if(_.includes(user_agent,"Mini")){return"Opera Mini"}return"Opera"}else if(/(BlackBerry|PlayBook|BB10)/i.test(user_agent)){return"BlackBerry"}else if(_.includes(user_agent,"IEMobile")||_.includes(user_agent,"WPDesktop")){return"Internet Explorer Mobile"}else if(_.includes(user_agent,"Edge")){return"Microsoft Edge"}else if(_.includes(user_agent,"FBIOS")){return"Facebook Mobile"}else if(_.includes(user_agent,"Chrome")){return"Chrome"}else if(_.includes(user_agent,"CriOS")){return"Chrome iOS"}else if(_.includes(user_agent,"UCWEB")||_.includes(user_agent,"UCBrowser")){return"UC Browser"}else if(_.includes(user_agent,"FxiOS")){return"Firefox iOS"}else if(_.includes(vendor,"Apple")){if(_.includes(user_agent,"Mobile")){return"Mobile Safari"}return"Safari"}else if(_.includes(user_agent,"Android")){return"Android Mobile"}else if(_.includes(user_agent,"Konqueror")){return"Konqueror"}else if(_.includes(user_agent,"Firefox")){return"Firefox"}else if(_.includes(user_agent,"MSIE")||_.includes(user_agent,"Trident/")){return"Internet Explorer"}else if(_.includes(user_agent,"Gecko")){return"Mozilla"}else{return""}},browserVersion:function(userAgent,vendor,opera){var browser=_.info.browser(userAgent,vendor,opera);var versionRegexs={"Internet Explorer Mobile":/rv:(\d+(\.\d+)?)/,"Microsoft Edge":/Edge\/(\d+(\.\d+)?)/,Chrome:/Chrome\/(\d+(\.\d+)?)/,"Chrome iOS":/CriOS\/(\d+(\.\d+)?)/,"UC Browser":/(UCBrowser|UCWEB)\/(\d+(\.\d+)?)/,Safari:/Version\/(\d+(\.\d+)?)/,"Mobile Safari":/Version\/(\d+(\.\d+)?)/,Opera:/(Opera|OPR)\/(\d+(\.\d+)?)/,Firefox:/Firefox\/(\d+(\.\d+)?)/,"Firefox iOS":/FxiOS\/(\d+(\.\d+)?)/,Konqueror:/Konqueror:(\d+(\.\d+)?)/,BlackBerry:/BlackBerry (\d+(\.\d+)?)/,"Android Mobile":/android\s(\d+(\.\d+)?)/,"Internet Explorer":/(rv:|MSIE )(\d+(\.\d+)?)/,Mozilla:/rv:(\d+(\.\d+)?)/};var regex=versionRegexs[browser];if(regex===undefined){return null}var matches=userAgent.match(regex);if(!matches){return null}return parseFloat(matches[matches.length-2])},os:function(){var a=userAgent;if(/Windows/i.test(a)){if(/Phone/.test(a)||/WPDesktop/.test(a)){return"Windows Phone"}return"Windows"}else if(/(iPhone|iPad|iPod)/.test(a)){return"iOS"}else if(/Android/.test(a)){return"Android"}else if(/(BlackBerry|PlayBook|BB10)/i.test(a)){return"BlackBerry"}else if(/Mac/i.test(a)){return"Mac OS X"}else if(/Linux/.test(a)){return"Linux"}else if(/CrOS/.test(a)){return"Chrome OS"}else{return""}},device:function(user_agent){if(/Windows Phone/i.test(user_agent)||/WPDesktop/.test(user_agent)){return"Windows Phone"}else if(/iPad/.test(user_agent)){return"iPad"}else if(/iPod/.test(user_agent)){return"iPod Touch"}else if(/iPhone/.test(user_agent)){return"iPhone"}else if(/(BlackBerry|PlayBook|BB10)/i.test(user_agent)){return"BlackBerry"}else if(/Android/.test(user_agent)){return"Android"}else{return""}},referringDomain:function(referrer){var split=referrer.split("/");if(split.length>=3){return split[2]}return""},properties:function(){return _.extend(_.strip_empty_properties({$os:_.info.os(),$browser:_.info.browser(userAgent,navigator$1.vendor,windowOpera),$referrer:document$1.referrer,$referring_domain:_.info.referringDomain(document$1.referrer),$device:_.info.device(userAgent)}),{$current_url:window$1.location.href,$browser_version:_.info.browserVersion(userAgent,navigator$1.vendor,windowOpera),$screen_height:screen.height,$screen_width:screen.width,mp_lib:"web",$lib_version:Config.LIB_VERSION,time:_.timestamp()/1e3})},people_properties:function(){return _.extend(_.strip_empty_properties({$os:_.info.os(),$browser:_.info.browser(userAgent,navigator$1.vendor,windowOpera)}),{$browser_version:_.info.browserVersion(userAgent,navigator$1.vendor,windowOpera)})},pageviewInfo:function(page){return _.strip_empty_properties({mp_page:page,mp_referrer:document$1.referrer,mp_browser:_.info.browser(userAgent,navigator$1.vendor,windowOpera),mp_platform:_.info.os()})}};_["toArray"]=_.toArray;_["isObject"]=_.isObject;_["JSONEncode"]=_.JSONEncode;_["JSONDecode"]=_.JSONDecode;_["isBlockedUA"]=_.isBlockedUA;_["isEmptyObject"]=_.isEmptyObject;_["info"]=_.info;_["info"]["device"]=_.info.device;_["info"]["browser"]=_.info.browser;_["info"]["properties"]=_.info.properties;function getClassName(el){switch(typeof el.className){case"string":return el.className;case"object":return el.className.baseVal||el.getAttribute("class")||"";default:return""}}function getSafeText(el){var elText="";if(shouldTrackElement(el)&&el.childNodes&&el.childNodes.length){_.each(el.childNodes,(function(child){if(isTextNode(child)&&child.textContent){elText+=_.trim(child.textContent).split(/(\s+)/).filter(shouldTrackValue).join("").replace(/[\r\n]/g," ").replace(/[ ]+/g," ").substring(0,255)}}))}return _.trim(elText)}function isElementNode(el){return el&&el.nodeType===1}function isTag(el,tag){return el&&el.tagName&&el.tagName.toLowerCase()===tag.toLowerCase()}function isTextNode(el){return el&&el.nodeType===3}function shouldTrackDomEvent(el,event){if(!el||isTag(el,"html")||!isElementNode(el)){return false}var tag=el.tagName.toLowerCase();switch(tag){case"html":return false;case"form":return event.type==="submit";case"input":if(["button","submit"].indexOf(el.getAttribute("type"))===-1){return event.type==="change"}else{return event.type==="click"}case"select":case"textarea":return event.type==="change";default:return event.type==="click"}}function shouldTrackElement(el){for(var curEl=el;curEl.parentNode&&!isTag(curEl,"body");curEl=curEl.parentNode){var classes=getClassName(curEl).split(" ");if(_.includes(classes,"mp-sensitive")||_.includes(classes,"mp-no-track")){return false}}if(_.includes(getClassName(el).split(" "),"mp-include")){return true}if(isTag(el,"input")||isTag(el,"select")||isTag(el,"textarea")||el.getAttribute("contenteditable")==="true"){return false}var type=el.type||"";if(typeof type==="string"){switch(type.toLowerCase()){case"hidden":return false;case"password":return false}}var name=el.name||el.id||"";if(typeof name==="string"){var sensitiveNameRegex=/^cc|cardnum|ccnum|creditcard|csc|cvc|cvv|exp|pass|pwd|routing|seccode|securitycode|securitynum|socialsec|socsec|ssn/i;if(sensitiveNameRegex.test(name.replace(/[^a-zA-Z0-9]/g,""))){return false}}return true}function shouldTrackValue(value){if(value===null||_.isUndefined(value)){return false}if(typeof value==="string"){value=_.trim(value);var ccRegex=/^(?:(4[0-9]{12}(?:[0-9]{3})?)|(5[1-5][0-9]{14})|(6(?:011|5[0-9]{2})[0-9]{12})|(3[47][0-9]{13})|(3(?:0[0-5]|[68][0-9])[0-9]{11})|((?:2131|1800|35[0-9]{3})[0-9]{11}))$/;if(ccRegex.test((value||"").replace(/[- ]/g,""))){return false}var ssnRegex=/(^\d{3}-?\d{2}-?\d{4}$)/;if(ssnRegex.test(value)){return false}}return true}var autotrack={_initializedTokens:[],_previousElementSibling:function(el){if(el.previousElementSibling){return el.previousElementSibling}else{do{el=el.previousSibling}while(el&&!isElementNode(el));return el}},_loadScript:function(scriptUrlToLoad,callback){var scriptTag=document.createElement("script");scriptTag.type="text/javascript";scriptTag.src=scriptUrlToLoad;scriptTag.onload=callback;var scripts=document.getElementsByTagName("script");if(scripts.length>0){scripts[0].parentNode.insertBefore(scriptTag,scripts[0])}else{document.body.appendChild(scriptTag)}},_getPropertiesFromElement:function(elem){var props={classes:getClassName(elem).split(" "),tag_name:elem.tagName.toLowerCase()};if(shouldTrackElement(elem)){_.each(elem.attributes,(function(attr){if(shouldTrackValue(attr.value)){props["attr__"+attr.name]=attr.value}}))}var nthChild=1;var nthOfType=1;var currentElem=elem;while(currentElem=this._previousElementSibling(currentElem)){nthChild++;if(currentElem.tagName===elem.tagName){nthOfType++}}props["nth_child"]=nthChild;props["nth_of_type"]=nthOfType;return props},_getDefaultProperties:function(eventType){return{$event_type:eventType,$ce_version:1,$host:window.location.host,$pathname:window.location.pathname}},_extractCustomPropertyValue:function(customProperty){var propValues=[];_.each(document.querySelectorAll(customProperty["css_selector"]),(function(matchedElem){var value;if(["input","select"].indexOf(matchedElem.tagName.toLowerCase())>-1){value=matchedElem["value"]}else if(matchedElem["textContent"]){value=matchedElem["textContent"]}if(shouldTrackValue(value)){propValues.push(value)}}));return propValues.join(", ")},_getCustomProperties:function(targetElementList){var props={};_.each(this._customProperties,(function(customProperty){_.each(customProperty["event_selectors"],(function(eventSelector){var eventElements=document.querySelectorAll(eventSelector);_.each(eventElements,(function(eventElement){if(_.includes(targetElementList,eventElement)&&shouldTrackElement(eventElement)){props[customProperty["name"]]=this._extractCustomPropertyValue(customProperty)}}),this)}),this)}),this);return props},_getEventTarget:function(e){if(typeof e.target==="undefined"){return e.srcElement}else{return e.target}},_trackEvent:function(e,instance){var target=this._getEventTarget(e);if(isTextNode(target)){target=target.parentNode}if(shouldTrackDomEvent(target,e)){var targetElementList=[target];var curEl=target;while(curEl.parentNode&&!isTag(curEl,"body")){targetElementList.push(curEl.parentNode);curEl=curEl.parentNode}var elementsJson=[];var href,explicitNoTrack=false;_.each(targetElementList,(function(el){var shouldTrackEl=shouldTrackElement(el);if(el.tagName.toLowerCase()==="a"){href=el.getAttribute("href");href=shouldTrackEl&&shouldTrackValue(href)&&href}var classes=getClassName(el).split(" ");if(_.includes(classes,"mp-no-track")){explicitNoTrack=true}elementsJson.push(this._getPropertiesFromElement(el))}),this);if(explicitNoTrack){return false}var elementText;var safeElementText=getSafeText(target);if(safeElementText&&safeElementText.length){elementText=safeElementText}var props=_.extend(this._getDefaultProperties(e.type),{$elements:elementsJson,$el_attr__href:href,$el_text:elementText},this._getCustomProperties(targetElementList));instance.track("$web_event",props);return true}},_navigate:function(href){window.location.href=href},_addDomEventHandlers:function(instance){var handler=_.bind((function(e){e=e||window.event;this._trackEvent(e,instance)}),this);_.register_event(document,"submit",handler,false,true);_.register_event(document,"change",handler,false,true);_.register_event(document,"click",handler,false,true)},_customProperties:{},init:function(instance){if(!(document&&document.body)){console.log("document not ready yet, trying again in 500 milliseconds...");var that=this;setTimeout((function(){that.init(instance)}),500);return}var token=instance.get_config("token");if(this._initializedTokens.indexOf(token)>-1){console.log('autotrack already initialized for token "'+token+'"');return}this._initializedTokens.push(token);if(!this._maybeLoadEditor(instance)){var parseDecideResponse=_.bind((function(response){if(response&&response["config"]&&response["config"]["enable_collect_everything"]===true){if(response["custom_properties"]){this._customProperties=response["custom_properties"]}instance.track("$web_event",_.extend({$title:document.title},this._getDefaultProperties("pageview")));this._addDomEventHandlers(instance)}else{instance["__autotrack_enabled"]=false}}),this);instance._send_request(instance.get_config("api_host")+"/decide/",{verbose:true,version:"1",lib:"web",token},instance._prepare_callback(parseDecideResponse))}},_editorParamsFromHash:function(instance,hash){var editorParams;try{var state=_.getHashParam(hash,"state");state=JSON.parse(decodeURIComponent(state));var expiresInSeconds=_.getHashParam(hash,"expires_in");editorParams={accessToken:_.getHashParam(hash,"access_token"),accessTokenExpiresAt:(new Date).getTime()+Number(expiresInSeconds)*1e3,bookmarkletMode:!!state["bookmarkletMode"],projectId:state["projectId"],projectOwnerId:state["projectOwnerId"],projectToken:state["token"],readOnly:state["readOnly"],userFlags:state["userFlags"],userId:state["userId"]};window.sessionStorage.setItem("editorParams",JSON.stringify(editorParams));if(state["desiredHash"]){window.location.hash=state["desiredHash"]}else if(window.history){history.replaceState("",document.title,window.location.pathname+window.location.search)}else{window.location.hash=""}}catch(e){console.error("Unable to parse data from hash",e)}return editorParams},_maybeLoadEditor:function(instance){try{var parseFromUrl=false;if(_.getHashParam(window.location.hash,"state")){var state=_.getHashParam(window.location.hash,"state");state=JSON.parse(decodeURIComponent(state));parseFromUrl=state["action"]==="mpeditor"}var parseFromStorage=!!window.sessionStorage.getItem("_mpcehash");var editorParams;if(parseFromUrl){editorParams=this._editorParamsFromHash(instance,window.location.hash)}else if(parseFromStorage){editorParams=this._editorParamsFromHash(instance,window.sessionStorage.getItem("_mpcehash"));window.sessionStorage.removeItem("_mpcehash")}else{editorParams=JSON.parse(window.sessionStorage.getItem("editorParams")||"{}")}if(editorParams["projectToken"]&&instance.get_config("token")===editorParams["projectToken"]){this._loadEditor(instance,editorParams);return true}else{return false}}catch(e){return false}},_loadEditor:function(instance,editorParams){if(!window["_mpEditorLoaded"]){window["_mpEditorLoaded"]=true;var editorUrl=instance.get_config("app_host")+"/js-bundle/reports/collect-everything/editor.js?_ts="+(new Date).getTime();this._loadScript(editorUrl,(function(){window["mp_load_editor"](editorParams)}));return true}return false},enabledForProject:function(token,numBuckets,numEnabledBuckets){numBuckets=!_.isUndefined(numBuckets)?numBuckets:10;numEnabledBuckets=!_.isUndefined(numEnabledBuckets)?numEnabledBuckets:10;var charCodeSum=0;for(var i=0;i<token.length;i++){charCodeSum+=token.charCodeAt(i)}return charCodeSum%numBuckets<numEnabledBuckets},isBrowserSupported:function(){return _.isFunction(document.querySelectorAll)}};_.bind_instance_methods(autotrack);_.safewrap_instance_methods(autotrack);var DomTracker=function(){};DomTracker.prototype.create_properties=function(){};DomTracker.prototype.event_handler=function(){};DomTracker.prototype.after_track_handler=function(){};DomTracker.prototype.init=function(mixpanel_instance){this.mp=mixpanel_instance;return this};DomTracker.prototype.track=function(query,event_name,properties,user_callback){var that=this;var elements=_.dom_query(query);if(elements.length===0){console$1.error("The DOM query ("+query+") returned 0 elements");return}_.each(elements,(function(element){_.register_event(element,this.override_event,(function(e){var options={};var props=that.create_properties(properties,this);var timeout=that.mp.get_config("track_links_timeout");that.event_handler(e,this,options);window.setTimeout(that.track_callback(user_callback,props,options,true),timeout);that.mp.track(event_name,props,that.track_callback(user_callback,props,options))}))}),this);return true};DomTracker.prototype.track_callback=function(user_callback,props,options,timeout_occured){timeout_occured=timeout_occured||false;var that=this;return function(){if(options.callback_fired){return}options.callback_fired=true;if(user_callback&&user_callback(timeout_occured,props)===false){return}that.after_track_handler(props,options,timeout_occured)}};DomTracker.prototype.create_properties=function(properties,element){var props;if(typeof properties==="function"){props=properties(element)}else{props=_.extend({},properties)}return props};var LinkTracker=function(){this.override_event="click"};_.inherit(LinkTracker,DomTracker);LinkTracker.prototype.create_properties=function(properties,element){var props=LinkTracker.superclass.create_properties.apply(this,arguments);if(element.href){props["url"]=element.href}return props};LinkTracker.prototype.event_handler=function(evt,element,options){options.new_tab=evt.which===2||evt.metaKey||evt.ctrlKey||element.target==="_blank";options.href=element.href;if(!options.new_tab){evt.preventDefault()}};LinkTracker.prototype.after_track_handler=function(props,options){if(options.new_tab){return}setTimeout((function(){window.location=options.href}),0)};var FormTracker=function(){this.override_event="submit"};_.inherit(FormTracker,DomTracker);FormTracker.prototype.event_handler=function(evt,element,options){options.element=element;evt.preventDefault()};FormTracker.prototype.after_track_handler=function(props,options){setTimeout((function(){options.element.submit()}),0)};var GDPR_DEFAULT_PERSISTENCE_PREFIX="__mp_opt_in_out_";function optIn(token,options){_optInOut(true,token,options)}function optOut(token,options){_optInOut(false,token,options)}function hasOptedIn(token,options){return _getStorageValue(token,options)==="1"}function hasOptedOut(token,options){if(_hasDoNotTrackFlagOn(options)){return true}return _getStorageValue(token,options)==="0"}function addOptOutCheckMixpanelLib(method){return _addOptOutCheck(method,(function(name){return this.get_config(name)}))}function addOptOutCheckMixpanelPeople(method){return _addOptOutCheck(method,(function(name){return this._get_config(name)}))}function addOptOutCheckMixpanelGroup(method){return _addOptOutCheck(method,(function(name){return this._get_config(name)}))}function clearOptInOut(token,options){options=options||{};_getStorage(options).remove(_getStorageKey(token,options),!!options.crossSubdomainCookie)}function _getStorage(options){options=options||{};return options.persistenceType==="localStorage"?_.localStorage:_.cookie}function _getStorageKey(token,options){options=options||{};return(options.persistencePrefix||GDPR_DEFAULT_PERSISTENCE_PREFIX)+token}function _getStorageValue(token,options){return _getStorage(options).get(_getStorageKey(token,options))}function _hasDoNotTrackFlagOn(options){var win=options&&options.window||window$1;var nav=win["navigator"]||{};var hasDntOn=false;_.each([nav["doNotTrack"],nav["msDoNotTrack"],win["doNotTrack"]],(function(dntValue){if(_.includes([true,1,"1","yes"],dntValue)){hasDntOn=true}}));return hasDntOn}function _optInOut(optValue,token,options){if(!_.isString(token)||!token.length){console.error("gdpr."+(optValue?"optIn":"optOut")+" called with an invalid token");return}options=options||{};_getStorage(options).set(_getStorageKey(token,options),optValue?1:0,_.isNumber(options.cookieExpiration)?options.cookieExpiration:null,!!options.crossSubdomainCookie,!!options.secureCookie);if(options.track&&optValue){options.track(options.trackEventName||"$opt_in",options.trackProperties)}}function _addOptOutCheck(method,getConfigValue){return function(){var optedOut=false;try{var token=getConfigValue.call(this,"token");var persistenceType=getConfigValue.call(this,"opt_out_tracking_persistence_type");var persistencePrefix=getConfigValue.call(this,"opt_out_tracking_cookie_prefix");var win=getConfigValue.call(this,"window");if(token){optedOut=hasOptedOut(token,{persistenceType,persistencePrefix,window:win})}}catch(err){console.error("Unexpected error when checking tracking opt-out status: "+err)}if(!optedOut){return method.apply(this,arguments)}var callback=arguments[arguments.length-1];if(typeof callback==="function"){callback(0)}return}}var SET_ACTION="$set";var SET_ONCE_ACTION="$set_once";var UNSET_ACTION="$unset";var ADD_ACTION="$add";var APPEND_ACTION="$append";var UNION_ACTION="$union";var REMOVE_ACTION="$remove";var DELETE_ACTION="$delete";var apiActions={set_action:function(prop,to){var data={};var $set={};if(_.isObject(prop)){_.each(prop,(function(v,k){if(!this._is_reserved_property(k)){$set[k]=v}}),this)}else{$set[prop]=to}data[SET_ACTION]=$set;return data},unset_action:function(prop){var data={};var $unset=[];if(!_.isArray(prop)){prop=[prop]}_.each(prop,(function(k){if(!this._is_reserved_property(k)){$unset.push(k)}}),this);data[UNSET_ACTION]=$unset;return data},set_once_action:function(prop,to){var data={};var $set_once={};if(_.isObject(prop)){_.each(prop,(function(v,k){if(!this._is_reserved_property(k)){$set_once[k]=v}}),this)}else{$set_once[prop]=to}data[SET_ONCE_ACTION]=$set_once;return data},union_action:function(list_name,values){var data={};var $union={};if(_.isObject(list_name)){_.each(list_name,(function(v,k){if(!this._is_reserved_property(k)){$union[k]=_.isArray(v)?v:[v]}}),this)}else{$union[list_name]=_.isArray(values)?values:[values]}data[UNION_ACTION]=$union;return data},append_action:function(list_name,value){var data={};var $append={};if(_.isObject(list_name)){_.each(list_name,(function(v,k){if(!this._is_reserved_property(k)){$append[k]=v}}),this)}else{$append[list_name]=value}data[APPEND_ACTION]=$append;return data},remove_action:function(list_name,value){var data={};var $remove={};if(_.isObject(list_name)){_.each(list_name,(function(v,k){if(!this._is_reserved_property(k)){$remove[k]=v}}),this)}else{$remove[list_name]=value}data[REMOVE_ACTION]=$remove;return data},delete_action:function(){var data={};data[DELETE_ACTION]="";return data}};var MixpanelGroup=function(){};_.extend(MixpanelGroup.prototype,apiActions);MixpanelGroup.prototype._init=function(mixpanel_instance,group_key,group_id){this._mixpanel=mixpanel_instance;this._group_key=group_key;this._group_id=group_id};MixpanelGroup.prototype.set=addOptOutCheckMixpanelGroup((function(prop,to,callback){var data=this.set_action(prop,to);if(_.isObject(prop)){callback=to}return this._send_request(data,callback)}));MixpanelGroup.prototype.set_once=addOptOutCheckMixpanelGroup((function(prop,to,callback){var data=this.set_once_action(prop,to);if(_.isObject(prop)){callback=to}return this._send_request(data,callback)}));MixpanelGroup.prototype.unset=addOptOutCheckMixpanelGroup((function(prop,callback){var data=this.unset_action(prop);return this._send_request(data,callback)}));MixpanelGroup.prototype.union=addOptOutCheckMixpanelGroup((function(list_name,values,callback){if(_.isObject(list_name)){callback=values}var data=this.union_action(list_name,values);return this._send_request(data,callback)}));MixpanelGroup.prototype["delete"]=addOptOutCheckMixpanelGroup((function(callback){var data=this.delete_action();return this._send_request(data,callback)}));MixpanelGroup.prototype.remove=addOptOutCheckMixpanelGroup((function(list_name,value,callback){var data=this.remove_action(list_name,value);return this._send_request(data,callback)}));MixpanelGroup.prototype._send_request=function(data,callback){data["$group_key"]=this._group_key;data["$group_id"]=this._group_id;data["$token"]=this._get_config("token");var date_encoded_data=_.encodeDates(data);var truncated_data=_.truncate(date_encoded_data,255);var json_data=_.JSONEncode(date_encoded_data);var encoded_data=_.base64Encode(json_data);console$1.log(data);this._mixpanel._send_request(this._mixpanel.get_config("api_host")+"/groups/",{data:encoded_data},this._mixpanel._prepare_callback(callback,truncated_data));return truncated_data};MixpanelGroup.prototype._is_reserved_property=function(prop){return prop==="$group_key"||prop==="$group_id"};MixpanelGroup.prototype._get_config=function(conf){return this._mixpanel.get_config(conf)};MixpanelGroup.prototype.toString=function(){return this._mixpanel.toString()+".group."+this._group_key+"."+this._group_id};MixpanelGroup.prototype["remove"]=MixpanelGroup.prototype.remove;MixpanelGroup.prototype["set"]=MixpanelGroup.prototype.set;MixpanelGroup.prototype["set_once"]=MixpanelGroup.prototype.set_once;MixpanelGroup.prototype["union"]=MixpanelGroup.prototype.union;MixpanelGroup.prototype["unset"]=MixpanelGroup.prototype.unset;MixpanelGroup.prototype["toString"]=MixpanelGroup.prototype.toString;var SET_QUEUE_KEY="__mps";var SET_ONCE_QUEUE_KEY="__mpso";var UNSET_QUEUE_KEY="__mpus";var ADD_QUEUE_KEY="__mpa";var APPEND_QUEUE_KEY="__mpap";var REMOVE_QUEUE_KEY="__mpr";var UNION_QUEUE_KEY="__mpu";var PEOPLE_DISTINCT_ID_KEY="$people_distinct_id";var ALIAS_ID_KEY="__alias";var CAMPAIGN_IDS_KEY="__cmpns";var EVENT_TIMERS_KEY="__timers";var RESERVED_PROPERTIES=[SET_QUEUE_KEY,SET_ONCE_QUEUE_KEY,UNSET_QUEUE_KEY,ADD_QUEUE_KEY,APPEND_QUEUE_KEY,REMOVE_QUEUE_KEY,UNION_QUEUE_KEY,PEOPLE_DISTINCT_ID_KEY,ALIAS_ID_KEY,CAMPAIGN_IDS_KEY,EVENT_TIMERS_KEY];var MixpanelPersistence=function(config){this["props"]={};this.campaign_params_saved=false;if(config["persistence_name"]){this.name="mp_"+config["persistence_name"]}else{this.name="mp_"+config["token"]+"_mixpanel"}var storage_type=config["persistence"];if(storage_type!=="cookie"&&storage_type!=="localStorage"){console$1.critical("Unknown persistence type "+storage_type+"; falling back to cookie");storage_type=config["persistence"]="cookie"}if(storage_type==="localStorage"&&_.localStorage.is_supported()){this.storage=_.localStorage}else{this.storage=_.cookie}this.load();this.update_config(config);this.upgrade(config);this.save()};MixpanelPersistence.prototype.properties=function(){var p={};_.each(this["props"],(function(v,k){if(!_.include(RESERVED_PROPERTIES,k)){p[k]=v}}));return p};MixpanelPersistence.prototype.load=function(){if(this.disabled){return}var entry=this.storage.parse(this.name);if(entry){this["props"]=_.extend({},entry)}};MixpanelPersistence.prototype.upgrade=function(config){var upgrade_from_old_lib=config["upgrade"],old_cookie_name,old_cookie;if(upgrade_from_old_lib){old_cookie_name="mp_super_properties";if(typeof upgrade_from_old_lib==="string"){old_cookie_name=upgrade_from_old_lib}old_cookie=this.storage.parse(old_cookie_name);this.storage.remove(old_cookie_name);this.storage.remove(old_cookie_name,true);if(old_cookie){this["props"]=_.extend(this["props"],old_cookie["all"],old_cookie["events"])}}if(!config["cookie_name"]&&config["name"]!=="mixpanel"){old_cookie_name="mp_"+config["token"]+"_"+config["name"];old_cookie=this.storage.parse(old_cookie_name);if(old_cookie){this.storage.remove(old_cookie_name);this.storage.remove(old_cookie_name,true);this.register_once(old_cookie)}}if(this.storage===_.localStorage){old_cookie=_.cookie.parse(this.name);_.cookie.remove(this.name);_.cookie.remove(this.name,true);if(old_cookie){this.register_once(old_cookie)}}};MixpanelPersistence.prototype.save=function(){if(this.disabled){return}this._expire_notification_campaigns();this.storage.set(this.name,_.JSONEncode(this["props"]),this.expire_days,this.cross_subdomain,this.secure)};MixpanelPersistence.prototype.remove=function(){this.storage.remove(this.name,false);this.storage.remove(this.name,true)};MixpanelPersistence.prototype.clear=function(){this.remove();this["props"]={}};MixpanelPersistence.prototype.register_once=function(props,default_value,days){if(_.isObject(props)){if(typeof default_value==="undefined"){default_value="None"}this.expire_days=typeof days==="undefined"?this.default_expiry:days;_.each(props,(function(val,prop){if(!this["props"].hasOwnProperty(prop)||this["props"][prop]===default_value){this["props"][prop]=val}}),this);this.save();return true}return false};MixpanelPersistence.prototype.register=function(props,days){if(_.isObject(props)){this.expire_days=typeof days==="undefined"?this.default_expiry:days;_.extend(this["props"],props);this.save();return true}return false};MixpanelPersistence.prototype.unregister=function(prop){if(prop in this["props"]){delete this["props"][prop];this.save()}};MixpanelPersistence.prototype._expire_notification_campaigns=_.safewrap((function(){var campaigns_shown=this["props"][CAMPAIGN_IDS_KEY],EXPIRY_TIME=Config.DEBUG?60*1e3:60*60*1e3;if(!campaigns_shown){return}for(var campaign_id in campaigns_shown){if(1*new Date-campaigns_shown[campaign_id]>EXPIRY_TIME){delete campaigns_shown[campaign_id]}}if(_.isEmptyObject(campaigns_shown)){delete this["props"][CAMPAIGN_IDS_KEY]}}));MixpanelPersistence.prototype.update_campaign_params=function(){if(!this.campaign_params_saved){this.register_once(_.info.campaignParams());this.campaign_params_saved=true}};MixpanelPersistence.prototype.update_search_keyword=function(referrer){this.register(_.info.searchInfo(referrer))};MixpanelPersistence.prototype.update_referrer_info=function(referrer){this.register_once({$initial_referrer:referrer||"$direct",$initial_referring_domain:_.info.referringDomain(referrer)||"$direct"},"")};MixpanelPersistence.prototype.get_referrer_info=function(){return _.strip_empty_properties({$initial_referrer:this["props"]["$initial_referrer"],$initial_referring_domain:this["props"]["$initial_referring_domain"]})};MixpanelPersistence.prototype.safe_merge=function(props){_.each(this["props"],(function(val,prop){if(!(prop in props)){props[prop]=val}}));return props};MixpanelPersistence.prototype.update_config=function(config){this.default_expiry=this.expire_days=config["cookie_expiration"];this.set_disabled(config["disable_persistence"]);this.set_cross_subdomain(config["cross_subdomain_cookie"]);this.set_secure(config["secure_cookie"])};MixpanelPersistence.prototype.set_disabled=function(disabled){this.disabled=disabled;if(this.disabled){this.remove()}else{this.save()}};MixpanelPersistence.prototype.set_cross_subdomain=function(cross_subdomain){if(cross_subdomain!==this.cross_subdomain){this.cross_subdomain=cross_subdomain;this.remove();this.save()}};MixpanelPersistence.prototype.get_cross_subdomain=function(){return this.cross_subdomain};MixpanelPersistence.prototype.set_secure=function(secure){if(secure!==this.secure){this.secure=secure?true:false;this.remove();this.save()}};MixpanelPersistence.prototype._add_to_people_queue=function(queue,data){var q_key=this._get_queue_key(queue),q_data=data[queue],set_q=this._get_or_create_queue(SET_ACTION),set_once_q=this._get_or_create_queue(SET_ONCE_ACTION),unset_q=this._get_or_create_queue(UNSET_ACTION),add_q=this._get_or_create_queue(ADD_ACTION),union_q=this._get_or_create_queue(UNION_ACTION),remove_q=this._get_or_create_queue(REMOVE_ACTION,[]),append_q=this._get_or_create_queue(APPEND_ACTION,[]);if(q_key===SET_QUEUE_KEY){_.extend(set_q,q_data);this._pop_from_people_queue(ADD_ACTION,q_data);this._pop_from_people_queue(UNION_ACTION,q_data);this._pop_from_people_queue(UNSET_ACTION,q_data)}else if(q_key===SET_ONCE_QUEUE_KEY){_.each(q_data,(function(v,k){if(!(k in set_once_q)){set_once_q[k]=v}}));this._pop_from_people_queue(UNSET_ACTION,q_data)}else if(q_key===UNSET_QUEUE_KEY){_.each(q_data,(function(prop){_.each([set_q,set_once_q,add_q,union_q],(function(enqueued_obj){if(prop in enqueued_obj){delete enqueued_obj[prop]}}));_.each(append_q,(function(append_obj){if(prop in append_obj){delete append_obj[prop]}}));unset_q[prop]=true}))}else if(q_key===ADD_QUEUE_KEY){_.each(q_data,(function(v,k){if(k in set_q){set_q[k]+=v}else{if(!(k in add_q)){add_q[k]=0}add_q[k]+=v}}),this);this._pop_from_people_queue(UNSET_ACTION,q_data)}else if(q_key===UNION_QUEUE_KEY){_.each(q_data,(function(v,k){if(_.isArray(v)){if(!(k in union_q)){union_q[k]=[]}union_q[k]=union_q[k].concat(v)}}));this._pop_from_people_queue(UNSET_ACTION,q_data)}else if(q_key===REMOVE_QUEUE_KEY){remove_q.push(q_data);this._pop_from_people_queue(APPEND_ACTION,q_data)}else if(q_key===APPEND_QUEUE_KEY){append_q.push(q_data);this._pop_from_people_queue(UNSET_ACTION,q_data)}console$1.log("MIXPANEL PEOPLE REQUEST (QUEUED, PENDING IDENTIFY):");console$1.log(data);this.save()};MixpanelPersistence.prototype._pop_from_people_queue=function(queue,data){var q=this._get_queue(queue);if(!_.isUndefined(q)){_.each(data,(function(v,k){if(queue===APPEND_ACTION||queue===REMOVE_ACTION){_.each(q,(function(queued_action){if(queued_action[k]===v){delete queued_action[k]}}))}else{delete q[k]}}),this);this.save()}};MixpanelPersistence.prototype._get_queue_key=function(queue){if(queue===SET_ACTION){return SET_QUEUE_KEY}else if(queue===SET_ONCE_ACTION){return SET_ONCE_QUEUE_KEY}else if(queue===UNSET_ACTION){return UNSET_QUEUE_KEY}else if(queue===ADD_ACTION){return ADD_QUEUE_KEY}else if(queue===APPEND_ACTION){return APPEND_QUEUE_KEY}else if(queue===REMOVE_ACTION){return REMOVE_QUEUE_KEY}else if(queue===UNION_ACTION){return UNION_QUEUE_KEY}else{console$1.error("Invalid queue:",queue)}};MixpanelPersistence.prototype._get_queue=function(queue){return this["props"][this._get_queue_key(queue)]};MixpanelPersistence.prototype._get_or_create_queue=function(queue,default_val){var key=this._get_queue_key(queue);default_val=_.isUndefined(default_val)?{}:default_val;return this["props"][key]||(this["props"][key]=default_val)};MixpanelPersistence.prototype.set_event_timer=function(event_name,timestamp){var timers=this["props"][EVENT_TIMERS_KEY]||{};timers[event_name]=timestamp;this["props"][EVENT_TIMERS_KEY]=timers;this.save()};MixpanelPersistence.prototype.remove_event_timer=function(event_name){var timers=this["props"][EVENT_TIMERS_KEY]||{};var timestamp=timers[event_name];if(!_.isUndefined(timestamp)){delete this["props"][EVENT_TIMERS_KEY][event_name];this.save()}return timestamp};var OPERATOR_KEY="operator";var PROPERTY_KEY="property";var WINDOW_KEY="window";var UNIT_KEY="unit";var VALUE_KEY="value";var HOUR_KEY="hour";var DAY_KEY="day";var WEEK_KEY="week";var MONTH_KEY="month";var EVENT_PROPERTY="event";var LITERAL_PROPERTY="literal";var AND_OPERATOR="and";var OR_OPERATOR="or";var IN_OPERATOR="in";var NOT_IN_OPERATOR="not in";var PLUS_OPERATOR="+";var MINUS_OPERATOR="-";var MUL_OPERATOR="*";var DIV_OPERATOR="/";var MOD_OPERATOR="%";var EQUALS_OPERATOR="==";var NOT_EQUALS_OPERATOR="!=";var GREATER_OPERATOR=">";var LESS_OPERATOR="<";var GREATER_EQUAL_OPERATOR=">=";var LESS_EQUAL_OPERATOR="<=";var BOOLEAN_OPERATOR="boolean";var DATETIME_OPERATOR="datetime";var LIST_OPERATOR="list";var NUMBER_OPERATOR="number";var STRING_OPERATOR="string";var NOT_OPERATOR="not";var DEFINED_OPERATOR="defined";var NOT_DEFINED_OPERATOR="not defined";var NOW_LITERAL="now";function toNumber(value){if(value===null){return null}switch(typeof value){case"object":if(_.isDate(value)&&value.getTime()>=0){return value.getTime()}return null;case"boolean":return Number(value);case"number":return value;case"string":value=Number(value);if(!isNaN(value)){return value}return 0}return null}function evaluateNumber(op,properties){if(!op["operator"]||op["operator"]!==NUMBER_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid cast operator: number "+op}return toNumber(evaluateSelector(op["children"][0],properties))}function toBoolean(value){if(value===null){return false}switch(typeof value){case"boolean":return value;case"number":return value!==0;case"string":return value.length>0;case"object":if(_.isArray(value)&&value.length>0){return true}if(_.isDate(value)&&value.getTime()>0){return true}if(_.isObject(value)&&!_.isEmptyObject(value)){return true}return false}return false}function evaluateBoolean(op,properties){if(!op["operator"]||op["operator"]!==BOOLEAN_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid cast operator: boolean "+op}return toBoolean(evaluateSelector(op["children"][0],properties))}function evaluateDateTime(op,properties){if(!op["operator"]||op["operator"]!==DATETIME_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid cast operator: datetime "+op}var v=evaluateSelector(op["children"][0],properties);if(v===null){return null}switch(typeof v){case"number":case"string":var d=new Date(v);if(isNaN(d.getTime())){return null}return d;case"object":if(_.isDate(v)){return v}}return null}function evaluateList(op,properties){if(!op["operator"]||op["operator"]!==LIST_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid cast operator: list "+op}var v=evaluateSelector(op["children"][0],properties);if(v===null){return null}if(_.isArray(v)){return v}return null}function evaluateString(op,properties){if(!op["operator"]||op["operator"]!==STRING_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid cast operator: string "+op}var v=evaluateSelector(op["children"][0],properties);switch(typeof v){case"object":if(_.isDate(v)){return v.toJSON()}return JSON.stringify(v)}return String(v)}function evaluateAnd(op,properties){if(!op["operator"]||op["operator"]!==AND_OPERATOR||!op["children"]||op["children"].length!==2){throw"Invalid operator: AND "+op}return toBoolean(evaluateSelector(op["children"][0],properties))&&toBoolean(evaluateSelector(op["children"][1],properties))}function evaluateOr(op,properties){if(!op["operator"]||op["operator"]!==OR_OPERATOR||!op["children"]||op["children"].length!==2){throw"Invalid operator: OR "+op}return toBoolean(evaluateSelector(op["children"][0],properties))||toBoolean(evaluateSelector(op["children"][1],properties))}function evaluateIn(op,properties){if(!op["operator"]||[IN_OPERATOR,NOT_IN_OPERATOR].indexOf(op["operator"])===-1||!op["children"]||op["children"].length!==2){throw"Invalid operator: IN/NOT IN "+op}var leftValue=evaluateSelector(op["children"][0],properties);var rightValue=evaluateSelector(op["children"][1],properties);if(!_.isArray(rightValue)&&!_.isString(rightValue)){throw"Invalid operand for operator IN: invalid type"+rightValue}var v=rightValue.indexOf(leftValue)>-1;if(op["operator"]===NOT_IN_OPERATOR){return!v}return v}function evaluatePlus(op,properties){if(!op["operator"]||op["operator"]!==PLUS_OPERATOR||!op["children"]||op["children"].length<2){throw"Invalid operator: PLUS "+op}var l=evaluateSelector(op["children"][0],properties);var r=evaluateSelector(op["children"][1],properties);if(typeof l==="number"&&typeof r==="number"){return l+r}if(typeof l==="string"&&typeof r==="string"){return l+r}return null}function evaluateArithmetic(op,properties){if(!op["operator"]||[MINUS_OPERATOR,MUL_OPERATOR,DIV_OPERATOR,MOD_OPERATOR].indexOf(op["operator"])===-1||!op["children"]||op["children"].length<2){throw"Invalid arithmetic operator "+op}var l=evaluateSelector(op["children"][0],properties);var r=evaluateSelector(op["children"][1],properties);if(typeof l==="number"&&typeof r==="number"){switch(op["operator"]){case MINUS_OPERATOR:return l-r;case MUL_OPERATOR:return l*r;case DIV_OPERATOR:if(r!==0){return l/r}return null;case MOD_OPERATOR:if(r===0){return null}if(l===0){return 0}if(l<0&&r>0||l>0&&r<0){return-(Math.floor(l/r)*r-l)}return l%r;default:throw"Unknown operator: "+op["operator"]}}return null}function _isArrayEqual(l,r){if(l===r)return true;if(l===null||r===null)return false;if(l.length!==r.length)return false;for(var i=0;i<l.length;i++){if(l[i]!==r[i]){return false}}return true}function _isEqual(l,r){if(l===null&&l===r){return true}if(typeof l===typeof r){switch(typeof l){case"number":case"string":case"boolean":return l===r;case"object":if(_.isArray(l)&&_.isArray(r)){return _isArrayEqual(l,r)}if(_.isDate(l)&&_.isDate(r)){return l.getTime()===r.getTime()}if(_.isObject(l)&&_.isObject(r)){return JSON.stringify(l)===JSON.stringify(r)}}}return false}function evaluateEquality(op,properties){if(!op["operator"]||[EQUALS_OPERATOR,NOT_EQUALS_OPERATOR].indexOf(op["operator"])===-1||!op["children"]||op["children"].length!==2){throw"Invalid equality operator "+op}var v=_isEqual(evaluateSelector(op["children"][0],properties),evaluateSelector(op["children"][1],properties));switch(op["operator"]){case EQUALS_OPERATOR:return v;case NOT_EQUALS_OPERATOR:return!v}}function evaluateComparison(op,properties){if(!op["operator"]||[GREATER_OPERATOR,GREATER_EQUAL_OPERATOR,LESS_OPERATOR,LESS_EQUAL_OPERATOR].indexOf(op["operator"])===-1||!op["children"]||op["children"].length!==2){throw"Invalid comparison operator "+op}var l=evaluateSelector(op["children"][0],properties);var r=evaluateSelector(op["children"][1],properties);if(typeof l===typeof r){if(typeof r==="number"||_.isDate(r)){l=toNumber(l);r=toNumber(r);switch(op["operator"]){case GREATER_OPERATOR:return l>r;case GREATER_EQUAL_OPERATOR:return l>=r;case LESS_OPERATOR:return l<r;case LESS_EQUAL_OPERATOR:return l<=r}}else if(typeof r==="string"){var compare=l.localeCompare(r);switch(op["operator"]){case GREATER_OPERATOR:return compare>0;case GREATER_EQUAL_OPERATOR:return compare>=0;case LESS_OPERATOR:return compare<0;case LESS_EQUAL_OPERATOR:return compare<=0}}}return null}function evaluateDefined(op,properties){if(!op["operator"]||[DEFINED_OPERATOR,NOT_DEFINED_OPERATOR].indexOf(op["operator"])===-1||!op["children"]||op["children"].length!==1){throw"Invalid defined/not defined operator: "+op}var b=evaluateSelector(op["children"][0],properties)!==null;if(op["operator"]===NOT_DEFINED_OPERATOR){return!b}return b}function evaluateNot(op,properties){if(!op["operator"]||op["operator"]!==NOT_OPERATOR||!op["children"]||op["children"].length!==1){throw"Invalid not operator: "+op}var v=evaluateSelector(op["children"][0],properties);if(v===null){return true}if(typeof v==="boolean"){return!v}return null}function evaluateOperator(op,properties){if(!op["operator"]){throw"Invalid operator: operator key missing "+op}switch(op["operator"]){case AND_OPERATOR:return evaluateAnd(op,properties);case OR_OPERATOR:return evaluateOr(op,properties);case IN_OPERATOR:case NOT_IN_OPERATOR:return evaluateIn(op,properties);case PLUS_OPERATOR:return evaluatePlus(op,properties);case MINUS_OPERATOR:case MUL_OPERATOR:case DIV_OPERATOR:case MOD_OPERATOR:return evaluateArithmetic(op,properties);case EQUALS_OPERATOR:case NOT_EQUALS_OPERATOR:return evaluateEquality(op,properties);case GREATER_OPERATOR:case LESS_OPERATOR:case GREATER_EQUAL_OPERATOR:case LESS_EQUAL_OPERATOR:return evaluateComparison(op,properties);case BOOLEAN_OPERATOR:return evaluateBoolean(op,properties);case DATETIME_OPERATOR:return evaluateDateTime(op,properties);case LIST_OPERATOR:return evaluateList(op,properties);case NUMBER_OPERATOR:return evaluateNumber(op,properties);case STRING_OPERATOR:return evaluateString(op,properties);case DEFINED_OPERATOR:case NOT_DEFINED_OPERATOR:return evaluateDefined(op,properties);case NOT_OPERATOR:return evaluateNot(op,properties)}}function evaluateWindow(value){var win=value[WINDOW_KEY];if(!win||!win[UNIT_KEY]||!win[VALUE_KEY]){throw"Invalid window: missing required keys "+JSON.stringify(value)}var out=new Date;switch(win[UNIT_KEY]){case HOUR_KEY:out.setTime(out.getTime()+win[VALUE_KEY]*-1*60*60*1e3);break;case DAY_KEY:out.setTime(out.getTime()+win[VALUE_KEY]*-1*24*60*60*1e3);break;case WEEK_KEY:out.setTime(out.getTime()+win[VALUE_KEY]*-1*7*24*60*60*1e3);break;case MONTH_KEY:out.setTime(out.getTime()+win[VALUE_KEY]*-1*30*24*60*60*1e3);break;default:throw"Invalid unit: "+win[UNIT_KEY]}return out}function evaluateOperand(op,properties){if(!op["property"]||!op["value"]){throw"Invalid operand: missing required keys "+op}switch(op["property"]){case EVENT_PROPERTY:if(properties[op["value"]]!==undefined){return properties[op["value"]]}return null;case LITERAL_PROPERTY:if(op["value"]===NOW_LITERAL){return new Date}if(typeof op["value"]==="object"){return evaluateWindow(op["value"])}return op["value"];default:throw"Invalid operand: Invalid property type "+op["property"]}}function evaluateSelector(filters,properties){if(filters[PROPERTY_KEY]){return evaluateOperand(filters,properties)}if(filters[OPERATOR_KEY]){return evaluateOperator(filters,properties)}}var MixpanelNotification=function(notif_data,mixpanel_instance){_.bind_instance_methods(this);this.mixpanel=mixpanel_instance;this.persistence=this.mixpanel["persistence"];this.resource_protocol=this.mixpanel.get_config("inapp_protocol");this.cdn_host=this.mixpanel.get_config("cdn");this.campaign_id=_.escapeHTML(notif_data["id"]);this.message_id=_.escapeHTML(notif_data["message_id"]);this.body=(_.escapeHTML(notif_data["body"])||"").replace(/\n/g,"<br/>");this.cta=_.escapeHTML(notif_data["cta"])||"Close";this.notif_type=_.escapeHTML(notif_data["type"])||"takeover";this.style=_.escapeHTML(notif_data["style"])||"light";this.title=_.escapeHTML(notif_data["title"])||"";this.video_width=MixpanelNotification.VIDEO_WIDTH;this.video_height=MixpanelNotification.VIDEO_HEIGHT;this.display_triggers=notif_data["display_triggers"]||[];this.dest_url=notif_data["cta_url"]||null;this.image_url=notif_data["image_url"]||null;this.thumb_image_url=notif_data["thumb_image_url"]||null;this.video_url=notif_data["video_url"]||null;if(this.thumb_image_url&&this.thumb_image_url.indexOf("//")===0){this.thumb_image_url=this.thumb_image_url.replace("//",this.resource_protocol)}this.clickthrough=true;if(!this.dest_url){this.dest_url="#dismiss";this.clickthrough=false}this.mini=this.notif_type==="mini";if(!this.mini){this.notif_type="takeover"}this.notif_width=!this.mini?MixpanelNotification.NOTIF_WIDTH:MixpanelNotification.NOTIF_WIDTH_MINI;this._set_client_config();this.imgs_to_preload=this._init_image_html();this._init_video()};MixpanelNotification.ANIM_TIME=200;MixpanelNotification.MARKUP_PREFIX="mixpanel-notification";MixpanelNotification.BG_OPACITY=.6;MixpanelNotification.NOTIF_TOP=25;MixpanelNotification.NOTIF_START_TOP=200;MixpanelNotification.NOTIF_WIDTH=388;MixpanelNotification.NOTIF_WIDTH_MINI=420;MixpanelNotification.NOTIF_HEIGHT_MINI=85;MixpanelNotification.THUMB_BORDER_SIZE=5;MixpanelNotification.THUMB_IMG_SIZE=60;MixpanelNotification.THUMB_OFFSET=Math.round(MixpanelNotification.THUMB_IMG_SIZE/2);MixpanelNotification.VIDEO_WIDTH=595;MixpanelNotification.VIDEO_HEIGHT=334;MixpanelNotification.prototype.show=function(){var self=this;this._set_client_config();if(!this.body_el){setTimeout((function(){self.show()}),300);return}this._init_styles();this._init_notification_el();this._preload_images(this._attach_and_animate)};MixpanelNotification.prototype.dismiss=_.safewrap((function(){if(!this.marked_as_shown){this._mark_delivery({invisible:true})}var exiting_el=this.showing_video?this._get_el("video"):this._get_notification_display_el();if(this.use_transitions){this._remove_class("bg","visible");this._add_class(exiting_el,"exiting");setTimeout(this._remove_notification_el,MixpanelNotification.ANIM_TIME)}else{var notif_attr,notif_start,notif_goal;if(this.mini){notif_attr="right";notif_start=20;notif_goal=-100}else{notif_attr="top";notif_start=MixpanelNotification.NOTIF_TOP;notif_goal=MixpanelNotification.NOTIF_START_TOP+MixpanelNotification.NOTIF_TOP}this._animate_els([{el:this._get_el("bg"),attr:"opacity",start:MixpanelNotification.BG_OPACITY,goal:0},{el:exiting_el,attr:"opacity",start:1,goal:0},{el:exiting_el,attr:notif_attr,start:notif_start,goal:notif_goal}],MixpanelNotification.ANIM_TIME,this._remove_notification_el)}}));MixpanelNotification.prototype._add_class=_.safewrap((function(el,class_name){class_name=MixpanelNotification.MARKUP_PREFIX+"-"+class_name;if(typeof el==="string"){el=this._get_el(el)}if(!el.className){el.className=class_name}else if(!~(" "+el.className+" ").indexOf(" "+class_name+" ")){el.className+=" "+class_name}}));MixpanelNotification.prototype._remove_class=_.safewrap((function(el,class_name){class_name=MixpanelNotification.MARKUP_PREFIX+"-"+class_name;if(typeof el==="string"){el=this._get_el(el)}if(el.className){el.className=(" "+el.className+" ").replace(" "+class_name+" ","").replace(/^[\s\xA0]+/,"").replace(/[\s\xA0]+$/,"")}}));MixpanelNotification.prototype._animate_els=_.safewrap((function(anims,mss,done_cb,start_time){var self=this,in_progress=false,ai,anim,cur_time=1*new Date,time_diff;start_time=start_time||cur_time;time_diff=cur_time-start_time;for(ai=0;ai<anims.length;ai++){anim=anims[ai];if(typeof anim.val==="undefined"){anim.val=anim.start}if(anim.val!==anim.goal){in_progress=true;var anim_diff=anim.goal-anim.start,anim_dir=anim.goal>=anim.start?1:-1;anim.val=anim.start+anim_diff*time_diff/mss;if(anim.attr!=="opacity"){anim.val=Math.round(anim.val)}if(anim_dir>0&&anim.val>=anim.goal||anim_dir<0&&anim.val<=anim.goal){anim.val=anim.goal}}}if(!in_progress){if(done_cb){done_cb()}return}for(ai=0;ai<anims.length;ai++){anim=anims[ai];if(anim.el){var suffix=anim.attr==="opacity"?"":"px";anim.el.style[anim.attr]=String(anim.val)+suffix}}setTimeout((function(){self._animate_els(anims,mss,done_cb,start_time)}),10)}));MixpanelNotification.prototype._attach_and_animate=_.safewrap((function(){var self=this;if(this.shown||this._get_shown_campaigns()[this.campaign_id]){return}this.shown=true;this.body_el.appendChild(this.notification_el);setTimeout((function(){var notif_el=self._get_notification_display_el();if(self.use_transitions){if(!self.mini){self._add_class("bg","visible")}self._add_class(notif_el,"visible");self._mark_as_shown()}else{var notif_attr,notif_start,notif_goal;if(self.mini){notif_attr="right";notif_start=-100;notif_goal=20}else{notif_attr="top";notif_start=MixpanelNotification.NOTIF_START_TOP+MixpanelNotification.NOTIF_TOP;notif_goal=MixpanelNotification.NOTIF_TOP}self._animate_els([{el:self._get_el("bg"),attr:"opacity",start:0,goal:MixpanelNotification.BG_OPACITY},{el:notif_el,attr:"opacity",start:0,goal:1},{el:notif_el,attr:notif_attr,start:notif_start,goal:notif_goal}],MixpanelNotification.ANIM_TIME,self._mark_as_shown)}}),100);_.register_event(self._get_el("cancel"),"click",(function(e){e.preventDefault();self.dismiss()}));var click_el=self._get_el("button")||self._get_el("mini-content");_.register_event(click_el,"click",(function(e){e.preventDefault();if(self.show_video){self._track_event("$campaign_open",{$resource_type:"video"});self._switch_to_video()}else{self.dismiss();if(self.clickthrough){var tracking_cb=null;if(self.mixpanel.get_config("inapp_link_new_window")){window.open(self.dest_url)}else{tracking_cb=function(){window.location.href=self.dest_url}}self._track_event("$campaign_open",{$resource_type:"link"},tracking_cb)}}}))}));MixpanelNotification.prototype._get_el=function(id){return document.getElementById(MixpanelNotification.MARKUP_PREFIX+"-"+id)};MixpanelNotification.prototype._get_notification_display_el=function(){return this._get_el(this.notif_type)};MixpanelNotification.prototype._get_shown_campaigns=function(){return this.persistence["props"][CAMPAIGN_IDS_KEY]||(this.persistence["props"][CAMPAIGN_IDS_KEY]={})};MixpanelNotification.prototype._matches_event_data=_.safewrap((function(event_data){var event_name=event_data["event"]||"";for(var i=0;i<this.display_triggers.length;i++){var display_trigger=this.display_triggers[i];var match_event=display_trigger["event"]||"";if(match_event==="$any_event"||event_name===display_trigger["event"]){if(display_trigger["selector"]&&!_.isEmptyObject(display_trigger["selector"])){if(evaluateSelector(display_trigger["selector"],event_data["properties"])){return true}}else{return true}}}return false}));MixpanelNotification.prototype._browser_lte=function(browser,version){return this.browser_versions[browser]&&this.browser_versions[browser]<=version};MixpanelNotification.prototype._init_image_html=function(){var imgs_to_preload=[];if(!this.mini){if(this.image_url){imgs_to_preload.push(this.image_url);this.img_html='<img id="img" src="'+this.image_url+'"/>'}else{this.img_html=""}if(this.thumb_image_url){imgs_to_preload.push(this.thumb_image_url);this.thumb_img_html='<div id="thumbborder-wrapper"><div id="thumbborder"></div></div>'+'<img id="thumbnail"'+' src="'+this.thumb_image_url+'"'+' width="'+MixpanelNotification.THUMB_IMG_SIZE+'"'+' height="'+MixpanelNotification.THUMB_IMG_SIZE+'"'+"/>"+'<div id="thumbspacer"></div>'}else{this.thumb_img_html=""}}else{this.thumb_image_url=this.thumb_image_url||this.cdn_host+"/site_media/images/icons/notifications/mini-news-dark.png";imgs_to_preload.push(this.thumb_image_url)}return imgs_to_preload};MixpanelNotification.prototype._init_notification_el=function(){var notification_html="";var video_src="";var video_html="";var cancel_html='<div id="cancel">'+'<div id="cancel-icon"></div>'+"</div>";this.notification_el=document.createElement("div");this.notification_el.id=MixpanelNotification.MARKUP_PREFIX+"-wrapper";if(!this.mini){var close_html=this.clickthrough||this.show_video?"":'<div id="button-close"></div>',play_html=this.show_video?'<div id="button-play"></div>':"";if(this._browser_lte("ie",7)){close_html="";play_html=""}notification_html='<div id="takeover">'+this.thumb_img_html+'<div id="mainbox">'+cancel_html+'<div id="content">'+this.img_html+'<div id="title">'+this.title+"</div>"+'<div id="body">'+this.body+"</div>"+'<div id="tagline">'+'<a href="http://mixpanel.com?from=inapp" target="_blank">POWERED BY MIXPANEL</a>'+"</div>"+"</div>"+'<div id="button">'+close_html+'<a id="button-link" href="'+this.dest_url+'">'+this.cta+"</a>"+play_html+"</div>"+"</div>"+"</div>"}else{notification_html='<div id="mini">'+'<div id="mainbox">'+cancel_html+'<div id="mini-content">'+'<div id="mini-icon">'+'<div id="mini-icon-img"></div>'+"</div>"+'<div id="body">'+'<div id="body-text"><div>'+this.body+"</div></div>"+"</div>"+"</div>"+"</div>"+'<div id="mini-border"></div>'+"</div>"}if(this.youtube_video){video_src=this.resource_protocol+"www.youtube.com/embed/"+this.youtube_video+"?wmode=transparent&showinfo=0&modestbranding=0&rel=0&autoplay=1&loop=0&vq=hd1080";if(this.yt_custom){video_src+="&enablejsapi=1&html5=1&controls=0";video_html='<div id="video-controls">'+'<div id="video-progress" class="video-progress-el">'+'<div id="video-progress-total" class="video-progress-el"></div>'+'<div id="video-elapsed" class="video-progress-el"></div>'+"</div>"+'<div id="video-time" class="video-progress-el"></div>'+"</div>"}}else if(this.vimeo_video){video_src=this.resource_protocol+"player.vimeo.com/video/"+this.vimeo_video+"?autoplay=1&title=0&byline=0&portrait=0"}if(this.show_video){this.video_iframe='<iframe id="'+MixpanelNotification.MARKUP_PREFIX+'-video-frame" '+'width="'+this.video_width+'" height="'+this.video_height+'" '+' src="'+video_src+'"'+' frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen="1" scrolling="no"'+"></iframe>";video_html='<div id="video-'+(this.flip_animate?"":"no")+'flip">'+'<div id="video">'+'<div id="video-holder"></div>'+video_html+"</div>"+"</div>"}var main_html=video_html+notification_html;if(this.flip_animate){main_html=(this.mini?notification_html:"")+'<div id="flipcontainer"><div id="flipper">'+(this.mini?video_html:main_html)+"</div></div>"}this.notification_el.innerHTML=('<div id="overlay" class="'+this.notif_type+'">'+'<div id="campaignid-'+this.campaign_id+'">'+'<div id="bgwrapper">'+'<div id="bg"></div>'+main_html+"</div>"+"</div>"+"</div>").replace(/class="/g,'class="'+MixpanelNotification.MARKUP_PREFIX+"-").replace(/id="/g,'id="'+MixpanelNotification.MARKUP_PREFIX+"-")};MixpanelNotification.prototype._init_styles=function(){if(this.style==="dark"){this.style_vals={bg:"#1d1f25",bg_actions:"#282b32",bg_hover:"#3a4147",bg_light:"#4a5157",border_gray:"#32353c",cancel_opacity:"0.4",mini_hover:"#2a3137",text_title:"#fff",text_main:"#9498a3",text_tagline:"#464851",text_hover:"#ddd"}}else{this.style_vals={bg:"#fff",bg_actions:"#e7eaee",bg_hover:"#eceff3",bg_light:"#f5f5f5",border_gray:"#e4ecf2",cancel_opacity:"1.0",mini_hover:"#fafafa",text_title:"#5c6578",text_main:"#8b949b",text_tagline:"#ced9e6",text_hover:"#7c8598"}}var shadow="0px 0px 35px 0px rgba(45, 49, 56, 0.7)",video_shadow=shadow,mini_shadow=shadow,thumb_total_size=MixpanelNotification.THUMB_IMG_SIZE+MixpanelNotification.THUMB_BORDER_SIZE*2,anim_seconds=MixpanelNotification.ANIM_TIME/1e3+"s";if(this.mini){shadow="none"}var notif_media_queries={},min_width=MixpanelNotification.NOTIF_WIDTH_MINI+20;notif_media_queries["@media only screen and (max-width: "+(min_width-1)+"px)"]={"#overlay":{display:"none"}};var notif_styles={".flipped":{transform:"rotateY(180deg)"},"#overlay":{position:"fixed",top:"0",left:"0",width:"100%",height:"100%",overflow:"auto","text-align":"center","z-index":"10000","font-family":'"Helvetica", "Arial", sans-serif',"-webkit-font-smoothing":"antialiased","-moz-osx-font-smoothing":"grayscale"},"#overlay.mini":{height:"0",overflow:"visible"},"#overlay a":{width:"initial",padding:"0","text-decoration":"none","text-transform":"none",color:"inherit"},"#bgwrapper":{position:"relative",width:"100%",height:"100%"},"#bg":{position:"fixed",top:"0",left:"0",width:"100%",height:"100%","min-width":this.doc_width*4+"px","min-height":this.doc_height*4+"px","background-color":"black",opacity:"0.0","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=60)",filter:"alpha(opacity=60)",transition:"opacity "+anim_seconds},"#bg.visible":{opacity:MixpanelNotification.BG_OPACITY},".mini #bg":{width:"0",height:"0","min-width":"0"},"#flipcontainer":{perspective:"1000px",position:"absolute",width:"100%"},"#flipper":{position:"relative","transform-style":"preserve-3d",transition:"0.3s"},"#takeover":{position:"absolute",left:"50%",width:MixpanelNotification.NOTIF_WIDTH+"px","margin-left":Math.round(-MixpanelNotification.NOTIF_WIDTH/2)+"px","backface-visibility":"hidden",transform:"rotateY(0deg)",opacity:"0.0",top:MixpanelNotification.NOTIF_START_TOP+"px",transition:"opacity "+anim_seconds+", top "+anim_seconds},"#takeover.visible":{opacity:"1.0",top:MixpanelNotification.NOTIF_TOP+"px"},"#takeover.exiting":{opacity:"0.0",top:MixpanelNotification.NOTIF_START_TOP+"px"},"#thumbspacer":{height:MixpanelNotification.THUMB_OFFSET+"px"},"#thumbborder-wrapper":{position:"absolute",top:-MixpanelNotification.THUMB_BORDER_SIZE+"px",left:MixpanelNotification.NOTIF_WIDTH/2-MixpanelNotification.THUMB_OFFSET-MixpanelNotification.THUMB_BORDER_SIZE+"px",width:thumb_total_size+"px",height:thumb_total_size/2+"px",overflow:"hidden"},"#thumbborder":{position:"absolute",width:thumb_total_size+"px",height:thumb_total_size+"px","border-radius":thumb_total_size+"px","background-color":this.style_vals.bg_actions,opacity:"0.5"},"#thumbnail":{position:"absolute",top:"0px",left:MixpanelNotification.NOTIF_WIDTH/2-MixpanelNotification.THUMB_OFFSET+"px",width:MixpanelNotification.THUMB_IMG_SIZE+"px",height:MixpanelNotification.THUMB_IMG_SIZE+"px",overflow:"hidden","z-index":"100","border-radius":MixpanelNotification.THUMB_IMG_SIZE+"px"},"#mini":{position:"absolute",right:"20px",top:MixpanelNotification.NOTIF_TOP+"px",width:this.notif_width+"px",height:MixpanelNotification.NOTIF_HEIGHT_MINI*2+"px","margin-top":20-MixpanelNotification.NOTIF_HEIGHT_MINI+"px","backface-visibility":"hidden",opacity:"0.0",transform:"rotateX(90deg)",transition:"opacity 0.3s, transform 0.3s, right 0.3s"},"#mini.visible":{opacity:"1.0",transform:"rotateX(0deg)"},"#mini.exiting":{opacity:"0.0",right:"-150px"},"#mainbox":{"border-radius":"4px","box-shadow":shadow,"text-align":"center","background-color":this.style_vals.bg,"font-size":"14px",color:this.style_vals.text_main},"#mini #mainbox":{height:MixpanelNotification.NOTIF_HEIGHT_MINI+"px","margin-top":MixpanelNotification.NOTIF_HEIGHT_MINI+"px","border-radius":"3px",transition:"background-color "+anim_seconds},"#mini-border":{height:MixpanelNotification.NOTIF_HEIGHT_MINI+6+"px",width:MixpanelNotification.NOTIF_WIDTH_MINI+6+"px",position:"absolute",top:"-3px",left:"-3px","margin-top":MixpanelNotification.NOTIF_HEIGHT_MINI+"px","border-radius":"6px",opacity:"0.25","background-color":"#fff","z-index":"-1","box-shadow":mini_shadow},"#mini-icon":{position:"relative",display:"inline-block",width:"75px",height:MixpanelNotification.NOTIF_HEIGHT_MINI+"px","border-radius":"3px 0 0 3px","background-color":this.style_vals.bg_actions,background:"linear-gradient(135deg, "+this.style_vals.bg_light+" 0%, "+this.style_vals.bg_actions+" 100%)",transition:"background-color "+anim_seconds},"#mini:hover #mini-icon":{"background-color":this.style_vals.mini_hover},"#mini:hover #mainbox":{"background-color":this.style_vals.mini_hover},"#mini-icon-img":{position:"absolute","background-image":"url("+this.thumb_image_url+")",width:"48px",height:"48px",top:"20px",left:"12px"},"#content":{padding:"30px 20px 0px 20px"},"#mini-content":{"text-align":"left",height:MixpanelNotification.NOTIF_HEIGHT_MINI+"px",cursor:"pointer"},"#img":{width:"328px","margin-top":"30px","border-radius":"5px"},"#title":{"max-height":"600px",overflow:"hidden","word-wrap":"break-word",padding:"25px 0px 20px 0px","font-size":"19px","font-weight":"bold",color:this.style_vals.text_title},"#body":{"max-height":"600px","margin-bottom":"25px",overflow:"hidden","word-wrap":"break-word","line-height":"21px","font-size":"15px","font-weight":"normal","text-align":"left"},"#mini #body":{display:"inline-block","max-width":"250px",margin:"0 0 0 30px",height:MixpanelNotification.NOTIF_HEIGHT_MINI+"px","font-size":"16px","letter-spacing":"0.8px",color:this.style_vals.text_title},"#mini #body-text":{display:"table",height:MixpanelNotification.NOTIF_HEIGHT_MINI+"px"},"#mini #body-text div":{display:"table-cell","vertical-align":"middle"},"#tagline":{"margin-bottom":"15px","font-size":"10px","font-weight":"600","letter-spacing":"0.8px",color:"#ccd7e0","text-align":"left"},"#tagline a":{color:this.style_vals.text_tagline,transition:"color "+anim_seconds},"#tagline a:hover":{color:this.style_vals.text_hover},"#cancel":{position:"absolute",right:"0",width:"8px",height:"8px",padding:"10px","border-radius":"20px",margin:"12px 12px 0 0","box-sizing":"content-box",cursor:"pointer",transition:"background-color "+anim_seconds},"#mini #cancel":{margin:"7px 7px 0 0"},"#cancel-icon":{width:"8px",height:"8px",overflow:"hidden","background-image":"url("+this.cdn_host+"/site_media/images/icons/notifications/cancel-x.png)",opacity:this.style_vals.cancel_opacity},"#cancel:hover":{"background-color":this.style_vals.bg_hover},"#button":{display:"block",height:"60px","line-height":"60px","text-align":"center","background-color":this.style_vals.bg_actions,"border-radius":"0 0 4px 4px",overflow:"hidden",cursor:"pointer",transition:"background-color "+anim_seconds},"#button-close":{display:"inline-block",width:"9px",height:"60px","margin-right":"8px","vertical-align":"top","background-image":"url("+this.cdn_host+"/site_media/images/icons/notifications/close-x-"+this.style+".png)","background-repeat":"no-repeat","background-position":"0px 25px"},"#button-play":{display:"inline-block",width:"30px",height:"60px","margin-left":"15px","background-image":"url("+this.cdn_host+"/site_media/images/icons/notifications/play-"+this.style+"-small.png)","background-repeat":"no-repeat","background-position":"0px 15px"},"a#button-link":{display:"inline-block","vertical-align":"top","text-align":"center","font-size":"17px","font-weight":"bold",overflow:"hidden","word-wrap":"break-word",color:this.style_vals.text_title,transition:"color "+anim_seconds},"#button:hover":{"background-color":this.style_vals.bg_hover,color:this.style_vals.text_hover},"#button:hover a":{color:this.style_vals.text_hover},"#video-noflip":{position:"relative",top:-this.video_height*2+"px"},"#video-flip":{"backface-visibility":"hidden",transform:"rotateY(180deg)"},"#video":{position:"absolute",width:this.video_width-1+"px",height:this.video_height+"px",top:MixpanelNotification.NOTIF_TOP+"px","margin-top":"100px",left:"50%","margin-left":Math.round(-this.video_width/2)+"px",overflow:"hidden","border-radius":"5px","box-shadow":video_shadow,transform:"translateZ(1px)",transition:"opacity "+anim_seconds+", top "+anim_seconds},"#video.exiting":{opacity:"0.0",top:this.video_height+"px"},"#video-holder":{position:"absolute",width:this.video_width-1+"px",height:this.video_height+"px",overflow:"hidden","border-radius":"5px"},"#video-frame":{"margin-left":"-1px",width:this.video_width+"px"},"#video-controls":{opacity:"0",transition:"opacity 0.5s"},"#video:hover #video-controls":{opacity:"1.0"},"#video .video-progress-el":{position:"absolute",bottom:"0",height:"25px","border-radius":"0 0 0 5px"},"#video-progress":{width:"90%"},"#video-progress-total":{width:"100%","background-color":this.style_vals.bg,opacity:"0.7"},"#video-elapsed":{width:"0","background-color":"#6cb6f5",opacity:"0.9"},"#video #video-time":{width:"10%",right:"0","font-size":"11px","line-height":"25px",color:this.style_vals.text_main,"background-color":"#666","border-radius":"0 0 5px 0"}};if(this._browser_lte("ie",8)){_.extend(notif_styles,{"* html #overlay":{position:"absolute"},"* html #bg":{position:"absolute"},"html, body":{height:"100%"}})}if(this._browser_lte("ie",7)){_.extend(notif_styles,{"#mini #body":{display:"inline",zoom:"1",border:"1px solid "+this.style_vals.bg_hover},"#mini #body-text":{padding:"20px"},"#mini #mini-icon":{display:"none"}})}var VENDOR_STYLES=["backface-visibility","border-radius","box-shadow","opacity","perspective","transform","transform-style","transition"],VENDOR_PREFIXES=["khtml","moz","ms","o","webkit"];for(var selector in notif_styles){for(var si=0;si<VENDOR_STYLES.length;si++){var prop=VENDOR_STYLES[si];if(prop in notif_styles[selector]){var val=notif_styles[selector][prop];for(var pi=0;pi<VENDOR_PREFIXES.length;pi++){notif_styles[selector]["-"+VENDOR_PREFIXES[pi]+"-"+prop]=val}}}}var inject_styles=function(styles,media_queries){var create_style_text=function(style_defs){var st="";for(var selector in style_defs){var mp_selector=selector.replace(/#/g,"#"+MixpanelNotification.MARKUP_PREFIX+"-").replace(/\./g,"."+MixpanelNotification.MARKUP_PREFIX+"-");st+="\n"+mp_selector+" {";var props=style_defs[selector];for(var k in props){st+=k+":"+props[k]+";"}st+="}"}return st};var create_media_query_text=function(mq_defs){var mqt="";for(var mq in mq_defs){mqt+="\n"+mq+" {"+create_style_text(mq_defs[mq])+"\n}"}return mqt};var style_text=create_style_text(styles)+create_media_query_text(media_queries),head_el=document.head||document.getElementsByTagName("head")[0]||document.documentElement,style_el=document.createElement("style");head_el.appendChild(style_el);style_el.setAttribute("type","text/css");if(style_el.styleSheet){style_el.styleSheet.cssText=style_text}else{style_el.textContent=style_text}};inject_styles(notif_styles,notif_media_queries)};MixpanelNotification.prototype._init_video=_.safewrap((function(){if(!this.video_url){return}var self=this;self.yt_custom="postMessage"in window;self.dest_url=self.video_url;var youtube_match=self.video_url.match(/(?:youtube(?:-nocookie)?\.com\/(?:[^/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?/ ]{11})/i),vimeo_match=self.video_url.match(/vimeo\.com\/.*?(\d+)/i);if(youtube_match){self.show_video=true;self.youtube_video=youtube_match[1];if(self.yt_custom){window["onYouTubeIframeAPIReady"]=function(){if(self._get_el("video-frame")){self._yt_video_ready()}};var tag=document.createElement("script");tag.src=self.resource_protocol+"www.youtube.com/iframe_api";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag)}}else if(vimeo_match){self.show_video=true;self.vimeo_video=vimeo_match[1]}if(self._browser_lte("ie",7)||self._browser_lte("firefox",3)){self.show_video=false;self.clickthrough=true}}));MixpanelNotification.prototype._mark_as_shown=_.safewrap((function(){var self=this;_.register_event(self._get_el("bg"),"click",(function(){self.dismiss()}));var get_style=function(el,style_name){var styles={};if(document.defaultView&&document.defaultView.getComputedStyle){styles=document.defaultView.getComputedStyle(el,null)}else if(el.currentStyle){styles=el.currentStyle}return styles[style_name]};if(this.campaign_id){var notif_el=this._get_el("overlay");if(notif_el&&get_style(notif_el,"visibility")!=="hidden"&&get_style(notif_el,"display")!=="none"){this._mark_delivery()}}}));MixpanelNotification.prototype._mark_delivery=_.safewrap((function(extra_props){if(!this.marked_as_shown){this.marked_as_shown=true;if(this.campaign_id){this._get_shown_campaigns()[this.campaign_id]=1*new Date;this.persistence.save()}this._track_event("$campaign_delivery",extra_props);this.mixpanel["people"]["append"]({$campaigns:this.campaign_id,$notifications:{campaign_id:this.campaign_id,message_id:this.message_id,type:"web",time:new Date}})}}));MixpanelNotification.prototype._preload_images=function(all_loaded_cb){var self=this;if(this.imgs_to_preload.length===0){all_loaded_cb();return}var preloaded_imgs=0;var img_objs=[];var onload=function(){preloaded_imgs++;if(preloaded_imgs===self.imgs_to_preload.length&&all_loaded_cb){all_loaded_cb();all_loaded_cb=null}};for(var i=0;i<this.imgs_to_preload.length;i++){var img=new Image;img.onload=onload;img.src=this.imgs_to_preload[i];if(img.complete){onload()}img_objs.push(img)}if(this._browser_lte("ie",7)){setTimeout((function(){var imgs_loaded=true;for(i=0;i<img_objs.length;i++){if(!img_objs[i].complete){imgs_loaded=false}}if(imgs_loaded&&all_loaded_cb){all_loaded_cb();all_loaded_cb=null}}),500)}};MixpanelNotification.prototype._remove_notification_el=_.safewrap((function(){window.clearInterval(this._video_progress_checker);this.notification_el.style.visibility="hidden";this.body_el.removeChild(this.notification_el)}));MixpanelNotification.prototype._set_client_config=function(){var get_browser_version=function(browser_ex){var match=navigator.userAgent.match(browser_ex);return match&&match[1]};this.browser_versions={};this.browser_versions["chrome"]=get_browser_version(/Chrome\/(\d+)/);this.browser_versions["firefox"]=get_browser_version(/Firefox\/(\d+)/);this.browser_versions["ie"]=get_browser_version(/MSIE (\d+).+/);if(!this.browser_versions["ie"]&&!window.ActiveXObject&&"ActiveXObject"in window){this.browser_versions["ie"]=11}this.body_el=document.body||document.getElementsByTagName("body")[0];if(this.body_el){this.doc_width=Math.max(this.body_el.scrollWidth,document.documentElement.scrollWidth,this.body_el.offsetWidth,document.documentElement.offsetWidth,this.body_el.clientWidth,document.documentElement.clientWidth);this.doc_height=Math.max(this.body_el.scrollHeight,document.documentElement.scrollHeight,this.body_el.offsetHeight,document.documentElement.offsetHeight,this.body_el.clientHeight,document.documentElement.clientHeight)}var ie_ver=this.browser_versions["ie"];var sample_styles=document.createElement("div").style,is_css_compatible=function(rule){if(rule in sample_styles){return true}if(!ie_ver){rule=rule[0].toUpperCase()+rule.slice(1);var props=["O"+rule,"Webkit"+rule,"Moz"+rule];for(var i=0;i<props.length;i++){if(props[i]in sample_styles){return true}}}return false};this.use_transitions=this.body_el&&is_css_compatible("transition")&&is_css_compatible("transform");this.flip_animate=(this.browser_versions["chrome"]>=33||this.browser_versions["firefox"]>=15)&&this.body_el&&is_css_compatible("backfaceVisibility")&&is_css_compatible("perspective")&&is_css_compatible("transform")};MixpanelNotification.prototype._switch_to_video=_.safewrap((function(){var self=this,anims=[{el:self._get_notification_display_el(),attr:"opacity",start:1,goal:0},{el:self._get_notification_display_el(),attr:"top",start:MixpanelNotification.NOTIF_TOP,goal:-500},{el:self._get_el("video-noflip"),attr:"opacity",start:0,goal:1},{el:self._get_el("video-noflip"),attr:"top",start:-self.video_height*2,goal:0}];if(self.mini){var bg=self._get_el("bg"),overlay=self._get_el("overlay");bg.style.width="100%";bg.style.height="100%";overlay.style.width="100%";self._add_class(self._get_notification_display_el(),"exiting");self._add_class(bg,"visible");anims.push({el:self._get_el("bg"),attr:"opacity",start:0,goal:MixpanelNotification.BG_OPACITY})}var video_el=self._get_el("video-holder");video_el.innerHTML=self.video_iframe;var video_ready=function(){if(window["YT"]&&window["YT"]["loaded"]){self._yt_video_ready()}self.showing_video=true;self._get_notification_display_el().style.visibility="hidden"};if(self.flip_animate){self._add_class("flipper","flipped");setTimeout(video_ready,MixpanelNotification.ANIM_TIME)}else{self._animate_els(anims,MixpanelNotification.ANIM_TIME,video_ready)}}));MixpanelNotification.prototype._track_event=function(event_name,properties,cb){if(this.campaign_id){properties=properties||{};properties=_.extend(properties,{campaign_id:this.campaign_id,message_id:this.message_id,message_type:"web_inapp",message_subtype:this.notif_type});this.mixpanel["track"](event_name,properties,cb)}else if(cb){cb.call()}};MixpanelNotification.prototype._yt_video_ready=_.safewrap((function(){var self=this;if(self.video_inited){return}self.video_inited=true;var progress_bar=self._get_el("video-elapsed"),progress_time=self._get_el("video-time"),progress_el=self._get_el("video-progress");new window["YT"]["Player"](MixpanelNotification.MARKUP_PREFIX+"-video-frame",{events:{onReady:function(event){var ytplayer=event["target"],video_duration=ytplayer["getDuration"](),pad=function(i){return("00"+i).slice(-2)},update_video_time=function(current_time){var secs=Math.round(video_duration-current_time),mins=Math.floor(secs/60),hours=Math.floor(mins/60);secs-=mins*60;mins-=hours*60;progress_time.innerHTML="-"+(hours?hours+":":"")+pad(mins)+":"+pad(secs)};update_video_time(0);self._video_progress_checker=window.setInterval((function(){var current_time=ytplayer["getCurrentTime"]();progress_bar.style.width=current_time/video_duration*100+"%";update_video_time(current_time)}),250);_.register_event(progress_el,"click",(function(e){var clickx=Math.max(0,e.pageX-progress_el.getBoundingClientRect().left);ytplayer["seekTo"](video_duration*clickx/progress_el.clientWidth,true)}))}}})}));var MixpanelPeople=function(){};_.extend(MixpanelPeople.prototype,apiActions);MixpanelPeople.prototype._init=function(mixpanel_instance){this._mixpanel=mixpanel_instance};MixpanelPeople.prototype.set=addOptOutCheckMixpanelPeople((function(prop,to,callback){var data=this.set_action(prop,to);if(_.isObject(prop)){callback=to}if(this._get_config("save_referrer")){this._mixpanel["persistence"].update_referrer_info(document.referrer)}data[SET_ACTION]=_.extend({},_.info.people_properties(),this._mixpanel["persistence"].get_referrer_info(),data[SET_ACTION]);return this._send_request(data,callback)}));MixpanelPeople.prototype.set_once=addOptOutCheckMixpanelPeople((function(prop,to,callback){var data=this.set_once_action(prop,to);if(_.isObject(prop)){callback=to}return this._send_request(data,callback)}));MixpanelPeople.prototype.unset=addOptOutCheckMixpanelPeople((function(prop,callback){var data=this.unset_action(prop);return this._send_request(data,callback)}));MixpanelPeople.prototype.increment=addOptOutCheckMixpanelPeople((function(prop,by,callback){var data={};var $add={};if(_.isObject(prop)){_.each(prop,(function(v,k){if(!this._is_reserved_property(k)){if(isNaN(parseFloat(v))){console$1.error("Invalid increment value passed to mixpanel.people.increment - must be a number");return}else{$add[k]=v}}}),this);callback=by}else{if(_.isUndefined(by)){by=1}$add[prop]=by}data[ADD_ACTION]=$add;return this._send_request(data,callback)}));MixpanelPeople.prototype.append=addOptOutCheckMixpanelPeople((function(list_name,value,callback){if(_.isObject(list_name)){callback=value}var data=this.append_action(list_name,value);return this._send_request(data,callback)}));MixpanelPeople.prototype.remove=addOptOutCheckMixpanelPeople((function(list_name,value,callback){if(_.isObject(list_name)){callback=value}var data=this.remove_action(list_name,value);return this._send_request(data,callback)}));MixpanelPeople.prototype.union=addOptOutCheckMixpanelPeople((function(list_name,values,callback){if(_.isObject(list_name)){callback=values}var data=this.union_action(list_name,values);return this._send_request(data,callback)}));MixpanelPeople.prototype.track_charge=addOptOutCheckMixpanelPeople((function(amount,properties,callback){if(!_.isNumber(amount)){amount=parseFloat(amount);if(isNaN(amount)){console$1.error("Invalid value passed to mixpanel.people.track_charge - must be a number");return}}return this.append("$transactions",_.extend({$amount:amount},properties),callback)}));MixpanelPeople.prototype.clear_charges=function(callback){return this.set("$transactions",[],callback)};MixpanelPeople.prototype.delete_user=function(){if(!this._identify_called()){console$1.error("mixpanel.people.delete_user() requires you to call identify() first");return}var data={$delete:this._mixpanel.get_distinct_id()};return this._send_request(data)};MixpanelPeople.prototype.toString=function(){return this._mixpanel.toString()+".people"};MixpanelPeople.prototype._send_request=function(data,callback){data["$token"]=this._get_config("token");data["$distinct_id"]=this._mixpanel.get_distinct_id();var device_id=this._mixpanel.get_property("$device_id");var user_id=this._mixpanel.get_property("$user_id");var had_persisted_distinct_id=this._mixpanel.get_property("$had_persisted_distinct_id");if(device_id){data["$device_id"]=device_id}if(user_id){data["$user_id"]=user_id}if(had_persisted_distinct_id){data["$had_persisted_distinct_id"]=had_persisted_distinct_id}var date_encoded_data=_.encodeDates(data);var truncated_data=_.truncate(date_encoded_data,255);var json_data=_.JSONEncode(date_encoded_data);var encoded_data=_.base64Encode(json_data);if(!this._identify_called()){this._enqueue(data);if(!_.isUndefined(callback)){if(this._get_config("verbose")){callback({status:-1,error:null})}else{callback(-1)}}return truncated_data}console$1.log("MIXPANEL PEOPLE REQUEST:");console$1.log(truncated_data);this._mixpanel._send_request(this._get_config("api_host")+"/engage/",{data:encoded_data},this._mixpanel._prepare_callback(callback,truncated_data));return truncated_data};MixpanelPeople.prototype._get_config=function(conf_var){return this._mixpanel.get_config(conf_var)};MixpanelPeople.prototype._identify_called=function(){return this._mixpanel._flags.identify_called===true};MixpanelPeople.prototype._enqueue=function(data){if(SET_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(SET_ACTION,data)}else if(SET_ONCE_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(SET_ONCE_ACTION,data)}else if(UNSET_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(UNSET_ACTION,data)}else if(ADD_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(ADD_ACTION,data)}else if(APPEND_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(APPEND_ACTION,data)}else if(REMOVE_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(REMOVE_ACTION,data)}else if(UNION_ACTION in data){this._mixpanel["persistence"]._add_to_people_queue(UNION_ACTION,data)}else{console$1.error("Invalid call to _enqueue():",data)}};MixpanelPeople.prototype._flush_one_queue=function(action,action_method,callback,queue_to_params_fn){var _this=this;var queued_data=_.extend({},this._mixpanel["persistence"]._get_queue(action));var action_params=queued_data;if(!_.isUndefined(queued_data)&&_.isObject(queued_data)&&!_.isEmptyObject(queued_data)){_this._mixpanel["persistence"]._pop_from_people_queue(action,queued_data);if(queue_to_params_fn){action_params=queue_to_params_fn(queued_data)}action_method.call(_this,action_params,(function(response,data){if(response===0){_this._mixpanel["persistence"]._add_to_people_queue(action,queued_data)}if(!_.isUndefined(callback)){callback(response,data)}}))}};MixpanelPeople.prototype._flush=function(_set_callback,_add_callback,_append_callback,_set_once_callback,_union_callback,_unset_callback,_remove_callback){var _this=this;var $append_queue=this._mixpanel["persistence"]._get_queue(APPEND_ACTION);var $remove_queue=this._mixpanel["persistence"]._get_queue(REMOVE_ACTION);this._flush_one_queue(SET_ACTION,this.set,_set_callback);this._flush_one_queue(SET_ONCE_ACTION,this.set_once,_set_once_callback);this._flush_one_queue(UNSET_ACTION,this.unset,_unset_callback,(function(queue){return _.keys(queue)}));this._flush_one_queue(ADD_ACTION,this.increment,_add_callback);this._flush_one_queue(UNION_ACTION,this.union,_union_callback);if(!_.isUndefined($append_queue)&&_.isArray($append_queue)&&$append_queue.length){var $append_item;var append_callback=function(response,data){if(response===0){_this._mixpanel["persistence"]._add_to_people_queue(APPEND_ACTION,$append_item)}if(!_.isUndefined(_append_callback)){_append_callback(response,data)}};for(var i=$append_queue.length-1;i>=0;i--){$append_item=$append_queue.pop();if(!_.isEmptyObject($append_item)){_this.append($append_item,append_callback)}}_this._mixpanel["persistence"].save()}if(!_.isUndefined($remove_queue)&&_.isArray($remove_queue)&&$remove_queue.length){var $remove_item;var remove_callback=function(response,data){if(response===0){_this._mixpanel["persistence"]._add_to_people_queue(REMOVE_ACTION,$remove_item)}if(!_.isUndefined(_remove_callback)){_remove_callback(response,data)}};for(var j=$remove_queue.length-1;j>=0;j--){$remove_item=$remove_queue.pop();if(!_.isEmptyObject($remove_item)){_this.remove($remove_item,remove_callback)}}_this._mixpanel["persistence"].save()}};MixpanelPeople.prototype._is_reserved_property=function(prop){return prop==="$distinct_id"||prop==="$token"||prop==="$device_id"||prop==="$user_id"||prop==="$had_persisted_distinct_id"};MixpanelPeople.prototype["set"]=MixpanelPeople.prototype.set;MixpanelPeople.prototype["set_once"]=MixpanelPeople.prototype.set_once;MixpanelPeople.prototype["unset"]=MixpanelPeople.prototype.unset;MixpanelPeople.prototype["increment"]=MixpanelPeople.prototype.increment;MixpanelPeople.prototype["append"]=MixpanelPeople.prototype.append;MixpanelPeople.prototype["remove"]=MixpanelPeople.prototype.remove;MixpanelPeople.prototype["union"]=MixpanelPeople.prototype.union;MixpanelPeople.prototype["track_charge"]=MixpanelPeople.prototype.track_charge;MixpanelPeople.prototype["clear_charges"]=MixpanelPeople.prototype.clear_charges;MixpanelPeople.prototype["delete_user"]=MixpanelPeople.prototype.delete_user;MixpanelPeople.prototype["toString"]=MixpanelPeople.prototype.toString;var init_type;var mixpanel_master;var INIT_MODULE=0;var INIT_SNIPPET=1;var PRIMARY_INSTANCE_NAME="mixpanel";var USE_XHR=window$1.XMLHttpRequest&&"withCredentials"in new XMLHttpRequest;var ENQUEUE_REQUESTS=!USE_XHR&&userAgent.indexOf("MSIE")===-1&&userAgent.indexOf("Mozilla")===-1;var DEFAULT_CONFIG={api_host:"https://api.mixpanel.com",app_host:"https://mixpanel.com",autotrack:true,cdn:"https://cdn.mxpnl.com",cross_subdomain_cookie:true,persistence:"cookie",persistence_name:"",cookie_name:"",loaded:function(){},store_google:true,save_referrer:true,test:false,verbose:false,img:false,track_pageview:true,debug:false,track_links_timeout:300,cookie_expiration:365,upgrade:false,disable_persistence:false,disable_cookie:false,secure_cookie:false,ip:true,opt_out_tracking_by_default:false,opt_out_persistence_by_default:false,opt_out_tracking_persistence_type:"localStorage",opt_out_tracking_cookie_prefix:null,property_blacklist:[],xhr_headers:{},inapp_protocol:"//",inapp_link_new_window:false};var DOM_LOADED=false;var MixpanelLib=function(){};var create_mplib=function(token,config,name){var instance,target=name===PRIMARY_INSTANCE_NAME?mixpanel_master:mixpanel_master[name];if(target&&init_type===INIT_MODULE){instance=target}else{if(target&&!_.isArray(target)){console$1.error("You have already initialized "+name);return}instance=new MixpanelLib}instance._init(token,config,name);instance["people"]=new MixpanelPeople;instance["people"]._init(instance);instance._cached_groups={};instance._user_decide_check_complete=false;instance._events_tracked_before_user_decide_check_complete=[];Config.DEBUG=Config.DEBUG||instance.get_config("debug");instance["__autotrack_enabled"]=instance.get_config("autotrack");if(instance.get_config("autotrack")){var num_buckets=100;var num_enabled_buckets=100;if(!autotrack.enabledForProject(instance.get_config("token"),num_buckets,num_enabled_buckets)){instance["__autotrack_enabled"]=false;console$1.log("Not in active bucket: disabling Automatic Event Collection.")}else if(!autotrack.isBrowserSupported()){instance["__autotrack_enabled"]=false;console$1.log("Disabling Automatic Event Collection because this browser is not supported")}else{autotrack.init(instance)}}if(!_.isUndefined(target)&&_.isArray(target)){instance._execute_array.call(instance["people"],target["people"]);instance._execute_array(target)}return instance};MixpanelLib.prototype.init=function(token,config,name){if(_.isUndefined(name)){console$1.error("You must name your new library: init(token, config, name)");return}if(name===PRIMARY_INSTANCE_NAME){console$1.error("You must initialize the main mixpanel object right after you include the Mixpanel js snippet");return}var instance=create_mplib(token,config,name);mixpanel_master[name]=instance;instance._loaded();return instance};MixpanelLib.prototype._init=function(token,config,name){this["__loaded"]=true;this["config"]={};this["_triggered_notifs"]=[];this.set_config(_.extend({},DEFAULT_CONFIG,config,{name,token,callback_fn:(name===PRIMARY_INSTANCE_NAME?name:PRIMARY_INSTANCE_NAME+"."+name)+"._jsc"}));this["_jsc"]=function(){};this.__dom_loaded_queue=[];this.__request_queue=[];this.__disabled_events=[];this._flags={disable_all_events:false,identify_called:false};this["persistence"]=this["cookie"]=new MixpanelPersistence(this["config"]);this._gdpr_init();var uuid=_.UUID();if(!this.get_distinct_id()){this.register_once({distinct_id:uuid,$device_id:uuid},"")}};MixpanelLib.prototype._loaded=function(){this.get_config("loaded")(this);if(this.get_config("track_pageview")){this.track_pageview()}};MixpanelLib.prototype._dom_loaded=function(){_.each(this.__dom_loaded_queue,(function(item){this._track_dom.apply(this,item)}),this);if(!this.has_opted_out_tracking()){_.each(this.__request_queue,(function(item){this._send_request.apply(this,item)}),this)}delete this.__dom_loaded_queue;delete this.__request_queue};MixpanelLib.prototype._track_dom=function(DomClass,args){if(this.get_config("img")){console$1.error("You can't use DOM tracking functions with img = true.");return false}if(!DOM_LOADED){this.__dom_loaded_queue.push([DomClass,args]);return false}var dt=(new DomClass).init(this);return dt.track.apply(dt,args)};MixpanelLib.prototype._prepare_callback=function(callback,data){if(_.isUndefined(callback)){return null}if(USE_XHR){var callback_function=function(response){callback(response,data)};return callback_function}else{var jsc=this["_jsc"];var randomized_cb=""+Math.floor(Math.random()*1e8);var callback_string=this.get_config("callback_fn")+"["+randomized_cb+"]";jsc[randomized_cb]=function(response){delete jsc[randomized_cb];callback(response,data)};return callback_string}};MixpanelLib.prototype._send_request=function(url,data,callback){if(ENQUEUE_REQUESTS){this.__request_queue.push(arguments);return}var verbose_mode=this.get_config("verbose");if(data["verbose"]){verbose_mode=true}if(this.get_config("test")){data["test"]=1}if(verbose_mode){data["verbose"]=1}if(this.get_config("img")){data["img"]=1}if(!USE_XHR){if(callback){data["callback"]=callback}else if(verbose_mode||this.get_config("test")){data["callback"]="(function(){})"}}data["ip"]=this.get_config("ip")?1:0;data["_"]=(new Date).getTime().toString();url+="?"+_.HTTPBuildQuery(data);if("img"in data){var img=document$1.createElement("img");img.src=url;document$1.body.appendChild(img)}else if(USE_XHR){try{var req=new XMLHttpRequest;req.open("GET",url,true);var headers=this.get_config("xhr_headers");_.each(headers,(function(headerValue,headerName){req.setRequestHeader(headerName,headerValue)}));req.withCredentials=true;req.onreadystatechange=function(){if(req.readyState===4){if(req.status===200){if(callback){if(verbose_mode){var response;try{response=_.JSONDecode(req.responseText)}catch(e){console$1.error(e);return}callback(response)}else{callback(Number(req.responseText))}}}else{var error="Bad HTTP status: "+req.status+" "+req.statusText;console$1.error(error);if(callback){if(verbose_mode){callback({status:0,error})}else{callback(0)}}}}};req.send(null)}catch(e){console$1.error(e)}}else{var script=document$1.createElement("script");script.type="text/javascript";script.async=true;script.defer=true;script.src=url;var s=document$1.getElementsByTagName("script")[0];s.parentNode.insertBefore(script,s)}};MixpanelLib.prototype._execute_array=function(array){var fn_name,alias_calls=[],other_calls=[],tracking_calls=[];_.each(array,(function(item){if(item){fn_name=item[0];if(_.isArray(fn_name)){tracking_calls.push(item)}else if(typeof item==="function"){item.call(this)}else if(_.isArray(item)&&fn_name==="alias"){alias_calls.push(item)}else if(_.isArray(item)&&fn_name.indexOf("track")!==-1&&typeof this[fn_name]==="function"){tracking_calls.push(item)}else{other_calls.push(item)}}}),this);var execute=function(calls,context){_.each(calls,(function(item){if(_.isArray(item[0])){var caller=context;_.each(item,(function(call){caller=caller[call[0]].apply(caller,call.slice(1))}))}else{this[item[0]].apply(this,item.slice(1))}}),context)};execute(alias_calls,this);execute(other_calls,this);execute(tracking_calls,this)};MixpanelLib.prototype.push=function(item){this._execute_array([item])};MixpanelLib.prototype.disable=function(events){if(typeof events==="undefined"){this._flags.disable_all_events=true}else{this.__disabled_events=this.__disabled_events.concat(events)}};MixpanelLib.prototype.track=addOptOutCheckMixpanelLib((function(event_name,properties,callback){if(typeof callback!=="function"){callback=function(){}}if(_.isUndefined(event_name)){console$1.error("No event name provided to mixpanel.track");return}if(this._event_is_disabled(event_name)){callback(0);return}properties=properties||{};properties["token"]=this.get_config("token");var start_timestamp=this["persistence"].remove_event_timer(event_name);if(!_.isUndefined(start_timestamp)){var duration_in_ms=(new Date).getTime()-start_timestamp;properties["$duration"]=parseFloat((duration_in_ms/1e3).toFixed(3))}this["persistence"].update_search_keyword(document$1.referrer);if(this.get_config("store_google")){this["persistence"].update_campaign_params()}if(this.get_config("save_referrer")){this["persistence"].update_referrer_info(document$1.referrer)}properties=_.extend({},_.info.properties(),this["persistence"].properties(),properties);var property_blacklist=this.get_config("property_blacklist");if(_.isArray(property_blacklist)){_.each(property_blacklist,(function(blacklisted_prop){delete properties[blacklisted_prop]}))}else{console$1.error("Invalid value for property_blacklist config: "+property_blacklist)}var data={event:event_name,properties};var truncated_data=_.truncate(data,255);var json_data=_.JSONEncode(truncated_data);var encoded_data=_.base64Encode(json_data);console$1.log("MIXPANEL REQUEST:");console$1.log(truncated_data);this._send_request(this.get_config("api_host")+"/track/",{data:encoded_data},this._prepare_callback(callback,truncated_data));this._check_and_handle_triggered_notifications(data);return truncated_data}));MixpanelLib.prototype.set_group=addOptOutCheckMixpanelLib((function(group_key,group_ids,callback){if(!_.isArray(group_ids)){group_ids=[group_ids]}var prop={};prop[group_key]=group_ids;this.register(prop);return this["people"].set(group_key,group_ids,callback)}));MixpanelLib.prototype.add_group=addOptOutCheckMixpanelLib((function(group_key,group_id,callback){var old_values=this.get_property(group_key);if(old_values===undefined){var prop={};prop[group_key]=[group_id];this.register(prop)}else{if(old_values.indexOf(group_id)===-1){old_values.push(group_id);this.register(prop)}}return this["people"].union(group_key,group_id,callback)}));MixpanelLib.prototype.remove_group=addOptOutCheckMixpanelLib((function(group_key,group_id,callback){var old_value=this.get_property(group_key);if(old_value!==undefined){var idx=old_value.indexOf(group_id);if(idx>-1){old_value.splice(idx,1);this.register({group_key:old_value})}if(old_value.length===0){this.unregister(group_key)}}return this["people"].remove(group_key,group_id,callback)}));MixpanelLib.prototype.track_with_groups=addOptOutCheckMixpanelLib((function(event_name,properties,groups,callback){var tracking_props=_.extend({},properties||{});_.each(groups,(function(v,k){if(v!==null&&v!==undefined){tracking_props[k]=v}}));return this.track(event_name,tracking_props,callback)}));MixpanelLib.prototype._create_map_key=function(group_key,group_id){return group_key+"_"+JSON.stringify(group_id)};MixpanelLib.prototype._remove_group_from_cache=function(group_key,group_id){delete this._cached_groups[this._create_map_key(group_key,group_id)]};MixpanelLib.prototype.get_group=function(group_key,group_id){var map_key=this._create_map_key(group_key,group_id);var group=this._cached_groups[map_key];if(group===undefined||group._group_key!==group_key||group._group_id!==group_id){group=new MixpanelGroup;group._init(this,group_key,group_id);this._cached_groups[map_key]=group}return group};MixpanelLib.prototype.track_pageview=function(page){if(_.isUndefined(page)){page=document$1.location.href}this.track("mp_page_view",_.info.pageviewInfo(page))};MixpanelLib.prototype.track_links=function(){return this._track_dom.call(this,LinkTracker,arguments)};MixpanelLib.prototype.track_forms=function(){return this._track_dom.call(this,FormTracker,arguments)};MixpanelLib.prototype.time_event=function(event_name){if(_.isUndefined(event_name)){console$1.error("No event name provided to mixpanel.time_event");return}if(this._event_is_disabled(event_name)){return}this["persistence"].set_event_timer(event_name,(new Date).getTime())};MixpanelLib.prototype.register=function(props,days){this["persistence"].register(props,days)};MixpanelLib.prototype.register_once=function(props,default_value,days){this["persistence"].register_once(props,default_value,days)};MixpanelLib.prototype.unregister=function(property){this["persistence"].unregister(property)};MixpanelLib.prototype._register_single=function(prop,value){var props={};props[prop]=value;this.register(props)};MixpanelLib.prototype.identify=function(new_distinct_id,_set_callback,_add_callback,_append_callback,_set_once_callback,_union_callback,_unset_callback,_remove_callback){var previous_distinct_id=this.get_distinct_id();this.register({$user_id:new_distinct_id});if(!this.get_property("$device_id")){var device_id=previous_distinct_id;this.register_once({$had_persisted_distinct_id:true,$device_id:device_id},"")}if(new_distinct_id!==previous_distinct_id&&new_distinct_id!==this.get_property(ALIAS_ID_KEY)){this.unregister(ALIAS_ID_KEY);this.register({distinct_id:new_distinct_id})}this._check_and_handle_notifications(this.get_distinct_id());this._flags.identify_called=true;this["people"]._flush(_set_callback,_add_callback,_append_callback,_set_once_callback,_union_callback,_unset_callback,_remove_callback);if(new_distinct_id!==previous_distinct_id){this.track("$identify",{distinct_id:new_distinct_id,$anon_distinct_id:previous_distinct_id})}};MixpanelLib.prototype.reset=function(){this["persistence"].clear();this._flags.identify_called=false;var uuid=_.UUID();this.register_once({distinct_id:uuid,$device_id:uuid},"")};MixpanelLib.prototype.get_distinct_id=function(){return this.get_property("distinct_id")};MixpanelLib.prototype.alias=function(alias,original){if(alias===this.get_property(PEOPLE_DISTINCT_ID_KEY)){console$1.critical("Attempting to create alias for existing People user - aborting.");return-2}var _this=this;if(_.isUndefined(original)){original=this.get_distinct_id()}if(alias!==original){this._register_single(ALIAS_ID_KEY,alias);return this.track("$create_alias",{alias,distinct_id:original},(function(){_this.identify(alias)}))}else{console$1.error("alias matches current distinct_id - skipping api call.");this.identify(alias);return-1}};MixpanelLib.prototype.name_tag=function(name_tag){this._register_single("mp_name_tag",name_tag)};MixpanelLib.prototype.set_config=function(config){if(_.isObject(config)){_.extend(this["config"],config);if(!this.get_config("persistence_name")){this["config"]["persistence_name"]=this["config"]["cookie_name"]}if(!this.get_config("disable_persistence")){this["config"]["disable_persistence"]=this["config"]["disable_cookie"]}if(this["persistence"]){this["persistence"].update_config(this["config"])}Config.DEBUG=Config.DEBUG||this.get_config("debug")}};MixpanelLib.prototype.get_config=function(prop_name){return this["config"][prop_name]};MixpanelLib.prototype.get_property=function(property_name){return this["persistence"]["props"][property_name]};MixpanelLib.prototype.toString=function(){var name=this.get_config("name");if(name!==PRIMARY_INSTANCE_NAME){name=PRIMARY_INSTANCE_NAME+"."+name}return name};MixpanelLib.prototype._event_is_disabled=function(event_name){return _.isBlockedUA(userAgent)||this._flags.disable_all_events||_.include(this.__disabled_events,event_name)};MixpanelLib.prototype._check_and_handle_triggered_notifications=addOptOutCheckMixpanelLib((function(event_data){if(!this._user_decide_check_complete){this._events_tracked_before_user_decide_check_complete.push(event_data)}else{var arr=this["_triggered_notifs"];for(var i=0;i<arr.length;i++){var notif=new MixpanelNotification(arr[i],this);if(notif._matches_event_data(event_data)){this._show_notification(arr[i]);return}}}}));MixpanelLib.prototype._check_and_handle_notifications=addOptOutCheckMixpanelLib((function(distinct_id){if(!distinct_id||this._flags.identify_called||this.get_config("disable_notifications")){return}console$1.log("MIXPANEL NOTIFICATION CHECK");var data={verbose:true,version:"3",lib:"web",token:this.get_config("token"),distinct_id};this._send_request(this.get_config("api_host")+"/decide/",data,this._prepare_callback(_.bind((function(result){if(result["notifications"]&&result["notifications"].length>0){this["_triggered_notifs"]=[];var notifications=[];_.each(result["notifications"],(function(notif){(notif["display_triggers"]&&notif["display_triggers"].length>0?this["_triggered_notifs"]:notifications).push(notif)}),this);if(notifications.length>0){this._show_notification.call(this,notifications[0])}}this._handle_user_decide_check_complete()}),this)))}));MixpanelLib.prototype._handle_user_decide_check_complete=function(){this._user_decide_check_complete=true;var events=this._events_tracked_before_user_decide_check_complete;while(events.length>0){var data=events.shift();this._check_and_handle_triggered_notifications(data)}};MixpanelLib.prototype._show_notification=function(notif_data){var notification=new MixpanelNotification(notif_data,this);notification.show()};MixpanelLib.prototype._gdpr_init=function(){var is_localStorage_requested=this.get_config("opt_out_tracking_persistence_type")==="localStorage";if(is_localStorage_requested&&_.localStorage.is_supported()){if(!this.has_opted_in_tracking()&&this.has_opted_in_tracking({persistence_type:"cookie"})){this.opt_in_tracking({enable_persistence:false})}if(!this.has_opted_out_tracking()&&this.has_opted_out_tracking({persistence_type:"cookie"})){this.opt_out_tracking({clear_persistence:false})}this.clear_opt_in_out_tracking({persistence_type:"cookie",enable_persistence:false})}if(this.has_opted_out_tracking()){this._gdpr_update_persistence({clear_persistence:true})}else if(!this.has_opted_in_tracking()&&(this.get_config("opt_out_tracking_by_default")||_.cookie.get("mp_optout"))){_.cookie.remove("mp_optout");this.opt_out_tracking({clear_persistence:this.get_config("opt_out_persistence_by_default")})}};MixpanelLib.prototype._gdpr_update_persistence=function(options){var disabled;if(options&&options["clear_persistence"]){disabled=true}else if(options&&options["enable_persistence"]){disabled=false}else{return}if(!this.get_config("disable_persistence")&&this["persistence"].disabled!==disabled){this["persistence"].set_disabled(disabled)}};MixpanelLib.prototype._gdpr_call_func=function(func,options){options=_.extend({track:_.bind(this.track,this),persistence_type:this.get_config("opt_out_tracking_persistence_type"),cookie_prefix:this.get_config("opt_out_tracking_cookie_prefix"),cookie_expiration:this.get_config("cookie_expiration"),cross_subdomain_cookie:this.get_config("cross_subdomain_cookie"),secure_cookie:this.get_config("secure_cookie")},options);if(!_.localStorage.is_supported()){options["persistence_type"]="cookie"}return func(this.get_config("token"),{track:options["track"],trackEventName:options["track_event_name"],trackProperties:options["track_properties"],persistenceType:options["persistence_type"],persistencePrefix:options["cookie_prefix"],cookieExpiration:options["cookie_expiration"],crossSubdomainCookie:options["cross_subdomain_cookie"],secureCookie:options["secure_cookie"]})};MixpanelLib.prototype.opt_in_tracking=function(options){options=_.extend({enable_persistence:true},options);this._gdpr_call_func(optIn,options);this._gdpr_update_persistence(options)};MixpanelLib.prototype.opt_out_tracking=function(options){options=_.extend({clear_persistence:true,delete_user:true},options);if(options["delete_user"]&&this["people"]&&this["people"]._identify_called()){this["people"].delete_user();this["people"].clear_charges()}this._gdpr_call_func(optOut,options);this._gdpr_update_persistence(options)};MixpanelLib.prototype.has_opted_in_tracking=function(options){return this._gdpr_call_func(hasOptedIn,options)};MixpanelLib.prototype.has_opted_out_tracking=function(options){return this._gdpr_call_func(hasOptedOut,options)};MixpanelLib.prototype.clear_opt_in_out_tracking=function(options){options=_.extend({enable_persistence:true},options);this._gdpr_call_func(clearOptInOut,options);this._gdpr_update_persistence(options)};MixpanelLib.prototype["init"]=MixpanelLib.prototype.init;MixpanelLib.prototype["reset"]=MixpanelLib.prototype.reset;MixpanelLib.prototype["disable"]=MixpanelLib.prototype.disable;MixpanelLib.prototype["time_event"]=MixpanelLib.prototype.time_event;MixpanelLib.prototype["track"]=MixpanelLib.prototype.track;MixpanelLib.prototype["track_links"]=MixpanelLib.prototype.track_links;MixpanelLib.prototype["track_forms"]=MixpanelLib.prototype.track_forms;MixpanelLib.prototype["track_pageview"]=MixpanelLib.prototype.track_pageview;MixpanelLib.prototype["register"]=MixpanelLib.prototype.register;MixpanelLib.prototype["register_once"]=MixpanelLib.prototype.register_once;MixpanelLib.prototype["unregister"]=MixpanelLib.prototype.unregister;MixpanelLib.prototype["identify"]=MixpanelLib.prototype.identify;MixpanelLib.prototype["alias"]=MixpanelLib.prototype.alias;MixpanelLib.prototype["name_tag"]=MixpanelLib.prototype.name_tag;MixpanelLib.prototype["set_config"]=MixpanelLib.prototype.set_config;MixpanelLib.prototype["get_config"]=MixpanelLib.prototype.get_config;MixpanelLib.prototype["get_property"]=MixpanelLib.prototype.get_property;MixpanelLib.prototype["get_distinct_id"]=MixpanelLib.prototype.get_distinct_id;MixpanelLib.prototype["toString"]=MixpanelLib.prototype.toString;MixpanelLib.prototype["_check_and_handle_notifications"]=MixpanelLib.prototype._check_and_handle_notifications;MixpanelLib.prototype["_show_notification"]=MixpanelLib.prototype._show_notification;MixpanelLib.prototype["opt_out_tracking"]=MixpanelLib.prototype.opt_out_tracking;MixpanelLib.prototype["opt_in_tracking"]=MixpanelLib.prototype.opt_in_tracking;MixpanelLib.prototype["has_opted_out_tracking"]=MixpanelLib.prototype.has_opted_out_tracking;MixpanelLib.prototype["has_opted_in_tracking"]=MixpanelLib.prototype.has_opted_in_tracking;MixpanelLib.prototype["clear_opt_in_out_tracking"]=MixpanelLib.prototype.clear_opt_in_out_tracking;MixpanelLib.prototype["get_group"]=MixpanelLib.prototype.get_group;MixpanelLib.prototype["set_group"]=MixpanelLib.prototype.set_group;MixpanelLib.prototype["add_group"]=MixpanelLib.prototype.add_group;MixpanelLib.prototype["remove_group"]=MixpanelLib.prototype.remove_group;MixpanelLib.prototype["track_with_groups"]=MixpanelLib.prototype.track_with_groups;MixpanelPersistence.prototype["properties"]=MixpanelPersistence.prototype.properties;MixpanelPersistence.prototype["update_search_keyword"]=MixpanelPersistence.prototype.update_search_keyword;MixpanelPersistence.prototype["update_referrer_info"]=MixpanelPersistence.prototype.update_referrer_info;MixpanelPersistence.prototype["get_cross_subdomain"]=MixpanelPersistence.prototype.get_cross_subdomain;MixpanelPersistence.prototype["clear"]=MixpanelPersistence.prototype.clear;_.safewrap_class(MixpanelLib,["identify","_check_and_handle_notifications","_show_notification"]);var instances={};var extend_mp=function(){_.each(instances,(function(instance,name){if(name!==PRIMARY_INSTANCE_NAME){mixpanel_master[name]=instance}}));mixpanel_master["_"]=_};var override_mp_init_func=function(){mixpanel_master["init"]=function(token,config,name){if(name){if(!mixpanel_master[name]){mixpanel_master[name]=instances[name]=create_mplib(token,config,name);mixpanel_master[name]._loaded()}return mixpanel_master[name]}else{var instance=mixpanel_master;if(instances[PRIMARY_INSTANCE_NAME]){instance=instances[PRIMARY_INSTANCE_NAME]}else if(token){instance=create_mplib(token,config,PRIMARY_INSTANCE_NAME);instance._loaded();instances[PRIMARY_INSTANCE_NAME]=instance}mixpanel_master=instance;if(init_type===INIT_SNIPPET){window$1[PRIMARY_INSTANCE_NAME]=mixpanel_master}extend_mp()}}};var add_dom_loaded_handler=function(){function dom_loaded_handler(){if(dom_loaded_handler.done){return}dom_loaded_handler.done=true;DOM_LOADED=true;ENQUEUE_REQUESTS=false;_.each(instances,(function(inst){inst._dom_loaded()}))}function do_scroll_check(){try{document$1.documentElement.doScroll("left")}catch(e){setTimeout(do_scroll_check,1);return}dom_loaded_handler()}if(document$1.addEventListener){if(document$1.readyState==="complete"){dom_loaded_handler()}else{document$1.addEventListener("DOMContentLoaded",dom_loaded_handler,false)}}else if(document$1.attachEvent){document$1.attachEvent("onreadystatechange",dom_loaded_handler);var toplevel=false;try{toplevel=window$1.frameElement===null}catch(e){}if(document$1.documentElement.doScroll&&toplevel){do_scroll_check()}}_.register_event(window$1,"load",dom_loaded_handler,true)};function init_as_module(){init_type=INIT_MODULE;mixpanel_master=new MixpanelLib;override_mp_init_func();mixpanel_master["init"]();add_dom_loaded_handler();return mixpanel_master}var mixpanel=init_as_module();module.exports=mixpanel},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const _=__webpack_require__(200);const Mixpanel=__webpack_require__(205);const Sentry=__webpack_require__(256);const utils=__webpack_require__(210);module.exports=(SentryLib,MixpanelLib,fake=false)=>{const sentry=Sentry(SentryLib);const mixpanel=Mixpanel(MixpanelLib);const installedServices=[];let installed=false;let enabled=true;let consoleOutputDisabled=false;const getSupportedServices=()=>["sentry","mixpanel"];const logDebug=message=>{const debugMessage=`${new Date} ${message}`;if(!consoleOutputDisabled){console.log(utils.hideAbsolutePathsInObject(debugMessage))}};let shouldReportCallback=_.constant(true);const setShouldReport=callback=>{if(!_.isFunction(callback)){throw new Error("Function expected")}else{shouldReportCallback=callback}};const shouldSendToExternalServices=()=>enabled&&!fake&&shouldReportCallback();return{getSupportedServices,logDebug,enable:()=>{enabled=true},disable:()=>{enabled=false},isEnabled:()=>enabled&&!fake,getInstalledServices:()=>installedServices,install:config=>{consoleOutputDisabled=Boolean(config.options.disableConsoleOutput);if(fake){return}if(installed){throw new Error("Already installed")}installed=true;if(!_.isNil(config.options.shouldReport)){setShouldReport(config.options.shouldReport)}Object.keys(config.services).forEach((serviceName=>{if(!getSupportedServices().includes(serviceName)){throw new Error(`Service not supported: ${serviceName}`)}if(serviceName==="sentry"&&!_.isNil(config.services.sentry)){sentry.install(config.services.sentry,{release:config.options.release,serverName:config.options.serverName,disableConsoleAlerts:consoleOutputDisabled});installedServices.push("sentry")}if(serviceName==="mixpanel"&&!_.isNil(config.services.mixpanel)){mixpanel.install(config.services.mixpanel,{version:config.options.release,serverName:config.options.serverName},config.options.mixpanel,config.options.mixpanelDeferred);installedServices.push("mixpanel")}}))},logEvent:(message,data)=>{const debugMessage=_.attempt((()=>{if(data){return`${message} (${JSON.stringify(data)})`}return message}));logDebug(debugMessage);if(shouldSendToExternalServices()&&installedServices.includes("mixpanel")){mixpanel.track(message,data)}},logException:error=>{if(!consoleOutputDisabled){console.error(JSON.stringify(utils.hideAbsolutePathsInObject(error)))}if(!installedServices.includes("sentry")||!shouldSendToExternalServices()||!utils.shouldReportError(error)){return}sentry.captureException(error)},shouldReport:setShouldReport,disableConsoleOutput:()=>{consoleOutputDisabled=true},enableConsoleOutput:()=>{consoleOutputDisabled=false},setConfigs:configs=>{mixpanel.setConfig(configs.mixpanel)}}}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const detect=__webpack_require__(206);const utils=__webpack_require__(210);const defaultContext=__webpack_require__(217);const _=__webpack_require__(200);module.exports=MixpanelLib=>{const env=detect.getName();const queue=[];let installed=false;let projectToken=null;let client=null;let mixpanelContext={};let disabled=false;function disposeEventsQueue(){if(client===null){return}let element=queue.shift();while(element!==undefined){const{event,data}=element;client.track(event,data);element=queue.shift()}}function setConfig(config){if(config==null){disabled=true;queue.splice(0,queue.length)}else{client=MixpanelLib.init(projectToken,config)||MixpanelLib}}return{isInstalled:()=>installed,install:(token,context,config,deferred=false)=>{if(installed){throw new Error("Mixpanel already installed")}if(global.window){global.window["_mpEditorLoaded"]=true;global.window.sessionStorage.setItem("editorParams",JSON.stringify({projectToken:token}))}projectToken=token;mixpanelContext=utils.flattenStartCase(_.defaults(context,defaultContext[env]));installed=true;if(!deferred){setConfig(config)}},uninstall:()=>{if(!installed){throw new Error("Mixpanel not installed")}installed=false},track:(message,data)=>{if(!installed){throw new Error("Mixpanel not installed")}if(disabled){return}queue.push({event:message,data:utils.hideAbsolutePathsInObject(Object.assign({},mixpanelContext,utils.flattenStartCase(data)))});disposeEventsQueue()},setConfig}}},(module,__unused_webpack_exports,__webpack_require__)=>{var isNode=__webpack_require__(207);var isPhantom=__webpack_require__(208);var isElectron=__webpack_require__(209);var getName=function(){if(isElectron()){return"electron"}if(isPhantom()){return"phantom"}if(isNode){return"nodejs"}return"browser"};module.exports={getName}},(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{default:()=>__WEBPACK_DEFAULT_EXPORT__});const __WEBPACK_DEFAULT_EXPORT__=Object.prototype.toString.call(typeof process!=="undefined"?process:0)==="[object process]"},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__;(function(exports){"use strict";function isPhantom(){return!!(typeof window!="undefined"&&window.callPhantom&&window._phantom)}if(true){!(__WEBPACK_AMD_DEFINE_RESULT__=function(){return isPhantom}.call(exports,__webpack_require__,exports,module),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})(this)},module=>{function isElectron(){if(typeof window!=="undefined"&&typeof window.process==="object"&&window.process.type==="renderer"){return true}if(typeof process!=="undefined"&&typeof process.versions==="object"&&!!process.versions.electron){return true}if(typeof navigator==="object"&&typeof navigator.userAgent==="string"&&navigator.userAgent.indexOf("Electron")>=0){return true}return false}module.exports=isElectron},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";const jc=__webpack_require__(211);const _=__webpack_require__(200);_.mixin(__webpack_require__(212));const flatten=__webpack_require__(213).flatten;const deepMapKeys=__webpack_require__(215);const path=__webpack_require__(40);exports.flattenStartCase=object=>{if(_.isUndefined(object)){return undefined}if(!_.isObject(object)){return{Value:object}}if(_.isArray(object)){return _.map(object,(property=>{if(_.isObject(property)){return exports.flattenStartCase(property)}return property}))}const transformedKeysObject=deepMapKeys(object,(key=>{const regex=/^[A-Z_]+$/;if(regex.test(key)){return key}return _.startCase(key)}));return flatten(transformedKeysObject,{delimiter:" ",safe:true})};exports.hideAbsolutePathsInObject=object=>{if(_.isError(object)){object=_.reduce(Object.getOwnPropertyNames(object),((accumulator,key)=>{accumulator[key]=object[key];return accumulator}),{})}if(_.isString(object)){const words=object.split(" ").map((word=>path.isAbsolute(word)?path.basename(word):word));return words.join(" ")}object=jc.decycle(object);return _.deepMapValues(object,(value=>{if(!_.isString(value)){return value}if(value.startsWith("/dev/")||value.startsWith("\\\\.\\")){return value}return path.isAbsolute(value)?path.basename(value):value}))};exports.shouldReportError=error=>!_.has(error,["report"])||Boolean(error.report)},module=>{"use strict";function decycle(object){var objects=[],paths=[];return function derez(value,path){var i,name,nu;var _value=value&&value.toJSON instanceof Function?value.toJSON():value;if(typeof _value==="object"&&_value!==null){for(i=0;i<objects.length;i+=1){if(objects[i]===_value){return{$ref:paths[i]}}}objects.push(_value);paths.push(path);if(Object.prototype.toString.apply(_value)==="[object Array]"){nu=[];for(i=0;i<_value.length;i+=1){nu[i]=derez(_value[i],path+"["+i+"]")}}else{nu={};for(name in _value){if(Object.prototype.hasOwnProperty.call(_value,name)){nu[name]=derez(_value[name],path+"["+JSON.stringify(name)+"]")}}}return nu}return _value}(object,"$")}function retrocycle($){var px=/^\$(?:\[(?:\d+|\"(?:[^\\\"\u0000-\u001f]|\\([\\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*\")\])*$/;(function rez(value){var i,item,name,path;if(value&&typeof value==="object"){if(Object.prototype.toString.apply(value)==="[object Array]"){for(i=0;i<value.length;i+=1){item=value[i];if(item&&typeof item==="object"){path=item.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(item)}}}}else{for(name in value){if(typeof value[name]==="object"){item=value[name];if(item){path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}}}}}})($);return $}module.exports={stringify:function stringifyJC(object,replacer,space){return JSON.stringify(decycle(object),replacer,space)},parse:function parseJC($,reviver){return retrocycle(JSON.parse($,reviver))},decycle,retrocycle}},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;(function(root,factory){if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[__webpack_require__(200)],__WEBPACK_AMD_DEFINE_FACTORY__=factory,__WEBPACK_AMD_DEFINE_RESULT__=typeof __WEBPACK_AMD_DEFINE_FACTORY__==="function"?__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__):__WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})(this,(function(_,undefined){"use strict";var mixins={deepMapValues:function(object,callback,propertyPath){propertyPath=propertyPath||"";if(_.isArray(object)){return _.map(object,deepMapValuesIteratee)}else if(_.isObject(object)&&!_.isDate(object)&&!_.isRegExp(object)&&!_.isFunction(object)){return _.extend({},object,_.mapValues(object,deepMapValuesIteratee))}else{return callback(object,propertyPath)}function deepMapValuesIteratee(value,key){var valuePath=propertyPath?propertyPath+"."+key:key;return _.deepMapValues(value,callback,valuePath)}}};_.mixin(mixins);return mixins}))},(module,__unused_webpack_exports,__webpack_require__)=>{var isBuffer=__webpack_require__(214);module.exports=flatten;flatten.flatten=flatten;flatten.unflatten=unflatten;function flatten(target,opts){opts=opts||{};var delimiter=opts.delimiter||".";var maxDepth=opts.maxDepth;var output={};function step(object,prev,currentDepth){currentDepth=currentDepth||1;Object.keys(object).forEach((function(key){var value=object[key];var isarray=opts.safe&&Array.isArray(value);var type=Object.prototype.toString.call(value);var isbuffer=isBuffer(value);var isobject=type==="[object Object]"||type==="[object Array]";var newKey=prev?prev+delimiter+key:key;if(!isarray&&!isbuffer&&isobject&&Object.keys(value).length&&(!opts.maxDepth||currentDepth<maxDepth)){return step(value,newKey,currentDepth+1)}output[newKey]=value}))}step(target);return output}function unflatten(target,opts){opts=opts||{};var delimiter=opts.delimiter||".";var overwrite=opts.overwrite||false;var result={};var isbuffer=isBuffer(target);if(isbuffer||Object.prototype.toString.call(target)!=="[object Object]"){return target}function getkey(key){var parsedKey=Number(key);return isNaN(parsedKey)||key.indexOf(".")!==-1||opts.object?key:parsedKey}var sortedKeys=Object.keys(target).sort((function(keyA,keyB){return keyA.length-keyB.length}));sortedKeys.forEach((function(key){var split=key.split(delimiter);var key1=getkey(split.shift());var key2=getkey(split[0]);var recipient=result;while(key2!==undefined){if(key1==="__proto__"){return}var type=Object.prototype.toString.call(recipient[key1]);var isobject=type==="[object Object]"||type==="[object Array]";if(!overwrite&&!isobject&&typeof recipient[key1]!=="undefined"){return}if(overwrite&&!isobject||!overwrite&&recipient[key1]==null){recipient[key1]=typeof key2==="number"&&!opts.object?[]:{}}recipient=recipient[key1];if(split.length>0){key1=getkey(split.shift());key2=getkey(split[0])}}recipient[key1]=unflatten(target[key],opts)}));return result}},module=>{module.exports=function isBuffer(obj){return obj!=null&&obj.constructor!=null&&typeof obj.constructor.isBuffer==="function"&&obj.constructor.isBuffer(obj)}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var lodash_1=__webpack_require__(200);var deep_map_keys_1=__webpack_require__(216);function deepMapKeys(object,mapFn,options){options=lodash_1.isNil(options)?{}:options;if(!mapFn){throw new Error("mapFn is required")}else if(!lodash_1.isFunction(mapFn)){throw new TypeError("mapFn must be a function")}else if(!lodash_1.isObject(options)){throw new TypeError("options must be an object")}return new deep_map_keys_1.DeepMapKeys(mapFn,options).map(object)}module.exports=deepMapKeys},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";var lodash_1=__webpack_require__(200);var DeepMapKeys=function(){function DeepMapKeys(mapFn,opts){this.mapFn=mapFn;this.opts=opts;this.cache=new WeakMap}DeepMapKeys.prototype.map=function(value){return lodash_1.isArray(value)?this.mapArray(value):lodash_1.isObject(value)?this.mapObject(value):value};DeepMapKeys.prototype.mapArray=function(arr){if(this.cache.has(arr)){return this.cache.get(arr)}var length=arr.length;var result=[];this.cache.set(arr,result);for(var i=0;i<length;i++){result.push(this.map(arr[i]))}return result};DeepMapKeys.prototype.mapObject=function(obj){if(this.cache.has(obj)){return this.cache.get(obj)}var _a=this,mapFn=_a.mapFn,thisArg=_a.opts.thisArg;var result={};this.cache.set(obj,result);for(var key in obj){if(obj.hasOwnProperty(key)){result[mapFn.call(thisArg,key,obj[key])]=this.map(obj[key])}}return result};return DeepMapKeys}();exports.DeepMapKeys=DeepMapKeys},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const arch=__webpack_require__(218);const os=__webpack_require__(18);const osLocale=__webpack_require__(219);const getHostArchitecture=()=>{if(/ia32|x64/.test(process.arch)){return arch().replace("x86","ia32")}return process.arch};module.exports.node={arch:process.arch,node:process.version,osPlatform:os.platform(),osRelease:os.release(),cpuCores:os.cpus().length,totalMemory:os.totalmem(),startFreeMemory:os.freemem(),hostArch:getHostArchitecture(),locale:osLocale.sync()};module.exports.electron=Object.assign({},module.exports.node,{electron:process.versions.electron});module.exports.browser={}},(module,__unused_webpack_exports,__webpack_require__)=>{var cp=__webpack_require__(158);var fs=__webpack_require__(20);var path=__webpack_require__(40);module.exports=function arch(){if(process.arch==="x64"){return"x64"}if(process.platform==="darwin"){return"x64"}if(process.platform==="win32"){var useEnv=false;try{useEnv=!!(process.env.SYSTEMROOT&&fs.statSync(process.env.SYSTEMROOT))}catch(err){}var sysRoot=useEnv?process.env.SYSTEMROOT:"C:\\Windows";var isWOW64=false;try{isWOW64=!!fs.statSync(path.join(sysRoot,"sysnative"))}catch(err){}return isWOW64?"x64":"x86"}if(process.platform==="linux"){var output=cp.execSync("getconf LONG_BIT",{encoding:"utf8"});return output==="64\n"?"x64":"x86"}return"x86"}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const execa=__webpack_require__(220);const lcid=__webpack_require__(251);const mem=__webpack_require__(254);const defaultOpts={spawn:true};const defaultLocale="en_US";function getEnvLocale(env){env=env||process.env;return env.LC_ALL||env.LC_MESSAGES||env.LANG||env.LANGUAGE}function parseLocale(x){const env=x.split("\n").reduce(((env,def)=>{def=def.split("=");env[def[0]]=def[1].replace(/^"|"$/g,"");return env}),{});return getEnvLocale(env)}function getLocale(str){return str&&str.replace(/[.:].*/,"")}function getAppleLocale(){return execa.stdout("defaults",["read","-g","AppleLocale"])}function getAppleLocaleSync(){return execa.sync("defaults",["read","-g","AppleLocale"]).stdout}function getUnixLocale(){if(process.platform==="darwin"){return getAppleLocale()}return execa.stdout("locale").then((stdout=>getLocale(parseLocale(stdout))))}function getUnixLocaleSync(){if(process.platform==="darwin"){return getAppleLocaleSync()}return getLocale(parseLocale(execa.sync("locale").stdout))}function getWinLocale(){return execa.stdout("wmic",["os","get","locale"]).then((stdout=>{const lcidCode=parseInt(stdout.replace("Locale",""),16);return lcid.from(lcidCode)}))}function getWinLocaleSync(){const stdout=execa.sync("wmic",["os","get","locale"]).stdout;const lcidCode=parseInt(stdout.replace("Locale",""),16);return lcid.from(lcidCode)}module.exports=mem((opts=>{opts=opts||defaultOpts;const envLocale=getEnvLocale();let thenable;if(envLocale||opts.spawn===false){thenable=Promise.resolve(getLocale(envLocale))}else if(process.platform==="win32"){thenable=getWinLocale()}else{thenable=getUnixLocale()}return thenable.then((locale=>locale||defaultLocale)).catch((()=>defaultLocale))}));module.exports.sync=mem((opts=>{opts=opts||defaultOpts;const envLocale=getEnvLocale();let res;if(envLocale||opts.spawn===false){res=getLocale(envLocale)}else{try{if(process.platform==="win32"){res=getWinLocaleSync()}else{res=getUnixLocaleSync()}}catch(err){}}return res||defaultLocale}))},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const childProcess=__webpack_require__(158);const util=__webpack_require__(16);const crossSpawn=__webpack_require__(221);const stripEof=__webpack_require__(240);const npmRunPath=__webpack_require__(241);const isStream=__webpack_require__(243);const _getStream=__webpack_require__(244);const pFinally=__webpack_require__(246);const onExit=__webpack_require__(247);const errname=__webpack_require__(249);const stdio=__webpack_require__(250);const TEN_MEGABYTES=1e3*1e3*10;function handleArgs(cmd,args,opts){let parsed;if(opts&&opts.env&&opts.extendEnv!==false){opts.env=Object.assign({},process.env,opts.env)}if(opts&&opts.__winShell===true){delete opts.__winShell;parsed={command:cmd,args,options:opts,file:cmd,original:cmd}}else{parsed=crossSpawn._parse(cmd,args,opts)}opts=Object.assign({maxBuffer:TEN_MEGABYTES,stripEof:true,preferLocal:true,localDir:parsed.options.cwd||process.cwd(),encoding:"utf8",reject:true,cleanup:true},parsed.options);opts.stdio=stdio(opts);if(opts.preferLocal){opts.env=npmRunPath.env(Object.assign({},opts,{cwd:opts.localDir}))}return{cmd:parsed.command,args:parsed.args,opts,parsed}}function handleInput(spawned,opts){const input=opts.input;if(input===null||input===undefined){return}if(isStream(input)){input.pipe(spawned.stdin)}else{spawned.stdin.end(input)}}function handleOutput(opts,val){if(val&&opts.stripEof){val=stripEof(val)}return val}function handleShell(fn,cmd,opts){let file="/bin/sh";let args=["-c",cmd];opts=Object.assign({},opts);if(process.platform==="win32"){opts.__winShell=true;file=process.env.comspec||"cmd.exe";args=["/s","/c",`"${cmd}"`];opts.windowsVerbatimArguments=true}if(opts.shell){file=opts.shell;delete opts.shell}return fn(file,args,opts)}function getStream(process,stream,encoding,maxBuffer){if(!process[stream]){return null}let ret;if(encoding){ret=_getStream(process[stream],{encoding,maxBuffer})}else{ret=_getStream.buffer(process[stream],{maxBuffer})}return ret.catch((err=>{err.stream=stream;err.message=`${stream} ${err.message}`;throw err}))}module.exports=(cmd,args,opts)=>{let joinedCmd=cmd;if(Array.isArray(args)&&args.length>0){joinedCmd+=" "+args.join(" ")}const parsed=handleArgs(cmd,args,opts);const encoding=parsed.opts.encoding;const maxBuffer=parsed.opts.maxBuffer;let spawned;try{spawned=childProcess.spawn(parsed.cmd,parsed.args,parsed.opts)}catch(err){return Promise.reject(err)}let removeExitHandler;if(parsed.opts.cleanup){removeExitHandler=onExit((()=>{spawned.kill()}))}let timeoutId=null;let timedOut=false;const cleanupTimeout=()=>{if(timeoutId){clearTimeout(timeoutId);timeoutId=null}};if(parsed.opts.timeout>0){timeoutId=setTimeout((()=>{timeoutId=null;timedOut=true;spawned.kill(parsed.opts.killSignal)}),parsed.opts.timeout)}const processDone=new Promise((resolve=>{spawned.on("exit",((code,signal)=>{cleanupTimeout();resolve({code,signal})}));spawned.on("error",(err=>{cleanupTimeout();resolve({err})}));if(spawned.stdin){spawned.stdin.on("error",(err=>{cleanupTimeout();resolve({err})}))}}));function destroy(){if(spawned.stdout){spawned.stdout.destroy()}if(spawned.stderr){spawned.stderr.destroy()}}const promise=pFinally(Promise.all([processDone,getStream(spawned,"stdout",encoding,maxBuffer),getStream(spawned,"stderr",encoding,maxBuffer)]).then((arr=>{const result=arr[0];const stdout=arr[1];const stderr=arr[2];let err=result.err;const code=result.code;const signal=result.signal;if(removeExitHandler){removeExitHandler()}if(err||code!==0||signal!==null){if(!err){let output="";if(Array.isArray(parsed.opts.stdio)){if(parsed.opts.stdio[2]!=="inherit"){output+=output.length>0?stderr:`\n${stderr}`}if(parsed.opts.stdio[1]!=="inherit"){output+=`\n${stdout}`}}else if(parsed.opts.stdio!=="inherit"){output=`\n${stderr}${stdout}`}err=new Error(`Command failed: ${joinedCmd}${output}`);err.code=code<0?errname(code):code}err.killed=err.killed||spawned.killed;err.stdout=stdout;err.stderr=stderr;err.failed=true;err.signal=signal||null;err.cmd=joinedCmd;err.timedOut=timedOut;if(!parsed.opts.reject){return err}throw err}return{stdout:handleOutput(parsed.opts,stdout),stderr:handleOutput(parsed.opts,stderr),code:0,failed:false,killed:false,signal:null,cmd:joinedCmd,timedOut:false}})),destroy);crossSpawn._enoent.hookChildProcess(spawned,parsed.parsed);handleInput(spawned,parsed.opts);spawned.then=promise.then.bind(promise);spawned.catch=promise.catch.bind(promise);return spawned};module.exports.stdout=function(){return module.exports.apply(null,arguments).then((x=>x.stdout))};module.exports.stderr=function(){return module.exports.apply(null,arguments).then((x=>x.stderr))};module.exports.shell=(cmd,opts)=>handleShell(module.exports,cmd,opts);module.exports.sync=(cmd,args,opts)=>{const parsed=handleArgs(cmd,args,opts);if(isStream(parsed.opts.input)){throw new TypeError("The `input` option cannot be a stream in sync mode")}const result=childProcess.spawnSync(parsed.cmd,parsed.args,parsed.opts);if(result.error||result.status!==0){throw result.error||new Error(result.stderr===""?result.stdout:result.stderr)}result.stdout=handleOutput(parsed.opts,result.stdout);result.stderr=handleOutput(parsed.opts,result.stderr);return result};module.exports.shellSync=(cmd,opts)=>handleShell(module.exports.sync,cmd,opts);module.exports.spawn=util.deprecate(module.exports,"execa.spawn() is deprecated. Use execa() instead.")},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var cp=__webpack_require__(158);var parse=__webpack_require__(222);var enoent=__webpack_require__(238);var cpSpawnSync=cp.spawnSync;function spawn(command,args,options){var parsed;var spawned;parsed=parse(command,args,options);spawned=cp.spawn(parsed.command,parsed.args,parsed.options);enoent.hookChildProcess(spawned,parsed);return spawned}function spawnSync(command,args,options){var parsed;var result;if(!cpSpawnSync){try{cpSpawnSync=__webpack_require__(239)}catch(ex){throw new Error("In order to use spawnSync on node 0.10 or older, you must "+"install spawn-sync:\n\n"+"  npm install spawn-sync --save")}}parsed=parse(command,args,options);result=cpSpawnSync(parsed.command,parsed.args,parsed.options);result.error=result.error||enoent.verifyENOENTSync(result.status,parsed);return result}module.exports=spawn;module.exports.spawn=spawn;module.exports.sync=spawnSync;module.exports._parse=parse;module.exports._enoent=enoent},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var resolveCommand=__webpack_require__(223);var hasEmptyArgumentBug=__webpack_require__(232);var escapeArgument=__webpack_require__(233);var escapeCommand=__webpack_require__(234);var readShebang=__webpack_require__(235);var isWin=process.platform==="win32";var skipShellRegExp=/\.(?:com|exe)$/i;var supportsShellOption=parseInt(process.version.substr(1).split(".")[0],10)>=6||parseInt(process.version.substr(1).split(".")[0],10)===4&&parseInt(process.version.substr(1).split(".")[1],10)>=8;function parseNonShell(parsed){var shebang;var needsShell;var applyQuotes;if(!isWin){return parsed}parsed.file=resolveCommand(parsed.command);parsed.file=parsed.file||resolveCommand(parsed.command,true);shebang=parsed.file&&readShebang(parsed.file);if(shebang){parsed.args.unshift(parsed.file);parsed.command=shebang;needsShell=hasEmptyArgumentBug||!skipShellRegExp.test(resolveCommand(shebang)||resolveCommand(shebang,true))}else{needsShell=hasEmptyArgumentBug||!skipShellRegExp.test(parsed.file)}if(needsShell){applyQuotes=parsed.command!=="echo";parsed.command=escapeCommand(parsed.command);parsed.args=parsed.args.map((function(arg){return escapeArgument(arg,applyQuotes)}));parsed.args=["/d","/s","/c",'"'+parsed.command+(parsed.args.length?" "+parsed.args.join(" "):"")+'"'];parsed.command=process.env.comspec||"cmd.exe";parsed.options.windowsVerbatimArguments=true}return parsed}function parseShell(parsed){var shellCommand;if(supportsShellOption){return parsed}shellCommand=[parsed.command].concat(parsed.args).join(" ");if(isWin){parsed.command=typeof parsed.options.shell==="string"?parsed.options.shell:process.env.comspec||"cmd.exe";parsed.args=["/d","/s","/c",'"'+shellCommand+'"'];parsed.options.windowsVerbatimArguments=true}else{if(typeof parsed.options.shell==="string"){parsed.command=parsed.options.shell}else if(process.platform==="android"){parsed.command="/system/bin/sh"}else{parsed.command="/bin/sh"}parsed.args=["-c",shellCommand]}return parsed}function parse(command,args,options){var parsed;if(args&&!Array.isArray(args)){options=args;args=null}args=args?args.slice(0):[];options=options||{};parsed={command,args,options,file:undefined,original:command};return options.shell?parseShell(parsed):parseNonShell(parsed)}module.exports=parse},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var path=__webpack_require__(40);var which=__webpack_require__(224);var LRU=__webpack_require__(228);var commandCache=new LRU({max:50,maxAge:30*1e3});function resolveCommand(command,noExtension){var resolved;noExtension=!!noExtension;resolved=commandCache.get(command+"!"+noExtension);if(commandCache.has(command)){return commandCache.get(command)}try{resolved=!noExtension?which.sync(command):which.sync(command,{pathExt:path.delimiter+(process.env.PATHEXT||"")})}catch(e){}commandCache.set(command+"!"+noExtension,resolved);return resolved}module.exports=resolveCommand},(module,__unused_webpack_exports,__webpack_require__)=>{module.exports=which;which.sync=whichSync;var isWindows=process.platform==="win32"||process.env.OSTYPE==="cygwin"||process.env.OSTYPE==="msys";var path=__webpack_require__(40);var COLON=isWindows?";":":";var isexe=__webpack_require__(225);function getNotFoundError(cmd){var er=new Error("not found: "+cmd);er.code="ENOENT";return er}function getPathInfo(cmd,opt){var colon=opt.colon||COLON;var pathEnv=opt.path||process.env.PATH||"";var pathExt=[""];pathEnv=pathEnv.split(colon);var pathExtExe="";if(isWindows){pathEnv.unshift(process.cwd());pathExtExe=opt.pathExt||process.env.PATHEXT||".EXE;.CMD;.BAT;.COM";pathExt=pathExtExe.split(colon);if(cmd.indexOf(".")!==-1&&pathExt[0]!=="")pathExt.unshift("")}if(cmd.match(/\//)||isWindows&&cmd.match(/\\/))pathEnv=[""];return{env:pathEnv,ext:pathExt,extExe:pathExtExe}}function which(cmd,opt,cb){if(typeof opt==="function"){cb=opt;opt={}}var info=getPathInfo(cmd,opt);var pathEnv=info.env;var pathExt=info.ext;var pathExtExe=info.extExe;var found=[];(function F(i,l){if(i===l){if(opt.all&&found.length)return cb(null,found);else return cb(getNotFoundError(cmd))}var pathPart=pathEnv[i];if(pathPart.charAt(0)==='"'&&pathPart.slice(-1)==='"')pathPart=pathPart.slice(1,-1);var p=path.join(pathPart,cmd);if(!pathPart&&/^\.[\\\/]/.test(cmd)){p=cmd.slice(0,2)+p}(function E(ii,ll){if(ii===ll)return F(i+1,l);var ext=pathExt[ii];isexe(p+ext,{pathExt:pathExtExe},(function(er,is){if(!er&&is){if(opt.all)found.push(p+ext);else return cb(null,p+ext)}return E(ii+1,ll)}))})(0,pathExt.length)})(0,pathEnv.length)}function whichSync(cmd,opt){opt=opt||{};var info=getPathInfo(cmd,opt);var pathEnv=info.env;var pathExt=info.ext;var pathExtExe=info.extExe;var found=[];for(var i=0,l=pathEnv.length;i<l;i++){var pathPart=pathEnv[i];if(pathPart.charAt(0)==='"'&&pathPart.slice(-1)==='"')pathPart=pathPart.slice(1,-1);var p=path.join(pathPart,cmd);if(!pathPart&&/^\.[\\\/]/.test(cmd)){p=cmd.slice(0,2)+p}for(var j=0,ll=pathExt.length;j<ll;j++){var cur=p+pathExt[j];var is;try{is=isexe.sync(cur,{pathExt:pathExtExe});if(is){if(opt.all)found.push(cur);else return cur}}catch(ex){}}}if(opt.all&&found.length)return found;if(opt.nothrow)return null;throw getNotFoundError(cmd)}},(module,__unused_webpack_exports,__webpack_require__)=>{var fs=__webpack_require__(20);var core;if(process.platform==="win32"||global.TESTING_WINDOWS){core=__webpack_require__(226)}else{core=__webpack_require__(227)}module.exports=isexe;isexe.sync=sync;function isexe(path,options,cb){if(typeof options==="function"){cb=options;options={}}if(!cb){if(typeof Promise!=="function"){throw new TypeError("callback not provided")}return new Promise((function(resolve,reject){isexe(path,options||{},(function(er,is){if(er){reject(er)}else{resolve(is)}}))}))}core(path,options||{},(function(er,is){if(er){if(er.code==="EACCES"||options&&options.ignoreErrors){er=null;is=false}}cb(er,is)}))}function sync(path,options){try{return core.sync(path,options||{})}catch(er){if(options&&options.ignoreErrors||er.code==="EACCES"){return false}else{throw er}}}},(module,__unused_webpack_exports,__webpack_require__)=>{module.exports=isexe;isexe.sync=sync;var fs=__webpack_require__(20);function checkPathExt(path,options){var pathext=options.pathExt!==undefined?options.pathExt:process.env.PATHEXT;if(!pathext){return true}pathext=pathext.split(";");if(pathext.indexOf("")!==-1){return true}for(var i=0;i<pathext.length;i++){var p=pathext[i].toLowerCase();if(p&&path.substr(-p.length).toLowerCase()===p){return true}}return false}function checkStat(stat,path,options){if(!stat.isSymbolicLink()&&!stat.isFile()){return false}return checkPathExt(path,options)}function isexe(path,options,cb){fs.stat(path,(function(er,stat){cb(er,er?false:checkStat(stat,path,options))}))}function sync(path,options){return checkStat(fs.statSync(path),path,options)}},(module,__unused_webpack_exports,__webpack_require__)=>{module.exports=isexe;isexe.sync=sync;var fs=__webpack_require__(20);function isexe(path,options,cb){fs.stat(path,(function(er,stat){cb(er,er?false:checkStat(stat,options))}))}function sync(path,options){return checkStat(fs.statSync(path),options)}function checkStat(stat,options){return stat.isFile()&&checkMode(stat,options)}function checkMode(stat,options){var mod=stat.mode;var uid=stat.uid;var gid=stat.gid;var myUid=options.uid!==undefined?options.uid:process.getuid&&process.getuid();var myGid=options.gid!==undefined?options.gid:process.getgid&&process.getgid();var u=parseInt("100",8);var g=parseInt("010",8);var o=parseInt("001",8);var ug=u|g;var ret=mod&o||mod&g&&gid===myGid||mod&u&&uid===myUid||mod&ug&&myUid===0;return ret}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";module.exports=LRUCache;var Map=__webpack_require__(229);var util=__webpack_require__(16);var Yallist=__webpack_require__(231);var hasSymbol=typeof Symbol==="function"&&process.env._nodeLRUCacheForceNoSymbol!=="1";var makeSymbol;if(hasSymbol){makeSymbol=function(key){return Symbol(key)}}else{makeSymbol=function(key){return"_"+key}}var MAX=makeSymbol("max");var LENGTH=makeSymbol("length");var LENGTH_CALCULATOR=makeSymbol("lengthCalculator");var ALLOW_STALE=makeSymbol("allowStale");var MAX_AGE=makeSymbol("maxAge");var DISPOSE=makeSymbol("dispose");var NO_DISPOSE_ON_SET=makeSymbol("noDisposeOnSet");var LRU_LIST=makeSymbol("lruList");var CACHE=makeSymbol("cache");function naiveLength(){return 1}function LRUCache(options){if(!(this instanceof LRUCache)){return new LRUCache(options)}if(typeof options==="number"){options={max:options}}if(!options){options={}}var max=this[MAX]=options.max;if(!max||!(typeof max==="number")||max<=0){this[MAX]=Infinity}var lc=options.length||naiveLength;if(typeof lc!=="function"){lc=naiveLength}this[LENGTH_CALCULATOR]=lc;this[ALLOW_STALE]=options.stale||false;this[MAX_AGE]=options.maxAge||0;this[DISPOSE]=options.dispose;this[NO_DISPOSE_ON_SET]=options.noDisposeOnSet||false;this.reset()}Object.defineProperty(LRUCache.prototype,"max",{set:function(mL){if(!mL||!(typeof mL==="number")||mL<=0){mL=Infinity}this[MAX]=mL;trim(this)},get:function(){return this[MAX]},enumerable:true});Object.defineProperty(LRUCache.prototype,"allowStale",{set:function(allowStale){this[ALLOW_STALE]=!!allowStale},get:function(){return this[ALLOW_STALE]},enumerable:true});Object.defineProperty(LRUCache.prototype,"maxAge",{set:function(mA){if(!mA||!(typeof mA==="number")||mA<0){mA=0}this[MAX_AGE]=mA;trim(this)},get:function(){return this[MAX_AGE]},enumerable:true});Object.defineProperty(LRUCache.prototype,"lengthCalculator",{set:function(lC){if(typeof lC!=="function"){lC=naiveLength}if(lC!==this[LENGTH_CALCULATOR]){this[LENGTH_CALCULATOR]=lC;this[LENGTH]=0;this[LRU_LIST].forEach((function(hit){hit.length=this[LENGTH_CALCULATOR](hit.value,hit.key);this[LENGTH]+=hit.length}),this)}trim(this)},get:function(){return this[LENGTH_CALCULATOR]},enumerable:true});Object.defineProperty(LRUCache.prototype,"length",{get:function(){return this[LENGTH]},enumerable:true});Object.defineProperty(LRUCache.prototype,"itemCount",{get:function(){return this[LRU_LIST].length},enumerable:true});LRUCache.prototype.rforEach=function(fn,thisp){thisp=thisp||this;for(var walker=this[LRU_LIST].tail;walker!==null;){var prev=walker.prev;forEachStep(this,fn,walker,thisp);walker=prev}};function forEachStep(self,fn,node,thisp){var hit=node.value;if(isStale(self,hit)){del(self,node);if(!self[ALLOW_STALE]){hit=undefined}}if(hit){fn.call(thisp,hit.value,hit.key,self)}}LRUCache.prototype.forEach=function(fn,thisp){thisp=thisp||this;for(var walker=this[LRU_LIST].head;walker!==null;){var next=walker.next;forEachStep(this,fn,walker,thisp);walker=next}};LRUCache.prototype.keys=function(){return this[LRU_LIST].toArray().map((function(k){return k.key}),this)};LRUCache.prototype.values=function(){return this[LRU_LIST].toArray().map((function(k){return k.value}),this)};LRUCache.prototype.reset=function(){if(this[DISPOSE]&&this[LRU_LIST]&&this[LRU_LIST].length){this[LRU_LIST].forEach((function(hit){this[DISPOSE](hit.key,hit.value)}),this)}this[CACHE]=new Map;this[LRU_LIST]=new Yallist;this[LENGTH]=0};LRUCache.prototype.dump=function(){return this[LRU_LIST].map((function(hit){if(!isStale(this,hit)){return{k:hit.key,v:hit.value,e:hit.now+(hit.maxAge||0)}}}),this).toArray().filter((function(h){return h}))};LRUCache.prototype.dumpLru=function(){return this[LRU_LIST]};LRUCache.prototype.inspect=function(n,opts){var str="LRUCache {";var extras=false;var as=this[ALLOW_STALE];if(as){str+="\n  allowStale: true";extras=true}var max=this[MAX];if(max&&max!==Infinity){if(extras){str+=","}str+="\n  max: "+util.inspect(max,opts);extras=true}var maxAge=this[MAX_AGE];if(maxAge){if(extras){str+=","}str+="\n  maxAge: "+util.inspect(maxAge,opts);extras=true}var lc=this[LENGTH_CALCULATOR];if(lc&&lc!==naiveLength){if(extras){str+=","}str+="\n  length: "+util.inspect(this[LENGTH],opts);extras=true}var didFirst=false;this[LRU_LIST].forEach((function(item){if(didFirst){str+=",\n  "}else{if(extras){str+=",\n"}didFirst=true;str+="\n  "}var key=util.inspect(item.key).split("\n").join("\n  ");var val={value:item.value};if(item.maxAge!==maxAge){val.maxAge=item.maxAge}if(lc!==naiveLength){val.length=item.length}if(isStale(this,item)){val.stale=true}val=util.inspect(val,opts).split("\n").join("\n  ");str+=key+" => "+val}));if(didFirst||extras){str+="\n"}str+="}";return str};LRUCache.prototype.set=function(key,value,maxAge){maxAge=maxAge||this[MAX_AGE];var now=maxAge?Date.now():0;var len=this[LENGTH_CALCULATOR](value,key);if(this[CACHE].has(key)){if(len>this[MAX]){del(this,this[CACHE].get(key));return false}var node=this[CACHE].get(key);var item=node.value;if(this[DISPOSE]){if(!this[NO_DISPOSE_ON_SET]){this[DISPOSE](key,item.value)}}item.now=now;item.maxAge=maxAge;item.value=value;this[LENGTH]+=len-item.length;item.length=len;this.get(key);trim(this);return true}var hit=new Entry(key,value,len,now,maxAge);if(hit.length>this[MAX]){if(this[DISPOSE]){this[DISPOSE](key,value)}return false}this[LENGTH]+=hit.length;this[LRU_LIST].unshift(hit);this[CACHE].set(key,this[LRU_LIST].head);trim(this);return true};LRUCache.prototype.has=function(key){if(!this[CACHE].has(key))return false;var hit=this[CACHE].get(key).value;if(isStale(this,hit)){return false}return true};LRUCache.prototype.get=function(key){return get(this,key,true)};LRUCache.prototype.peek=function(key){return get(this,key,false)};LRUCache.prototype.pop=function(){var node=this[LRU_LIST].tail;if(!node)return null;del(this,node);return node.value};LRUCache.prototype.del=function(key){del(this,this[CACHE].get(key))};LRUCache.prototype.load=function(arr){this.reset();var now=Date.now();for(var l=arr.length-1;l>=0;l--){var hit=arr[l];var expiresAt=hit.e||0;if(expiresAt===0){this.set(hit.k,hit.v)}else{var maxAge=expiresAt-now;if(maxAge>0){this.set(hit.k,hit.v,maxAge)}}}};LRUCache.prototype.prune=function(){var self=this;this[CACHE].forEach((function(value,key){get(self,key,false)}))};function get(self,key,doUse){var node=self[CACHE].get(key);if(node){var hit=node.value;if(isStale(self,hit)){del(self,node);if(!self[ALLOW_STALE])hit=undefined}else{if(doUse){self[LRU_LIST].unshiftNode(node)}}if(hit)hit=hit.value}return hit}function isStale(self,hit){if(!hit||!hit.maxAge&&!self[MAX_AGE]){return false}var stale=false;var diff=Date.now()-hit.now;if(hit.maxAge){stale=diff>hit.maxAge}else{stale=self[MAX_AGE]&&diff>self[MAX_AGE]}return stale}function trim(self){if(self[LENGTH]>self[MAX]){for(var walker=self[LRU_LIST].tail;self[LENGTH]>self[MAX]&&walker!==null;){var prev=walker.prev;del(self,walker);walker=prev}}}function del(self,node){if(node){var hit=node.value;if(self[DISPOSE]){self[DISPOSE](hit.key,hit.value)}self[LENGTH]-=hit.length;self[CACHE].delete(hit.key);self[LRU_LIST].removeNode(node)}}function Entry(key,value,length,now,maxAge){this.key=key;this.value=value;this.length=length;this.now=now;this.maxAge=maxAge||0}},(module,__unused_webpack_exports,__webpack_require__)=>{if(process.env.npm_package_name==="pseudomap"&&process.env.npm_lifecycle_script==="test")process.env.TEST_PSEUDOMAP="true";if(typeof Map==="function"&&!process.env.TEST_PSEUDOMAP){module.exports=Map}else{module.exports=__webpack_require__(230)}},module=>{var hasOwnProperty=Object.prototype.hasOwnProperty;module.exports=PseudoMap;function PseudoMap(set){if(!(this instanceof PseudoMap))throw new TypeError("Constructor PseudoMap requires 'new'");this.clear();if(set){if(set instanceof PseudoMap||typeof Map==="function"&&set instanceof Map)set.forEach((function(value,key){this.set(key,value)}),this);else if(Array.isArray(set))set.forEach((function(kv){this.set(kv[0],kv[1])}),this);else throw new TypeError("invalid argument")}}PseudoMap.prototype.forEach=function(fn,thisp){thisp=thisp||this;Object.keys(this._data).forEach((function(k){if(k!=="size")fn.call(thisp,this._data[k].value,this._data[k].key)}),this)};PseudoMap.prototype.has=function(k){return!!find(this._data,k)};PseudoMap.prototype.get=function(k){var res=find(this._data,k);return res&&res.value};PseudoMap.prototype.set=function(k,v){set(this._data,k,v)};PseudoMap.prototype.delete=function(k){var res=find(this._data,k);if(res){delete this._data[res._index];this._data.size--}};PseudoMap.prototype.clear=function(){var data=Object.create(null);data.size=0;Object.defineProperty(this,"_data",{value:data,enumerable:false,configurable:true,writable:false})};Object.defineProperty(PseudoMap.prototype,"size",{get:function(){return this._data.size},set:function(n){},enumerable:true,configurable:true});PseudoMap.prototype.values=PseudoMap.prototype.keys=PseudoMap.prototype.entries=function(){throw new Error("iterators are not implemented in this version")};function same(a,b){return a===b||a!==a&&b!==b}function Entry(k,v,i){this.key=k;this.value=v;this._index=i}function find(data,k){for(var i=0,s="_"+k,key=s;hasOwnProperty.call(data,key);key=s+i++){if(same(data[key].key,k))return data[key]}}function set(data,k,v){for(var i=0,s="_"+k,key=s;hasOwnProperty.call(data,key);key=s+i++){if(same(data[key].key,k)){data[key].value=v;return}}data.size++;data[key]=new Entry(k,v,key)}},module=>{module.exports=Yallist;Yallist.Node=Node;Yallist.create=Yallist;function Yallist(list){var self=this;if(!(self instanceof Yallist)){self=new Yallist}self.tail=null;self.head=null;self.length=0;if(list&&typeof list.forEach==="function"){list.forEach((function(item){self.push(item)}))}else if(arguments.length>0){for(var i=0,l=arguments.length;i<l;i++){self.push(arguments[i])}}return self}Yallist.prototype.removeNode=function(node){if(node.list!==this){throw new Error("removing node which does not belong to this list")}var next=node.next;var prev=node.prev;if(next){next.prev=prev}if(prev){prev.next=next}if(node===this.head){this.head=next}if(node===this.tail){this.tail=prev}node.list.length--;node.next=null;node.prev=null;node.list=null};Yallist.prototype.unshiftNode=function(node){if(node===this.head){return}if(node.list){node.list.removeNode(node)}var head=this.head;node.list=this;node.next=head;if(head){head.prev=node}this.head=node;if(!this.tail){this.tail=node}this.length++};Yallist.prototype.pushNode=function(node){if(node===this.tail){return}if(node.list){node.list.removeNode(node)}var tail=this.tail;node.list=this;node.prev=tail;if(tail){tail.next=node}this.tail=node;if(!this.head){this.head=node}this.length++};Yallist.prototype.push=function(){for(var i=0,l=arguments.length;i<l;i++){push(this,arguments[i])}return this.length};Yallist.prototype.unshift=function(){for(var i=0,l=arguments.length;i<l;i++){unshift(this,arguments[i])}return this.length};Yallist.prototype.pop=function(){if(!this.tail){return undefined}var res=this.tail.value;this.tail=this.tail.prev;if(this.tail){this.tail.next=null}else{this.head=null}this.length--;return res};Yallist.prototype.shift=function(){if(!this.head){return undefined}var res=this.head.value;this.head=this.head.next;if(this.head){this.head.prev=null}else{this.tail=null}this.length--;return res};Yallist.prototype.forEach=function(fn,thisp){thisp=thisp||this;for(var walker=this.head,i=0;walker!==null;i++){fn.call(thisp,walker.value,i,this);walker=walker.next}};Yallist.prototype.forEachReverse=function(fn,thisp){thisp=thisp||this;for(var walker=this.tail,i=this.length-1;walker!==null;i--){fn.call(thisp,walker.value,i,this);walker=walker.prev}};Yallist.prototype.get=function(n){for(var i=0,walker=this.head;walker!==null&&i<n;i++){walker=walker.next}if(i===n&&walker!==null){return walker.value}};Yallist.prototype.getReverse=function(n){for(var i=0,walker=this.tail;walker!==null&&i<n;i++){walker=walker.prev}if(i===n&&walker!==null){return walker.value}};Yallist.prototype.map=function(fn,thisp){thisp=thisp||this;var res=new Yallist;for(var walker=this.head;walker!==null;){res.push(fn.call(thisp,walker.value,this));walker=walker.next}return res};Yallist.prototype.mapReverse=function(fn,thisp){thisp=thisp||this;var res=new Yallist;for(var walker=this.tail;walker!==null;){res.push(fn.call(thisp,walker.value,this));walker=walker.prev}return res};Yallist.prototype.reduce=function(fn,initial){var acc;var walker=this.head;if(arguments.length>1){acc=initial}else if(this.head){walker=this.head.next;acc=this.head.value}else{throw new TypeError("Reduce of empty list with no initial value")}for(var i=0;walker!==null;i++){acc=fn(acc,walker.value,i);walker=walker.next}return acc};Yallist.prototype.reduceReverse=function(fn,initial){var acc;var walker=this.tail;if(arguments.length>1){acc=initial}else if(this.tail){walker=this.tail.prev;acc=this.tail.value}else{throw new TypeError("Reduce of empty list with no initial value")}for(var i=this.length-1;walker!==null;i--){acc=fn(acc,walker.value,i);walker=walker.prev}return acc};Yallist.prototype.toArray=function(){var arr=new Array(this.length);for(var i=0,walker=this.head;walker!==null;i++){arr[i]=walker.value;walker=walker.next}return arr};Yallist.prototype.toArrayReverse=function(){var arr=new Array(this.length);for(var i=0,walker=this.tail;walker!==null;i++){arr[i]=walker.value;walker=walker.prev}return arr};Yallist.prototype.slice=function(from,to){to=to||this.length;if(to<0){to+=this.length}from=from||0;if(from<0){from+=this.length}var ret=new Yallist;if(to<from||to<0){return ret}if(from<0){from=0}if(to>this.length){to=this.length}for(var i=0,walker=this.head;walker!==null&&i<from;i++){walker=walker.next}for(;walker!==null&&i<to;i++,walker=walker.next){ret.push(walker.value)}return ret};Yallist.prototype.sliceReverse=function(from,to){to=to||this.length;if(to<0){to+=this.length}from=from||0;if(from<0){from+=this.length}var ret=new Yallist;if(to<from||to<0){return ret}if(from<0){from=0}if(to>this.length){to=this.length}for(var i=this.length,walker=this.tail;walker!==null&&i>to;i--){walker=walker.prev}for(;walker!==null&&i>from;i--,walker=walker.prev){ret.push(walker.value)}return ret};Yallist.prototype.reverse=function(){var head=this.head;var tail=this.tail;for(var walker=head;walker!==null;walker=walker.prev){var p=walker.prev;walker.prev=walker.next;walker.next=p}this.head=tail;this.tail=head;return this};function push(self,item){self.tail=new Node(item,self.tail,null,self);if(!self.head){self.head=self.tail}self.length++}function unshift(self,item){self.head=new Node(item,null,self.head,self);if(!self.tail){self.tail=self.head}self.length++}function Node(value,prev,next,list){if(!(this instanceof Node)){return new Node(value,prev,next,list)}this.list=list;this.value=value;if(prev){prev.next=this;this.prev=prev}else{this.prev=null}if(next){next.prev=this;this.next=next}else{this.next=null}}},module=>{"use strict";function hasEmptyArgumentBug(){var nodeVer;if(process.platform!=="win32"){return false}nodeVer=process.version.substr(1).split(".").map((function(num){return parseInt(num,10)}));return nodeVer[0]===0&&nodeVer[1]<12}module.exports=hasEmptyArgumentBug()},module=>{"use strict";function escapeArgument(arg,quote){arg=""+arg;if(!quote){arg=arg.replace(/([()%!^<>&|;,"'\s])/g,"^$1")}else{arg=arg.replace(/(\\*)"/g,'$1$1\\"');arg=arg.replace(/(\\*)$/,"$1$1");arg='"'+arg+'"'}return arg}module.exports=escapeArgument},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var escapeArgument=__webpack_require__(233);function escapeCommand(command){return/^[a-z0-9_-]+$/i.test(command)?command:escapeArgument(command,true)}module.exports=escapeCommand},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var fs=__webpack_require__(20);var LRU=__webpack_require__(228);var shebangCommand=__webpack_require__(236);var shebangCache=new LRU({max:50,maxAge:30*1e3});function readShebang(command){var buffer;var fd;var shebang;if(shebangCache.has(command)){return shebangCache.get(command)}buffer=new Buffer(150);try{fd=fs.openSync(command,"r");fs.readSync(fd,buffer,0,150,0);fs.closeSync(fd)}catch(e){}shebang=shebangCommand(buffer.toString());shebangCache.set(command,shebang);return shebang}module.exports=readShebang},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var shebangRegex=__webpack_require__(237);module.exports=function(str){var match=str.match(shebangRegex);if(!match){return null}var arr=match[0].replace(/#! ?/,"").split(" ");var bin=arr[0].split("/").pop();var arg=arr[1];return bin==="env"?arg:bin+(arg?" "+arg:"")}},module=>{"use strict";module.exports=/^#!.*/},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";var isWin=process.platform==="win32";var resolveCommand=__webpack_require__(223);var isNode10=process.version.indexOf("v0.10.")===0;function notFoundError(command,syscall){var err;err=new Error(syscall+" "+command+" ENOENT");err.code=err.errno="ENOENT";err.syscall=syscall+" "+command;return err}function hookChildProcess(cp,parsed){var originalEmit;if(!isWin){return}originalEmit=cp.emit;cp.emit=function(name,arg1){var err;if(name==="exit"){err=verifyENOENT(arg1,parsed,"spawn");if(err){return originalEmit.call(cp,"error",err)}}return originalEmit.apply(cp,arguments)}}function verifyENOENT(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawn")}return null}function verifyENOENTSync(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawnSync")}if(isNode10&&status===-1){parsed.file=isWin?parsed.file:resolveCommand(parsed.original);if(!parsed.file){return notFoundError(parsed.original,"spawnSync")}}return null}module.exports.hookChildProcess=hookChildProcess;module.exports.verifyENOENT=verifyENOENT;module.exports.verifyENOENTSync=verifyENOENTSync;module.exports.notFoundError=notFoundError},module=>{"use strict";if(typeof{}==="undefined"){var e=new Error("Cannot find module '{}'");e.code="MODULE_NOT_FOUND";throw e}module.exports={}},module=>{"use strict";module.exports=function(x){var lf=typeof x==="string"?"\n":"\n".charCodeAt();var cr=typeof x==="string"?"\r":"\r".charCodeAt();if(x[x.length-1]===lf){x=x.slice(0,x.length-1)}if(x[x.length-1]===cr){x=x.slice(0,x.length-1)}return x}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const path=__webpack_require__(40);const pathKey=__webpack_require__(242);module.exports=opts=>{opts=Object.assign({cwd:process.cwd(),path:process.env[pathKey()]},opts);let prev;let pth=path.resolve(opts.cwd);const ret=[];while(prev!==pth){ret.push(path.join(pth,"node_modules/.bin"));prev=pth;pth=path.resolve(pth,"..")}ret.push(path.dirname(process.execPath));return ret.concat(opts.path).join(path.delimiter)};module.exports.env=opts=>{opts=Object.assign({env:process.env},opts);const env=Object.assign({},opts.env);const path=pathKey({env});opts.path=env[path];env[path]=module.exports(opts);return env}},module=>{"use strict";module.exports=opts=>{opts=opts||{};const env=opts.env||process.env;const platform=opts.platform||process.platform;if(platform!=="win32"){return"PATH"}return Object.keys(env).find((x=>x.toUpperCase()==="PATH"))||"Path"}},module=>{"use strict";var isStream=module.exports=function(stream){return stream!==null&&typeof stream==="object"&&typeof stream.pipe==="function"};isStream.writable=function(stream){return isStream(stream)&&stream.writable!==false&&typeof stream._write==="function"&&typeof stream._writableState==="object"};isStream.readable=function(stream){return isStream(stream)&&stream.readable!==false&&typeof stream._read==="function"&&typeof stream._readableState==="object"};isStream.duplex=function(stream){return isStream.writable(stream)&&isStream.readable(stream)};isStream.transform=function(stream){return isStream.duplex(stream)&&typeof stream._transform==="function"&&typeof stream._transformState==="object"}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const bufferStream=__webpack_require__(245);function getStream(inputStream,opts){if(!inputStream){return Promise.reject(new Error("Expected a stream"))}opts=Object.assign({maxBuffer:Infinity},opts);const maxBuffer=opts.maxBuffer;let stream;let clean;const p=new Promise(((resolve,reject)=>{const error=err=>{if(err){err.bufferedData=stream.getBufferedValue()}reject(err)};stream=bufferStream(opts);inputStream.once("error",error);inputStream.pipe(stream);stream.on("data",(()=>{if(stream.getBufferedLength()>maxBuffer){reject(new Error("maxBuffer exceeded"))}}));stream.once("error",error);stream.on("end",resolve);clean=()=>{if(inputStream.unpipe){inputStream.unpipe(stream)}}}));p.then(clean,clean);return p.then((()=>stream.getBufferedValue()))}module.exports=getStream;module.exports.buffer=(stream,opts)=>getStream(stream,Object.assign({},opts,{encoding:"buffer"}));module.exports.array=(stream,opts)=>getStream(stream,Object.assign({},opts,{array:true}))},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const PassThrough=__webpack_require__(21).PassThrough;module.exports=opts=>{opts=Object.assign({},opts);const array=opts.array;let encoding=opts.encoding;const buffer=encoding==="buffer";let objectMode=false;if(array){objectMode=!(encoding||buffer)}else{encoding=encoding||"utf8"}if(buffer){encoding=null}let len=0;const ret=[];const stream=new PassThrough({objectMode});if(encoding){stream.setEncoding(encoding)}stream.on("data",(chunk=>{ret.push(chunk);if(objectMode){len=ret.length}else{len+=chunk.length}}));stream.getBufferedValue=()=>{if(array){return ret}return buffer?Buffer.concat(ret,len):ret.join("")};stream.getBufferedLength=()=>len;return stream}},module=>{"use strict";module.exports=(promise,onFinally)=>{onFinally=onFinally||(()=>{});return promise.then((val=>new Promise((resolve=>{resolve(onFinally())})).then((()=>val))),(err=>new Promise((resolve=>{resolve(onFinally())})).then((()=>{throw err}))))}},(module,__unused_webpack_exports,__webpack_require__)=>{var process=global.process;const processOk=function(process){return process&&typeof process==="object"&&typeof process.removeListener==="function"&&typeof process.emit==="function"&&typeof process.reallyExit==="function"&&typeof process.listeners==="function"&&typeof process.kill==="function"&&typeof process.pid==="number"&&typeof process.on==="function"};if(!processOk(process)){module.exports=function(){}}else{var assert=__webpack_require__(37);var signals=__webpack_require__(248);var isWin=/^win/i.test(process.platform);var EE=__webpack_require__(7);if(typeof EE!=="function"){EE=EE.EventEmitter}var emitter;if(process.__signal_exit_emitter__){emitter=process.__signal_exit_emitter__}else{emitter=process.__signal_exit_emitter__=new EE;emitter.count=0;emitter.emitted={}}if(!emitter.infinite){emitter.setMaxListeners(Infinity);emitter.infinite=true}module.exports=function(cb,opts){if(!processOk(global.process)){return}assert.equal(typeof cb,"function","a callback must be provided for exit handler");if(loaded===false){load()}var ev="exit";if(opts&&opts.alwaysLast){ev="afterexit"}var remove=function(){emitter.removeListener(ev,cb);if(emitter.listeners("exit").length===0&&emitter.listeners("afterexit").length===0){unload()}};emitter.on(ev,cb);return remove};var unload=function unload(){if(!loaded||!processOk(global.process)){return}loaded=false;signals.forEach((function(sig){try{process.removeListener(sig,sigListeners[sig])}catch(er){}}));process.emit=originalProcessEmit;process.reallyExit=originalProcessReallyExit;emitter.count-=1};module.exports.unload=unload;var emit=function emit(event,code,signal){if(emitter.emitted[event]){return}emitter.emitted[event]=true;emitter.emit(event,code,signal)};var sigListeners={};signals.forEach((function(sig){sigListeners[sig]=function listener(){if(!processOk(global.process)){return}var listeners=process.listeners(sig);if(listeners.length===emitter.count){unload();emit("exit",null,sig);emit("afterexit",null,sig);if(isWin&&sig==="SIGHUP"){sig="SIGINT"}process.kill(process.pid,sig)}}}));module.exports.signals=function(){return signals};var loaded=false;var load=function load(){if(loaded||!processOk(global.process)){return}loaded=true;emitter.count+=1;signals=signals.filter((function(sig){try{process.on(sig,sigListeners[sig]);return true}catch(er){return false}}));process.emit=processEmit;process.reallyExit=processReallyExit};module.exports.load=load;var originalProcessReallyExit=process.reallyExit;var processReallyExit=function processReallyExit(code){if(!processOk(global.process)){return}process.exitCode=code||0;emit("exit",process.exitCode,null);emit("afterexit",process.exitCode,null);originalProcessReallyExit.call(process,process.exitCode)};var originalProcessEmit=process.emit;var processEmit=function processEmit(ev,arg){if(ev==="exit"&&processOk(global.process)){if(arg!==undefined){process.exitCode=arg}var ret=originalProcessEmit.apply(this,arguments);emit("exit",process.exitCode,null);emit("afterexit",process.exitCode,null);return ret}else{return originalProcessEmit.apply(this,arguments)}}}},module=>{module.exports=["SIGABRT","SIGALRM","SIGHUP","SIGINT","SIGTERM"];if(process.platform!=="win32"){module.exports.push("SIGVTALRM","SIGXCPU","SIGXFSZ","SIGUSR2","SIGTRAP","SIGSYS","SIGQUIT","SIGIOT")}if(process.platform==="linux"){module.exports.push("SIGIO","SIGPOLL","SIGPWR","SIGSTKFLT","SIGUNUSED")}},module=>{"use strict";let uv;try{uv=process.binding("uv");if(typeof uv.errname!=="function"){throw new TypeError("uv.errname is not a function")}}catch(err){console.error("execa/lib/errname: unable to establish process.binding('uv')",err);uv=null}function errname(uv,code){if(uv){return uv.errname(code)}if(!(code<0)){throw new Error("err >= 0")}return`Unknown system error ${code}`}module.exports=code=>errname(uv,code);module.exports.__test__=errname},module=>{"use strict";const alias=["stdin","stdout","stderr"];const hasAlias=opts=>alias.some((x=>Boolean(opts[x])));module.exports=opts=>{if(!opts){return null}if(opts.stdio&&hasAlias(opts)){throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${alias.map((x=>`\`${x}\``)).join(", ")}`)}if(typeof opts.stdio==="string"){return opts.stdio}const stdio=opts.stdio||[];if(!Array.isArray(stdio)){throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``)}const result=[];const len=Math.max(stdio.length,alias.length);for(let i=0;i<len;i++){let value=null;if(stdio[i]!==undefined){value=stdio[i]}else if(opts[alias[i]]!==undefined){value=opts[alias[i]]}result[i]=value}return result}},(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";var invertKv=__webpack_require__(252);var all=__webpack_require__(253);var inverted=invertKv(all);exports.from=function(lcidCode){if(typeof lcidCode!=="number"){throw new TypeError("Expected a number")}return inverted[lcidCode]};exports.to=function(localeId){if(typeof localeId!=="string"){throw new TypeError("Expected a string")}return all[localeId]};exports.all=all},module=>{"use strict";module.exports=function(obj){if(typeof obj!=="object"){throw new TypeError("Expected an object")}var ret={};for(var key in obj){var val=obj[key];ret[val]=key}return ret}},module=>{"use strict";module.exports=JSON.parse('{"af_ZA":1078,"am_ET":1118,"ar_AE":14337,"ar_BH":15361,"ar_DZ":5121,"ar_EG":3073,"ar_IQ":2049,"ar_JO":11265,"ar_KW":13313,"ar_LB":12289,"ar_LY":4097,"ar_MA":6145,"ar_OM":8193,"ar_QA":16385,"ar_SA":1025,"ar_SY":10241,"ar_TN":7169,"ar_YE":9217,"arn_CL":1146,"as_IN":1101,"az_AZ":2092,"ba_RU":1133,"be_BY":1059,"bg_BG":1026,"bn_IN":1093,"bo_BT":2129,"bo_CN":1105,"br_FR":1150,"bs_BA":8218,"ca_ES":1027,"co_FR":1155,"cs_CZ":1029,"cy_GB":1106,"da_DK":1030,"de_AT":3079,"de_CH":2055,"de_DE":1031,"de_LI":5127,"de_LU":4103,"div_MV":1125,"dsb_DE":2094,"el_GR":1032,"en_AU":3081,"en_BZ":10249,"en_CA":4105,"en_CB":9225,"en_GB":2057,"en_IE":6153,"en_IN":18441,"en_JA":8201,"en_MY":17417,"en_NZ":5129,"en_PH":13321,"en_TT":11273,"en_US":1033,"en_ZA":7177,"en_ZW":12297,"es_AR":11274,"es_BO":16394,"es_CL":13322,"es_CO":9226,"es_CR":5130,"es_DO":7178,"es_EC":12298,"es_ES":3082,"es_GT":4106,"es_HN":18442,"es_MX":2058,"es_NI":19466,"es_PA":6154,"es_PE":10250,"es_PR":20490,"es_PY":15370,"es_SV":17418,"es_UR":14346,"es_US":21514,"es_VE":8202,"et_EE":1061,"eu_ES":1069,"fa_IR":1065,"fi_FI":1035,"fil_PH":1124,"fo_FO":1080,"fr_BE":2060,"fr_CA":3084,"fr_CH":4108,"fr_FR":1036,"fr_LU":5132,"fr_MC":6156,"fy_NL":1122,"ga_IE":2108,"gbz_AF":1164,"gl_ES":1110,"gsw_FR":1156,"gu_IN":1095,"ha_NG":1128,"he_IL":1037,"hi_IN":1081,"hr_BA":4122,"hr_HR":1050,"hu_HU":1038,"hy_AM":1067,"id_ID":1057,"ii_CN":1144,"is_IS":1039,"it_CH":2064,"it_IT":1040,"iu_CA":2141,"ja_JP":1041,"ka_GE":1079,"kh_KH":1107,"kk_KZ":1087,"kl_GL":1135,"kn_IN":1099,"ko_KR":1042,"kok_IN":1111,"ky_KG":1088,"lb_LU":1134,"lo_LA":1108,"lt_LT":1063,"lv_LV":1062,"mi_NZ":1153,"mk_MK":1071,"ml_IN":1100,"mn_CN":2128,"mn_MN":1104,"moh_CA":1148,"mr_IN":1102,"ms_BN":2110,"ms_MY":1086,"mt_MT":1082,"my_MM":1109,"nb_NO":1044,"ne_NP":1121,"nl_BE":2067,"nl_NL":1043,"nn_NO":2068,"ns_ZA":1132,"oc_FR":1154,"or_IN":1096,"pa_IN":1094,"pl_PL":1045,"ps_AF":1123,"pt_BR":1046,"pt_PT":2070,"qut_GT":1158,"quz_BO":1131,"quz_EC":2155,"quz_PE":3179,"rm_CH":1047,"ro_RO":1048,"ru_RU":1049,"rw_RW":1159,"sa_IN":1103,"sah_RU":1157,"se_FI":3131,"se_NO":1083,"se_SE":2107,"si_LK":1115,"sk_SK":1051,"sl_SI":1060,"sma_NO":6203,"sma_SE":7227,"smj_NO":4155,"smj_SE":5179,"smn_FI":9275,"sms_FI":8251,"sq_AL":1052,"sr_BA":7194,"sr_SP":3098,"sv_FI":2077,"sv_SE":1053,"sw_KE":1089,"syr_SY":1114,"ta_IN":1097,"te_IN":1098,"tg_TJ":1064,"th_TH":1054,"tk_TM":1090,"tmz_DZ":2143,"tn_ZA":1074,"tr_TR":1055,"tt_RU":1092,"ug_CN":1152,"uk_UA":1058,"ur_IN":2080,"ur_PK":1056,"uz_UZ":2115,"vi_VN":1066,"wen_DE":1070,"wo_SN":1160,"xh_ZA":1076,"yo_NG":1130,"zh_CHS":4,"zh_CHT":31748,"zh_CN":2052,"zh_HK":3076,"zh_MO":5124,"zh_SG":4100,"zh_TW":1028,"zu_ZA":1077}')},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const mimicFn=__webpack_require__(255);const cacheStore=new WeakMap;const defaultCacheKey=function(x){if(arguments.length===1&&(x===null||x===undefined||typeof x!=="function"&&typeof x!=="object")){return x}return JSON.stringify(arguments)};module.exports=(fn,opts)=>{opts=Object.assign({cacheKey:defaultCacheKey,cache:new Map},opts);const memoized=function(){const cache=cacheStore.get(memoized);const key=opts.cacheKey.apply(null,arguments);if(cache.has(key)){const c=cache.get(key);if(typeof opts.maxAge!=="number"||Date.now()<c.maxAge){return c.data}}const ret=fn.apply(null,arguments);cache.set(key,{data:ret,maxAge:Date.now()+(opts.maxAge||0)});return ret};mimicFn(memoized,fn);cacheStore.set(memoized,opts.cache);return memoized};module.exports.clear=fn=>{const cache=cacheStore.get(fn);if(cache&&typeof cache.clear==="function"){cache.clear()}}},module=>{"use strict";module.exports=(to,from)=>{for(const prop of Object.getOwnPropertyNames(from).concat(Object.getOwnPropertySymbols(from))){Object.defineProperty(to,prop,Object.getOwnPropertyDescriptor(from,prop))}return to}},(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const _=__webpack_require__(200);const detect=__webpack_require__(206);const defaultContext=__webpack_require__(217);const utils=__webpack_require__(210);const env=detect.getName();module.exports=SentryLib=>{const properties={installed:false,enabled:true};return{isInstalled:()=>properties.installed,install:(dsn,config)=>{if(properties.installed){throw new Error("Sentry already installed")}const sentryConfig=_.cloneDeep(config);const transport=SentryLib.transports&&SentryLib.transports.https;_.defaults(sentryConfig,{autoBreadcrumbs:true,allowSecretKey:true,dataCallback:utils.hideAbsolutePathsInObject,transport});_.merge(sentryConfig,{extra:defaultContext[env]});properties.client=SentryLib.config(dsn,sentryConfig).install();properties.installed=true},uninstall:()=>{if(!properties.installed){throw new Error("Sentry not installed")}properties.client.uninstall();properties.installed=false},captureException:exception=>{if(!properties.installed){throw new Error("Sentry not installed")}properties.client.captureException(exception)}}}},function(module){(function(global,factory){true?module.exports=factory():0})(this,(function(){"use strict";var SLICE$0=Array.prototype.slice;function createClass(ctor,superClass){if(superClass){ctor.prototype=Object.create(superClass.prototype)}ctor.prototype.constructor=ctor}function Iterable(value){return isIterable(value)?value:Seq(value)}createClass(KeyedIterable,Iterable);function KeyedIterable(value){return isKeyed(value)?value:KeyedSeq(value)}createClass(IndexedIterable,Iterable);function IndexedIterable(value){return isIndexed(value)?value:IndexedSeq(value)}createClass(SetIterable,Iterable);function SetIterable(value){return isIterable(value)&&!isAssociative(value)?value:SetSeq(value)}function isIterable(maybeIterable){return!!(maybeIterable&&maybeIterable[IS_ITERABLE_SENTINEL])}function isKeyed(maybeKeyed){return!!(maybeKeyed&&maybeKeyed[IS_KEYED_SENTINEL])}function isIndexed(maybeIndexed){return!!(maybeIndexed&&maybeIndexed[IS_INDEXED_SENTINEL])}function isAssociative(maybeAssociative){return isKeyed(maybeAssociative)||isIndexed(maybeAssociative)}function isOrdered(maybeOrdered){return!!(maybeOrdered&&maybeOrdered[IS_ORDERED_SENTINEL])}Iterable.isIterable=isIterable;Iterable.isKeyed=isKeyed;Iterable.isIndexed=isIndexed;Iterable.isAssociative=isAssociative;Iterable.isOrdered=isOrdered;Iterable.Keyed=KeyedIterable;Iterable.Indexed=IndexedIterable;Iterable.Set=SetIterable;var IS_ITERABLE_SENTINEL="@@__IMMUTABLE_ITERABLE__@@";var IS_KEYED_SENTINEL="@@__IMMUTABLE_KEYED__@@";var IS_INDEXED_SENTINEL="@@__IMMUTABLE_INDEXED__@@";var IS_ORDERED_SENTINEL="@@__IMMUTABLE_ORDERED__@@";var DELETE="delete";var SHIFT=5;var SIZE=1<<SHIFT;var MASK=SIZE-1;var NOT_SET={};var CHANGE_LENGTH={value:false};var DID_ALTER={value:false};function MakeRef(ref){ref.value=false;return ref}function SetRef(ref){ref&&(ref.value=true)}function OwnerID(){}function arrCopy(arr,offset){offset=offset||0;var len=Math.max(0,arr.length-offset);var newArr=new Array(len);for(var ii=0;ii<len;ii++){newArr[ii]=arr[ii+offset]}return newArr}function ensureSize(iter){if(iter.size===undefined){iter.size=iter.__iterate(returnTrue)}return iter.size}function wrapIndex(iter,index){if(typeof index!=="number"){var uint32Index=index>>>0;if(""+uint32Index!==index||uint32Index===4294967295){return NaN}index=uint32Index}return index<0?ensureSize(iter)+index:index}function returnTrue(){return true}function wholeSlice(begin,end,size){return(begin===0||size!==undefined&&begin<=-size)&&(end===undefined||size!==undefined&&end>=size)}function resolveBegin(begin,size){return resolveIndex(begin,size,0)}function resolveEnd(end,size){return resolveIndex(end,size,size)}function resolveIndex(index,size,defaultIndex){return index===undefined?defaultIndex:index<0?Math.max(0,size+index):size===undefined?index:Math.min(size,index)}var ITERATE_KEYS=0;var ITERATE_VALUES=1;var ITERATE_ENTRIES=2;var REAL_ITERATOR_SYMBOL=typeof Symbol==="function"&&Symbol.iterator;var FAUX_ITERATOR_SYMBOL="@@iterator";var ITERATOR_SYMBOL=REAL_ITERATOR_SYMBOL||FAUX_ITERATOR_SYMBOL;function Iterator(next){this.next=next}Iterator.prototype.toString=function(){return"[Iterator]"};Iterator.KEYS=ITERATE_KEYS;Iterator.VALUES=ITERATE_VALUES;Iterator.ENTRIES=ITERATE_ENTRIES;Iterator.prototype.inspect=Iterator.prototype.toSource=function(){return this.toString()};Iterator.prototype[ITERATOR_SYMBOL]=function(){return this};function iteratorValue(type,k,v,iteratorResult){var value=type===0?k:type===1?v:[k,v];iteratorResult?iteratorResult.value=value:iteratorResult={value,done:false};return iteratorResult}function iteratorDone(){return{value:undefined,done:true}}function hasIterator(maybeIterable){return!!getIteratorFn(maybeIterable)}function isIterator(maybeIterator){return maybeIterator&&typeof maybeIterator.next==="function"}function getIterator(iterable){var iteratorFn=getIteratorFn(iterable);return iteratorFn&&iteratorFn.call(iterable)}function getIteratorFn(iterable){var iteratorFn=iterable&&(REAL_ITERATOR_SYMBOL&&iterable[REAL_ITERATOR_SYMBOL]||iterable[FAUX_ITERATOR_SYMBOL]);if(typeof iteratorFn==="function"){return iteratorFn}}function isArrayLike(value){return value&&typeof value.length==="number"}createClass(Seq,Iterable);function Seq(value){return value===null||value===undefined?emptySequence():isIterable(value)?value.toSeq():seqFromValue(value)}Seq.of=function(){return Seq(arguments)};Seq.prototype.toSeq=function(){return this};Seq.prototype.toString=function(){return this.__toString("Seq {","}")};Seq.prototype.cacheResult=function(){if(!this._cache&&this.__iterateUncached){this._cache=this.entrySeq().toArray();this.size=this._cache.length}return this};Seq.prototype.__iterate=function(fn,reverse){return seqIterate(this,fn,reverse,true)};Seq.prototype.__iterator=function(type,reverse){return seqIterator(this,type,reverse,true)};createClass(KeyedSeq,Seq);function KeyedSeq(value){return value===null||value===undefined?emptySequence().toKeyedSeq():isIterable(value)?isKeyed(value)?value.toSeq():value.fromEntrySeq():keyedSeqFromValue(value)}KeyedSeq.prototype.toKeyedSeq=function(){return this};createClass(IndexedSeq,Seq);function IndexedSeq(value){return value===null||value===undefined?emptySequence():!isIterable(value)?indexedSeqFromValue(value):isKeyed(value)?value.entrySeq():value.toIndexedSeq()}IndexedSeq.of=function(){return IndexedSeq(arguments)};IndexedSeq.prototype.toIndexedSeq=function(){return this};IndexedSeq.prototype.toString=function(){return this.__toString("Seq [","]")};IndexedSeq.prototype.__iterate=function(fn,reverse){return seqIterate(this,fn,reverse,false)};IndexedSeq.prototype.__iterator=function(type,reverse){return seqIterator(this,type,reverse,false)};createClass(SetSeq,Seq);function SetSeq(value){return(value===null||value===undefined?emptySequence():!isIterable(value)?indexedSeqFromValue(value):isKeyed(value)?value.entrySeq():value).toSetSeq()}SetSeq.of=function(){return SetSeq(arguments)};SetSeq.prototype.toSetSeq=function(){return this};Seq.isSeq=isSeq;Seq.Keyed=KeyedSeq;Seq.Set=SetSeq;Seq.Indexed=IndexedSeq;var IS_SEQ_SENTINEL="@@__IMMUTABLE_SEQ__@@";Seq.prototype[IS_SEQ_SENTINEL]=true;createClass(ArraySeq,IndexedSeq);function ArraySeq(array){this._array=array;this.size=array.length}ArraySeq.prototype.get=function(index,notSetValue){return this.has(index)?this._array[wrapIndex(this,index)]:notSetValue};ArraySeq.prototype.__iterate=function(fn,reverse){var array=this._array;var maxIndex=array.length-1;for(var ii=0;ii<=maxIndex;ii++){if(fn(array[reverse?maxIndex-ii:ii],ii,this)===false){return ii+1}}return ii};ArraySeq.prototype.__iterator=function(type,reverse){var array=this._array;var maxIndex=array.length-1;var ii=0;return new Iterator((function(){return ii>maxIndex?iteratorDone():iteratorValue(type,ii,array[reverse?maxIndex-ii++:ii++])}))};createClass(ObjectSeq,KeyedSeq);function ObjectSeq(object){var keys=Object.keys(object);this._object=object;this._keys=keys;this.size=keys.length}ObjectSeq.prototype.get=function(key,notSetValue){if(notSetValue!==undefined&&!this.has(key)){return notSetValue}return this._object[key]};ObjectSeq.prototype.has=function(key){return this._object.hasOwnProperty(key)};ObjectSeq.prototype.__iterate=function(fn,reverse){var object=this._object;var keys=this._keys;var maxIndex=keys.length-1;for(var ii=0;ii<=maxIndex;ii++){var key=keys[reverse?maxIndex-ii:ii];if(fn(object[key],key,this)===false){return ii+1}}return ii};ObjectSeq.prototype.__iterator=function(type,reverse){var object=this._object;var keys=this._keys;var maxIndex=keys.length-1;var ii=0;return new Iterator((function(){var key=keys[reverse?maxIndex-ii:ii];return ii++>maxIndex?iteratorDone():iteratorValue(type,key,object[key])}))};ObjectSeq.prototype[IS_ORDERED_SENTINEL]=true;createClass(IterableSeq,IndexedSeq);function IterableSeq(iterable){this._iterable=iterable;this.size=iterable.length||iterable.size}IterableSeq.prototype.__iterateUncached=function(fn,reverse){if(reverse){return this.cacheResult().__iterate(fn,reverse)}var iterable=this._iterable;var iterator=getIterator(iterable);var iterations=0;if(isIterator(iterator)){var step;while(!(step=iterator.next()).done){if(fn(step.value,iterations++,this)===false){break}}}return iterations};IterableSeq.prototype.__iteratorUncached=function(type,reverse){if(reverse){return this.cacheResult().__iterator(type,reverse)}var iterable=this._iterable;var iterator=getIterator(iterable);if(!isIterator(iterator)){return new Iterator(iteratorDone)}var iterations=0;return new Iterator((function(){var step=iterator.next();return step.done?step:iteratorValue(type,iterations++,step.value)}))};createClass(IteratorSeq,IndexedSeq);function IteratorSeq(iterator){this._iterator=iterator;this._iteratorCache=[]}IteratorSeq.prototype.__iterateUncached=function(fn,reverse){if(reverse){return this.cacheResult().__iterate(fn,reverse)}var iterator=this._iterator;var cache=this._iteratorCache;var iterations=0;while(iterations<cache.length){if(fn(cache[iterations],iterations++,this)===false){return iterations}}var step;while(!(step=iterator.next()).done){var val=step.value;cache[iterations]=val;if(fn(val,iterations++,this)===false){break}}return iterations};IteratorSeq.prototype.__iteratorUncached=function(type,reverse){if(reverse){return this.cacheResult().__iterator(type,reverse)}var iterator=this._iterator;var cache=this._iteratorCache;var iterations=0;return new Iterator((function(){if(iterations>=cache.length){var step=iterator.next();if(step.done){return step}cache[iterations]=step.value}return iteratorValue(type,iterations,cache[iterations++])}))};function isSeq(maybeSeq){return!!(maybeSeq&&maybeSeq[IS_SEQ_SENTINEL])}var EMPTY_SEQ;function emptySequence(){return EMPTY_SEQ||(EMPTY_SEQ=new ArraySeq([]))}function keyedSeqFromValue(value){var seq=Array.isArray(value)?new ArraySeq(value).fromEntrySeq():isIterator(value)?new IteratorSeq(value).fromEntrySeq():hasIterator(value)?new IterableSeq(value).fromEntrySeq():typeof value==="object"?new ObjectSeq(value):undefined;if(!seq){throw new TypeError("Expected Array or iterable object of [k, v] entries, "+"or keyed object: "+value)}return seq}function indexedSeqFromValue(value){var seq=maybeIndexedSeqFromValue(value);if(!seq){throw new TypeError("Expected Array or iterable object of values: "+value)}return seq}function seqFromValue(value){var seq=maybeIndexedSeqFromValue(value)||typeof value==="object"&&new ObjectSeq(value);if(!seq){throw new TypeError("Expected Array or iterable object of values, or keyed object: "+value)}return seq}function maybeIndexedSeqFromValue(value){return isArrayLike(value)?new ArraySeq(value):isIterator(value)?new IteratorSeq(value):hasIterator(value)?new IterableSeq(value):undefined}function seqIterate(seq,fn,reverse,useKeys){var cache=seq._cache;if(cache){var maxIndex=cache.length-1;for(var ii=0;ii<=maxIndex;ii++){var entry=cache[reverse?maxIndex-ii:ii];if(fn(entry[1],useKeys?entry[0]:ii,seq)===false){return ii+1}}return ii}return seq.__iterateUncached(fn,reverse)}function seqIterator(seq,type,reverse,useKeys){var cache=seq._cache;if(cache){var maxIndex=cache.length-1;var ii=0;return new Iterator((function(){var entry=cache[reverse?maxIndex-ii:ii];return ii++>maxIndex?iteratorDone():iteratorValue(type,useKeys?entry[0]:ii-1,entry[1])}))}return seq.__iteratorUncached(type,reverse)}function fromJS(json,converter){return converter?fromJSWith(converter,json,"",{"":json}):fromJSDefault(json)}function fromJSWith(converter,json,key,parentJSON){if(Array.isArray(json)){return converter.call(parentJSON,key,IndexedSeq(json).map((function(v,k){return fromJSWith(converter,v,k,json)})))}if(isPlainObj(json)){return converter.call(parentJSON,key,KeyedSeq(json).map((function(v,k){return fromJSWith(converter,v,k,json)})))}return json}function fromJSDefault(json){if(Array.isArray(json)){return IndexedSeq(json).map(fromJSDefault).toList()}if(isPlainObj(json)){return KeyedSeq(json).map(fromJSDefault).toMap()}return json}function isPlainObj(value){return value&&(value.constructor===Object||value.constructor===undefined)}function is(valueA,valueB){if(valueA===valueB||valueA!==valueA&&valueB!==valueB){return true}if(!valueA||!valueB){return false}if(typeof valueA.valueOf==="function"&&typeof valueB.valueOf==="function"){valueA=valueA.valueOf();valueB=valueB.valueOf();if(valueA===valueB||valueA!==valueA&&valueB!==valueB){return true}if(!valueA||!valueB){return false}}if(typeof valueA.equals==="function"&&typeof valueB.equals==="function"&&valueA.equals(valueB)){return true}return false}function deepEqual(a,b){if(a===b){return true}if(!isIterable(b)||a.size!==undefined&&b.size!==undefined&&a.size!==b.size||a.__hash!==undefined&&b.__hash!==undefined&&a.__hash!==b.__hash||isKeyed(a)!==isKeyed(b)||isIndexed(a)!==isIndexed(b)||isOrdered(a)!==isOrdered(b)){return false}if(a.size===0&&b.size===0){return true}var notAssociative=!isAssociative(a);if(isOrdered(a)){var entries=a.entries();return b.every((function(v,k){var entry=entries.next().value;return entry&&is(entry[1],v)&&(notAssociative||is(entry[0],k))}))&&entries.next().done}var flipped=false;if(a.size===undefined){if(b.size===undefined){if(typeof a.cacheResult==="function"){a.cacheResult()}}else{flipped=true;var _=a;a=b;b=_}}var allEqual=true;var bSize=b.__iterate((function(v,k){if(notAssociative?!a.has(v):flipped?!is(v,a.get(k,NOT_SET)):!is(a.get(k,NOT_SET),v)){allEqual=false;return false}}));return allEqual&&a.size===bSize}createClass(Repeat,IndexedSeq);function Repeat(value,times){if(!(this instanceof Repeat)){return new Repeat(value,times)}this._value=value;this.size=times===undefined?Infinity:Math.max(0,times);if(this.size===0){if(EMPTY_REPEAT){return EMPTY_REPEAT}EMPTY_REPEAT=this}}Repeat.prototype.toString=function(){if(this.size===0){return"Repeat []"}return"Repeat [ "+this._value+" "+this.size+" times ]"};Repeat.prototype.get=function(index,notSetValue){return this.has(index)?this._value:notSetValue};Repeat.prototype.includes=function(searchValue){return is(this._value,searchValue)};Repeat.prototype.slice=function(begin,end){var size=this.size;return wholeSlice(begin,end,size)?this:new Repeat(this._value,resolveEnd(end,size)-resolveBegin(begin,size))};Repeat.prototype.reverse=function(){return this};Repeat.prototype.indexOf=function(searchValue){if(is(this._value,searchValue)){return 0}return-1};Repeat.prototype.lastIndexOf=function(searchValue){if(is(this._value,searchValue)){return this.size}return-1};Repeat.prototype.__iterate=function(fn,reverse){for(var ii=0;ii<this.size;ii++){if(fn(this._value,ii,this)===false){return ii+1}}return ii};Repeat.prototype.__iterator=function(type,reverse){var this$0=this;var ii=0;return new Iterator((function(){return ii<this$0.size?iteratorValue(type,ii++,this$0._value):iteratorDone()}))};Repeat.prototype.equals=function(other){return other instanceof Repeat?is(this._value,other._value):deepEqual(other)};var EMPTY_REPEAT;function invariant(condition,error){if(!condition)throw new Error(error)}createClass(Range,IndexedSeq);function Range(start,end,step){if(!(this instanceof Range)){return new Range(start,end,step)}invariant(step!==0,"Cannot step a Range by 0");start=start||0;if(end===undefined){end=Infinity}step=step===undefined?1:Math.abs(step);if(end<start){step=-step}this._start=start;this._end=end;this._step=step;this.size=Math.max(0,Math.ceil((end-start)/step-1)+1);if(this.size===0){if(EMPTY_RANGE){return EMPTY_RANGE}EMPTY_RANGE=this}}Range.prototype.toString=function(){if(this.size===0){return"Range []"}return"Range [ "+this._start+"..."+this._end+(this._step!==1?" by "+this._step:"")+" ]"};Range.prototype.get=function(index,notSetValue){return this.has(index)?this._start+wrapIndex(this,index)*this._step:notSetValue};Range.prototype.includes=function(searchValue){var possibleIndex=(searchValue-this._start)/this._step;return possibleIndex>=0&&possibleIndex<this.size&&possibleIndex===Math.floor(possibleIndex)};Range.prototype.slice=function(begin,end){if(wholeSlice(begin,end,this.size)){return this}begin=resolveBegin(begin,this.size);end=resolveEnd(end,this.size);if(end<=begin){return new Range(0,0)}return new Range(this.get(begin,this._end),this.get(end,this._end),this._step)};Range.prototype.indexOf=function(searchValue){var offsetValue=searchValue-this._start;if(offsetValue%this._step===0){var index=offsetValue/this._step;if(index>=0&&index<this.size){return index}}return-1};Range.prototype.lastIndexOf=function(searchValue){return this.indexOf(searchValue)};Range.prototype.__iterate=function(fn,reverse){var maxIndex=this.size-1;var step=this._step;var value=reverse?this._start+maxIndex*step:this._start;for(var ii=0;ii<=maxIndex;ii++){if(fn(value,ii,this)===false){return ii+1}value+=reverse?-step:step}return ii};Range.prototype.__iterator=function(type,reverse){var maxIndex=this.size-1;var step=this._step;var value=reverse?this._start+maxIndex*step:this._start;var ii=0;return new Iterator((function(){var v=value;value+=reverse?-step:step;return ii>maxIndex?iteratorDone():iteratorValue(type,ii++,v)}))};Range.prototype.equals=function(other){return other instanceof Range?this._start===other._start&&this._end===other._end&&this._step===other._step:deepEqual(this,other)};var EMPTY_RANGE;createClass(Collection,Iterable);function Collection(){throw TypeError("Abstract")}createClass(KeyedCollection,Collection);function KeyedCollection(){}createClass(IndexedCollection,Collection);function IndexedCollection(){}createClass(SetCollection,Collection);function SetCollection(){}Collection.Keyed=KeyedCollection;Collection.Indexed=IndexedCollection;Collection.Set=SetCollection;var imul=typeof Math.imul==="function"&&Math.imul(4294967295,2)===-2?Math.imul:function imul(a,b){a=a|0;b=b|0;var c=a&65535;var d=b&65535;return c*d+((a>>>16)*d+c*(b>>>16)<<16>>>0)|0};function smi(i32){return i32>>>1&1073741824|i32&3221225471}function hash(o){if(o===false||o===null||o===undefined){return 0}if(typeof o.valueOf==="function"){o=o.valueOf();if(o===false||o===null||o===undefined){return 0}}if(o===true){return 1}var type=typeof o;if(type==="number"){if(o!==o||o===Infinity){return 0}var h=o|0;if(h!==o){h^=o*4294967295}while(o>4294967295){o/=4294967295;h^=o}return smi(h)}if(type==="string"){return o.length>STRING_HASH_CACHE_MIN_STRLEN?cachedHashString(o):hashString(o)}if(typeof o.hashCode==="function"){return o.hashCode()}if(type==="object"){return hashJSObj(o)}if(typeof o.toString==="function"){return hashString(o.toString())}throw new Error("Value type "+type+" cannot be hashed.")}function cachedHashString(string){var hash=stringHashCache[string];if(hash===undefined){hash=hashString(string);if(STRING_HASH_CACHE_SIZE===STRING_HASH_CACHE_MAX_SIZE){STRING_HASH_CACHE_SIZE=0;stringHashCache={}}STRING_HASH_CACHE_SIZE++;stringHashCache[string]=hash}return hash}function hashString(string){var hash=0;for(var ii=0;ii<string.length;ii++){hash=31*hash+string.charCodeAt(ii)|0}return smi(hash)}function hashJSObj(obj){var hash;if(usingWeakMap){hash=weakMap.get(obj);if(hash!==undefined){return hash}}hash=obj[UID_HASH_KEY];if(hash!==undefined){return hash}if(!canDefineProperty){hash=obj.propertyIsEnumerable&&obj.propertyIsEnumerable[UID_HASH_KEY];if(hash!==undefined){return hash}hash=getIENodeHash(obj);if(hash!==undefined){return hash}}hash=++objHashUID;if(objHashUID&1073741824){objHashUID=0}if(usingWeakMap){weakMap.set(obj,hash)}else if(isExtensible!==undefined&&isExtensible(obj)===false){throw new Error("Non-extensible objects are not allowed as keys.")}else if(canDefineProperty){Object.defineProperty(obj,UID_HASH_KEY,{enumerable:false,configurable:false,writable:false,value:hash})}else if(obj.propertyIsEnumerable!==undefined&&obj.propertyIsEnumerable===obj.constructor.prototype.propertyIsEnumerable){obj.propertyIsEnumerable=function(){return this.constructor.prototype.propertyIsEnumerable.apply(this,arguments)};obj.propertyIsEnumerable[UID_HASH_KEY]=hash}else if(obj.nodeType!==undefined){obj[UID_HASH_KEY]=hash}else{throw new Error("Unable to set a non-enumerable property on object.")}return hash}var isExtensible=Object.isExtensible;var canDefineProperty=function(){try{Object.defineProperty({},"@",{});return true}catch(e){return false}}();function getIENodeHash(node){if(node&&node.nodeType>0){switch(node.nodeType){case 1:return node.uniqueID;case 9:return node.documentElement&&node.documentElement.uniqueID}}}var usingWeakMap=typeof WeakMap==="function";var weakMap;if(usingWeakMap){weakMap=new WeakMap}var objHashUID=0;var UID_HASH_KEY="__immutablehash__";if(typeof Symbol==="function"){UID_HASH_KEY=Symbol(UID_HASH_KEY)}var STRING_HASH_CACHE_MIN_STRLEN=16;var STRING_HASH_CACHE_MAX_SIZE=255;var STRING_HASH_CACHE_SIZE=0;var stringHashCache={};function assertNotInfinite(size){invariant(size!==Infinity,"Cannot perform this action with an infinite size.")}createClass(Map,KeyedCollection);function Map(value){return value===null||value===undefined?emptyMap():isMap(value)&&!isOrdered(value)?value:emptyMap().withMutations((function(map){var iter=KeyedIterable(value);assertNotInfinite(iter.size);iter.forEach((function(v,k){return map.set(k,v)}))}))}Map.of=function(){var keyValues=SLICE$0.call(arguments,0);return emptyMap().withMutations((function(map){for(var i=0;i<keyValues.length;i+=2){if(i+1>=keyValues.length){throw new Error("Missing value for key: "+keyValues[i])}map.set(keyValues[i],keyValues[i+1])}}))};Map.prototype.toString=function(){return this.__toString("Map {","}")};Map.prototype.get=function(k,notSetValue){return this._root?this._root.get(0,undefined,k,notSetValue):notSetValue};Map.prototype.set=function(k,v){return updateMap(this,k,v)};Map.prototype.setIn=function(keyPath,v){return this.updateIn(keyPath,NOT_SET,(function(){return v}))};Map.prototype.remove=function(k){return updateMap(this,k,NOT_SET)};Map.prototype.deleteIn=function(keyPath){return this.updateIn(keyPath,(function(){return NOT_SET}))};Map.prototype.update=function(k,notSetValue,updater){return arguments.length===1?k(this):this.updateIn([k],notSetValue,updater)};Map.prototype.updateIn=function(keyPath,notSetValue,updater){if(!updater){updater=notSetValue;notSetValue=undefined}var updatedValue=updateInDeepMap(this,forceIterator(keyPath),notSetValue,updater);return updatedValue===NOT_SET?undefined:updatedValue};Map.prototype.clear=function(){if(this.size===0){return this}if(this.__ownerID){this.size=0;this._root=null;this.__hash=undefined;this.__altered=true;return this}return emptyMap()};Map.prototype.merge=function(){return mergeIntoMapWith(this,undefined,arguments)};Map.prototype.mergeWith=function(merger){var iters=SLICE$0.call(arguments,1);return mergeIntoMapWith(this,merger,iters)};Map.prototype.mergeIn=function(keyPath){var iters=SLICE$0.call(arguments,1);return this.updateIn(keyPath,emptyMap(),(function(m){return typeof m.merge==="function"?m.merge.apply(m,iters):iters[iters.length-1]}))};Map.prototype.mergeDeep=function(){return mergeIntoMapWith(this,deepMerger,arguments)};Map.prototype.mergeDeepWith=function(merger){var iters=SLICE$0.call(arguments,1);return mergeIntoMapWith(this,deepMergerWith(merger),iters)};Map.prototype.mergeDeepIn=function(keyPath){var iters=SLICE$0.call(arguments,1);return this.updateIn(keyPath,emptyMap(),(function(m){return typeof m.mergeDeep==="function"?m.mergeDeep.apply(m,iters):iters[iters.length-1]}))};Map.prototype.sort=function(comparator){return OrderedMap(sortFactory(this,comparator))};Map.prototype.sortBy=function(mapper,comparator){return OrderedMap(sortFactory(this,comparator,mapper))};Map.prototype.withMutations=function(fn){var mutable=this.asMutable();fn(mutable);return mutable.wasAltered()?mutable.__ensureOwner(this.__ownerID):this};Map.prototype.asMutable=function(){return this.__ownerID?this:this.__ensureOwner(new OwnerID)};Map.prototype.asImmutable=function(){return this.__ensureOwner()};Map.prototype.wasAltered=function(){return this.__altered};Map.prototype.__iterator=function(type,reverse){return new MapIterator(this,type,reverse)};Map.prototype.__iterate=function(fn,reverse){var this$0=this;var iterations=0;this._root&&this._root.iterate((function(entry){iterations++;return fn(entry[1],entry[0],this$0)}),reverse);return iterations};Map.prototype.__ensureOwner=function(ownerID){if(ownerID===this.__ownerID){return this}if(!ownerID){this.__ownerID=ownerID;this.__altered=false;return this}return makeMap(this.size,this._root,ownerID,this.__hash)};function isMap(maybeMap){return!!(maybeMap&&maybeMap[IS_MAP_SENTINEL])}Map.isMap=isMap;var IS_MAP_SENTINEL="@@__IMMUTABLE_MAP__@@";var MapPrototype=Map.prototype;MapPrototype[IS_MAP_SENTINEL]=true;MapPrototype[DELETE]=MapPrototype.remove;MapPrototype.removeIn=MapPrototype.deleteIn;function ArrayMapNode(ownerID,entries){this.ownerID=ownerID;this.entries=entries}ArrayMapNode.prototype.get=function(shift,keyHash,key,notSetValue){var entries=this.entries;for(var ii=0,len=entries.length;ii<len;ii++){if(is(key,entries[ii][0])){return entries[ii][1]}}return notSetValue};ArrayMapNode.prototype.update=function(ownerID,shift,keyHash,key,value,didChangeSize,didAlter){var removed=value===NOT_SET;var entries=this.entries;var idx=0;for(var len=entries.length;idx<len;idx++){if(is(key,entries[idx][0])){break}}var exists=idx<len;if(exists?entries[idx][1]===value:removed){return this}SetRef(didAlter);(removed||!exists)&&SetRef(didChangeSize);if(removed&&entries.length===1){return}if(!exists&&!removed&&entries.length>=MAX_ARRAY_MAP_SIZE){return createNodes(ownerID,entries,key,value)}var isEditable=ownerID&&ownerID===this.ownerID;var newEntries=isEditable?entries:arrCopy(entries);if(exists){if(removed){idx===len-1?newEntries.pop():newEntries[idx]=newEntries.pop()}else{newEntries[idx]=[key,value]}}else{newEntries.push([key,value])}if(isEditable){this.entries=newEntries;return this}return new ArrayMapNode(ownerID,newEntries)};function BitmapIndexedNode(ownerID,bitmap,nodes){this.ownerID=ownerID;this.bitmap=bitmap;this.nodes=nodes}BitmapIndexedNode.prototype.get=function(shift,keyHash,key,notSetValue){if(keyHash===undefined){keyHash=hash(key)}var bit=1<<((shift===0?keyHash:keyHash>>>shift)&MASK);var bitmap=this.bitmap;return(bitmap&bit)===0?notSetValue:this.nodes[popCount(bitmap&bit-1)].get(shift+SHIFT,keyHash,key,notSetValue)};BitmapIndexedNode.prototype.update=function(ownerID,shift,keyHash,key,value,didChangeSize,didAlter){if(keyHash===undefined){keyHash=hash(key)}var keyHashFrag=(shift===0?keyHash:keyHash>>>shift)&MASK;var bit=1<<keyHashFrag;var bitmap=this.bitmap;var exists=(bitmap&bit)!==0;if(!exists&&value===NOT_SET){return this}var idx=popCount(bitmap&bit-1);var nodes=this.nodes;var node=exists?nodes[idx]:undefined;var newNode=updateNode(node,ownerID,shift+SHIFT,keyHash,key,value,didChangeSize,didAlter);if(newNode===node){return this}if(!exists&&newNode&&nodes.length>=MAX_BITMAP_INDEXED_SIZE){return expandNodes(ownerID,nodes,bitmap,keyHashFrag,newNode)}if(exists&&!newNode&&nodes.length===2&&isLeafNode(nodes[idx^1])){return nodes[idx^1]}if(exists&&newNode&&nodes.length===1&&isLeafNode(newNode)){return newNode}var isEditable=ownerID&&ownerID===this.ownerID;var newBitmap=exists?newNode?bitmap:bitmap^bit:bitmap|bit;var newNodes=exists?newNode?setIn(nodes,idx,newNode,isEditable):spliceOut(nodes,idx,isEditable):spliceIn(nodes,idx,newNode,isEditable);if(isEditable){this.bitmap=newBitmap;this.nodes=newNodes;return this}return new BitmapIndexedNode(ownerID,newBitmap,newNodes)};function HashArrayMapNode(ownerID,count,nodes){this.ownerID=ownerID;this.count=count;this.nodes=nodes}HashArrayMapNode.prototype.get=function(shift,keyHash,key,notSetValue){if(keyHash===undefined){keyHash=hash(key)}var idx=(shift===0?keyHash:keyHash>>>shift)&MASK;var node=this.nodes[idx];return node?node.get(shift+SHIFT,keyHash,key,notSetValue):notSetValue};HashArrayMapNode.prototype.update=function(ownerID,shift,keyHash,key,value,didChangeSize,didAlter){if(keyHash===undefined){keyHash=hash(key)}var idx=(shift===0?keyHash:keyHash>>>shift)&MASK;var removed=value===NOT_SET;var nodes=this.nodes;var node=nodes[idx];if(removed&&!node){return this}var newNode=updateNode(node,ownerID,shift+SHIFT,keyHash,key,value,didChangeSize,didAlter);if(newNode===node){return this}var newCount=this.count;if(!node){newCount++}else if(!newNode){newCount--;if(newCount<MIN_HASH_ARRAY_MAP_SIZE){return packNodes(ownerID,nodes,newCount,idx)}}var isEditable=ownerID&&ownerID===this.ownerID;var newNodes=setIn(nodes,idx,newNode,isEditable);if(isEditable){this.count=newCount;this.nodes=newNodes;return this}return new HashArrayMapNode(ownerID,newCount,newNodes)};function HashCollisionNode(ownerID,keyHash,entries){this.ownerID=ownerID;this.keyHash=keyHash;this.entries=entries}HashCollisionNode.prototype.get=function(shift,keyHash,key,notSetValue){var entries=this.entries;for(var ii=0,len=entries.length;ii<len;ii++){if(is(key,entries[ii][0])){return entries[ii][1]}}return notSetValue};HashCollisionNode.prototype.update=function(ownerID,shift,keyHash,key,value,didChangeSize,didAlter){if(keyHash===undefined){keyHash=hash(key)}var removed=value===NOT_SET;if(keyHash!==this.keyHash){if(removed){return this}SetRef(didAlter);SetRef(didChangeSize);return mergeIntoNode(this,ownerID,shift,keyHash,[key,value])}var entries=this.entries;var idx=0;for(var len=entries.length;idx<len;idx++){if(is(key,entries[idx][0])){break}}var exists=idx<len;if(exists?entries[idx][1]===value:removed){return this}SetRef(didAlter);(removed||!exists)&&SetRef(didChangeSize);if(removed&&len===2){return new ValueNode(ownerID,this.keyHash,entries[idx^1])}var isEditable=ownerID&&ownerID===this.ownerID;var newEntries=isEditable?entries:arrCopy(entries);if(exists){if(removed){idx===len-1?newEntries.pop():newEntries[idx]=newEntries.pop()}else{newEntries[idx]=[key,value]}}else{newEntries.push([key,value])}if(isEditable){this.entries=newEntries;return this}return new HashCollisionNode(ownerID,this.keyHash,newEntries)};function ValueNode(ownerID,keyHash,entry){this.ownerID=ownerID;this.keyHash=keyHash;this.entry=entry}ValueNode.prototype.get=function(shift,keyHash,key,notSetValue){return is(key,this.entry[0])?this.entry[1]:notSetValue};ValueNode.prototype.update=function(ownerID,shift,keyHash,key,value,didChangeSize,didAlter){var removed=value===NOT_SET;var keyMatch=is(key,this.entry[0]);if(keyMatch?value===this.entry[1]:removed){return this}SetRef(didAlter);if(removed){SetRef(didChangeSize);return}if(keyMatch){if(ownerID&&ownerID===this.ownerID){this.entry[1]=value;return this}return new ValueNode(ownerID,this.keyHash,[key,value])}SetRef(didChangeSize);return mergeIntoNode(this,ownerID,shift,hash(key),[key,value])};ArrayMapNode.prototype.iterate=HashCollisionNode.prototype.iterate=function(fn,reverse){var entries=this.entries;for(var ii=0,maxIndex=entries.length-1;ii<=maxIndex;ii++){if(fn(entries[reverse?maxIndex-ii:ii])===false){return false}}};BitmapIndexedNode.prototype.iterate=HashArrayMapNode.prototype.iterate=function(fn,reverse){var nodes=this.nodes;for(var ii=0,maxIndex=nodes.length-1;ii<=maxIndex;ii++){var node=nodes[reverse?maxIndex-ii:ii];if(node&&node.iterate(fn,reverse)===false){return false}}};ValueNode.prototype.iterate=function(fn,reverse){return fn(this.entry)};createClass(MapIterator,Iterator);function MapIterator(map,type,reverse){this._type=type;this._reverse=reverse;this._stack=map._root&&mapIteratorFrame(map._root)}MapIterator.prototype.next=function(){var type=this._type;var stack=this._stack;while(stack){var node=stack.node;var index=stack.index++;var maxIndex;if(node.entry){if(index===0){return mapIteratorValue(type,node.entry)}}else if(node.entries){maxIndex=node.entries.length-1;if(index<=maxIndex){return mapIteratorValue(type,node.entries[this._reverse?maxIndex-index:index])}}else{maxIndex=node.nodes.length-1;if(index<=maxIndex){var subNode=node.nodes[this._reverse?maxIndex-index:index];if(subNode){if(subNode.entry){return mapIteratorValue(type,subNode.entry)}stack=this._stack=mapIteratorFrame(subNode,stack)}continue}}stack=this._stack=this._stack.__prev}return iteratorDone()};function mapIteratorValue(type,entry){return iteratorValue(type,entry[0],entry[1])}function mapIteratorFrame(node,prev){return{node,index:0,__prev:prev}}function makeMap(size,root,ownerID,hash){var map=Object.create(MapPrototype);map.size=size;map._root=root;map.__ownerID=ownerID;map.__hash=hash;map.__altered=false;return map}var EMPTY_MAP;function emptyMap(){return EMPTY_MAP||(EMPTY_MAP=makeMap(0))}function updateMap(map,k,v){var newRoot;var newSize;if(!map._root){if(v===NOT_SET){return map}newSize=1;newRoot=new ArrayMapNode(map.__ownerID,[[k,v]])}else{var didChangeSize=MakeRef(CHANGE_LENGTH);var didAlter=MakeRef(DID_ALTER);newRoot=updateNode(map._root,map.__ownerID,0,undefined,k,v,didChangeSize,didAlter);if(!didAlter.value){return map}newSize=map.size+(didChangeSize.value?v===NOT_SET?-1:1:0)}if(map.__ownerID){map.size=newSize;map._root=newRoot;map.__hash=undefined;map.__altered=true;return map}return newRoot?makeMap(newSize,newRoot):emptyMap()}function updateNode(node,ownerID,shift,keyHash,key,value,didChangeSize,didAlter){if(!node){if(value===NOT_SET){return node}SetRef(didAlter);SetRef(didChangeSize);return new ValueNode(ownerID,keyHash,[key,value])}return node.update(ownerID,shift,keyHash,key,value,didChangeSize,didAlter)}function isLeafNode(node){return node.constructor===ValueNode||node.constructor===HashCollisionNode}function mergeIntoNode(node,ownerID,shift,keyHash,entry){if(node.keyHash===keyHash){return new HashCollisionNode(ownerID,keyHash,[node.entry,entry])}var idx1=(shift===0?node.keyHash:node.keyHash>>>shift)&MASK;var idx2=(shift===0?keyHash:keyHash>>>shift)&MASK;var newNode;var nodes=idx1===idx2?[mergeIntoNode(node,ownerID,shift+SHIFT,keyHash,entry)]:(newNode=new ValueNode(ownerID,keyHash,entry),idx1<idx2?[node,newNode]:[newNode,node]);return new BitmapIndexedNode(ownerID,1<<idx1|1<<idx2,nodes)}function createNodes(ownerID,entries,key,value){if(!ownerID){ownerID=new OwnerID}var node=new ValueNode(ownerID,hash(key),[key,value]);for(var ii=0;ii<entries.length;ii++){var entry=entries[ii];node=node.update(ownerID,0,undefined,entry[0],entry[1])}return node}function packNodes(ownerID,nodes,count,excluding){var bitmap=0;var packedII=0;var packedNodes=new Array(count);for(var ii=0,bit=1,len=nodes.length;ii<len;ii++,bit<<=1){var node=nodes[ii];if(node!==undefined&&ii!==excluding){bitmap|=bit;packedNodes[packedII++]=node}}return new BitmapIndexedNode(ownerID,bitmap,packedNodes)}function expandNodes(ownerID,nodes,bitmap,including,node){var count=0;var expandedNodes=new Array(SIZE);for(var ii=0;bitmap!==0;ii++,bitmap>>>=1){expandedNodes[ii]=bitmap&1?nodes[count++]:undefined}expandedNodes[including]=node;return new HashArrayMapNode(ownerID,count+1,expandedNodes)}function mergeIntoMapWith(map,merger,iterables){var iters=[];for(var ii=0;ii<iterables.length;ii++){var value=iterables[ii];var iter=KeyedIterable(value);if(!isIterable(value)){iter=iter.map((function(v){return fromJS(v)}))}iters.push(iter)}return mergeIntoCollectionWith(map,merger,iters)}function deepMerger(existing,value,key){return existing&&existing.mergeDeep&&isIterable(value)?existing.mergeDeep(value):is(existing,value)?existing:value}function deepMergerWith(merger){return function(existing,value,key){if(existing&&existing.mergeDeepWith&&isIterable(value)){return existing.mergeDeepWith(merger,value)}var nextValue=merger(existing,value,key);return is(existing,nextValue)?existing:nextValue}}function mergeIntoCollectionWith(collection,merger,iters){iters=iters.filter((function(x){return x.size!==0}));if(iters.length===0){return collection}if(collection.size===0&&!collection.__ownerID&&iters.length===1){return collection.constructor(iters[0])}return collection.withMutations((function(collection){var mergeIntoMap=merger?function(value,key){collection.update(key,NOT_SET,(function(existing){return existing===NOT_SET?value:merger(existing,value,key)}))}:function(value,key){collection.set(key,value)};for(var ii=0;ii<iters.length;ii++){iters[ii].forEach(mergeIntoMap)}}))}function updateInDeepMap(existing,keyPathIter,notSetValue,updater){var isNotSet=existing===NOT_SET;var step=keyPathIter.next();if(step.done){var existingValue=isNotSet?notSetValue:existing;var newValue=updater(existingValue);return newValue===existingValue?existing:newValue}invariant(isNotSet||existing&&existing.set,"invalid keyPath");var key=step.value;var nextExisting=isNotSet?NOT_SET:existing.get(key,NOT_SET);var nextUpdated=updateInDeepMap(nextExisting,keyPathIter,notSetValue,updater);return nextUpdated===nextExisting?existing:nextUpdated===NOT_SET?existing.remove(key):(isNotSet?emptyMap():existing).set(key,nextUpdated)}function popCount(x){x=x-(x>>1&1431655765);x=(x&858993459)+(x>>2&858993459);x=x+(x>>4)&252645135;x=x+(x>>8);x=x+(x>>16);return x&127}function setIn(array,idx,val,canEdit){var newArray=canEdit?array:arrCopy(array);newArray[idx]=val;return newArray}function spliceIn(array,idx,val,canEdit){var newLen=array.length+1;if(canEdit&&idx+1===newLen){array[idx]=val;return array}var newArray=new Array(newLen);var after=0;for(var ii=0;ii<newLen;ii++){if(ii===idx){newArray[ii]=val;after=-1}else{newArray[ii]=array[ii+after]}}return newArray}function spliceOut(array,idx,canEdit){var newLen=array.length-1;if(canEdit&&idx===newLen){array.pop();return array}var newArray=new Array(newLen);var after=0;for(var ii=0;ii<newLen;ii++){if(ii===idx){after=1}newArray[ii]=array[ii+after]}return newArray}var MAX_ARRAY_MAP_SIZE=SIZE/4;var MAX_BITMAP_INDEXED_SIZE=SIZE/2;var MIN_HASH_ARRAY_MAP_SIZE=SIZE/4;createClass(List,IndexedCollection);function List(value){var empty=emptyList();if(value===null||value===undefined){return empty}if(isList(value)){return value}var iter=IndexedIterable(value);var size=iter.size;if(size===0){return empty}assertNotInfinite(size);if(size>0&&size<SIZE){return makeList(0,size,SHIFT,null,new VNode(iter.toArray()))}return empty.withMutations((function(list){list.setSize(size);iter.forEach((function(v,i){return list.set(i,v)}))}))}List.of=function(){return this(arguments)};List.prototype.toString=function(){return this.__toString("List [","]")};List.prototype.get=function(index,notSetValue){index=wrapIndex(this,index);if(index>=0&&index<this.size){index+=this._origin;var node=listNodeFor(this,index);return node&&node.array[index&MASK]}return notSetValue};List.prototype.set=function(index,value){return updateList(this,index,value)};List.prototype.remove=function(index){return!this.has(index)?this:index===0?this.shift():index===this.size-1?this.pop():this.splice(index,1)};List.prototype.insert=function(index,value){return this.splice(index,0,value)};List.prototype.clear=function(){if(this.size===0){return this}if(this.__ownerID){this.size=this._origin=this._capacity=0;this._level=SHIFT;this._root=this._tail=null;this.__hash=undefined;this.__altered=true;return this}return emptyList()};List.prototype.push=function(){var values=arguments;var oldSize=this.size;return this.withMutations((function(list){setListBounds(list,0,oldSize+values.length);for(var ii=0;ii<values.length;ii++){list.set(oldSize+ii,values[ii])}}))};List.prototype.pop=function(){return setListBounds(this,0,-1)};List.prototype.unshift=function(){var values=arguments;return this.withMutations((function(list){setListBounds(list,-values.length);for(var ii=0;ii<values.length;ii++){list.set(ii,values[ii])}}))};List.prototype.shift=function(){return setListBounds(this,1)};List.prototype.merge=function(){return mergeIntoListWith(this,undefined,arguments)};List.prototype.mergeWith=function(merger){var iters=SLICE$0.call(arguments,1);return mergeIntoListWith(this,merger,iters)};List.prototype.mergeDeep=function(){return mergeIntoListWith(this,deepMerger,arguments)};List.prototype.mergeDeepWith=function(merger){var iters=SLICE$0.call(arguments,1);return mergeIntoListWith(this,deepMergerWith(merger),iters)};List.prototype.setSize=function(size){return setListBounds(this,0,size)};List.prototype.slice=function(begin,end){var size=this.size;if(wholeSlice(begin,end,size)){return this}return setListBounds(this,resolveBegin(begin,size),resolveEnd(end,size))};List.prototype.__iterator=function(type,reverse){var index=0;var values=iterateList(this,reverse);return new Iterator((function(){var value=values();return value===DONE?iteratorDone():iteratorValue(type,index++,value)}))};List.prototype.__iterate=function(fn,reverse){var index=0;var values=iterateList(this,reverse);var value;while((value=values())!==DONE){if(fn(value,index++,this)===false){break}}return index};List.prototype.__ensureOwner=function(ownerID){if(ownerID===this.__ownerID){return this}if(!ownerID){this.__ownerID=ownerID;return this}return makeList(this._origin,this._capacity,this._level,this._root,this._tail,ownerID,this.__hash)};function isList(maybeList){return!!(maybeList&&maybeList[IS_LIST_SENTINEL])}List.isList=isList;var IS_LIST_SENTINEL="@@__IMMUTABLE_LIST__@@";var ListPrototype=List.prototype;ListPrototype[IS_LIST_SENTINEL]=true;ListPrototype[DELETE]=ListPrototype.remove;ListPrototype.setIn=MapPrototype.setIn;ListPrototype.deleteIn=ListPrototype.removeIn=MapPrototype.removeIn;ListPrototype.update=MapPrototype.update;ListPrototype.updateIn=MapPrototype.updateIn;ListPrototype.mergeIn=MapPrototype.mergeIn;ListPrototype.mergeDeepIn=MapPrototype.mergeDeepIn;ListPrototype.withMutations=MapPrototype.withMutations;ListPrototype.asMutable=MapPrototype.asMutable;ListPrototype.asImmutable=MapPrototype.asImmutable;ListPrototype.wasAltered=MapPrototype.wasAltered;function VNode(array,ownerID){this.array=array;this.ownerID=ownerID}VNode.prototype.removeBefore=function(ownerID,level,index){if(index===level?1<<level:false||this.array.length===0){return this}var originIndex=index>>>level&MASK;if(originIndex>=this.array.length){return new VNode([],ownerID)}var removingFirst=originIndex===0;var newChild;if(level>0){var oldChild=this.array[originIndex];newChild=oldChild&&oldChild.removeBefore(ownerID,level-SHIFT,index);if(newChild===oldChild&&removingFirst){return this}}if(removingFirst&&!newChild){return this}var editable=editableVNode(this,ownerID);if(!removingFirst){for(var ii=0;ii<originIndex;ii++){editable.array[ii]=undefined}}if(newChild){editable.array[originIndex]=newChild}return editable};VNode.prototype.removeAfter=function(ownerID,level,index){if(index===(level?1<<level:0)||this.array.length===0){return this}var sizeIndex=index-1>>>level&MASK;if(sizeIndex>=this.array.length){return this}var newChild;if(level>0){var oldChild=this.array[sizeIndex];newChild=oldChild&&oldChild.removeAfter(ownerID,level-SHIFT,index);if(newChild===oldChild&&sizeIndex===this.array.length-1){return this}}var editable=editableVNode(this,ownerID);editable.array.splice(sizeIndex+1);if(newChild){editable.array[sizeIndex]=newChild}return editable};var DONE={};function iterateList(list,reverse){var left=list._origin;var right=list._capacity;var tailPos=getTailOffset(right);var tail=list._tail;return iterateNodeOrLeaf(list._root,list._level,0);function iterateNodeOrLeaf(node,level,offset){return level===0?iterateLeaf(node,offset):iterateNode(node,level,offset)}function iterateLeaf(node,offset){var array=offset===tailPos?tail&&tail.array:node&&node.array;var from=offset>left?0:left-offset;var to=right-offset;if(to>SIZE){to=SIZE}return function(){if(from===to){return DONE}var idx=reverse?--to:from++;return array&&array[idx]}}function iterateNode(node,level,offset){var values;var array=node&&node.array;var from=offset>left?0:left-offset>>level;var to=(right-offset>>level)+1;if(to>SIZE){to=SIZE}return function(){do{if(values){var value=values();if(value!==DONE){return value}values=null}if(from===to){return DONE}var idx=reverse?--to:from++;values=iterateNodeOrLeaf(array&&array[idx],level-SHIFT,offset+(idx<<level))}while(true)}}}function makeList(origin,capacity,level,root,tail,ownerID,hash){var list=Object.create(ListPrototype);list.size=capacity-origin;list._origin=origin;list._capacity=capacity;list._level=level;list._root=root;list._tail=tail;list.__ownerID=ownerID;list.__hash=hash;list.__altered=false;return list}var EMPTY_LIST;function emptyList(){return EMPTY_LIST||(EMPTY_LIST=makeList(0,0,SHIFT))}function updateList(list,index,value){index=wrapIndex(list,index);if(index!==index){return list}if(index>=list.size||index<0){return list.withMutations((function(list){index<0?setListBounds(list,index).set(0,value):setListBounds(list,0,index+1).set(index,value)}))}index+=list._origin;var newTail=list._tail;var newRoot=list._root;var didAlter=MakeRef(DID_ALTER);if(index>=getTailOffset(list._capacity)){newTail=updateVNode(newTail,list.__ownerID,0,index,value,didAlter)}else{newRoot=updateVNode(newRoot,list.__ownerID,list._level,index,value,didAlter)}if(!didAlter.value){return list}if(list.__ownerID){list._root=newRoot;list._tail=newTail;list.__hash=undefined;list.__altered=true;return list}return makeList(list._origin,list._capacity,list._level,newRoot,newTail)}function updateVNode(node,ownerID,level,index,value,didAlter){var idx=index>>>level&MASK;var nodeHas=node&&idx<node.array.length;if(!nodeHas&&value===undefined){return node}var newNode;if(level>0){var lowerNode=node&&node.array[idx];var newLowerNode=updateVNode(lowerNode,ownerID,level-SHIFT,index,value,didAlter);if(newLowerNode===lowerNode){return node}newNode=editableVNode(node,ownerID);newNode.array[idx]=newLowerNode;return newNode}if(nodeHas&&node.array[idx]===value){return node}SetRef(didAlter);newNode=editableVNode(node,ownerID);if(value===undefined&&idx===newNode.array.length-1){newNode.array.pop()}else{newNode.array[idx]=value}return newNode}function editableVNode(node,ownerID){if(ownerID&&node&&ownerID===node.ownerID){return node}return new VNode(node?node.array.slice():[],ownerID)}function listNodeFor(list,rawIndex){if(rawIndex>=getTailOffset(list._capacity)){return list._tail}if(rawIndex<1<<list._level+SHIFT){var node=list._root;var level=list._level;while(node&&level>0){node=node.array[rawIndex>>>level&MASK];level-=SHIFT}return node}}function setListBounds(list,begin,end){if(begin!==undefined){begin=begin|0}if(end!==undefined){end=end|0}var owner=list.__ownerID||new OwnerID;var oldOrigin=list._origin;var oldCapacity=list._capacity;var newOrigin=oldOrigin+begin;var newCapacity=end===undefined?oldCapacity:end<0?oldCapacity+end:oldOrigin+end;if(newOrigin===oldOrigin&&newCapacity===oldCapacity){return list}if(newOrigin>=newCapacity){return list.clear()}var newLevel=list._level;var newRoot=list._root;var offsetShift=0;while(newOrigin+offsetShift<0){newRoot=new VNode(newRoot&&newRoot.array.length?[undefined,newRoot]:[],owner);newLevel+=SHIFT;offsetShift+=1<<newLevel}if(offsetShift){newOrigin+=offsetShift;oldOrigin+=offsetShift;newCapacity+=offsetShift;oldCapacity+=offsetShift}var oldTailOffset=getTailOffset(oldCapacity);var newTailOffset=getTailOffset(newCapacity);while(newTailOffset>=1<<newLevel+SHIFT){newRoot=new VNode(newRoot&&newRoot.array.length?[newRoot]:[],owner);newLevel+=SHIFT}var oldTail=list._tail;var newTail=newTailOffset<oldTailOffset?listNodeFor(list,newCapacity-1):newTailOffset>oldTailOffset?new VNode([],owner):oldTail;if(oldTail&&newTailOffset>oldTailOffset&&newOrigin<oldCapacity&&oldTail.array.length){newRoot=editableVNode(newRoot,owner);var node=newRoot;for(var level=newLevel;level>SHIFT;level-=SHIFT){var idx=oldTailOffset>>>level&MASK;node=node.array[idx]=editableVNode(node.array[idx],owner)}node.array[oldTailOffset>>>SHIFT&MASK]=oldTail}if(newCapacity<oldCapacity){newTail=newTail&&newTail.removeAfter(owner,0,newCapacity)}if(newOrigin>=newTailOffset){newOrigin-=newTailOffset;newCapacity-=newTailOffset;newLevel=SHIFT;newRoot=null;newTail=newTail&&newTail.removeBefore(owner,0,newOrigin)}else if(newOrigin>oldOrigin||newTailOffset<oldTailOffset){offsetShift=0;while(newRoot){var beginIndex=newOrigin>>>newLevel&MASK;if(beginIndex!==newTailOffset>>>newLevel&MASK){break}if(beginIndex){offsetShift+=(1<<newLevel)*beginIndex}newLevel-=SHIFT;newRoot=newRoot.array[beginIndex]}if(newRoot&&newOrigin>oldOrigin){newRoot=newRoot.removeBefore(owner,newLevel,newOrigin-offsetShift)}if(newRoot&&newTailOffset<oldTailOffset){newRoot=newRoot.removeAfter(owner,newLevel,newTailOffset-offsetShift)}if(offsetShift){newOrigin-=offsetShift;newCapacity-=offsetShift}}if(list.__ownerID){list.size=newCapacity-newOrigin;list._origin=newOrigin;list._capacity=newCapacity;list._level=newLevel;list._root=newRoot;list._tail=newTail;list.__hash=undefined;list.__altered=true;return list}return makeList(newOrigin,newCapacity,newLevel,newRoot,newTail)}function mergeIntoListWith(list,merger,iterables){var iters=[];var maxSize=0;for(var ii=0;ii<iterables.length;ii++){var value=iterables[ii];var iter=IndexedIterable(value);if(iter.size>maxSize){maxSize=iter.size}if(!isIterable(value)){iter=iter.map((function(v){return fromJS(v)}))}iters.push(iter)}if(maxSize>list.size){list=list.setSize(maxSize)}return mergeIntoCollectionWith(list,merger,iters)}function getTailOffset(size){return size<SIZE?0:size-1>>>SHIFT<<SHIFT}createClass(OrderedMap,Map);function OrderedMap(value){return value===null||value===undefined?emptyOrderedMap():isOrderedMap(value)?value:emptyOrderedMap().withMutations((function(map){var iter=KeyedIterable(value);assertNotInfinite(iter.size);iter.forEach((function(v,k){return map.set(k,v)}))}))}OrderedMap.of=function(){return this(arguments)};OrderedMap.prototype.toString=function(){return this.__toString("OrderedMap {","}")};OrderedMap.prototype.get=function(k,notSetValue){var index=this._map.get(k);return index!==undefined?this._list.get(index)[1]:notSetValue};OrderedMap.prototype.clear=function(){if(this.size===0){return this}if(this.__ownerID){this.size=0;this._map.clear();this._list.clear();return this}return emptyOrderedMap()};OrderedMap.prototype.set=function(k,v){return updateOrderedMap(this,k,v)};OrderedMap.prototype.remove=function(k){return updateOrderedMap(this,k,NOT_SET)};OrderedMap.prototype.wasAltered=function(){return this._map.wasAltered()||this._list.wasAltered()};OrderedMap.prototype.__iterate=function(fn,reverse){var this$0=this;return this._list.__iterate((function(entry){return entry&&fn(entry[1],entry[0],this$0)}),reverse)};OrderedMap.prototype.__iterator=function(type,reverse){return this._list.fromEntrySeq().__iterator(type,reverse)};OrderedMap.prototype.__ensureOwner=function(ownerID){if(ownerID===this.__ownerID){return this}var newMap=this._map.__ensureOwner(ownerID);var newList=this._list.__ensureOwner(ownerID);if(!ownerID){this.__ownerID=ownerID;this._map=newMap;this._list=newList;return this}return makeOrderedMap(newMap,newList,ownerID,this.__hash)};function isOrderedMap(maybeOrderedMap){return isMap(maybeOrderedMap)&&isOrdered(maybeOrderedMap)}OrderedMap.isOrderedMap=isOrderedMap;OrderedMap.prototype[IS_ORDERED_SENTINEL]=true;OrderedMap.prototype[DELETE]=OrderedMap.prototype.remove;function makeOrderedMap(map,list,ownerID,hash){var omap=Object.create(OrderedMap.prototype);omap.size=map?map.size:0;omap._map=map;omap._list=list;omap.__ownerID=ownerID;omap.__hash=hash;return omap}var EMPTY_ORDERED_MAP;function emptyOrderedMap(){return EMPTY_ORDERED_MAP||(EMPTY_ORDERED_MAP=makeOrderedMap(emptyMap(),emptyList()))}function updateOrderedMap(omap,k,v){var map=omap._map;var list=omap._list;var i=map.get(k);var has=i!==undefined;var newMap;var newList;if(v===NOT_SET){if(!has){return omap}if(list.size>=SIZE&&list.size>=map.size*2){newList=list.filter((function(entry,idx){return entry!==undefined&&i!==idx}));newMap=newList.toKeyedSeq().map((function(entry){return entry[0]})).flip().toMap();if(omap.__ownerID){newMap.__ownerID=newList.__ownerID=omap.__ownerID}}else{newMap=map.remove(k);newList=i===list.size-1?list.pop():list.set(i,undefined)}}else{if(has){if(v===list.get(i)[1]){return omap}newMap=map;newList=list.set(i,[k,v])}else{newMap=map.set(k,list.size);newList=list.set(list.size,[k,v])}}if(omap.__ownerID){omap.size=newMap.size;omap._map=newMap;omap._list=newList;omap.__hash=undefined;return omap}return makeOrderedMap(newMap,newList)}createClass(ToKeyedSequence,KeyedSeq);function ToKeyedSequence(indexed,useKeys){this._iter=indexed;this._useKeys=useKeys;this.size=indexed.size}ToKeyedSequence.prototype.get=function(key,notSetValue){return this._iter.get(key,notSetValue)};ToKe