#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# modify_cannadic
# ==============================================================================

modify_cannadic = Proc.new do
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	dicfile = File.new($dicname, "w")

	lines.length.times do |i|
		s = lines[i].chomp.split(" ")

		# （例）あきびん #T35*202 空き瓶 空瓶 #T35*151 空きビン 空ビン #T35*150 空きびん
		yomi = s[0]

		(s.length - 1).times do |c|
			if s[c + 1].index("#") == 0
				$hinsi = s[c + 1]
				next
			end

			hyouki = s[c + 1]

			if $hinsi.index("#T3") == 0 ||
			$hinsi.index("#T0") == 0 ||
			$hinsi.index("#CN") == 0 ||
			$hinsi.index("#JN") == 0 ||
			$hinsi.index("#KK") == 0
				dicfile.puts yomi + "	" + hyouki
			end
		end
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".modcanna"

	modify_cannadic.call
end
