#!/bin/sh

# 人名を手動で追加するときのスクリプト
# 「zzz」というファイルを作って「読みがな	表記」のエントリを書いて保存。
# sh add-newjinmei.sh で辞書に追加。
# これで作ったエントリはjinmei_specified.txtにも自動で追加される。

cp jinmei.hits jinmei.hits_bak
cp jinmei.txt jinmei.txt_bak
rm -f {zzz.*,zzz_*}

ruby ../src/get-yomigana-hyouki-jinmei.rb zzz
cat zzz.pairs jinmei.txt > jinmei.txt.new
mv jinmei.txt.new jinmei.txt
ruby ../src/remove-duplicates.rb jinmei.txt
mv jinmei.txt.remdup jinmei.txt
ruby ../src/remove-duplicates.rb jinmei_specified.txt
mv jinmei_specified.txt.remdup jinmei_specified.txt

ruby make-jinmeilist.rb zzz.pairs
cat zzz.pairs.list jinmei_specified.txt > jinmei_specified.txt.new
mv jinmei_specified.txt.new jinmei_specified.txt
ruby ../src/remove-duplicates.rb jinmei_specified.txt
mv jinmei_specified.txt.remdup jinmei_specified.txt

split -d -l $(expr $(grep '' zzz.pairs | wc -l) / 3 + 1) zzz.pairs zzz.pairs

ruby ../src/get-jawiki-hits.rb zzz.pairs00 &
ruby ../src/get-jawiki-hits.rb zzz.pairs01 &
ruby ../src/get-jawiki-hits.rb zzz.pairs02 &
wait

cat zzz.pairs*.hits > zzz_all.hits
cat zzz_all.hits jinmei.hits > jinmei.hits.new
mv jinmei.hits.new jinmei.hits
ruby ../src/remove-duplicates.rb jinmei.hits
mv jinmei.hits.remdup jinmei.hits

ruby modify-jinmei-jawikihits.rb zzz_all.hits
cat zzz_all.hits.modhits jinmei.hits.modhits > jinmei.hits.modhits.new
mv jinmei.hits.modhits.new jinmei.hits.modhits
ruby ../src/sortdic.rb jinmei.hits.modhits
rm zzz.*
