#!/bin/bash

# ==============================================================================
# generate-release
# ==============================================================================

DICVER="20171008"

cd ..
rm -rf ../mozcdic-ut2-$DICVER/

mkdir -p ../mozcdic-ut2-$DICVER/{alt-cannadic,chimei,edict,edict-katakana-english,ekimei,hatena,jinmei,neologd,niconico,skk-jisyo,src,wordnet-ejdic}
cp alt-cannadic/{*.hits,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/alt-cannadic/
cp chimei/{*.hits,*.rb,generate-chimei-hits.sh,reset-chimei-hits.sh} ../mozcdic-ut2-$DICVER/chimei/
cp -r docs/ ../mozcdic-ut2-$DICVER/
cp edict/{*.hits,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/edict/
cp edict-katakana-english/{kanaeng.costs,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/edict-katakana-english/
cp ekimei/{*.hits,*.rb,generate-ekimei-*.sh,reset-ekimei-hits.sh} ../mozcdic-ut2-$DICVER/ekimei/
cp hatena/{*.hits,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/hatena/
cp jinmei/{jinmei.txt,jinmei.hits.modhits,jinmei_specified.txt,*.rb,generate-dictionary.sh,add-newjinmei.sh} ../mozcdic-ut2-$DICVER/jinmei/
cp neologd/{*.hits,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/neologd/
cp niconico/{*.hits,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/niconico/
cp skk-jisyo/{*.hits,*.rb,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/skk-jisyo/
cp src/{filter-*.txt,*.rb,generate-release.sh,get-latest-mozc.sh,update-dictionary.sh} ../mozcdic-ut2-$DICVER/src/
cp wordnet-ejdic/wordnet-ejdic.costs ../mozcdic-ut2-$DICVER/wordnet-ejdic/
cp {AUTHORS,ChangeLog,COPYING,PKGBUILD,README.md,generate-dictionary.sh} ../mozcdic-ut2-$DICVER/

cd ..
rm -f mozcdic-ut2-$DICVER.tar.bz2
tar -jcf mozcdic-ut2-$DICVER.tar.bz2 mozcdic-ut2-$DICVER/
rm -rf mozcdic-ut2-$DICVER/
