/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.bean;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class AppSetting
implements Serializable {
    public static final String filepath = "ini";
    private static AppSetting setting;
    private boolean showLineNumberFlag;
    private boolean showToolBarFlag;
    private Vector openFileHistory = new Vector();
    private boolean wordWrapFlag;
    private Dimension framesize;
    private Font font;
    private Color backgroundColor;
    private Color foregroundColor;
    private String lookAndFeelClass;

    private AppSetting() {
    }

    public static AppSetting getInstance() {
        if (setting == null) {
            setting = new AppSetting();
        }
        return setting;
    }

    public void saveSetting() throws FileNotFoundException, IOException {
        File file = new File(filepath);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(this);
        out.flush();
        out.close();
    }

    public void loadSetting() throws FileNotFoundException, ClassNotFoundException, IOException {
        File file = new File(filepath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        AppSetting setting = (AppSetting)in.readObject();
        in.close();
        this.setOpenFileHistory(setting.getOpenFileHistory());
        this.setShowLineNumberFlag(setting.isShowLineNumberFlag());
        this.setShowToolBarFlag(setting.isShowToolBarFlag());
        this.setWordWrapFlag(setting.isWordWrapFlag());
        this.setFramesize(setting.getFramesize());
        this.setFont(setting.getFont());
        this.setForegroundColor(setting.getForegroundColor());
        this.setBackgroundColor(setting.getBackgroundColor());
        this.setLookAndFeelClass(setting.getLookAndFeelClass());
        Vector files = this.getOpenFileHistory();
        if (files.size() >= 10) {
            int rem = files.size() - 10;
            int i = 0;
            while (i < rem) {
                files.remove(0);
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public boolean isShowLineNumberFlag() {
        return this.showLineNumberFlag;
    }

    public void setShowLineNumberFlag(boolean showLineNumberFlag) {
        this.showLineNumberFlag = showLineNumberFlag;
    }

    public boolean isShowToolBarFlag() {
        return this.showToolBarFlag;
    }

    public void setShowToolBarFlag(boolean showToolBarFlag) {
        this.showToolBarFlag = showToolBarFlag;
    }

    public Vector getOpenFileHistory() {
        return this.openFileHistory;
    }

    private void setOpenFileHistory(Vector openFileHistory) {
        this.openFileHistory = openFileHistory;
        if (openFileHistory.size() == 11) {
            openFileHistory.remove(10);
        }
    }

    public void setOpenFileHistory(File openFile) {
        this.openFileHistory.add(openFile);
    }

    public boolean isWordWrapFlag() {
        return this.wordWrapFlag;
    }

    public void setWordWrapFlag(boolean wordWrapFlag) {
        this.wordWrapFlag = wordWrapFlag;
    }

    public Dimension getFramesize() {
        return this.framesize;
    }

    public void setFramesize(Dimension framesize) {
        this.framesize = framesize;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setForegroundColor(Color foreColor) {
        this.foregroundColor = foreColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setBackgroundColor(Color backColor) {
        this.backgroundColor = backColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getLookAndFeelClass() {
        return this.lookAndFeelClass;
    }

    public void setLookAndFeelClass(String lookAndFeelClass) {
        this.lookAndFeelClass = lookAndFeelClass;
    }
}

