/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.startup;

import java.util.Iterator;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.ProjectProperties;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.ResourceChange;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.ResourceChangeList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IStartup;

public class Startup
implements IStartup {
    public void earlyStartup() {
        IWorkspace workspace = PropertiesEditorPlugin.getWorkspace();
        ProjectProperties.getInstance().loadAllProperty(workspace);
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                ProjectProperties pp = ProjectProperties.getInstance();
                IResourceDelta delta = event.getDelta();
                ResourceChangeList rcs = this.getEventType(delta);
                if (rcs.size() == 0) {
                    return;
                }
                Iterator ite = rcs.iterator();
                while (ite.hasNext()) {
                    ResourceChange rc = (ResourceChange)ite.next();
                    switch (rc.getType()) {
                        case 3: {
                            pp.loadProjectProperties(rc.getProject());
                            break;
                        }
                        case 4: {
                            pp.deleteProjectProperties(rc.getProject());
                            break;
                        }
                        case 5: {
                            pp.loadProjectProperties(rc.getProject());
                            break;
                        }
                        case 6: {
                            pp.deleteProjectProperties(rc.getProject());
                            break;
                        }
                        case 2: {
                            pp.loadProjectProperties(rc.getProject());
                            break;
                        }
                        case 1: {
                            pp.deleteProjectProperties(rc.getProject());
                            break;
                        }
                        case 15: {
                            pp.loadProjectProperties(rc.getProject());
                        }
                    }
                }
            }

            private ResourceChangeList getEventType(IResourceDelta delta) {
                IFile file;
                String ext;
                IProject project;
                ResourceChangeList resourceChangeList = new ResourceChangeList();
                if (delta == null) {
                    return resourceChangeList;
                }
                int kind = delta.getKind();
                int flags = delta.getFlags();
                if (kind == 4 && (flags & 0x4000) != 0) {
                    project = (IProject)delta.getResource();
                    if (project.isOpen()) {
                        resourceChangeList.add(new ResourceChange(2, project));
                    } else {
                        resourceChangeList.add(new ResourceChange(1, project));
                    }
                } else if (delta.getResource() instanceof IProject) {
                    project = (IProject)delta.getResource();
                    if (kind == 1) {
                        resourceChangeList.add(new ResourceChange(3, project));
                    } else if (kind == 2) {
                        resourceChangeList.add(new ResourceChange(4, project));
                    } else if (kind == 8192) {
                        resourceChangeList.add(new ResourceChange(5, project));
                    } else if (kind == 4096) {
                        resourceChangeList.add(new ResourceChange(6, project));
                    }
                } else if (delta.getResource() instanceof IFile && (ext = (file = (IFile)delta.getResource()).getFileExtension()) != null && ext.equals("properties")) {
                    IJavaProject jProject = JavaCore.create((IProject)file.getProject());
                    IPath outputPath = null;
                    try {
                        outputPath = jProject.getOutputLocation();
                    }
                    catch (JavaModelException javaModelException) {}
                    if (outputPath == null || outputPath.matchingFirstSegments(file.getFullPath()) != outputPath.segmentCount()) {
                        resourceChangeList.add(new ResourceChange(15, delta.getResource().getProject()));
                    }
                }
                IResourceDelta[] deltas = delta.getAffectedChildren();
                int i = 0;
                while (i < deltas.length) {
                    ResourceChangeList rcs = this.getEventType(deltas[i]);
                    resourceChangeList.addAll(rcs);
                    ++i;
                }
                return resourceChangeList;
            }
        });
    }
}

