/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public class Room {

    public static void addFreak(Freak freak) {
        synchronized(Gate.class) {
            int newIndex;
            if (Gate.allFreaks!=null) {
                newIndex = -1;
                for (int i=0;i<Gate.allFreaks.length;i++) {
                    if (Gate.allFreaks[i]==null) {
                        newIndex = i;
                        break;
                    }
                }
                if (newIndex<0) {
                    newIndex = Gate.allFreaks.length;
                    Freak[] newFreaks = new Freak[Gate.allFreaks.length + 1];
                    System.arraycopy(Gate.allFreaks, 0, newFreaks, 0, Gate.allFreaks.length);
                    Gate.allFreaks = newFreaks;
                }
            } else {
                Gate.allFreaks = new Freak[1];
                newIndex = 0;
            }
            Gate.allFreaks[newIndex] = freak;

            int flags = freak.controlFlags();

            Gate.callBeforeEnabled = growArray(newIndex,Gate.callBeforeEnabled,((flags&Freak.CONTROL_CALL_BEFORE)!=0));
            Gate.callAfterEnabled = growArray(newIndex,Gate.callAfterEnabled,((flags&Freak.CONTROL_CALL_AFTER)!=0));
            Gate.callStaticBeforeEnabled = growArray(newIndex,Gate.callStaticBeforeEnabled,((flags&Freak.CONTROL_STATIC_CALL_BEFORE)!=0));
            Gate.callStaticAfterEnabled = growArray(newIndex,Gate.callStaticAfterEnabled,((flags&Freak.CONTROL_STATIC_CALL_AFTER)!=0));
            Gate.throwEnabled = growArray(newIndex,Gate.throwEnabled,((flags&Freak.CONTROL_THROW)!=0));
            Gate.catchEnabled = growArray(newIndex,Gate.catchEnabled,((flags&Freak.CONTROL_CATCH)!=0));

            Gate.callBeforeEnabledAny = anyEnabled(Gate.callBeforeEnabled);
            Gate.callAfterEnabledAny = anyEnabled(Gate.callAfterEnabled);
            Gate.callStaticBeforeEnabledAny = anyEnabled(Gate.callStaticBeforeEnabled);
            Gate.callStaticAfterEnabledAny = anyEnabled(Gate.callStaticAfterEnabled);
            Gate.throwEnabledAny = anyEnabled(Gate.throwEnabled);
            Gate.catchEnabledAny = anyEnabled(Gate.catchEnabled);
        }
    }

    public synchronized static void removeFreak(Freak freak) {
        synchronized(Gate.class) {
            if (Gate.allFreaks==null) return;
            for (int i=0;i<Gate.allFreaks.length;i++) {
                if (Gate.allFreaks[i]==freak) {
                    removeFreak(i);
                    break;
                }
            }
        }
    }

    private synchronized static void removeFreak(int index) {
        synchronized(Gate.class) {
            Gate.allFreaks[index] = null;
            Gate.callBeforeEnabled[index] = false;
            Gate.callAfterEnabled[index] = false;
            Gate.callStaticBeforeEnabled[index] = false;
            Gate.callStaticAfterEnabled[index] = false;
            Gate.throwEnabled[index] = false;
            Gate.catchEnabled[index] = false;
        }
    }

    public synchronized static void disableAllFreaks() {
        Gate.callBeforeEnabledAny = false;
        Gate.callAfterEnabledAny = false;
        Gate.callStaticBeforeEnabledAny = false;
        Gate.callStaticAfterEnabledAny = false;
        Gate.throwEnabledAny = false;
        Gate.catchEnabledAny = false;
    }

    private static boolean[] growArray(int index,boolean[] oldArray,boolean newValue) {
        boolean[] newArray;
        if (oldArray!=null) {
            if (index==oldArray.length) {
                newArray = new boolean[oldArray.length + 1];
                System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            } else {
                newArray = oldArray;
            }
        } else {
            newArray = new boolean[1];
        }
        newArray[index] = newValue;
        return newArray;
    }

    private static boolean anyEnabled(boolean[] array) {
        for (int i=0;i<array.length;i++) {
            if (array[i]==true) return true;
        }
        return false;
    }

    public static Class getCallerClass(int depth) {
        return callerContextInstance.callerClass(depth+4);
    }

    private static class CallerContext extends SecurityManager {
        public Class callerClass(int depth) {
            return getClassContext()[depth];
        }
    }

    private static CallerContext callerContextInstance = new CallerContext();

}
