/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public class Util {

    public static char unpackC(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return (char) (int) longs[index];
    }

    public static byte unpackB(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return (byte) (int) longs[index];
    }

    public static short unpackS(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return (short) (int) longs[index];
    }

    public static int unpackI(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return (int) longs[index];
    }

    public static long unpackJ(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return longs[index];
    }

    public static boolean unpackZ(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return (longs[index] != 0);
    }

    public static float unpackF(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return Float.intBitsToFloat((int) longs[index]);
    }

    public static double unpackD(Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        return Double.longBitsToDouble(longs[index]);
    }

    public static Object[] pack(char a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        return pile;
    }

    public static long[] pack(char a0, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        return pile;
    }

    public static Object[] pack(byte a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        return pile;
    }

    public static long[] pack(byte a0, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        return pile;
    }

    public static Object[] pack(short a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        return pile;
    }

    public static long[] pack(short a0, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        return pile;
    }

    public static Object[] pack(int a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        return pile;
    }

    public static long[] pack(int a0, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        return pile;
    }

    public static Object[] pack(long a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        return pile;
    }

    public static long[] pack(long a0, long[] pile, int index) {
        pile[index + 0] = a0;
        return pile;
    }

    public static Object[] pack(boolean a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        return pile;
    }

    public static long[] pack(float a0, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        return pile;
    }

    public static Object[] pack(double a0, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        return pile;
    }

    public static long[] pack(double a0, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        return pile;
    }

    public static Object[] pack(Object a0, Object[] pile, int index) {
        pile[index + 1] = a0;
        return pile;
    }

    public static Object[] pack(char a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(char a0, char a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(char a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(char a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(char a0, short a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(char a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(char a0, int a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(char a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(char a0, long a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(char a0, float a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(char a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(char a0, double a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(char a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(byte a0, char a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(byte a0, short a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(byte a0, int a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(byte a0, long a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(byte a0, float a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(byte a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(byte a0, double a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(short a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(short a0, char a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(short a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(short a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(short a0, short a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(short a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(short a0, int a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(short a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(short a0, long a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(short a0, float a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(short a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(short a0, double a1, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(short a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(int a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(int a0, char a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(int a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(int a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(int a0, short a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(int a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(int a0, int a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(int a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(int a0, long a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(int a0, float a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(int a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(int a0, double a1, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(int a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(long a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(long a0, char a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(long a0, byte a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(long a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(long a0, short a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(long a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(long a0, int a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(long a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(long a0, long a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(long a0, float a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(long a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(long a0, double a1, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(long a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(boolean a0, float a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(boolean a0, double a1, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(float a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(float a0, char a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(float a0, byte a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(float a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(float a0, short a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(float a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(float a0, int a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(float a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(float a0, long a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(float a0, float a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(float a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(float a0, double a1, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(float a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(double a0, char a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(double a0, char a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(double a0, byte a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(double a0, short a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        return pile;
    }

    public static long[] pack(double a0, short a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(double a0, int a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        return pile;
    }

    public static long[] pack(double a0, int a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        return pile;
    }

    public static Object[] pack(double a0, long a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        return pile;
    }

    public static long[] pack(double a0, long a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, boolean a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, float a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static long[] pack(double a0, float a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(double a0, double a1, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static long[] pack(double a0, double a1, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(double a0, Object a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, float a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        return pile;
    }

    public static Object[] pack(Object a0, double a1, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, Object[] pile, int index) {
        pile[index + 1] = a0;
        pile[index + 2] = a1;
        return pile;
    }

    public static Object[] pack(char a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(char a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(char a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(char a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(char a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(char a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(char a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(char a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(char a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(char a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(char a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(byte a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(byte a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(byte a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(byte a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(byte a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(byte a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(short a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(short a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(short a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(short a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(short a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(short a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) (int) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(short a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) (int) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(short a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(short a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(short a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) (int) a0;
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(int a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(int a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(int a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(int a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(int a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(int a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(int a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(int a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(int a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(int a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) a0;
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(long a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(long a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(long a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(long a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(long a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(long a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = a0;
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(long a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = a0;
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(long a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(long a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(long a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = a0;
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(boolean a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(boolean a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(boolean a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(boolean a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (a0 ? 1 : 0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(boolean a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (a0 ? 1 : 0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(boolean a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (a0 ? 1 : 0);
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(float a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(float a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(float a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(float a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(float a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(float a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(float a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(float a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(float a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(float a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a0);
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, char a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, char a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, char a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, char a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, char a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, char a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, char a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, char a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, char a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, char a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, char a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, byte a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, byte a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, byte a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, byte a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, byte a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, byte a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, byte a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, byte a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, byte a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, byte a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, byte a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, short a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, short a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, short a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, short a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, short a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, short a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, short a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, short a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, short a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, short a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) (int) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, short a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) (int) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (long) (int) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, int a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, int a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, int a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, int a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, int a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, int a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, int a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, int a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, int a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, int a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, int a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (long) a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, long a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, long a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, long a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, long a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, long a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, long a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, long a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, long a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, long a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, long a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = a1;
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, long a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = a1;
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = a1;
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, boolean a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, boolean a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, boolean a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, boolean a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, boolean a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, boolean a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, boolean a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (a1 ? 1 : 0);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, boolean a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (a1 ? 1 : 0);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (a1 ? 1 : 0);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, float a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, float a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, float a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, float a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, float a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, float a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, float a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, float a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, float a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, float a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = (long) Float.floatToRawIntBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, float a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, char a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, double a1, char a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, byte a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, double a1, byte a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, short a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) (int) a2;
        return pile;
    }

    public static long[] pack(double a0, double a1, short a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, int a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) a2;
        return pile;
    }

    public static long[] pack(double a0, double a1, int a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, long a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = a2;
        return pile;
    }

    public static long[] pack(double a0, double a1, long a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = a2;
        return pile;
    }

    public static Object[] pack(double a0, double a1, boolean a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static long[] pack(double a0, double a1, boolean a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, double a1, float a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static long[] pack(double a0, double a1, float a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, double a1, double a2, Object[] pile, int index) {
        long[] longs = (long[]) pile[0];
        longs[index + 0] = Double.doubleToRawLongBits(a0);
        longs[index + 1] = Double.doubleToRawLongBits(a1);
        longs[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static long[] pack(double a0, double a1, double a2, long[] pile, int index) {
        pile[index + 0] = Double.doubleToRawLongBits(a0);
        pile[index + 1] = Double.doubleToRawLongBits(a1);
        pile[index + 2] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        longs[index1 + 1] = Double.doubleToRawLongBits(a1);
        pile[index0 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(double a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(double a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(double a0, Object a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        longs[index1 + 0] = Double.doubleToRawLongBits(a0);
        pile[index0 + 1] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, char a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, char a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, char a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, char a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, byte a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, short a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, short a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, short a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, short a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) (int) a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, int a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, int a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, int a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, int a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, long a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, long a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, long a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, long a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = a1;
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, boolean a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (a1 ? 1 : 0);
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, float a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, float a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, float a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, float a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a1);
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, double a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, double a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, double a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        longs[index1 + 1] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, double a1, Object a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        longs[index1 + 0] = Double.doubleToRawLongBits(a1);
        pile[index0 + 2] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, char a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, byte a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, short a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (long) (int) a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, int a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (long) a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, long a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = a2;
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, boolean a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (a2 ? 1 : 0);
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, float a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = (long) Float.floatToRawIntBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, double a2, Object[] pile, int index0, int index1) {
        long[] longs = (long[]) pile[0];
        pile[index0 + 1] = a0;
        pile[index0 + 2] = a1;
        longs[index1 + 0] = Double.doubleToRawLongBits(a2);
        return pile;
    }

    public static Object[] pack(Object a0, Object a1, Object a2, Object[] pile, int index) {
        pile[index + 1] = a0;
        pile[index + 2] = a1;
        pile[index + 3] = a2;
        return pile;
    }
}
