/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package glue.java.lang;

import blues.Jail;
import blues.Log;
import impl.java.net.URLPeer;

public class Package {
    public static boolean isSealed(Object obj, jail.java.net.URL url) {
        java.net.URL nurl = URLPeer.fromJail(url);
        return ((java.lang.Package) obj).isSealed(nurl);
    }

    public static String getName(Object obj) {
        String name = ((java.lang.Package)obj).getName();
        return Jail.packageNameRemoveJail(name);
    }

    public static java.lang.Package getPackage(Object obj,String name) {
        Log.unimplemented();
        String jname = Jail.packageNameAddJail(name);
        java.lang.Package p = java.lang.Package.getPackage(jname);
        return p;
    }

    public static java.lang.Package[] getPackages() {
        Log.unimplemented();
        java.lang.Package[] pkgs = java.lang.Package.getPackages();
        return pkgs;
    }

    public static boolean isCompatibleWith(Object obj,String name) {
        Log.unimplemented();
        java.lang.Package p = (java.lang.Package)obj;
        return p.isCompatibleWith(name);
    }

}
