/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.awt;

import jail.java.awt.Component;
import jail.java.awt.EventQueue;
import jail.java.awt.GraphicsDevice;
import jail.java.awt.Toolkit;
import jail.java.awt.Window;

public abstract class AwtAccess {

    public abstract void hide(Component component);
    public abstract Window getWindow(GraphicsDevice graphicsDevice);
    public abstract Thread getDispatchThread(EventQueue eq);
    public abstract void stopDispatching(Thread dispatchThread);

    private static AwtAccess instance = null;

    public static synchronized void setAccess(AwtAccess access) {
        instance = access;
    }

    public static synchronized AwtAccess getAccess() {
        if (instance==null) {
            Toolkit.getDefaultToolkit();
        }
        return instance;
    }


}
