/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.io.IOException;
import java.util.zip.ZipFile;

public class JarRootDir extends JarDir {

    public JarRootDir(String path, String nativePath) {
        setPath(path, nativePath);
    }

    @Override
    protected void populateAttributes() {
        BluesFile zipBluesFile = new BluesFile(nativePath, nativePath);
        String localPath = BluesFileSystem.getLocalPath(zipBluesFile,nativePath);

        try {
            zipFile = new ZipFile(localPath);
        } catch (IOException e) {
            throw new RuntimeException("Jar file invalid - " + path, e);
        }
        zipBluesFile.lastReferenceClosed();

        if (zipFile.size() == 0) {
            lastModifiedTime = glue.java.lang.System.currentTimeMillis();
        } else {
            lastModifiedTime = zipFile.entries().nextElement().getTime();
        }
        accessFlags = ACCESS_READ;
    }

    @Override
    protected String getRelativePath() {
        return "";
    }

    @Override
    public void closeThis() {
        if (zipFile!=null) {
            try {
                zipFile.close();
            } catch (IOException e) {
            }
            zipFile = null;
        }
    }

}
