/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

public class LocalDir extends FsDir {

    public LocalDir(String apath) {
        setPath(apath, null);
    }

    public LocalDir(LocalDir parent, String name) {
        setPath(parent, name, null);
    }

    @Override
    protected void populateEntries() {
    }

    @Override
    protected void populateAttributes() {
        accessFlags = ACCESS_READ | ACCESS_WRITE;
        lastModifiedTime = glue.java.lang.System.currentTimeMillis();
    }

    @Override
    protected boolean deleteObject(FsObject obj) {
        if (obj instanceof FsFile) {
            return true;
        }
        if (obj instanceof FsDir) {
            if (((FsDir) obj).entries.isEmpty() == true) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected FsDir createDirectoryObject(String name) {
        LocalDir dir = new LocalDir(this, name);
        dir.callPopulateAttributes();
        return dir;
    }

    @Override
    protected FsFile createFileObject(String name) {
        LocalFile f = new LocalFile(this, name);
        f.callPopulateAttributes();
        return f;
    }

    @Override
    public void closeThis() {
    }
}
