/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.lang;

import java.security.AccessController;
import java.security.PrivilegedAction;

import blues.AccessibleClassLoader;
import blues.Container;
import blues.Jail;

public class ClassLoaderPeer extends blues.AccessibleClassLoader {
    private jail.java.lang.ClassLoader peer;
    public static ClassLoaderAccess access = null;

    public ClassLoaderPeer(jail.java.lang.ClassLoader peer) {
        this.peer = peer;
    }

    public ClassLoaderPeer(jail.java.lang.ClassLoader peer, java.lang.ClassLoader parent) {
        super(parent);
        this.peer = peer;
    }

    public static synchronized void setClassLoaderAccess(ClassLoaderAccess a) {
        if (access == null) {
            access = a;
        }
    }

    // called by VM
    public Class loadClass(String name) throws ClassNotFoundException {
        if (Jail.classNameIsJail(name)==false) {
            // this class can't come from jailed code,
            // and name can't be marshaled
            AccessibleClassLoader root = Container.my().getClassLoader();
            return root.loadClass(name);
        }
        return peer.loadClass(Jail.classNameRemoveJail(name));
    }

    public static java.lang.ClassLoader fromJail(jail.java.lang.ClassLoader j) {
        return access.getPeer(j);
    }

    public static jail.java.lang.ClassLoader toJail(java.lang.ClassLoader n) {
        if (n instanceof ClassLoaderPeer) {
            return ((ClassLoaderPeer) n).peer;
        }
        return access.getSystemClassLoader0();
    }

    public static java.lang.ClassLoader getClassLoader(final Class caller) {
        if (caller == null) {
            return null;
        }
        java.lang.ClassLoader cl = (java.lang.ClassLoader)AccessController.doPrivileged(new PrivilegedAction() {
            @Override
            public Object run() {
                return caller.getClassLoader();
            }
        });
        return cl;
    }

}
