/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2023 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.lang;

import java.util.HashMap;

public class PeerManager<N, J> {
    HashMap<N, J> map = new HashMap();
    PeerAccess<N, J> access = null;

    public synchronized void setPeerAccess(PeerAccess<N, J> a) {
        access = a;
    }

    public synchronized void add(N n, J j) {
        map.put(n, j);
    }

    public synchronized J toJail(N obj) {
        if (null == obj)
            return null;
        return toJailAllowNull(obj);
    }

    public synchronized J toJailAllowNull(N obj) {
        J r = map.get(obj);
        if (r == null) {
            r = createJailed(obj);
            map.put(obj, r);
        }
        return r;
    }

    protected J createJailed(N peer) {
        return access.construct(peer);
    }

    public synchronized N fromJail(J obj) {
        if (null == obj)
            return null;
        return access.getPeer(obj);
    }
}
